/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/types/types.ts":
/*!****************************!*\
  !*** ./src/types/types.ts ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   defaultOptions: () => (/* binding */ defaultOptions)
/* harmony export */ });
// 默认选项
const defaultOptions = {
    theme: 'light',
    notifications: true,
    debugMode: false
};


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!******************************!*\
  !*** ./src/options/index.ts ***!
  \******************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _types_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../types/types */ "./src/types/types.ts");

// DOM元素
const themeToggle = document.getElementById('theme-toggle');
const notificationsToggle = document.getElementById('notifications-toggle');
const debugModeToggle = document.getElementById('debug-mode');
const saveButton = document.getElementById('save-button');
const resetButton = document.getElementById('reset-button');
const saveStatus = document.getElementById('save-status');
// 当前选项
let currentOptions = Object.assign({}, _types_types__WEBPACK_IMPORTED_MODULE_0__.defaultOptions);
// 初始化选项页面
function initOptionsPage() {
    // 从存储中加载选项
    loadOptions();
    // 为保存按钮添加事件监听器
    saveButton.addEventListener('click', saveOptions);
    // 为重置按钮添加事件监听器
    resetButton.addEventListener('click', resetOptions);
    // 添加主题改变监听
    themeToggle.addEventListener('change', () => {
        toggleTheme(themeToggle.checked);
    });
}
// 从存储中加载选项
function loadOptions() {
    chrome.storage.sync.get('options', (result) => {
        // 如果存储中有选项，则使用它们
        if (result.options) {
            currentOptions = Object.assign(Object.assign({}, _types_types__WEBPACK_IMPORTED_MODULE_0__.defaultOptions), result.options);
        }
        // 更新UI以反映当前选项
        updateUI();
    });
}
// 更新UI以反映当前选项
function updateUI() {
    // 更新选择框状态
    themeToggle.checked = currentOptions.theme === 'dark';
    notificationsToggle.checked = currentOptions.notifications;
    debugModeToggle.checked = !!currentOptions.debugMode;
    // 应用主题
    toggleTheme(themeToggle.checked);
}
// 切换主题
function toggleTheme(isDark) {
    if (isDark) {
        document.body.classList.add('theme-dark');
    }
    else {
        document.body.classList.remove('theme-dark');
    }
}
// 保存选项
function saveOptions() {
    // 获取UI中的当前值
    const theme = themeToggle.checked ? 'dark' : 'light';
    const notifications = notificationsToggle.checked;
    const debugMode = debugModeToggle.checked;
    // 更新当前选项
    currentOptions = {
        theme,
        notifications,
        debugMode
    };
    // 保存到存储
    chrome.storage.sync.set({ options: currentOptions }, () => {
        // 显示保存状态
        showSaveStatus();
        if (debugMode) {
            console.log('选项已保存:', currentOptions);
        }
    });
}
// 重置选项为默认值
function resetOptions() {
    // 重置为默认选项
    currentOptions = Object.assign({}, _types_types__WEBPACK_IMPORTED_MODULE_0__.defaultOptions);
    // 更新UI
    updateUI();
    // 保存到存储
    chrome.storage.sync.set({ options: currentOptions }, () => {
        // 显示保存状态
        showSaveStatus();
    });
}
// 显示保存状态
function showSaveStatus() {
    saveStatus.classList.add('show');
    // 3秒后隐藏状态消息
    setTimeout(() => {
        saveStatus.classList.remove('show');
    }, 3000);
}
// 当DOM加载完成时初始化选项页面
document.addEventListener('DOMContentLoaded', initOptionsPage);

})();

/******/ })()
;
//# sourceMappingURL=index.js.map