/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./src/hot-reload.js":
/*!***************************!*\
  !*** ./src/hot-reload.js ***!
  \***************************/
/***/ ((module) => {

// 热重载脚本 - 监视文件变化并自动重新加载Chrome扩展
const filesInDirectory = dir => new Promise(resolve =>
  chrome.runtime.getPackageDirectoryEntry(entry =>
    entry.createReader().readEntries(entries =>
      Promise.all(entries.filter(e => e.isFile).map(e =>
        new Promise(resolve => e.file(resolve))
      ))
      .then(files => resolve(files))
    )
  )
);

const timestampForFilesInDirectory = dir =>
  filesInDirectory(dir).then(files =>
    files.map(f => f.name + f.lastModifiedDate).join()
  );

const reload = () => {
  chrome.runtime.reload();
  window.close();
};

const watchChanges = (dir, lastTimestamp) => {
  timestampForFilesInDirectory(dir).then(timestamp => {
    if (!lastTimestamp || (lastTimestamp === timestamp)) {
      setTimeout(() => watchChanges(dir, timestamp), 1000); // 每秒检查一次
    } else {
      reload();
    }
  });
};

// 只在开发模式下启用热重载
if (false) {}

// 导出空对象，以便TypeScript导入
module.exports = {};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./src/hot-reload.js");
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map