/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@vue/reactivity/dist/reactivity.esm-bundler.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@vue/reactivity/dist/reactivity.esm-bundler.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ARRAY_ITERATE_KEY: () => (/* binding */ ARRAY_ITERATE_KEY),
/* harmony export */   EffectFlags: () => (/* binding */ EffectFlags),
/* harmony export */   EffectScope: () => (/* binding */ EffectScope),
/* harmony export */   ITERATE_KEY: () => (/* binding */ ITERATE_KEY),
/* harmony export */   MAP_KEY_ITERATE_KEY: () => (/* binding */ MAP_KEY_ITERATE_KEY),
/* harmony export */   ReactiveEffect: () => (/* binding */ ReactiveEffect),
/* harmony export */   ReactiveFlags: () => (/* binding */ ReactiveFlags),
/* harmony export */   TrackOpTypes: () => (/* binding */ TrackOpTypes),
/* harmony export */   TriggerOpTypes: () => (/* binding */ TriggerOpTypes),
/* harmony export */   WatchErrorCodes: () => (/* binding */ WatchErrorCodes),
/* harmony export */   computed: () => (/* binding */ computed),
/* harmony export */   customRef: () => (/* binding */ customRef),
/* harmony export */   effect: () => (/* binding */ effect),
/* harmony export */   effectScope: () => (/* binding */ effectScope),
/* harmony export */   enableTracking: () => (/* binding */ enableTracking),
/* harmony export */   getCurrentScope: () => (/* binding */ getCurrentScope),
/* harmony export */   getCurrentWatcher: () => (/* binding */ getCurrentWatcher),
/* harmony export */   isProxy: () => (/* binding */ isProxy),
/* harmony export */   isReactive: () => (/* binding */ isReactive),
/* harmony export */   isReadonly: () => (/* binding */ isReadonly),
/* harmony export */   isRef: () => (/* binding */ isRef),
/* harmony export */   isShallow: () => (/* binding */ isShallow),
/* harmony export */   markRaw: () => (/* binding */ markRaw),
/* harmony export */   onEffectCleanup: () => (/* binding */ onEffectCleanup),
/* harmony export */   onScopeDispose: () => (/* binding */ onScopeDispose),
/* harmony export */   onWatcherCleanup: () => (/* binding */ onWatcherCleanup),
/* harmony export */   pauseTracking: () => (/* binding */ pauseTracking),
/* harmony export */   proxyRefs: () => (/* binding */ proxyRefs),
/* harmony export */   reactive: () => (/* binding */ reactive),
/* harmony export */   reactiveReadArray: () => (/* binding */ reactiveReadArray),
/* harmony export */   readonly: () => (/* binding */ readonly),
/* harmony export */   ref: () => (/* binding */ ref),
/* harmony export */   resetTracking: () => (/* binding */ resetTracking),
/* harmony export */   shallowReactive: () => (/* binding */ shallowReactive),
/* harmony export */   shallowReadArray: () => (/* binding */ shallowReadArray),
/* harmony export */   shallowReadonly: () => (/* binding */ shallowReadonly),
/* harmony export */   shallowRef: () => (/* binding */ shallowRef),
/* harmony export */   stop: () => (/* binding */ stop),
/* harmony export */   toRaw: () => (/* binding */ toRaw),
/* harmony export */   toReactive: () => (/* binding */ toReactive),
/* harmony export */   toReadonly: () => (/* binding */ toReadonly),
/* harmony export */   toRef: () => (/* binding */ toRef),
/* harmony export */   toRefs: () => (/* binding */ toRefs),
/* harmony export */   toValue: () => (/* binding */ toValue),
/* harmony export */   track: () => (/* binding */ track),
/* harmony export */   traverse: () => (/* binding */ traverse),
/* harmony export */   trigger: () => (/* binding */ trigger),
/* harmony export */   triggerRef: () => (/* binding */ triggerRef),
/* harmony export */   unref: () => (/* binding */ unref),
/* harmony export */   watch: () => (/* binding */ watch)
/* harmony export */ });
/* harmony import */ var _vue_shared__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @vue/shared */ "./node_modules/@vue/shared/dist/shared.esm-bundler.js");
/**
* @vue/reactivity v3.5.16
* (c) 2018-present Yuxi (Evan) You and Vue contributors
* @license MIT
**/


function warn(msg, ...args) {
  console.warn(`[Vue warn] ${msg}`, ...args);
}

let activeEffectScope;
class EffectScope {
  constructor(detached = false) {
    this.detached = detached;
    /**
     * @internal
     */
    this._active = true;
    /**
     * @internal track `on` calls, allow `on` call multiple times
     */
    this._on = 0;
    /**
     * @internal
     */
    this.effects = [];
    /**
     * @internal
     */
    this.cleanups = [];
    this._isPaused = false;
    this.parent = activeEffectScope;
    if (!detached && activeEffectScope) {
      this.index = (activeEffectScope.scopes || (activeEffectScope.scopes = [])).push(
        this
      ) - 1;
    }
  }
  get active() {
    return this._active;
  }
  pause() {
    if (this._active) {
      this._isPaused = true;
      let i, l;
      if (this.scopes) {
        for (i = 0, l = this.scopes.length; i < l; i++) {
          this.scopes[i].pause();
        }
      }
      for (i = 0, l = this.effects.length; i < l; i++) {
        this.effects[i].pause();
      }
    }
  }
  /**
   * Resumes the effect scope, including all child scopes and effects.
   */
  resume() {
    if (this._active) {
      if (this._isPaused) {
        this._isPaused = false;
        let i, l;
        if (this.scopes) {
          for (i = 0, l = this.scopes.length; i < l; i++) {
            this.scopes[i].resume();
          }
        }
        for (i = 0, l = this.effects.length; i < l; i++) {
          this.effects[i].resume();
        }
      }
    }
  }
  run(fn) {
    if (this._active) {
      const currentEffectScope = activeEffectScope;
      try {
        activeEffectScope = this;
        return fn();
      } finally {
        activeEffectScope = currentEffectScope;
      }
    } else if (true) {
      warn(`cannot run an inactive effect scope.`);
    }
  }
  /**
   * This should only be called on non-detached scopes
   * @internal
   */
  on() {
    if (++this._on === 1) {
      this.prevScope = activeEffectScope;
      activeEffectScope = this;
    }
  }
  /**
   * This should only be called on non-detached scopes
   * @internal
   */
  off() {
    if (this._on > 0 && --this._on === 0) {
      activeEffectScope = this.prevScope;
      this.prevScope = void 0;
    }
  }
  stop(fromParent) {
    if (this._active) {
      this._active = false;
      let i, l;
      for (i = 0, l = this.effects.length; i < l; i++) {
        this.effects[i].stop();
      }
      this.effects.length = 0;
      for (i = 0, l = this.cleanups.length; i < l; i++) {
        this.cleanups[i]();
      }
      this.cleanups.length = 0;
      if (this.scopes) {
        for (i = 0, l = this.scopes.length; i < l; i++) {
          this.scopes[i].stop(true);
        }
        this.scopes.length = 0;
      }
      if (!this.detached && this.parent && !fromParent) {
        const last = this.parent.scopes.pop();
        if (last && last !== this) {
          this.parent.scopes[this.index] = last;
          last.index = this.index;
        }
      }
      this.parent = void 0;
    }
  }
}
function effectScope(detached) {
  return new EffectScope(detached);
}
function getCurrentScope() {
  return activeEffectScope;
}
function onScopeDispose(fn, failSilently = false) {
  if (activeEffectScope) {
    activeEffectScope.cleanups.push(fn);
  } else if ( true && !failSilently) {
    warn(
      `onScopeDispose() is called when there is no active effect scope to be associated with.`
    );
  }
}

let activeSub;
const EffectFlags = {
  "ACTIVE": 1,
  "1": "ACTIVE",
  "RUNNING": 2,
  "2": "RUNNING",
  "TRACKING": 4,
  "4": "TRACKING",
  "NOTIFIED": 8,
  "8": "NOTIFIED",
  "DIRTY": 16,
  "16": "DIRTY",
  "ALLOW_RECURSE": 32,
  "32": "ALLOW_RECURSE",
  "PAUSED": 64,
  "64": "PAUSED",
  "EVALUATED": 128,
  "128": "EVALUATED"
};
const pausedQueueEffects = /* @__PURE__ */ new WeakSet();
class ReactiveEffect {
  constructor(fn) {
    this.fn = fn;
    /**
     * @internal
     */
    this.deps = void 0;
    /**
     * @internal
     */
    this.depsTail = void 0;
    /**
     * @internal
     */
    this.flags = 1 | 4;
    /**
     * @internal
     */
    this.next = void 0;
    /**
     * @internal
     */
    this.cleanup = void 0;
    this.scheduler = void 0;
    if (activeEffectScope && activeEffectScope.active) {
      activeEffectScope.effects.push(this);
    }
  }
  pause() {
    this.flags |= 64;
  }
  resume() {
    if (this.flags & 64) {
      this.flags &= -65;
      if (pausedQueueEffects.has(this)) {
        pausedQueueEffects.delete(this);
        this.trigger();
      }
    }
  }
  /**
   * @internal
   */
  notify() {
    if (this.flags & 2 && !(this.flags & 32)) {
      return;
    }
    if (!(this.flags & 8)) {
      batch(this);
    }
  }
  run() {
    if (!(this.flags & 1)) {
      return this.fn();
    }
    this.flags |= 2;
    cleanupEffect(this);
    prepareDeps(this);
    const prevEffect = activeSub;
    const prevShouldTrack = shouldTrack;
    activeSub = this;
    shouldTrack = true;
    try {
      return this.fn();
    } finally {
      if ( true && activeSub !== this) {
        warn(
          "Active effect was not restored correctly - this is likely a Vue internal bug."
        );
      }
      cleanupDeps(this);
      activeSub = prevEffect;
      shouldTrack = prevShouldTrack;
      this.flags &= -3;
    }
  }
  stop() {
    if (this.flags & 1) {
      for (let link = this.deps; link; link = link.nextDep) {
        removeSub(link);
      }
      this.deps = this.depsTail = void 0;
      cleanupEffect(this);
      this.onStop && this.onStop();
      this.flags &= -2;
    }
  }
  trigger() {
    if (this.flags & 64) {
      pausedQueueEffects.add(this);
    } else if (this.scheduler) {
      this.scheduler();
    } else {
      this.runIfDirty();
    }
  }
  /**
   * @internal
   */
  runIfDirty() {
    if (isDirty(this)) {
      this.run();
    }
  }
  get dirty() {
    return isDirty(this);
  }
}
let batchDepth = 0;
let batchedSub;
let batchedComputed;
function batch(sub, isComputed = false) {
  sub.flags |= 8;
  if (isComputed) {
    sub.next = batchedComputed;
    batchedComputed = sub;
    return;
  }
  sub.next = batchedSub;
  batchedSub = sub;
}
function startBatch() {
  batchDepth++;
}
function endBatch() {
  if (--batchDepth > 0) {
    return;
  }
  if (batchedComputed) {
    let e = batchedComputed;
    batchedComputed = void 0;
    while (e) {
      const next = e.next;
      e.next = void 0;
      e.flags &= -9;
      e = next;
    }
  }
  let error;
  while (batchedSub) {
    let e = batchedSub;
    batchedSub = void 0;
    while (e) {
      const next = e.next;
      e.next = void 0;
      e.flags &= -9;
      if (e.flags & 1) {
        try {
          ;
          e.trigger();
        } catch (err) {
          if (!error) error = err;
        }
      }
      e = next;
    }
  }
  if (error) throw error;
}
function prepareDeps(sub) {
  for (let link = sub.deps; link; link = link.nextDep) {
    link.version = -1;
    link.prevActiveLink = link.dep.activeLink;
    link.dep.activeLink = link;
  }
}
function cleanupDeps(sub) {
  let head;
  let tail = sub.depsTail;
  let link = tail;
  while (link) {
    const prev = link.prevDep;
    if (link.version === -1) {
      if (link === tail) tail = prev;
      removeSub(link);
      removeDep(link);
    } else {
      head = link;
    }
    link.dep.activeLink = link.prevActiveLink;
    link.prevActiveLink = void 0;
    link = prev;
  }
  sub.deps = head;
  sub.depsTail = tail;
}
function isDirty(sub) {
  for (let link = sub.deps; link; link = link.nextDep) {
    if (link.dep.version !== link.version || link.dep.computed && (refreshComputed(link.dep.computed) || link.dep.version !== link.version)) {
      return true;
    }
  }
  if (sub._dirty) {
    return true;
  }
  return false;
}
function refreshComputed(computed) {
  if (computed.flags & 4 && !(computed.flags & 16)) {
    return;
  }
  computed.flags &= -17;
  if (computed.globalVersion === globalVersion) {
    return;
  }
  computed.globalVersion = globalVersion;
  if (!computed.isSSR && computed.flags & 128 && (!computed.deps && !computed._dirty || !isDirty(computed))) {
    return;
  }
  computed.flags |= 2;
  const dep = computed.dep;
  const prevSub = activeSub;
  const prevShouldTrack = shouldTrack;
  activeSub = computed;
  shouldTrack = true;
  try {
    prepareDeps(computed);
    const value = computed.fn(computed._value);
    if (dep.version === 0 || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasChanged)(value, computed._value)) {
      computed.flags |= 128;
      computed._value = value;
      dep.version++;
    }
  } catch (err) {
    dep.version++;
    throw err;
  } finally {
    activeSub = prevSub;
    shouldTrack = prevShouldTrack;
    cleanupDeps(computed);
    computed.flags &= -3;
  }
}
function removeSub(link, soft = false) {
  const { dep, prevSub, nextSub } = link;
  if (prevSub) {
    prevSub.nextSub = nextSub;
    link.prevSub = void 0;
  }
  if (nextSub) {
    nextSub.prevSub = prevSub;
    link.nextSub = void 0;
  }
  if ( true && dep.subsHead === link) {
    dep.subsHead = nextSub;
  }
  if (dep.subs === link) {
    dep.subs = prevSub;
    if (!prevSub && dep.computed) {
      dep.computed.flags &= -5;
      for (let l = dep.computed.deps; l; l = l.nextDep) {
        removeSub(l, true);
      }
    }
  }
  if (!soft && !--dep.sc && dep.map) {
    dep.map.delete(dep.key);
  }
}
function removeDep(link) {
  const { prevDep, nextDep } = link;
  if (prevDep) {
    prevDep.nextDep = nextDep;
    link.prevDep = void 0;
  }
  if (nextDep) {
    nextDep.prevDep = prevDep;
    link.nextDep = void 0;
  }
}
function effect(fn, options) {
  if (fn.effect instanceof ReactiveEffect) {
    fn = fn.effect.fn;
  }
  const e = new ReactiveEffect(fn);
  if (options) {
    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.extend)(e, options);
  }
  try {
    e.run();
  } catch (err) {
    e.stop();
    throw err;
  }
  const runner = e.run.bind(e);
  runner.effect = e;
  return runner;
}
function stop(runner) {
  runner.effect.stop();
}
let shouldTrack = true;
const trackStack = [];
function pauseTracking() {
  trackStack.push(shouldTrack);
  shouldTrack = false;
}
function enableTracking() {
  trackStack.push(shouldTrack);
  shouldTrack = true;
}
function resetTracking() {
  const last = trackStack.pop();
  shouldTrack = last === void 0 ? true : last;
}
function onEffectCleanup(fn, failSilently = false) {
  if (activeSub instanceof ReactiveEffect) {
    activeSub.cleanup = fn;
  } else if ( true && !failSilently) {
    warn(
      `onEffectCleanup() was called when there was no active effect to associate with.`
    );
  }
}
function cleanupEffect(e) {
  const { cleanup } = e;
  e.cleanup = void 0;
  if (cleanup) {
    const prevSub = activeSub;
    activeSub = void 0;
    try {
      cleanup();
    } finally {
      activeSub = prevSub;
    }
  }
}

let globalVersion = 0;
class Link {
  constructor(sub, dep) {
    this.sub = sub;
    this.dep = dep;
    this.version = dep.version;
    this.nextDep = this.prevDep = this.nextSub = this.prevSub = this.prevActiveLink = void 0;
  }
}
class Dep {
  constructor(computed) {
    this.computed = computed;
    this.version = 0;
    /**
     * Link between this dep and the current active effect
     */
    this.activeLink = void 0;
    /**
     * Doubly linked list representing the subscribing effects (tail)
     */
    this.subs = void 0;
    /**
     * For object property deps cleanup
     */
    this.map = void 0;
    this.key = void 0;
    /**
     * Subscriber counter
     */
    this.sc = 0;
    if (true) {
      this.subsHead = void 0;
    }
  }
  track(debugInfo) {
    if (!activeSub || !shouldTrack || activeSub === this.computed) {
      return;
    }
    let link = this.activeLink;
    if (link === void 0 || link.sub !== activeSub) {
      link = this.activeLink = new Link(activeSub, this);
      if (!activeSub.deps) {
        activeSub.deps = activeSub.depsTail = link;
      } else {
        link.prevDep = activeSub.depsTail;
        activeSub.depsTail.nextDep = link;
        activeSub.depsTail = link;
      }
      addSub(link);
    } else if (link.version === -1) {
      link.version = this.version;
      if (link.nextDep) {
        const next = link.nextDep;
        next.prevDep = link.prevDep;
        if (link.prevDep) {
          link.prevDep.nextDep = next;
        }
        link.prevDep = activeSub.depsTail;
        link.nextDep = void 0;
        activeSub.depsTail.nextDep = link;
        activeSub.depsTail = link;
        if (activeSub.deps === link) {
          activeSub.deps = next;
        }
      }
    }
    if ( true && activeSub.onTrack) {
      activeSub.onTrack(
        (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.extend)(
          {
            effect: activeSub
          },
          debugInfo
        )
      );
    }
    return link;
  }
  trigger(debugInfo) {
    this.version++;
    globalVersion++;
    this.notify(debugInfo);
  }
  notify(debugInfo) {
    startBatch();
    try {
      if (true) {
        for (let head = this.subsHead; head; head = head.nextSub) {
          if (head.sub.onTrigger && !(head.sub.flags & 8)) {
            head.sub.onTrigger(
              (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.extend)(
                {
                  effect: head.sub
                },
                debugInfo
              )
            );
          }
        }
      }
      for (let link = this.subs; link; link = link.prevSub) {
        if (link.sub.notify()) {
          ;
          link.sub.dep.notify();
        }
      }
    } finally {
      endBatch();
    }
  }
}
function addSub(link) {
  link.dep.sc++;
  if (link.sub.flags & 4) {
    const computed = link.dep.computed;
    if (computed && !link.dep.subs) {
      computed.flags |= 4 | 16;
      for (let l = computed.deps; l; l = l.nextDep) {
        addSub(l);
      }
    }
    const currentTail = link.dep.subs;
    if (currentTail !== link) {
      link.prevSub = currentTail;
      if (currentTail) currentTail.nextSub = link;
    }
    if ( true && link.dep.subsHead === void 0) {
      link.dep.subsHead = link;
    }
    link.dep.subs = link;
  }
}
const targetMap = /* @__PURE__ */ new WeakMap();
const ITERATE_KEY = Symbol(
   true ? "Object iterate" : 0
);
const MAP_KEY_ITERATE_KEY = Symbol(
   true ? "Map keys iterate" : 0
);
const ARRAY_ITERATE_KEY = Symbol(
   true ? "Array iterate" : 0
);
function track(target, type, key) {
  if (shouldTrack && activeSub) {
    let depsMap = targetMap.get(target);
    if (!depsMap) {
      targetMap.set(target, depsMap = /* @__PURE__ */ new Map());
    }
    let dep = depsMap.get(key);
    if (!dep) {
      depsMap.set(key, dep = new Dep());
      dep.map = depsMap;
      dep.key = key;
    }
    if (true) {
      dep.track({
        target,
        type,
        key
      });
    } else {}
  }
}
function trigger(target, type, key, newValue, oldValue, oldTarget) {
  const depsMap = targetMap.get(target);
  if (!depsMap) {
    globalVersion++;
    return;
  }
  const run = (dep) => {
    if (dep) {
      if (true) {
        dep.trigger({
          target,
          type,
          key,
          newValue,
          oldValue,
          oldTarget
        });
      } else {}
    }
  };
  startBatch();
  if (type === "clear") {
    depsMap.forEach(run);
  } else {
    const targetIsArray = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(target);
    const isArrayIndex = targetIsArray && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isIntegerKey)(key);
    if (targetIsArray && key === "length") {
      const newLength = Number(newValue);
      depsMap.forEach((dep, key2) => {
        if (key2 === "length" || key2 === ARRAY_ITERATE_KEY || !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isSymbol)(key2) && key2 >= newLength) {
          run(dep);
        }
      });
    } else {
      if (key !== void 0 || depsMap.has(void 0)) {
        run(depsMap.get(key));
      }
      if (isArrayIndex) {
        run(depsMap.get(ARRAY_ITERATE_KEY));
      }
      switch (type) {
        case "add":
          if (!targetIsArray) {
            run(depsMap.get(ITERATE_KEY));
            if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isMap)(target)) {
              run(depsMap.get(MAP_KEY_ITERATE_KEY));
            }
          } else if (isArrayIndex) {
            run(depsMap.get("length"));
          }
          break;
        case "delete":
          if (!targetIsArray) {
            run(depsMap.get(ITERATE_KEY));
            if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isMap)(target)) {
              run(depsMap.get(MAP_KEY_ITERATE_KEY));
            }
          }
          break;
        case "set":
          if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isMap)(target)) {
            run(depsMap.get(ITERATE_KEY));
          }
          break;
      }
    }
  }
  endBatch();
}
function getDepFromReactive(object, key) {
  const depMap = targetMap.get(object);
  return depMap && depMap.get(key);
}

function reactiveReadArray(array) {
  const raw = toRaw(array);
  if (raw === array) return raw;
  track(raw, "iterate", ARRAY_ITERATE_KEY);
  return isShallow(array) ? raw : raw.map(toReactive);
}
function shallowReadArray(arr) {
  track(arr = toRaw(arr), "iterate", ARRAY_ITERATE_KEY);
  return arr;
}
const arrayInstrumentations = {
  __proto__: null,
  [Symbol.iterator]() {
    return iterator(this, Symbol.iterator, toReactive);
  },
  concat(...args) {
    return reactiveReadArray(this).concat(
      ...args.map((x) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(x) ? reactiveReadArray(x) : x)
    );
  },
  entries() {
    return iterator(this, "entries", (value) => {
      value[1] = toReactive(value[1]);
      return value;
    });
  },
  every(fn, thisArg) {
    return apply(this, "every", fn, thisArg, void 0, arguments);
  },
  filter(fn, thisArg) {
    return apply(this, "filter", fn, thisArg, (v) => v.map(toReactive), arguments);
  },
  find(fn, thisArg) {
    return apply(this, "find", fn, thisArg, toReactive, arguments);
  },
  findIndex(fn, thisArg) {
    return apply(this, "findIndex", fn, thisArg, void 0, arguments);
  },
  findLast(fn, thisArg) {
    return apply(this, "findLast", fn, thisArg, toReactive, arguments);
  },
  findLastIndex(fn, thisArg) {
    return apply(this, "findLastIndex", fn, thisArg, void 0, arguments);
  },
  // flat, flatMap could benefit from ARRAY_ITERATE but are not straight-forward to implement
  forEach(fn, thisArg) {
    return apply(this, "forEach", fn, thisArg, void 0, arguments);
  },
  includes(...args) {
    return searchProxy(this, "includes", args);
  },
  indexOf(...args) {
    return searchProxy(this, "indexOf", args);
  },
  join(separator) {
    return reactiveReadArray(this).join(separator);
  },
  // keys() iterator only reads `length`, no optimisation required
  lastIndexOf(...args) {
    return searchProxy(this, "lastIndexOf", args);
  },
  map(fn, thisArg) {
    return apply(this, "map", fn, thisArg, void 0, arguments);
  },
  pop() {
    return noTracking(this, "pop");
  },
  push(...args) {
    return noTracking(this, "push", args);
  },
  reduce(fn, ...args) {
    return reduce(this, "reduce", fn, args);
  },
  reduceRight(fn, ...args) {
    return reduce(this, "reduceRight", fn, args);
  },
  shift() {
    return noTracking(this, "shift");
  },
  // slice could use ARRAY_ITERATE but also seems to beg for range tracking
  some(fn, thisArg) {
    return apply(this, "some", fn, thisArg, void 0, arguments);
  },
  splice(...args) {
    return noTracking(this, "splice", args);
  },
  toReversed() {
    return reactiveReadArray(this).toReversed();
  },
  toSorted(comparer) {
    return reactiveReadArray(this).toSorted(comparer);
  },
  toSpliced(...args) {
    return reactiveReadArray(this).toSpliced(...args);
  },
  unshift(...args) {
    return noTracking(this, "unshift", args);
  },
  values() {
    return iterator(this, "values", toReactive);
  }
};
function iterator(self, method, wrapValue) {
  const arr = shallowReadArray(self);
  const iter = arr[method]();
  if (arr !== self && !isShallow(self)) {
    iter._next = iter.next;
    iter.next = () => {
      const result = iter._next();
      if (result.value) {
        result.value = wrapValue(result.value);
      }
      return result;
    };
  }
  return iter;
}
const arrayProto = Array.prototype;
function apply(self, method, fn, thisArg, wrappedRetFn, args) {
  const arr = shallowReadArray(self);
  const needsWrap = arr !== self && !isShallow(self);
  const methodFn = arr[method];
  if (methodFn !== arrayProto[method]) {
    const result2 = methodFn.apply(self, args);
    return needsWrap ? toReactive(result2) : result2;
  }
  let wrappedFn = fn;
  if (arr !== self) {
    if (needsWrap) {
      wrappedFn = function(item, index) {
        return fn.call(this, toReactive(item), index, self);
      };
    } else if (fn.length > 2) {
      wrappedFn = function(item, index) {
        return fn.call(this, item, index, self);
      };
    }
  }
  const result = methodFn.call(arr, wrappedFn, thisArg);
  return needsWrap && wrappedRetFn ? wrappedRetFn(result) : result;
}
function reduce(self, method, fn, args) {
  const arr = shallowReadArray(self);
  let wrappedFn = fn;
  if (arr !== self) {
    if (!isShallow(self)) {
      wrappedFn = function(acc, item, index) {
        return fn.call(this, acc, toReactive(item), index, self);
      };
    } else if (fn.length > 3) {
      wrappedFn = function(acc, item, index) {
        return fn.call(this, acc, item, index, self);
      };
    }
  }
  return arr[method](wrappedFn, ...args);
}
function searchProxy(self, method, args) {
  const arr = toRaw(self);
  track(arr, "iterate", ARRAY_ITERATE_KEY);
  const res = arr[method](...args);
  if ((res === -1 || res === false) && isProxy(args[0])) {
    args[0] = toRaw(args[0]);
    return arr[method](...args);
  }
  return res;
}
function noTracking(self, method, args = []) {
  pauseTracking();
  startBatch();
  const res = toRaw(self)[method].apply(self, args);
  endBatch();
  resetTracking();
  return res;
}

const isNonTrackableKeys = /* @__PURE__ */ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.makeMap)(`__proto__,__v_isRef,__isVue`);
const builtInSymbols = new Set(
  /* @__PURE__ */ Object.getOwnPropertyNames(Symbol).filter((key) => key !== "arguments" && key !== "caller").map((key) => Symbol[key]).filter(_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isSymbol)
);
function hasOwnProperty(key) {
  if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isSymbol)(key)) key = String(key);
  const obj = toRaw(this);
  track(obj, "has", key);
  return obj.hasOwnProperty(key);
}
class BaseReactiveHandler {
  constructor(_isReadonly = false, _isShallow = false) {
    this._isReadonly = _isReadonly;
    this._isShallow = _isShallow;
  }
  get(target, key, receiver) {
    if (key === "__v_skip") return target["__v_skip"];
    const isReadonly2 = this._isReadonly, isShallow2 = this._isShallow;
    if (key === "__v_isReactive") {
      return !isReadonly2;
    } else if (key === "__v_isReadonly") {
      return isReadonly2;
    } else if (key === "__v_isShallow") {
      return isShallow2;
    } else if (key === "__v_raw") {
      if (receiver === (isReadonly2 ? isShallow2 ? shallowReadonlyMap : readonlyMap : isShallow2 ? shallowReactiveMap : reactiveMap).get(target) || // receiver is not the reactive proxy, but has the same prototype
      // this means the receiver is a user proxy of the reactive proxy
      Object.getPrototypeOf(target) === Object.getPrototypeOf(receiver)) {
        return target;
      }
      return;
    }
    const targetIsArray = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(target);
    if (!isReadonly2) {
      let fn;
      if (targetIsArray && (fn = arrayInstrumentations[key])) {
        return fn;
      }
      if (key === "hasOwnProperty") {
        return hasOwnProperty;
      }
    }
    const res = Reflect.get(
      target,
      key,
      // if this is a proxy wrapping a ref, return methods using the raw ref
      // as receiver so that we don't have to call `toRaw` on the ref in all
      // its class methods
      isRef(target) ? target : receiver
    );
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isSymbol)(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) {
      return res;
    }
    if (!isReadonly2) {
      track(target, "get", key);
    }
    if (isShallow2) {
      return res;
    }
    if (isRef(res)) {
      return targetIsArray && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isIntegerKey)(key) ? res : res.value;
    }
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isObject)(res)) {
      return isReadonly2 ? readonly(res) : reactive(res);
    }
    return res;
  }
}
class MutableReactiveHandler extends BaseReactiveHandler {
  constructor(isShallow2 = false) {
    super(false, isShallow2);
  }
  set(target, key, value, receiver) {
    let oldValue = target[key];
    if (!this._isShallow) {
      const isOldValueReadonly = isReadonly(oldValue);
      if (!isShallow(value) && !isReadonly(value)) {
        oldValue = toRaw(oldValue);
        value = toRaw(value);
      }
      if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(target) && isRef(oldValue) && !isRef(value)) {
        if (isOldValueReadonly) {
          return false;
        } else {
          oldValue.value = value;
          return true;
        }
      }
    }
    const hadKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(target) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isIntegerKey)(key) ? Number(key) < target.length : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasOwn)(target, key);
    const result = Reflect.set(
      target,
      key,
      value,
      isRef(target) ? target : receiver
    );
    if (target === toRaw(receiver)) {
      if (!hadKey) {
        trigger(target, "add", key, value);
      } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasChanged)(value, oldValue)) {
        trigger(target, "set", key, value, oldValue);
      }
    }
    return result;
  }
  deleteProperty(target, key) {
    const hadKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasOwn)(target, key);
    const oldValue = target[key];
    const result = Reflect.deleteProperty(target, key);
    if (result && hadKey) {
      trigger(target, "delete", key, void 0, oldValue);
    }
    return result;
  }
  has(target, key) {
    const result = Reflect.has(target, key);
    if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isSymbol)(key) || !builtInSymbols.has(key)) {
      track(target, "has", key);
    }
    return result;
  }
  ownKeys(target) {
    track(
      target,
      "iterate",
      (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(target) ? "length" : ITERATE_KEY
    );
    return Reflect.ownKeys(target);
  }
}
class ReadonlyReactiveHandler extends BaseReactiveHandler {
  constructor(isShallow2 = false) {
    super(true, isShallow2);
  }
  set(target, key) {
    if (true) {
      warn(
        `Set operation on key "${String(key)}" failed: target is readonly.`,
        target
      );
    }
    return true;
  }
  deleteProperty(target, key) {
    if (true) {
      warn(
        `Delete operation on key "${String(key)}" failed: target is readonly.`,
        target
      );
    }
    return true;
  }
}
const mutableHandlers = /* @__PURE__ */ new MutableReactiveHandler();
const readonlyHandlers = /* @__PURE__ */ new ReadonlyReactiveHandler();
const shallowReactiveHandlers = /* @__PURE__ */ new MutableReactiveHandler(true);
const shallowReadonlyHandlers = /* @__PURE__ */ new ReadonlyReactiveHandler(true);

const toShallow = (value) => value;
const getProto = (v) => Reflect.getPrototypeOf(v);
function createIterableMethod(method, isReadonly2, isShallow2) {
  return function(...args) {
    const target = this["__v_raw"];
    const rawTarget = toRaw(target);
    const targetIsMap = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isMap)(rawTarget);
    const isPair = method === "entries" || method === Symbol.iterator && targetIsMap;
    const isKeyOnly = method === "keys" && targetIsMap;
    const innerIterator = target[method](...args);
    const wrap = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
    !isReadonly2 && track(
      rawTarget,
      "iterate",
      isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY
    );
    return {
      // iterator protocol
      next() {
        const { value, done } = innerIterator.next();
        return done ? { value, done } : {
          value: isPair ? [wrap(value[0]), wrap(value[1])] : wrap(value),
          done
        };
      },
      // iterable protocol
      [Symbol.iterator]() {
        return this;
      }
    };
  };
}
function createReadonlyMethod(type) {
  return function(...args) {
    if (true) {
      const key = args[0] ? `on key "${args[0]}" ` : ``;
      warn(
        `${(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.capitalize)(type)} operation ${key}failed: target is readonly.`,
        toRaw(this)
      );
    }
    return type === "delete" ? false : type === "clear" ? void 0 : this;
  };
}
function createInstrumentations(readonly, shallow) {
  const instrumentations = {
    get(key) {
      const target = this["__v_raw"];
      const rawTarget = toRaw(target);
      const rawKey = toRaw(key);
      if (!readonly) {
        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasChanged)(key, rawKey)) {
          track(rawTarget, "get", key);
        }
        track(rawTarget, "get", rawKey);
      }
      const { has } = getProto(rawTarget);
      const wrap = shallow ? toShallow : readonly ? toReadonly : toReactive;
      if (has.call(rawTarget, key)) {
        return wrap(target.get(key));
      } else if (has.call(rawTarget, rawKey)) {
        return wrap(target.get(rawKey));
      } else if (target !== rawTarget) {
        target.get(key);
      }
    },
    get size() {
      const target = this["__v_raw"];
      !readonly && track(toRaw(target), "iterate", ITERATE_KEY);
      return Reflect.get(target, "size", target);
    },
    has(key) {
      const target = this["__v_raw"];
      const rawTarget = toRaw(target);
      const rawKey = toRaw(key);
      if (!readonly) {
        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasChanged)(key, rawKey)) {
          track(rawTarget, "has", key);
        }
        track(rawTarget, "has", rawKey);
      }
      return key === rawKey ? target.has(key) : target.has(key) || target.has(rawKey);
    },
    forEach(callback, thisArg) {
      const observed = this;
      const target = observed["__v_raw"];
      const rawTarget = toRaw(target);
      const wrap = shallow ? toShallow : readonly ? toReadonly : toReactive;
      !readonly && track(rawTarget, "iterate", ITERATE_KEY);
      return target.forEach((value, key) => {
        return callback.call(thisArg, wrap(value), wrap(key), observed);
      });
    }
  };
  (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.extend)(
    instrumentations,
    readonly ? {
      add: createReadonlyMethod("add"),
      set: createReadonlyMethod("set"),
      delete: createReadonlyMethod("delete"),
      clear: createReadonlyMethod("clear")
    } : {
      add(value) {
        if (!shallow && !isShallow(value) && !isReadonly(value)) {
          value = toRaw(value);
        }
        const target = toRaw(this);
        const proto = getProto(target);
        const hadKey = proto.has.call(target, value);
        if (!hadKey) {
          target.add(value);
          trigger(target, "add", value, value);
        }
        return this;
      },
      set(key, value) {
        if (!shallow && !isShallow(value) && !isReadonly(value)) {
          value = toRaw(value);
        }
        const target = toRaw(this);
        const { has, get } = getProto(target);
        let hadKey = has.call(target, key);
        if (!hadKey) {
          key = toRaw(key);
          hadKey = has.call(target, key);
        } else if (true) {
          checkIdentityKeys(target, has, key);
        }
        const oldValue = get.call(target, key);
        target.set(key, value);
        if (!hadKey) {
          trigger(target, "add", key, value);
        } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasChanged)(value, oldValue)) {
          trigger(target, "set", key, value, oldValue);
        }
        return this;
      },
      delete(key) {
        const target = toRaw(this);
        const { has, get } = getProto(target);
        let hadKey = has.call(target, key);
        if (!hadKey) {
          key = toRaw(key);
          hadKey = has.call(target, key);
        } else if (true) {
          checkIdentityKeys(target, has, key);
        }
        const oldValue = get ? get.call(target, key) : void 0;
        const result = target.delete(key);
        if (hadKey) {
          trigger(target, "delete", key, void 0, oldValue);
        }
        return result;
      },
      clear() {
        const target = toRaw(this);
        const hadItems = target.size !== 0;
        const oldTarget =  true ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isMap)(target) ? new Map(target) : new Set(target) : 0;
        const result = target.clear();
        if (hadItems) {
          trigger(
            target,
            "clear",
            void 0,
            void 0,
            oldTarget
          );
        }
        return result;
      }
    }
  );
  const iteratorMethods = [
    "keys",
    "values",
    "entries",
    Symbol.iterator
  ];
  iteratorMethods.forEach((method) => {
    instrumentations[method] = createIterableMethod(method, readonly, shallow);
  });
  return instrumentations;
}
function createInstrumentationGetter(isReadonly2, shallow) {
  const instrumentations = createInstrumentations(isReadonly2, shallow);
  return (target, key, receiver) => {
    if (key === "__v_isReactive") {
      return !isReadonly2;
    } else if (key === "__v_isReadonly") {
      return isReadonly2;
    } else if (key === "__v_raw") {
      return target;
    }
    return Reflect.get(
      (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasOwn)(instrumentations, key) && key in target ? instrumentations : target,
      key,
      receiver
    );
  };
}
const mutableCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(false, false)
};
const shallowCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(false, true)
};
const readonlyCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(true, false)
};
const shallowReadonlyCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(true, true)
};
function checkIdentityKeys(target, has, key) {
  const rawKey = toRaw(key);
  if (rawKey !== key && has.call(target, rawKey)) {
    const type = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.toRawType)(target);
    warn(
      `Reactive ${type} contains both the raw and reactive versions of the same object${type === `Map` ? ` as keys` : ``}, which can lead to inconsistencies. Avoid differentiating between the raw and reactive versions of an object and only use the reactive version if possible.`
    );
  }
}

const reactiveMap = /* @__PURE__ */ new WeakMap();
const shallowReactiveMap = /* @__PURE__ */ new WeakMap();
const readonlyMap = /* @__PURE__ */ new WeakMap();
const shallowReadonlyMap = /* @__PURE__ */ new WeakMap();
function targetTypeMap(rawType) {
  switch (rawType) {
    case "Object":
    case "Array":
      return 1 /* COMMON */;
    case "Map":
    case "Set":
    case "WeakMap":
    case "WeakSet":
      return 2 /* COLLECTION */;
    default:
      return 0 /* INVALID */;
  }
}
function getTargetType(value) {
  return value["__v_skip"] || !Object.isExtensible(value) ? 0 /* INVALID */ : targetTypeMap((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.toRawType)(value));
}
function reactive(target) {
  if (isReadonly(target)) {
    return target;
  }
  return createReactiveObject(
    target,
    false,
    mutableHandlers,
    mutableCollectionHandlers,
    reactiveMap
  );
}
function shallowReactive(target) {
  return createReactiveObject(
    target,
    false,
    shallowReactiveHandlers,
    shallowCollectionHandlers,
    shallowReactiveMap
  );
}
function readonly(target) {
  return createReactiveObject(
    target,
    true,
    readonlyHandlers,
    readonlyCollectionHandlers,
    readonlyMap
  );
}
function shallowReadonly(target) {
  return createReactiveObject(
    target,
    true,
    shallowReadonlyHandlers,
    shallowReadonlyCollectionHandlers,
    shallowReadonlyMap
  );
}
function createReactiveObject(target, isReadonly2, baseHandlers, collectionHandlers, proxyMap) {
  if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isObject)(target)) {
    if (true) {
      warn(
        `value cannot be made ${isReadonly2 ? "readonly" : "reactive"}: ${String(
          target
        )}`
      );
    }
    return target;
  }
  if (target["__v_raw"] && !(isReadonly2 && target["__v_isReactive"])) {
    return target;
  }
  const targetType = getTargetType(target);
  if (targetType === 0 /* INVALID */) {
    return target;
  }
  const existingProxy = proxyMap.get(target);
  if (existingProxy) {
    return existingProxy;
  }
  const proxy = new Proxy(
    target,
    targetType === 2 /* COLLECTION */ ? collectionHandlers : baseHandlers
  );
  proxyMap.set(target, proxy);
  return proxy;
}
function isReactive(value) {
  if (isReadonly(value)) {
    return isReactive(value["__v_raw"]);
  }
  return !!(value && value["__v_isReactive"]);
}
function isReadonly(value) {
  return !!(value && value["__v_isReadonly"]);
}
function isShallow(value) {
  return !!(value && value["__v_isShallow"]);
}
function isProxy(value) {
  return value ? !!value["__v_raw"] : false;
}
function toRaw(observed) {
  const raw = observed && observed["__v_raw"];
  return raw ? toRaw(raw) : observed;
}
function markRaw(value) {
  if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasOwn)(value, "__v_skip") && Object.isExtensible(value)) {
    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.def)(value, "__v_skip", true);
  }
  return value;
}
const toReactive = (value) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isObject)(value) ? reactive(value) : value;
const toReadonly = (value) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isObject)(value) ? readonly(value) : value;

function isRef(r) {
  return r ? r["__v_isRef"] === true : false;
}
function ref(value) {
  return createRef(value, false);
}
function shallowRef(value) {
  return createRef(value, true);
}
function createRef(rawValue, shallow) {
  if (isRef(rawValue)) {
    return rawValue;
  }
  return new RefImpl(rawValue, shallow);
}
class RefImpl {
  constructor(value, isShallow2) {
    this.dep = new Dep();
    this["__v_isRef"] = true;
    this["__v_isShallow"] = false;
    this._rawValue = isShallow2 ? value : toRaw(value);
    this._value = isShallow2 ? value : toReactive(value);
    this["__v_isShallow"] = isShallow2;
  }
  get value() {
    if (true) {
      this.dep.track({
        target: this,
        type: "get",
        key: "value"
      });
    } else {}
    return this._value;
  }
  set value(newValue) {
    const oldValue = this._rawValue;
    const useDirectValue = this["__v_isShallow"] || isShallow(newValue) || isReadonly(newValue);
    newValue = useDirectValue ? newValue : toRaw(newValue);
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasChanged)(newValue, oldValue)) {
      this._rawValue = newValue;
      this._value = useDirectValue ? newValue : toReactive(newValue);
      if (true) {
        this.dep.trigger({
          target: this,
          type: "set",
          key: "value",
          newValue,
          oldValue
        });
      } else {}
    }
  }
}
function triggerRef(ref2) {
  if (ref2.dep) {
    if (true) {
      ref2.dep.trigger({
        target: ref2,
        type: "set",
        key: "value",
        newValue: ref2._value
      });
    } else {}
  }
}
function unref(ref2) {
  return isRef(ref2) ? ref2.value : ref2;
}
function toValue(source) {
  return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isFunction)(source) ? source() : unref(source);
}
const shallowUnwrapHandlers = {
  get: (target, key, receiver) => key === "__v_raw" ? target : unref(Reflect.get(target, key, receiver)),
  set: (target, key, value, receiver) => {
    const oldValue = target[key];
    if (isRef(oldValue) && !isRef(value)) {
      oldValue.value = value;
      return true;
    } else {
      return Reflect.set(target, key, value, receiver);
    }
  }
};
function proxyRefs(objectWithRefs) {
  return isReactive(objectWithRefs) ? objectWithRefs : new Proxy(objectWithRefs, shallowUnwrapHandlers);
}
class CustomRefImpl {
  constructor(factory) {
    this["__v_isRef"] = true;
    this._value = void 0;
    const dep = this.dep = new Dep();
    const { get, set } = factory(dep.track.bind(dep), dep.trigger.bind(dep));
    this._get = get;
    this._set = set;
  }
  get value() {
    return this._value = this._get();
  }
  set value(newVal) {
    this._set(newVal);
  }
}
function customRef(factory) {
  return new CustomRefImpl(factory);
}
function toRefs(object) {
  if ( true && !isProxy(object)) {
    warn(`toRefs() expects a reactive object but received a plain one.`);
  }
  const ret = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(object) ? new Array(object.length) : {};
  for (const key in object) {
    ret[key] = propertyToRef(object, key);
  }
  return ret;
}
class ObjectRefImpl {
  constructor(_object, _key, _defaultValue) {
    this._object = _object;
    this._key = _key;
    this._defaultValue = _defaultValue;
    this["__v_isRef"] = true;
    this._value = void 0;
  }
  get value() {
    const val = this._object[this._key];
    return this._value = val === void 0 ? this._defaultValue : val;
  }
  set value(newVal) {
    this._object[this._key] = newVal;
  }
  get dep() {
    return getDepFromReactive(toRaw(this._object), this._key);
  }
}
class GetterRefImpl {
  constructor(_getter) {
    this._getter = _getter;
    this["__v_isRef"] = true;
    this["__v_isReadonly"] = true;
    this._value = void 0;
  }
  get value() {
    return this._value = this._getter();
  }
}
function toRef(source, key, defaultValue) {
  if (isRef(source)) {
    return source;
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isFunction)(source)) {
    return new GetterRefImpl(source);
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isObject)(source) && arguments.length > 1) {
    return propertyToRef(source, key, defaultValue);
  } else {
    return ref(source);
  }
}
function propertyToRef(source, key, defaultValue) {
  const val = source[key];
  return isRef(val) ? val : new ObjectRefImpl(source, key, defaultValue);
}

class ComputedRefImpl {
  constructor(fn, setter, isSSR) {
    this.fn = fn;
    this.setter = setter;
    /**
     * @internal
     */
    this._value = void 0;
    /**
     * @internal
     */
    this.dep = new Dep(this);
    /**
     * @internal
     */
    this.__v_isRef = true;
    // TODO isolatedDeclarations "__v_isReadonly"
    // A computed is also a subscriber that tracks other deps
    /**
     * @internal
     */
    this.deps = void 0;
    /**
     * @internal
     */
    this.depsTail = void 0;
    /**
     * @internal
     */
    this.flags = 16;
    /**
     * @internal
     */
    this.globalVersion = globalVersion - 1;
    /**
     * @internal
     */
    this.next = void 0;
    // for backwards compat
    this.effect = this;
    this["__v_isReadonly"] = !setter;
    this.isSSR = isSSR;
  }
  /**
   * @internal
   */
  notify() {
    this.flags |= 16;
    if (!(this.flags & 8) && // avoid infinite self recursion
    activeSub !== this) {
      batch(this, true);
      return true;
    } else if (true) ;
  }
  get value() {
    const link =  true ? this.dep.track({
      target: this,
      type: "get",
      key: "value"
    }) : 0;
    refreshComputed(this);
    if (link) {
      link.version = this.dep.version;
    }
    return this._value;
  }
  set value(newValue) {
    if (this.setter) {
      this.setter(newValue);
    } else if (true) {
      warn("Write operation failed: computed value is readonly");
    }
  }
}
function computed(getterOrOptions, debugOptions, isSSR = false) {
  let getter;
  let setter;
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isFunction)(getterOrOptions)) {
    getter = getterOrOptions;
  } else {
    getter = getterOrOptions.get;
    setter = getterOrOptions.set;
  }
  const cRef = new ComputedRefImpl(getter, setter, isSSR);
  if ( true && debugOptions && !isSSR) {
    cRef.onTrack = debugOptions.onTrack;
    cRef.onTrigger = debugOptions.onTrigger;
  }
  return cRef;
}

const TrackOpTypes = {
  "GET": "get",
  "HAS": "has",
  "ITERATE": "iterate"
};
const TriggerOpTypes = {
  "SET": "set",
  "ADD": "add",
  "DELETE": "delete",
  "CLEAR": "clear"
};
const ReactiveFlags = {
  "SKIP": "__v_skip",
  "IS_REACTIVE": "__v_isReactive",
  "IS_READONLY": "__v_isReadonly",
  "IS_SHALLOW": "__v_isShallow",
  "RAW": "__v_raw",
  "IS_REF": "__v_isRef"
};

const WatchErrorCodes = {
  "WATCH_GETTER": 2,
  "2": "WATCH_GETTER",
  "WATCH_CALLBACK": 3,
  "3": "WATCH_CALLBACK",
  "WATCH_CLEANUP": 4,
  "4": "WATCH_CLEANUP"
};
const INITIAL_WATCHER_VALUE = {};
const cleanupMap = /* @__PURE__ */ new WeakMap();
let activeWatcher = void 0;
function getCurrentWatcher() {
  return activeWatcher;
}
function onWatcherCleanup(cleanupFn, failSilently = false, owner = activeWatcher) {
  if (owner) {
    let cleanups = cleanupMap.get(owner);
    if (!cleanups) cleanupMap.set(owner, cleanups = []);
    cleanups.push(cleanupFn);
  } else if ( true && !failSilently) {
    warn(
      `onWatcherCleanup() was called when there was no active watcher to associate with.`
    );
  }
}
function watch(source, cb, options = _vue_shared__WEBPACK_IMPORTED_MODULE_0__.EMPTY_OBJ) {
  const { immediate, deep, once, scheduler, augmentJob, call } = options;
  const warnInvalidSource = (s) => {
    (options.onWarn || warn)(
      `Invalid watch source: `,
      s,
      `A watch source can only be a getter/effect function, a ref, a reactive object, or an array of these types.`
    );
  };
  const reactiveGetter = (source2) => {
    if (deep) return source2;
    if (isShallow(source2) || deep === false || deep === 0)
      return traverse(source2, 1);
    return traverse(source2);
  };
  let effect;
  let getter;
  let cleanup;
  let boundCleanup;
  let forceTrigger = false;
  let isMultiSource = false;
  if (isRef(source)) {
    getter = () => source.value;
    forceTrigger = isShallow(source);
  } else if (isReactive(source)) {
    getter = () => reactiveGetter(source);
    forceTrigger = true;
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(source)) {
    isMultiSource = true;
    forceTrigger = source.some((s) => isReactive(s) || isShallow(s));
    getter = () => source.map((s) => {
      if (isRef(s)) {
        return s.value;
      } else if (isReactive(s)) {
        return reactiveGetter(s);
      } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isFunction)(s)) {
        return call ? call(s, 2) : s();
      } else {
         true && warnInvalidSource(s);
      }
    });
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isFunction)(source)) {
    if (cb) {
      getter = call ? () => call(source, 2) : source;
    } else {
      getter = () => {
        if (cleanup) {
          pauseTracking();
          try {
            cleanup();
          } finally {
            resetTracking();
          }
        }
        const currentEffect = activeWatcher;
        activeWatcher = effect;
        try {
          return call ? call(source, 3, [boundCleanup]) : source(boundCleanup);
        } finally {
          activeWatcher = currentEffect;
        }
      };
    }
  } else {
    getter = _vue_shared__WEBPACK_IMPORTED_MODULE_0__.NOOP;
     true && warnInvalidSource(source);
  }
  if (cb && deep) {
    const baseGetter = getter;
    const depth = deep === true ? Infinity : deep;
    getter = () => traverse(baseGetter(), depth);
  }
  const scope = getCurrentScope();
  const watchHandle = () => {
    effect.stop();
    if (scope && scope.active) {
      (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.remove)(scope.effects, effect);
    }
  };
  if (once && cb) {
    const _cb = cb;
    cb = (...args) => {
      _cb(...args);
      watchHandle();
    };
  }
  let oldValue = isMultiSource ? new Array(source.length).fill(INITIAL_WATCHER_VALUE) : INITIAL_WATCHER_VALUE;
  const job = (immediateFirstRun) => {
    if (!(effect.flags & 1) || !effect.dirty && !immediateFirstRun) {
      return;
    }
    if (cb) {
      const newValue = effect.run();
      if (deep || forceTrigger || (isMultiSource ? newValue.some((v, i) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasChanged)(v, oldValue[i])) : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasChanged)(newValue, oldValue))) {
        if (cleanup) {
          cleanup();
        }
        const currentWatcher = activeWatcher;
        activeWatcher = effect;
        try {
          const args = [
            newValue,
            // pass undefined as the old value when it's changed for the first time
            oldValue === INITIAL_WATCHER_VALUE ? void 0 : isMultiSource && oldValue[0] === INITIAL_WATCHER_VALUE ? [] : oldValue,
            boundCleanup
          ];
          oldValue = newValue;
          call ? call(cb, 3, args) : (
            // @ts-expect-error
            cb(...args)
          );
        } finally {
          activeWatcher = currentWatcher;
        }
      }
    } else {
      effect.run();
    }
  };
  if (augmentJob) {
    augmentJob(job);
  }
  effect = new ReactiveEffect(getter);
  effect.scheduler = scheduler ? () => scheduler(job, false) : job;
  boundCleanup = (fn) => onWatcherCleanup(fn, false, effect);
  cleanup = effect.onStop = () => {
    const cleanups = cleanupMap.get(effect);
    if (cleanups) {
      if (call) {
        call(cleanups, 4);
      } else {
        for (const cleanup2 of cleanups) cleanup2();
      }
      cleanupMap.delete(effect);
    }
  };
  if (true) {
    effect.onTrack = options.onTrack;
    effect.onTrigger = options.onTrigger;
  }
  if (cb) {
    if (immediate) {
      job(true);
    } else {
      oldValue = effect.run();
    }
  } else if (scheduler) {
    scheduler(job.bind(null, true), true);
  } else {
    effect.run();
  }
  watchHandle.pause = effect.pause.bind(effect);
  watchHandle.resume = effect.resume.bind(effect);
  watchHandle.stop = watchHandle;
  return watchHandle;
}
function traverse(value, depth = Infinity, seen) {
  if (depth <= 0 || !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isObject)(value) || value["__v_skip"]) {
    return value;
  }
  seen = seen || /* @__PURE__ */ new Set();
  if (seen.has(value)) {
    return value;
  }
  seen.add(value);
  depth--;
  if (isRef(value)) {
    traverse(value.value, depth, seen);
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(value)) {
    for (let i = 0; i < value.length; i++) {
      traverse(value[i], depth, seen);
    }
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isSet)(value) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isMap)(value)) {
    value.forEach((v) => {
      traverse(v, depth, seen);
    });
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(value)) {
    for (const key in value) {
      traverse(value[key], depth, seen);
    }
    for (const key of Object.getOwnPropertySymbols(value)) {
      if (Object.prototype.propertyIsEnumerable.call(value, key)) {
        traverse(value[key], depth, seen);
      }
    }
  }
  return value;
}




/***/ }),

/***/ "./node_modules/@vue/runtime-core/dist/runtime-core.esm-bundler.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@vue/runtime-core/dist/runtime-core.esm-bundler.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseTransition: () => (/* binding */ BaseTransition),
/* harmony export */   BaseTransitionPropsValidators: () => (/* binding */ BaseTransitionPropsValidators),
/* harmony export */   Comment: () => (/* binding */ Comment),
/* harmony export */   DeprecationTypes: () => (/* binding */ DeprecationTypes),
/* harmony export */   EffectScope: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.EffectScope),
/* harmony export */   ErrorCodes: () => (/* binding */ ErrorCodes),
/* harmony export */   ErrorTypeStrings: () => (/* binding */ ErrorTypeStrings),
/* harmony export */   Fragment: () => (/* binding */ Fragment),
/* harmony export */   KeepAlive: () => (/* binding */ KeepAlive),
/* harmony export */   ReactiveEffect: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ReactiveEffect),
/* harmony export */   Static: () => (/* binding */ Static),
/* harmony export */   Suspense: () => (/* binding */ Suspense),
/* harmony export */   Teleport: () => (/* binding */ Teleport),
/* harmony export */   Text: () => (/* binding */ Text),
/* harmony export */   TrackOpTypes: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.TrackOpTypes),
/* harmony export */   TriggerOpTypes: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.TriggerOpTypes),
/* harmony export */   assertNumber: () => (/* binding */ assertNumber),
/* harmony export */   callWithAsyncErrorHandling: () => (/* binding */ callWithAsyncErrorHandling),
/* harmony export */   callWithErrorHandling: () => (/* binding */ callWithErrorHandling),
/* harmony export */   camelize: () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize),
/* harmony export */   capitalize: () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.capitalize),
/* harmony export */   cloneVNode: () => (/* binding */ cloneVNode),
/* harmony export */   compatUtils: () => (/* binding */ compatUtils),
/* harmony export */   computed: () => (/* binding */ computed),
/* harmony export */   createBlock: () => (/* binding */ createBlock),
/* harmony export */   createCommentVNode: () => (/* binding */ createCommentVNode),
/* harmony export */   createElementBlock: () => (/* binding */ createElementBlock),
/* harmony export */   createElementVNode: () => (/* binding */ createBaseVNode),
/* harmony export */   createHydrationRenderer: () => (/* binding */ createHydrationRenderer),
/* harmony export */   createPropsRestProxy: () => (/* binding */ createPropsRestProxy),
/* harmony export */   createRenderer: () => (/* binding */ createRenderer),
/* harmony export */   createSlots: () => (/* binding */ createSlots),
/* harmony export */   createStaticVNode: () => (/* binding */ createStaticVNode),
/* harmony export */   createTextVNode: () => (/* binding */ createTextVNode),
/* harmony export */   createVNode: () => (/* binding */ createVNode),
/* harmony export */   customRef: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.customRef),
/* harmony export */   defineAsyncComponent: () => (/* binding */ defineAsyncComponent),
/* harmony export */   defineComponent: () => (/* binding */ defineComponent),
/* harmony export */   defineEmits: () => (/* binding */ defineEmits),
/* harmony export */   defineExpose: () => (/* binding */ defineExpose),
/* harmony export */   defineModel: () => (/* binding */ defineModel),
/* harmony export */   defineOptions: () => (/* binding */ defineOptions),
/* harmony export */   defineProps: () => (/* binding */ defineProps),
/* harmony export */   defineSlots: () => (/* binding */ defineSlots),
/* harmony export */   devtools: () => (/* binding */ devtools),
/* harmony export */   effect: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.effect),
/* harmony export */   effectScope: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.effectScope),
/* harmony export */   getCurrentInstance: () => (/* binding */ getCurrentInstance),
/* harmony export */   getCurrentScope: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.getCurrentScope),
/* harmony export */   getCurrentWatcher: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.getCurrentWatcher),
/* harmony export */   getTransitionRawChildren: () => (/* binding */ getTransitionRawChildren),
/* harmony export */   guardReactiveProps: () => (/* binding */ guardReactiveProps),
/* harmony export */   h: () => (/* binding */ h),
/* harmony export */   handleError: () => (/* binding */ handleError),
/* harmony export */   hasInjectionContext: () => (/* binding */ hasInjectionContext),
/* harmony export */   hydrateOnIdle: () => (/* binding */ hydrateOnIdle),
/* harmony export */   hydrateOnInteraction: () => (/* binding */ hydrateOnInteraction),
/* harmony export */   hydrateOnMediaQuery: () => (/* binding */ hydrateOnMediaQuery),
/* harmony export */   hydrateOnVisible: () => (/* binding */ hydrateOnVisible),
/* harmony export */   initCustomFormatter: () => (/* binding */ initCustomFormatter),
/* harmony export */   inject: () => (/* binding */ inject),
/* harmony export */   isMemoSame: () => (/* binding */ isMemoSame),
/* harmony export */   isProxy: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isProxy),
/* harmony export */   isReactive: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReactive),
/* harmony export */   isReadonly: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReadonly),
/* harmony export */   isRef: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef),
/* harmony export */   isRuntimeOnly: () => (/* binding */ isRuntimeOnly),
/* harmony export */   isShallow: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isShallow),
/* harmony export */   isVNode: () => (/* binding */ isVNode),
/* harmony export */   markRaw: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.markRaw),
/* harmony export */   mergeDefaults: () => (/* binding */ mergeDefaults),
/* harmony export */   mergeModels: () => (/* binding */ mergeModels),
/* harmony export */   mergeProps: () => (/* binding */ mergeProps),
/* harmony export */   nextTick: () => (/* binding */ nextTick),
/* harmony export */   normalizeClass: () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeClass),
/* harmony export */   normalizeProps: () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeProps),
/* harmony export */   normalizeStyle: () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeStyle),
/* harmony export */   onActivated: () => (/* binding */ onActivated),
/* harmony export */   onBeforeMount: () => (/* binding */ onBeforeMount),
/* harmony export */   onBeforeUnmount: () => (/* binding */ onBeforeUnmount),
/* harmony export */   onBeforeUpdate: () => (/* binding */ onBeforeUpdate),
/* harmony export */   onDeactivated: () => (/* binding */ onDeactivated),
/* harmony export */   onErrorCaptured: () => (/* binding */ onErrorCaptured),
/* harmony export */   onMounted: () => (/* binding */ onMounted),
/* harmony export */   onRenderTracked: () => (/* binding */ onRenderTracked),
/* harmony export */   onRenderTriggered: () => (/* binding */ onRenderTriggered),
/* harmony export */   onScopeDispose: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.onScopeDispose),
/* harmony export */   onServerPrefetch: () => (/* binding */ onServerPrefetch),
/* harmony export */   onUnmounted: () => (/* binding */ onUnmounted),
/* harmony export */   onUpdated: () => (/* binding */ onUpdated),
/* harmony export */   onWatcherCleanup: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.onWatcherCleanup),
/* harmony export */   openBlock: () => (/* binding */ openBlock),
/* harmony export */   popScopeId: () => (/* binding */ popScopeId),
/* harmony export */   provide: () => (/* binding */ provide),
/* harmony export */   proxyRefs: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.proxyRefs),
/* harmony export */   pushScopeId: () => (/* binding */ pushScopeId),
/* harmony export */   queuePostFlushCb: () => (/* binding */ queuePostFlushCb),
/* harmony export */   reactive: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.reactive),
/* harmony export */   readonly: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.readonly),
/* harmony export */   ref: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ref),
/* harmony export */   registerRuntimeCompiler: () => (/* binding */ registerRuntimeCompiler),
/* harmony export */   renderList: () => (/* binding */ renderList),
/* harmony export */   renderSlot: () => (/* binding */ renderSlot),
/* harmony export */   resolveComponent: () => (/* binding */ resolveComponent),
/* harmony export */   resolveDirective: () => (/* binding */ resolveDirective),
/* harmony export */   resolveDynamicComponent: () => (/* binding */ resolveDynamicComponent),
/* harmony export */   resolveFilter: () => (/* binding */ resolveFilter),
/* harmony export */   resolveTransitionHooks: () => (/* binding */ resolveTransitionHooks),
/* harmony export */   setBlockTracking: () => (/* binding */ setBlockTracking),
/* harmony export */   setDevtoolsHook: () => (/* binding */ setDevtoolsHook),
/* harmony export */   setTransitionHooks: () => (/* binding */ setTransitionHooks),
/* harmony export */   shallowReactive: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReactive),
/* harmony export */   shallowReadonly: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly),
/* harmony export */   shallowRef: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowRef),
/* harmony export */   ssrContextKey: () => (/* binding */ ssrContextKey),
/* harmony export */   ssrUtils: () => (/* binding */ ssrUtils),
/* harmony export */   stop: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.stop),
/* harmony export */   toDisplayString: () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.toDisplayString),
/* harmony export */   toHandlerKey: () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey),
/* harmony export */   toHandlers: () => (/* binding */ toHandlers),
/* harmony export */   toRaw: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw),
/* harmony export */   toRef: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRef),
/* harmony export */   toRefs: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRefs),
/* harmony export */   toValue: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toValue),
/* harmony export */   transformVNodeArgs: () => (/* binding */ transformVNodeArgs),
/* harmony export */   triggerRef: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.triggerRef),
/* harmony export */   unref: () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.unref),
/* harmony export */   useAttrs: () => (/* binding */ useAttrs),
/* harmony export */   useId: () => (/* binding */ useId),
/* harmony export */   useModel: () => (/* binding */ useModel),
/* harmony export */   useSSRContext: () => (/* binding */ useSSRContext),
/* harmony export */   useSlots: () => (/* binding */ useSlots),
/* harmony export */   useTemplateRef: () => (/* binding */ useTemplateRef),
/* harmony export */   useTransitionState: () => (/* binding */ useTransitionState),
/* harmony export */   version: () => (/* binding */ version),
/* harmony export */   warn: () => (/* binding */ warn),
/* harmony export */   watch: () => (/* binding */ watch),
/* harmony export */   watchEffect: () => (/* binding */ watchEffect),
/* harmony export */   watchPostEffect: () => (/* binding */ watchPostEffect),
/* harmony export */   watchSyncEffect: () => (/* binding */ watchSyncEffect),
/* harmony export */   withAsyncContext: () => (/* binding */ withAsyncContext),
/* harmony export */   withCtx: () => (/* binding */ withCtx),
/* harmony export */   withDefaults: () => (/* binding */ withDefaults),
/* harmony export */   withDirectives: () => (/* binding */ withDirectives),
/* harmony export */   withMemo: () => (/* binding */ withMemo),
/* harmony export */   withScopeId: () => (/* binding */ withScopeId)
/* harmony export */ });
/* harmony import */ var _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @vue/reactivity */ "./node_modules/@vue/reactivity/dist/reactivity.esm-bundler.js");
/* harmony import */ var _vue_shared__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @vue/shared */ "./node_modules/@vue/shared/dist/shared.esm-bundler.js");
/**
* @vue/runtime-core v3.5.16
* (c) 2018-present Yuxi (Evan) You and Vue contributors
* @license MIT
**/





const stack = [];
function pushWarningContext(vnode) {
  stack.push(vnode);
}
function popWarningContext() {
  stack.pop();
}
let isWarning = false;
function warn$1(msg, ...args) {
  if (isWarning) return;
  isWarning = true;
  (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();
  const instance = stack.length ? stack[stack.length - 1].component : null;
  const appWarnHandler = instance && instance.appContext.config.warnHandler;
  const trace = getComponentTrace();
  if (appWarnHandler) {
    callWithErrorHandling(
      appWarnHandler,
      instance,
      11,
      [
        // eslint-disable-next-line no-restricted-syntax
        msg + args.map((a) => {
          var _a, _b;
          return (_b = (_a = a.toString) == null ? void 0 : _a.call(a)) != null ? _b : JSON.stringify(a);
        }).join(""),
        instance && instance.proxy,
        trace.map(
          ({ vnode }) => `at <${formatComponentName(instance, vnode.type)}>`
        ).join("\n"),
        trace
      ]
    );
  } else {
    const warnArgs = [`[Vue warn]: ${msg}`, ...args];
    if (trace.length && // avoid spamming console during tests
    true) {
      warnArgs.push(`
`, ...formatTrace(trace));
    }
    console.warn(...warnArgs);
  }
  (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();
  isWarning = false;
}
function getComponentTrace() {
  let currentVNode = stack[stack.length - 1];
  if (!currentVNode) {
    return [];
  }
  const normalizedStack = [];
  while (currentVNode) {
    const last = normalizedStack[0];
    if (last && last.vnode === currentVNode) {
      last.recurseCount++;
    } else {
      normalizedStack.push({
        vnode: currentVNode,
        recurseCount: 0
      });
    }
    const parentInstance = currentVNode.component && currentVNode.component.parent;
    currentVNode = parentInstance && parentInstance.vnode;
  }
  return normalizedStack;
}
function formatTrace(trace) {
  const logs = [];
  trace.forEach((entry, i) => {
    logs.push(...i === 0 ? [] : [`
`], ...formatTraceEntry(entry));
  });
  return logs;
}
function formatTraceEntry({ vnode, recurseCount }) {
  const postfix = recurseCount > 0 ? `... (${recurseCount} recursive calls)` : ``;
  const isRoot = vnode.component ? vnode.component.parent == null : false;
  const open = ` at <${formatComponentName(
    vnode.component,
    vnode.type,
    isRoot
  )}`;
  const close = `>` + postfix;
  return vnode.props ? [open, ...formatProps(vnode.props), close] : [open + close];
}
function formatProps(props) {
  const res = [];
  const keys = Object.keys(props);
  keys.slice(0, 3).forEach((key) => {
    res.push(...formatProp(key, props[key]));
  });
  if (keys.length > 3) {
    res.push(` ...`);
  }
  return res;
}
function formatProp(key, value, raw) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(value)) {
    value = JSON.stringify(value);
    return raw ? value : [`${key}=${value}`];
  } else if (typeof value === "number" || typeof value === "boolean" || value == null) {
    return raw ? value : [`${key}=${value}`];
  } else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(value)) {
    value = formatProp(key, (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(value.value), true);
    return raw ? value : [`${key}=Ref<`, value, `>`];
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(value)) {
    return [`${key}=fn${value.name ? `<${value.name}>` : ``}`];
  } else {
    value = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(value);
    return raw ? value : [`${key}=`, value];
  }
}
function assertNumber(val, type) {
  if (false) {}
  if (val === void 0) {
    return;
  } else if (typeof val !== "number") {
    warn$1(`${type} is not a valid number - got ${JSON.stringify(val)}.`);
  } else if (isNaN(val)) {
    warn$1(`${type} is NaN - the duration expression might be incorrect.`);
  }
}

const ErrorCodes = {
  "SETUP_FUNCTION": 0,
  "0": "SETUP_FUNCTION",
  "RENDER_FUNCTION": 1,
  "1": "RENDER_FUNCTION",
  "NATIVE_EVENT_HANDLER": 5,
  "5": "NATIVE_EVENT_HANDLER",
  "COMPONENT_EVENT_HANDLER": 6,
  "6": "COMPONENT_EVENT_HANDLER",
  "VNODE_HOOK": 7,
  "7": "VNODE_HOOK",
  "DIRECTIVE_HOOK": 8,
  "8": "DIRECTIVE_HOOK",
  "TRANSITION_HOOK": 9,
  "9": "TRANSITION_HOOK",
  "APP_ERROR_HANDLER": 10,
  "10": "APP_ERROR_HANDLER",
  "APP_WARN_HANDLER": 11,
  "11": "APP_WARN_HANDLER",
  "FUNCTION_REF": 12,
  "12": "FUNCTION_REF",
  "ASYNC_COMPONENT_LOADER": 13,
  "13": "ASYNC_COMPONENT_LOADER",
  "SCHEDULER": 14,
  "14": "SCHEDULER",
  "COMPONENT_UPDATE": 15,
  "15": "COMPONENT_UPDATE",
  "APP_UNMOUNT_CLEANUP": 16,
  "16": "APP_UNMOUNT_CLEANUP"
};
const ErrorTypeStrings$1 = {
  ["sp"]: "serverPrefetch hook",
  ["bc"]: "beforeCreate hook",
  ["c"]: "created hook",
  ["bm"]: "beforeMount hook",
  ["m"]: "mounted hook",
  ["bu"]: "beforeUpdate hook",
  ["u"]: "updated",
  ["bum"]: "beforeUnmount hook",
  ["um"]: "unmounted hook",
  ["a"]: "activated hook",
  ["da"]: "deactivated hook",
  ["ec"]: "errorCaptured hook",
  ["rtc"]: "renderTracked hook",
  ["rtg"]: "renderTriggered hook",
  [0]: "setup function",
  [1]: "render function",
  [2]: "watcher getter",
  [3]: "watcher callback",
  [4]: "watcher cleanup function",
  [5]: "native event handler",
  [6]: "component event handler",
  [7]: "vnode hook",
  [8]: "directive hook",
  [9]: "transition hook",
  [10]: "app errorHandler",
  [11]: "app warnHandler",
  [12]: "ref function",
  [13]: "async component loader",
  [14]: "scheduler flush",
  [15]: "component update",
  [16]: "app unmount cleanup function"
};
function callWithErrorHandling(fn, instance, type, args) {
  try {
    return args ? fn(...args) : fn();
  } catch (err) {
    handleError(err, instance, type);
  }
}
function callWithAsyncErrorHandling(fn, instance, type, args) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(fn)) {
    const res = callWithErrorHandling(fn, instance, type, args);
    if (res && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isPromise)(res)) {
      res.catch((err) => {
        handleError(err, instance, type);
      });
    }
    return res;
  }
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(fn)) {
    const values = [];
    for (let i = 0; i < fn.length; i++) {
      values.push(callWithAsyncErrorHandling(fn[i], instance, type, args));
    }
    return values;
  } else if (true) {
    warn$1(
      `Invalid value type passed to callWithAsyncErrorHandling(): ${typeof fn}`
    );
  }
}
function handleError(err, instance, type, throwInDev = true) {
  const contextVNode = instance ? instance.vnode : null;
  const { errorHandler, throwUnhandledErrorInProduction } = instance && instance.appContext.config || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;
  if (instance) {
    let cur = instance.parent;
    const exposedInstance = instance.proxy;
    const errorInfo =  true ? ErrorTypeStrings$1[type] : 0;
    while (cur) {
      const errorCapturedHooks = cur.ec;
      if (errorCapturedHooks) {
        for (let i = 0; i < errorCapturedHooks.length; i++) {
          if (errorCapturedHooks[i](err, exposedInstance, errorInfo) === false) {
            return;
          }
        }
      }
      cur = cur.parent;
    }
    if (errorHandler) {
      (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();
      callWithErrorHandling(errorHandler, null, 10, [
        err,
        exposedInstance,
        errorInfo
      ]);
      (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();
      return;
    }
  }
  logError(err, type, contextVNode, throwInDev, throwUnhandledErrorInProduction);
}
function logError(err, type, contextVNode, throwInDev = true, throwInProd = false) {
  if (true) {
    const info = ErrorTypeStrings$1[type];
    if (contextVNode) {
      pushWarningContext(contextVNode);
    }
    warn$1(`Unhandled error${info ? ` during execution of ${info}` : ``}`);
    if (contextVNode) {
      popWarningContext();
    }
    if (throwInDev) {
      throw err;
    } else {
      console.error(err);
    }
  } else {}
}

const queue = [];
let flushIndex = -1;
const pendingPostFlushCbs = [];
let activePostFlushCbs = null;
let postFlushIndex = 0;
const resolvedPromise = /* @__PURE__ */ Promise.resolve();
let currentFlushPromise = null;
const RECURSION_LIMIT = 100;
function nextTick(fn) {
  const p = currentFlushPromise || resolvedPromise;
  return fn ? p.then(this ? fn.bind(this) : fn) : p;
}
function findInsertionIndex(id) {
  let start = flushIndex + 1;
  let end = queue.length;
  while (start < end) {
    const middle = start + end >>> 1;
    const middleJob = queue[middle];
    const middleJobId = getId(middleJob);
    if (middleJobId < id || middleJobId === id && middleJob.flags & 2) {
      start = middle + 1;
    } else {
      end = middle;
    }
  }
  return start;
}
function queueJob(job) {
  if (!(job.flags & 1)) {
    const jobId = getId(job);
    const lastJob = queue[queue.length - 1];
    if (!lastJob || // fast path when the job id is larger than the tail
    !(job.flags & 2) && jobId >= getId(lastJob)) {
      queue.push(job);
    } else {
      queue.splice(findInsertionIndex(jobId), 0, job);
    }
    job.flags |= 1;
    queueFlush();
  }
}
function queueFlush() {
  if (!currentFlushPromise) {
    currentFlushPromise = resolvedPromise.then(flushJobs);
  }
}
function queuePostFlushCb(cb) {
  if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(cb)) {
    if (activePostFlushCbs && cb.id === -1) {
      activePostFlushCbs.splice(postFlushIndex + 1, 0, cb);
    } else if (!(cb.flags & 1)) {
      pendingPostFlushCbs.push(cb);
      cb.flags |= 1;
    }
  } else {
    pendingPostFlushCbs.push(...cb);
  }
  queueFlush();
}
function flushPreFlushCbs(instance, seen, i = flushIndex + 1) {
  if (true) {
    seen = seen || /* @__PURE__ */ new Map();
  }
  for (; i < queue.length; i++) {
    const cb = queue[i];
    if (cb && cb.flags & 2) {
      if (instance && cb.id !== instance.uid) {
        continue;
      }
      if ( true && checkRecursiveUpdates(seen, cb)) {
        continue;
      }
      queue.splice(i, 1);
      i--;
      if (cb.flags & 4) {
        cb.flags &= -2;
      }
      cb();
      if (!(cb.flags & 4)) {
        cb.flags &= -2;
      }
    }
  }
}
function flushPostFlushCbs(seen) {
  if (pendingPostFlushCbs.length) {
    const deduped = [...new Set(pendingPostFlushCbs)].sort(
      (a, b) => getId(a) - getId(b)
    );
    pendingPostFlushCbs.length = 0;
    if (activePostFlushCbs) {
      activePostFlushCbs.push(...deduped);
      return;
    }
    activePostFlushCbs = deduped;
    if (true) {
      seen = seen || /* @__PURE__ */ new Map();
    }
    for (postFlushIndex = 0; postFlushIndex < activePostFlushCbs.length; postFlushIndex++) {
      const cb = activePostFlushCbs[postFlushIndex];
      if ( true && checkRecursiveUpdates(seen, cb)) {
        continue;
      }
      if (cb.flags & 4) {
        cb.flags &= -2;
      }
      if (!(cb.flags & 8)) cb();
      cb.flags &= -2;
    }
    activePostFlushCbs = null;
    postFlushIndex = 0;
  }
}
const getId = (job) => job.id == null ? job.flags & 2 ? -1 : Infinity : job.id;
function flushJobs(seen) {
  if (true) {
    seen = seen || /* @__PURE__ */ new Map();
  }
  const check =  true ? (job) => checkRecursiveUpdates(seen, job) : 0;
  try {
    for (flushIndex = 0; flushIndex < queue.length; flushIndex++) {
      const job = queue[flushIndex];
      if (job && !(job.flags & 8)) {
        if ( true && check(job)) {
          continue;
        }
        if (job.flags & 4) {
          job.flags &= ~1;
        }
        callWithErrorHandling(
          job,
          job.i,
          job.i ? 15 : 14
        );
        if (!(job.flags & 4)) {
          job.flags &= ~1;
        }
      }
    }
  } finally {
    for (; flushIndex < queue.length; flushIndex++) {
      const job = queue[flushIndex];
      if (job) {
        job.flags &= -2;
      }
    }
    flushIndex = -1;
    queue.length = 0;
    flushPostFlushCbs(seen);
    currentFlushPromise = null;
    if (queue.length || pendingPostFlushCbs.length) {
      flushJobs(seen);
    }
  }
}
function checkRecursiveUpdates(seen, fn) {
  const count = seen.get(fn) || 0;
  if (count > RECURSION_LIMIT) {
    const instance = fn.i;
    const componentName = instance && getComponentName(instance.type);
    handleError(
      `Maximum recursive updates exceeded${componentName ? ` in component <${componentName}>` : ``}. This means you have a reactive effect that is mutating its own dependencies and thus recursively triggering itself. Possible sources include component template, render function, updated hook or watcher source function.`,
      null,
      10
    );
    return true;
  }
  seen.set(fn, count + 1);
  return false;
}

let isHmrUpdating = false;
const hmrDirtyComponents = /* @__PURE__ */ new Map();
if (true) {
  (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.getGlobalThis)().__VUE_HMR_RUNTIME__ = {
    createRecord: tryWrap(createRecord),
    rerender: tryWrap(rerender),
    reload: tryWrap(reload)
  };
}
const map = /* @__PURE__ */ new Map();
function registerHMR(instance) {
  const id = instance.type.__hmrId;
  let record = map.get(id);
  if (!record) {
    createRecord(id, instance.type);
    record = map.get(id);
  }
  record.instances.add(instance);
}
function unregisterHMR(instance) {
  map.get(instance.type.__hmrId).instances.delete(instance);
}
function createRecord(id, initialDef) {
  if (map.has(id)) {
    return false;
  }
  map.set(id, {
    initialDef: normalizeClassComponent(initialDef),
    instances: /* @__PURE__ */ new Set()
  });
  return true;
}
function normalizeClassComponent(component) {
  return isClassComponent(component) ? component.__vccOpts : component;
}
function rerender(id, newRender) {
  const record = map.get(id);
  if (!record) {
    return;
  }
  record.initialDef.render = newRender;
  [...record.instances].forEach((instance) => {
    if (newRender) {
      instance.render = newRender;
      normalizeClassComponent(instance.type).render = newRender;
    }
    instance.renderCache = [];
    isHmrUpdating = true;
    instance.update();
    isHmrUpdating = false;
  });
}
function reload(id, newComp) {
  const record = map.get(id);
  if (!record) return;
  newComp = normalizeClassComponent(newComp);
  updateComponentDef(record.initialDef, newComp);
  const instances = [...record.instances];
  for (let i = 0; i < instances.length; i++) {
    const instance = instances[i];
    const oldComp = normalizeClassComponent(instance.type);
    let dirtyInstances = hmrDirtyComponents.get(oldComp);
    if (!dirtyInstances) {
      if (oldComp !== record.initialDef) {
        updateComponentDef(oldComp, newComp);
      }
      hmrDirtyComponents.set(oldComp, dirtyInstances = /* @__PURE__ */ new Set());
    }
    dirtyInstances.add(instance);
    instance.appContext.propsCache.delete(instance.type);
    instance.appContext.emitsCache.delete(instance.type);
    instance.appContext.optionsCache.delete(instance.type);
    if (instance.ceReload) {
      dirtyInstances.add(instance);
      instance.ceReload(newComp.styles);
      dirtyInstances.delete(instance);
    } else if (instance.parent) {
      queueJob(() => {
        isHmrUpdating = true;
        instance.parent.update();
        isHmrUpdating = false;
        dirtyInstances.delete(instance);
      });
    } else if (instance.appContext.reload) {
      instance.appContext.reload();
    } else if (typeof window !== "undefined") {
      window.location.reload();
    } else {
      console.warn(
        "[HMR] Root or manually mounted instance modified. Full reload required."
      );
    }
    if (instance.root.ce && instance !== instance.root) {
      instance.root.ce._removeChildStyle(oldComp);
    }
  }
  queuePostFlushCb(() => {
    hmrDirtyComponents.clear();
  });
}
function updateComponentDef(oldComp, newComp) {
  (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(oldComp, newComp);
  for (const key in oldComp) {
    if (key !== "__file" && !(key in newComp)) {
      delete oldComp[key];
    }
  }
}
function tryWrap(fn) {
  return (id, arg) => {
    try {
      return fn(id, arg);
    } catch (e) {
      console.error(e);
      console.warn(
        `[HMR] Something went wrong during Vue component hot-reload. Full reload required.`
      );
    }
  };
}

let devtools$1;
let buffer = [];
let devtoolsNotInstalled = false;
function emit$1(event, ...args) {
  if (devtools$1) {
    devtools$1.emit(event, ...args);
  } else if (!devtoolsNotInstalled) {
    buffer.push({ event, args });
  }
}
function setDevtoolsHook$1(hook, target) {
  var _a, _b;
  devtools$1 = hook;
  if (devtools$1) {
    devtools$1.enabled = true;
    buffer.forEach(({ event, args }) => devtools$1.emit(event, ...args));
    buffer = [];
  } else if (
    // handle late devtools injection - only do this if we are in an actual
    // browser environment to avoid the timer handle stalling test runner exit
    // (#4815)
    typeof window !== "undefined" && // some envs mock window but not fully
    window.HTMLElement && // also exclude jsdom
    // eslint-disable-next-line no-restricted-syntax
    !((_b = (_a = window.navigator) == null ? void 0 : _a.userAgent) == null ? void 0 : _b.includes("jsdom"))
  ) {
    const replay = target.__VUE_DEVTOOLS_HOOK_REPLAY__ = target.__VUE_DEVTOOLS_HOOK_REPLAY__ || [];
    replay.push((newHook) => {
      setDevtoolsHook$1(newHook, target);
    });
    setTimeout(() => {
      if (!devtools$1) {
        target.__VUE_DEVTOOLS_HOOK_REPLAY__ = null;
        devtoolsNotInstalled = true;
        buffer = [];
      }
    }, 3e3);
  } else {
    devtoolsNotInstalled = true;
    buffer = [];
  }
}
function devtoolsInitApp(app, version) {
  emit$1("app:init" /* APP_INIT */, app, version, {
    Fragment,
    Text,
    Comment,
    Static
  });
}
function devtoolsUnmountApp(app) {
  emit$1("app:unmount" /* APP_UNMOUNT */, app);
}
const devtoolsComponentAdded = /* @__PURE__ */ createDevtoolsComponentHook("component:added" /* COMPONENT_ADDED */);
const devtoolsComponentUpdated = /* @__PURE__ */ createDevtoolsComponentHook("component:updated" /* COMPONENT_UPDATED */);
const _devtoolsComponentRemoved = /* @__PURE__ */ createDevtoolsComponentHook(
  "component:removed" /* COMPONENT_REMOVED */
);
const devtoolsComponentRemoved = (component) => {
  if (devtools$1 && typeof devtools$1.cleanupBuffer === "function" && // remove the component if it wasn't buffered
  !devtools$1.cleanupBuffer(component)) {
    _devtoolsComponentRemoved(component);
  }
};
/*! #__NO_SIDE_EFFECTS__ */
// @__NO_SIDE_EFFECTS__
function createDevtoolsComponentHook(hook) {
  return (component) => {
    emit$1(
      hook,
      component.appContext.app,
      component.uid,
      component.parent ? component.parent.uid : void 0,
      component
    );
  };
}
const devtoolsPerfStart = /* @__PURE__ */ createDevtoolsPerformanceHook("perf:start" /* PERFORMANCE_START */);
const devtoolsPerfEnd = /* @__PURE__ */ createDevtoolsPerformanceHook("perf:end" /* PERFORMANCE_END */);
function createDevtoolsPerformanceHook(hook) {
  return (component, type, time) => {
    emit$1(hook, component.appContext.app, component.uid, component, type, time);
  };
}
function devtoolsComponentEmit(component, event, params) {
  emit$1(
    "component:emit" /* COMPONENT_EMIT */,
    component.appContext.app,
    component,
    event,
    params
  );
}

let currentRenderingInstance = null;
let currentScopeId = null;
function setCurrentRenderingInstance(instance) {
  const prev = currentRenderingInstance;
  currentRenderingInstance = instance;
  currentScopeId = instance && instance.type.__scopeId || null;
  return prev;
}
function pushScopeId(id) {
  currentScopeId = id;
}
function popScopeId() {
  currentScopeId = null;
}
const withScopeId = (_id) => withCtx;
function withCtx(fn, ctx = currentRenderingInstance, isNonScopedSlot) {
  if (!ctx) return fn;
  if (fn._n) {
    return fn;
  }
  const renderFnWithContext = (...args) => {
    if (renderFnWithContext._d) {
      setBlockTracking(-1);
    }
    const prevInstance = setCurrentRenderingInstance(ctx);
    let res;
    try {
      res = fn(...args);
    } finally {
      setCurrentRenderingInstance(prevInstance);
      if (renderFnWithContext._d) {
        setBlockTracking(1);
      }
    }
    if (true) {
      devtoolsComponentUpdated(ctx);
    }
    return res;
  };
  renderFnWithContext._n = true;
  renderFnWithContext._c = true;
  renderFnWithContext._d = true;
  return renderFnWithContext;
}

function validateDirectiveName(name) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isBuiltInDirective)(name)) {
    warn$1("Do not use built-in directive ids as custom directive id: " + name);
  }
}
function withDirectives(vnode, directives) {
  if (currentRenderingInstance === null) {
     true && warn$1(`withDirectives can only be used inside render functions.`);
    return vnode;
  }
  const instance = getComponentPublicInstance(currentRenderingInstance);
  const bindings = vnode.dirs || (vnode.dirs = []);
  for (let i = 0; i < directives.length; i++) {
    let [dir, value, arg, modifiers = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ] = directives[i];
    if (dir) {
      if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(dir)) {
        dir = {
          mounted: dir,
          updated: dir
        };
      }
      if (dir.deep) {
        (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.traverse)(value);
      }
      bindings.push({
        dir,
        instance,
        value,
        oldValue: void 0,
        arg,
        modifiers
      });
    }
  }
  return vnode;
}
function invokeDirectiveHook(vnode, prevVNode, instance, name) {
  const bindings = vnode.dirs;
  const oldBindings = prevVNode && prevVNode.dirs;
  for (let i = 0; i < bindings.length; i++) {
    const binding = bindings[i];
    if (oldBindings) {
      binding.oldValue = oldBindings[i].value;
    }
    let hook = binding.dir[name];
    if (hook) {
      (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();
      callWithAsyncErrorHandling(hook, instance, 8, [
        vnode.el,
        binding,
        vnode,
        prevVNode
      ]);
      (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();
    }
  }
}

const TeleportEndKey = Symbol("_vte");
const isTeleport = (type) => type.__isTeleport;
const isTeleportDisabled = (props) => props && (props.disabled || props.disabled === "");
const isTeleportDeferred = (props) => props && (props.defer || props.defer === "");
const isTargetSVG = (target) => typeof SVGElement !== "undefined" && target instanceof SVGElement;
const isTargetMathML = (target) => typeof MathMLElement === "function" && target instanceof MathMLElement;
const resolveTarget = (props, select) => {
  const targetSelector = props && props.to;
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(targetSelector)) {
    if (!select) {
       true && warn$1(
        `Current renderer does not support string target for Teleports. (missing querySelector renderer option)`
      );
      return null;
    } else {
      const target = select(targetSelector);
      if ( true && !target && !isTeleportDisabled(props)) {
        warn$1(
          `Failed to locate Teleport target with selector "${targetSelector}". Note the target element must exist before the component is mounted - i.e. the target cannot be rendered by the component itself, and ideally should be outside of the entire Vue component tree.`
        );
      }
      return target;
    }
  } else {
    if ( true && !targetSelector && !isTeleportDisabled(props)) {
      warn$1(`Invalid Teleport target: ${targetSelector}`);
    }
    return targetSelector;
  }
};
const TeleportImpl = {
  name: "Teleport",
  __isTeleport: true,
  process(n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized, internals) {
    const {
      mc: mountChildren,
      pc: patchChildren,
      pbc: patchBlockChildren,
      o: { insert, querySelector, createText, createComment }
    } = internals;
    const disabled = isTeleportDisabled(n2.props);
    let { shapeFlag, children, dynamicChildren } = n2;
    if ( true && isHmrUpdating) {
      optimized = false;
      dynamicChildren = null;
    }
    if (n1 == null) {
      const placeholder = n2.el =  true ? createComment("teleport start") : 0;
      const mainAnchor = n2.anchor =  true ? createComment("teleport end") : 0;
      insert(placeholder, container, anchor);
      insert(mainAnchor, container, anchor);
      const mount = (container2, anchor2) => {
        if (shapeFlag & 16) {
          if (parentComponent && parentComponent.isCE) {
            parentComponent.ce._teleportTarget = container2;
          }
          mountChildren(
            children,
            container2,
            anchor2,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
        }
      };
      const mountToTarget = () => {
        const target = n2.target = resolveTarget(n2.props, querySelector);
        const targetAnchor = prepareAnchor(target, n2, createText, insert);
        if (target) {
          if (namespace !== "svg" && isTargetSVG(target)) {
            namespace = "svg";
          } else if (namespace !== "mathml" && isTargetMathML(target)) {
            namespace = "mathml";
          }
          if (!disabled) {
            mount(target, targetAnchor);
            updateCssVars(n2, false);
          }
        } else if ( true && !disabled) {
          warn$1(
            "Invalid Teleport target on mount:",
            target,
            `(${typeof target})`
          );
        }
      };
      if (disabled) {
        mount(container, mainAnchor);
        updateCssVars(n2, true);
      }
      if (isTeleportDeferred(n2.props)) {
        n2.el.__isMounted = false;
        queuePostRenderEffect(() => {
          mountToTarget();
          delete n2.el.__isMounted;
        }, parentSuspense);
      } else {
        mountToTarget();
      }
    } else {
      if (isTeleportDeferred(n2.props) && n1.el.__isMounted === false) {
        queuePostRenderEffect(() => {
          TeleportImpl.process(
            n1,
            n2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized,
            internals
          );
        }, parentSuspense);
        return;
      }
      n2.el = n1.el;
      n2.targetStart = n1.targetStart;
      const mainAnchor = n2.anchor = n1.anchor;
      const target = n2.target = n1.target;
      const targetAnchor = n2.targetAnchor = n1.targetAnchor;
      const wasDisabled = isTeleportDisabled(n1.props);
      const currentContainer = wasDisabled ? container : target;
      const currentAnchor = wasDisabled ? mainAnchor : targetAnchor;
      if (namespace === "svg" || isTargetSVG(target)) {
        namespace = "svg";
      } else if (namespace === "mathml" || isTargetMathML(target)) {
        namespace = "mathml";
      }
      if (dynamicChildren) {
        patchBlockChildren(
          n1.dynamicChildren,
          dynamicChildren,
          currentContainer,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds
        );
        traverseStaticChildren(n1, n2, !!!("development " !== "production"));
      } else if (!optimized) {
        patchChildren(
          n1,
          n2,
          currentContainer,
          currentAnchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          false
        );
      }
      if (disabled) {
        if (!wasDisabled) {
          moveTeleport(
            n2,
            container,
            mainAnchor,
            internals,
            1
          );
        } else {
          if (n2.props && n1.props && n2.props.to !== n1.props.to) {
            n2.props.to = n1.props.to;
          }
        }
      } else {
        if ((n2.props && n2.props.to) !== (n1.props && n1.props.to)) {
          const nextTarget = n2.target = resolveTarget(
            n2.props,
            querySelector
          );
          if (nextTarget) {
            moveTeleport(
              n2,
              nextTarget,
              null,
              internals,
              0
            );
          } else if (true) {
            warn$1(
              "Invalid Teleport target on update:",
              target,
              `(${typeof target})`
            );
          }
        } else if (wasDisabled) {
          moveTeleport(
            n2,
            target,
            targetAnchor,
            internals,
            1
          );
        }
      }
      updateCssVars(n2, disabled);
    }
  },
  remove(vnode, parentComponent, parentSuspense, { um: unmount, o: { remove: hostRemove } }, doRemove) {
    const {
      shapeFlag,
      children,
      anchor,
      targetStart,
      targetAnchor,
      target,
      props
    } = vnode;
    if (target) {
      hostRemove(targetStart);
      hostRemove(targetAnchor);
    }
    doRemove && hostRemove(anchor);
    if (shapeFlag & 16) {
      const shouldRemove = doRemove || !isTeleportDisabled(props);
      for (let i = 0; i < children.length; i++) {
        const child = children[i];
        unmount(
          child,
          parentComponent,
          parentSuspense,
          shouldRemove,
          !!child.dynamicChildren
        );
      }
    }
  },
  move: moveTeleport,
  hydrate: hydrateTeleport
};
function moveTeleport(vnode, container, parentAnchor, { o: { insert }, m: move }, moveType = 2) {
  if (moveType === 0) {
    insert(vnode.targetAnchor, container, parentAnchor);
  }
  const { el, anchor, shapeFlag, children, props } = vnode;
  const isReorder = moveType === 2;
  if (isReorder) {
    insert(el, container, parentAnchor);
  }
  if (!isReorder || isTeleportDisabled(props)) {
    if (shapeFlag & 16) {
      for (let i = 0; i < children.length; i++) {
        move(
          children[i],
          container,
          parentAnchor,
          2
        );
      }
    }
  }
  if (isReorder) {
    insert(anchor, container, parentAnchor);
  }
}
function hydrateTeleport(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized, {
  o: { nextSibling, parentNode, querySelector, insert, createText }
}, hydrateChildren) {
  const target = vnode.target = resolveTarget(
    vnode.props,
    querySelector
  );
  if (target) {
    const disabled = isTeleportDisabled(vnode.props);
    const targetNode = target._lpa || target.firstChild;
    if (vnode.shapeFlag & 16) {
      if (disabled) {
        vnode.anchor = hydrateChildren(
          nextSibling(node),
          vnode,
          parentNode(node),
          parentComponent,
          parentSuspense,
          slotScopeIds,
          optimized
        );
        vnode.targetStart = targetNode;
        vnode.targetAnchor = targetNode && nextSibling(targetNode);
      } else {
        vnode.anchor = nextSibling(node);
        let targetAnchor = targetNode;
        while (targetAnchor) {
          if (targetAnchor && targetAnchor.nodeType === 8) {
            if (targetAnchor.data === "teleport start anchor") {
              vnode.targetStart = targetAnchor;
            } else if (targetAnchor.data === "teleport anchor") {
              vnode.targetAnchor = targetAnchor;
              target._lpa = vnode.targetAnchor && nextSibling(vnode.targetAnchor);
              break;
            }
          }
          targetAnchor = nextSibling(targetAnchor);
        }
        if (!vnode.targetAnchor) {
          prepareAnchor(target, vnode, createText, insert);
        }
        hydrateChildren(
          targetNode && nextSibling(targetNode),
          vnode,
          target,
          parentComponent,
          parentSuspense,
          slotScopeIds,
          optimized
        );
      }
    }
    updateCssVars(vnode, disabled);
  }
  return vnode.anchor && nextSibling(vnode.anchor);
}
const Teleport = TeleportImpl;
function updateCssVars(vnode, isDisabled) {
  const ctx = vnode.ctx;
  if (ctx && ctx.ut) {
    let node, anchor;
    if (isDisabled) {
      node = vnode.el;
      anchor = vnode.anchor;
    } else {
      node = vnode.targetStart;
      anchor = vnode.targetAnchor;
    }
    while (node && node !== anchor) {
      if (node.nodeType === 1) node.setAttribute("data-v-owner", ctx.uid);
      node = node.nextSibling;
    }
    ctx.ut();
  }
}
function prepareAnchor(target, vnode, createText, insert) {
  const targetStart = vnode.targetStart = createText("");
  const targetAnchor = vnode.targetAnchor = createText("");
  targetStart[TeleportEndKey] = targetAnchor;
  if (target) {
    insert(targetStart, target);
    insert(targetAnchor, target);
  }
  return targetAnchor;
}

const leaveCbKey = Symbol("_leaveCb");
const enterCbKey = Symbol("_enterCb");
function useTransitionState() {
  const state = {
    isMounted: false,
    isLeaving: false,
    isUnmounting: false,
    leavingVNodes: /* @__PURE__ */ new Map()
  };
  onMounted(() => {
    state.isMounted = true;
  });
  onBeforeUnmount(() => {
    state.isUnmounting = true;
  });
  return state;
}
const TransitionHookValidator = [Function, Array];
const BaseTransitionPropsValidators = {
  mode: String,
  appear: Boolean,
  persisted: Boolean,
  // enter
  onBeforeEnter: TransitionHookValidator,
  onEnter: TransitionHookValidator,
  onAfterEnter: TransitionHookValidator,
  onEnterCancelled: TransitionHookValidator,
  // leave
  onBeforeLeave: TransitionHookValidator,
  onLeave: TransitionHookValidator,
  onAfterLeave: TransitionHookValidator,
  onLeaveCancelled: TransitionHookValidator,
  // appear
  onBeforeAppear: TransitionHookValidator,
  onAppear: TransitionHookValidator,
  onAfterAppear: TransitionHookValidator,
  onAppearCancelled: TransitionHookValidator
};
const recursiveGetSubtree = (instance) => {
  const subTree = instance.subTree;
  return subTree.component ? recursiveGetSubtree(subTree.component) : subTree;
};
const BaseTransitionImpl = {
  name: `BaseTransition`,
  props: BaseTransitionPropsValidators,
  setup(props, { slots }) {
    const instance = getCurrentInstance();
    const state = useTransitionState();
    return () => {
      const children = slots.default && getTransitionRawChildren(slots.default(), true);
      if (!children || !children.length) {
        return;
      }
      const child = findNonCommentChild(children);
      const rawProps = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(props);
      const { mode } = rawProps;
      if ( true && mode && mode !== "in-out" && mode !== "out-in" && mode !== "default") {
        warn$1(`invalid <transition> mode: ${mode}`);
      }
      if (state.isLeaving) {
        return emptyPlaceholder(child);
      }
      const innerChild = getInnerChild$1(child);
      if (!innerChild) {
        return emptyPlaceholder(child);
      }
      let enterHooks = resolveTransitionHooks(
        innerChild,
        rawProps,
        state,
        instance,
        // #11061, ensure enterHooks is fresh after clone
        (hooks) => enterHooks = hooks
      );
      if (innerChild.type !== Comment) {
        setTransitionHooks(innerChild, enterHooks);
      }
      let oldInnerChild = instance.subTree && getInnerChild$1(instance.subTree);
      if (oldInnerChild && oldInnerChild.type !== Comment && !isSameVNodeType(innerChild, oldInnerChild) && recursiveGetSubtree(instance).type !== Comment) {
        let leavingHooks = resolveTransitionHooks(
          oldInnerChild,
          rawProps,
          state,
          instance
        );
        setTransitionHooks(oldInnerChild, leavingHooks);
        if (mode === "out-in" && innerChild.type !== Comment) {
          state.isLeaving = true;
          leavingHooks.afterLeave = () => {
            state.isLeaving = false;
            if (!(instance.job.flags & 8)) {
              instance.update();
            }
            delete leavingHooks.afterLeave;
            oldInnerChild = void 0;
          };
          return emptyPlaceholder(child);
        } else if (mode === "in-out" && innerChild.type !== Comment) {
          leavingHooks.delayLeave = (el, earlyRemove, delayedLeave) => {
            const leavingVNodesCache = getLeavingNodesForType(
              state,
              oldInnerChild
            );
            leavingVNodesCache[String(oldInnerChild.key)] = oldInnerChild;
            el[leaveCbKey] = () => {
              earlyRemove();
              el[leaveCbKey] = void 0;
              delete enterHooks.delayedLeave;
              oldInnerChild = void 0;
            };
            enterHooks.delayedLeave = () => {
              delayedLeave();
              delete enterHooks.delayedLeave;
              oldInnerChild = void 0;
            };
          };
        } else {
          oldInnerChild = void 0;
        }
      } else if (oldInnerChild) {
        oldInnerChild = void 0;
      }
      return child;
    };
  }
};
function findNonCommentChild(children) {
  let child = children[0];
  if (children.length > 1) {
    let hasFound = false;
    for (const c of children) {
      if (c.type !== Comment) {
        if ( true && hasFound) {
          warn$1(
            "<transition> can only be used on a single element or component. Use <transition-group> for lists."
          );
          break;
        }
        child = c;
        hasFound = true;
        if (false) {}
      }
    }
  }
  return child;
}
const BaseTransition = BaseTransitionImpl;
function getLeavingNodesForType(state, vnode) {
  const { leavingVNodes } = state;
  let leavingVNodesCache = leavingVNodes.get(vnode.type);
  if (!leavingVNodesCache) {
    leavingVNodesCache = /* @__PURE__ */ Object.create(null);
    leavingVNodes.set(vnode.type, leavingVNodesCache);
  }
  return leavingVNodesCache;
}
function resolveTransitionHooks(vnode, props, state, instance, postClone) {
  const {
    appear,
    mode,
    persisted = false,
    onBeforeEnter,
    onEnter,
    onAfterEnter,
    onEnterCancelled,
    onBeforeLeave,
    onLeave,
    onAfterLeave,
    onLeaveCancelled,
    onBeforeAppear,
    onAppear,
    onAfterAppear,
    onAppearCancelled
  } = props;
  const key = String(vnode.key);
  const leavingVNodesCache = getLeavingNodesForType(state, vnode);
  const callHook = (hook, args) => {
    hook && callWithAsyncErrorHandling(
      hook,
      instance,
      9,
      args
    );
  };
  const callAsyncHook = (hook, args) => {
    const done = args[1];
    callHook(hook, args);
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(hook)) {
      if (hook.every((hook2) => hook2.length <= 1)) done();
    } else if (hook.length <= 1) {
      done();
    }
  };
  const hooks = {
    mode,
    persisted,
    beforeEnter(el) {
      let hook = onBeforeEnter;
      if (!state.isMounted) {
        if (appear) {
          hook = onBeforeAppear || onBeforeEnter;
        } else {
          return;
        }
      }
      if (el[leaveCbKey]) {
        el[leaveCbKey](
          true
          /* cancelled */
        );
      }
      const leavingVNode = leavingVNodesCache[key];
      if (leavingVNode && isSameVNodeType(vnode, leavingVNode) && leavingVNode.el[leaveCbKey]) {
        leavingVNode.el[leaveCbKey]();
      }
      callHook(hook, [el]);
    },
    enter(el) {
      let hook = onEnter;
      let afterHook = onAfterEnter;
      let cancelHook = onEnterCancelled;
      if (!state.isMounted) {
        if (appear) {
          hook = onAppear || onEnter;
          afterHook = onAfterAppear || onAfterEnter;
          cancelHook = onAppearCancelled || onEnterCancelled;
        } else {
          return;
        }
      }
      let called = false;
      const done = el[enterCbKey] = (cancelled) => {
        if (called) return;
        called = true;
        if (cancelled) {
          callHook(cancelHook, [el]);
        } else {
          callHook(afterHook, [el]);
        }
        if (hooks.delayedLeave) {
          hooks.delayedLeave();
        }
        el[enterCbKey] = void 0;
      };
      if (hook) {
        callAsyncHook(hook, [el, done]);
      } else {
        done();
      }
    },
    leave(el, remove) {
      const key2 = String(vnode.key);
      if (el[enterCbKey]) {
        el[enterCbKey](
          true
          /* cancelled */
        );
      }
      if (state.isUnmounting) {
        return remove();
      }
      callHook(onBeforeLeave, [el]);
      let called = false;
      const done = el[leaveCbKey] = (cancelled) => {
        if (called) return;
        called = true;
        remove();
        if (cancelled) {
          callHook(onLeaveCancelled, [el]);
        } else {
          callHook(onAfterLeave, [el]);
        }
        el[leaveCbKey] = void 0;
        if (leavingVNodesCache[key2] === vnode) {
          delete leavingVNodesCache[key2];
        }
      };
      leavingVNodesCache[key2] = vnode;
      if (onLeave) {
        callAsyncHook(onLeave, [el, done]);
      } else {
        done();
      }
    },
    clone(vnode2) {
      const hooks2 = resolveTransitionHooks(
        vnode2,
        props,
        state,
        instance,
        postClone
      );
      if (postClone) postClone(hooks2);
      return hooks2;
    }
  };
  return hooks;
}
function emptyPlaceholder(vnode) {
  if (isKeepAlive(vnode)) {
    vnode = cloneVNode(vnode);
    vnode.children = null;
    return vnode;
  }
}
function getInnerChild$1(vnode) {
  if (!isKeepAlive(vnode)) {
    if (isTeleport(vnode.type) && vnode.children) {
      return findNonCommentChild(vnode.children);
    }
    return vnode;
  }
  if (vnode.component) {
    return vnode.component.subTree;
  }
  const { shapeFlag, children } = vnode;
  if (children) {
    if (shapeFlag & 16) {
      return children[0];
    }
    if (shapeFlag & 32 && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(children.default)) {
      return children.default();
    }
  }
}
function setTransitionHooks(vnode, hooks) {
  if (vnode.shapeFlag & 6 && vnode.component) {
    vnode.transition = hooks;
    setTransitionHooks(vnode.component.subTree, hooks);
  } else if (vnode.shapeFlag & 128) {
    vnode.ssContent.transition = hooks.clone(vnode.ssContent);
    vnode.ssFallback.transition = hooks.clone(vnode.ssFallback);
  } else {
    vnode.transition = hooks;
  }
}
function getTransitionRawChildren(children, keepComment = false, parentKey) {
  let ret = [];
  let keyedFragmentCount = 0;
  for (let i = 0; i < children.length; i++) {
    let child = children[i];
    const key = parentKey == null ? child.key : String(parentKey) + String(child.key != null ? child.key : i);
    if (child.type === Fragment) {
      if (child.patchFlag & 128) keyedFragmentCount++;
      ret = ret.concat(
        getTransitionRawChildren(child.children, keepComment, key)
      );
    } else if (keepComment || child.type !== Comment) {
      ret.push(key != null ? cloneVNode(child, { key }) : child);
    }
  }
  if (keyedFragmentCount > 1) {
    for (let i = 0; i < ret.length; i++) {
      ret[i].patchFlag = -2;
    }
  }
  return ret;
}

/*! #__NO_SIDE_EFFECTS__ */
// @__NO_SIDE_EFFECTS__
function defineComponent(options, extraOptions) {
  return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(options) ? (
    // #8236: extend call and options.name access are considered side-effects
    // by Rollup, so we have to wrap it in a pure-annotated IIFE.
    /* @__PURE__ */ (() => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({ name: options.name }, extraOptions, { setup: options }))()
  ) : options;
}

function useId() {
  const i = getCurrentInstance();
  if (i) {
    return (i.appContext.config.idPrefix || "v") + "-" + i.ids[0] + i.ids[1]++;
  } else if (true) {
    warn$1(
      `useId() is called when there is no active component instance to be associated with.`
    );
  }
  return "";
}
function markAsyncBoundary(instance) {
  instance.ids = [instance.ids[0] + instance.ids[2]++ + "-", 0, 0];
}

const knownTemplateRefs = /* @__PURE__ */ new WeakSet();
function useTemplateRef(key) {
  const i = getCurrentInstance();
  const r = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowRef)(null);
  if (i) {
    const refs = i.refs === _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ ? i.refs = {} : i.refs;
    let desc;
    if ( true && (desc = Object.getOwnPropertyDescriptor(refs, key)) && !desc.configurable) {
      warn$1(`useTemplateRef('${key}') already exists.`);
    } else {
      Object.defineProperty(refs, key, {
        enumerable: true,
        get: () => r.value,
        set: (val) => r.value = val
      });
    }
  } else if (true) {
    warn$1(
      `useTemplateRef() is called when there is no active component instance to be associated with.`
    );
  }
  const ret =  true ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.readonly)(r) : 0;
  if (true) {
    knownTemplateRefs.add(ret);
  }
  return ret;
}

function setRef(rawRef, oldRawRef, parentSuspense, vnode, isUnmount = false) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(rawRef)) {
    rawRef.forEach(
      (r, i) => setRef(
        r,
        oldRawRef && ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(oldRawRef) ? oldRawRef[i] : oldRawRef),
        parentSuspense,
        vnode,
        isUnmount
      )
    );
    return;
  }
  if (isAsyncWrapper(vnode) && !isUnmount) {
    if (vnode.shapeFlag & 512 && vnode.type.__asyncResolved && vnode.component.subTree.component) {
      setRef(rawRef, oldRawRef, parentSuspense, vnode.component.subTree);
    }
    return;
  }
  const refValue = vnode.shapeFlag & 4 ? getComponentPublicInstance(vnode.component) : vnode.el;
  const value = isUnmount ? null : refValue;
  const { i: owner, r: ref } = rawRef;
  if ( true && !owner) {
    warn$1(
      `Missing ref owner context. ref cannot be used on hoisted vnodes. A vnode with ref must be created inside the render function.`
    );
    return;
  }
  const oldRef = oldRawRef && oldRawRef.r;
  const refs = owner.refs === _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ ? owner.refs = {} : owner.refs;
  const setupState = owner.setupState;
  const rawSetupState = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(setupState);
  const canSetSetupRef = setupState === _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ ? () => false : (key) => {
    if (true) {
      if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(rawSetupState, key) && !(0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(rawSetupState[key])) {
        warn$1(
          `Template ref "${key}" used on a non-ref value. It will not work in the production build.`
        );
      }
      if (knownTemplateRefs.has(rawSetupState[key])) {
        return false;
      }
    }
    return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(rawSetupState, key);
  };
  if (oldRef != null && oldRef !== ref) {
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(oldRef)) {
      refs[oldRef] = null;
      if (canSetSetupRef(oldRef)) {
        setupState[oldRef] = null;
      }
    } else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(oldRef)) {
      oldRef.value = null;
    }
  }
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(ref)) {
    callWithErrorHandling(ref, owner, 12, [value, refs]);
  } else {
    const _isString = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(ref);
    const _isRef = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(ref);
    if (_isString || _isRef) {
      const doSet = () => {
        if (rawRef.f) {
          const existing = _isString ? canSetSetupRef(ref) ? setupState[ref] : refs[ref] : ref.value;
          if (isUnmount) {
            (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(existing) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.remove)(existing, refValue);
          } else {
            if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(existing)) {
              if (_isString) {
                refs[ref] = [refValue];
                if (canSetSetupRef(ref)) {
                  setupState[ref] = refs[ref];
                }
              } else {
                ref.value = [refValue];
                if (rawRef.k) refs[rawRef.k] = ref.value;
              }
            } else if (!existing.includes(refValue)) {
              existing.push(refValue);
            }
          }
        } else if (_isString) {
          refs[ref] = value;
          if (canSetSetupRef(ref)) {
            setupState[ref] = value;
          }
        } else if (_isRef) {
          ref.value = value;
          if (rawRef.k) refs[rawRef.k] = value;
        } else if (true) {
          warn$1("Invalid template ref type:", ref, `(${typeof ref})`);
        }
      };
      if (value) {
        doSet.id = -1;
        queuePostRenderEffect(doSet, parentSuspense);
      } else {
        doSet();
      }
    } else if (true) {
      warn$1("Invalid template ref type:", ref, `(${typeof ref})`);
    }
  }
}

let hasLoggedMismatchError = false;
const logMismatchError = () => {
  if (hasLoggedMismatchError) {
    return;
  }
  console.error("Hydration completed but contains mismatches.");
  hasLoggedMismatchError = true;
};
const isSVGContainer = (container) => container.namespaceURI.includes("svg") && container.tagName !== "foreignObject";
const isMathMLContainer = (container) => container.namespaceURI.includes("MathML");
const getContainerType = (container) => {
  if (container.nodeType !== 1) return void 0;
  if (isSVGContainer(container)) return "svg";
  if (isMathMLContainer(container)) return "mathml";
  return void 0;
};
const isComment = (node) => node.nodeType === 8;
function createHydrationFunctions(rendererInternals) {
  const {
    mt: mountComponent,
    p: patch,
    o: {
      patchProp,
      createText,
      nextSibling,
      parentNode,
      remove,
      insert,
      createComment
    }
  } = rendererInternals;
  const hydrate = (vnode, container) => {
    if (!container.hasChildNodes()) {
      ( true) && warn$1(
        `Attempting to hydrate existing markup but container is empty. Performing full mount instead.`
      );
      patch(null, vnode, container);
      flushPostFlushCbs();
      container._vnode = vnode;
      return;
    }
    hydrateNode(container.firstChild, vnode, null, null, null);
    flushPostFlushCbs();
    container._vnode = vnode;
  };
  const hydrateNode = (node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized = false) => {
    optimized = optimized || !!vnode.dynamicChildren;
    const isFragmentStart = isComment(node) && node.data === "[";
    const onMismatch = () => handleMismatch(
      node,
      vnode,
      parentComponent,
      parentSuspense,
      slotScopeIds,
      isFragmentStart
    );
    const { type, ref, shapeFlag, patchFlag } = vnode;
    let domType = node.nodeType;
    vnode.el = node;
    if (true) {
      (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.def)(node, "__vnode", vnode, true);
      (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.def)(node, "__vueParentComponent", parentComponent, true);
    }
    if (patchFlag === -2) {
      optimized = false;
      vnode.dynamicChildren = null;
    }
    let nextNode = null;
    switch (type) {
      case Text:
        if (domType !== 3) {
          if (vnode.children === "") {
            insert(vnode.el = createText(""), parentNode(node), node);
            nextNode = node;
          } else {
            nextNode = onMismatch();
          }
        } else {
          if (node.data !== vnode.children) {
            ( true) && warn$1(
              `Hydration text mismatch in`,
              node.parentNode,
              `
  - rendered on server: ${JSON.stringify(
                node.data
              )}
  - expected on client: ${JSON.stringify(vnode.children)}`
            );
            logMismatchError();
            node.data = vnode.children;
          }
          nextNode = nextSibling(node);
        }
        break;
      case Comment:
        if (isTemplateNode(node)) {
          nextNode = nextSibling(node);
          replaceNode(
            vnode.el = node.content.firstChild,
            node,
            parentComponent
          );
        } else if (domType !== 8 || isFragmentStart) {
          nextNode = onMismatch();
        } else {
          nextNode = nextSibling(node);
        }
        break;
      case Static:
        if (isFragmentStart) {
          node = nextSibling(node);
          domType = node.nodeType;
        }
        if (domType === 1 || domType === 3) {
          nextNode = node;
          const needToAdoptContent = !vnode.children.length;
          for (let i = 0; i < vnode.staticCount; i++) {
            if (needToAdoptContent)
              vnode.children += nextNode.nodeType === 1 ? nextNode.outerHTML : nextNode.data;
            if (i === vnode.staticCount - 1) {
              vnode.anchor = nextNode;
            }
            nextNode = nextSibling(nextNode);
          }
          return isFragmentStart ? nextSibling(nextNode) : nextNode;
        } else {
          onMismatch();
        }
        break;
      case Fragment:
        if (!isFragmentStart) {
          nextNode = onMismatch();
        } else {
          nextNode = hydrateFragment(
            node,
            vnode,
            parentComponent,
            parentSuspense,
            slotScopeIds,
            optimized
          );
        }
        break;
      default:
        if (shapeFlag & 1) {
          if ((domType !== 1 || vnode.type.toLowerCase() !== node.tagName.toLowerCase()) && !isTemplateNode(node)) {
            nextNode = onMismatch();
          } else {
            nextNode = hydrateElement(
              node,
              vnode,
              parentComponent,
              parentSuspense,
              slotScopeIds,
              optimized
            );
          }
        } else if (shapeFlag & 6) {
          vnode.slotScopeIds = slotScopeIds;
          const container = parentNode(node);
          if (isFragmentStart) {
            nextNode = locateClosingAnchor(node);
          } else if (isComment(node) && node.data === "teleport start") {
            nextNode = locateClosingAnchor(node, node.data, "teleport end");
          } else {
            nextNode = nextSibling(node);
          }
          mountComponent(
            vnode,
            container,
            null,
            parentComponent,
            parentSuspense,
            getContainerType(container),
            optimized
          );
          if (isAsyncWrapper(vnode) && !vnode.type.__asyncResolved) {
            let subTree;
            if (isFragmentStart) {
              subTree = createVNode(Fragment);
              subTree.anchor = nextNode ? nextNode.previousSibling : container.lastChild;
            } else {
              subTree = node.nodeType === 3 ? createTextVNode("") : createVNode("div");
            }
            subTree.el = node;
            vnode.component.subTree = subTree;
          }
        } else if (shapeFlag & 64) {
          if (domType !== 8) {
            nextNode = onMismatch();
          } else {
            nextNode = vnode.type.hydrate(
              node,
              vnode,
              parentComponent,
              parentSuspense,
              slotScopeIds,
              optimized,
              rendererInternals,
              hydrateChildren
            );
          }
        } else if (shapeFlag & 128) {
          nextNode = vnode.type.hydrate(
            node,
            vnode,
            parentComponent,
            parentSuspense,
            getContainerType(parentNode(node)),
            slotScopeIds,
            optimized,
            rendererInternals,
            hydrateNode
          );
        } else if (true) {
          warn$1("Invalid HostVNode type:", type, `(${typeof type})`);
        }
    }
    if (ref != null) {
      setRef(ref, null, parentSuspense, vnode);
    }
    return nextNode;
  };
  const hydrateElement = (el, vnode, parentComponent, parentSuspense, slotScopeIds, optimized) => {
    optimized = optimized || !!vnode.dynamicChildren;
    const { type, props, patchFlag, shapeFlag, dirs, transition } = vnode;
    const forcePatch = type === "input" || type === "option";
    if (true) {
      if (dirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "created");
      }
      let needCallTransitionHooks = false;
      if (isTemplateNode(el)) {
        needCallTransitionHooks = needTransition(
          null,
          // no need check parentSuspense in hydration
          transition
        ) && parentComponent && parentComponent.vnode.props && parentComponent.vnode.props.appear;
        const content = el.content.firstChild;
        if (needCallTransitionHooks) {
          const cls = content.getAttribute("class");
          if (cls) content.$cls = cls;
          transition.beforeEnter(content);
        }
        replaceNode(content, el, parentComponent);
        vnode.el = el = content;
      }
      if (shapeFlag & 16 && // skip if element has innerHTML / textContent
      !(props && (props.innerHTML || props.textContent))) {
        let next = hydrateChildren(
          el.firstChild,
          vnode,
          el,
          parentComponent,
          parentSuspense,
          slotScopeIds,
          optimized
        );
        let hasWarned = false;
        while (next) {
          if (!isMismatchAllowed(el, 1 /* CHILDREN */)) {
            if (( true) && !hasWarned) {
              warn$1(
                `Hydration children mismatch on`,
                el,
                `
Server rendered element contains more child nodes than client vdom.`
              );
              hasWarned = true;
            }
            logMismatchError();
          }
          const cur = next;
          next = next.nextSibling;
          remove(cur);
        }
      } else if (shapeFlag & 8) {
        let clientText = vnode.children;
        if (clientText[0] === "\n" && (el.tagName === "PRE" || el.tagName === "TEXTAREA")) {
          clientText = clientText.slice(1);
        }
        if (el.textContent !== clientText) {
          if (!isMismatchAllowed(el, 0 /* TEXT */)) {
            ( true) && warn$1(
              `Hydration text content mismatch on`,
              el,
              `
  - rendered on server: ${el.textContent}
  - expected on client: ${vnode.children}`
            );
            logMismatchError();
          }
          el.textContent = vnode.children;
        }
      }
      if (props) {
        if (true) {
          const isCustomElement = el.tagName.includes("-");
          for (const key in props) {
            if (( true) && // #11189 skip if this node has directives that have created hooks
            // as it could have mutated the DOM in any possible way
            !(dirs && dirs.some((d) => d.dir.created)) && propHasMismatch(el, key, props[key], vnode, parentComponent)) {
              logMismatchError();
            }
            if (forcePatch && (key.endsWith("value") || key === "indeterminate") || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isOn)(key) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isReservedProp)(key) || // force hydrate v-bind with .prop modifiers
            key[0] === "." || isCustomElement) {
              patchProp(el, key, null, props[key], void 0, parentComponent);
            }
          }
        } else {}
      }
      let vnodeHooks;
      if (vnodeHooks = props && props.onVnodeBeforeMount) {
        invokeVNodeHook(vnodeHooks, parentComponent, vnode);
      }
      if (dirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "beforeMount");
      }
      if ((vnodeHooks = props && props.onVnodeMounted) || dirs || needCallTransitionHooks) {
        queueEffectWithSuspense(() => {
          vnodeHooks && invokeVNodeHook(vnodeHooks, parentComponent, vnode);
          needCallTransitionHooks && transition.enter(el);
          dirs && invokeDirectiveHook(vnode, null, parentComponent, "mounted");
        }, parentSuspense);
      }
    }
    return el.nextSibling;
  };
  const hydrateChildren = (node, parentVNode, container, parentComponent, parentSuspense, slotScopeIds, optimized) => {
    optimized = optimized || !!parentVNode.dynamicChildren;
    const children = parentVNode.children;
    const l = children.length;
    let hasWarned = false;
    for (let i = 0; i < l; i++) {
      const vnode = optimized ? children[i] : children[i] = normalizeVNode(children[i]);
      const isText = vnode.type === Text;
      if (node) {
        if (isText && !optimized) {
          if (i + 1 < l && normalizeVNode(children[i + 1]).type === Text) {
            insert(
              createText(
                node.data.slice(vnode.children.length)
              ),
              container,
              nextSibling(node)
            );
            node.data = vnode.children;
          }
        }
        node = hydrateNode(
          node,
          vnode,
          parentComponent,
          parentSuspense,
          slotScopeIds,
          optimized
        );
      } else if (isText && !vnode.children) {
        insert(vnode.el = createText(""), container);
      } else {
        if (!isMismatchAllowed(container, 1 /* CHILDREN */)) {
          if (( true) && !hasWarned) {
            warn$1(
              `Hydration children mismatch on`,
              container,
              `
Server rendered element contains fewer child nodes than client vdom.`
            );
            hasWarned = true;
          }
          logMismatchError();
        }
        patch(
          null,
          vnode,
          container,
          null,
          parentComponent,
          parentSuspense,
          getContainerType(container),
          slotScopeIds
        );
      }
    }
    return node;
  };
  const hydrateFragment = (node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized) => {
    const { slotScopeIds: fragmentSlotScopeIds } = vnode;
    if (fragmentSlotScopeIds) {
      slotScopeIds = slotScopeIds ? slotScopeIds.concat(fragmentSlotScopeIds) : fragmentSlotScopeIds;
    }
    const container = parentNode(node);
    const next = hydrateChildren(
      nextSibling(node),
      vnode,
      container,
      parentComponent,
      parentSuspense,
      slotScopeIds,
      optimized
    );
    if (next && isComment(next) && next.data === "]") {
      return nextSibling(vnode.anchor = next);
    } else {
      logMismatchError();
      insert(vnode.anchor = createComment(`]`), container, next);
      return next;
    }
  };
  const handleMismatch = (node, vnode, parentComponent, parentSuspense, slotScopeIds, isFragment) => {
    if (!isMismatchAllowed(node.parentElement, 1 /* CHILDREN */)) {
      ( true) && warn$1(
        `Hydration node mismatch:
- rendered on server:`,
        node,
        node.nodeType === 3 ? `(text)` : isComment(node) && node.data === "[" ? `(start of fragment)` : ``,
        `
- expected on client:`,
        vnode.type
      );
      logMismatchError();
    }
    vnode.el = null;
    if (isFragment) {
      const end = locateClosingAnchor(node);
      while (true) {
        const next2 = nextSibling(node);
        if (next2 && next2 !== end) {
          remove(next2);
        } else {
          break;
        }
      }
    }
    const next = nextSibling(node);
    const container = parentNode(node);
    remove(node);
    patch(
      null,
      vnode,
      container,
      next,
      parentComponent,
      parentSuspense,
      getContainerType(container),
      slotScopeIds
    );
    if (parentComponent) {
      parentComponent.vnode.el = vnode.el;
      updateHOCHostEl(parentComponent, vnode.el);
    }
    return next;
  };
  const locateClosingAnchor = (node, open = "[", close = "]") => {
    let match = 0;
    while (node) {
      node = nextSibling(node);
      if (node && isComment(node)) {
        if (node.data === open) match++;
        if (node.data === close) {
          if (match === 0) {
            return nextSibling(node);
          } else {
            match--;
          }
        }
      }
    }
    return node;
  };
  const replaceNode = (newNode, oldNode, parentComponent) => {
    const parentNode2 = oldNode.parentNode;
    if (parentNode2) {
      parentNode2.replaceChild(newNode, oldNode);
    }
    let parent = parentComponent;
    while (parent) {
      if (parent.vnode.el === oldNode) {
        parent.vnode.el = parent.subTree.el = newNode;
      }
      parent = parent.parent;
    }
  };
  const isTemplateNode = (node) => {
    return node.nodeType === 1 && node.tagName === "TEMPLATE";
  };
  return [hydrate, hydrateNode];
}
function propHasMismatch(el, key, clientValue, vnode, instance) {
  let mismatchType;
  let mismatchKey;
  let actual;
  let expected;
  if (key === "class") {
    if (el.$cls) {
      actual = el.$cls;
      delete el.$cls;
    } else {
      actual = el.getAttribute("class");
    }
    expected = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeClass)(clientValue);
    if (!isSetEqual(toClassSet(actual || ""), toClassSet(expected))) {
      mismatchType = 2 /* CLASS */;
      mismatchKey = `class`;
    }
  } else if (key === "style") {
    actual = el.getAttribute("style") || "";
    expected = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(clientValue) ? clientValue : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.stringifyStyle)((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeStyle)(clientValue));
    const actualMap = toStyleMap(actual);
    const expectedMap = toStyleMap(expected);
    if (vnode.dirs) {
      for (const { dir, value } of vnode.dirs) {
        if (dir.name === "show" && !value) {
          expectedMap.set("display", "none");
        }
      }
    }
    if (instance) {
      resolveCssVars(instance, vnode, expectedMap);
    }
    if (!isMapEqual(actualMap, expectedMap)) {
      mismatchType = 3 /* STYLE */;
      mismatchKey = "style";
    }
  } else if (el instanceof SVGElement && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isKnownSvgAttr)(key) || el instanceof HTMLElement && ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isBooleanAttr)(key) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isKnownHtmlAttr)(key))) {
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isBooleanAttr)(key)) {
      actual = el.hasAttribute(key);
      expected = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.includeBooleanAttr)(clientValue);
    } else if (clientValue == null) {
      actual = el.hasAttribute(key);
      expected = false;
    } else {
      if (el.hasAttribute(key)) {
        actual = el.getAttribute(key);
      } else if (key === "value" && el.tagName === "TEXTAREA") {
        actual = el.value;
      } else {
        actual = false;
      }
      expected = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isRenderableAttrValue)(clientValue) ? String(clientValue) : false;
    }
    if (actual !== expected) {
      mismatchType = 4 /* ATTRIBUTE */;
      mismatchKey = key;
    }
  }
  if (mismatchType != null && !isMismatchAllowed(el, mismatchType)) {
    const format = (v) => v === false ? `(not rendered)` : `${mismatchKey}="${v}"`;
    const preSegment = `Hydration ${MismatchTypeString[mismatchType]} mismatch on`;
    const postSegment = `
  - rendered on server: ${format(actual)}
  - expected on client: ${format(expected)}
  Note: this mismatch is check-only. The DOM will not be rectified in production due to performance overhead.
  You should fix the source of the mismatch.`;
    {
      warn$1(preSegment, el, postSegment);
    }
    return true;
  }
  return false;
}
function toClassSet(str) {
  return new Set(str.trim().split(/\s+/));
}
function isSetEqual(a, b) {
  if (a.size !== b.size) {
    return false;
  }
  for (const s of a) {
    if (!b.has(s)) {
      return false;
    }
  }
  return true;
}
function toStyleMap(str) {
  const styleMap = /* @__PURE__ */ new Map();
  for (const item of str.split(";")) {
    let [key, value] = item.split(":");
    key = key.trim();
    value = value && value.trim();
    if (key && value) {
      styleMap.set(key, value);
    }
  }
  return styleMap;
}
function isMapEqual(a, b) {
  if (a.size !== b.size) {
    return false;
  }
  for (const [key, value] of a) {
    if (value !== b.get(key)) {
      return false;
    }
  }
  return true;
}
function resolveCssVars(instance, vnode, expectedMap) {
  const root = instance.subTree;
  if (instance.getCssVars && (vnode === root || root && root.type === Fragment && root.children.includes(vnode))) {
    const cssVars = instance.getCssVars();
    for (const key in cssVars) {
      expectedMap.set(
        `--${(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.getEscapedCssVarName)(key, false)}`,
        String(cssVars[key])
      );
    }
  }
  if (vnode === root && instance.parent) {
    resolveCssVars(instance.parent, instance.vnode, expectedMap);
  }
}
const allowMismatchAttr = "data-allow-mismatch";
const MismatchTypeString = {
  [0 /* TEXT */]: "text",
  [1 /* CHILDREN */]: "children",
  [2 /* CLASS */]: "class",
  [3 /* STYLE */]: "style",
  [4 /* ATTRIBUTE */]: "attribute"
};
function isMismatchAllowed(el, allowedType) {
  if (allowedType === 0 /* TEXT */ || allowedType === 1 /* CHILDREN */) {
    while (el && !el.hasAttribute(allowMismatchAttr)) {
      el = el.parentElement;
    }
  }
  const allowedAttr = el && el.getAttribute(allowMismatchAttr);
  if (allowedAttr == null) {
    return false;
  } else if (allowedAttr === "") {
    return true;
  } else {
    const list = allowedAttr.split(",");
    if (allowedType === 0 /* TEXT */ && list.includes("children")) {
      return true;
    }
    return allowedAttr.split(",").includes(MismatchTypeString[allowedType]);
  }
}

const requestIdleCallback = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.getGlobalThis)().requestIdleCallback || ((cb) => setTimeout(cb, 1));
const cancelIdleCallback = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.getGlobalThis)().cancelIdleCallback || ((id) => clearTimeout(id));
const hydrateOnIdle = (timeout = 1e4) => (hydrate) => {
  const id = requestIdleCallback(hydrate, { timeout });
  return () => cancelIdleCallback(id);
};
function elementIsVisibleInViewport(el) {
  const { top, left, bottom, right } = el.getBoundingClientRect();
  const { innerHeight, innerWidth } = window;
  return (top > 0 && top < innerHeight || bottom > 0 && bottom < innerHeight) && (left > 0 && left < innerWidth || right > 0 && right < innerWidth);
}
const hydrateOnVisible = (opts) => (hydrate, forEach) => {
  const ob = new IntersectionObserver((entries) => {
    for (const e of entries) {
      if (!e.isIntersecting) continue;
      ob.disconnect();
      hydrate();
      break;
    }
  }, opts);
  forEach((el) => {
    if (!(el instanceof Element)) return;
    if (elementIsVisibleInViewport(el)) {
      hydrate();
      ob.disconnect();
      return false;
    }
    ob.observe(el);
  });
  return () => ob.disconnect();
};
const hydrateOnMediaQuery = (query) => (hydrate) => {
  if (query) {
    const mql = matchMedia(query);
    if (mql.matches) {
      hydrate();
    } else {
      mql.addEventListener("change", hydrate, { once: true });
      return () => mql.removeEventListener("change", hydrate);
    }
  }
};
const hydrateOnInteraction = (interactions = []) => (hydrate, forEach) => {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(interactions)) interactions = [interactions];
  let hasHydrated = false;
  const doHydrate = (e) => {
    if (!hasHydrated) {
      hasHydrated = true;
      teardown();
      hydrate();
      e.target.dispatchEvent(new e.constructor(e.type, e));
    }
  };
  const teardown = () => {
    forEach((el) => {
      for (const i of interactions) {
        el.removeEventListener(i, doHydrate);
      }
    });
  };
  forEach((el) => {
    for (const i of interactions) {
      el.addEventListener(i, doHydrate, { once: true });
    }
  });
  return teardown;
};
function forEachElement(node, cb) {
  if (isComment(node) && node.data === "[") {
    let depth = 1;
    let next = node.nextSibling;
    while (next) {
      if (next.nodeType === 1) {
        const result = cb(next);
        if (result === false) {
          break;
        }
      } else if (isComment(next)) {
        if (next.data === "]") {
          if (--depth === 0) break;
        } else if (next.data === "[") {
          depth++;
        }
      }
      next = next.nextSibling;
    }
  } else {
    cb(node);
  }
}

const isAsyncWrapper = (i) => !!i.type.__asyncLoader;
/*! #__NO_SIDE_EFFECTS__ */
// @__NO_SIDE_EFFECTS__
function defineAsyncComponent(source) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(source)) {
    source = { loader: source };
  }
  const {
    loader,
    loadingComponent,
    errorComponent,
    delay = 200,
    hydrate: hydrateStrategy,
    timeout,
    // undefined = never times out
    suspensible = true,
    onError: userOnError
  } = source;
  let pendingRequest = null;
  let resolvedComp;
  let retries = 0;
  const retry = () => {
    retries++;
    pendingRequest = null;
    return load();
  };
  const load = () => {
    let thisRequest;
    return pendingRequest || (thisRequest = pendingRequest = loader().catch((err) => {
      err = err instanceof Error ? err : new Error(String(err));
      if (userOnError) {
        return new Promise((resolve, reject) => {
          const userRetry = () => resolve(retry());
          const userFail = () => reject(err);
          userOnError(err, userRetry, userFail, retries + 1);
        });
      } else {
        throw err;
      }
    }).then((comp) => {
      if (thisRequest !== pendingRequest && pendingRequest) {
        return pendingRequest;
      }
      if ( true && !comp) {
        warn$1(
          `Async component loader resolved to undefined. If you are using retry(), make sure to return its return value.`
        );
      }
      if (comp && (comp.__esModule || comp[Symbol.toStringTag] === "Module")) {
        comp = comp.default;
      }
      if ( true && comp && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(comp) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(comp)) {
        throw new Error(`Invalid async component load result: ${comp}`);
      }
      resolvedComp = comp;
      return comp;
    }));
  };
  return defineComponent({
    name: "AsyncComponentWrapper",
    __asyncLoader: load,
    __asyncHydrate(el, instance, hydrate) {
      let patched = false;
      const doHydrate = hydrateStrategy ? () => {
        const performHydrate = () => {
          if ( true && patched) {
            warn$1(
              `Skipping lazy hydration for component '${getComponentName(resolvedComp)}': it was updated before lazy hydration performed.`
            );
            return;
          }
          hydrate();
        };
        const teardown = hydrateStrategy(
          performHydrate,
          (cb) => forEachElement(el, cb)
        );
        if (teardown) {
          (instance.bum || (instance.bum = [])).push(teardown);
        }
        (instance.u || (instance.u = [])).push(() => patched = true);
      } : hydrate;
      if (resolvedComp) {
        doHydrate();
      } else {
        load().then(() => !instance.isUnmounted && doHydrate());
      }
    },
    get __asyncResolved() {
      return resolvedComp;
    },
    setup() {
      const instance = currentInstance;
      markAsyncBoundary(instance);
      if (resolvedComp) {
        return () => createInnerComp(resolvedComp, instance);
      }
      const onError = (err) => {
        pendingRequest = null;
        handleError(
          err,
          instance,
          13,
          !errorComponent
        );
      };
      if (suspensible && instance.suspense || isInSSRComponentSetup) {
        return load().then((comp) => {
          return () => createInnerComp(comp, instance);
        }).catch((err) => {
          onError(err);
          return () => errorComponent ? createVNode(errorComponent, {
            error: err
          }) : null;
        });
      }
      const loaded = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
      const error = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ref)();
      const delayed = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ref)(!!delay);
      if (delay) {
        setTimeout(() => {
          delayed.value = false;
        }, delay);
      }
      if (timeout != null) {
        setTimeout(() => {
          if (!loaded.value && !error.value) {
            const err = new Error(
              `Async component timed out after ${timeout}ms.`
            );
            onError(err);
            error.value = err;
          }
        }, timeout);
      }
      load().then(() => {
        loaded.value = true;
        if (instance.parent && isKeepAlive(instance.parent.vnode)) {
          instance.parent.update();
        }
      }).catch((err) => {
        onError(err);
        error.value = err;
      });
      return () => {
        if (loaded.value && resolvedComp) {
          return createInnerComp(resolvedComp, instance);
        } else if (error.value && errorComponent) {
          return createVNode(errorComponent, {
            error: error.value
          });
        } else if (loadingComponent && !delayed.value) {
          return createVNode(loadingComponent);
        }
      };
    }
  });
}
function createInnerComp(comp, parent) {
  const { ref: ref2, props, children, ce } = parent.vnode;
  const vnode = createVNode(comp, props, children);
  vnode.ref = ref2;
  vnode.ce = ce;
  delete parent.vnode.ce;
  return vnode;
}

const isKeepAlive = (vnode) => vnode.type.__isKeepAlive;
const KeepAliveImpl = {
  name: `KeepAlive`,
  // Marker for special handling inside the renderer. We are not using a ===
  // check directly on KeepAlive in the renderer, because importing it directly
  // would prevent it from being tree-shaken.
  __isKeepAlive: true,
  props: {
    include: [String, RegExp, Array],
    exclude: [String, RegExp, Array],
    max: [String, Number]
  },
  setup(props, { slots }) {
    const instance = getCurrentInstance();
    const sharedContext = instance.ctx;
    if (!sharedContext.renderer) {
      return () => {
        const children = slots.default && slots.default();
        return children && children.length === 1 ? children[0] : children;
      };
    }
    const cache = /* @__PURE__ */ new Map();
    const keys = /* @__PURE__ */ new Set();
    let current = null;
    if (true) {
      instance.__v_cache = cache;
    }
    const parentSuspense = instance.suspense;
    const {
      renderer: {
        p: patch,
        m: move,
        um: _unmount,
        o: { createElement }
      }
    } = sharedContext;
    const storageContainer = createElement("div");
    sharedContext.activate = (vnode, container, anchor, namespace, optimized) => {
      const instance2 = vnode.component;
      move(vnode, container, anchor, 0, parentSuspense);
      patch(
        instance2.vnode,
        vnode,
        container,
        anchor,
        instance2,
        parentSuspense,
        namespace,
        vnode.slotScopeIds,
        optimized
      );
      queuePostRenderEffect(() => {
        instance2.isDeactivated = false;
        if (instance2.a) {
          (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(instance2.a);
        }
        const vnodeHook = vnode.props && vnode.props.onVnodeMounted;
        if (vnodeHook) {
          invokeVNodeHook(vnodeHook, instance2.parent, vnode);
        }
      }, parentSuspense);
      if (true) {
        devtoolsComponentAdded(instance2);
      }
    };
    sharedContext.deactivate = (vnode) => {
      const instance2 = vnode.component;
      invalidateMount(instance2.m);
      invalidateMount(instance2.a);
      move(vnode, storageContainer, null, 1, parentSuspense);
      queuePostRenderEffect(() => {
        if (instance2.da) {
          (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(instance2.da);
        }
        const vnodeHook = vnode.props && vnode.props.onVnodeUnmounted;
        if (vnodeHook) {
          invokeVNodeHook(vnodeHook, instance2.parent, vnode);
        }
        instance2.isDeactivated = true;
      }, parentSuspense);
      if (true) {
        devtoolsComponentAdded(instance2);
      }
      if (true) {
        instance2.__keepAliveStorageContainer = storageContainer;
      }
    };
    function unmount(vnode) {
      resetShapeFlag(vnode);
      _unmount(vnode, instance, parentSuspense, true);
    }
    function pruneCache(filter) {
      cache.forEach((vnode, key) => {
        const name = getComponentName(vnode.type);
        if (name && !filter(name)) {
          pruneCacheEntry(key);
        }
      });
    }
    function pruneCacheEntry(key) {
      const cached = cache.get(key);
      if (cached && (!current || !isSameVNodeType(cached, current))) {
        unmount(cached);
      } else if (current) {
        resetShapeFlag(current);
      }
      cache.delete(key);
      keys.delete(key);
    }
    watch(
      () => [props.include, props.exclude],
      ([include, exclude]) => {
        include && pruneCache((name) => matches(include, name));
        exclude && pruneCache((name) => !matches(exclude, name));
      },
      // prune post-render after `current` has been updated
      { flush: "post", deep: true }
    );
    let pendingCacheKey = null;
    const cacheSubtree = () => {
      if (pendingCacheKey != null) {
        if (isSuspense(instance.subTree.type)) {
          queuePostRenderEffect(() => {
            cache.set(pendingCacheKey, getInnerChild(instance.subTree));
          }, instance.subTree.suspense);
        } else {
          cache.set(pendingCacheKey, getInnerChild(instance.subTree));
        }
      }
    };
    onMounted(cacheSubtree);
    onUpdated(cacheSubtree);
    onBeforeUnmount(() => {
      cache.forEach((cached) => {
        const { subTree, suspense } = instance;
        const vnode = getInnerChild(subTree);
        if (cached.type === vnode.type && cached.key === vnode.key) {
          resetShapeFlag(vnode);
          const da = vnode.component.da;
          da && queuePostRenderEffect(da, suspense);
          return;
        }
        unmount(cached);
      });
    });
    return () => {
      pendingCacheKey = null;
      if (!slots.default) {
        return current = null;
      }
      const children = slots.default();
      const rawVNode = children[0];
      if (children.length > 1) {
        if (true) {
          warn$1(`KeepAlive should contain exactly one component child.`);
        }
        current = null;
        return children;
      } else if (!isVNode(rawVNode) || !(rawVNode.shapeFlag & 4) && !(rawVNode.shapeFlag & 128)) {
        current = null;
        return rawVNode;
      }
      let vnode = getInnerChild(rawVNode);
      if (vnode.type === Comment) {
        current = null;
        return vnode;
      }
      const comp = vnode.type;
      const name = getComponentName(
        isAsyncWrapper(vnode) ? vnode.type.__asyncResolved || {} : comp
      );
      const { include, exclude, max } = props;
      if (include && (!name || !matches(include, name)) || exclude && name && matches(exclude, name)) {
        vnode.shapeFlag &= -257;
        current = vnode;
        return rawVNode;
      }
      const key = vnode.key == null ? comp : vnode.key;
      const cachedVNode = cache.get(key);
      if (vnode.el) {
        vnode = cloneVNode(vnode);
        if (rawVNode.shapeFlag & 128) {
          rawVNode.ssContent = vnode;
        }
      }
      pendingCacheKey = key;
      if (cachedVNode) {
        vnode.el = cachedVNode.el;
        vnode.component = cachedVNode.component;
        if (vnode.transition) {
          setTransitionHooks(vnode, vnode.transition);
        }
        vnode.shapeFlag |= 512;
        keys.delete(key);
        keys.add(key);
      } else {
        keys.add(key);
        if (max && keys.size > parseInt(max, 10)) {
          pruneCacheEntry(keys.values().next().value);
        }
      }
      vnode.shapeFlag |= 256;
      current = vnode;
      return isSuspense(rawVNode.type) ? rawVNode : vnode;
    };
  }
};
const KeepAlive = KeepAliveImpl;
function matches(pattern, name) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(pattern)) {
    return pattern.some((p) => matches(p, name));
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(pattern)) {
    return pattern.split(",").includes(name);
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isRegExp)(pattern)) {
    pattern.lastIndex = 0;
    return pattern.test(name);
  }
  return false;
}
function onActivated(hook, target) {
  registerKeepAliveHook(hook, "a", target);
}
function onDeactivated(hook, target) {
  registerKeepAliveHook(hook, "da", target);
}
function registerKeepAliveHook(hook, type, target = currentInstance) {
  const wrappedHook = hook.__wdc || (hook.__wdc = () => {
    let current = target;
    while (current) {
      if (current.isDeactivated) {
        return;
      }
      current = current.parent;
    }
    return hook();
  });
  injectHook(type, wrappedHook, target);
  if (target) {
    let current = target.parent;
    while (current && current.parent) {
      if (isKeepAlive(current.parent.vnode)) {
        injectToKeepAliveRoot(wrappedHook, type, target, current);
      }
      current = current.parent;
    }
  }
}
function injectToKeepAliveRoot(hook, type, target, keepAliveRoot) {
  const injected = injectHook(
    type,
    hook,
    keepAliveRoot,
    true
    /* prepend */
  );
  onUnmounted(() => {
    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.remove)(keepAliveRoot[type], injected);
  }, target);
}
function resetShapeFlag(vnode) {
  vnode.shapeFlag &= -257;
  vnode.shapeFlag &= -513;
}
function getInnerChild(vnode) {
  return vnode.shapeFlag & 128 ? vnode.ssContent : vnode;
}

function injectHook(type, hook, target = currentInstance, prepend = false) {
  if (target) {
    const hooks = target[type] || (target[type] = []);
    const wrappedHook = hook.__weh || (hook.__weh = (...args) => {
      (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();
      const reset = setCurrentInstance(target);
      const res = callWithAsyncErrorHandling(hook, target, type, args);
      reset();
      (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();
      return res;
    });
    if (prepend) {
      hooks.unshift(wrappedHook);
    } else {
      hooks.push(wrappedHook);
    }
    return wrappedHook;
  } else if (true) {
    const apiName = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)(ErrorTypeStrings$1[type].replace(/ hook$/, ""));
    warn$1(
      `${apiName} is called when there is no active component instance to be associated with. Lifecycle injection APIs can only be used during execution of setup().` + (` If you are using async setup(), make sure to register lifecycle hooks before the first await statement.` )
    );
  }
}
const createHook = (lifecycle) => (hook, target = currentInstance) => {
  if (!isInSSRComponentSetup || lifecycle === "sp") {
    injectHook(lifecycle, (...args) => hook(...args), target);
  }
};
const onBeforeMount = createHook("bm");
const onMounted = createHook("m");
const onBeforeUpdate = createHook(
  "bu"
);
const onUpdated = createHook("u");
const onBeforeUnmount = createHook(
  "bum"
);
const onUnmounted = createHook("um");
const onServerPrefetch = createHook(
  "sp"
);
const onRenderTriggered = createHook("rtg");
const onRenderTracked = createHook("rtc");
function onErrorCaptured(hook, target = currentInstance) {
  injectHook("ec", hook, target);
}

const COMPONENTS = "components";
const DIRECTIVES = "directives";
function resolveComponent(name, maybeSelfReference) {
  return resolveAsset(COMPONENTS, name, true, maybeSelfReference) || name;
}
const NULL_DYNAMIC_COMPONENT = Symbol.for("v-ndc");
function resolveDynamicComponent(component) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(component)) {
    return resolveAsset(COMPONENTS, component, false) || component;
  } else {
    return component || NULL_DYNAMIC_COMPONENT;
  }
}
function resolveDirective(name) {
  return resolveAsset(DIRECTIVES, name);
}
function resolveAsset(type, name, warnMissing = true, maybeSelfReference = false) {
  const instance = currentRenderingInstance || currentInstance;
  if (instance) {
    const Component = instance.type;
    if (type === COMPONENTS) {
      const selfName = getComponentName(
        Component,
        false
      );
      if (selfName && (selfName === name || selfName === (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(name) || selfName === (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.capitalize)((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(name)))) {
        return Component;
      }
    }
    const res = (
      // local registration
      // check instance[type] first which is resolved for options API
      resolve(instance[type] || Component[type], name) || // global registration
      resolve(instance.appContext[type], name)
    );
    if (!res && maybeSelfReference) {
      return Component;
    }
    if ( true && warnMissing && !res) {
      const extra = type === COMPONENTS ? `
If this is a native custom element, make sure to exclude it from component resolution via compilerOptions.isCustomElement.` : ``;
      warn$1(`Failed to resolve ${type.slice(0, -1)}: ${name}${extra}`);
    }
    return res;
  } else if (true) {
    warn$1(
      `resolve${(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.capitalize)(type.slice(0, -1))} can only be used in render() or setup().`
    );
  }
}
function resolve(registry, name) {
  return registry && (registry[name] || registry[(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(name)] || registry[(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.capitalize)((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(name))]);
}

function renderList(source, renderItem, cache, index) {
  let ret;
  const cached = cache && cache[index];
  const sourceIsArray = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(source);
  if (sourceIsArray || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(source)) {
    const sourceIsReactiveArray = sourceIsArray && (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReactive)(source);
    let needsWrap = false;
    let isReadonlySource = false;
    if (sourceIsReactiveArray) {
      needsWrap = !(0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isShallow)(source);
      isReadonlySource = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReadonly)(source);
      source = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadArray)(source);
    }
    ret = new Array(source.length);
    for (let i = 0, l = source.length; i < l; i++) {
      ret[i] = renderItem(
        needsWrap ? isReadonlySource ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toReadonly)((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toReactive)(source[i])) : (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toReactive)(source[i]) : source[i],
        i,
        void 0,
        cached && cached[i]
      );
    }
  } else if (typeof source === "number") {
    if ( true && !Number.isInteger(source)) {
      warn$1(`The v-for range expect an integer value but got ${source}.`);
    }
    ret = new Array(source);
    for (let i = 0; i < source; i++) {
      ret[i] = renderItem(i + 1, i, void 0, cached && cached[i]);
    }
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(source)) {
    if (source[Symbol.iterator]) {
      ret = Array.from(
        source,
        (item, i) => renderItem(item, i, void 0, cached && cached[i])
      );
    } else {
      const keys = Object.keys(source);
      ret = new Array(keys.length);
      for (let i = 0, l = keys.length; i < l; i++) {
        const key = keys[i];
        ret[i] = renderItem(source[key], key, i, cached && cached[i]);
      }
    }
  } else {
    ret = [];
  }
  if (cache) {
    cache[index] = ret;
  }
  return ret;
}

function createSlots(slots, dynamicSlots) {
  for (let i = 0; i < dynamicSlots.length; i++) {
    const slot = dynamicSlots[i];
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(slot)) {
      for (let j = 0; j < slot.length; j++) {
        slots[slot[j].name] = slot[j].fn;
      }
    } else if (slot) {
      slots[slot.name] = slot.key ? (...args) => {
        const res = slot.fn(...args);
        if (res) res.key = slot.key;
        return res;
      } : slot.fn;
    }
  }
  return slots;
}

function renderSlot(slots, name, props = {}, fallback, noSlotted) {
  if (currentRenderingInstance.ce || currentRenderingInstance.parent && isAsyncWrapper(currentRenderingInstance.parent) && currentRenderingInstance.parent.ce) {
    if (name !== "default") props.name = name;
    return openBlock(), createBlock(
      Fragment,
      null,
      [createVNode("slot", props, fallback && fallback())],
      64
    );
  }
  let slot = slots[name];
  if ( true && slot && slot.length > 1) {
    warn$1(
      `SSR-optimized slot function detected in a non-SSR-optimized render function. You need to mark this component with $dynamic-slots in the parent template.`
    );
    slot = () => [];
  }
  if (slot && slot._c) {
    slot._d = false;
  }
  openBlock();
  const validSlotContent = slot && ensureValidVNode(slot(props));
  const slotKey = props.key || // slot content array of a dynamic conditional slot may have a branch
  // key attached in the `createSlots` helper, respect that
  validSlotContent && validSlotContent.key;
  const rendered = createBlock(
    Fragment,
    {
      key: (slotKey && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isSymbol)(slotKey) ? slotKey : `_${name}`) + // #7256 force differentiate fallback content from actual content
      (!validSlotContent && fallback ? "_fb" : "")
    },
    validSlotContent || (fallback ? fallback() : []),
    validSlotContent && slots._ === 1 ? 64 : -2
  );
  if (!noSlotted && rendered.scopeId) {
    rendered.slotScopeIds = [rendered.scopeId + "-s"];
  }
  if (slot && slot._c) {
    slot._d = true;
  }
  return rendered;
}
function ensureValidVNode(vnodes) {
  return vnodes.some((child) => {
    if (!isVNode(child)) return true;
    if (child.type === Comment) return false;
    if (child.type === Fragment && !ensureValidVNode(child.children))
      return false;
    return true;
  }) ? vnodes : null;
}

function toHandlers(obj, preserveCaseIfNecessary) {
  const ret = {};
  if ( true && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(obj)) {
    warn$1(`v-on with no argument expects an object value.`);
    return ret;
  }
  for (const key in obj) {
    ret[preserveCaseIfNecessary && /[A-Z]/.test(key) ? `on:${key}` : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)(key)] = obj[key];
  }
  return ret;
}

const getPublicInstance = (i) => {
  if (!i) return null;
  if (isStatefulComponent(i)) return getComponentPublicInstance(i);
  return getPublicInstance(i.parent);
};
const publicPropertiesMap = (
  // Move PURE marker to new line to workaround compiler discarding it
  // due to type annotation
  /* @__PURE__ */ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(/* @__PURE__ */ Object.create(null), {
    $: (i) => i,
    $el: (i) => i.vnode.el,
    $data: (i) => i.data,
    $props: (i) =>  true ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(i.props) : 0,
    $attrs: (i) =>  true ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(i.attrs) : 0,
    $slots: (i) =>  true ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(i.slots) : 0,
    $refs: (i) =>  true ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(i.refs) : 0,
    $parent: (i) => getPublicInstance(i.parent),
    $root: (i) => getPublicInstance(i.root),
    $host: (i) => i.ce,
    $emit: (i) => i.emit,
    $options: (i) =>  true ? resolveMergedOptions(i) : 0,
    $forceUpdate: (i) => i.f || (i.f = () => {
      queueJob(i.update);
    }),
    $nextTick: (i) => i.n || (i.n = nextTick.bind(i.proxy)),
    $watch: (i) =>  true ? instanceWatch.bind(i) : 0
  })
);
const isReservedPrefix = (key) => key === "_" || key === "$";
const hasSetupBinding = (state, key) => state !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && !state.__isScriptSetup && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(state, key);
const PublicInstanceProxyHandlers = {
  get({ _: instance }, key) {
    if (key === "__v_skip") {
      return true;
    }
    const { ctx, setupState, data, props, accessCache, type, appContext } = instance;
    if ( true && key === "__isVue") {
      return true;
    }
    let normalizedProps;
    if (key[0] !== "$") {
      const n = accessCache[key];
      if (n !== void 0) {
        switch (n) {
          case 1 /* SETUP */:
            return setupState[key];
          case 2 /* DATA */:
            return data[key];
          case 4 /* CONTEXT */:
            return ctx[key];
          case 3 /* PROPS */:
            return props[key];
        }
      } else if (hasSetupBinding(setupState, key)) {
        accessCache[key] = 1 /* SETUP */;
        return setupState[key];
      } else if (data !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(data, key)) {
        accessCache[key] = 2 /* DATA */;
        return data[key];
      } else if (
        // only cache other properties when instance has declared (thus stable)
        // props
        (normalizedProps = instance.propsOptions[0]) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(normalizedProps, key)
      ) {
        accessCache[key] = 3 /* PROPS */;
        return props[key];
      } else if (ctx !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(ctx, key)) {
        accessCache[key] = 4 /* CONTEXT */;
        return ctx[key];
      } else if ( false || shouldCacheAccess) {
        accessCache[key] = 0 /* OTHER */;
      }
    }
    const publicGetter = publicPropertiesMap[key];
    let cssModule, globalProperties;
    if (publicGetter) {
      if (key === "$attrs") {
        (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.track)(instance.attrs, "get", "");
         true && markAttrsAccessed();
      } else if ( true && key === "$slots") {
        (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.track)(instance, "get", key);
      }
      return publicGetter(instance);
    } else if (
      // css module (injected by vue-loader)
      (cssModule = type.__cssModules) && (cssModule = cssModule[key])
    ) {
      return cssModule;
    } else if (ctx !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(ctx, key)) {
      accessCache[key] = 4 /* CONTEXT */;
      return ctx[key];
    } else if (
      // global properties
      globalProperties = appContext.config.globalProperties, (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(globalProperties, key)
    ) {
      {
        return globalProperties[key];
      }
    } else if ( true && currentRenderingInstance && (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(key) || // #1091 avoid internal isRef/isVNode checks on component instance leading
    // to infinite warning loop
    key.indexOf("__v") !== 0)) {
      if (data !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && isReservedPrefix(key[0]) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(data, key)) {
        warn$1(
          `Property ${JSON.stringify(
            key
          )} must be accessed via $data because it starts with a reserved character ("$" or "_") and is not proxied on the render context.`
        );
      } else if (instance === currentRenderingInstance) {
        warn$1(
          `Property ${JSON.stringify(key)} was accessed during render but is not defined on instance.`
        );
      }
    }
  },
  set({ _: instance }, key, value) {
    const { data, setupState, ctx } = instance;
    if (hasSetupBinding(setupState, key)) {
      setupState[key] = value;
      return true;
    } else if ( true && setupState.__isScriptSetup && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(setupState, key)) {
      warn$1(`Cannot mutate <script setup> binding "${key}" from Options API.`);
      return false;
    } else if (data !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(data, key)) {
      data[key] = value;
      return true;
    } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(instance.props, key)) {
       true && warn$1(`Attempting to mutate prop "${key}". Props are readonly.`);
      return false;
    }
    if (key[0] === "$" && key.slice(1) in instance) {
       true && warn$1(
        `Attempting to mutate public property "${key}". Properties starting with $ are reserved and readonly.`
      );
      return false;
    } else {
      if ( true && key in instance.appContext.config.globalProperties) {
        Object.defineProperty(ctx, key, {
          enumerable: true,
          configurable: true,
          value
        });
      } else {
        ctx[key] = value;
      }
    }
    return true;
  },
  has({
    _: { data, setupState, accessCache, ctx, appContext, propsOptions }
  }, key) {
    let normalizedProps;
    return !!accessCache[key] || data !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(data, key) || hasSetupBinding(setupState, key) || (normalizedProps = propsOptions[0]) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(normalizedProps, key) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(ctx, key) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(publicPropertiesMap, key) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(appContext.config.globalProperties, key);
  },
  defineProperty(target, key, descriptor) {
    if (descriptor.get != null) {
      target._.accessCache[key] = 0;
    } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(descriptor, "value")) {
      this.set(target, key, descriptor.value, null);
    }
    return Reflect.defineProperty(target, key, descriptor);
  }
};
if (true) {
  PublicInstanceProxyHandlers.ownKeys = (target) => {
    warn$1(
      `Avoid app logic that relies on enumerating keys on a component instance. The keys will be empty in production mode to avoid performance overhead.`
    );
    return Reflect.ownKeys(target);
  };
}
const RuntimeCompiledPublicInstanceProxyHandlers = /* @__PURE__ */ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, PublicInstanceProxyHandlers, {
  get(target, key) {
    if (key === Symbol.unscopables) {
      return;
    }
    return PublicInstanceProxyHandlers.get(target, key, target);
  },
  has(_, key) {
    const has = key[0] !== "_" && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isGloballyAllowed)(key);
    if ( true && !has && PublicInstanceProxyHandlers.has(_, key)) {
      warn$1(
        `Property ${JSON.stringify(
          key
        )} should not start with _ which is a reserved prefix for Vue internals.`
      );
    }
    return has;
  }
});
function createDevRenderContext(instance) {
  const target = {};
  Object.defineProperty(target, `_`, {
    configurable: true,
    enumerable: false,
    get: () => instance
  });
  Object.keys(publicPropertiesMap).forEach((key) => {
    Object.defineProperty(target, key, {
      configurable: true,
      enumerable: false,
      get: () => publicPropertiesMap[key](instance),
      // intercepted by the proxy so no need for implementation,
      // but needed to prevent set errors
      set: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP
    });
  });
  return target;
}
function exposePropsOnRenderContext(instance) {
  const {
    ctx,
    propsOptions: [propsOptions]
  } = instance;
  if (propsOptions) {
    Object.keys(propsOptions).forEach((key) => {
      Object.defineProperty(ctx, key, {
        enumerable: true,
        configurable: true,
        get: () => instance.props[key],
        set: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP
      });
    });
  }
}
function exposeSetupStateOnRenderContext(instance) {
  const { ctx, setupState } = instance;
  Object.keys((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(setupState)).forEach((key) => {
    if (!setupState.__isScriptSetup) {
      if (isReservedPrefix(key[0])) {
        warn$1(
          `setup() return property ${JSON.stringify(
            key
          )} should not start with "$" or "_" which are reserved prefixes for Vue internals.`
        );
        return;
      }
      Object.defineProperty(ctx, key, {
        enumerable: true,
        configurable: true,
        get: () => setupState[key],
        set: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP
      });
    }
  });
}

const warnRuntimeUsage = (method) => warn$1(
  `${method}() is a compiler-hint helper that is only usable inside <script setup> of a single file component. Its arguments should be compiled away and passing it at runtime has no effect.`
);
function defineProps() {
  if (true) {
    warnRuntimeUsage(`defineProps`);
  }
  return null;
}
function defineEmits() {
  if (true) {
    warnRuntimeUsage(`defineEmits`);
  }
  return null;
}
function defineExpose(exposed) {
  if (true) {
    warnRuntimeUsage(`defineExpose`);
  }
}
function defineOptions(options) {
  if (true) {
    warnRuntimeUsage(`defineOptions`);
  }
}
function defineSlots() {
  if (true) {
    warnRuntimeUsage(`defineSlots`);
  }
  return null;
}
function defineModel() {
  if (true) {
    warnRuntimeUsage("defineModel");
  }
}
function withDefaults(props, defaults) {
  if (true) {
    warnRuntimeUsage(`withDefaults`);
  }
  return null;
}
function useSlots() {
  return getContext().slots;
}
function useAttrs() {
  return getContext().attrs;
}
function getContext() {
  const i = getCurrentInstance();
  if ( true && !i) {
    warn$1(`useContext() called without active instance.`);
  }
  return i.setupContext || (i.setupContext = createSetupContext(i));
}
function normalizePropsOrEmits(props) {
  return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(props) ? props.reduce(
    (normalized, p) => (normalized[p] = null, normalized),
    {}
  ) : props;
}
function mergeDefaults(raw, defaults) {
  const props = normalizePropsOrEmits(raw);
  for (const key in defaults) {
    if (key.startsWith("__skip")) continue;
    let opt = props[key];
    if (opt) {
      if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(opt) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(opt)) {
        opt = props[key] = { type: opt, default: defaults[key] };
      } else {
        opt.default = defaults[key];
      }
    } else if (opt === null) {
      opt = props[key] = { default: defaults[key] };
    } else if (true) {
      warn$1(`props default key "${key}" has no corresponding declaration.`);
    }
    if (opt && defaults[`__skip_${key}`]) {
      opt.skipFactory = true;
    }
  }
  return props;
}
function mergeModels(a, b) {
  if (!a || !b) return a || b;
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(a) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(b)) return a.concat(b);
  return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, normalizePropsOrEmits(a), normalizePropsOrEmits(b));
}
function createPropsRestProxy(props, excludedKeys) {
  const ret = {};
  for (const key in props) {
    if (!excludedKeys.includes(key)) {
      Object.defineProperty(ret, key, {
        enumerable: true,
        get: () => props[key]
      });
    }
  }
  return ret;
}
function withAsyncContext(getAwaitable) {
  const ctx = getCurrentInstance();
  if ( true && !ctx) {
    warn$1(
      `withAsyncContext called without active current instance. This is likely a bug.`
    );
  }
  let awaitable = getAwaitable();
  unsetCurrentInstance();
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isPromise)(awaitable)) {
    awaitable = awaitable.catch((e) => {
      setCurrentInstance(ctx);
      throw e;
    });
  }
  return [awaitable, () => setCurrentInstance(ctx)];
}

function createDuplicateChecker() {
  const cache = /* @__PURE__ */ Object.create(null);
  return (type, key) => {
    if (cache[key]) {
      warn$1(`${type} property "${key}" is already defined in ${cache[key]}.`);
    } else {
      cache[key] = type;
    }
  };
}
let shouldCacheAccess = true;
function applyOptions(instance) {
  const options = resolveMergedOptions(instance);
  const publicThis = instance.proxy;
  const ctx = instance.ctx;
  shouldCacheAccess = false;
  if (options.beforeCreate) {
    callHook(options.beforeCreate, instance, "bc");
  }
  const {
    // state
    data: dataOptions,
    computed: computedOptions,
    methods,
    watch: watchOptions,
    provide: provideOptions,
    inject: injectOptions,
    // lifecycle
    created,
    beforeMount,
    mounted,
    beforeUpdate,
    updated,
    activated,
    deactivated,
    beforeDestroy,
    beforeUnmount,
    destroyed,
    unmounted,
    render,
    renderTracked,
    renderTriggered,
    errorCaptured,
    serverPrefetch,
    // public API
    expose,
    inheritAttrs,
    // assets
    components,
    directives,
    filters
  } = options;
  const checkDuplicateProperties =  true ? createDuplicateChecker() : 0;
  if (true) {
    const [propsOptions] = instance.propsOptions;
    if (propsOptions) {
      for (const key in propsOptions) {
        checkDuplicateProperties("Props" /* PROPS */, key);
      }
    }
  }
  if (injectOptions) {
    resolveInjections(injectOptions, ctx, checkDuplicateProperties);
  }
  if (methods) {
    for (const key in methods) {
      const methodHandler = methods[key];
      if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(methodHandler)) {
        if (true) {
          Object.defineProperty(ctx, key, {
            value: methodHandler.bind(publicThis),
            configurable: true,
            enumerable: true,
            writable: true
          });
        } else {}
        if (true) {
          checkDuplicateProperties("Methods" /* METHODS */, key);
        }
      } else if (true) {
        warn$1(
          `Method "${key}" has type "${typeof methodHandler}" in the component definition. Did you reference the function correctly?`
        );
      }
    }
  }
  if (dataOptions) {
    if ( true && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(dataOptions)) {
      warn$1(
        `The data option must be a function. Plain object usage is no longer supported.`
      );
    }
    const data = dataOptions.call(publicThis, publicThis);
    if ( true && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isPromise)(data)) {
      warn$1(
        `data() returned a Promise - note data() cannot be async; If you intend to perform data fetching before component renders, use async setup() + <Suspense>.`
      );
    }
    if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(data)) {
       true && warn$1(`data() should return an object.`);
    } else {
      instance.data = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.reactive)(data);
      if (true) {
        for (const key in data) {
          checkDuplicateProperties("Data" /* DATA */, key);
          if (!isReservedPrefix(key[0])) {
            Object.defineProperty(ctx, key, {
              configurable: true,
              enumerable: true,
              get: () => data[key],
              set: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP
            });
          }
        }
      }
    }
  }
  shouldCacheAccess = true;
  if (computedOptions) {
    for (const key in computedOptions) {
      const opt = computedOptions[key];
      const get = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(opt) ? opt.bind(publicThis, publicThis) : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(opt.get) ? opt.get.bind(publicThis, publicThis) : _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP;
      if ( true && get === _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP) {
        warn$1(`Computed property "${key}" has no getter.`);
      }
      const set = !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(opt) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(opt.set) ? opt.set.bind(publicThis) :  true ? () => {
        warn$1(
          `Write operation failed: computed property "${key}" is readonly.`
        );
      } : 0;
      const c = computed({
        get,
        set
      });
      Object.defineProperty(ctx, key, {
        enumerable: true,
        configurable: true,
        get: () => c.value,
        set: (v) => c.value = v
      });
      if (true) {
        checkDuplicateProperties("Computed" /* COMPUTED */, key);
      }
    }
  }
  if (watchOptions) {
    for (const key in watchOptions) {
      createWatcher(watchOptions[key], ctx, publicThis, key);
    }
  }
  if (provideOptions) {
    const provides = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(provideOptions) ? provideOptions.call(publicThis) : provideOptions;
    Reflect.ownKeys(provides).forEach((key) => {
      provide(key, provides[key]);
    });
  }
  if (created) {
    callHook(created, instance, "c");
  }
  function registerLifecycleHook(register, hook) {
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(hook)) {
      hook.forEach((_hook) => register(_hook.bind(publicThis)));
    } else if (hook) {
      register(hook.bind(publicThis));
    }
  }
  registerLifecycleHook(onBeforeMount, beforeMount);
  registerLifecycleHook(onMounted, mounted);
  registerLifecycleHook(onBeforeUpdate, beforeUpdate);
  registerLifecycleHook(onUpdated, updated);
  registerLifecycleHook(onActivated, activated);
  registerLifecycleHook(onDeactivated, deactivated);
  registerLifecycleHook(onErrorCaptured, errorCaptured);
  registerLifecycleHook(onRenderTracked, renderTracked);
  registerLifecycleHook(onRenderTriggered, renderTriggered);
  registerLifecycleHook(onBeforeUnmount, beforeUnmount);
  registerLifecycleHook(onUnmounted, unmounted);
  registerLifecycleHook(onServerPrefetch, serverPrefetch);
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(expose)) {
    if (expose.length) {
      const exposed = instance.exposed || (instance.exposed = {});
      expose.forEach((key) => {
        Object.defineProperty(exposed, key, {
          get: () => publicThis[key],
          set: (val) => publicThis[key] = val
        });
      });
    } else if (!instance.exposed) {
      instance.exposed = {};
    }
  }
  if (render && instance.render === _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP) {
    instance.render = render;
  }
  if (inheritAttrs != null) {
    instance.inheritAttrs = inheritAttrs;
  }
  if (components) instance.components = components;
  if (directives) instance.directives = directives;
  if (serverPrefetch) {
    markAsyncBoundary(instance);
  }
}
function resolveInjections(injectOptions, ctx, checkDuplicateProperties = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(injectOptions)) {
    injectOptions = normalizeInject(injectOptions);
  }
  for (const key in injectOptions) {
    const opt = injectOptions[key];
    let injected;
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(opt)) {
      if ("default" in opt) {
        injected = inject(
          opt.from || key,
          opt.default,
          true
        );
      } else {
        injected = inject(opt.from || key);
      }
    } else {
      injected = inject(opt);
    }
    if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(injected)) {
      Object.defineProperty(ctx, key, {
        enumerable: true,
        configurable: true,
        get: () => injected.value,
        set: (v) => injected.value = v
      });
    } else {
      ctx[key] = injected;
    }
    if (true) {
      checkDuplicateProperties("Inject" /* INJECT */, key);
    }
  }
}
function callHook(hook, instance, type) {
  callWithAsyncErrorHandling(
    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(hook) ? hook.map((h) => h.bind(instance.proxy)) : hook.bind(instance.proxy),
    instance,
    type
  );
}
function createWatcher(raw, ctx, publicThis, key) {
  let getter = key.includes(".") ? createPathGetter(publicThis, key) : () => publicThis[key];
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(raw)) {
    const handler = ctx[raw];
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(handler)) {
      {
        watch(getter, handler);
      }
    } else if (true) {
      warn$1(`Invalid watch handler specified by key "${raw}"`, handler);
    }
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(raw)) {
    {
      watch(getter, raw.bind(publicThis));
    }
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(raw)) {
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(raw)) {
      raw.forEach((r) => createWatcher(r, ctx, publicThis, key));
    } else {
      const handler = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(raw.handler) ? raw.handler.bind(publicThis) : ctx[raw.handler];
      if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(handler)) {
        watch(getter, handler, raw);
      } else if (true) {
        warn$1(`Invalid watch handler specified by key "${raw.handler}"`, handler);
      }
    }
  } else if (true) {
    warn$1(`Invalid watch option: "${key}"`, raw);
  }
}
function resolveMergedOptions(instance) {
  const base = instance.type;
  const { mixins, extends: extendsOptions } = base;
  const {
    mixins: globalMixins,
    optionsCache: cache,
    config: { optionMergeStrategies }
  } = instance.appContext;
  const cached = cache.get(base);
  let resolved;
  if (cached) {
    resolved = cached;
  } else if (!globalMixins.length && !mixins && !extendsOptions) {
    {
      resolved = base;
    }
  } else {
    resolved = {};
    if (globalMixins.length) {
      globalMixins.forEach(
        (m) => mergeOptions(resolved, m, optionMergeStrategies, true)
      );
    }
    mergeOptions(resolved, base, optionMergeStrategies);
  }
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(base)) {
    cache.set(base, resolved);
  }
  return resolved;
}
function mergeOptions(to, from, strats, asMixin = false) {
  const { mixins, extends: extendsOptions } = from;
  if (extendsOptions) {
    mergeOptions(to, extendsOptions, strats, true);
  }
  if (mixins) {
    mixins.forEach(
      (m) => mergeOptions(to, m, strats, true)
    );
  }
  for (const key in from) {
    if (asMixin && key === "expose") {
       true && warn$1(
        `"expose" option is ignored when declared in mixins or extends. It should only be declared in the base component itself.`
      );
    } else {
      const strat = internalOptionMergeStrats[key] || strats && strats[key];
      to[key] = strat ? strat(to[key], from[key]) : from[key];
    }
  }
  return to;
}
const internalOptionMergeStrats = {
  data: mergeDataFn,
  props: mergeEmitsOrPropsOptions,
  emits: mergeEmitsOrPropsOptions,
  // objects
  methods: mergeObjectOptions,
  computed: mergeObjectOptions,
  // lifecycle
  beforeCreate: mergeAsArray,
  created: mergeAsArray,
  beforeMount: mergeAsArray,
  mounted: mergeAsArray,
  beforeUpdate: mergeAsArray,
  updated: mergeAsArray,
  beforeDestroy: mergeAsArray,
  beforeUnmount: mergeAsArray,
  destroyed: mergeAsArray,
  unmounted: mergeAsArray,
  activated: mergeAsArray,
  deactivated: mergeAsArray,
  errorCaptured: mergeAsArray,
  serverPrefetch: mergeAsArray,
  // assets
  components: mergeObjectOptions,
  directives: mergeObjectOptions,
  // watch
  watch: mergeWatchOptions,
  // provide / inject
  provide: mergeDataFn,
  inject: mergeInject
};
function mergeDataFn(to, from) {
  if (!from) {
    return to;
  }
  if (!to) {
    return from;
  }
  return function mergedDataFn() {
    return ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend))(
      (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(to) ? to.call(this, this) : to,
      (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(from) ? from.call(this, this) : from
    );
  };
}
function mergeInject(to, from) {
  return mergeObjectOptions(normalizeInject(to), normalizeInject(from));
}
function normalizeInject(raw) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(raw)) {
    const res = {};
    for (let i = 0; i < raw.length; i++) {
      res[raw[i]] = raw[i];
    }
    return res;
  }
  return raw;
}
function mergeAsArray(to, from) {
  return to ? [...new Set([].concat(to, from))] : from;
}
function mergeObjectOptions(to, from) {
  return to ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(/* @__PURE__ */ Object.create(null), to, from) : from;
}
function mergeEmitsOrPropsOptions(to, from) {
  if (to) {
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(to) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(from)) {
      return [.../* @__PURE__ */ new Set([...to, ...from])];
    }
    return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(
      /* @__PURE__ */ Object.create(null),
      normalizePropsOrEmits(to),
      normalizePropsOrEmits(from != null ? from : {})
    );
  } else {
    return from;
  }
}
function mergeWatchOptions(to, from) {
  if (!to) return from;
  if (!from) return to;
  const merged = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(/* @__PURE__ */ Object.create(null), to);
  for (const key in from) {
    merged[key] = mergeAsArray(to[key], from[key]);
  }
  return merged;
}

function createAppContext() {
  return {
    app: null,
    config: {
      isNativeTag: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NO,
      performance: false,
      globalProperties: {},
      optionMergeStrategies: {},
      errorHandler: void 0,
      warnHandler: void 0,
      compilerOptions: {}
    },
    mixins: [],
    components: {},
    directives: {},
    provides: /* @__PURE__ */ Object.create(null),
    optionsCache: /* @__PURE__ */ new WeakMap(),
    propsCache: /* @__PURE__ */ new WeakMap(),
    emitsCache: /* @__PURE__ */ new WeakMap()
  };
}
let uid$1 = 0;
function createAppAPI(render, hydrate) {
  return function createApp(rootComponent, rootProps = null) {
    if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(rootComponent)) {
      rootComponent = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, rootComponent);
    }
    if (rootProps != null && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(rootProps)) {
       true && warn$1(`root props passed to app.mount() must be an object.`);
      rootProps = null;
    }
    const context = createAppContext();
    const installedPlugins = /* @__PURE__ */ new WeakSet();
    const pluginCleanupFns = [];
    let isMounted = false;
    const app = context.app = {
      _uid: uid$1++,
      _component: rootComponent,
      _props: rootProps,
      _container: null,
      _context: context,
      _instance: null,
      version,
      get config() {
        return context.config;
      },
      set config(v) {
        if (true) {
          warn$1(
            `app.config cannot be replaced. Modify individual options instead.`
          );
        }
      },
      use(plugin, ...options) {
        if (installedPlugins.has(plugin)) {
           true && warn$1(`Plugin has already been applied to target app.`);
        } else if (plugin && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(plugin.install)) {
          installedPlugins.add(plugin);
          plugin.install(app, ...options);
        } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(plugin)) {
          installedPlugins.add(plugin);
          plugin(app, ...options);
        } else if (true) {
          warn$1(
            `A plugin must either be a function or an object with an "install" function.`
          );
        }
        return app;
      },
      mixin(mixin) {
        if (true) {
          if (!context.mixins.includes(mixin)) {
            context.mixins.push(mixin);
          } else if (true) {
            warn$1(
              "Mixin has already been applied to target app" + (mixin.name ? `: ${mixin.name}` : "")
            );
          }
        } else {}
        return app;
      },
      component(name, component) {
        if (true) {
          validateComponentName(name, context.config);
        }
        if (!component) {
          return context.components[name];
        }
        if ( true && context.components[name]) {
          warn$1(`Component "${name}" has already been registered in target app.`);
        }
        context.components[name] = component;
        return app;
      },
      directive(name, directive) {
        if (true) {
          validateDirectiveName(name);
        }
        if (!directive) {
          return context.directives[name];
        }
        if ( true && context.directives[name]) {
          warn$1(`Directive "${name}" has already been registered in target app.`);
        }
        context.directives[name] = directive;
        return app;
      },
      mount(rootContainer, isHydrate, namespace) {
        if (!isMounted) {
          if ( true && rootContainer.__vue_app__) {
            warn$1(
              `There is already an app instance mounted on the host container.
 If you want to mount another app on the same host container, you need to unmount the previous app by calling \`app.unmount()\` first.`
            );
          }
          const vnode = app._ceVNode || createVNode(rootComponent, rootProps);
          vnode.appContext = context;
          if (namespace === true) {
            namespace = "svg";
          } else if (namespace === false) {
            namespace = void 0;
          }
          if (true) {
            context.reload = () => {
              const cloned = cloneVNode(vnode);
              cloned.el = null;
              render(cloned, rootContainer, namespace);
            };
          }
          if (isHydrate && hydrate) {
            hydrate(vnode, rootContainer);
          } else {
            render(vnode, rootContainer, namespace);
          }
          isMounted = true;
          app._container = rootContainer;
          rootContainer.__vue_app__ = app;
          if (true) {
            app._instance = vnode.component;
            devtoolsInitApp(app, version);
          }
          return getComponentPublicInstance(vnode.component);
        } else if (true) {
          warn$1(
            `App has already been mounted.
If you want to remount the same app, move your app creation logic into a factory function and create fresh app instances for each mount - e.g. \`const createMyApp = () => createApp(App)\``
          );
        }
      },
      onUnmount(cleanupFn) {
        if ( true && typeof cleanupFn !== "function") {
          warn$1(
            `Expected function as first argument to app.onUnmount(), but got ${typeof cleanupFn}`
          );
        }
        pluginCleanupFns.push(cleanupFn);
      },
      unmount() {
        if (isMounted) {
          callWithAsyncErrorHandling(
            pluginCleanupFns,
            app._instance,
            16
          );
          render(null, app._container);
          if (true) {
            app._instance = null;
            devtoolsUnmountApp(app);
          }
          delete app._container.__vue_app__;
        } else if (true) {
          warn$1(`Cannot unmount an app that is not mounted.`);
        }
      },
      provide(key, value) {
        if ( true && key in context.provides) {
          if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(context.provides, key)) {
            warn$1(
              `App already provides property with key "${String(key)}". It will be overwritten with the new value.`
            );
          } else {
            warn$1(
              `App already provides property with key "${String(key)}" inherited from its parent element. It will be overwritten with the new value.`
            );
          }
        }
        context.provides[key] = value;
        return app;
      },
      runWithContext(fn) {
        const lastApp = currentApp;
        currentApp = app;
        try {
          return fn();
        } finally {
          currentApp = lastApp;
        }
      }
    };
    return app;
  };
}
let currentApp = null;

function provide(key, value) {
  if (!currentInstance) {
    if (true) {
      warn$1(`provide() can only be used inside setup().`);
    }
  } else {
    let provides = currentInstance.provides;
    const parentProvides = currentInstance.parent && currentInstance.parent.provides;
    if (parentProvides === provides) {
      provides = currentInstance.provides = Object.create(parentProvides);
    }
    provides[key] = value;
  }
}
function inject(key, defaultValue, treatDefaultAsFactory = false) {
  const instance = currentInstance || currentRenderingInstance;
  if (instance || currentApp) {
    let provides = currentApp ? currentApp._context.provides : instance ? instance.parent == null || instance.ce ? instance.vnode.appContext && instance.vnode.appContext.provides : instance.parent.provides : void 0;
    if (provides && key in provides) {
      return provides[key];
    } else if (arguments.length > 1) {
      return treatDefaultAsFactory && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(defaultValue) ? defaultValue.call(instance && instance.proxy) : defaultValue;
    } else if (true) {
      warn$1(`injection "${String(key)}" not found.`);
    }
  } else if (true) {
    warn$1(`inject() can only be used inside setup() or functional components.`);
  }
}
function hasInjectionContext() {
  return !!(currentInstance || currentRenderingInstance || currentApp);
}

const internalObjectProto = {};
const createInternalObject = () => Object.create(internalObjectProto);
const isInternalObject = (obj) => Object.getPrototypeOf(obj) === internalObjectProto;

function initProps(instance, rawProps, isStateful, isSSR = false) {
  const props = {};
  const attrs = createInternalObject();
  instance.propsDefaults = /* @__PURE__ */ Object.create(null);
  setFullProps(instance, rawProps, props, attrs);
  for (const key in instance.propsOptions[0]) {
    if (!(key in props)) {
      props[key] = void 0;
    }
  }
  if (true) {
    validateProps(rawProps || {}, props, instance);
  }
  if (isStateful) {
    instance.props = isSSR ? props : (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReactive)(props);
  } else {
    if (!instance.type.props) {
      instance.props = attrs;
    } else {
      instance.props = props;
    }
  }
  instance.attrs = attrs;
}
function isInHmrContext(instance) {
  while (instance) {
    if (instance.type.__hmrId) return true;
    instance = instance.parent;
  }
}
function updateProps(instance, rawProps, rawPrevProps, optimized) {
  const {
    props,
    attrs,
    vnode: { patchFlag }
  } = instance;
  const rawCurrentProps = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(props);
  const [options] = instance.propsOptions;
  let hasAttrsChanged = false;
  if (
    // always force full diff in dev
    // - #1942 if hmr is enabled with sfc component
    // - vite#872 non-sfc component used by sfc component
    !( true && isInHmrContext(instance)) && (optimized || patchFlag > 0) && !(patchFlag & 16)
  ) {
    if (patchFlag & 8) {
      const propsToUpdate = instance.vnode.dynamicProps;
      for (let i = 0; i < propsToUpdate.length; i++) {
        let key = propsToUpdate[i];
        if (isEmitListener(instance.emitsOptions, key)) {
          continue;
        }
        const value = rawProps[key];
        if (options) {
          if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(attrs, key)) {
            if (value !== attrs[key]) {
              attrs[key] = value;
              hasAttrsChanged = true;
            }
          } else {
            const camelizedKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(key);
            props[camelizedKey] = resolvePropValue(
              options,
              rawCurrentProps,
              camelizedKey,
              value,
              instance,
              false
            );
          }
        } else {
          if (value !== attrs[key]) {
            attrs[key] = value;
            hasAttrsChanged = true;
          }
        }
      }
    }
  } else {
    if (setFullProps(instance, rawProps, props, attrs)) {
      hasAttrsChanged = true;
    }
    let kebabKey;
    for (const key in rawCurrentProps) {
      if (!rawProps || // for camelCase
      !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(rawProps, key) && // it's possible the original props was passed in as kebab-case
      // and converted to camelCase (#955)
      ((kebabKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(key)) === key || !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(rawProps, kebabKey))) {
        if (options) {
          if (rawPrevProps && // for camelCase
          (rawPrevProps[key] !== void 0 || // for kebab-case
          rawPrevProps[kebabKey] !== void 0)) {
            props[key] = resolvePropValue(
              options,
              rawCurrentProps,
              key,
              void 0,
              instance,
              true
            );
          }
        } else {
          delete props[key];
        }
      }
    }
    if (attrs !== rawCurrentProps) {
      for (const key in attrs) {
        if (!rawProps || !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(rawProps, key) && true) {
          delete attrs[key];
          hasAttrsChanged = true;
        }
      }
    }
  }
  if (hasAttrsChanged) {
    (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.trigger)(instance.attrs, "set", "");
  }
  if (true) {
    validateProps(rawProps || {}, props, instance);
  }
}
function setFullProps(instance, rawProps, props, attrs) {
  const [options, needCastKeys] = instance.propsOptions;
  let hasAttrsChanged = false;
  let rawCastValues;
  if (rawProps) {
    for (let key in rawProps) {
      if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isReservedProp)(key)) {
        continue;
      }
      const value = rawProps[key];
      let camelKey;
      if (options && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(options, camelKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(key))) {
        if (!needCastKeys || !needCastKeys.includes(camelKey)) {
          props[camelKey] = value;
        } else {
          (rawCastValues || (rawCastValues = {}))[camelKey] = value;
        }
      } else if (!isEmitListener(instance.emitsOptions, key)) {
        if (!(key in attrs) || value !== attrs[key]) {
          attrs[key] = value;
          hasAttrsChanged = true;
        }
      }
    }
  }
  if (needCastKeys) {
    const rawCurrentProps = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(props);
    const castValues = rawCastValues || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;
    for (let i = 0; i < needCastKeys.length; i++) {
      const key = needCastKeys[i];
      props[key] = resolvePropValue(
        options,
        rawCurrentProps,
        key,
        castValues[key],
        instance,
        !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(castValues, key)
      );
    }
  }
  return hasAttrsChanged;
}
function resolvePropValue(options, props, key, value, instance, isAbsent) {
  const opt = options[key];
  if (opt != null) {
    const hasDefault = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(opt, "default");
    if (hasDefault && value === void 0) {
      const defaultValue = opt.default;
      if (opt.type !== Function && !opt.skipFactory && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(defaultValue)) {
        const { propsDefaults } = instance;
        if (key in propsDefaults) {
          value = propsDefaults[key];
        } else {
          const reset = setCurrentInstance(instance);
          value = propsDefaults[key] = defaultValue.call(
            null,
            props
          );
          reset();
        }
      } else {
        value = defaultValue;
      }
      if (instance.ce) {
        instance.ce._setProp(key, value);
      }
    }
    if (opt[0 /* shouldCast */]) {
      if (isAbsent && !hasDefault) {
        value = false;
      } else if (opt[1 /* shouldCastTrue */] && (value === "" || value === (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(key))) {
        value = true;
      }
    }
  }
  return value;
}
const mixinPropsCache = /* @__PURE__ */ new WeakMap();
function normalizePropsOptions(comp, appContext, asMixin = false) {
  const cache =  true && asMixin ? mixinPropsCache : appContext.propsCache;
  const cached = cache.get(comp);
  if (cached) {
    return cached;
  }
  const raw = comp.props;
  const normalized = {};
  const needCastKeys = [];
  let hasExtends = false;
  if ( true && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(comp)) {
    const extendProps = (raw2) => {
      hasExtends = true;
      const [props, keys] = normalizePropsOptions(raw2, appContext, true);
      (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(normalized, props);
      if (keys) needCastKeys.push(...keys);
    };
    if (!asMixin && appContext.mixins.length) {
      appContext.mixins.forEach(extendProps);
    }
    if (comp.extends) {
      extendProps(comp.extends);
    }
    if (comp.mixins) {
      comp.mixins.forEach(extendProps);
    }
  }
  if (!raw && !hasExtends) {
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(comp)) {
      cache.set(comp, _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_ARR);
    }
    return _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_ARR;
  }
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(raw)) {
    for (let i = 0; i < raw.length; i++) {
      if ( true && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(raw[i])) {
        warn$1(`props must be strings when using array syntax.`, raw[i]);
      }
      const normalizedKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(raw[i]);
      if (validatePropName(normalizedKey)) {
        normalized[normalizedKey] = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;
      }
    }
  } else if (raw) {
    if ( true && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(raw)) {
      warn$1(`invalid props options`, raw);
    }
    for (const key in raw) {
      const normalizedKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(key);
      if (validatePropName(normalizedKey)) {
        const opt = raw[key];
        const prop = normalized[normalizedKey] = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(opt) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(opt) ? { type: opt } : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, opt);
        const propType = prop.type;
        let shouldCast = false;
        let shouldCastTrue = true;
        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(propType)) {
          for (let index = 0; index < propType.length; ++index) {
            const type = propType[index];
            const typeName = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(type) && type.name;
            if (typeName === "Boolean") {
              shouldCast = true;
              break;
            } else if (typeName === "String") {
              shouldCastTrue = false;
            }
          }
        } else {
          shouldCast = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(propType) && propType.name === "Boolean";
        }
        prop[0 /* shouldCast */] = shouldCast;
        prop[1 /* shouldCastTrue */] = shouldCastTrue;
        if (shouldCast || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(prop, "default")) {
          needCastKeys.push(normalizedKey);
        }
      }
    }
  }
  const res = [normalized, needCastKeys];
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(comp)) {
    cache.set(comp, res);
  }
  return res;
}
function validatePropName(key) {
  if (key[0] !== "$" && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isReservedProp)(key)) {
    return true;
  } else if (true) {
    warn$1(`Invalid prop name: "${key}" is a reserved property.`);
  }
  return false;
}
function getType(ctor) {
  if (ctor === null) {
    return "null";
  }
  if (typeof ctor === "function") {
    return ctor.name || "";
  } else if (typeof ctor === "object") {
    const name = ctor.constructor && ctor.constructor.name;
    return name || "";
  }
  return "";
}
function validateProps(rawProps, props, instance) {
  const resolvedValues = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(props);
  const options = instance.propsOptions[0];
  const camelizePropsKey = Object.keys(rawProps).map((key) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(key));
  for (const key in options) {
    let opt = options[key];
    if (opt == null) continue;
    validateProp(
      key,
      resolvedValues[key],
      opt,
       true ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(resolvedValues) : 0,
      !camelizePropsKey.includes(key)
    );
  }
}
function validateProp(name, value, prop, props, isAbsent) {
  const { type, required, validator, skipCheck } = prop;
  if (required && isAbsent) {
    warn$1('Missing required prop: "' + name + '"');
    return;
  }
  if (value == null && !required) {
    return;
  }
  if (type != null && type !== true && !skipCheck) {
    let isValid = false;
    const types = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(type) ? type : [type];
    const expectedTypes = [];
    for (let i = 0; i < types.length && !isValid; i++) {
      const { valid, expectedType } = assertType(value, types[i]);
      expectedTypes.push(expectedType || "");
      isValid = valid;
    }
    if (!isValid) {
      warn$1(getInvalidTypeMessage(name, value, expectedTypes));
      return;
    }
  }
  if (validator && !validator(value, props)) {
    warn$1('Invalid prop: custom validator check failed for prop "' + name + '".');
  }
}
const isSimpleType = /* @__PURE__ */ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.makeMap)(
  "String,Number,Boolean,Function,Symbol,BigInt"
);
function assertType(value, type) {
  let valid;
  const expectedType = getType(type);
  if (expectedType === "null") {
    valid = value === null;
  } else if (isSimpleType(expectedType)) {
    const t = typeof value;
    valid = t === expectedType.toLowerCase();
    if (!valid && t === "object") {
      valid = value instanceof type;
    }
  } else if (expectedType === "Object") {
    valid = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(value);
  } else if (expectedType === "Array") {
    valid = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(value);
  } else {
    valid = value instanceof type;
  }
  return {
    valid,
    expectedType
  };
}
function getInvalidTypeMessage(name, value, expectedTypes) {
  if (expectedTypes.length === 0) {
    return `Prop type [] for prop "${name}" won't match anything. Did you mean to use type Array instead?`;
  }
  let message = `Invalid prop: type check failed for prop "${name}". Expected ${expectedTypes.map(_vue_shared__WEBPACK_IMPORTED_MODULE_1__.capitalize).join(" | ")}`;
  const expectedType = expectedTypes[0];
  const receivedType = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toRawType)(value);
  const expectedValue = styleValue(value, expectedType);
  const receivedValue = styleValue(value, receivedType);
  if (expectedTypes.length === 1 && isExplicable(expectedType) && !isBoolean(expectedType, receivedType)) {
    message += ` with value ${expectedValue}`;
  }
  message += `, got ${receivedType} `;
  if (isExplicable(receivedType)) {
    message += `with value ${receivedValue}.`;
  }
  return message;
}
function styleValue(value, type) {
  if (type === "String") {
    return `"${value}"`;
  } else if (type === "Number") {
    return `${Number(value)}`;
  } else {
    return `${value}`;
  }
}
function isExplicable(type) {
  const explicitTypes = ["string", "number", "boolean"];
  return explicitTypes.some((elem) => type.toLowerCase() === elem);
}
function isBoolean(...args) {
  return args.some((elem) => elem.toLowerCase() === "boolean");
}

const isInternalKey = (key) => key[0] === "_" || key === "$stable";
const normalizeSlotValue = (value) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(value) ? value.map(normalizeVNode) : [normalizeVNode(value)];
const normalizeSlot = (key, rawSlot, ctx) => {
  if (rawSlot._n) {
    return rawSlot;
  }
  const normalized = withCtx((...args) => {
    if ( true && currentInstance && !(ctx === null && currentRenderingInstance) && !(ctx && ctx.root !== currentInstance.root)) {
      warn$1(
        `Slot "${key}" invoked outside of the render function: this will not track dependencies used in the slot. Invoke the slot function inside the render function instead.`
      );
    }
    return normalizeSlotValue(rawSlot(...args));
  }, ctx);
  normalized._c = false;
  return normalized;
};
const normalizeObjectSlots = (rawSlots, slots, instance) => {
  const ctx = rawSlots._ctx;
  for (const key in rawSlots) {
    if (isInternalKey(key)) continue;
    const value = rawSlots[key];
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(value)) {
      slots[key] = normalizeSlot(key, value, ctx);
    } else if (value != null) {
      if (true) {
        warn$1(
          `Non-function value encountered for slot "${key}". Prefer function slots for better performance.`
        );
      }
      const normalized = normalizeSlotValue(value);
      slots[key] = () => normalized;
    }
  }
};
const normalizeVNodeSlots = (instance, children) => {
  if ( true && !isKeepAlive(instance.vnode) && true) {
    warn$1(
      `Non-function value encountered for default slot. Prefer function slots for better performance.`
    );
  }
  const normalized = normalizeSlotValue(children);
  instance.slots.default = () => normalized;
};
const assignSlots = (slots, children, optimized) => {
  for (const key in children) {
    if (optimized || !isInternalKey(key)) {
      slots[key] = children[key];
    }
  }
};
const initSlots = (instance, children, optimized) => {
  const slots = instance.slots = createInternalObject();
  if (instance.vnode.shapeFlag & 32) {
    const type = children._;
    if (type) {
      assignSlots(slots, children, optimized);
      if (optimized) {
        (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.def)(slots, "_", type, true);
      }
    } else {
      normalizeObjectSlots(children, slots);
    }
  } else if (children) {
    normalizeVNodeSlots(instance, children);
  }
};
const updateSlots = (instance, children, optimized) => {
  const { vnode, slots } = instance;
  let needDeletionCheck = true;
  let deletionComparisonTarget = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;
  if (vnode.shapeFlag & 32) {
    const type = children._;
    if (type) {
      if ( true && isHmrUpdating) {
        assignSlots(slots, children, optimized);
        (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.trigger)(instance, "set", "$slots");
      } else if (optimized && type === 1) {
        needDeletionCheck = false;
      } else {
        assignSlots(slots, children, optimized);
      }
    } else {
      needDeletionCheck = !children.$stable;
      normalizeObjectSlots(children, slots);
    }
    deletionComparisonTarget = children;
  } else if (children) {
    normalizeVNodeSlots(instance, children);
    deletionComparisonTarget = { default: 1 };
  }
  if (needDeletionCheck) {
    for (const key in slots) {
      if (!isInternalKey(key) && deletionComparisonTarget[key] == null) {
        delete slots[key];
      }
    }
  }
};

let supported;
let perf;
function startMeasure(instance, type) {
  if (instance.appContext.config.performance && isSupported()) {
    perf.mark(`vue-${type}-${instance.uid}`);
  }
  if (true) {
    devtoolsPerfStart(instance, type, isSupported() ? perf.now() : Date.now());
  }
}
function endMeasure(instance, type) {
  if (instance.appContext.config.performance && isSupported()) {
    const startTag = `vue-${type}-${instance.uid}`;
    const endTag = startTag + `:end`;
    perf.mark(endTag);
    perf.measure(
      `<${formatComponentName(instance, instance.type)}> ${type}`,
      startTag,
      endTag
    );
    perf.clearMarks(startTag);
    perf.clearMarks(endTag);
  }
  if (true) {
    devtoolsPerfEnd(instance, type, isSupported() ? perf.now() : Date.now());
  }
}
function isSupported() {
  if (supported !== void 0) {
    return supported;
  }
  if (typeof window !== "undefined" && window.performance) {
    supported = true;
    perf = window.performance;
  } else {
    supported = false;
  }
  return supported;
}

function initFeatureFlags() {
  const needWarn = [];
  if (false) {}
  if (false) {}
  if (false) {}
  if ( true && needWarn.length) {
    const multi = needWarn.length > 1;
    console.warn(
      `Feature flag${multi ? `s` : ``} ${needWarn.join(", ")} ${multi ? `are` : `is`} not explicitly defined. You are running the esm-bundler build of Vue, which expects these compile-time feature flags to be globally injected via the bundler config in order to get better tree-shaking in the production bundle.

For more details, see https://link.vuejs.org/feature-flags.`
    );
  }
}

const queuePostRenderEffect = queueEffectWithSuspense ;
function createRenderer(options) {
  return baseCreateRenderer(options);
}
function createHydrationRenderer(options) {
  return baseCreateRenderer(options, createHydrationFunctions);
}
function baseCreateRenderer(options, createHydrationFns) {
  {
    initFeatureFlags();
  }
  const target = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.getGlobalThis)();
  target.__VUE__ = true;
  if (true) {
    setDevtoolsHook$1(target.__VUE_DEVTOOLS_GLOBAL_HOOK__, target);
  }
  const {
    insert: hostInsert,
    remove: hostRemove,
    patchProp: hostPatchProp,
    createElement: hostCreateElement,
    createText: hostCreateText,
    createComment: hostCreateComment,
    setText: hostSetText,
    setElementText: hostSetElementText,
    parentNode: hostParentNode,
    nextSibling: hostNextSibling,
    setScopeId: hostSetScopeId = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP,
    insertStaticContent: hostInsertStaticContent
  } = options;
  const patch = (n1, n2, container, anchor = null, parentComponent = null, parentSuspense = null, namespace = void 0, slotScopeIds = null, optimized =  true && isHmrUpdating ? false : !!n2.dynamicChildren) => {
    if (n1 === n2) {
      return;
    }
    if (n1 && !isSameVNodeType(n1, n2)) {
      anchor = getNextHostNode(n1);
      unmount(n1, parentComponent, parentSuspense, true);
      n1 = null;
    }
    if (n2.patchFlag === -2) {
      optimized = false;
      n2.dynamicChildren = null;
    }
    const { type, ref, shapeFlag } = n2;
    switch (type) {
      case Text:
        processText(n1, n2, container, anchor);
        break;
      case Comment:
        processCommentNode(n1, n2, container, anchor);
        break;
      case Static:
        if (n1 == null) {
          mountStaticNode(n2, container, anchor, namespace);
        } else if (true) {
          patchStaticNode(n1, n2, container, namespace);
        }
        break;
      case Fragment:
        processFragment(
          n1,
          n2,
          container,
          anchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
        break;
      default:
        if (shapeFlag & 1) {
          processElement(
            n1,
            n2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
        } else if (shapeFlag & 6) {
          processComponent(
            n1,
            n2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
        } else if (shapeFlag & 64) {
          type.process(
            n1,
            n2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized,
            internals
          );
        } else if (shapeFlag & 128) {
          type.process(
            n1,
            n2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized,
            internals
          );
        } else if (true) {
          warn$1("Invalid VNode type:", type, `(${typeof type})`);
        }
    }
    if (ref != null && parentComponent) {
      setRef(ref, n1 && n1.ref, parentSuspense, n2 || n1, !n2);
    }
  };
  const processText = (n1, n2, container, anchor) => {
    if (n1 == null) {
      hostInsert(
        n2.el = hostCreateText(n2.children),
        container,
        anchor
      );
    } else {
      const el = n2.el = n1.el;
      if (n2.children !== n1.children) {
        hostSetText(el, n2.children);
      }
    }
  };
  const processCommentNode = (n1, n2, container, anchor) => {
    if (n1 == null) {
      hostInsert(
        n2.el = hostCreateComment(n2.children || ""),
        container,
        anchor
      );
    } else {
      n2.el = n1.el;
    }
  };
  const mountStaticNode = (n2, container, anchor, namespace) => {
    [n2.el, n2.anchor] = hostInsertStaticContent(
      n2.children,
      container,
      anchor,
      namespace,
      n2.el,
      n2.anchor
    );
  };
  const patchStaticNode = (n1, n2, container, namespace) => {
    if (n2.children !== n1.children) {
      const anchor = hostNextSibling(n1.anchor);
      removeStaticNode(n1);
      [n2.el, n2.anchor] = hostInsertStaticContent(
        n2.children,
        container,
        anchor,
        namespace
      );
    } else {
      n2.el = n1.el;
      n2.anchor = n1.anchor;
    }
  };
  const moveStaticNode = ({ el, anchor }, container, nextSibling) => {
    let next;
    while (el && el !== anchor) {
      next = hostNextSibling(el);
      hostInsert(el, container, nextSibling);
      el = next;
    }
    hostInsert(anchor, container, nextSibling);
  };
  const removeStaticNode = ({ el, anchor }) => {
    let next;
    while (el && el !== anchor) {
      next = hostNextSibling(el);
      hostRemove(el);
      el = next;
    }
    hostRemove(anchor);
  };
  const processElement = (n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
    if (n2.type === "svg") {
      namespace = "svg";
    } else if (n2.type === "math") {
      namespace = "mathml";
    }
    if (n1 == null) {
      mountElement(
        n2,
        container,
        anchor,
        parentComponent,
        parentSuspense,
        namespace,
        slotScopeIds,
        optimized
      );
    } else {
      patchElement(
        n1,
        n2,
        parentComponent,
        parentSuspense,
        namespace,
        slotScopeIds,
        optimized
      );
    }
  };
  const mountElement = (vnode, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
    let el;
    let vnodeHook;
    const { props, shapeFlag, transition, dirs } = vnode;
    el = vnode.el = hostCreateElement(
      vnode.type,
      namespace,
      props && props.is,
      props
    );
    if (shapeFlag & 8) {
      hostSetElementText(el, vnode.children);
    } else if (shapeFlag & 16) {
      mountChildren(
        vnode.children,
        el,
        null,
        parentComponent,
        parentSuspense,
        resolveChildrenNamespace(vnode, namespace),
        slotScopeIds,
        optimized
      );
    }
    if (dirs) {
      invokeDirectiveHook(vnode, null, parentComponent, "created");
    }
    setScopeId(el, vnode, vnode.scopeId, slotScopeIds, parentComponent);
    if (props) {
      for (const key in props) {
        if (key !== "value" && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isReservedProp)(key)) {
          hostPatchProp(el, key, null, props[key], namespace, parentComponent);
        }
      }
      if ("value" in props) {
        hostPatchProp(el, "value", null, props.value, namespace);
      }
      if (vnodeHook = props.onVnodeBeforeMount) {
        invokeVNodeHook(vnodeHook, parentComponent, vnode);
      }
    }
    if (true) {
      (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.def)(el, "__vnode", vnode, true);
      (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.def)(el, "__vueParentComponent", parentComponent, true);
    }
    if (dirs) {
      invokeDirectiveHook(vnode, null, parentComponent, "beforeMount");
    }
    const needCallTransitionHooks = needTransition(parentSuspense, transition);
    if (needCallTransitionHooks) {
      transition.beforeEnter(el);
    }
    hostInsert(el, container, anchor);
    if ((vnodeHook = props && props.onVnodeMounted) || needCallTransitionHooks || dirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
        needCallTransitionHooks && transition.enter(el);
        dirs && invokeDirectiveHook(vnode, null, parentComponent, "mounted");
      }, parentSuspense);
    }
  };
  const setScopeId = (el, vnode, scopeId, slotScopeIds, parentComponent) => {
    if (scopeId) {
      hostSetScopeId(el, scopeId);
    }
    if (slotScopeIds) {
      for (let i = 0; i < slotScopeIds.length; i++) {
        hostSetScopeId(el, slotScopeIds[i]);
      }
    }
    if (parentComponent) {
      let subTree = parentComponent.subTree;
      if ( true && subTree.patchFlag > 0 && subTree.patchFlag & 2048) {
        subTree = filterSingleRoot(subTree.children) || subTree;
      }
      if (vnode === subTree || isSuspense(subTree.type) && (subTree.ssContent === vnode || subTree.ssFallback === vnode)) {
        const parentVNode = parentComponent.vnode;
        setScopeId(
          el,
          parentVNode,
          parentVNode.scopeId,
          parentVNode.slotScopeIds,
          parentComponent.parent
        );
      }
    }
  };
  const mountChildren = (children, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized, start = 0) => {
    for (let i = start; i < children.length; i++) {
      const child = children[i] = optimized ? cloneIfMounted(children[i]) : normalizeVNode(children[i]);
      patch(
        null,
        child,
        container,
        anchor,
        parentComponent,
        parentSuspense,
        namespace,
        slotScopeIds,
        optimized
      );
    }
  };
  const patchElement = (n1, n2, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
    const el = n2.el = n1.el;
    if (true) {
      el.__vnode = n2;
    }
    let { patchFlag, dynamicChildren, dirs } = n2;
    patchFlag |= n1.patchFlag & 16;
    const oldProps = n1.props || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;
    const newProps = n2.props || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;
    let vnodeHook;
    parentComponent && toggleRecurse(parentComponent, false);
    if (vnodeHook = newProps.onVnodeBeforeUpdate) {
      invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
    }
    if (dirs) {
      invokeDirectiveHook(n2, n1, parentComponent, "beforeUpdate");
    }
    parentComponent && toggleRecurse(parentComponent, true);
    if ( true && isHmrUpdating) {
      patchFlag = 0;
      optimized = false;
      dynamicChildren = null;
    }
    if (oldProps.innerHTML && newProps.innerHTML == null || oldProps.textContent && newProps.textContent == null) {
      hostSetElementText(el, "");
    }
    if (dynamicChildren) {
      patchBlockChildren(
        n1.dynamicChildren,
        dynamicChildren,
        el,
        parentComponent,
        parentSuspense,
        resolveChildrenNamespace(n2, namespace),
        slotScopeIds
      );
      if (true) {
        traverseStaticChildren(n1, n2);
      }
    } else if (!optimized) {
      patchChildren(
        n1,
        n2,
        el,
        null,
        parentComponent,
        parentSuspense,
        resolveChildrenNamespace(n2, namespace),
        slotScopeIds,
        false
      );
    }
    if (patchFlag > 0) {
      if (patchFlag & 16) {
        patchProps(el, oldProps, newProps, parentComponent, namespace);
      } else {
        if (patchFlag & 2) {
          if (oldProps.class !== newProps.class) {
            hostPatchProp(el, "class", null, newProps.class, namespace);
          }
        }
        if (patchFlag & 4) {
          hostPatchProp(el, "style", oldProps.style, newProps.style, namespace);
        }
        if (patchFlag & 8) {
          const propsToUpdate = n2.dynamicProps;
          for (let i = 0; i < propsToUpdate.length; i++) {
            const key = propsToUpdate[i];
            const prev = oldProps[key];
            const next = newProps[key];
            if (next !== prev || key === "value") {
              hostPatchProp(el, key, prev, next, namespace, parentComponent);
            }
          }
        }
      }
      if (patchFlag & 1) {
        if (n1.children !== n2.children) {
          hostSetElementText(el, n2.children);
        }
      }
    } else if (!optimized && dynamicChildren == null) {
      patchProps(el, oldProps, newProps, parentComponent, namespace);
    }
    if ((vnodeHook = newProps.onVnodeUpdated) || dirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
        dirs && invokeDirectiveHook(n2, n1, parentComponent, "updated");
      }, parentSuspense);
    }
  };
  const patchBlockChildren = (oldChildren, newChildren, fallbackContainer, parentComponent, parentSuspense, namespace, slotScopeIds) => {
    for (let i = 0; i < newChildren.length; i++) {
      const oldVNode = oldChildren[i];
      const newVNode = newChildren[i];
      const container = (
        // oldVNode may be an errored async setup() component inside Suspense
        // which will not have a mounted element
        oldVNode.el && // - In the case of a Fragment, we need to provide the actual parent
        // of the Fragment itself so it can move its children.
        (oldVNode.type === Fragment || // - In the case of different nodes, there is going to be a replacement
        // which also requires the correct parent container
        !isSameVNodeType(oldVNode, newVNode) || // - In the case of a component, it could contain anything.
        oldVNode.shapeFlag & (6 | 64 | 128)) ? hostParentNode(oldVNode.el) : (
          // In other cases, the parent container is not actually used so we
          // just pass the block element here to avoid a DOM parentNode call.
          fallbackContainer
        )
      );
      patch(
        oldVNode,
        newVNode,
        container,
        null,
        parentComponent,
        parentSuspense,
        namespace,
        slotScopeIds,
        true
      );
    }
  };
  const patchProps = (el, oldProps, newProps, parentComponent, namespace) => {
    if (oldProps !== newProps) {
      if (oldProps !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ) {
        for (const key in oldProps) {
          if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isReservedProp)(key) && !(key in newProps)) {
            hostPatchProp(
              el,
              key,
              oldProps[key],
              null,
              namespace,
              parentComponent
            );
          }
        }
      }
      for (const key in newProps) {
        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isReservedProp)(key)) continue;
        const next = newProps[key];
        const prev = oldProps[key];
        if (next !== prev && key !== "value") {
          hostPatchProp(el, key, prev, next, namespace, parentComponent);
        }
      }
      if ("value" in newProps) {
        hostPatchProp(el, "value", oldProps.value, newProps.value, namespace);
      }
    }
  };
  const processFragment = (n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
    const fragmentStartAnchor = n2.el = n1 ? n1.el : hostCreateText("");
    const fragmentEndAnchor = n2.anchor = n1 ? n1.anchor : hostCreateText("");
    let { patchFlag, dynamicChildren, slotScopeIds: fragmentSlotScopeIds } = n2;
    if ( true && // #5523 dev root fragment may inherit directives
    (isHmrUpdating || patchFlag & 2048)) {
      patchFlag = 0;
      optimized = false;
      dynamicChildren = null;
    }
    if (fragmentSlotScopeIds) {
      slotScopeIds = slotScopeIds ? slotScopeIds.concat(fragmentSlotScopeIds) : fragmentSlotScopeIds;
    }
    if (n1 == null) {
      hostInsert(fragmentStartAnchor, container, anchor);
      hostInsert(fragmentEndAnchor, container, anchor);
      mountChildren(
        // #10007
        // such fragment like `<></>` will be compiled into
        // a fragment which doesn't have a children.
        // In this case fallback to an empty array
        n2.children || [],
        container,
        fragmentEndAnchor,
        parentComponent,
        parentSuspense,
        namespace,
        slotScopeIds,
        optimized
      );
    } else {
      if (patchFlag > 0 && patchFlag & 64 && dynamicChildren && // #2715 the previous fragment could've been a BAILed one as a result
      // of renderSlot() with no valid children
      n1.dynamicChildren) {
        patchBlockChildren(
          n1.dynamicChildren,
          dynamicChildren,
          container,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds
        );
        if (true) {
          traverseStaticChildren(n1, n2);
        } else {}
      } else {
        patchChildren(
          n1,
          n2,
          container,
          fragmentEndAnchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
      }
    }
  };
  const processComponent = (n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
    n2.slotScopeIds = slotScopeIds;
    if (n1 == null) {
      if (n2.shapeFlag & 512) {
        parentComponent.ctx.activate(
          n2,
          container,
          anchor,
          namespace,
          optimized
        );
      } else {
        mountComponent(
          n2,
          container,
          anchor,
          parentComponent,
          parentSuspense,
          namespace,
          optimized
        );
      }
    } else {
      updateComponent(n1, n2, optimized);
    }
  };
  const mountComponent = (initialVNode, container, anchor, parentComponent, parentSuspense, namespace, optimized) => {
    const instance = (initialVNode.component = createComponentInstance(
      initialVNode,
      parentComponent,
      parentSuspense
    ));
    if ( true && instance.type.__hmrId) {
      registerHMR(instance);
    }
    if (true) {
      pushWarningContext(initialVNode);
      startMeasure(instance, `mount`);
    }
    if (isKeepAlive(initialVNode)) {
      instance.ctx.renderer = internals;
    }
    {
      if (true) {
        startMeasure(instance, `init`);
      }
      setupComponent(instance, false, optimized);
      if (true) {
        endMeasure(instance, `init`);
      }
    }
    if ( true && isHmrUpdating) initialVNode.el = null;
    if (instance.asyncDep) {
      parentSuspense && parentSuspense.registerDep(instance, setupRenderEffect, optimized);
      if (!initialVNode.el) {
        const placeholder = instance.subTree = createVNode(Comment);
        processCommentNode(null, placeholder, container, anchor);
      }
    } else {
      setupRenderEffect(
        instance,
        initialVNode,
        container,
        anchor,
        parentSuspense,
        namespace,
        optimized
      );
    }
    if (true) {
      popWarningContext();
      endMeasure(instance, `mount`);
    }
  };
  const updateComponent = (n1, n2, optimized) => {
    const instance = n2.component = n1.component;
    if (shouldUpdateComponent(n1, n2, optimized)) {
      if (instance.asyncDep && !instance.asyncResolved) {
        if (true) {
          pushWarningContext(n2);
        }
        updateComponentPreRender(instance, n2, optimized);
        if (true) {
          popWarningContext();
        }
        return;
      } else {
        instance.next = n2;
        instance.update();
      }
    } else {
      n2.el = n1.el;
      instance.vnode = n2;
    }
  };
  const setupRenderEffect = (instance, initialVNode, container, anchor, parentSuspense, namespace, optimized) => {
    const componentUpdateFn = () => {
      if (!instance.isMounted) {
        let vnodeHook;
        const { el, props } = initialVNode;
        const { bm, m, parent, root, type } = instance;
        const isAsyncWrapperVNode = isAsyncWrapper(initialVNode);
        toggleRecurse(instance, false);
        if (bm) {
          (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(bm);
        }
        if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeBeforeMount)) {
          invokeVNodeHook(vnodeHook, parent, initialVNode);
        }
        toggleRecurse(instance, true);
        if (el && hydrateNode) {
          const hydrateSubTree = () => {
            if (true) {
              startMeasure(instance, `render`);
            }
            instance.subTree = renderComponentRoot(instance);
            if (true) {
              endMeasure(instance, `render`);
            }
            if (true) {
              startMeasure(instance, `hydrate`);
            }
            hydrateNode(
              el,
              instance.subTree,
              instance,
              parentSuspense,
              null
            );
            if (true) {
              endMeasure(instance, `hydrate`);
            }
          };
          if (isAsyncWrapperVNode && type.__asyncHydrate) {
            type.__asyncHydrate(
              el,
              instance,
              hydrateSubTree
            );
          } else {
            hydrateSubTree();
          }
        } else {
          if (root.ce) {
            root.ce._injectChildStyle(type);
          }
          if (true) {
            startMeasure(instance, `render`);
          }
          const subTree = instance.subTree = renderComponentRoot(instance);
          if (true) {
            endMeasure(instance, `render`);
          }
          if (true) {
            startMeasure(instance, `patch`);
          }
          patch(
            null,
            subTree,
            container,
            anchor,
            instance,
            parentSuspense,
            namespace
          );
          if (true) {
            endMeasure(instance, `patch`);
          }
          initialVNode.el = subTree.el;
        }
        if (m) {
          queuePostRenderEffect(m, parentSuspense);
        }
        if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeMounted)) {
          const scopedInitialVNode = initialVNode;
          queuePostRenderEffect(
            () => invokeVNodeHook(vnodeHook, parent, scopedInitialVNode),
            parentSuspense
          );
        }
        if (initialVNode.shapeFlag & 256 || parent && isAsyncWrapper(parent.vnode) && parent.vnode.shapeFlag & 256) {
          instance.a && queuePostRenderEffect(instance.a, parentSuspense);
        }
        instance.isMounted = true;
        if (true) {
          devtoolsComponentAdded(instance);
        }
        initialVNode = container = anchor = null;
      } else {
        let { next, bu, u, parent, vnode } = instance;
        {
          const nonHydratedAsyncRoot = locateNonHydratedAsyncRoot(instance);
          if (nonHydratedAsyncRoot) {
            if (next) {
              next.el = vnode.el;
              updateComponentPreRender(instance, next, optimized);
            }
            nonHydratedAsyncRoot.asyncDep.then(() => {
              if (!instance.isUnmounted) {
                componentUpdateFn();
              }
            });
            return;
          }
        }
        let originNext = next;
        let vnodeHook;
        if (true) {
          pushWarningContext(next || instance.vnode);
        }
        toggleRecurse(instance, false);
        if (next) {
          next.el = vnode.el;
          updateComponentPreRender(instance, next, optimized);
        } else {
          next = vnode;
        }
        if (bu) {
          (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(bu);
        }
        if (vnodeHook = next.props && next.props.onVnodeBeforeUpdate) {
          invokeVNodeHook(vnodeHook, parent, next, vnode);
        }
        toggleRecurse(instance, true);
        if (true) {
          startMeasure(instance, `render`);
        }
        const nextTree = renderComponentRoot(instance);
        if (true) {
          endMeasure(instance, `render`);
        }
        const prevTree = instance.subTree;
        instance.subTree = nextTree;
        if (true) {
          startMeasure(instance, `patch`);
        }
        patch(
          prevTree,
          nextTree,
          // parent may have changed if it's in a teleport
          hostParentNode(prevTree.el),
          // anchor may have changed if it's in a fragment
          getNextHostNode(prevTree),
          instance,
          parentSuspense,
          namespace
        );
        if (true) {
          endMeasure(instance, `patch`);
        }
        next.el = nextTree.el;
        if (originNext === null) {
          updateHOCHostEl(instance, nextTree.el);
        }
        if (u) {
          queuePostRenderEffect(u, parentSuspense);
        }
        if (vnodeHook = next.props && next.props.onVnodeUpdated) {
          queuePostRenderEffect(
            () => invokeVNodeHook(vnodeHook, parent, next, vnode),
            parentSuspense
          );
        }
        if (true) {
          devtoolsComponentUpdated(instance);
        }
        if (true) {
          popWarningContext();
        }
      }
    };
    instance.scope.on();
    const effect = instance.effect = new _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ReactiveEffect(componentUpdateFn);
    instance.scope.off();
    const update = instance.update = effect.run.bind(effect);
    const job = instance.job = effect.runIfDirty.bind(effect);
    job.i = instance;
    job.id = instance.uid;
    effect.scheduler = () => queueJob(job);
    toggleRecurse(instance, true);
    if (true) {
      effect.onTrack = instance.rtc ? (e) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(instance.rtc, e) : void 0;
      effect.onTrigger = instance.rtg ? (e) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(instance.rtg, e) : void 0;
    }
    update();
  };
  const updateComponentPreRender = (instance, nextVNode, optimized) => {
    nextVNode.component = instance;
    const prevProps = instance.vnode.props;
    instance.vnode = nextVNode;
    instance.next = null;
    updateProps(instance, nextVNode.props, prevProps, optimized);
    updateSlots(instance, nextVNode.children, optimized);
    (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();
    flushPreFlushCbs(instance);
    (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();
  };
  const patchChildren = (n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized = false) => {
    const c1 = n1 && n1.children;
    const prevShapeFlag = n1 ? n1.shapeFlag : 0;
    const c2 = n2.children;
    const { patchFlag, shapeFlag } = n2;
    if (patchFlag > 0) {
      if (patchFlag & 128) {
        patchKeyedChildren(
          c1,
          c2,
          container,
          anchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
        return;
      } else if (patchFlag & 256) {
        patchUnkeyedChildren(
          c1,
          c2,
          container,
          anchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
        return;
      }
    }
    if (shapeFlag & 8) {
      if (prevShapeFlag & 16) {
        unmountChildren(c1, parentComponent, parentSuspense);
      }
      if (c2 !== c1) {
        hostSetElementText(container, c2);
      }
    } else {
      if (prevShapeFlag & 16) {
        if (shapeFlag & 16) {
          patchKeyedChildren(
            c1,
            c2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
        } else {
          unmountChildren(c1, parentComponent, parentSuspense, true);
        }
      } else {
        if (prevShapeFlag & 8) {
          hostSetElementText(container, "");
        }
        if (shapeFlag & 16) {
          mountChildren(
            c2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
        }
      }
    }
  };
  const patchUnkeyedChildren = (c1, c2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
    c1 = c1 || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_ARR;
    c2 = c2 || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_ARR;
    const oldLength = c1.length;
    const newLength = c2.length;
    const commonLength = Math.min(oldLength, newLength);
    let i;
    for (i = 0; i < commonLength; i++) {
      const nextChild = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
      patch(
        c1[i],
        nextChild,
        container,
        null,
        parentComponent,
        parentSuspense,
        namespace,
        slotScopeIds,
        optimized
      );
    }
    if (oldLength > newLength) {
      unmountChildren(
        c1,
        parentComponent,
        parentSuspense,
        true,
        false,
        commonLength
      );
    } else {
      mountChildren(
        c2,
        container,
        anchor,
        parentComponent,
        parentSuspense,
        namespace,
        slotScopeIds,
        optimized,
        commonLength
      );
    }
  };
  const patchKeyedChildren = (c1, c2, container, parentAnchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
    let i = 0;
    const l2 = c2.length;
    let e1 = c1.length - 1;
    let e2 = l2 - 1;
    while (i <= e1 && i <= e2) {
      const n1 = c1[i];
      const n2 = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
      if (isSameVNodeType(n1, n2)) {
        patch(
          n1,
          n2,
          container,
          null,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
      } else {
        break;
      }
      i++;
    }
    while (i <= e1 && i <= e2) {
      const n1 = c1[e1];
      const n2 = c2[e2] = optimized ? cloneIfMounted(c2[e2]) : normalizeVNode(c2[e2]);
      if (isSameVNodeType(n1, n2)) {
        patch(
          n1,
          n2,
          container,
          null,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
      } else {
        break;
      }
      e1--;
      e2--;
    }
    if (i > e1) {
      if (i <= e2) {
        const nextPos = e2 + 1;
        const anchor = nextPos < l2 ? c2[nextPos].el : parentAnchor;
        while (i <= e2) {
          patch(
            null,
            c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]),
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
          i++;
        }
      }
    } else if (i > e2) {
      while (i <= e1) {
        unmount(c1[i], parentComponent, parentSuspense, true);
        i++;
      }
    } else {
      const s1 = i;
      const s2 = i;
      const keyToNewIndexMap = /* @__PURE__ */ new Map();
      for (i = s2; i <= e2; i++) {
        const nextChild = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
        if (nextChild.key != null) {
          if ( true && keyToNewIndexMap.has(nextChild.key)) {
            warn$1(
              `Duplicate keys found during update:`,
              JSON.stringify(nextChild.key),
              `Make sure keys are unique.`
            );
          }
          keyToNewIndexMap.set(nextChild.key, i);
        }
      }
      let j;
      let patched = 0;
      const toBePatched = e2 - s2 + 1;
      let moved = false;
      let maxNewIndexSoFar = 0;
      const newIndexToOldIndexMap = new Array(toBePatched);
      for (i = 0; i < toBePatched; i++) newIndexToOldIndexMap[i] = 0;
      for (i = s1; i <= e1; i++) {
        const prevChild = c1[i];
        if (patched >= toBePatched) {
          unmount(prevChild, parentComponent, parentSuspense, true);
          continue;
        }
        let newIndex;
        if (prevChild.key != null) {
          newIndex = keyToNewIndexMap.get(prevChild.key);
        } else {
          for (j = s2; j <= e2; j++) {
            if (newIndexToOldIndexMap[j - s2] === 0 && isSameVNodeType(prevChild, c2[j])) {
              newIndex = j;
              break;
            }
          }
        }
        if (newIndex === void 0) {
          unmount(prevChild, parentComponent, parentSuspense, true);
        } else {
          newIndexToOldIndexMap[newIndex - s2] = i + 1;
          if (newIndex >= maxNewIndexSoFar) {
            maxNewIndexSoFar = newIndex;
          } else {
            moved = true;
          }
          patch(
            prevChild,
            c2[newIndex],
            container,
            null,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
          patched++;
        }
      }
      const increasingNewIndexSequence = moved ? getSequence(newIndexToOldIndexMap) : _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_ARR;
      j = increasingNewIndexSequence.length - 1;
      for (i = toBePatched - 1; i >= 0; i--) {
        const nextIndex = s2 + i;
        const nextChild = c2[nextIndex];
        const anchor = nextIndex + 1 < l2 ? c2[nextIndex + 1].el : parentAnchor;
        if (newIndexToOldIndexMap[i] === 0) {
          patch(
            null,
            nextChild,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
        } else if (moved) {
          if (j < 0 || i !== increasingNewIndexSequence[j]) {
            move(nextChild, container, anchor, 2);
          } else {
            j--;
          }
        }
      }
    }
  };
  const move = (vnode, container, anchor, moveType, parentSuspense = null) => {
    const { el, type, transition, children, shapeFlag } = vnode;
    if (shapeFlag & 6) {
      move(vnode.component.subTree, container, anchor, moveType);
      return;
    }
    if (shapeFlag & 128) {
      vnode.suspense.move(container, anchor, moveType);
      return;
    }
    if (shapeFlag & 64) {
      type.move(vnode, container, anchor, internals);
      return;
    }
    if (type === Fragment) {
      hostInsert(el, container, anchor);
      for (let i = 0; i < children.length; i++) {
        move(children[i], container, anchor, moveType);
      }
      hostInsert(vnode.anchor, container, anchor);
      return;
    }
    if (type === Static) {
      moveStaticNode(vnode, container, anchor);
      return;
    }
    const needTransition2 = moveType !== 2 && shapeFlag & 1 && transition;
    if (needTransition2) {
      if (moveType === 0) {
        transition.beforeEnter(el);
        hostInsert(el, container, anchor);
        queuePostRenderEffect(() => transition.enter(el), parentSuspense);
      } else {
        const { leave, delayLeave, afterLeave } = transition;
        const remove2 = () => {
          if (vnode.ctx.isUnmounted) {
            hostRemove(el);
          } else {
            hostInsert(el, container, anchor);
          }
        };
        const performLeave = () => {
          leave(el, () => {
            remove2();
            afterLeave && afterLeave();
          });
        };
        if (delayLeave) {
          delayLeave(el, remove2, performLeave);
        } else {
          performLeave();
        }
      }
    } else {
      hostInsert(el, container, anchor);
    }
  };
  const unmount = (vnode, parentComponent, parentSuspense, doRemove = false, optimized = false) => {
    const {
      type,
      props,
      ref,
      children,
      dynamicChildren,
      shapeFlag,
      patchFlag,
      dirs,
      cacheIndex
    } = vnode;
    if (patchFlag === -2) {
      optimized = false;
    }
    if (ref != null) {
      (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();
      setRef(ref, null, parentSuspense, vnode, true);
      (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();
    }
    if (cacheIndex != null) {
      parentComponent.renderCache[cacheIndex] = void 0;
    }
    if (shapeFlag & 256) {
      parentComponent.ctx.deactivate(vnode);
      return;
    }
    const shouldInvokeDirs = shapeFlag & 1 && dirs;
    const shouldInvokeVnodeHook = !isAsyncWrapper(vnode);
    let vnodeHook;
    if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeBeforeUnmount)) {
      invokeVNodeHook(vnodeHook, parentComponent, vnode);
    }
    if (shapeFlag & 6) {
      unmountComponent(vnode.component, parentSuspense, doRemove);
    } else {
      if (shapeFlag & 128) {
        vnode.suspense.unmount(parentSuspense, doRemove);
        return;
      }
      if (shouldInvokeDirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "beforeUnmount");
      }
      if (shapeFlag & 64) {
        vnode.type.remove(
          vnode,
          parentComponent,
          parentSuspense,
          internals,
          doRemove
        );
      } else if (dynamicChildren && // #5154
      // when v-once is used inside a block, setBlockTracking(-1) marks the
      // parent block with hasOnce: true
      // so that it doesn't take the fast path during unmount - otherwise
      // components nested in v-once are never unmounted.
      !dynamicChildren.hasOnce && // #1153: fast path should not be taken for non-stable (v-for) fragments
      (type !== Fragment || patchFlag > 0 && patchFlag & 64)) {
        unmountChildren(
          dynamicChildren,
          parentComponent,
          parentSuspense,
          false,
          true
        );
      } else if (type === Fragment && patchFlag & (128 | 256) || !optimized && shapeFlag & 16) {
        unmountChildren(children, parentComponent, parentSuspense);
      }
      if (doRemove) {
        remove(vnode);
      }
    }
    if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeUnmounted) || shouldInvokeDirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
        shouldInvokeDirs && invokeDirectiveHook(vnode, null, parentComponent, "unmounted");
      }, parentSuspense);
    }
  };
  const remove = (vnode) => {
    const { type, el, anchor, transition } = vnode;
    if (type === Fragment) {
      if ( true && vnode.patchFlag > 0 && vnode.patchFlag & 2048 && transition && !transition.persisted) {
        vnode.children.forEach((child) => {
          if (child.type === Comment) {
            hostRemove(child.el);
          } else {
            remove(child);
          }
        });
      } else {
        removeFragment(el, anchor);
      }
      return;
    }
    if (type === Static) {
      removeStaticNode(vnode);
      return;
    }
    const performRemove = () => {
      hostRemove(el);
      if (transition && !transition.persisted && transition.afterLeave) {
        transition.afterLeave();
      }
    };
    if (vnode.shapeFlag & 1 && transition && !transition.persisted) {
      const { leave, delayLeave } = transition;
      const performLeave = () => leave(el, performRemove);
      if (delayLeave) {
        delayLeave(vnode.el, performRemove, performLeave);
      } else {
        performLeave();
      }
    } else {
      performRemove();
    }
  };
  const removeFragment = (cur, end) => {
    let next;
    while (cur !== end) {
      next = hostNextSibling(cur);
      hostRemove(cur);
      cur = next;
    }
    hostRemove(end);
  };
  const unmountComponent = (instance, parentSuspense, doRemove) => {
    if ( true && instance.type.__hmrId) {
      unregisterHMR(instance);
    }
    const {
      bum,
      scope,
      job,
      subTree,
      um,
      m,
      a,
      parent,
      slots: { __: slotCacheKeys }
    } = instance;
    invalidateMount(m);
    invalidateMount(a);
    if (bum) {
      (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(bum);
    }
    if (parent && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(slotCacheKeys)) {
      slotCacheKeys.forEach((v) => {
        parent.renderCache[v] = void 0;
      });
    }
    scope.stop();
    if (job) {
      job.flags |= 8;
      unmount(subTree, instance, parentSuspense, doRemove);
    }
    if (um) {
      queuePostRenderEffect(um, parentSuspense);
    }
    queuePostRenderEffect(() => {
      instance.isUnmounted = true;
    }, parentSuspense);
    if (parentSuspense && parentSuspense.pendingBranch && !parentSuspense.isUnmounted && instance.asyncDep && !instance.asyncResolved && instance.suspenseId === parentSuspense.pendingId) {
      parentSuspense.deps--;
      if (parentSuspense.deps === 0) {
        parentSuspense.resolve();
      }
    }
    if (true) {
      devtoolsComponentRemoved(instance);
    }
  };
  const unmountChildren = (children, parentComponent, parentSuspense, doRemove = false, optimized = false, start = 0) => {
    for (let i = start; i < children.length; i++) {
      unmount(children[i], parentComponent, parentSuspense, doRemove, optimized);
    }
  };
  const getNextHostNode = (vnode) => {
    if (vnode.shapeFlag & 6) {
      return getNextHostNode(vnode.component.subTree);
    }
    if (vnode.shapeFlag & 128) {
      return vnode.suspense.next();
    }
    const el = hostNextSibling(vnode.anchor || vnode.el);
    const teleportEnd = el && el[TeleportEndKey];
    return teleportEnd ? hostNextSibling(teleportEnd) : el;
  };
  let isFlushing = false;
  const render = (vnode, container, namespace) => {
    if (vnode == null) {
      if (container._vnode) {
        unmount(container._vnode, null, null, true);
      }
    } else {
      patch(
        container._vnode || null,
        vnode,
        container,
        null,
        null,
        null,
        namespace
      );
    }
    container._vnode = vnode;
    if (!isFlushing) {
      isFlushing = true;
      flushPreFlushCbs();
      flushPostFlushCbs();
      isFlushing = false;
    }
  };
  const internals = {
    p: patch,
    um: unmount,
    m: move,
    r: remove,
    mt: mountComponent,
    mc: mountChildren,
    pc: patchChildren,
    pbc: patchBlockChildren,
    n: getNextHostNode,
    o: options
  };
  let hydrate;
  let hydrateNode;
  if (createHydrationFns) {
    [hydrate, hydrateNode] = createHydrationFns(
      internals
    );
  }
  return {
    render,
    hydrate,
    createApp: createAppAPI(render, hydrate)
  };
}
function resolveChildrenNamespace({ type, props }, currentNamespace) {
  return currentNamespace === "svg" && type === "foreignObject" || currentNamespace === "mathml" && type === "annotation-xml" && props && props.encoding && props.encoding.includes("html") ? void 0 : currentNamespace;
}
function toggleRecurse({ effect, job }, allowed) {
  if (allowed) {
    effect.flags |= 32;
    job.flags |= 4;
  } else {
    effect.flags &= -33;
    job.flags &= -5;
  }
}
function needTransition(parentSuspense, transition) {
  return (!parentSuspense || parentSuspense && !parentSuspense.pendingBranch) && transition && !transition.persisted;
}
function traverseStaticChildren(n1, n2, shallow = false) {
  const ch1 = n1.children;
  const ch2 = n2.children;
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(ch1) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(ch2)) {
    for (let i = 0; i < ch1.length; i++) {
      const c1 = ch1[i];
      let c2 = ch2[i];
      if (c2.shapeFlag & 1 && !c2.dynamicChildren) {
        if (c2.patchFlag <= 0 || c2.patchFlag === 32) {
          c2 = ch2[i] = cloneIfMounted(ch2[i]);
          c2.el = c1.el;
        }
        if (!shallow && c2.patchFlag !== -2)
          traverseStaticChildren(c1, c2);
      }
      if (c2.type === Text) {
        c2.el = c1.el;
      }
      if (c2.type === Comment && !c2.el) {
        c2.el = c1.el;
      }
      if (true) {
        c2.el && (c2.el.__vnode = c2);
      }
    }
  }
}
function getSequence(arr) {
  const p = arr.slice();
  const result = [0];
  let i, j, u, v, c;
  const len = arr.length;
  for (i = 0; i < len; i++) {
    const arrI = arr[i];
    if (arrI !== 0) {
      j = result[result.length - 1];
      if (arr[j] < arrI) {
        p[i] = j;
        result.push(i);
        continue;
      }
      u = 0;
      v = result.length - 1;
      while (u < v) {
        c = u + v >> 1;
        if (arr[result[c]] < arrI) {
          u = c + 1;
        } else {
          v = c;
        }
      }
      if (arrI < arr[result[u]]) {
        if (u > 0) {
          p[i] = result[u - 1];
        }
        result[u] = i;
      }
    }
  }
  u = result.length;
  v = result[u - 1];
  while (u-- > 0) {
    result[u] = v;
    v = p[v];
  }
  return result;
}
function locateNonHydratedAsyncRoot(instance) {
  const subComponent = instance.subTree.component;
  if (subComponent) {
    if (subComponent.asyncDep && !subComponent.asyncResolved) {
      return subComponent;
    } else {
      return locateNonHydratedAsyncRoot(subComponent);
    }
  }
}
function invalidateMount(hooks) {
  if (hooks) {
    for (let i = 0; i < hooks.length; i++)
      hooks[i].flags |= 8;
  }
}

const ssrContextKey = Symbol.for("v-scx");
const useSSRContext = () => {
  {
    const ctx = inject(ssrContextKey);
    if (!ctx) {
       true && warn$1(
        `Server rendering context not provided. Make sure to only call useSSRContext() conditionally in the server build.`
      );
    }
    return ctx;
  }
};

function watchEffect(effect, options) {
  return doWatch(effect, null, options);
}
function watchPostEffect(effect, options) {
  return doWatch(
    effect,
    null,
     true ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, options, { flush: "post" }) : 0
  );
}
function watchSyncEffect(effect, options) {
  return doWatch(
    effect,
    null,
     true ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, options, { flush: "sync" }) : 0
  );
}
function watch(source, cb, options) {
  if ( true && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(cb)) {
    warn$1(
      `\`watch(fn, options?)\` signature has been moved to a separate API. Use \`watchEffect(fn, options?)\` instead. \`watch\` now only supports \`watch(source, cb, options?) signature.`
    );
  }
  return doWatch(source, cb, options);
}
function doWatch(source, cb, options = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ) {
  const { immediate, deep, flush, once } = options;
  if ( true && !cb) {
    if (immediate !== void 0) {
      warn$1(
        `watch() "immediate" option is only respected when using the watch(source, callback, options?) signature.`
      );
    }
    if (deep !== void 0) {
      warn$1(
        `watch() "deep" option is only respected when using the watch(source, callback, options?) signature.`
      );
    }
    if (once !== void 0) {
      warn$1(
        `watch() "once" option is only respected when using the watch(source, callback, options?) signature.`
      );
    }
  }
  const baseWatchOptions = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, options);
  if (true) baseWatchOptions.onWarn = warn$1;
  const runsImmediately = cb && immediate || !cb && flush !== "post";
  let ssrCleanup;
  if (isInSSRComponentSetup) {
    if (flush === "sync") {
      const ctx = useSSRContext();
      ssrCleanup = ctx.__watcherHandles || (ctx.__watcherHandles = []);
    } else if (!runsImmediately) {
      const watchStopHandle = () => {
      };
      watchStopHandle.stop = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP;
      watchStopHandle.resume = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP;
      watchStopHandle.pause = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP;
      return watchStopHandle;
    }
  }
  const instance = currentInstance;
  baseWatchOptions.call = (fn, type, args) => callWithAsyncErrorHandling(fn, instance, type, args);
  let isPre = false;
  if (flush === "post") {
    baseWatchOptions.scheduler = (job) => {
      queuePostRenderEffect(job, instance && instance.suspense);
    };
  } else if (flush !== "sync") {
    isPre = true;
    baseWatchOptions.scheduler = (job, isFirstRun) => {
      if (isFirstRun) {
        job();
      } else {
        queueJob(job);
      }
    };
  }
  baseWatchOptions.augmentJob = (job) => {
    if (cb) {
      job.flags |= 4;
    }
    if (isPre) {
      job.flags |= 2;
      if (instance) {
        job.id = instance.uid;
        job.i = instance;
      }
    }
  };
  const watchHandle = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.watch)(source, cb, baseWatchOptions);
  if (isInSSRComponentSetup) {
    if (ssrCleanup) {
      ssrCleanup.push(watchHandle);
    } else if (runsImmediately) {
      watchHandle();
    }
  }
  return watchHandle;
}
function instanceWatch(source, value, options) {
  const publicThis = this.proxy;
  const getter = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(source) ? source.includes(".") ? createPathGetter(publicThis, source) : () => publicThis[source] : source.bind(publicThis, publicThis);
  let cb;
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(value)) {
    cb = value;
  } else {
    cb = value.handler;
    options = value;
  }
  const reset = setCurrentInstance(this);
  const res = doWatch(getter, cb.bind(publicThis), options);
  reset();
  return res;
}
function createPathGetter(ctx, path) {
  const segments = path.split(".");
  return () => {
    let cur = ctx;
    for (let i = 0; i < segments.length && cur; i++) {
      cur = cur[segments[i]];
    }
    return cur;
  };
}

function useModel(props, name, options = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ) {
  const i = getCurrentInstance();
  if ( true && !i) {
    warn$1(`useModel() called without active instance.`);
    return (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ref)();
  }
  const camelizedName = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(name);
  if ( true && !i.propsOptions[0][camelizedName]) {
    warn$1(`useModel() called with prop "${name}" which is not declared.`);
    return (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ref)();
  }
  const hyphenatedName = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(name);
  const modifiers = getModelModifiers(props, camelizedName);
  const res = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.customRef)((track, trigger) => {
    let localValue;
    let prevSetValue = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;
    let prevEmittedValue;
    watchSyncEffect(() => {
      const propValue = props[camelizedName];
      if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasChanged)(localValue, propValue)) {
        localValue = propValue;
        trigger();
      }
    });
    return {
      get() {
        track();
        return options.get ? options.get(localValue) : localValue;
      },
      set(value) {
        const emittedValue = options.set ? options.set(value) : value;
        if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasChanged)(emittedValue, localValue) && !(prevSetValue !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasChanged)(value, prevSetValue))) {
          return;
        }
        const rawProps = i.vnode.props;
        if (!(rawProps && // check if parent has passed v-model
        (name in rawProps || camelizedName in rawProps || hyphenatedName in rawProps) && (`onUpdate:${name}` in rawProps || `onUpdate:${camelizedName}` in rawProps || `onUpdate:${hyphenatedName}` in rawProps))) {
          localValue = value;
          trigger();
        }
        i.emit(`update:${name}`, emittedValue);
        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasChanged)(value, emittedValue) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasChanged)(value, prevSetValue) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasChanged)(emittedValue, prevEmittedValue)) {
          trigger();
        }
        prevSetValue = value;
        prevEmittedValue = emittedValue;
      }
    };
  });
  res[Symbol.iterator] = () => {
    let i2 = 0;
    return {
      next() {
        if (i2 < 2) {
          return { value: i2++ ? modifiers || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ : res, done: false };
        } else {
          return { done: true };
        }
      }
    };
  };
  return res;
}
const getModelModifiers = (props, modelName) => {
  return modelName === "modelValue" || modelName === "model-value" ? props.modelModifiers : props[`${modelName}Modifiers`] || props[`${(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(modelName)}Modifiers`] || props[`${(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(modelName)}Modifiers`];
};

function emit(instance, event, ...rawArgs) {
  if (instance.isUnmounted) return;
  const props = instance.vnode.props || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;
  if (true) {
    const {
      emitsOptions,
      propsOptions: [propsOptions]
    } = instance;
    if (emitsOptions) {
      if (!(event in emitsOptions) && true) {
        if (!propsOptions || !((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(event)) in propsOptions)) {
          warn$1(
            `Component emitted event "${event}" but it is neither declared in the emits option nor as an "${(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(event))}" prop.`
          );
        }
      } else {
        const validator = emitsOptions[event];
        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(validator)) {
          const isValid = validator(...rawArgs);
          if (!isValid) {
            warn$1(
              `Invalid event arguments: event validation failed for event "${event}".`
            );
          }
        }
      }
    }
  }
  let args = rawArgs;
  const isModelListener = event.startsWith("update:");
  const modifiers = isModelListener && getModelModifiers(props, event.slice(7));
  if (modifiers) {
    if (modifiers.trim) {
      args = rawArgs.map((a) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(a) ? a.trim() : a);
    }
    if (modifiers.number) {
      args = rawArgs.map(_vue_shared__WEBPACK_IMPORTED_MODULE_1__.looseToNumber);
    }
  }
  if (true) {
    devtoolsComponentEmit(instance, event, args);
  }
  if (true) {
    const lowerCaseEvent = event.toLowerCase();
    if (lowerCaseEvent !== event && props[(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)(lowerCaseEvent)]) {
      warn$1(
        `Event "${lowerCaseEvent}" is emitted in component ${formatComponentName(
          instance,
          instance.type
        )} but the handler is registered for "${event}". Note that HTML attributes are case-insensitive and you cannot use v-on to listen to camelCase events when using in-DOM templates. You should probably use "${(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(
          event
        )}" instead of "${event}".`
      );
    }
  }
  let handlerName;
  let handler = props[handlerName = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)(event)] || // also try camelCase event handler (#2249)
  props[handlerName = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(event))];
  if (!handler && isModelListener) {
    handler = props[handlerName = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(event))];
  }
  if (handler) {
    callWithAsyncErrorHandling(
      handler,
      instance,
      6,
      args
    );
  }
  const onceHandler = props[handlerName + `Once`];
  if (onceHandler) {
    if (!instance.emitted) {
      instance.emitted = {};
    } else if (instance.emitted[handlerName]) {
      return;
    }
    instance.emitted[handlerName] = true;
    callWithAsyncErrorHandling(
      onceHandler,
      instance,
      6,
      args
    );
  }
}
function normalizeEmitsOptions(comp, appContext, asMixin = false) {
  const cache = appContext.emitsCache;
  const cached = cache.get(comp);
  if (cached !== void 0) {
    return cached;
  }
  const raw = comp.emits;
  let normalized = {};
  let hasExtends = false;
  if ( true && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(comp)) {
    const extendEmits = (raw2) => {
      const normalizedFromExtend = normalizeEmitsOptions(raw2, appContext, true);
      if (normalizedFromExtend) {
        hasExtends = true;
        (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(normalized, normalizedFromExtend);
      }
    };
    if (!asMixin && appContext.mixins.length) {
      appContext.mixins.forEach(extendEmits);
    }
    if (comp.extends) {
      extendEmits(comp.extends);
    }
    if (comp.mixins) {
      comp.mixins.forEach(extendEmits);
    }
  }
  if (!raw && !hasExtends) {
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(comp)) {
      cache.set(comp, null);
    }
    return null;
  }
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(raw)) {
    raw.forEach((key) => normalized[key] = null);
  } else {
    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(normalized, raw);
  }
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(comp)) {
    cache.set(comp, normalized);
  }
  return normalized;
}
function isEmitListener(options, key) {
  if (!options || !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isOn)(key)) {
    return false;
  }
  key = key.slice(2).replace(/Once$/, "");
  return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(options, key[0].toLowerCase() + key.slice(1)) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(options, (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(key)) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(options, key);
}

let accessedAttrs = false;
function markAttrsAccessed() {
  accessedAttrs = true;
}
function renderComponentRoot(instance) {
  const {
    type: Component,
    vnode,
    proxy,
    withProxy,
    propsOptions: [propsOptions],
    slots,
    attrs,
    emit,
    render,
    renderCache,
    props,
    data,
    setupState,
    ctx,
    inheritAttrs
  } = instance;
  const prev = setCurrentRenderingInstance(instance);
  let result;
  let fallthroughAttrs;
  if (true) {
    accessedAttrs = false;
  }
  try {
    if (vnode.shapeFlag & 4) {
      const proxyToUse = withProxy || proxy;
      const thisProxy =  true && setupState.__isScriptSetup ? new Proxy(proxyToUse, {
        get(target, key, receiver) {
          warn$1(
            `Property '${String(
              key
            )}' was accessed via 'this'. Avoid using 'this' in templates.`
          );
          return Reflect.get(target, key, receiver);
        }
      }) : proxyToUse;
      result = normalizeVNode(
        render.call(
          thisProxy,
          proxyToUse,
          renderCache,
           true ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(props) : 0,
          setupState,
          data,
          ctx
        )
      );
      fallthroughAttrs = attrs;
    } else {
      const render2 = Component;
      if ( true && attrs === props) {
        markAttrsAccessed();
      }
      result = normalizeVNode(
        render2.length > 1 ? render2(
           true ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(props) : 0,
           true ? {
            get attrs() {
              markAttrsAccessed();
              return (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(attrs);
            },
            slots,
            emit
          } : 0
        ) : render2(
           true ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(props) : 0,
          null
        )
      );
      fallthroughAttrs = Component.props ? attrs : getFunctionalFallthrough(attrs);
    }
  } catch (err) {
    blockStack.length = 0;
    handleError(err, instance, 1);
    result = createVNode(Comment);
  }
  let root = result;
  let setRoot = void 0;
  if ( true && result.patchFlag > 0 && result.patchFlag & 2048) {
    [root, setRoot] = getChildRoot(result);
  }
  if (fallthroughAttrs && inheritAttrs !== false) {
    const keys = Object.keys(fallthroughAttrs);
    const { shapeFlag } = root;
    if (keys.length) {
      if (shapeFlag & (1 | 6)) {
        if (propsOptions && keys.some(_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isModelListener)) {
          fallthroughAttrs = filterModelListeners(
            fallthroughAttrs,
            propsOptions
          );
        }
        root = cloneVNode(root, fallthroughAttrs, false, true);
      } else if ( true && !accessedAttrs && root.type !== Comment) {
        const allAttrs = Object.keys(attrs);
        const eventAttrs = [];
        const extraAttrs = [];
        for (let i = 0, l = allAttrs.length; i < l; i++) {
          const key = allAttrs[i];
          if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isOn)(key)) {
            if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isModelListener)(key)) {
              eventAttrs.push(key[2].toLowerCase() + key.slice(3));
            }
          } else {
            extraAttrs.push(key);
          }
        }
        if (extraAttrs.length) {
          warn$1(
            `Extraneous non-props attributes (${extraAttrs.join(", ")}) were passed to component but could not be automatically inherited because component renders fragment or text or teleport root nodes.`
          );
        }
        if (eventAttrs.length) {
          warn$1(
            `Extraneous non-emits event listeners (${eventAttrs.join(", ")}) were passed to component but could not be automatically inherited because component renders fragment or text root nodes. If the listener is intended to be a component custom event listener only, declare it using the "emits" option.`
          );
        }
      }
    }
  }
  if (vnode.dirs) {
    if ( true && !isElementRoot(root)) {
      warn$1(
        `Runtime directive used on component with non-element root node. The directives will not function as intended.`
      );
    }
    root = cloneVNode(root, null, false, true);
    root.dirs = root.dirs ? root.dirs.concat(vnode.dirs) : vnode.dirs;
  }
  if (vnode.transition) {
    if ( true && !isElementRoot(root)) {
      warn$1(
        `Component inside <Transition> renders non-element root node that cannot be animated.`
      );
    }
    setTransitionHooks(root, vnode.transition);
  }
  if ( true && setRoot) {
    setRoot(root);
  } else {
    result = root;
  }
  setCurrentRenderingInstance(prev);
  return result;
}
const getChildRoot = (vnode) => {
  const rawChildren = vnode.children;
  const dynamicChildren = vnode.dynamicChildren;
  const childRoot = filterSingleRoot(rawChildren, false);
  if (!childRoot) {
    return [vnode, void 0];
  } else if ( true && childRoot.patchFlag > 0 && childRoot.patchFlag & 2048) {
    return getChildRoot(childRoot);
  }
  const index = rawChildren.indexOf(childRoot);
  const dynamicIndex = dynamicChildren ? dynamicChildren.indexOf(childRoot) : -1;
  const setRoot = (updatedRoot) => {
    rawChildren[index] = updatedRoot;
    if (dynamicChildren) {
      if (dynamicIndex > -1) {
        dynamicChildren[dynamicIndex] = updatedRoot;
      } else if (updatedRoot.patchFlag > 0) {
        vnode.dynamicChildren = [...dynamicChildren, updatedRoot];
      }
    }
  };
  return [normalizeVNode(childRoot), setRoot];
};
function filterSingleRoot(children, recurse = true) {
  let singleRoot;
  for (let i = 0; i < children.length; i++) {
    const child = children[i];
    if (isVNode(child)) {
      if (child.type !== Comment || child.children === "v-if") {
        if (singleRoot) {
          return;
        } else {
          singleRoot = child;
          if ( true && recurse && singleRoot.patchFlag > 0 && singleRoot.patchFlag & 2048) {
            return filterSingleRoot(singleRoot.children);
          }
        }
      }
    } else {
      return;
    }
  }
  return singleRoot;
}
const getFunctionalFallthrough = (attrs) => {
  let res;
  for (const key in attrs) {
    if (key === "class" || key === "style" || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isOn)(key)) {
      (res || (res = {}))[key] = attrs[key];
    }
  }
  return res;
};
const filterModelListeners = (attrs, props) => {
  const res = {};
  for (const key in attrs) {
    if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isModelListener)(key) || !(key.slice(9) in props)) {
      res[key] = attrs[key];
    }
  }
  return res;
};
const isElementRoot = (vnode) => {
  return vnode.shapeFlag & (6 | 1) || vnode.type === Comment;
};
function shouldUpdateComponent(prevVNode, nextVNode, optimized) {
  const { props: prevProps, children: prevChildren, component } = prevVNode;
  const { props: nextProps, children: nextChildren, patchFlag } = nextVNode;
  const emits = component.emitsOptions;
  if ( true && (prevChildren || nextChildren) && isHmrUpdating) {
    return true;
  }
  if (nextVNode.dirs || nextVNode.transition) {
    return true;
  }
  if (optimized && patchFlag >= 0) {
    if (patchFlag & 1024) {
      return true;
    }
    if (patchFlag & 16) {
      if (!prevProps) {
        return !!nextProps;
      }
      return hasPropsChanged(prevProps, nextProps, emits);
    } else if (patchFlag & 8) {
      const dynamicProps = nextVNode.dynamicProps;
      for (let i = 0; i < dynamicProps.length; i++) {
        const key = dynamicProps[i];
        if (nextProps[key] !== prevProps[key] && !isEmitListener(emits, key)) {
          return true;
        }
      }
    }
  } else {
    if (prevChildren || nextChildren) {
      if (!nextChildren || !nextChildren.$stable) {
        return true;
      }
    }
    if (prevProps === nextProps) {
      return false;
    }
    if (!prevProps) {
      return !!nextProps;
    }
    if (!nextProps) {
      return true;
    }
    return hasPropsChanged(prevProps, nextProps, emits);
  }
  return false;
}
function hasPropsChanged(prevProps, nextProps, emitsOptions) {
  const nextKeys = Object.keys(nextProps);
  if (nextKeys.length !== Object.keys(prevProps).length) {
    return true;
  }
  for (let i = 0; i < nextKeys.length; i++) {
    const key = nextKeys[i];
    if (nextProps[key] !== prevProps[key] && !isEmitListener(emitsOptions, key)) {
      return true;
    }
  }
  return false;
}
function updateHOCHostEl({ vnode, parent }, el) {
  while (parent) {
    const root = parent.subTree;
    if (root.suspense && root.suspense.activeBranch === vnode) {
      root.el = vnode.el;
    }
    if (root === vnode) {
      (vnode = parent.vnode).el = el;
      parent = parent.parent;
    } else {
      break;
    }
  }
}

const isSuspense = (type) => type.__isSuspense;
let suspenseId = 0;
const SuspenseImpl = {
  name: "Suspense",
  // In order to make Suspense tree-shakable, we need to avoid importing it
  // directly in the renderer. The renderer checks for the __isSuspense flag
  // on a vnode's type and calls the `process` method, passing in renderer
  // internals.
  __isSuspense: true,
  process(n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized, rendererInternals) {
    if (n1 == null) {
      mountSuspense(
        n2,
        container,
        anchor,
        parentComponent,
        parentSuspense,
        namespace,
        slotScopeIds,
        optimized,
        rendererInternals
      );
    } else {
      if (parentSuspense && parentSuspense.deps > 0 && !n1.suspense.isInFallback) {
        n2.suspense = n1.suspense;
        n2.suspense.vnode = n2;
        n2.el = n1.el;
        return;
      }
      patchSuspense(
        n1,
        n2,
        container,
        anchor,
        parentComponent,
        namespace,
        slotScopeIds,
        optimized,
        rendererInternals
      );
    }
  },
  hydrate: hydrateSuspense,
  normalize: normalizeSuspenseChildren
};
const Suspense = SuspenseImpl ;
function triggerEvent(vnode, name) {
  const eventListener = vnode.props && vnode.props[name];
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(eventListener)) {
    eventListener();
  }
}
function mountSuspense(vnode, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized, rendererInternals) {
  const {
    p: patch,
    o: { createElement }
  } = rendererInternals;
  const hiddenContainer = createElement("div");
  const suspense = vnode.suspense = createSuspenseBoundary(
    vnode,
    parentSuspense,
    parentComponent,
    container,
    hiddenContainer,
    anchor,
    namespace,
    slotScopeIds,
    optimized,
    rendererInternals
  );
  patch(
    null,
    suspense.pendingBranch = vnode.ssContent,
    hiddenContainer,
    null,
    parentComponent,
    suspense,
    namespace,
    slotScopeIds
  );
  if (suspense.deps > 0) {
    triggerEvent(vnode, "onPending");
    triggerEvent(vnode, "onFallback");
    patch(
      null,
      vnode.ssFallback,
      container,
      anchor,
      parentComponent,
      null,
      // fallback tree will not have suspense context
      namespace,
      slotScopeIds
    );
    setActiveBranch(suspense, vnode.ssFallback);
  } else {
    suspense.resolve(false, true);
  }
}
function patchSuspense(n1, n2, container, anchor, parentComponent, namespace, slotScopeIds, optimized, { p: patch, um: unmount, o: { createElement } }) {
  const suspense = n2.suspense = n1.suspense;
  suspense.vnode = n2;
  n2.el = n1.el;
  const newBranch = n2.ssContent;
  const newFallback = n2.ssFallback;
  const { activeBranch, pendingBranch, isInFallback, isHydrating } = suspense;
  if (pendingBranch) {
    suspense.pendingBranch = newBranch;
    if (isSameVNodeType(newBranch, pendingBranch)) {
      patch(
        pendingBranch,
        newBranch,
        suspense.hiddenContainer,
        null,
        parentComponent,
        suspense,
        namespace,
        slotScopeIds,
        optimized
      );
      if (suspense.deps <= 0) {
        suspense.resolve();
      } else if (isInFallback) {
        if (!isHydrating) {
          patch(
            activeBranch,
            newFallback,
            container,
            anchor,
            parentComponent,
            null,
            // fallback tree will not have suspense context
            namespace,
            slotScopeIds,
            optimized
          );
          setActiveBranch(suspense, newFallback);
        }
      }
    } else {
      suspense.pendingId = suspenseId++;
      if (isHydrating) {
        suspense.isHydrating = false;
        suspense.activeBranch = pendingBranch;
      } else {
        unmount(pendingBranch, parentComponent, suspense);
      }
      suspense.deps = 0;
      suspense.effects.length = 0;
      suspense.hiddenContainer = createElement("div");
      if (isInFallback) {
        patch(
          null,
          newBranch,
          suspense.hiddenContainer,
          null,
          parentComponent,
          suspense,
          namespace,
          slotScopeIds,
          optimized
        );
        if (suspense.deps <= 0) {
          suspense.resolve();
        } else {
          patch(
            activeBranch,
            newFallback,
            container,
            anchor,
            parentComponent,
            null,
            // fallback tree will not have suspense context
            namespace,
            slotScopeIds,
            optimized
          );
          setActiveBranch(suspense, newFallback);
        }
      } else if (activeBranch && isSameVNodeType(newBranch, activeBranch)) {
        patch(
          activeBranch,
          newBranch,
          container,
          anchor,
          parentComponent,
          suspense,
          namespace,
          slotScopeIds,
          optimized
        );
        suspense.resolve(true);
      } else {
        patch(
          null,
          newBranch,
          suspense.hiddenContainer,
          null,
          parentComponent,
          suspense,
          namespace,
          slotScopeIds,
          optimized
        );
        if (suspense.deps <= 0) {
          suspense.resolve();
        }
      }
    }
  } else {
    if (activeBranch && isSameVNodeType(newBranch, activeBranch)) {
      patch(
        activeBranch,
        newBranch,
        container,
        anchor,
        parentComponent,
        suspense,
        namespace,
        slotScopeIds,
        optimized
      );
      setActiveBranch(suspense, newBranch);
    } else {
      triggerEvent(n2, "onPending");
      suspense.pendingBranch = newBranch;
      if (newBranch.shapeFlag & 512) {
        suspense.pendingId = newBranch.component.suspenseId;
      } else {
        suspense.pendingId = suspenseId++;
      }
      patch(
        null,
        newBranch,
        suspense.hiddenContainer,
        null,
        parentComponent,
        suspense,
        namespace,
        slotScopeIds,
        optimized
      );
      if (suspense.deps <= 0) {
        suspense.resolve();
      } else {
        const { timeout, pendingId } = suspense;
        if (timeout > 0) {
          setTimeout(() => {
            if (suspense.pendingId === pendingId) {
              suspense.fallback(newFallback);
            }
          }, timeout);
        } else if (timeout === 0) {
          suspense.fallback(newFallback);
        }
      }
    }
  }
}
let hasWarned = false;
function createSuspenseBoundary(vnode, parentSuspense, parentComponent, container, hiddenContainer, anchor, namespace, slotScopeIds, optimized, rendererInternals, isHydrating = false) {
  if ( true && !hasWarned) {
    hasWarned = true;
    console[console.info ? "info" : "log"](
      `<Suspense> is an experimental feature and its API will likely change.`
    );
  }
  const {
    p: patch,
    m: move,
    um: unmount,
    n: next,
    o: { parentNode, remove }
  } = rendererInternals;
  let parentSuspenseId;
  const isSuspensible = isVNodeSuspensible(vnode);
  if (isSuspensible) {
    if (parentSuspense && parentSuspense.pendingBranch) {
      parentSuspenseId = parentSuspense.pendingId;
      parentSuspense.deps++;
    }
  }
  const timeout = vnode.props ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toNumber)(vnode.props.timeout) : void 0;
  if (true) {
    assertNumber(timeout, `Suspense timeout`);
  }
  const initialAnchor = anchor;
  const suspense = {
    vnode,
    parent: parentSuspense,
    parentComponent,
    namespace,
    container,
    hiddenContainer,
    deps: 0,
    pendingId: suspenseId++,
    timeout: typeof timeout === "number" ? timeout : -1,
    activeBranch: null,
    pendingBranch: null,
    isInFallback: !isHydrating,
    isHydrating,
    isUnmounted: false,
    effects: [],
    resolve(resume = false, sync = false) {
      if (true) {
        if (!resume && !suspense.pendingBranch) {
          throw new Error(
            `suspense.resolve() is called without a pending branch.`
          );
        }
        if (suspense.isUnmounted) {
          throw new Error(
            `suspense.resolve() is called on an already unmounted suspense boundary.`
          );
        }
      }
      const {
        vnode: vnode2,
        activeBranch,
        pendingBranch,
        pendingId,
        effects,
        parentComponent: parentComponent2,
        container: container2
      } = suspense;
      let delayEnter = false;
      if (suspense.isHydrating) {
        suspense.isHydrating = false;
      } else if (!resume) {
        delayEnter = activeBranch && pendingBranch.transition && pendingBranch.transition.mode === "out-in";
        if (delayEnter) {
          activeBranch.transition.afterLeave = () => {
            if (pendingId === suspense.pendingId) {
              move(
                pendingBranch,
                container2,
                anchor === initialAnchor ? next(activeBranch) : anchor,
                0
              );
              queuePostFlushCb(effects);
            }
          };
        }
        if (activeBranch) {
          if (parentNode(activeBranch.el) === container2) {
            anchor = next(activeBranch);
          }
          unmount(activeBranch, parentComponent2, suspense, true);
        }
        if (!delayEnter) {
          move(pendingBranch, container2, anchor, 0);
        }
      }
      setActiveBranch(suspense, pendingBranch);
      suspense.pendingBranch = null;
      suspense.isInFallback = false;
      let parent = suspense.parent;
      let hasUnresolvedAncestor = false;
      while (parent) {
        if (parent.pendingBranch) {
          parent.effects.push(...effects);
          hasUnresolvedAncestor = true;
          break;
        }
        parent = parent.parent;
      }
      if (!hasUnresolvedAncestor && !delayEnter) {
        queuePostFlushCb(effects);
      }
      suspense.effects = [];
      if (isSuspensible) {
        if (parentSuspense && parentSuspense.pendingBranch && parentSuspenseId === parentSuspense.pendingId) {
          parentSuspense.deps--;
          if (parentSuspense.deps === 0 && !sync) {
            parentSuspense.resolve();
          }
        }
      }
      triggerEvent(vnode2, "onResolve");
    },
    fallback(fallbackVNode) {
      if (!suspense.pendingBranch) {
        return;
      }
      const { vnode: vnode2, activeBranch, parentComponent: parentComponent2, container: container2, namespace: namespace2 } = suspense;
      triggerEvent(vnode2, "onFallback");
      const anchor2 = next(activeBranch);
      const mountFallback = () => {
        if (!suspense.isInFallback) {
          return;
        }
        patch(
          null,
          fallbackVNode,
          container2,
          anchor2,
          parentComponent2,
          null,
          // fallback tree will not have suspense context
          namespace2,
          slotScopeIds,
          optimized
        );
        setActiveBranch(suspense, fallbackVNode);
      };
      const delayEnter = fallbackVNode.transition && fallbackVNode.transition.mode === "out-in";
      if (delayEnter) {
        activeBranch.transition.afterLeave = mountFallback;
      }
      suspense.isInFallback = true;
      unmount(
        activeBranch,
        parentComponent2,
        null,
        // no suspense so unmount hooks fire now
        true
        // shouldRemove
      );
      if (!delayEnter) {
        mountFallback();
      }
    },
    move(container2, anchor2, type) {
      suspense.activeBranch && move(suspense.activeBranch, container2, anchor2, type);
      suspense.container = container2;
    },
    next() {
      return suspense.activeBranch && next(suspense.activeBranch);
    },
    registerDep(instance, setupRenderEffect, optimized2) {
      const isInPendingSuspense = !!suspense.pendingBranch;
      if (isInPendingSuspense) {
        suspense.deps++;
      }
      const hydratedEl = instance.vnode.el;
      instance.asyncDep.catch((err) => {
        handleError(err, instance, 0);
      }).then((asyncSetupResult) => {
        if (instance.isUnmounted || suspense.isUnmounted || suspense.pendingId !== instance.suspenseId) {
          return;
        }
        instance.asyncResolved = true;
        const { vnode: vnode2 } = instance;
        if (true) {
          pushWarningContext(vnode2);
        }
        handleSetupResult(instance, asyncSetupResult, false);
        if (hydratedEl) {
          vnode2.el = hydratedEl;
        }
        const placeholder = !hydratedEl && instance.subTree.el;
        setupRenderEffect(
          instance,
          vnode2,
          // component may have been moved before resolve.
          // if this is not a hydration, instance.subTree will be the comment
          // placeholder.
          parentNode(hydratedEl || instance.subTree.el),
          // anchor will not be used if this is hydration, so only need to
          // consider the comment placeholder case.
          hydratedEl ? null : next(instance.subTree),
          suspense,
          namespace,
          optimized2
        );
        if (placeholder) {
          remove(placeholder);
        }
        updateHOCHostEl(instance, vnode2.el);
        if (true) {
          popWarningContext();
        }
        if (isInPendingSuspense && --suspense.deps === 0) {
          suspense.resolve();
        }
      });
    },
    unmount(parentSuspense2, doRemove) {
      suspense.isUnmounted = true;
      if (suspense.activeBranch) {
        unmount(
          suspense.activeBranch,
          parentComponent,
          parentSuspense2,
          doRemove
        );
      }
      if (suspense.pendingBranch) {
        unmount(
          suspense.pendingBranch,
          parentComponent,
          parentSuspense2,
          doRemove
        );
      }
    }
  };
  return suspense;
}
function hydrateSuspense(node, vnode, parentComponent, parentSuspense, namespace, slotScopeIds, optimized, rendererInternals, hydrateNode) {
  const suspense = vnode.suspense = createSuspenseBoundary(
    vnode,
    parentSuspense,
    parentComponent,
    node.parentNode,
    // eslint-disable-next-line no-restricted-globals
    document.createElement("div"),
    null,
    namespace,
    slotScopeIds,
    optimized,
    rendererInternals,
    true
  );
  const result = hydrateNode(
    node,
    suspense.pendingBranch = vnode.ssContent,
    parentComponent,
    suspense,
    slotScopeIds,
    optimized
  );
  if (suspense.deps === 0) {
    suspense.resolve(false, true);
  }
  return result;
}
function normalizeSuspenseChildren(vnode) {
  const { shapeFlag, children } = vnode;
  const isSlotChildren = shapeFlag & 32;
  vnode.ssContent = normalizeSuspenseSlot(
    isSlotChildren ? children.default : children
  );
  vnode.ssFallback = isSlotChildren ? normalizeSuspenseSlot(children.fallback) : createVNode(Comment);
}
function normalizeSuspenseSlot(s) {
  let block;
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(s)) {
    const trackBlock = isBlockTreeEnabled && s._c;
    if (trackBlock) {
      s._d = false;
      openBlock();
    }
    s = s();
    if (trackBlock) {
      s._d = true;
      block = currentBlock;
      closeBlock();
    }
  }
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(s)) {
    const singleChild = filterSingleRoot(s);
    if ( true && !singleChild && s.filter((child) => child !== NULL_DYNAMIC_COMPONENT).length > 0) {
      warn$1(`<Suspense> slots expect a single root node.`);
    }
    s = singleChild;
  }
  s = normalizeVNode(s);
  if (block && !s.dynamicChildren) {
    s.dynamicChildren = block.filter((c) => c !== s);
  }
  return s;
}
function queueEffectWithSuspense(fn, suspense) {
  if (suspense && suspense.pendingBranch) {
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(fn)) {
      suspense.effects.push(...fn);
    } else {
      suspense.effects.push(fn);
    }
  } else {
    queuePostFlushCb(fn);
  }
}
function setActiveBranch(suspense, branch) {
  suspense.activeBranch = branch;
  const { vnode, parentComponent } = suspense;
  let el = branch.el;
  while (!el && branch.component) {
    branch = branch.component.subTree;
    el = branch.el;
  }
  vnode.el = el;
  if (parentComponent && parentComponent.subTree === vnode) {
    parentComponent.vnode.el = el;
    updateHOCHostEl(parentComponent, el);
  }
}
function isVNodeSuspensible(vnode) {
  const suspensible = vnode.props && vnode.props.suspensible;
  return suspensible != null && suspensible !== false;
}

const Fragment = Symbol.for("v-fgt");
const Text = Symbol.for("v-txt");
const Comment = Symbol.for("v-cmt");
const Static = Symbol.for("v-stc");
const blockStack = [];
let currentBlock = null;
function openBlock(disableTracking = false) {
  blockStack.push(currentBlock = disableTracking ? null : []);
}
function closeBlock() {
  blockStack.pop();
  currentBlock = blockStack[blockStack.length - 1] || null;
}
let isBlockTreeEnabled = 1;
function setBlockTracking(value, inVOnce = false) {
  isBlockTreeEnabled += value;
  if (value < 0 && currentBlock && inVOnce) {
    currentBlock.hasOnce = true;
  }
}
function setupBlock(vnode) {
  vnode.dynamicChildren = isBlockTreeEnabled > 0 ? currentBlock || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_ARR : null;
  closeBlock();
  if (isBlockTreeEnabled > 0 && currentBlock) {
    currentBlock.push(vnode);
  }
  return vnode;
}
function createElementBlock(type, props, children, patchFlag, dynamicProps, shapeFlag) {
  return setupBlock(
    createBaseVNode(
      type,
      props,
      children,
      patchFlag,
      dynamicProps,
      shapeFlag,
      true
    )
  );
}
function createBlock(type, props, children, patchFlag, dynamicProps) {
  return setupBlock(
    createVNode(
      type,
      props,
      children,
      patchFlag,
      dynamicProps,
      true
    )
  );
}
function isVNode(value) {
  return value ? value.__v_isVNode === true : false;
}
function isSameVNodeType(n1, n2) {
  if ( true && n2.shapeFlag & 6 && n1.component) {
    const dirtyInstances = hmrDirtyComponents.get(n2.type);
    if (dirtyInstances && dirtyInstances.has(n1.component)) {
      n1.shapeFlag &= -257;
      n2.shapeFlag &= -513;
      return false;
    }
  }
  return n1.type === n2.type && n1.key === n2.key;
}
let vnodeArgsTransformer;
function transformVNodeArgs(transformer) {
  vnodeArgsTransformer = transformer;
}
const createVNodeWithArgsTransform = (...args) => {
  return _createVNode(
    ...vnodeArgsTransformer ? vnodeArgsTransformer(args, currentRenderingInstance) : args
  );
};
const normalizeKey = ({ key }) => key != null ? key : null;
const normalizeRef = ({
  ref,
  ref_key,
  ref_for
}) => {
  if (typeof ref === "number") {
    ref = "" + ref;
  }
  return ref != null ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(ref) || (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(ref) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(ref) ? { i: currentRenderingInstance, r: ref, k: ref_key, f: !!ref_for } : ref : null;
};
function createBaseVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, shapeFlag = type === Fragment ? 0 : 1, isBlockNode = false, needFullChildrenNormalization = false) {
  const vnode = {
    __v_isVNode: true,
    __v_skip: true,
    type,
    props,
    key: props && normalizeKey(props),
    ref: props && normalizeRef(props),
    scopeId: currentScopeId,
    slotScopeIds: null,
    children,
    component: null,
    suspense: null,
    ssContent: null,
    ssFallback: null,
    dirs: null,
    transition: null,
    el: null,
    anchor: null,
    target: null,
    targetStart: null,
    targetAnchor: null,
    staticCount: 0,
    shapeFlag,
    patchFlag,
    dynamicProps,
    dynamicChildren: null,
    appContext: null,
    ctx: currentRenderingInstance
  };
  if (needFullChildrenNormalization) {
    normalizeChildren(vnode, children);
    if (shapeFlag & 128) {
      type.normalize(vnode);
    }
  } else if (children) {
    vnode.shapeFlag |= (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(children) ? 8 : 16;
  }
  if ( true && vnode.key !== vnode.key) {
    warn$1(`VNode created with invalid key (NaN). VNode type:`, vnode.type);
  }
  if (isBlockTreeEnabled > 0 && // avoid a block node from tracking itself
  !isBlockNode && // has current parent block
  currentBlock && // presence of a patch flag indicates this node needs patching on updates.
  // component nodes also should always be patched, because even if the
  // component doesn't need to update, it needs to persist the instance on to
  // the next vnode so that it can be properly unmounted later.
  (vnode.patchFlag > 0 || shapeFlag & 6) && // the EVENTS flag is only for hydration and if it is the only flag, the
  // vnode should not be considered dynamic due to handler caching.
  vnode.patchFlag !== 32) {
    currentBlock.push(vnode);
  }
  return vnode;
}
const createVNode =  true ? createVNodeWithArgsTransform : 0;
function _createVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, isBlockNode = false) {
  if (!type || type === NULL_DYNAMIC_COMPONENT) {
    if ( true && !type) {
      warn$1(`Invalid vnode type when creating vnode: ${type}.`);
    }
    type = Comment;
  }
  if (isVNode(type)) {
    const cloned = cloneVNode(
      type,
      props,
      true
      /* mergeRef: true */
    );
    if (children) {
      normalizeChildren(cloned, children);
    }
    if (isBlockTreeEnabled > 0 && !isBlockNode && currentBlock) {
      if (cloned.shapeFlag & 6) {
        currentBlock[currentBlock.indexOf(type)] = cloned;
      } else {
        currentBlock.push(cloned);
      }
    }
    cloned.patchFlag = -2;
    return cloned;
  }
  if (isClassComponent(type)) {
    type = type.__vccOpts;
  }
  if (props) {
    props = guardReactiveProps(props);
    let { class: klass, style } = props;
    if (klass && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(klass)) {
      props.class = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeClass)(klass);
    }
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(style)) {
      if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isProxy)(style) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(style)) {
        style = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, style);
      }
      props.style = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeStyle)(style);
    }
  }
  const shapeFlag = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(type) ? 1 : isSuspense(type) ? 128 : isTeleport(type) ? 64 : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(type) ? 4 : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(type) ? 2 : 0;
  if ( true && shapeFlag & 4 && (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isProxy)(type)) {
    type = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(type);
    warn$1(
      `Vue received a Component that was made a reactive object. This can lead to unnecessary performance overhead and should be avoided by marking the component with \`markRaw\` or using \`shallowRef\` instead of \`ref\`.`,
      `
Component that was made reactive: `,
      type
    );
  }
  return createBaseVNode(
    type,
    props,
    children,
    patchFlag,
    dynamicProps,
    shapeFlag,
    isBlockNode,
    true
  );
}
function guardReactiveProps(props) {
  if (!props) return null;
  return (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isProxy)(props) || isInternalObject(props) ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, props) : props;
}
function cloneVNode(vnode, extraProps, mergeRef = false, cloneTransition = false) {
  const { props, ref, patchFlag, children, transition } = vnode;
  const mergedProps = extraProps ? mergeProps(props || {}, extraProps) : props;
  const cloned = {
    __v_isVNode: true,
    __v_skip: true,
    type: vnode.type,
    props: mergedProps,
    key: mergedProps && normalizeKey(mergedProps),
    ref: extraProps && extraProps.ref ? (
      // #2078 in the case of <component :is="vnode" ref="extra"/>
      // if the vnode itself already has a ref, cloneVNode will need to merge
      // the refs so the single vnode can be set on multiple refs
      mergeRef && ref ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(ref) ? ref.concat(normalizeRef(extraProps)) : [ref, normalizeRef(extraProps)] : normalizeRef(extraProps)
    ) : ref,
    scopeId: vnode.scopeId,
    slotScopeIds: vnode.slotScopeIds,
    children:  true && patchFlag === -1 && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(children) ? children.map(deepCloneVNode) : children,
    target: vnode.target,
    targetStart: vnode.targetStart,
    targetAnchor: vnode.targetAnchor,
    staticCount: vnode.staticCount,
    shapeFlag: vnode.shapeFlag,
    // if the vnode is cloned with extra props, we can no longer assume its
    // existing patch flag to be reliable and need to add the FULL_PROPS flag.
    // note: preserve flag for fragments since they use the flag for children
    // fast paths only.
    patchFlag: extraProps && vnode.type !== Fragment ? patchFlag === -1 ? 16 : patchFlag | 16 : patchFlag,
    dynamicProps: vnode.dynamicProps,
    dynamicChildren: vnode.dynamicChildren,
    appContext: vnode.appContext,
    dirs: vnode.dirs,
    transition,
    // These should technically only be non-null on mounted VNodes. However,
    // they *should* be copied for kept-alive vnodes. So we just always copy
    // them since them being non-null during a mount doesn't affect the logic as
    // they will simply be overwritten.
    component: vnode.component,
    suspense: vnode.suspense,
    ssContent: vnode.ssContent && cloneVNode(vnode.ssContent),
    ssFallback: vnode.ssFallback && cloneVNode(vnode.ssFallback),
    el: vnode.el,
    anchor: vnode.anchor,
    ctx: vnode.ctx,
    ce: vnode.ce
  };
  if (transition && cloneTransition) {
    setTransitionHooks(
      cloned,
      transition.clone(cloned)
    );
  }
  return cloned;
}
function deepCloneVNode(vnode) {
  const cloned = cloneVNode(vnode);
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(vnode.children)) {
    cloned.children = vnode.children.map(deepCloneVNode);
  }
  return cloned;
}
function createTextVNode(text = " ", flag = 0) {
  return createVNode(Text, null, text, flag);
}
function createStaticVNode(content, numberOfNodes) {
  const vnode = createVNode(Static, null, content);
  vnode.staticCount = numberOfNodes;
  return vnode;
}
function createCommentVNode(text = "", asBlock = false) {
  return asBlock ? (openBlock(), createBlock(Comment, null, text)) : createVNode(Comment, null, text);
}
function normalizeVNode(child) {
  if (child == null || typeof child === "boolean") {
    return createVNode(Comment);
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(child)) {
    return createVNode(
      Fragment,
      null,
      // #3666, avoid reference pollution when reusing vnode
      child.slice()
    );
  } else if (isVNode(child)) {
    return cloneIfMounted(child);
  } else {
    return createVNode(Text, null, String(child));
  }
}
function cloneIfMounted(child) {
  return child.el === null && child.patchFlag !== -1 || child.memo ? child : cloneVNode(child);
}
function normalizeChildren(vnode, children) {
  let type = 0;
  const { shapeFlag } = vnode;
  if (children == null) {
    children = null;
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(children)) {
    type = 16;
  } else if (typeof children === "object") {
    if (shapeFlag & (1 | 64)) {
      const slot = children.default;
      if (slot) {
        slot._c && (slot._d = false);
        normalizeChildren(vnode, slot());
        slot._c && (slot._d = true);
      }
      return;
    } else {
      type = 32;
      const slotFlag = children._;
      if (!slotFlag && !isInternalObject(children)) {
        children._ctx = currentRenderingInstance;
      } else if (slotFlag === 3 && currentRenderingInstance) {
        if (currentRenderingInstance.slots._ === 1) {
          children._ = 1;
        } else {
          children._ = 2;
          vnode.patchFlag |= 1024;
        }
      }
    }
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(children)) {
    children = { default: children, _ctx: currentRenderingInstance };
    type = 32;
  } else {
    children = String(children);
    if (shapeFlag & 64) {
      type = 16;
      children = [createTextVNode(children)];
    } else {
      type = 8;
    }
  }
  vnode.children = children;
  vnode.shapeFlag |= type;
}
function mergeProps(...args) {
  const ret = {};
  for (let i = 0; i < args.length; i++) {
    const toMerge = args[i];
    for (const key in toMerge) {
      if (key === "class") {
        if (ret.class !== toMerge.class) {
          ret.class = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeClass)([ret.class, toMerge.class]);
        }
      } else if (key === "style") {
        ret.style = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeStyle)([ret.style, toMerge.style]);
      } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isOn)(key)) {
        const existing = ret[key];
        const incoming = toMerge[key];
        if (incoming && existing !== incoming && !((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(existing) && existing.includes(incoming))) {
          ret[key] = existing ? [].concat(existing, incoming) : incoming;
        }
      } else if (key !== "") {
        ret[key] = toMerge[key];
      }
    }
  }
  return ret;
}
function invokeVNodeHook(hook, instance, vnode, prevVNode = null) {
  callWithAsyncErrorHandling(hook, instance, 7, [
    vnode,
    prevVNode
  ]);
}

const emptyAppContext = createAppContext();
let uid = 0;
function createComponentInstance(vnode, parent, suspense) {
  const type = vnode.type;
  const appContext = (parent ? parent.appContext : vnode.appContext) || emptyAppContext;
  const instance = {
    uid: uid++,
    vnode,
    type,
    parent,
    appContext,
    root: null,
    // to be immediately set
    next: null,
    subTree: null,
    // will be set synchronously right after creation
    effect: null,
    update: null,
    // will be set synchronously right after creation
    job: null,
    scope: new _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.EffectScope(
      true
      /* detached */
    ),
    render: null,
    proxy: null,
    exposed: null,
    exposeProxy: null,
    withProxy: null,
    provides: parent ? parent.provides : Object.create(appContext.provides),
    ids: parent ? parent.ids : ["", 0, 0],
    accessCache: null,
    renderCache: [],
    // local resolved assets
    components: null,
    directives: null,
    // resolved props and emits options
    propsOptions: normalizePropsOptions(type, appContext),
    emitsOptions: normalizeEmitsOptions(type, appContext),
    // emit
    emit: null,
    // to be set immediately
    emitted: null,
    // props default value
    propsDefaults: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,
    // inheritAttrs
    inheritAttrs: type.inheritAttrs,
    // state
    ctx: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,
    data: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,
    props: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,
    attrs: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,
    slots: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,
    refs: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,
    setupState: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,
    setupContext: null,
    // suspense related
    suspense,
    suspenseId: suspense ? suspense.pendingId : 0,
    asyncDep: null,
    asyncResolved: false,
    // lifecycle hooks
    // not using enums here because it results in computed properties
    isMounted: false,
    isUnmounted: false,
    isDeactivated: false,
    bc: null,
    c: null,
    bm: null,
    m: null,
    bu: null,
    u: null,
    um: null,
    bum: null,
    da: null,
    a: null,
    rtg: null,
    rtc: null,
    ec: null,
    sp: null
  };
  if (true) {
    instance.ctx = createDevRenderContext(instance);
  } else {}
  instance.root = parent ? parent.root : instance;
  instance.emit = emit.bind(null, instance);
  if (vnode.ce) {
    vnode.ce(instance);
  }
  return instance;
}
let currentInstance = null;
const getCurrentInstance = () => currentInstance || currentRenderingInstance;
let internalSetCurrentInstance;
let setInSSRSetupState;
{
  const g = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.getGlobalThis)();
  const registerGlobalSetter = (key, setter) => {
    let setters;
    if (!(setters = g[key])) setters = g[key] = [];
    setters.push(setter);
    return (v) => {
      if (setters.length > 1) setters.forEach((set) => set(v));
      else setters[0](v);
    };
  };
  internalSetCurrentInstance = registerGlobalSetter(
    `__VUE_INSTANCE_SETTERS__`,
    (v) => currentInstance = v
  );
  setInSSRSetupState = registerGlobalSetter(
    `__VUE_SSR_SETTERS__`,
    (v) => isInSSRComponentSetup = v
  );
}
const setCurrentInstance = (instance) => {
  const prev = currentInstance;
  internalSetCurrentInstance(instance);
  instance.scope.on();
  return () => {
    instance.scope.off();
    internalSetCurrentInstance(prev);
  };
};
const unsetCurrentInstance = () => {
  currentInstance && currentInstance.scope.off();
  internalSetCurrentInstance(null);
};
const isBuiltInTag = /* @__PURE__ */ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.makeMap)("slot,component");
function validateComponentName(name, { isNativeTag }) {
  if (isBuiltInTag(name) || isNativeTag(name)) {
    warn$1(
      "Do not use built-in or reserved HTML elements as component id: " + name
    );
  }
}
function isStatefulComponent(instance) {
  return instance.vnode.shapeFlag & 4;
}
let isInSSRComponentSetup = false;
function setupComponent(instance, isSSR = false, optimized = false) {
  isSSR && setInSSRSetupState(isSSR);
  const { props, children } = instance.vnode;
  const isStateful = isStatefulComponent(instance);
  initProps(instance, props, isStateful, isSSR);
  initSlots(instance, children, optimized || isSSR);
  const setupResult = isStateful ? setupStatefulComponent(instance, isSSR) : void 0;
  isSSR && setInSSRSetupState(false);
  return setupResult;
}
function setupStatefulComponent(instance, isSSR) {
  var _a;
  const Component = instance.type;
  if (true) {
    if (Component.name) {
      validateComponentName(Component.name, instance.appContext.config);
    }
    if (Component.components) {
      const names = Object.keys(Component.components);
      for (let i = 0; i < names.length; i++) {
        validateComponentName(names[i], instance.appContext.config);
      }
    }
    if (Component.directives) {
      const names = Object.keys(Component.directives);
      for (let i = 0; i < names.length; i++) {
        validateDirectiveName(names[i]);
      }
    }
    if (Component.compilerOptions && isRuntimeOnly()) {
      warn$1(
        `"compilerOptions" is only supported when using a build of Vue that includes the runtime compiler. Since you are using a runtime-only build, the options should be passed via your build tool config instead.`
      );
    }
  }
  instance.accessCache = /* @__PURE__ */ Object.create(null);
  instance.proxy = new Proxy(instance.ctx, PublicInstanceProxyHandlers);
  if (true) {
    exposePropsOnRenderContext(instance);
  }
  const { setup } = Component;
  if (setup) {
    (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();
    const setupContext = instance.setupContext = setup.length > 1 ? createSetupContext(instance) : null;
    const reset = setCurrentInstance(instance);
    const setupResult = callWithErrorHandling(
      setup,
      instance,
      0,
      [
         true ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(instance.props) : 0,
        setupContext
      ]
    );
    const isAsyncSetup = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isPromise)(setupResult);
    (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();
    reset();
    if ((isAsyncSetup || instance.sp) && !isAsyncWrapper(instance)) {
      markAsyncBoundary(instance);
    }
    if (isAsyncSetup) {
      setupResult.then(unsetCurrentInstance, unsetCurrentInstance);
      if (isSSR) {
        return setupResult.then((resolvedResult) => {
          handleSetupResult(instance, resolvedResult, isSSR);
        }).catch((e) => {
          handleError(e, instance, 0);
        });
      } else {
        instance.asyncDep = setupResult;
        if ( true && !instance.suspense) {
          const name = (_a = Component.name) != null ? _a : "Anonymous";
          warn$1(
            `Component <${name}>: setup function returned a promise, but no <Suspense> boundary was found in the parent component tree. A component with async setup() must be nested in a <Suspense> in order to be rendered.`
          );
        }
      }
    } else {
      handleSetupResult(instance, setupResult, isSSR);
    }
  } else {
    finishComponentSetup(instance, isSSR);
  }
}
function handleSetupResult(instance, setupResult, isSSR) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(setupResult)) {
    if (instance.type.__ssrInlineRender) {
      instance.ssrRender = setupResult;
    } else {
      instance.render = setupResult;
    }
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(setupResult)) {
    if ( true && isVNode(setupResult)) {
      warn$1(
        `setup() should not return VNodes directly - return a render function instead.`
      );
    }
    if (true) {
      instance.devtoolsRawSetupState = setupResult;
    }
    instance.setupState = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.proxyRefs)(setupResult);
    if (true) {
      exposeSetupStateOnRenderContext(instance);
    }
  } else if ( true && setupResult !== void 0) {
    warn$1(
      `setup() should return an object. Received: ${setupResult === null ? "null" : typeof setupResult}`
    );
  }
  finishComponentSetup(instance, isSSR);
}
let compile;
let installWithProxy;
function registerRuntimeCompiler(_compile) {
  compile = _compile;
  installWithProxy = (i) => {
    if (i.render._rc) {
      i.withProxy = new Proxy(i.ctx, RuntimeCompiledPublicInstanceProxyHandlers);
    }
  };
}
const isRuntimeOnly = () => !compile;
function finishComponentSetup(instance, isSSR, skipOptions) {
  const Component = instance.type;
  if (!instance.render) {
    if (!isSSR && compile && !Component.render) {
      const template = Component.template ||  true && resolveMergedOptions(instance).template;
      if (template) {
        if (true) {
          startMeasure(instance, `compile`);
        }
        const { isCustomElement, compilerOptions } = instance.appContext.config;
        const { delimiters, compilerOptions: componentCompilerOptions } = Component;
        const finalCompilerOptions = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(
          (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(
            {
              isCustomElement,
              delimiters
            },
            compilerOptions
          ),
          componentCompilerOptions
        );
        Component.render = compile(template, finalCompilerOptions);
        if (true) {
          endMeasure(instance, `compile`);
        }
      }
    }
    instance.render = Component.render || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP;
    if (installWithProxy) {
      installWithProxy(instance);
    }
  }
  if (true) {
    const reset = setCurrentInstance(instance);
    (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();
    try {
      applyOptions(instance);
    } finally {
      (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();
      reset();
    }
  }
  if ( true && !Component.render && instance.render === _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP && !isSSR) {
    if (!compile && Component.template) {
      warn$1(
        `Component provided template option but runtime compilation is not supported in this build of Vue.` + (` Configure your bundler to alias "vue" to "vue/dist/vue.esm-bundler.js".` )
      );
    } else {
      warn$1(`Component is missing template or render function: `, Component);
    }
  }
}
const attrsProxyHandlers =  true ? {
  get(target, key) {
    markAttrsAccessed();
    (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.track)(target, "get", "");
    return target[key];
  },
  set() {
    warn$1(`setupContext.attrs is readonly.`);
    return false;
  },
  deleteProperty() {
    warn$1(`setupContext.attrs is readonly.`);
    return false;
  }
} : 0;
function getSlotsProxy(instance) {
  return new Proxy(instance.slots, {
    get(target, key) {
      (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.track)(instance, "get", "$slots");
      return target[key];
    }
  });
}
function createSetupContext(instance) {
  const expose = (exposed) => {
    if (true) {
      if (instance.exposed) {
        warn$1(`expose() should be called only once per setup().`);
      }
      if (exposed != null) {
        let exposedType = typeof exposed;
        if (exposedType === "object") {
          if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(exposed)) {
            exposedType = "array";
          } else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(exposed)) {
            exposedType = "ref";
          }
        }
        if (exposedType !== "object") {
          warn$1(
            `expose() should be passed a plain object, received ${exposedType}.`
          );
        }
      }
    }
    instance.exposed = exposed || {};
  };
  if (true) {
    let attrsProxy;
    let slotsProxy;
    return Object.freeze({
      get attrs() {
        return attrsProxy || (attrsProxy = new Proxy(instance.attrs, attrsProxyHandlers));
      },
      get slots() {
        return slotsProxy || (slotsProxy = getSlotsProxy(instance));
      },
      get emit() {
        return (event, ...args) => instance.emit(event, ...args);
      },
      expose
    });
  } else {}
}
function getComponentPublicInstance(instance) {
  if (instance.exposed) {
    return instance.exposeProxy || (instance.exposeProxy = new Proxy((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.proxyRefs)((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.markRaw)(instance.exposed)), {
      get(target, key) {
        if (key in target) {
          return target[key];
        } else if (key in publicPropertiesMap) {
          return publicPropertiesMap[key](instance);
        }
      },
      has(target, key) {
        return key in target || key in publicPropertiesMap;
      }
    }));
  } else {
    return instance.proxy;
  }
}
const classifyRE = /(?:^|[-_])(\w)/g;
const classify = (str) => str.replace(classifyRE, (c) => c.toUpperCase()).replace(/[-_]/g, "");
function getComponentName(Component, includeInferred = true) {
  return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(Component) ? Component.displayName || Component.name : Component.name || includeInferred && Component.__name;
}
function formatComponentName(instance, Component, isRoot = false) {
  let name = getComponentName(Component);
  if (!name && Component.__file) {
    const match = Component.__file.match(/([^/\\]+)\.\w+$/);
    if (match) {
      name = match[1];
    }
  }
  if (!name && instance && instance.parent) {
    const inferFromRegistry = (registry) => {
      for (const key in registry) {
        if (registry[key] === Component) {
          return key;
        }
      }
    };
    name = inferFromRegistry(
      instance.components || instance.parent.type.components
    ) || inferFromRegistry(instance.appContext.components);
  }
  return name ? classify(name) : isRoot ? `App` : `Anonymous`;
}
function isClassComponent(value) {
  return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(value) && "__vccOpts" in value;
}

const computed = (getterOrOptions, debugOptions) => {
  const c = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.computed)(getterOrOptions, debugOptions, isInSSRComponentSetup);
  if (true) {
    const i = getCurrentInstance();
    if (i && i.appContext.config.warnRecursiveComputed) {
      c._warnRecursive = true;
    }
  }
  return c;
};

function h(type, propsOrChildren, children) {
  const l = arguments.length;
  if (l === 2) {
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(propsOrChildren) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(propsOrChildren)) {
      if (isVNode(propsOrChildren)) {
        return createVNode(type, null, [propsOrChildren]);
      }
      return createVNode(type, propsOrChildren);
    } else {
      return createVNode(type, null, propsOrChildren);
    }
  } else {
    if (l > 3) {
      children = Array.prototype.slice.call(arguments, 2);
    } else if (l === 3 && isVNode(children)) {
      children = [children];
    }
    return createVNode(type, propsOrChildren, children);
  }
}

function initCustomFormatter() {
  if ( false || typeof window === "undefined") {
    return;
  }
  const vueStyle = { style: "color:#3ba776" };
  const numberStyle = { style: "color:#1677ff" };
  const stringStyle = { style: "color:#f5222d" };
  const keywordStyle = { style: "color:#eb2f96" };
  const formatter = {
    __vue_custom_formatter: true,
    header(obj) {
      if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(obj)) {
        return null;
      }
      if (obj.__isVue) {
        return ["div", vueStyle, `VueInstance`];
      } else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(obj)) {
        (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();
        const value = obj.value;
        (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();
        return [
          "div",
          {},
          ["span", vueStyle, genRefFlag(obj)],
          "<",
          formatValue(value),
          `>`
        ];
      } else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReactive)(obj)) {
        return [
          "div",
          {},
          ["span", vueStyle, (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isShallow)(obj) ? "ShallowReactive" : "Reactive"],
          "<",
          formatValue(obj),
          `>${(0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReadonly)(obj) ? ` (readonly)` : ``}`
        ];
      } else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReadonly)(obj)) {
        return [
          "div",
          {},
          ["span", vueStyle, (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isShallow)(obj) ? "ShallowReadonly" : "Readonly"],
          "<",
          formatValue(obj),
          ">"
        ];
      }
      return null;
    },
    hasBody(obj) {
      return obj && obj.__isVue;
    },
    body(obj) {
      if (obj && obj.__isVue) {
        return [
          "div",
          {},
          ...formatInstance(obj.$)
        ];
      }
    }
  };
  function formatInstance(instance) {
    const blocks = [];
    if (instance.type.props && instance.props) {
      blocks.push(createInstanceBlock("props", (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(instance.props)));
    }
    if (instance.setupState !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ) {
      blocks.push(createInstanceBlock("setup", instance.setupState));
    }
    if (instance.data !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ) {
      blocks.push(createInstanceBlock("data", (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(instance.data)));
    }
    const computed = extractKeys(instance, "computed");
    if (computed) {
      blocks.push(createInstanceBlock("computed", computed));
    }
    const injected = extractKeys(instance, "inject");
    if (injected) {
      blocks.push(createInstanceBlock("injected", injected));
    }
    blocks.push([
      "div",
      {},
      [
        "span",
        {
          style: keywordStyle.style + ";opacity:0.66"
        },
        "$ (internal): "
      ],
      ["object", { object: instance }]
    ]);
    return blocks;
  }
  function createInstanceBlock(type, target) {
    target = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, target);
    if (!Object.keys(target).length) {
      return ["span", {}];
    }
    return [
      "div",
      { style: "line-height:1.25em;margin-bottom:0.6em" },
      [
        "div",
        {
          style: "color:#476582"
        },
        type
      ],
      [
        "div",
        {
          style: "padding-left:1.25em"
        },
        ...Object.keys(target).map((key) => {
          return [
            "div",
            {},
            ["span", keywordStyle, key + ": "],
            formatValue(target[key], false)
          ];
        })
      ]
    ];
  }
  function formatValue(v, asRaw = true) {
    if (typeof v === "number") {
      return ["span", numberStyle, v];
    } else if (typeof v === "string") {
      return ["span", stringStyle, JSON.stringify(v)];
    } else if (typeof v === "boolean") {
      return ["span", keywordStyle, v];
    } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(v)) {
      return ["object", { object: asRaw ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(v) : v }];
    } else {
      return ["span", stringStyle, String(v)];
    }
  }
  function extractKeys(instance, type) {
    const Comp = instance.type;
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(Comp)) {
      return;
    }
    const extracted = {};
    for (const key in instance.ctx) {
      if (isKeyOfType(Comp, key, type)) {
        extracted[key] = instance.ctx[key];
      }
    }
    return extracted;
  }
  function isKeyOfType(Comp, key, type) {
    const opts = Comp[type];
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(opts) && opts.includes(key) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(opts) && key in opts) {
      return true;
    }
    if (Comp.extends && isKeyOfType(Comp.extends, key, type)) {
      return true;
    }
    if (Comp.mixins && Comp.mixins.some((m) => isKeyOfType(m, key, type))) {
      return true;
    }
  }
  function genRefFlag(v) {
    if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isShallow)(v)) {
      return `ShallowRef`;
    }
    if (v.effect) {
      return `ComputedRef`;
    }
    return `Ref`;
  }
  if (window.devtoolsFormatters) {
    window.devtoolsFormatters.push(formatter);
  } else {
    window.devtoolsFormatters = [formatter];
  }
}

function withMemo(memo, render, cache, index) {
  const cached = cache[index];
  if (cached && isMemoSame(cached, memo)) {
    return cached;
  }
  const ret = render();
  ret.memo = memo.slice();
  ret.cacheIndex = index;
  return cache[index] = ret;
}
function isMemoSame(cached, memo) {
  const prev = cached.memo;
  if (prev.length != memo.length) {
    return false;
  }
  for (let i = 0; i < prev.length; i++) {
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasChanged)(prev[i], memo[i])) {
      return false;
    }
  }
  if (isBlockTreeEnabled > 0 && currentBlock) {
    currentBlock.push(cached);
  }
  return true;
}

const version = "3.5.16";
const warn =  true ? warn$1 : 0;
const ErrorTypeStrings = ErrorTypeStrings$1 ;
const devtools =  true ? devtools$1 : 0;
const setDevtoolsHook =  true ? setDevtoolsHook$1 : 0;
const _ssrUtils = {
  createComponentInstance,
  setupComponent,
  renderComponentRoot,
  setCurrentRenderingInstance,
  isVNode: isVNode,
  normalizeVNode,
  getComponentPublicInstance,
  ensureValidVNode,
  pushWarningContext,
  popWarningContext
};
const ssrUtils = _ssrUtils ;
const resolveFilter = null;
const compatUtils = null;
const DeprecationTypes = null;




/***/ }),

/***/ "./node_modules/@vue/runtime-dom/dist/runtime-dom.esm-bundler.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@vue/runtime-dom/dist/runtime-dom.esm-bundler.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseTransition: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.BaseTransition),
/* harmony export */   BaseTransitionPropsValidators: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.BaseTransitionPropsValidators),
/* harmony export */   Comment: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.Comment),
/* harmony export */   DeprecationTypes: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.DeprecationTypes),
/* harmony export */   EffectScope: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.EffectScope),
/* harmony export */   ErrorCodes: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.ErrorCodes),
/* harmony export */   ErrorTypeStrings: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.ErrorTypeStrings),
/* harmony export */   Fragment: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.Fragment),
/* harmony export */   KeepAlive: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.KeepAlive),
/* harmony export */   ReactiveEffect: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.ReactiveEffect),
/* harmony export */   Static: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.Static),
/* harmony export */   Suspense: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.Suspense),
/* harmony export */   Teleport: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.Teleport),
/* harmony export */   Text: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.Text),
/* harmony export */   TrackOpTypes: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.TrackOpTypes),
/* harmony export */   Transition: () => (/* binding */ Transition),
/* harmony export */   TransitionGroup: () => (/* binding */ TransitionGroup),
/* harmony export */   TriggerOpTypes: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.TriggerOpTypes),
/* harmony export */   VueElement: () => (/* binding */ VueElement),
/* harmony export */   assertNumber: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.assertNumber),
/* harmony export */   callWithAsyncErrorHandling: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.callWithAsyncErrorHandling),
/* harmony export */   callWithErrorHandling: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.callWithErrorHandling),
/* harmony export */   camelize: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.camelize),
/* harmony export */   capitalize: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.capitalize),
/* harmony export */   cloneVNode: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.cloneVNode),
/* harmony export */   compatUtils: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.compatUtils),
/* harmony export */   computed: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.computed),
/* harmony export */   createApp: () => (/* binding */ createApp),
/* harmony export */   createBlock: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createBlock),
/* harmony export */   createCommentVNode: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode),
/* harmony export */   createElementBlock: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createElementBlock),
/* harmony export */   createElementVNode: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createElementVNode),
/* harmony export */   createHydrationRenderer: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createHydrationRenderer),
/* harmony export */   createPropsRestProxy: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createPropsRestProxy),
/* harmony export */   createRenderer: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createRenderer),
/* harmony export */   createSSRApp: () => (/* binding */ createSSRApp),
/* harmony export */   createSlots: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createSlots),
/* harmony export */   createStaticVNode: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createStaticVNode),
/* harmony export */   createTextVNode: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createTextVNode),
/* harmony export */   createVNode: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createVNode),
/* harmony export */   customRef: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.customRef),
/* harmony export */   defineAsyncComponent: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.defineAsyncComponent),
/* harmony export */   defineComponent: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.defineComponent),
/* harmony export */   defineCustomElement: () => (/* binding */ defineCustomElement),
/* harmony export */   defineEmits: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.defineEmits),
/* harmony export */   defineExpose: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.defineExpose),
/* harmony export */   defineModel: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.defineModel),
/* harmony export */   defineOptions: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.defineOptions),
/* harmony export */   defineProps: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.defineProps),
/* harmony export */   defineSSRCustomElement: () => (/* binding */ defineSSRCustomElement),
/* harmony export */   defineSlots: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.defineSlots),
/* harmony export */   devtools: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.devtools),
/* harmony export */   effect: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.effect),
/* harmony export */   effectScope: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.effectScope),
/* harmony export */   getCurrentInstance: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.getCurrentInstance),
/* harmony export */   getCurrentScope: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.getCurrentScope),
/* harmony export */   getCurrentWatcher: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.getCurrentWatcher),
/* harmony export */   getTransitionRawChildren: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.getTransitionRawChildren),
/* harmony export */   guardReactiveProps: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.guardReactiveProps),
/* harmony export */   h: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.h),
/* harmony export */   handleError: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.handleError),
/* harmony export */   hasInjectionContext: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.hasInjectionContext),
/* harmony export */   hydrate: () => (/* binding */ hydrate),
/* harmony export */   hydrateOnIdle: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.hydrateOnIdle),
/* harmony export */   hydrateOnInteraction: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.hydrateOnInteraction),
/* harmony export */   hydrateOnMediaQuery: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.hydrateOnMediaQuery),
/* harmony export */   hydrateOnVisible: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.hydrateOnVisible),
/* harmony export */   initCustomFormatter: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.initCustomFormatter),
/* harmony export */   initDirectivesForSSR: () => (/* binding */ initDirectivesForSSR),
/* harmony export */   inject: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.inject),
/* harmony export */   isMemoSame: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.isMemoSame),
/* harmony export */   isProxy: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.isProxy),
/* harmony export */   isReactive: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.isReactive),
/* harmony export */   isReadonly: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.isReadonly),
/* harmony export */   isRef: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.isRef),
/* harmony export */   isRuntimeOnly: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.isRuntimeOnly),
/* harmony export */   isShallow: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.isShallow),
/* harmony export */   isVNode: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.isVNode),
/* harmony export */   markRaw: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.markRaw),
/* harmony export */   mergeDefaults: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.mergeDefaults),
/* harmony export */   mergeModels: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.mergeModels),
/* harmony export */   mergeProps: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.mergeProps),
/* harmony export */   nextTick: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.nextTick),
/* harmony export */   normalizeClass: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.normalizeClass),
/* harmony export */   normalizeProps: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.normalizeProps),
/* harmony export */   normalizeStyle: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle),
/* harmony export */   onActivated: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onActivated),
/* harmony export */   onBeforeMount: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onBeforeMount),
/* harmony export */   onBeforeUnmount: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount),
/* harmony export */   onBeforeUpdate: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onBeforeUpdate),
/* harmony export */   onDeactivated: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onDeactivated),
/* harmony export */   onErrorCaptured: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onErrorCaptured),
/* harmony export */   onMounted: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onMounted),
/* harmony export */   onRenderTracked: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onRenderTracked),
/* harmony export */   onRenderTriggered: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onRenderTriggered),
/* harmony export */   onScopeDispose: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onScopeDispose),
/* harmony export */   onServerPrefetch: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onServerPrefetch),
/* harmony export */   onUnmounted: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onUnmounted),
/* harmony export */   onUpdated: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onUpdated),
/* harmony export */   onWatcherCleanup: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onWatcherCleanup),
/* harmony export */   openBlock: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.openBlock),
/* harmony export */   popScopeId: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.popScopeId),
/* harmony export */   provide: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.provide),
/* harmony export */   proxyRefs: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.proxyRefs),
/* harmony export */   pushScopeId: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.pushScopeId),
/* harmony export */   queuePostFlushCb: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.queuePostFlushCb),
/* harmony export */   reactive: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.reactive),
/* harmony export */   readonly: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.readonly),
/* harmony export */   ref: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.ref),
/* harmony export */   registerRuntimeCompiler: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.registerRuntimeCompiler),
/* harmony export */   render: () => (/* binding */ render),
/* harmony export */   renderList: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.renderList),
/* harmony export */   renderSlot: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.renderSlot),
/* harmony export */   resolveComponent: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.resolveComponent),
/* harmony export */   resolveDirective: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.resolveDirective),
/* harmony export */   resolveDynamicComponent: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.resolveDynamicComponent),
/* harmony export */   resolveFilter: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.resolveFilter),
/* harmony export */   resolveTransitionHooks: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.resolveTransitionHooks),
/* harmony export */   setBlockTracking: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.setBlockTracking),
/* harmony export */   setDevtoolsHook: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.setDevtoolsHook),
/* harmony export */   setTransitionHooks: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.setTransitionHooks),
/* harmony export */   shallowReactive: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.shallowReactive),
/* harmony export */   shallowReadonly: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly),
/* harmony export */   shallowRef: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.shallowRef),
/* harmony export */   ssrContextKey: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.ssrContextKey),
/* harmony export */   ssrUtils: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.ssrUtils),
/* harmony export */   stop: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.stop),
/* harmony export */   toDisplayString: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.toDisplayString),
/* harmony export */   toHandlerKey: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.toHandlerKey),
/* harmony export */   toHandlers: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.toHandlers),
/* harmony export */   toRaw: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.toRaw),
/* harmony export */   toRef: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.toRef),
/* harmony export */   toRefs: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.toRefs),
/* harmony export */   toValue: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.toValue),
/* harmony export */   transformVNodeArgs: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.transformVNodeArgs),
/* harmony export */   triggerRef: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.triggerRef),
/* harmony export */   unref: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.unref),
/* harmony export */   useAttrs: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.useAttrs),
/* harmony export */   useCssModule: () => (/* binding */ useCssModule),
/* harmony export */   useCssVars: () => (/* binding */ useCssVars),
/* harmony export */   useHost: () => (/* binding */ useHost),
/* harmony export */   useId: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.useId),
/* harmony export */   useModel: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.useModel),
/* harmony export */   useSSRContext: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.useSSRContext),
/* harmony export */   useShadowRoot: () => (/* binding */ useShadowRoot),
/* harmony export */   useSlots: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.useSlots),
/* harmony export */   useTemplateRef: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.useTemplateRef),
/* harmony export */   useTransitionState: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.useTransitionState),
/* harmony export */   vModelCheckbox: () => (/* binding */ vModelCheckbox),
/* harmony export */   vModelDynamic: () => (/* binding */ vModelDynamic),
/* harmony export */   vModelRadio: () => (/* binding */ vModelRadio),
/* harmony export */   vModelSelect: () => (/* binding */ vModelSelect),
/* harmony export */   vModelText: () => (/* binding */ vModelText),
/* harmony export */   vShow: () => (/* binding */ vShow),
/* harmony export */   version: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.version),
/* harmony export */   warn: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn),
/* harmony export */   watch: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.watch),
/* harmony export */   watchEffect: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.watchEffect),
/* harmony export */   watchPostEffect: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.watchPostEffect),
/* harmony export */   watchSyncEffect: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.watchSyncEffect),
/* harmony export */   withAsyncContext: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.withAsyncContext),
/* harmony export */   withCtx: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.withCtx),
/* harmony export */   withDefaults: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.withDefaults),
/* harmony export */   withDirectives: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.withDirectives),
/* harmony export */   withKeys: () => (/* binding */ withKeys),
/* harmony export */   withMemo: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.withMemo),
/* harmony export */   withModifiers: () => (/* binding */ withModifiers),
/* harmony export */   withScopeId: () => (/* reexport safe */ _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.withScopeId)
/* harmony export */ });
/* harmony import */ var _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @vue/runtime-core */ "./node_modules/@vue/runtime-core/dist/runtime-core.esm-bundler.js");
/* harmony import */ var _vue_shared__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @vue/shared */ "./node_modules/@vue/shared/dist/shared.esm-bundler.js");
/* harmony import */ var _vue_runtime_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @vue/runtime-core */ "./node_modules/@vue/reactivity/dist/reactivity.esm-bundler.js");
/**
* @vue/runtime-dom v3.5.16
* (c) 2018-present Yuxi (Evan) You and Vue contributors
* @license MIT
**/




let policy = void 0;
const tt = typeof window !== "undefined" && window.trustedTypes;
if (tt) {
  try {
    policy = /* @__PURE__ */ tt.createPolicy("vue", {
      createHTML: (val) => val
    });
  } catch (e) {
     true && (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(`Error creating trusted types policy: ${e}`);
  }
}
const unsafeToTrustedHTML = policy ? (val) => policy.createHTML(val) : (val) => val;
const svgNS = "http://www.w3.org/2000/svg";
const mathmlNS = "http://www.w3.org/1998/Math/MathML";
const doc = typeof document !== "undefined" ? document : null;
const templateContainer = doc && /* @__PURE__ */ doc.createElement("template");
const nodeOps = {
  insert: (child, parent, anchor) => {
    parent.insertBefore(child, anchor || null);
  },
  remove: (child) => {
    const parent = child.parentNode;
    if (parent) {
      parent.removeChild(child);
    }
  },
  createElement: (tag, namespace, is, props) => {
    const el = namespace === "svg" ? doc.createElementNS(svgNS, tag) : namespace === "mathml" ? doc.createElementNS(mathmlNS, tag) : is ? doc.createElement(tag, { is }) : doc.createElement(tag);
    if (tag === "select" && props && props.multiple != null) {
      el.setAttribute("multiple", props.multiple);
    }
    return el;
  },
  createText: (text) => doc.createTextNode(text),
  createComment: (text) => doc.createComment(text),
  setText: (node, text) => {
    node.nodeValue = text;
  },
  setElementText: (el, text) => {
    el.textContent = text;
  },
  parentNode: (node) => node.parentNode,
  nextSibling: (node) => node.nextSibling,
  querySelector: (selector) => doc.querySelector(selector),
  setScopeId(el, id) {
    el.setAttribute(id, "");
  },
  // __UNSAFE__
  // Reason: innerHTML.
  // Static content here can only come from compiled templates.
  // As long as the user only uses trusted templates, this is safe.
  insertStaticContent(content, parent, anchor, namespace, start, end) {
    const before = anchor ? anchor.previousSibling : parent.lastChild;
    if (start && (start === end || start.nextSibling)) {
      while (true) {
        parent.insertBefore(start.cloneNode(true), anchor);
        if (start === end || !(start = start.nextSibling)) break;
      }
    } else {
      templateContainer.innerHTML = unsafeToTrustedHTML(
        namespace === "svg" ? `<svg>${content}</svg>` : namespace === "mathml" ? `<math>${content}</math>` : content
      );
      const template = templateContainer.content;
      if (namespace === "svg" || namespace === "mathml") {
        const wrapper = template.firstChild;
        while (wrapper.firstChild) {
          template.appendChild(wrapper.firstChild);
        }
        template.removeChild(wrapper);
      }
      parent.insertBefore(template, anchor);
    }
    return [
      // first
      before ? before.nextSibling : parent.firstChild,
      // last
      anchor ? anchor.previousSibling : parent.lastChild
    ];
  }
};

const TRANSITION = "transition";
const ANIMATION = "animation";
const vtcKey = Symbol("_vtc");
const DOMTransitionPropsValidators = {
  name: String,
  type: String,
  css: {
    type: Boolean,
    default: true
  },
  duration: [String, Number, Object],
  enterFromClass: String,
  enterActiveClass: String,
  enterToClass: String,
  appearFromClass: String,
  appearActiveClass: String,
  appearToClass: String,
  leaveFromClass: String,
  leaveActiveClass: String,
  leaveToClass: String
};
const TransitionPropsValidators = /* @__PURE__ */ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(
  {},
  _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.BaseTransitionPropsValidators,
  DOMTransitionPropsValidators
);
const decorate$1 = (t) => {
  t.displayName = "Transition";
  t.props = TransitionPropsValidators;
  return t;
};
const Transition = /* @__PURE__ */ decorate$1(
  (props, { slots }) => (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.h)(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.BaseTransition, resolveTransitionProps(props), slots)
);
const callHook = (hook, args = []) => {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(hook)) {
    hook.forEach((h2) => h2(...args));
  } else if (hook) {
    hook(...args);
  }
};
const hasExplicitCallback = (hook) => {
  return hook ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(hook) ? hook.some((h2) => h2.length > 1) : hook.length > 1 : false;
};
function resolveTransitionProps(rawProps) {
  const baseProps = {};
  for (const key in rawProps) {
    if (!(key in DOMTransitionPropsValidators)) {
      baseProps[key] = rawProps[key];
    }
  }
  if (rawProps.css === false) {
    return baseProps;
  }
  const {
    name = "v",
    type,
    duration,
    enterFromClass = `${name}-enter-from`,
    enterActiveClass = `${name}-enter-active`,
    enterToClass = `${name}-enter-to`,
    appearFromClass = enterFromClass,
    appearActiveClass = enterActiveClass,
    appearToClass = enterToClass,
    leaveFromClass = `${name}-leave-from`,
    leaveActiveClass = `${name}-leave-active`,
    leaveToClass = `${name}-leave-to`
  } = rawProps;
  const durations = normalizeDuration(duration);
  const enterDuration = durations && durations[0];
  const leaveDuration = durations && durations[1];
  const {
    onBeforeEnter,
    onEnter,
    onEnterCancelled,
    onLeave,
    onLeaveCancelled,
    onBeforeAppear = onBeforeEnter,
    onAppear = onEnter,
    onAppearCancelled = onEnterCancelled
  } = baseProps;
  const finishEnter = (el, isAppear, done, isCancelled) => {
    el._enterCancelled = isCancelled;
    removeTransitionClass(el, isAppear ? appearToClass : enterToClass);
    removeTransitionClass(el, isAppear ? appearActiveClass : enterActiveClass);
    done && done();
  };
  const finishLeave = (el, done) => {
    el._isLeaving = false;
    removeTransitionClass(el, leaveFromClass);
    removeTransitionClass(el, leaveToClass);
    removeTransitionClass(el, leaveActiveClass);
    done && done();
  };
  const makeEnterHook = (isAppear) => {
    return (el, done) => {
      const hook = isAppear ? onAppear : onEnter;
      const resolve = () => finishEnter(el, isAppear, done);
      callHook(hook, [el, resolve]);
      nextFrame(() => {
        removeTransitionClass(el, isAppear ? appearFromClass : enterFromClass);
        addTransitionClass(el, isAppear ? appearToClass : enterToClass);
        if (!hasExplicitCallback(hook)) {
          whenTransitionEnds(el, type, enterDuration, resolve);
        }
      });
    };
  };
  return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(baseProps, {
    onBeforeEnter(el) {
      callHook(onBeforeEnter, [el]);
      addTransitionClass(el, enterFromClass);
      addTransitionClass(el, enterActiveClass);
    },
    onBeforeAppear(el) {
      callHook(onBeforeAppear, [el]);
      addTransitionClass(el, appearFromClass);
      addTransitionClass(el, appearActiveClass);
    },
    onEnter: makeEnterHook(false),
    onAppear: makeEnterHook(true),
    onLeave(el, done) {
      el._isLeaving = true;
      const resolve = () => finishLeave(el, done);
      addTransitionClass(el, leaveFromClass);
      if (!el._enterCancelled) {
        forceReflow();
        addTransitionClass(el, leaveActiveClass);
      } else {
        addTransitionClass(el, leaveActiveClass);
        forceReflow();
      }
      nextFrame(() => {
        if (!el._isLeaving) {
          return;
        }
        removeTransitionClass(el, leaveFromClass);
        addTransitionClass(el, leaveToClass);
        if (!hasExplicitCallback(onLeave)) {
          whenTransitionEnds(el, type, leaveDuration, resolve);
        }
      });
      callHook(onLeave, [el, resolve]);
    },
    onEnterCancelled(el) {
      finishEnter(el, false, void 0, true);
      callHook(onEnterCancelled, [el]);
    },
    onAppearCancelled(el) {
      finishEnter(el, true, void 0, true);
      callHook(onAppearCancelled, [el]);
    },
    onLeaveCancelled(el) {
      finishLeave(el);
      callHook(onLeaveCancelled, [el]);
    }
  });
}
function normalizeDuration(duration) {
  if (duration == null) {
    return null;
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(duration)) {
    return [NumberOf(duration.enter), NumberOf(duration.leave)];
  } else {
    const n = NumberOf(duration);
    return [n, n];
  }
}
function NumberOf(val) {
  const res = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toNumber)(val);
  if (true) {
    (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.assertNumber)(res, "<transition> explicit duration");
  }
  return res;
}
function addTransitionClass(el, cls) {
  cls.split(/\s+/).forEach((c) => c && el.classList.add(c));
  (el[vtcKey] || (el[vtcKey] = /* @__PURE__ */ new Set())).add(cls);
}
function removeTransitionClass(el, cls) {
  cls.split(/\s+/).forEach((c) => c && el.classList.remove(c));
  const _vtc = el[vtcKey];
  if (_vtc) {
    _vtc.delete(cls);
    if (!_vtc.size) {
      el[vtcKey] = void 0;
    }
  }
}
function nextFrame(cb) {
  requestAnimationFrame(() => {
    requestAnimationFrame(cb);
  });
}
let endId = 0;
function whenTransitionEnds(el, expectedType, explicitTimeout, resolve) {
  const id = el._endId = ++endId;
  const resolveIfNotStale = () => {
    if (id === el._endId) {
      resolve();
    }
  };
  if (explicitTimeout != null) {
    return setTimeout(resolveIfNotStale, explicitTimeout);
  }
  const { type, timeout, propCount } = getTransitionInfo(el, expectedType);
  if (!type) {
    return resolve();
  }
  const endEvent = type + "end";
  let ended = 0;
  const end = () => {
    el.removeEventListener(endEvent, onEnd);
    resolveIfNotStale();
  };
  const onEnd = (e) => {
    if (e.target === el && ++ended >= propCount) {
      end();
    }
  };
  setTimeout(() => {
    if (ended < propCount) {
      end();
    }
  }, timeout + 1);
  el.addEventListener(endEvent, onEnd);
}
function getTransitionInfo(el, expectedType) {
  const styles = window.getComputedStyle(el);
  const getStyleProperties = (key) => (styles[key] || "").split(", ");
  const transitionDelays = getStyleProperties(`${TRANSITION}Delay`);
  const transitionDurations = getStyleProperties(`${TRANSITION}Duration`);
  const transitionTimeout = getTimeout(transitionDelays, transitionDurations);
  const animationDelays = getStyleProperties(`${ANIMATION}Delay`);
  const animationDurations = getStyleProperties(`${ANIMATION}Duration`);
  const animationTimeout = getTimeout(animationDelays, animationDurations);
  let type = null;
  let timeout = 0;
  let propCount = 0;
  if (expectedType === TRANSITION) {
    if (transitionTimeout > 0) {
      type = TRANSITION;
      timeout = transitionTimeout;
      propCount = transitionDurations.length;
    }
  } else if (expectedType === ANIMATION) {
    if (animationTimeout > 0) {
      type = ANIMATION;
      timeout = animationTimeout;
      propCount = animationDurations.length;
    }
  } else {
    timeout = Math.max(transitionTimeout, animationTimeout);
    type = timeout > 0 ? transitionTimeout > animationTimeout ? TRANSITION : ANIMATION : null;
    propCount = type ? type === TRANSITION ? transitionDurations.length : animationDurations.length : 0;
  }
  const hasTransform = type === TRANSITION && /\b(transform|all)(,|$)/.test(
    getStyleProperties(`${TRANSITION}Property`).toString()
  );
  return {
    type,
    timeout,
    propCount,
    hasTransform
  };
}
function getTimeout(delays, durations) {
  while (delays.length < durations.length) {
    delays = delays.concat(delays);
  }
  return Math.max(...durations.map((d, i) => toMs(d) + toMs(delays[i])));
}
function toMs(s) {
  if (s === "auto") return 0;
  return Number(s.slice(0, -1).replace(",", ".")) * 1e3;
}
function forceReflow() {
  return document.body.offsetHeight;
}

function patchClass(el, value, isSVG) {
  const transitionClasses = el[vtcKey];
  if (transitionClasses) {
    value = (value ? [value, ...transitionClasses] : [...transitionClasses]).join(" ");
  }
  if (value == null) {
    el.removeAttribute("class");
  } else if (isSVG) {
    el.setAttribute("class", value);
  } else {
    el.className = value;
  }
}

const vShowOriginalDisplay = Symbol("_vod");
const vShowHidden = Symbol("_vsh");
const vShow = {
  beforeMount(el, { value }, { transition }) {
    el[vShowOriginalDisplay] = el.style.display === "none" ? "" : el.style.display;
    if (transition && value) {
      transition.beforeEnter(el);
    } else {
      setDisplay(el, value);
    }
  },
  mounted(el, { value }, { transition }) {
    if (transition && value) {
      transition.enter(el);
    }
  },
  updated(el, { value, oldValue }, { transition }) {
    if (!value === !oldValue) return;
    if (transition) {
      if (value) {
        transition.beforeEnter(el);
        setDisplay(el, true);
        transition.enter(el);
      } else {
        transition.leave(el, () => {
          setDisplay(el, false);
        });
      }
    } else {
      setDisplay(el, value);
    }
  },
  beforeUnmount(el, { value }) {
    setDisplay(el, value);
  }
};
if (true) {
  vShow.name = "show";
}
function setDisplay(el, value) {
  el.style.display = value ? el[vShowOriginalDisplay] : "none";
  el[vShowHidden] = !value;
}
function initVShowForSSR() {
  vShow.getSSRProps = ({ value }) => {
    if (!value) {
      return { style: { display: "none" } };
    }
  };
}

const CSS_VAR_TEXT = Symbol( true ? "CSS_VAR_TEXT" : 0);
function useCssVars(getter) {
  const instance = (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.getCurrentInstance)();
  if (!instance) {
     true && (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(`useCssVars is called without current active component instance.`);
    return;
  }
  const updateTeleports = instance.ut = (vars = getter(instance.proxy)) => {
    Array.from(
      document.querySelectorAll(`[data-v-owner="${instance.uid}"]`)
    ).forEach((node) => setVarsOnNode(node, vars));
  };
  if (true) {
    instance.getCssVars = () => getter(instance.proxy);
  }
  const setVars = () => {
    const vars = getter(instance.proxy);
    if (instance.ce) {
      setVarsOnNode(instance.ce, vars);
    } else {
      setVarsOnVNode(instance.subTree, vars);
    }
    updateTeleports(vars);
  };
  (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onBeforeUpdate)(() => {
    (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.queuePostFlushCb)(setVars);
  });
  (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
    (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.watch)(setVars, _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP, { flush: "post" });
    const ob = new MutationObserver(setVars);
    ob.observe(instance.subTree.el.parentNode, { childList: true });
    (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onUnmounted)(() => ob.disconnect());
  });
}
function setVarsOnVNode(vnode, vars) {
  if (vnode.shapeFlag & 128) {
    const suspense = vnode.suspense;
    vnode = suspense.activeBranch;
    if (suspense.pendingBranch && !suspense.isHydrating) {
      suspense.effects.push(() => {
        setVarsOnVNode(suspense.activeBranch, vars);
      });
    }
  }
  while (vnode.component) {
    vnode = vnode.component.subTree;
  }
  if (vnode.shapeFlag & 1 && vnode.el) {
    setVarsOnNode(vnode.el, vars);
  } else if (vnode.type === _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.Fragment) {
    vnode.children.forEach((c) => setVarsOnVNode(c, vars));
  } else if (vnode.type === _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.Static) {
    let { el, anchor } = vnode;
    while (el) {
      setVarsOnNode(el, vars);
      if (el === anchor) break;
      el = el.nextSibling;
    }
  }
}
function setVarsOnNode(el, vars) {
  if (el.nodeType === 1) {
    const style = el.style;
    let cssText = "";
    for (const key in vars) {
      style.setProperty(`--${key}`, vars[key]);
      cssText += `--${key}: ${vars[key]};`;
    }
    style[CSS_VAR_TEXT] = cssText;
  }
}

const displayRE = /(^|;)\s*display\s*:/;
function patchStyle(el, prev, next) {
  const style = el.style;
  const isCssString = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(next);
  let hasControlledDisplay = false;
  if (next && !isCssString) {
    if (prev) {
      if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(prev)) {
        for (const key in prev) {
          if (next[key] == null) {
            setStyle(style, key, "");
          }
        }
      } else {
        for (const prevStyle of prev.split(";")) {
          const key = prevStyle.slice(0, prevStyle.indexOf(":")).trim();
          if (next[key] == null) {
            setStyle(style, key, "");
          }
        }
      }
    }
    for (const key in next) {
      if (key === "display") {
        hasControlledDisplay = true;
      }
      setStyle(style, key, next[key]);
    }
  } else {
    if (isCssString) {
      if (prev !== next) {
        const cssVarText = style[CSS_VAR_TEXT];
        if (cssVarText) {
          next += ";" + cssVarText;
        }
        style.cssText = next;
        hasControlledDisplay = displayRE.test(next);
      }
    } else if (prev) {
      el.removeAttribute("style");
    }
  }
  if (vShowOriginalDisplay in el) {
    el[vShowOriginalDisplay] = hasControlledDisplay ? style.display : "";
    if (el[vShowHidden]) {
      style.display = "none";
    }
  }
}
const semicolonRE = /[^\\];\s*$/;
const importantRE = /\s*!important$/;
function setStyle(style, name, val) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(val)) {
    val.forEach((v) => setStyle(style, name, v));
  } else {
    if (val == null) val = "";
    if (true) {
      if (semicolonRE.test(val)) {
        (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(
          `Unexpected semicolon at the end of '${name}' style value: '${val}'`
        );
      }
    }
    if (name.startsWith("--")) {
      style.setProperty(name, val);
    } else {
      const prefixed = autoPrefix(style, name);
      if (importantRE.test(val)) {
        style.setProperty(
          (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(prefixed),
          val.replace(importantRE, ""),
          "important"
        );
      } else {
        style[prefixed] = val;
      }
    }
  }
}
const prefixes = ["Webkit", "Moz", "ms"];
const prefixCache = {};
function autoPrefix(style, rawName) {
  const cached = prefixCache[rawName];
  if (cached) {
    return cached;
  }
  let name = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(rawName);
  if (name !== "filter" && name in style) {
    return prefixCache[rawName] = name;
  }
  name = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.capitalize)(name);
  for (let i = 0; i < prefixes.length; i++) {
    const prefixed = prefixes[i] + name;
    if (prefixed in style) {
      return prefixCache[rawName] = prefixed;
    }
  }
  return rawName;
}

const xlinkNS = "http://www.w3.org/1999/xlink";
function patchAttr(el, key, value, isSVG, instance, isBoolean = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isSpecialBooleanAttr)(key)) {
  if (isSVG && key.startsWith("xlink:")) {
    if (value == null) {
      el.removeAttributeNS(xlinkNS, key.slice(6, key.length));
    } else {
      el.setAttributeNS(xlinkNS, key, value);
    }
  } else {
    if (value == null || isBoolean && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.includeBooleanAttr)(value)) {
      el.removeAttribute(key);
    } else {
      el.setAttribute(
        key,
        isBoolean ? "" : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isSymbol)(value) ? String(value) : value
      );
    }
  }
}

function patchDOMProp(el, key, value, parentComponent, attrName) {
  if (key === "innerHTML" || key === "textContent") {
    if (value != null) {
      el[key] = key === "innerHTML" ? unsafeToTrustedHTML(value) : value;
    }
    return;
  }
  const tag = el.tagName;
  if (key === "value" && tag !== "PROGRESS" && // custom elements may use _value internally
  !tag.includes("-")) {
    const oldValue = tag === "OPTION" ? el.getAttribute("value") || "" : el.value;
    const newValue = value == null ? (
      // #11647: value should be set as empty string for null and undefined,
      // but <input type="checkbox"> should be set as 'on'.
      el.type === "checkbox" ? "on" : ""
    ) : String(value);
    if (oldValue !== newValue || !("_value" in el)) {
      el.value = newValue;
    }
    if (value == null) {
      el.removeAttribute(key);
    }
    el._value = value;
    return;
  }
  let needRemove = false;
  if (value === "" || value == null) {
    const type = typeof el[key];
    if (type === "boolean") {
      value = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.includeBooleanAttr)(value);
    } else if (value == null && type === "string") {
      value = "";
      needRemove = true;
    } else if (type === "number") {
      value = 0;
      needRemove = true;
    }
  }
  try {
    el[key] = value;
  } catch (e) {
    if ( true && !needRemove) {
      (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(
        `Failed setting prop "${key}" on <${tag.toLowerCase()}>: value ${value} is invalid.`,
        e
      );
    }
  }
  needRemove && el.removeAttribute(attrName || key);
}

function addEventListener(el, event, handler, options) {
  el.addEventListener(event, handler, options);
}
function removeEventListener(el, event, handler, options) {
  el.removeEventListener(event, handler, options);
}
const veiKey = Symbol("_vei");
function patchEvent(el, rawName, prevValue, nextValue, instance = null) {
  const invokers = el[veiKey] || (el[veiKey] = {});
  const existingInvoker = invokers[rawName];
  if (nextValue && existingInvoker) {
    existingInvoker.value =  true ? sanitizeEventValue(nextValue, rawName) : 0;
  } else {
    const [name, options] = parseName(rawName);
    if (nextValue) {
      const invoker = invokers[rawName] = createInvoker(
         true ? sanitizeEventValue(nextValue, rawName) : 0,
        instance
      );
      addEventListener(el, name, invoker, options);
    } else if (existingInvoker) {
      removeEventListener(el, name, existingInvoker, options);
      invokers[rawName] = void 0;
    }
  }
}
const optionsModifierRE = /(?:Once|Passive|Capture)$/;
function parseName(name) {
  let options;
  if (optionsModifierRE.test(name)) {
    options = {};
    let m;
    while (m = name.match(optionsModifierRE)) {
      name = name.slice(0, name.length - m[0].length);
      options[m[0].toLowerCase()] = true;
    }
  }
  const event = name[2] === ":" ? name.slice(3) : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(name.slice(2));
  return [event, options];
}
let cachedNow = 0;
const p = /* @__PURE__ */ Promise.resolve();
const getNow = () => cachedNow || (p.then(() => cachedNow = 0), cachedNow = Date.now());
function createInvoker(initialValue, instance) {
  const invoker = (e) => {
    if (!e._vts) {
      e._vts = Date.now();
    } else if (e._vts <= invoker.attached) {
      return;
    }
    (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.callWithAsyncErrorHandling)(
      patchStopImmediatePropagation(e, invoker.value),
      instance,
      5,
      [e]
    );
  };
  invoker.value = initialValue;
  invoker.attached = getNow();
  return invoker;
}
function sanitizeEventValue(value, propName) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(value) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(value)) {
    return value;
  }
  (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(
    `Wrong type passed as event handler to ${propName} - did you forget @ or : in front of your prop?
Expected function or array of functions, received type ${typeof value}.`
  );
  return _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP;
}
function patchStopImmediatePropagation(e, value) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(value)) {
    const originalStop = e.stopImmediatePropagation;
    e.stopImmediatePropagation = () => {
      originalStop.call(e);
      e._stopped = true;
    };
    return value.map(
      (fn) => (e2) => !e2._stopped && fn && fn(e2)
    );
  } else {
    return value;
  }
}

const isNativeOn = (key) => key.charCodeAt(0) === 111 && key.charCodeAt(1) === 110 && // lowercase letter
key.charCodeAt(2) > 96 && key.charCodeAt(2) < 123;
const patchProp = (el, key, prevValue, nextValue, namespace, parentComponent) => {
  const isSVG = namespace === "svg";
  if (key === "class") {
    patchClass(el, nextValue, isSVG);
  } else if (key === "style") {
    patchStyle(el, prevValue, nextValue);
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isOn)(key)) {
    if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isModelListener)(key)) {
      patchEvent(el, key, prevValue, nextValue, parentComponent);
    }
  } else if (key[0] === "." ? (key = key.slice(1), true) : key[0] === "^" ? (key = key.slice(1), false) : shouldSetAsProp(el, key, nextValue, isSVG)) {
    patchDOMProp(el, key, nextValue);
    if (!el.tagName.includes("-") && (key === "value" || key === "checked" || key === "selected")) {
      patchAttr(el, key, nextValue, isSVG, parentComponent, key !== "value");
    }
  } else if (
    // #11081 force set props for possible async custom element
    el._isVueCE && (/[A-Z]/.test(key) || !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(nextValue))
  ) {
    patchDOMProp(el, (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(key), nextValue, parentComponent, key);
  } else {
    if (key === "true-value") {
      el._trueValue = nextValue;
    } else if (key === "false-value") {
      el._falseValue = nextValue;
    }
    patchAttr(el, key, nextValue, isSVG);
  }
};
function shouldSetAsProp(el, key, value, isSVG) {
  if (isSVG) {
    if (key === "innerHTML" || key === "textContent") {
      return true;
    }
    if (key in el && isNativeOn(key) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(value)) {
      return true;
    }
    return false;
  }
  if (key === "spellcheck" || key === "draggable" || key === "translate" || key === "autocorrect") {
    return false;
  }
  if (key === "form") {
    return false;
  }
  if (key === "list" && el.tagName === "INPUT") {
    return false;
  }
  if (key === "type" && el.tagName === "TEXTAREA") {
    return false;
  }
  if (key === "width" || key === "height") {
    const tag = el.tagName;
    if (tag === "IMG" || tag === "VIDEO" || tag === "CANVAS" || tag === "SOURCE") {
      return false;
    }
  }
  if (isNativeOn(key) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(value)) {
    return false;
  }
  return key in el;
}

const REMOVAL = {};
/*! #__NO_SIDE_EFFECTS__ */
// @__NO_SIDE_EFFECTS__
function defineCustomElement(options, extraOptions, _createApp) {
  const Comp = (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.defineComponent)(options, extraOptions);
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(Comp)) (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(Comp, extraOptions);
  class VueCustomElement extends VueElement {
    constructor(initialProps) {
      super(Comp, initialProps, _createApp);
    }
  }
  VueCustomElement.def = Comp;
  return VueCustomElement;
}
/*! #__NO_SIDE_EFFECTS__ */
const defineSSRCustomElement = /* @__NO_SIDE_EFFECTS__ */ (options, extraOptions) => {
  return /* @__PURE__ */ defineCustomElement(options, extraOptions, createSSRApp);
};
const BaseClass = typeof HTMLElement !== "undefined" ? HTMLElement : class {
};
class VueElement extends BaseClass {
  constructor(_def, _props = {}, _createApp = createApp) {
    super();
    this._def = _def;
    this._props = _props;
    this._createApp = _createApp;
    this._isVueCE = true;
    /**
     * @internal
     */
    this._instance = null;
    /**
     * @internal
     */
    this._app = null;
    /**
     * @internal
     */
    this._nonce = this._def.nonce;
    this._connected = false;
    this._resolved = false;
    this._numberProps = null;
    this._styleChildren = /* @__PURE__ */ new WeakSet();
    this._ob = null;
    if (this.shadowRoot && _createApp !== createApp) {
      this._root = this.shadowRoot;
    } else {
      if ( true && this.shadowRoot) {
        (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(
          `Custom element has pre-rendered declarative shadow root but is not defined as hydratable. Use \`defineSSRCustomElement\`.`
        );
      }
      if (_def.shadowRoot !== false) {
        this.attachShadow({ mode: "open" });
        this._root = this.shadowRoot;
      } else {
        this._root = this;
      }
    }
  }
  connectedCallback() {
    if (!this.isConnected) return;
    if (!this.shadowRoot && !this._resolved) {
      this._parseSlots();
    }
    this._connected = true;
    let parent = this;
    while (parent = parent && (parent.parentNode || parent.host)) {
      if (parent instanceof VueElement) {
        this._parent = parent;
        break;
      }
    }
    if (!this._instance) {
      if (this._resolved) {
        this._mount(this._def);
      } else {
        if (parent && parent._pendingResolve) {
          this._pendingResolve = parent._pendingResolve.then(() => {
            this._pendingResolve = void 0;
            this._resolveDef();
          });
        } else {
          this._resolveDef();
        }
      }
    }
  }
  _setParent(parent = this._parent) {
    if (parent) {
      this._instance.parent = parent._instance;
      this._inheritParentContext(parent);
    }
  }
  _inheritParentContext(parent = this._parent) {
    if (parent && this._app) {
      Object.setPrototypeOf(
        this._app._context.provides,
        parent._instance.provides
      );
    }
  }
  disconnectedCallback() {
    this._connected = false;
    (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => {
      if (!this._connected) {
        if (this._ob) {
          this._ob.disconnect();
          this._ob = null;
        }
        this._app && this._app.unmount();
        if (this._instance) this._instance.ce = void 0;
        this._app = this._instance = null;
      }
    });
  }
  /**
   * resolve inner component definition (handle possible async component)
   */
  _resolveDef() {
    if (this._pendingResolve) {
      return;
    }
    for (let i = 0; i < this.attributes.length; i++) {
      this._setAttr(this.attributes[i].name);
    }
    this._ob = new MutationObserver((mutations) => {
      for (const m of mutations) {
        this._setAttr(m.attributeName);
      }
    });
    this._ob.observe(this, { attributes: true });
    const resolve = (def, isAsync = false) => {
      this._resolved = true;
      this._pendingResolve = void 0;
      const { props, styles } = def;
      let numberProps;
      if (props && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(props)) {
        for (const key in props) {
          const opt = props[key];
          if (opt === Number || opt && opt.type === Number) {
            if (key in this._props) {
              this._props[key] = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toNumber)(this._props[key]);
            }
            (numberProps || (numberProps = /* @__PURE__ */ Object.create(null)))[(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(key)] = true;
          }
        }
      }
      this._numberProps = numberProps;
      this._resolveProps(def);
      if (this.shadowRoot) {
        this._applyStyles(styles);
      } else if ( true && styles) {
        (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(
          "Custom element style injection is not supported when using shadowRoot: false"
        );
      }
      this._mount(def);
    };
    const asyncDef = this._def.__asyncLoader;
    if (asyncDef) {
      this._pendingResolve = asyncDef().then(
        (def) => resolve(this._def = def, true)
      );
    } else {
      resolve(this._def);
    }
  }
  _mount(def) {
    if (( true) && !def.name) {
      def.name = "VueElement";
    }
    this._app = this._createApp(def);
    this._inheritParentContext();
    if (def.configureApp) {
      def.configureApp(this._app);
    }
    this._app._ceVNode = this._createVNode();
    this._app.mount(this._root);
    const exposed = this._instance && this._instance.exposed;
    if (!exposed) return;
    for (const key in exposed) {
      if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(this, key)) {
        Object.defineProperty(this, key, {
          // unwrap ref to be consistent with public instance behavior
          get: () => (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_2__.unref)(exposed[key])
        });
      } else if (true) {
        (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(`Exposed property "${key}" already exists on custom element.`);
      }
    }
  }
  _resolveProps(def) {
    const { props } = def;
    const declaredPropKeys = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(props) ? props : Object.keys(props || {});
    for (const key of Object.keys(this)) {
      if (key[0] !== "_" && declaredPropKeys.includes(key)) {
        this._setProp(key, this[key]);
      }
    }
    for (const key of declaredPropKeys.map(_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)) {
      Object.defineProperty(this, key, {
        get() {
          return this._getProp(key);
        },
        set(val) {
          this._setProp(key, val, true, true);
        }
      });
    }
  }
  _setAttr(key) {
    if (key.startsWith("data-v-")) return;
    const has = this.hasAttribute(key);
    let value = has ? this.getAttribute(key) : REMOVAL;
    const camelKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(key);
    if (has && this._numberProps && this._numberProps[camelKey]) {
      value = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toNumber)(value);
    }
    this._setProp(camelKey, value, false, true);
  }
  /**
   * @internal
   */
  _getProp(key) {
    return this._props[key];
  }
  /**
   * @internal
   */
  _setProp(key, val, shouldReflect = true, shouldUpdate = false) {
    if (val !== this._props[key]) {
      if (val === REMOVAL) {
        delete this._props[key];
      } else {
        this._props[key] = val;
        if (key === "key" && this._app) {
          this._app._ceVNode.key = val;
        }
      }
      if (shouldUpdate && this._instance) {
        this._update();
      }
      if (shouldReflect) {
        const ob = this._ob;
        ob && ob.disconnect();
        if (val === true) {
          this.setAttribute((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(key), "");
        } else if (typeof val === "string" || typeof val === "number") {
          this.setAttribute((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(key), val + "");
        } else if (!val) {
          this.removeAttribute((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(key));
        }
        ob && ob.observe(this, { attributes: true });
      }
    }
  }
  _update() {
    const vnode = this._createVNode();
    if (this._app) vnode.appContext = this._app._context;
    render(vnode, this._root);
  }
  _createVNode() {
    const baseProps = {};
    if (!this.shadowRoot) {
      baseProps.onVnodeMounted = baseProps.onVnodeUpdated = this._renderSlots.bind(this);
    }
    const vnode = (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createVNode)(this._def, (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(baseProps, this._props));
    if (!this._instance) {
      vnode.ce = (instance) => {
        this._instance = instance;
        instance.ce = this;
        instance.isCE = true;
        if (true) {
          instance.ceReload = (newStyles) => {
            if (this._styles) {
              this._styles.forEach((s) => this._root.removeChild(s));
              this._styles.length = 0;
            }
            this._applyStyles(newStyles);
            this._instance = null;
            this._update();
          };
        }
        const dispatch = (event, args) => {
          this.dispatchEvent(
            new CustomEvent(
              event,
              (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(args[0]) ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({ detail: args }, args[0]) : { detail: args }
            )
          );
        };
        instance.emit = (event, ...args) => {
          dispatch(event, args);
          if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(event) !== event) {
            dispatch((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(event), args);
          }
        };
        this._setParent();
      };
    }
    return vnode;
  }
  _applyStyles(styles, owner) {
    if (!styles) return;
    if (owner) {
      if (owner === this._def || this._styleChildren.has(owner)) {
        return;
      }
      this._styleChildren.add(owner);
    }
    const nonce = this._nonce;
    for (let i = styles.length - 1; i >= 0; i--) {
      const s = document.createElement("style");
      if (nonce) s.setAttribute("nonce", nonce);
      s.textContent = styles[i];
      this.shadowRoot.prepend(s);
      if (true) {
        if (owner) {
          if (owner.__hmrId) {
            if (!this._childStyles) this._childStyles = /* @__PURE__ */ new Map();
            let entry = this._childStyles.get(owner.__hmrId);
            if (!entry) {
              this._childStyles.set(owner.__hmrId, entry = []);
            }
            entry.push(s);
          }
        } else {
          (this._styles || (this._styles = [])).push(s);
        }
      }
    }
  }
  /**
   * Only called when shadowRoot is false
   */
  _parseSlots() {
    const slots = this._slots = {};
    let n;
    while (n = this.firstChild) {
      const slotName = n.nodeType === 1 && n.getAttribute("slot") || "default";
      (slots[slotName] || (slots[slotName] = [])).push(n);
      this.removeChild(n);
    }
  }
  /**
   * Only called when shadowRoot is false
   */
  _renderSlots() {
    const outlets = (this._teleportTarget || this).querySelectorAll("slot");
    const scopeId = this._instance.type.__scopeId;
    for (let i = 0; i < outlets.length; i++) {
      const o = outlets[i];
      const slotName = o.getAttribute("name") || "default";
      const content = this._slots[slotName];
      const parent = o.parentNode;
      if (content) {
        for (const n of content) {
          if (scopeId && n.nodeType === 1) {
            const id = scopeId + "-s";
            const walker = document.createTreeWalker(n, 1);
            n.setAttribute(id, "");
            let child;
            while (child = walker.nextNode()) {
              child.setAttribute(id, "");
            }
          }
          parent.insertBefore(n, o);
        }
      } else {
        while (o.firstChild) parent.insertBefore(o.firstChild, o);
      }
      parent.removeChild(o);
    }
  }
  /**
   * @internal
   */
  _injectChildStyle(comp) {
    this._applyStyles(comp.styles, comp);
  }
  /**
   * @internal
   */
  _removeChildStyle(comp) {
    if (true) {
      this._styleChildren.delete(comp);
      if (this._childStyles && comp.__hmrId) {
        const oldStyles = this._childStyles.get(comp.__hmrId);
        if (oldStyles) {
          oldStyles.forEach((s) => this._root.removeChild(s));
          oldStyles.length = 0;
        }
      }
    }
  }
}
function useHost(caller) {
  const instance = (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.getCurrentInstance)();
  const el = instance && instance.ce;
  if (el) {
    return el;
  } else if (true) {
    if (!instance) {
      (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(
        `${caller || "useHost"} called without an active component instance.`
      );
    } else {
      (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(
        `${caller || "useHost"} can only be used in components defined via defineCustomElement.`
      );
    }
  }
  return null;
}
function useShadowRoot() {
  const el =  true ? useHost("useShadowRoot") : 0;
  return el && el.shadowRoot;
}

function useCssModule(name = "$style") {
  {
    const instance = (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.getCurrentInstance)();
    if (!instance) {
       true && (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(`useCssModule must be called inside setup()`);
      return _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;
    }
    const modules = instance.type.__cssModules;
    if (!modules) {
       true && (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(`Current instance does not have CSS modules injected.`);
      return _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;
    }
    const mod = modules[name];
    if (!mod) {
       true && (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(`Current instance does not have CSS module named "${name}".`);
      return _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;
    }
    return mod;
  }
}

const positionMap = /* @__PURE__ */ new WeakMap();
const newPositionMap = /* @__PURE__ */ new WeakMap();
const moveCbKey = Symbol("_moveCb");
const enterCbKey = Symbol("_enterCb");
const decorate = (t) => {
  delete t.props.mode;
  return t;
};
const TransitionGroupImpl = /* @__PURE__ */ decorate({
  name: "TransitionGroup",
  props: /* @__PURE__ */ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, TransitionPropsValidators, {
    tag: String,
    moveClass: String
  }),
  setup(props, { slots }) {
    const instance = (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.getCurrentInstance)();
    const state = (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.useTransitionState)();
    let prevChildren;
    let children;
    (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.onUpdated)(() => {
      if (!prevChildren.length) {
        return;
      }
      const moveClass = props.moveClass || `${props.name || "v"}-move`;
      if (!hasCSSTransform(
        prevChildren[0].el,
        instance.vnode.el,
        moveClass
      )) {
        prevChildren = [];
        return;
      }
      prevChildren.forEach(callPendingCbs);
      prevChildren.forEach(recordPosition);
      const movedChildren = prevChildren.filter(applyTranslation);
      forceReflow();
      movedChildren.forEach((c) => {
        const el = c.el;
        const style = el.style;
        addTransitionClass(el, moveClass);
        style.transform = style.webkitTransform = style.transitionDuration = "";
        const cb = el[moveCbKey] = (e) => {
          if (e && e.target !== el) {
            return;
          }
          if (!e || /transform$/.test(e.propertyName)) {
            el.removeEventListener("transitionend", cb);
            el[moveCbKey] = null;
            removeTransitionClass(el, moveClass);
          }
        };
        el.addEventListener("transitionend", cb);
      });
      prevChildren = [];
    });
    return () => {
      const rawProps = (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_2__.toRaw)(props);
      const cssTransitionProps = resolveTransitionProps(rawProps);
      let tag = rawProps.tag || _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.Fragment;
      prevChildren = [];
      if (children) {
        for (let i = 0; i < children.length; i++) {
          const child = children[i];
          if (child.el && child.el instanceof Element) {
            prevChildren.push(child);
            (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.setTransitionHooks)(
              child,
              (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.resolveTransitionHooks)(
                child,
                cssTransitionProps,
                state,
                instance
              )
            );
            positionMap.set(
              child,
              child.el.getBoundingClientRect()
            );
          }
        }
      }
      children = slots.default ? (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.getTransitionRawChildren)(slots.default()) : [];
      for (let i = 0; i < children.length; i++) {
        const child = children[i];
        if (child.key != null) {
          (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.setTransitionHooks)(
            child,
            (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.resolveTransitionHooks)(child, cssTransitionProps, state, instance)
          );
        } else if ( true && child.type !== _vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.Text) {
          (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(`<TransitionGroup> children must be keyed.`);
        }
      }
      return (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createVNode)(tag, null, children);
    };
  }
});
const TransitionGroup = TransitionGroupImpl;
function callPendingCbs(c) {
  const el = c.el;
  if (el[moveCbKey]) {
    el[moveCbKey]();
  }
  if (el[enterCbKey]) {
    el[enterCbKey]();
  }
}
function recordPosition(c) {
  newPositionMap.set(c, c.el.getBoundingClientRect());
}
function applyTranslation(c) {
  const oldPos = positionMap.get(c);
  const newPos = newPositionMap.get(c);
  const dx = oldPos.left - newPos.left;
  const dy = oldPos.top - newPos.top;
  if (dx || dy) {
    const s = c.el.style;
    s.transform = s.webkitTransform = `translate(${dx}px,${dy}px)`;
    s.transitionDuration = "0s";
    return c;
  }
}
function hasCSSTransform(el, root, moveClass) {
  const clone = el.cloneNode();
  const _vtc = el[vtcKey];
  if (_vtc) {
    _vtc.forEach((cls) => {
      cls.split(/\s+/).forEach((c) => c && clone.classList.remove(c));
    });
  }
  moveClass.split(/\s+/).forEach((c) => c && clone.classList.add(c));
  clone.style.display = "none";
  const container = root.nodeType === 1 ? root : root.parentNode;
  container.appendChild(clone);
  const { hasTransform } = getTransitionInfo(clone);
  container.removeChild(clone);
  return hasTransform;
}

const getModelAssigner = (vnode) => {
  const fn = vnode.props["onUpdate:modelValue"] || false;
  return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(fn) ? (value) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(fn, value) : fn;
};
function onCompositionStart(e) {
  e.target.composing = true;
}
function onCompositionEnd(e) {
  const target = e.target;
  if (target.composing) {
    target.composing = false;
    target.dispatchEvent(new Event("input"));
  }
}
const assignKey = Symbol("_assign");
const vModelText = {
  created(el, { modifiers: { lazy, trim, number } }, vnode) {
    el[assignKey] = getModelAssigner(vnode);
    const castToNumber = number || vnode.props && vnode.props.type === "number";
    addEventListener(el, lazy ? "change" : "input", (e) => {
      if (e.target.composing) return;
      let domValue = el.value;
      if (trim) {
        domValue = domValue.trim();
      }
      if (castToNumber) {
        domValue = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.looseToNumber)(domValue);
      }
      el[assignKey](domValue);
    });
    if (trim) {
      addEventListener(el, "change", () => {
        el.value = el.value.trim();
      });
    }
    if (!lazy) {
      addEventListener(el, "compositionstart", onCompositionStart);
      addEventListener(el, "compositionend", onCompositionEnd);
      addEventListener(el, "change", onCompositionEnd);
    }
  },
  // set value on mounted so it's after min/max for type="range"
  mounted(el, { value }) {
    el.value = value == null ? "" : value;
  },
  beforeUpdate(el, { value, oldValue, modifiers: { lazy, trim, number } }, vnode) {
    el[assignKey] = getModelAssigner(vnode);
    if (el.composing) return;
    const elValue = (number || el.type === "number") && !/^0\d/.test(el.value) ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.looseToNumber)(el.value) : el.value;
    const newValue = value == null ? "" : value;
    if (elValue === newValue) {
      return;
    }
    if (document.activeElement === el && el.type !== "range") {
      if (lazy && value === oldValue) {
        return;
      }
      if (trim && el.value.trim() === newValue) {
        return;
      }
    }
    el.value = newValue;
  }
};
const vModelCheckbox = {
  // #4096 array checkboxes need to be deep traversed
  deep: true,
  created(el, _, vnode) {
    el[assignKey] = getModelAssigner(vnode);
    addEventListener(el, "change", () => {
      const modelValue = el._modelValue;
      const elementValue = getValue(el);
      const checked = el.checked;
      const assign = el[assignKey];
      if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(modelValue)) {
        const index = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.looseIndexOf)(modelValue, elementValue);
        const found = index !== -1;
        if (checked && !found) {
          assign(modelValue.concat(elementValue));
        } else if (!checked && found) {
          const filtered = [...modelValue];
          filtered.splice(index, 1);
          assign(filtered);
        }
      } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isSet)(modelValue)) {
        const cloned = new Set(modelValue);
        if (checked) {
          cloned.add(elementValue);
        } else {
          cloned.delete(elementValue);
        }
        assign(cloned);
      } else {
        assign(getCheckboxValue(el, checked));
      }
    });
  },
  // set initial checked on mount to wait for true-value/false-value
  mounted: setChecked,
  beforeUpdate(el, binding, vnode) {
    el[assignKey] = getModelAssigner(vnode);
    setChecked(el, binding, vnode);
  }
};
function setChecked(el, { value, oldValue }, vnode) {
  el._modelValue = value;
  let checked;
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(value)) {
    checked = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.looseIndexOf)(value, vnode.props.value) > -1;
  } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isSet)(value)) {
    checked = value.has(vnode.props.value);
  } else {
    if (value === oldValue) return;
    checked = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.looseEqual)(value, getCheckboxValue(el, true));
  }
  if (el.checked !== checked) {
    el.checked = checked;
  }
}
const vModelRadio = {
  created(el, { value }, vnode) {
    el.checked = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.looseEqual)(value, vnode.props.value);
    el[assignKey] = getModelAssigner(vnode);
    addEventListener(el, "change", () => {
      el[assignKey](getValue(el));
    });
  },
  beforeUpdate(el, { value, oldValue }, vnode) {
    el[assignKey] = getModelAssigner(vnode);
    if (value !== oldValue) {
      el.checked = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.looseEqual)(value, vnode.props.value);
    }
  }
};
const vModelSelect = {
  // <select multiple> value need to be deep traversed
  deep: true,
  created(el, { value, modifiers: { number } }, vnode) {
    const isSetModel = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isSet)(value);
    addEventListener(el, "change", () => {
      const selectedVal = Array.prototype.filter.call(el.options, (o) => o.selected).map(
        (o) => number ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.looseToNumber)(getValue(o)) : getValue(o)
      );
      el[assignKey](
        el.multiple ? isSetModel ? new Set(selectedVal) : selectedVal : selectedVal[0]
      );
      el._assigning = true;
      (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => {
        el._assigning = false;
      });
    });
    el[assignKey] = getModelAssigner(vnode);
  },
  // set value in mounted & updated because <select> relies on its children
  // <option>s.
  mounted(el, { value }) {
    setSelected(el, value);
  },
  beforeUpdate(el, _binding, vnode) {
    el[assignKey] = getModelAssigner(vnode);
  },
  updated(el, { value }) {
    if (!el._assigning) {
      setSelected(el, value);
    }
  }
};
function setSelected(el, value) {
  const isMultiple = el.multiple;
  const isArrayValue = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(value);
  if (isMultiple && !isArrayValue && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isSet)(value)) {
     true && (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(
      `<select multiple v-model> expects an Array or Set value for its binding, but got ${Object.prototype.toString.call(value).slice(8, -1)}.`
    );
    return;
  }
  for (let i = 0, l = el.options.length; i < l; i++) {
    const option = el.options[i];
    const optionValue = getValue(option);
    if (isMultiple) {
      if (isArrayValue) {
        const optionType = typeof optionValue;
        if (optionType === "string" || optionType === "number") {
          option.selected = value.some((v) => String(v) === String(optionValue));
        } else {
          option.selected = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.looseIndexOf)(value, optionValue) > -1;
        }
      } else {
        option.selected = value.has(optionValue);
      }
    } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.looseEqual)(getValue(option), value)) {
      if (el.selectedIndex !== i) el.selectedIndex = i;
      return;
    }
  }
  if (!isMultiple && el.selectedIndex !== -1) {
    el.selectedIndex = -1;
  }
}
function getValue(el) {
  return "_value" in el ? el._value : el.value;
}
function getCheckboxValue(el, checked) {
  const key = checked ? "_trueValue" : "_falseValue";
  return key in el ? el[key] : checked;
}
const vModelDynamic = {
  created(el, binding, vnode) {
    callModelHook(el, binding, vnode, null, "created");
  },
  mounted(el, binding, vnode) {
    callModelHook(el, binding, vnode, null, "mounted");
  },
  beforeUpdate(el, binding, vnode, prevVNode) {
    callModelHook(el, binding, vnode, prevVNode, "beforeUpdate");
  },
  updated(el, binding, vnode, prevVNode) {
    callModelHook(el, binding, vnode, prevVNode, "updated");
  }
};
function resolveDynamicModel(tagName, type) {
  switch (tagName) {
    case "SELECT":
      return vModelSelect;
    case "TEXTAREA":
      return vModelText;
    default:
      switch (type) {
        case "checkbox":
          return vModelCheckbox;
        case "radio":
          return vModelRadio;
        default:
          return vModelText;
      }
  }
}
function callModelHook(el, binding, vnode, prevVNode, hook) {
  const modelToUse = resolveDynamicModel(
    el.tagName,
    vnode.props && vnode.props.type
  );
  const fn = modelToUse[hook];
  fn && fn(el, binding, vnode, prevVNode);
}
function initVModelForSSR() {
  vModelText.getSSRProps = ({ value }) => ({ value });
  vModelRadio.getSSRProps = ({ value }, vnode) => {
    if (vnode.props && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.looseEqual)(vnode.props.value, value)) {
      return { checked: true };
    }
  };
  vModelCheckbox.getSSRProps = ({ value }, vnode) => {
    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(value)) {
      if (vnode.props && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.looseIndexOf)(value, vnode.props.value) > -1) {
        return { checked: true };
      }
    } else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isSet)(value)) {
      if (vnode.props && value.has(vnode.props.value)) {
        return { checked: true };
      }
    } else if (value) {
      return { checked: true };
    }
  };
  vModelDynamic.getSSRProps = (binding, vnode) => {
    if (typeof vnode.type !== "string") {
      return;
    }
    const modelToUse = resolveDynamicModel(
      // resolveDynamicModel expects an uppercase tag name, but vnode.type is lowercase
      vnode.type.toUpperCase(),
      vnode.props && vnode.props.type
    );
    if (modelToUse.getSSRProps) {
      return modelToUse.getSSRProps(binding, vnode);
    }
  };
}

const systemModifiers = ["ctrl", "shift", "alt", "meta"];
const modifierGuards = {
  stop: (e) => e.stopPropagation(),
  prevent: (e) => e.preventDefault(),
  self: (e) => e.target !== e.currentTarget,
  ctrl: (e) => !e.ctrlKey,
  shift: (e) => !e.shiftKey,
  alt: (e) => !e.altKey,
  meta: (e) => !e.metaKey,
  left: (e) => "button" in e && e.button !== 0,
  middle: (e) => "button" in e && e.button !== 1,
  right: (e) => "button" in e && e.button !== 2,
  exact: (e, modifiers) => systemModifiers.some((m) => e[`${m}Key`] && !modifiers.includes(m))
};
const withModifiers = (fn, modifiers) => {
  const cache = fn._withMods || (fn._withMods = {});
  const cacheKey = modifiers.join(".");
  return cache[cacheKey] || (cache[cacheKey] = (event, ...args) => {
    for (let i = 0; i < modifiers.length; i++) {
      const guard = modifierGuards[modifiers[i]];
      if (guard && guard(event, modifiers)) return;
    }
    return fn(event, ...args);
  });
};
const keyNames = {
  esc: "escape",
  space: " ",
  up: "arrow-up",
  left: "arrow-left",
  right: "arrow-right",
  down: "arrow-down",
  delete: "backspace"
};
const withKeys = (fn, modifiers) => {
  const cache = fn._withKeys || (fn._withKeys = {});
  const cacheKey = modifiers.join(".");
  return cache[cacheKey] || (cache[cacheKey] = (event) => {
    if (!("key" in event)) {
      return;
    }
    const eventKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(event.key);
    if (modifiers.some(
      (k) => k === eventKey || keyNames[k] === eventKey
    )) {
      return fn(event);
    }
  });
};

const rendererOptions = /* @__PURE__ */ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({ patchProp }, nodeOps);
let renderer;
let enabledHydration = false;
function ensureRenderer() {
  return renderer || (renderer = (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createRenderer)(rendererOptions));
}
function ensureHydrationRenderer() {
  renderer = enabledHydration ? renderer : (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.createHydrationRenderer)(rendererOptions);
  enabledHydration = true;
  return renderer;
}
const render = (...args) => {
  ensureRenderer().render(...args);
};
const hydrate = (...args) => {
  ensureHydrationRenderer().hydrate(...args);
};
const createApp = (...args) => {
  const app = ensureRenderer().createApp(...args);
  if (true) {
    injectNativeTagCheck(app);
    injectCompilerOptionsCheck(app);
  }
  const { mount } = app;
  app.mount = (containerOrSelector) => {
    const container = normalizeContainer(containerOrSelector);
    if (!container) return;
    const component = app._component;
    if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(component) && !component.render && !component.template) {
      component.template = container.innerHTML;
    }
    if (container.nodeType === 1) {
      container.textContent = "";
    }
    const proxy = mount(container, false, resolveRootNamespace(container));
    if (container instanceof Element) {
      container.removeAttribute("v-cloak");
      container.setAttribute("data-v-app", "");
    }
    return proxy;
  };
  return app;
};
const createSSRApp = (...args) => {
  const app = ensureHydrationRenderer().createApp(...args);
  if (true) {
    injectNativeTagCheck(app);
    injectCompilerOptionsCheck(app);
  }
  const { mount } = app;
  app.mount = (containerOrSelector) => {
    const container = normalizeContainer(containerOrSelector);
    if (container) {
      return mount(container, true, resolveRootNamespace(container));
    }
  };
  return app;
};
function resolveRootNamespace(container) {
  if (container instanceof SVGElement) {
    return "svg";
  }
  if (typeof MathMLElement === "function" && container instanceof MathMLElement) {
    return "mathml";
  }
}
function injectNativeTagCheck(app) {
  Object.defineProperty(app.config, "isNativeTag", {
    value: (tag) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isHTMLTag)(tag) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isSVGTag)(tag) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isMathMLTag)(tag),
    writable: false
  });
}
function injectCompilerOptionsCheck(app) {
  if ((0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.isRuntimeOnly)()) {
    const isCustomElement = app.config.isCustomElement;
    Object.defineProperty(app.config, "isCustomElement", {
      get() {
        return isCustomElement;
      },
      set() {
        (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(
          `The \`isCustomElement\` config option is deprecated. Use \`compilerOptions.isCustomElement\` instead.`
        );
      }
    });
    const compilerOptions = app.config.compilerOptions;
    const msg = `The \`compilerOptions\` config option is only respected when using a build of Vue.js that includes the runtime compiler (aka "full build"). Since you are using the runtime-only build, \`compilerOptions\` must be passed to \`@vue/compiler-dom\` in the build setup instead.
- For vue-loader: pass it via vue-loader's \`compilerOptions\` loader option.
- For vue-cli: see https://cli.vuejs.org/guide/webpack.html#modifying-options-of-a-loader
- For vite: pass it via @vitejs/plugin-vue options. See https://github.com/vitejs/vite-plugin-vue/tree/main/packages/plugin-vue#example-for-passing-options-to-vuecompiler-sfc`;
    Object.defineProperty(app.config, "compilerOptions", {
      get() {
        (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(msg);
        return compilerOptions;
      },
      set() {
        (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(msg);
      }
    });
  }
}
function normalizeContainer(container) {
  if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(container)) {
    const res = document.querySelector(container);
    if ( true && !res) {
      (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(
        `Failed to mount app: mount target selector "${container}" returned null.`
      );
    }
    return res;
  }
  if ( true && window.ShadowRoot && container instanceof window.ShadowRoot && container.mode === "closed") {
    (0,_vue_runtime_core__WEBPACK_IMPORTED_MODULE_0__.warn)(
      `mounting on a ShadowRoot with \`{mode: "closed"}\` may lead to unpredictable bugs`
    );
  }
  return container;
}
let ssrDirectiveInitialized = false;
const initDirectivesForSSR = () => {
  if (!ssrDirectiveInitialized) {
    ssrDirectiveInitialized = true;
    initVModelForSSR();
    initVShowForSSR();
  }
} ;




/***/ }),

/***/ "./node_modules/@vue/shared/dist/shared.esm-bundler.js":
/*!*************************************************************!*\
  !*** ./node_modules/@vue/shared/dist/shared.esm-bundler.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EMPTY_ARR: () => (/* binding */ EMPTY_ARR),
/* harmony export */   EMPTY_OBJ: () => (/* binding */ EMPTY_OBJ),
/* harmony export */   NO: () => (/* binding */ NO),
/* harmony export */   NOOP: () => (/* binding */ NOOP),
/* harmony export */   PatchFlagNames: () => (/* binding */ PatchFlagNames),
/* harmony export */   PatchFlags: () => (/* binding */ PatchFlags),
/* harmony export */   ShapeFlags: () => (/* binding */ ShapeFlags),
/* harmony export */   SlotFlags: () => (/* binding */ SlotFlags),
/* harmony export */   camelize: () => (/* binding */ camelize),
/* harmony export */   capitalize: () => (/* binding */ capitalize),
/* harmony export */   cssVarNameEscapeSymbolsRE: () => (/* binding */ cssVarNameEscapeSymbolsRE),
/* harmony export */   def: () => (/* binding */ def),
/* harmony export */   escapeHtml: () => (/* binding */ escapeHtml),
/* harmony export */   escapeHtmlComment: () => (/* binding */ escapeHtmlComment),
/* harmony export */   extend: () => (/* binding */ extend),
/* harmony export */   genCacheKey: () => (/* binding */ genCacheKey),
/* harmony export */   genPropsAccessExp: () => (/* binding */ genPropsAccessExp),
/* harmony export */   generateCodeFrame: () => (/* binding */ generateCodeFrame),
/* harmony export */   getEscapedCssVarName: () => (/* binding */ getEscapedCssVarName),
/* harmony export */   getGlobalThis: () => (/* binding */ getGlobalThis),
/* harmony export */   hasChanged: () => (/* binding */ hasChanged),
/* harmony export */   hasOwn: () => (/* binding */ hasOwn),
/* harmony export */   hyphenate: () => (/* binding */ hyphenate),
/* harmony export */   includeBooleanAttr: () => (/* binding */ includeBooleanAttr),
/* harmony export */   invokeArrayFns: () => (/* binding */ invokeArrayFns),
/* harmony export */   isArray: () => (/* binding */ isArray),
/* harmony export */   isBooleanAttr: () => (/* binding */ isBooleanAttr),
/* harmony export */   isBuiltInDirective: () => (/* binding */ isBuiltInDirective),
/* harmony export */   isDate: () => (/* binding */ isDate),
/* harmony export */   isFunction: () => (/* binding */ isFunction),
/* harmony export */   isGloballyAllowed: () => (/* binding */ isGloballyAllowed),
/* harmony export */   isGloballyWhitelisted: () => (/* binding */ isGloballyWhitelisted),
/* harmony export */   isHTMLTag: () => (/* binding */ isHTMLTag),
/* harmony export */   isIntegerKey: () => (/* binding */ isIntegerKey),
/* harmony export */   isKnownHtmlAttr: () => (/* binding */ isKnownHtmlAttr),
/* harmony export */   isKnownMathMLAttr: () => (/* binding */ isKnownMathMLAttr),
/* harmony export */   isKnownSvgAttr: () => (/* binding */ isKnownSvgAttr),
/* harmony export */   isMap: () => (/* binding */ isMap),
/* harmony export */   isMathMLTag: () => (/* binding */ isMathMLTag),
/* harmony export */   isModelListener: () => (/* binding */ isModelListener),
/* harmony export */   isObject: () => (/* binding */ isObject),
/* harmony export */   isOn: () => (/* binding */ isOn),
/* harmony export */   isPlainObject: () => (/* binding */ isPlainObject),
/* harmony export */   isPromise: () => (/* binding */ isPromise),
/* harmony export */   isRegExp: () => (/* binding */ isRegExp),
/* harmony export */   isRenderableAttrValue: () => (/* binding */ isRenderableAttrValue),
/* harmony export */   isReservedProp: () => (/* binding */ isReservedProp),
/* harmony export */   isSSRSafeAttrName: () => (/* binding */ isSSRSafeAttrName),
/* harmony export */   isSVGTag: () => (/* binding */ isSVGTag),
/* harmony export */   isSet: () => (/* binding */ isSet),
/* harmony export */   isSpecialBooleanAttr: () => (/* binding */ isSpecialBooleanAttr),
/* harmony export */   isString: () => (/* binding */ isString),
/* harmony export */   isSymbol: () => (/* binding */ isSymbol),
/* harmony export */   isVoidTag: () => (/* binding */ isVoidTag),
/* harmony export */   looseEqual: () => (/* binding */ looseEqual),
/* harmony export */   looseIndexOf: () => (/* binding */ looseIndexOf),
/* harmony export */   looseToNumber: () => (/* binding */ looseToNumber),
/* harmony export */   makeMap: () => (/* binding */ makeMap),
/* harmony export */   normalizeClass: () => (/* binding */ normalizeClass),
/* harmony export */   normalizeProps: () => (/* binding */ normalizeProps),
/* harmony export */   normalizeStyle: () => (/* binding */ normalizeStyle),
/* harmony export */   objectToString: () => (/* binding */ objectToString),
/* harmony export */   parseStringStyle: () => (/* binding */ parseStringStyle),
/* harmony export */   propsToAttrMap: () => (/* binding */ propsToAttrMap),
/* harmony export */   remove: () => (/* binding */ remove),
/* harmony export */   slotFlagsText: () => (/* binding */ slotFlagsText),
/* harmony export */   stringifyStyle: () => (/* binding */ stringifyStyle),
/* harmony export */   toDisplayString: () => (/* binding */ toDisplayString),
/* harmony export */   toHandlerKey: () => (/* binding */ toHandlerKey),
/* harmony export */   toNumber: () => (/* binding */ toNumber),
/* harmony export */   toRawType: () => (/* binding */ toRawType),
/* harmony export */   toTypeString: () => (/* binding */ toTypeString)
/* harmony export */ });
/**
* @vue/shared v3.5.16
* (c) 2018-present Yuxi (Evan) You and Vue contributors
* @license MIT
**/
/*! #__NO_SIDE_EFFECTS__ */
// @__NO_SIDE_EFFECTS__
function makeMap(str) {
  const map = /* @__PURE__ */ Object.create(null);
  for (const key of str.split(",")) map[key] = 1;
  return (val) => val in map;
}

const EMPTY_OBJ =  true ? Object.freeze({}) : 0;
const EMPTY_ARR =  true ? Object.freeze([]) : 0;
const NOOP = () => {
};
const NO = () => false;
const isOn = (key) => key.charCodeAt(0) === 111 && key.charCodeAt(1) === 110 && // uppercase letter
(key.charCodeAt(2) > 122 || key.charCodeAt(2) < 97);
const isModelListener = (key) => key.startsWith("onUpdate:");
const extend = Object.assign;
const remove = (arr, el) => {
  const i = arr.indexOf(el);
  if (i > -1) {
    arr.splice(i, 1);
  }
};
const hasOwnProperty = Object.prototype.hasOwnProperty;
const hasOwn = (val, key) => hasOwnProperty.call(val, key);
const isArray = Array.isArray;
const isMap = (val) => toTypeString(val) === "[object Map]";
const isSet = (val) => toTypeString(val) === "[object Set]";
const isDate = (val) => toTypeString(val) === "[object Date]";
const isRegExp = (val) => toTypeString(val) === "[object RegExp]";
const isFunction = (val) => typeof val === "function";
const isString = (val) => typeof val === "string";
const isSymbol = (val) => typeof val === "symbol";
const isObject = (val) => val !== null && typeof val === "object";
const isPromise = (val) => {
  return (isObject(val) || isFunction(val)) && isFunction(val.then) && isFunction(val.catch);
};
const objectToString = Object.prototype.toString;
const toTypeString = (value) => objectToString.call(value);
const toRawType = (value) => {
  return toTypeString(value).slice(8, -1);
};
const isPlainObject = (val) => toTypeString(val) === "[object Object]";
const isIntegerKey = (key) => isString(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
const isReservedProp = /* @__PURE__ */ makeMap(
  // the leading comma is intentional so empty string "" is also included
  ",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted"
);
const isBuiltInDirective = /* @__PURE__ */ makeMap(
  "bind,cloak,else-if,else,for,html,if,model,on,once,pre,show,slot,text,memo"
);
const cacheStringFunction = (fn) => {
  const cache = /* @__PURE__ */ Object.create(null);
  return (str) => {
    const hit = cache[str];
    return hit || (cache[str] = fn(str));
  };
};
const camelizeRE = /-(\w)/g;
const camelize = cacheStringFunction(
  (str) => {
    return str.replace(camelizeRE, (_, c) => c ? c.toUpperCase() : "");
  }
);
const hyphenateRE = /\B([A-Z])/g;
const hyphenate = cacheStringFunction(
  (str) => str.replace(hyphenateRE, "-$1").toLowerCase()
);
const capitalize = cacheStringFunction((str) => {
  return str.charAt(0).toUpperCase() + str.slice(1);
});
const toHandlerKey = cacheStringFunction(
  (str) => {
    const s = str ? `on${capitalize(str)}` : ``;
    return s;
  }
);
const hasChanged = (value, oldValue) => !Object.is(value, oldValue);
const invokeArrayFns = (fns, ...arg) => {
  for (let i = 0; i < fns.length; i++) {
    fns[i](...arg);
  }
};
const def = (obj, key, value, writable = false) => {
  Object.defineProperty(obj, key, {
    configurable: true,
    enumerable: false,
    writable,
    value
  });
};
const looseToNumber = (val) => {
  const n = parseFloat(val);
  return isNaN(n) ? val : n;
};
const toNumber = (val) => {
  const n = isString(val) ? Number(val) : NaN;
  return isNaN(n) ? val : n;
};
let _globalThis;
const getGlobalThis = () => {
  return _globalThis || (_globalThis = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof __webpack_require__.g !== "undefined" ? __webpack_require__.g : {});
};
const identRE = /^[_$a-zA-Z\xA0-\uFFFF][_$a-zA-Z0-9\xA0-\uFFFF]*$/;
function genPropsAccessExp(name) {
  return identRE.test(name) ? `__props.${name}` : `__props[${JSON.stringify(name)}]`;
}
function genCacheKey(source, options) {
  return source + JSON.stringify(
    options,
    (_, val) => typeof val === "function" ? val.toString() : val
  );
}

const PatchFlags = {
  "TEXT": 1,
  "1": "TEXT",
  "CLASS": 2,
  "2": "CLASS",
  "STYLE": 4,
  "4": "STYLE",
  "PROPS": 8,
  "8": "PROPS",
  "FULL_PROPS": 16,
  "16": "FULL_PROPS",
  "NEED_HYDRATION": 32,
  "32": "NEED_HYDRATION",
  "STABLE_FRAGMENT": 64,
  "64": "STABLE_FRAGMENT",
  "KEYED_FRAGMENT": 128,
  "128": "KEYED_FRAGMENT",
  "UNKEYED_FRAGMENT": 256,
  "256": "UNKEYED_FRAGMENT",
  "NEED_PATCH": 512,
  "512": "NEED_PATCH",
  "DYNAMIC_SLOTS": 1024,
  "1024": "DYNAMIC_SLOTS",
  "DEV_ROOT_FRAGMENT": 2048,
  "2048": "DEV_ROOT_FRAGMENT",
  "CACHED": -1,
  "-1": "CACHED",
  "BAIL": -2,
  "-2": "BAIL"
};
const PatchFlagNames = {
  [1]: `TEXT`,
  [2]: `CLASS`,
  [4]: `STYLE`,
  [8]: `PROPS`,
  [16]: `FULL_PROPS`,
  [32]: `NEED_HYDRATION`,
  [64]: `STABLE_FRAGMENT`,
  [128]: `KEYED_FRAGMENT`,
  [256]: `UNKEYED_FRAGMENT`,
  [512]: `NEED_PATCH`,
  [1024]: `DYNAMIC_SLOTS`,
  [2048]: `DEV_ROOT_FRAGMENT`,
  [-1]: `HOISTED`,
  [-2]: `BAIL`
};

const ShapeFlags = {
  "ELEMENT": 1,
  "1": "ELEMENT",
  "FUNCTIONAL_COMPONENT": 2,
  "2": "FUNCTIONAL_COMPONENT",
  "STATEFUL_COMPONENT": 4,
  "4": "STATEFUL_COMPONENT",
  "TEXT_CHILDREN": 8,
  "8": "TEXT_CHILDREN",
  "ARRAY_CHILDREN": 16,
  "16": "ARRAY_CHILDREN",
  "SLOTS_CHILDREN": 32,
  "32": "SLOTS_CHILDREN",
  "TELEPORT": 64,
  "64": "TELEPORT",
  "SUSPENSE": 128,
  "128": "SUSPENSE",
  "COMPONENT_SHOULD_KEEP_ALIVE": 256,
  "256": "COMPONENT_SHOULD_KEEP_ALIVE",
  "COMPONENT_KEPT_ALIVE": 512,
  "512": "COMPONENT_KEPT_ALIVE",
  "COMPONENT": 6,
  "6": "COMPONENT"
};

const SlotFlags = {
  "STABLE": 1,
  "1": "STABLE",
  "DYNAMIC": 2,
  "2": "DYNAMIC",
  "FORWARDED": 3,
  "3": "FORWARDED"
};
const slotFlagsText = {
  [1]: "STABLE",
  [2]: "DYNAMIC",
  [3]: "FORWARDED"
};

const GLOBALS_ALLOWED = "Infinity,undefined,NaN,isFinite,isNaN,parseFloat,parseInt,decodeURI,decodeURIComponent,encodeURI,encodeURIComponent,Math,Number,Date,Array,Object,Boolean,String,RegExp,Map,Set,JSON,Intl,BigInt,console,Error,Symbol";
const isGloballyAllowed = /* @__PURE__ */ makeMap(GLOBALS_ALLOWED);
const isGloballyWhitelisted = isGloballyAllowed;

const range = 2;
function generateCodeFrame(source, start = 0, end = source.length) {
  start = Math.max(0, Math.min(start, source.length));
  end = Math.max(0, Math.min(end, source.length));
  if (start > end) return "";
  let lines = source.split(/(\r?\n)/);
  const newlineSequences = lines.filter((_, idx) => idx % 2 === 1);
  lines = lines.filter((_, idx) => idx % 2 === 0);
  let count = 0;
  const res = [];
  for (let i = 0; i < lines.length; i++) {
    count += lines[i].length + (newlineSequences[i] && newlineSequences[i].length || 0);
    if (count >= start) {
      for (let j = i - range; j <= i + range || end > count; j++) {
        if (j < 0 || j >= lines.length) continue;
        const line = j + 1;
        res.push(
          `${line}${" ".repeat(Math.max(3 - String(line).length, 0))}|  ${lines[j]}`
        );
        const lineLength = lines[j].length;
        const newLineSeqLength = newlineSequences[j] && newlineSequences[j].length || 0;
        if (j === i) {
          const pad = start - (count - (lineLength + newLineSeqLength));
          const length = Math.max(
            1,
            end > count ? lineLength - pad : end - start
          );
          res.push(`   |  ` + " ".repeat(pad) + "^".repeat(length));
        } else if (j > i) {
          if (end > count) {
            const length = Math.max(Math.min(end - count, lineLength), 1);
            res.push(`   |  ` + "^".repeat(length));
          }
          count += lineLength + newLineSeqLength;
        }
      }
      break;
    }
  }
  return res.join("\n");
}

function normalizeStyle(value) {
  if (isArray(value)) {
    const res = {};
    for (let i = 0; i < value.length; i++) {
      const item = value[i];
      const normalized = isString(item) ? parseStringStyle(item) : normalizeStyle(item);
      if (normalized) {
        for (const key in normalized) {
          res[key] = normalized[key];
        }
      }
    }
    return res;
  } else if (isString(value) || isObject(value)) {
    return value;
  }
}
const listDelimiterRE = /;(?![^(]*\))/g;
const propertyDelimiterRE = /:([^]+)/;
const styleCommentRE = /\/\*[^]*?\*\//g;
function parseStringStyle(cssText) {
  const ret = {};
  cssText.replace(styleCommentRE, "").split(listDelimiterRE).forEach((item) => {
    if (item) {
      const tmp = item.split(propertyDelimiterRE);
      tmp.length > 1 && (ret[tmp[0].trim()] = tmp[1].trim());
    }
  });
  return ret;
}
function stringifyStyle(styles) {
  if (!styles) return "";
  if (isString(styles)) return styles;
  let ret = "";
  for (const key in styles) {
    const value = styles[key];
    if (isString(value) || typeof value === "number") {
      const normalizedKey = key.startsWith(`--`) ? key : hyphenate(key);
      ret += `${normalizedKey}:${value};`;
    }
  }
  return ret;
}
function normalizeClass(value) {
  let res = "";
  if (isString(value)) {
    res = value;
  } else if (isArray(value)) {
    for (let i = 0; i < value.length; i++) {
      const normalized = normalizeClass(value[i]);
      if (normalized) {
        res += normalized + " ";
      }
    }
  } else if (isObject(value)) {
    for (const name in value) {
      if (value[name]) {
        res += name + " ";
      }
    }
  }
  return res.trim();
}
function normalizeProps(props) {
  if (!props) return null;
  let { class: klass, style } = props;
  if (klass && !isString(klass)) {
    props.class = normalizeClass(klass);
  }
  if (style) {
    props.style = normalizeStyle(style);
  }
  return props;
}

const HTML_TAGS = "html,body,base,head,link,meta,style,title,address,article,aside,footer,header,hgroup,h1,h2,h3,h4,h5,h6,nav,section,div,dd,dl,dt,figcaption,figure,picture,hr,img,li,main,ol,p,pre,ul,a,b,abbr,bdi,bdo,br,cite,code,data,dfn,em,i,kbd,mark,q,rp,rt,ruby,s,samp,small,span,strong,sub,sup,time,u,var,wbr,area,audio,map,track,video,embed,object,param,source,canvas,script,noscript,del,ins,caption,col,colgroup,table,thead,tbody,td,th,tr,button,datalist,fieldset,form,input,label,legend,meter,optgroup,option,output,progress,select,textarea,details,dialog,menu,summary,template,blockquote,iframe,tfoot";
const SVG_TAGS = "svg,animate,animateMotion,animateTransform,circle,clipPath,color-profile,defs,desc,discard,ellipse,feBlend,feColorMatrix,feComponentTransfer,feComposite,feConvolveMatrix,feDiffuseLighting,feDisplacementMap,feDistantLight,feDropShadow,feFlood,feFuncA,feFuncB,feFuncG,feFuncR,feGaussianBlur,feImage,feMerge,feMergeNode,feMorphology,feOffset,fePointLight,feSpecularLighting,feSpotLight,feTile,feTurbulence,filter,foreignObject,g,hatch,hatchpath,image,line,linearGradient,marker,mask,mesh,meshgradient,meshpatch,meshrow,metadata,mpath,path,pattern,polygon,polyline,radialGradient,rect,set,solidcolor,stop,switch,symbol,text,textPath,title,tspan,unknown,use,view";
const MATH_TAGS = "annotation,annotation-xml,maction,maligngroup,malignmark,math,menclose,merror,mfenced,mfrac,mfraction,mglyph,mi,mlabeledtr,mlongdiv,mmultiscripts,mn,mo,mover,mpadded,mphantom,mprescripts,mroot,mrow,ms,mscarries,mscarry,msgroup,msline,mspace,msqrt,msrow,mstack,mstyle,msub,msubsup,msup,mtable,mtd,mtext,mtr,munder,munderover,none,semantics";
const VOID_TAGS = "area,base,br,col,embed,hr,img,input,link,meta,param,source,track,wbr";
const isHTMLTag = /* @__PURE__ */ makeMap(HTML_TAGS);
const isSVGTag = /* @__PURE__ */ makeMap(SVG_TAGS);
const isMathMLTag = /* @__PURE__ */ makeMap(MATH_TAGS);
const isVoidTag = /* @__PURE__ */ makeMap(VOID_TAGS);

const specialBooleanAttrs = `itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly`;
const isSpecialBooleanAttr = /* @__PURE__ */ makeMap(specialBooleanAttrs);
const isBooleanAttr = /* @__PURE__ */ makeMap(
  specialBooleanAttrs + `,async,autofocus,autoplay,controls,default,defer,disabled,hidden,inert,loop,open,required,reversed,scoped,seamless,checked,muted,multiple,selected`
);
function includeBooleanAttr(value) {
  return !!value || value === "";
}
const unsafeAttrCharRE = /[>/="'\u0009\u000a\u000c\u0020]/;
const attrValidationCache = {};
function isSSRSafeAttrName(name) {
  if (attrValidationCache.hasOwnProperty(name)) {
    return attrValidationCache[name];
  }
  const isUnsafe = unsafeAttrCharRE.test(name);
  if (isUnsafe) {
    console.error(`unsafe attribute name: ${name}`);
  }
  return attrValidationCache[name] = !isUnsafe;
}
const propsToAttrMap = {
  acceptCharset: "accept-charset",
  className: "class",
  htmlFor: "for",
  httpEquiv: "http-equiv"
};
const isKnownHtmlAttr = /* @__PURE__ */ makeMap(
  `accept,accept-charset,accesskey,action,align,allow,alt,async,autocapitalize,autocomplete,autofocus,autoplay,background,bgcolor,border,buffered,capture,challenge,charset,checked,cite,class,code,codebase,color,cols,colspan,content,contenteditable,contextmenu,controls,coords,crossorigin,csp,data,datetime,decoding,default,defer,dir,dirname,disabled,download,draggable,dropzone,enctype,enterkeyhint,for,form,formaction,formenctype,formmethod,formnovalidate,formtarget,headers,height,hidden,high,href,hreflang,http-equiv,icon,id,importance,inert,integrity,ismap,itemprop,keytype,kind,label,lang,language,loading,list,loop,low,manifest,max,maxlength,minlength,media,min,multiple,muted,name,novalidate,open,optimum,pattern,ping,placeholder,poster,preload,radiogroup,readonly,referrerpolicy,rel,required,reversed,rows,rowspan,sandbox,scope,scoped,selected,shape,size,sizes,slot,span,spellcheck,src,srcdoc,srclang,srcset,start,step,style,summary,tabindex,target,title,translate,type,usemap,value,width,wrap`
);
const isKnownSvgAttr = /* @__PURE__ */ makeMap(
  `xmlns,accent-height,accumulate,additive,alignment-baseline,alphabetic,amplitude,arabic-form,ascent,attributeName,attributeType,azimuth,baseFrequency,baseline-shift,baseProfile,bbox,begin,bias,by,calcMode,cap-height,class,clip,clipPathUnits,clip-path,clip-rule,color,color-interpolation,color-interpolation-filters,color-profile,color-rendering,contentScriptType,contentStyleType,crossorigin,cursor,cx,cy,d,decelerate,descent,diffuseConstant,direction,display,divisor,dominant-baseline,dur,dx,dy,edgeMode,elevation,enable-background,end,exponent,fill,fill-opacity,fill-rule,filter,filterRes,filterUnits,flood-color,flood-opacity,font-family,font-size,font-size-adjust,font-stretch,font-style,font-variant,font-weight,format,from,fr,fx,fy,g1,g2,glyph-name,glyph-orientation-horizontal,glyph-orientation-vertical,glyphRef,gradientTransform,gradientUnits,hanging,height,href,hreflang,horiz-adv-x,horiz-origin-x,id,ideographic,image-rendering,in,in2,intercept,k,k1,k2,k3,k4,kernelMatrix,kernelUnitLength,kerning,keyPoints,keySplines,keyTimes,lang,lengthAdjust,letter-spacing,lighting-color,limitingConeAngle,local,marker-end,marker-mid,marker-start,markerHeight,markerUnits,markerWidth,mask,maskContentUnits,maskUnits,mathematical,max,media,method,min,mode,name,numOctaves,offset,opacity,operator,order,orient,orientation,origin,overflow,overline-position,overline-thickness,panose-1,paint-order,path,pathLength,patternContentUnits,patternTransform,patternUnits,ping,pointer-events,points,pointsAtX,pointsAtY,pointsAtZ,preserveAlpha,preserveAspectRatio,primitiveUnits,r,radius,referrerPolicy,refX,refY,rel,rendering-intent,repeatCount,repeatDur,requiredExtensions,requiredFeatures,restart,result,rotate,rx,ry,scale,seed,shape-rendering,slope,spacing,specularConstant,specularExponent,speed,spreadMethod,startOffset,stdDeviation,stemh,stemv,stitchTiles,stop-color,stop-opacity,strikethrough-position,strikethrough-thickness,string,stroke,stroke-dasharray,stroke-dashoffset,stroke-linecap,stroke-linejoin,stroke-miterlimit,stroke-opacity,stroke-width,style,surfaceScale,systemLanguage,tabindex,tableValues,target,targetX,targetY,text-anchor,text-decoration,text-rendering,textLength,to,transform,transform-origin,type,u1,u2,underline-position,underline-thickness,unicode,unicode-bidi,unicode-range,units-per-em,v-alphabetic,v-hanging,v-ideographic,v-mathematical,values,vector-effect,version,vert-adv-y,vert-origin-x,vert-origin-y,viewBox,viewTarget,visibility,width,widths,word-spacing,writing-mode,x,x-height,x1,x2,xChannelSelector,xlink:actuate,xlink:arcrole,xlink:href,xlink:role,xlink:show,xlink:title,xlink:type,xmlns:xlink,xml:base,xml:lang,xml:space,y,y1,y2,yChannelSelector,z,zoomAndPan`
);
const isKnownMathMLAttr = /* @__PURE__ */ makeMap(
  `accent,accentunder,actiontype,align,alignmentscope,altimg,altimg-height,altimg-valign,altimg-width,alttext,bevelled,close,columnsalign,columnlines,columnspan,denomalign,depth,dir,display,displaystyle,encoding,equalcolumns,equalrows,fence,fontstyle,fontweight,form,frame,framespacing,groupalign,height,href,id,indentalign,indentalignfirst,indentalignlast,indentshift,indentshiftfirst,indentshiftlast,indextype,justify,largetop,largeop,lquote,lspace,mathbackground,mathcolor,mathsize,mathvariant,maxsize,minlabelspacing,mode,other,overflow,position,rowalign,rowlines,rowspan,rquote,rspace,scriptlevel,scriptminsize,scriptsizemultiplier,selection,separator,separators,shift,side,src,stackalign,stretchy,subscriptshift,superscriptshift,symmetric,voffset,width,widths,xlink:href,xlink:show,xlink:type,xmlns`
);
function isRenderableAttrValue(value) {
  if (value == null) {
    return false;
  }
  const type = typeof value;
  return type === "string" || type === "number" || type === "boolean";
}

const escapeRE = /["'&<>]/;
function escapeHtml(string) {
  const str = "" + string;
  const match = escapeRE.exec(str);
  if (!match) {
    return str;
  }
  let html = "";
  let escaped;
  let index;
  let lastIndex = 0;
  for (index = match.index; index < str.length; index++) {
    switch (str.charCodeAt(index)) {
      case 34:
        escaped = "&quot;";
        break;
      case 38:
        escaped = "&amp;";
        break;
      case 39:
        escaped = "&#39;";
        break;
      case 60:
        escaped = "&lt;";
        break;
      case 62:
        escaped = "&gt;";
        break;
      default:
        continue;
    }
    if (lastIndex !== index) {
      html += str.slice(lastIndex, index);
    }
    lastIndex = index + 1;
    html += escaped;
  }
  return lastIndex !== index ? html + str.slice(lastIndex, index) : html;
}
const commentStripRE = /^-?>|<!--|-->|--!>|<!-$/g;
function escapeHtmlComment(src) {
  return src.replace(commentStripRE, "");
}
const cssVarNameEscapeSymbolsRE = /[ !"#$%&'()*+,./:;<=>?@[\\\]^`{|}~]/g;
function getEscapedCssVarName(key, doubleEscape) {
  return key.replace(
    cssVarNameEscapeSymbolsRE,
    (s) => doubleEscape ? s === '"' ? '\\\\\\"' : `\\\\${s}` : `\\${s}`
  );
}

function looseCompareArrays(a, b) {
  if (a.length !== b.length) return false;
  let equal = true;
  for (let i = 0; equal && i < a.length; i++) {
    equal = looseEqual(a[i], b[i]);
  }
  return equal;
}
function looseEqual(a, b) {
  if (a === b) return true;
  let aValidType = isDate(a);
  let bValidType = isDate(b);
  if (aValidType || bValidType) {
    return aValidType && bValidType ? a.getTime() === b.getTime() : false;
  }
  aValidType = isSymbol(a);
  bValidType = isSymbol(b);
  if (aValidType || bValidType) {
    return a === b;
  }
  aValidType = isArray(a);
  bValidType = isArray(b);
  if (aValidType || bValidType) {
    return aValidType && bValidType ? looseCompareArrays(a, b) : false;
  }
  aValidType = isObject(a);
  bValidType = isObject(b);
  if (aValidType || bValidType) {
    if (!aValidType || !bValidType) {
      return false;
    }
    const aKeysCount = Object.keys(a).length;
    const bKeysCount = Object.keys(b).length;
    if (aKeysCount !== bKeysCount) {
      return false;
    }
    for (const key in a) {
      const aHasKey = a.hasOwnProperty(key);
      const bHasKey = b.hasOwnProperty(key);
      if (aHasKey && !bHasKey || !aHasKey && bHasKey || !looseEqual(a[key], b[key])) {
        return false;
      }
    }
  }
  return String(a) === String(b);
}
function looseIndexOf(arr, val) {
  return arr.findIndex((item) => looseEqual(item, val));
}

const isRef = (val) => {
  return !!(val && val["__v_isRef"] === true);
};
const toDisplayString = (val) => {
  return isString(val) ? val : val == null ? "" : isArray(val) || isObject(val) && (val.toString === objectToString || !isFunction(val.toString)) ? isRef(val) ? toDisplayString(val.value) : JSON.stringify(val, replacer, 2) : String(val);
};
const replacer = (_key, val) => {
  if (isRef(val)) {
    return replacer(_key, val.value);
  } else if (isMap(val)) {
    return {
      [`Map(${val.size})`]: [...val.entries()].reduce(
        (entries, [key, val2], i) => {
          entries[stringifySymbol(key, i) + " =>"] = val2;
          return entries;
        },
        {}
      )
    };
  } else if (isSet(val)) {
    return {
      [`Set(${val.size})`]: [...val.values()].map((v) => stringifySymbol(v))
    };
  } else if (isSymbol(val)) {
    return stringifySymbol(val);
  } else if (isObject(val) && !isArray(val) && !isPlainObject(val)) {
    return String(val);
  }
  return val;
};
const stringifySymbol = (v, i = "") => {
  var _a;
  return (
    // Symbol.description in es2019+ so we need to cast here to pass
    // the lib: es2016 check
    isSymbol(v) ? `Symbol(${(_a = v.description) != null ? _a : i})` : v
  );
};




/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/Panel.vue?vue&type=style&index=0&id=35e53414&lang=css":
/*!****************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/Panel.vue?vue&type=style&index=0&id=35e53414&lang=css ***!
  \****************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
/* 图标字体定义 */
.icon-hierarchy::before { content: '⬢';
}
.icon-performance::before { content: '⚡';
}
.icon-nano::before { content: '◉';
}
.icon-debug::before { content: '⚙';
}
.icon-refresh::before { content: '⟳';
}
.icon-expand::before { content: '⬇';
}
.icon-collapse::before { content: '➤';
}
.icon-flag::before { content: '🚩';
}
.icon-select::before { content: '◯';
}
.icon-development::before { content: '⟲';
}
.icon-scene::before { content: '⬢';
}
.icon-camera::before { content: '◉';
}
.icon-folder::before { content: '▩';
}
.icon-sprite::before { content: '◈';
}
.icon-mesh::before { content: '⬟';
}
.icon-node::before { content: '⬡';
}
.icon-engine::before { content: '⚙';
}
.icon-light::before { content: '☀';
}
.icon-dark::before { content: '🌙';
}
.icon-loading::before { content: '⟲';
}
.icon-play::before { content: '▷';
}
.icon-pause::before { content: '❚❚';
}
.icon-ai-agent::before { content: '🤖';
}
.icon-feedback::before { content: '💬';
}

/* 从原文件中提取的核心样式 */

/* CSS 变量定义 */
.layatree-panel {
  /* 深色主题变量 */
  --bg-primary: linear-gradient(135deg, #0a0e17 0%, #0f1419 40%, #1a1f29 100%);
  --bg-secondary: linear-gradient(135deg, rgba(15, 20, 25, 0.95) 0%, rgba(26, 31, 41, 0.95) 100%);
  --bg-panel: linear-gradient(135deg, rgba(15, 20, 25, 0.9) 0%, rgba(26, 31, 41, 0.8) 100%);
  --bg-card: linear-gradient(135deg, rgba(15, 20, 25, 0.7) 0%, rgba(26, 31, 41, 0.5) 100%);
  --text-primary: #f0f2f5;
  --text-secondary: #b8c5d1;
  --text-accent: #4dd4ff;
  --accent-primary: #0aa2ff;
  --accent-secondary: #40e0d0;
  --border-primary: rgba(0, 162, 255, 0.2);
  --border-accent: rgba(0, 162, 255, 0.4);
  --shadow-primary: rgba(0, 0, 0, 0.3);
  --shadow-accent: rgba(0, 162, 255, 0.3);
  --text-glow: 0 0 8px rgba(0, 162, 255, 0.5);
  --text-glow-accent: 0 0 4px rgba(0, 162, 255, 0.3);
  --text-glow-secondary: 0 0 6px rgba(0, 162, 255, 0.3);
}

/* 浅色主题变量 */
.layatree-panel.light-mode {
  --bg-primary: #f8fafc;
  --bg-secondary: rgba(248, 250, 252, 0.95);
  --bg-panel: rgba(255, 255, 255, 0.9);
  --bg-card: rgba(255, 255, 255, 0.8);
  --text-primary: #1e293b;
  --text-secondary: #475569;
  --text-accent: #0369a1;
  --accent-primary: #0ea5e9;
  --accent-secondary: #14b8a6;
  --border-primary: rgba(0, 0, 0, 0.08);
  --border-accent: rgba(0, 0, 0, 0.12);
  --shadow-primary: rgba(0, 0, 0, 0.05);
  --shadow-accent: rgba(0, 0, 0, 0.1);
  --text-glow: 0 1px 2px rgba(0, 0, 0, 0.05);
  --text-glow-accent: 0 1px 1px rgba(0, 0, 0, 0.08);
  --text-glow-secondary: 0 1px 2px rgba(0, 0, 0, 0.06);
}

/* 主容器 */
.layatree-panel {
  height: 100vh;
  display: flex;
  flex-direction: column;
  background: var(--bg-primary);
  font-family: 'SF Pro Display', -apple-system, BlinkMacSystemFont, 'Inter', 'Segoe UI', Helvetica, Arial, sans-serif;
  color: var(--text-primary);
  font-weight: 400;
  letter-spacing: -0.003em;
  position: relative;
  overflow: hidden;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}

/* 信息栏样式 */
.info-bar {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0 12px;
  background: var(--bg-secondary);
  backdrop-filter: blur(16px);
  border-bottom: 1px solid var(--border-primary);
  min-height: 32px;
}
.left-info {
  display: flex;
  align-items: center;
  gap: 12px;
}
.right-info {
  display: flex;
  align-items: center;
}
.server-info {
  display: flex;
  align-items: center;
  gap: 6px;
  font-size: 10px;
  color: var(--text-secondary);
  background: var(--bg-card);
  padding: 3px 8px;
  border-radius: 10px;
  border: 1px solid var(--border-primary);
  backdrop-filter: blur(8px);
  text-shadow: var(--text-glow-accent);
  font-weight: 500;
  white-space: nowrap;
  opacity: 1;
  transform: translateY(0);
  transition: all 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  box-shadow: 
    0 2px 8px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
}
.server-info.fade-out {
  opacity: 0;
  transform: translateY(-10px);
}
.server-info-text {
  font-size: 10px;
  line-height: 1.2;
}
.close-btn {
  background: none;
  border: none;
  color: var(--text-secondary);
  font-size: 12px;
  cursor: pointer;
  width: 16px;
  height: 16px;
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 50%;
  transition: all 0.2s ease;
  opacity: 0.7;
  line-height: 1;
  font-weight: bold;
}
.close-btn:hover {
  background: var(--bg-secondary);
  color: var(--text-primary);
  opacity: 1;
  transform: scale(1.1);
}

/* 顶部导航栏 */
.header {
  background: var(--bg-secondary);
  backdrop-filter: blur(24px) saturate(180%);
  border-bottom: 1px solid var(--border-primary);
  padding: 0 12px;
  z-index: 100;
  position: relative;
  box-shadow: 
    0 1px 0 var(--border-primary) inset,
    0 4px 24px var(--shadow-primary),
    0 0 0 1px rgba(255, 255, 255, 0.05);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.header-content {
  display: flex;
  align-items: center;
  justify-content: space-between;
  height: 40px;
  max-width: 2440px;
  margin: 0;
  position: relative;
  z-index: 1;
  gap: 16px;
}

/* 控制按钮组 */
.control-buttons {
  display: flex;
  align-items: center;
  gap: 12px;
}

/* 智能体和主题切换按钮样式 */
.ai-agent-switcher, .theme-switcher {
  display: flex;
  align-items: center;
}
.ai-agent-btn, .theme-toggle-btn {
  display: flex;
  align-items: center;
  gap: 6px;
  padding: 6px 12px;
  border: 1px solid var(--border-primary);
  background: var(--bg-card);
  backdrop-filter: blur(16px);
  border-radius: 20px;
  cursor: pointer;
  transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
  font-size: 11px;
  font-weight: 500;
  color: var(--text-secondary);
  position: relative;
  overflow: hidden;
  min-width: 60px;
  box-shadow: 0 2px 8px var(--shadow-primary);
}
.ai-agent-btn {
  min-width: 80px;
}
.ai-agent-btn:hover, .theme-toggle-btn:hover:not(:disabled) {
  border-color: var(--border-accent);
  background: var(--bg-panel);
  color: var(--text-primary);
  box-shadow: 
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--border-primary) inset;
  transform: translateY(-1px);
}
.ai-icon-container, .theme-icon-container {
  position: relative;
  width: 16px;
  height: 16px;
  border-radius: 50%;
  background: var(--bg-secondary);
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s ease;
  border: 1px solid var(--border-primary);
}
.ai-icon-container.connected, .theme-icon-container {
  background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));
  border-color: var(--accent-primary);
  box-shadow: 0 0 8px var(--shadow-accent);
}
.ai-icon-container .icon-ai-agent, .theme-icon {
  font-size: 10px;
  color: #ffffff;
  transition: all 0.3s ease;
  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
}
.connection-status {
  position: absolute;
  top: 2px;
  right: 2px;
  width: 6px;
  height: 6px;
  border-radius: 50%;
  background: #9ca3af;
  transition: all 0.3s ease;
  opacity: 0.8;
}
.connection-status.active {
  background: #40e0d0;
  box-shadow: 0 0 8px rgba(64, 224, 208, 0.5);
}

/* 主内容区域 */
.main-content {
  flex: 1;
  overflow: hidden;
  padding: 8px 12px 12px;
  position: relative;
  z-index: 1;
  background: var(--bg-primary);
}
.content-panel {
  height: 100%;
  background: var(--bg-panel);
  backdrop-filter: blur(24px) saturate(180%);
  border-radius: 16px;
  border: 1px solid var(--border-primary);
  overflow: hidden;
  box-shadow: 
    0 16px 64px var(--shadow-primary),
    0 0 0 1px rgba(255, 255, 255, 0.05) inset,
    0 2px 0 var(--border-primary) inset;
  position: relative;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}

/* Hierarchy 面板 */
.hierarchy-panel {
  display: flex;
  flex-direction: column;
}
.hierarchy-content {
  display: flex;
  height: 100%;
}
.tree-panel, .inspector-panel {
  display: flex;
  flex-direction: column;
  background: var(--bg-card);
  backdrop-filter: blur(16px);
  position: relative;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.tree-panel {
  flex: 1;
  min-width: 320px;
  max-width: 50%;
  border-right: 1px solid var(--border-primary);
  position: relative;
}
.inspector-panel {
  flex: 1;
  min-width: 320px;
}
.panel-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 12px 16px;
  border-bottom: 1px solid var(--border-primary);
  background: var(--bg-secondary);
  backdrop-filter: blur(16px);
  position: relative;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.panel-header h3 {
  font-size: 15px;
  font-weight: 600;
  color: var(--text-primary);
  margin: 0;
  letter-spacing: -0.022em;
  text-shadow: var(--text-glow);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.panel-actions {
  display: flex;
  gap: 8px;
}
.action-btn {
  width: 32px;
  height: 32px;
  border: 1px solid var(--border-accent);
  background: var(--bg-card);
  border-radius: 8px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  font-size: 14px;
  color: var(--text-secondary);
  box-shadow: 
    0 4px 16px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  position: relative;
  overflow: hidden;
}
.action-btn:hover {
  background: var(--bg-panel);
  color: var(--text-primary);
  border-color: var(--border-accent);
  box-shadow: 
    0 8px 32px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset,
    0 0 16px var(--shadow-accent) inset;
  transform: translateY(-1px);
  text-shadow: var(--text-glow-accent);
}
.action-btn.refreshing {
  pointer-events: none;
  opacity: 0.7;
}
.action-btn.refreshing i {
  animation: refreshSpin 1s linear infinite;
}
.action-btn:disabled {
  opacity: 0.6;
  cursor: not-allowed;
  pointer-events: none;
}
.action-btn.active {
  background: var(--accent-primary);
  color: #ffffff;
  border-color: var(--accent-primary);
  box-shadow: 
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--accent-primary) inset,
    0 0 12px var(--shadow-accent) inset;
  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
}
.action-btn.active:hover {
  background: var(--accent-secondary);
  border-color: var(--accent-secondary);
}
@keyframes refreshSpin {
from { transform: rotate(0deg);
}
to { transform: rotate(360deg);
}
}
.tree-container {
  flex: 1;
  overflow: auto;
  padding: 8px;
  background: var(--bg-card);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}

/* 属性检查器 */
.inspector-content {
  flex: 1;
  overflow: auto;
  padding: 16px;
  background: var(--bg-card);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.node-info {
  background: var(--bg-panel);
  backdrop-filter: blur(16px);
  border-radius: 12px;
  padding: 12px;
  margin-bottom: 16px;
  border: 1px solid var(--border-primary);
  box-shadow: 
    0 8px 32px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset,
    0 2px 0 var(--border-primary) inset;
  position: relative;
  overflow: hidden;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.node-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  color: var(--text-primary);
  margin-bottom: 6px;
  letter-spacing: -0.024em;
  text-shadow: var(--text-glow);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.node-type {
  font-size: 13px;
  color: var(--accent-secondary);
  background: var(--bg-card);
  backdrop-filter: blur(8px);
  display: inline-block;
  padding: 6px 16px;
  border-radius: 20px;
  font-weight: 500;
  letter-spacing: -0.008em;
  border: 1px solid var(--border-accent);
  box-shadow: 
    0 4px 16px var(--shadow-accent),
    0 0 8px var(--shadow-accent) inset;
  text-shadow: var(--text-glow-accent);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.properties-section, .transform-section {
  margin-bottom: 20px;
}
.section-header {
  margin-bottom: 12px;
  padding-bottom: 8px;
  border-bottom: 1px solid var(--border-primary);
  position: relative;
}
.section-header h4 {
  font-size: 15px;
  font-weight: 600;
  color: var(--text-primary);
  margin: 0;
  letter-spacing: -0.016em;
  text-shadow: var(--text-glow-secondary);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.property-group {
  display: flex;
  flex-direction: column;
  gap: 12px;
}
.property-item {
  display: flex;
  align-items: center;
  gap: 12px;
  padding: 2px 0;
}
.property-label {
  min-width: 80px;
  font-size: 13px;
  color: var(--text-secondary);
  font-weight: 500;
  letter-spacing: -0.006em;
  text-shadow: var(--text-glow-accent);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.property-input {
  flex: 1;
  padding: 8px 12px;
  border: 1px solid var(--border-primary);
  border-radius: 8px;
  font-size: 13px;
  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  background: var(--bg-card);
  backdrop-filter: blur(8px);
  color: var(--text-primary);
  font-family: inherit;
  box-shadow: 
    0 2px 8px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
}
.property-input:focus {
  outline: none;
  border-color: var(--border-accent);
  box-shadow: 
    0 0 0 4px var(--shadow-accent),
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset,
    0 0 16px var(--shadow-accent) inset;
  background: var(--bg-panel);
  transform: translateY(-1px);
  text-shadow: var(--text-glow-accent);
}
.transform-grid {
  display: flex;
  flex-direction: column;
  gap: 12px;
}
.transform-row {
  display: flex;
  align-items: center;
  gap: 12px;
  padding: 6px 12px;
  background: var(--bg-card);
  backdrop-filter: blur(8px);
  border-radius: 10px;
  border: 1px solid var(--border-primary);
  box-shadow: 
    0 4px 16px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  transition: all 0.3s ease;
}
.transform-row label {
  min-width: 60px;
  font-size: 13px;
  color: var(--text-secondary);
  font-weight: 500;
  letter-spacing: -0.006em;
  text-shadow: var(--text-glow-accent);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.vector-input {
  display: flex;
  gap: 8px;
  flex: 1;
}
.vector-input input {
  flex: 1;
  padding: 8px 12px;
  border: 1px solid var(--border-primary);
  border-radius: 8px;
  font-size: 13px;
  text-align: center;
  background: var(--bg-card);
  backdrop-filter: blur(8px);
  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  color: var(--text-primary);
  font-family: 'SF Mono', Monaco, 'Cascadia Code', 'Roboto Mono', Consolas, 'Courier New', monospace;
  font-variant-numeric: tabular-nums;
  box-shadow: 
    0 2px 8px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
}
.vector-input input:focus {
  outline: none;
  border-color: var(--border-accent);
  box-shadow: 
    0 0 0 3px var(--shadow-accent),
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset,
    0 0 12px var(--shadow-accent) inset;
  background: var(--bg-panel);
  transform: translateY(-1px);
  text-shadow: var(--text-glow-accent);
}
.no-selection {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  height: 240px;
  color: var(--text-secondary);
  text-align: center;
  background: var(--bg-card);
  backdrop-filter: blur(16px);
  border-radius: 16px;
  border: 1px solid var(--border-primary);
  box-shadow: 
    0 8px 32px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.no-selection i {
  font-size: 48px;
  margin-bottom: 16px;
  opacity: 0.8;
  color: var(--text-accent);
  filter: drop-shadow(0 0 8px var(--shadow-accent));
  animation: pulse 3s ease-in-out infinite;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.no-selection p {
  font-size: 15px;
  letter-spacing: -0.016em;
  text-shadow: var(--text-glow-accent);
  font-weight: 500;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}

/* 待开发页面 */
.coming-soon {
  display: flex;
  align-items: center;
  justify-content: center;
  background: radial-gradient(circle at center, rgba(14, 165, 233, 0.08) 0%, transparent 70%);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.coming-soon-content {
  text-align: center;
  padding: 48px;
  max-width: 480px;
  background: var(--bg-panel);
  backdrop-filter: blur(24px);
  border-radius: 24px;
  border: 1px solid var(--border-accent);
  box-shadow: 
    0 16px 64px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset,
    0 4px 0 var(--border-primary) inset;
  position: relative;
  overflow: hidden;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.coming-soon-content i {
  font-size: 64px;
  margin-bottom: 24px;
  opacity: 0.9;
  color: var(--text-accent);
  filter: drop-shadow(0 0 16px var(--shadow-accent));
  animation: pulse 2s ease-in-out infinite;
  text-shadow: var(--text-glow);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.coming-soon-content h2 {
  font-size: 28px;
  font-weight: 600;
  color: var(--text-primary);
  margin-bottom: 16px;
  letter-spacing: -0.032em;
  text-shadow: var(--text-glow);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.coming-soon-content p {
  color: var(--text-secondary);
  margin-bottom: 32px;
  font-size: 17px;
  letter-spacing: -0.022em;
  line-height: 1.47;
  text-shadow: var(--text-glow-secondary);
  font-weight: 500;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.progress-indicator {
  width: 100%;
  height: 6px;
  background: var(--bg-card);
  border-radius: 3px;
  overflow: hidden;
  box-shadow: 
    0 2px 8px var(--shadow-primary) inset,
    0 0 0 1px var(--border-primary);
  border: 1px solid var(--border-primary);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.progress-bar {
  height: 100%;
  background: linear-gradient(90deg, var(--accent-primary), var(--accent-secondary), #8a2be2);
  border-radius: 3px;
  animation: aiProgress 2.5s ease-in-out infinite;
  box-shadow: 
    0 0 16px var(--shadow-accent),
    0 0 8px var(--shadow-accent) inset;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
@keyframes aiProgress {
0% {
    width: 0%;
    margin-left: 0%;
}
50% {
    width: 70%;
    margin-left: 30%;
}
100% {
    width: 0%;
    margin-left: 100%;
}
}

/* 引擎帮助信息样式 */
.engine-help {
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  width: 100%;
  max-width: 400px;
  padding: 0 20px;
}
.help-content {
  background: var(--bg-panel);
  backdrop-filter: blur(24px);
  border-radius: 16px;
  padding: 32px;
  border: 1px solid var(--border-primary);
  box-shadow: 
    0 16px 64px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  text-align: center;
}
.help-content i {
  font-size: 64px;
  margin-bottom: 24px;
  opacity: 0.9;
  color: var(--text-accent);
  filter: drop-shadow(0 0 16px var(--shadow-accent));
  animation: pulse 2s ease-in-out infinite;
}
.help-title {
  font-size: 18px;
  font-weight: 600;
  color: var(--text-primary);
  margin-bottom: 20px;
  text-shadow: var(--text-glow);
}
.help-details {
  text-align: left;
}
.help-details .help-text {
  font-size: 13px;
  color: var(--text-secondary);
  margin-bottom: 12px;
  line-height: 1.5;
  text-shadow: var(--text-glow-secondary);
  font-weight: 500;
}
.help-details .help-list {
  list-style: none;
  padding: 0;
  margin: 16px 0;
  background: var(--bg-card);
  border-radius: 8px;
  padding: 12px;
  border: 1px solid var(--border-primary);
  box-shadow: 0 2px 8px var(--shadow-primary);
}
.help-details .help-list li {
  font-size: 12px;
  color: var(--text-secondary);
  margin-bottom: 8px;
  padding: 4px 0;
  border-bottom: 1px solid var(--border-primary);
  text-shadow: var(--text-glow-secondary);
  font-weight: 500;
}
.help-details .help-list li:last-child {
  border-bottom: none;
  margin-bottom: 0;
}
@keyframes pulse {
0%, 100% { 
    opacity: 0.8; 
    transform: scale(1);
}
50% { 
    opacity: 1; 
    transform: scale(1.08);
}
}

/* 主题转换特效 - 平滑渐变 */
.theme-transitioning {
  position: relative;
  overflow: hidden;
}
.theme-transition-overlay {
  position: fixed;
  top: 0;
  left: 0;
  width: 100vw;
  height: 100vh;
  z-index: 9999;
  pointer-events: none;
  opacity: 0;
  transition: opacity 0.3s cubic-bezier(0.4, 0, 0.2, 1);
  backdrop-filter: blur(8px);
}
.theme-transition-overlay.fade-to-light {
  background: linear-gradient(
    135deg,
    rgba(10, 14, 23, 0.95) 0%,
    rgba(26, 31, 41, 0.9) 20%,
    rgba(64, 74, 88, 0.8) 40%,
    rgba(148, 163, 184, 0.7) 60%,
    rgba(203, 213, 224, 0.6) 80%,
    rgba(248, 250, 252, 0.5) 100%
  );
}
.theme-transition-overlay.fade-to-dark {
  background: linear-gradient(
    135deg,
    rgba(248, 250, 252, 0.95) 0%,
    rgba(203, 213, 224, 0.9) 20%,
    rgba(148, 163, 184, 0.8) 40%,
    rgba(64, 74, 88, 0.7) 60%,
    rgba(26, 31, 41, 0.6) 80%,
    rgba(10, 14, 23, 0.5) 100%
  );
}
.theme-transition-overlay.active {
  opacity: 1;
}

/* 确认弹窗样式 */
.modal-overlay {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: rgba(0, 0, 0, 0.6);
  backdrop-filter: blur(8px);
  display: flex;
  align-items: center;
  justify-content: center;
  z-index: 10000;
  animation: fadeIn 0.3s ease;
}
.modal-container {
  background: var(--bg-panel);
  backdrop-filter: blur(24px);
  border-radius: 16px;
  border: 1px solid var(--border-primary);
  box-shadow: 
    0 16px 64px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  max-width: 480px;
  width: 90%;
  max-height: 80vh;
  overflow: hidden;
  animation: slideIn 0.3s ease;
}
.modal-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 20px 24px 16px;
  border-bottom: 1px solid var(--border-primary);
  background: var(--bg-secondary);
}
.modal-header h3 {
  margin: 0;
  font-size: 18px;
  font-weight: 600;
  color: var(--text-primary);
  text-shadow: var(--text-glow);
}
.modal-close-btn {
  background: none;
  border: none;
  color: var(--text-secondary);
  font-size: 20px;
  cursor: pointer;
  width: 32px;
  height: 32px;
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 50%;
  transition: all 0.2s ease;
}
.modal-close-btn:hover {
  background: var(--bg-card);
  color: var(--text-primary);
  transform: scale(1.1);
}
.modal-content {
  padding: 24px;
  text-align: center;
}
.warning-icon {
  font-size: 48px;
  margin-bottom: 16px;
  animation: pulse 2s ease-in-out infinite;
}
.warning-text {
  font-size: 16px;
  color: var(--text-primary);
  margin-bottom: 12px;
  line-height: 1.5;
  text-shadow: var(--text-glow);
}
.confirm-text {
  font-size: 14px;
  color: var(--text-secondary);
  margin-bottom: 0;
  font-weight: 500;
}
.modal-footer {
  display: flex;
  gap: 12px;
  padding: 16px 24px 24px;
  justify-content: center;
}
.cancel-btn, .confirm-btn {
  padding: 10px 20px;
  border-radius: 8px;
  font-size: 14px;
  font-weight: 500;
  cursor: pointer;
  transition: all 0.3s ease;
  border: 1px solid var(--border-primary);
  min-width: 80px;
}
.cancel-btn {
  background: var(--bg-card);
  color: var(--text-secondary);
}
.cancel-btn:hover {
  background: var(--bg-panel);
  color: var(--text-primary);
  border-color: var(--border-accent);
}
.confirm-btn {
  background: linear-gradient(135deg, #ff6b6b, #ee5a52);
  color: #ffffff;
  border-color: #ff6b6b;
  box-shadow: 0 4px 16px rgba(255, 107, 107, 0.3);
}
.confirm-btn:hover {
  background: linear-gradient(135deg, #ff5252, #e53935);
  border-color: #ff5252;
  box-shadow: 0 6px 20px rgba(255, 107, 107, 0.4);
  transform: translateY(-1px);
}
@keyframes fadeIn {
from { opacity: 0;
}
to { opacity: 1;
}
}
@keyframes slideIn {
from {
    opacity: 0;
    transform: translateY(-20px) scale(0.95);
}
to {
    opacity: 1;
    transform: translateY(0) scale(1);
}
}

/* 反馈弹窗样式 */
.feedback-modal {
  max-width: 400px;
  width: 90%;
}
.feedback-content {
  padding: 20px;
  text-align: center;
}
.qrcode-container {
  margin-bottom: 20px;
  display: flex;
  justify-content: center;
  align-items: center;
}
.qrcode-image {
  width: 280px;
  height: 280px;
  border-radius: 12px;
  box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
  border: 2px solid var(--border-primary);
  transition: all 0.3s ease;
}
.qrcode-image:hover {
  transform: scale(1.05);
  box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
}
.feedback-text {
  color: var(--text-primary);
}
.feedback-text h4 {
  margin: 0 0 12px 0;
  font-size: 18px;
  font-weight: 600;
  color: var(--text-primary);
}
.feedback-text p {
  margin: 8px 0;
  font-size: 14px;
  line-height: 1.5;
  color: var(--text-secondary);
}
.feedback-text p:first-of-type {
  font-weight: 500;
  color: var(--text-primary);
}

/* 反馈按钮样式 */
.feedback-btn {
  background: var(--bg-card);
  border: 1px solid var(--border-primary);
  border-radius: 2px;
  padding: 2px 2px;
  color: var(--text-secondary);
  cursor: pointer;
  transition: all 0.2s ease;
  font-size: 14px;
  display: flex;
  align-items: center;
  justify-content: center;
  min-width: 18px;
  height: 18px;
}
.feedback-btn:hover {
  background: var(--bg-panel);
  color: var(--text-primary);
  border-color: var(--border-accent);
  transform: translateY(-1px);
  box-shadow: 0 2px 2px var(--shadow-primary);
}
.feedback-btn .icon-feedback {
  font-size: 16px;
  padding-bottom: 5px;
}
`, "",{"version":3,"sources":["webpack://./src/devtools/Panel.vue"],"names":[],"mappings":";AA6qBA,WAAW;AACX,0BAA0B,YAAY;AAAE;AACxC,4BAA4B,YAAY;AAAE;AAC1C,qBAAqB,YAAY;AAAE;AACnC,sBAAsB,YAAY;AAAE;AACpC,wBAAwB,YAAY;AAAE;AACtC,uBAAuB,YAAY;AAAE;AACrC,yBAAyB,YAAY;AAAE;AACvC,qBAAqB,aAAa;AAAE;AACpC,uBAAuB,YAAY;AAAE;AACrC,4BAA4B,YAAY;AAAE;AAC1C,sBAAsB,YAAY;AAAE;AACpC,uBAAuB,YAAY;AAAE;AACrC,uBAAuB,YAAY;AAAE;AACrC,uBAAuB,YAAY;AAAE;AACrC,qBAAqB,YAAY;AAAE;AACnC,qBAAqB,YAAY;AAAE;AACnC,uBAAuB,YAAY;AAAE;AACrC,sBAAsB,YAAY;AAAE;AACpC,qBAAqB,aAAa;AAAE;AACpC,wBAAwB,YAAY;AAAE;AACtC,qBAAqB,YAAY;AAAE;AACnC,sBAAsB,aAAa;AAAE;AACrC,yBAAyB,aAAa;AAAE;AACxC,yBAAyB,aAAa;AAAE;;AAExC,iBAAiB;;AAEjB,aAAa;AACb;EACE,WAAW;EACX,4EAA4E;EAC5E,+FAA+F;EAC/F,yFAAyF;EACzF,wFAAwF;EACxF,uBAAuB;EACvB,yBAAyB;EACzB,sBAAsB;EACtB,yBAAyB;EACzB,2BAA2B;EAC3B,wCAAwC;EACxC,uCAAuC;EACvC,oCAAoC;EACpC,uCAAuC;EACvC,2CAA2C;EAC3C,kDAAkD;EAClD,qDAAqD;AACvD;;AAEA,WAAW;AACX;EACE,qBAAqB;EACrB,yCAAyC;EACzC,oCAAoC;EACpC,mCAAmC;EACnC,uBAAuB;EACvB,yBAAyB;EACzB,sBAAsB;EACtB,yBAAyB;EACzB,2BAA2B;EAC3B,qCAAqC;EACrC,oCAAoC;EACpC,qCAAqC;EACrC,mCAAmC;EACnC,0CAA0C;EAC1C,iDAAiD;EACjD,oDAAoD;AACtD;;AAEA,QAAQ;AACR;EACE,aAAa;EACb,aAAa;EACb,sBAAsB;EACtB,6BAA6B;EAC7B,mHAAmH;EACnH,0BAA0B;EAC1B,gBAAgB;EAChB,wBAAwB;EACxB,kBAAkB;EAClB,gBAAgB;EAChB,yDAAyD;AAC3D;;AAEA,UAAU;AACV;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,eAAe;EACf,+BAA+B;EAC/B,2BAA2B;EAC3B,8CAA8C;EAC9C,gBAAgB;AAClB;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,SAAS;AACX;AAEA;EACE,aAAa;EACb,mBAAmB;AAErB;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,eAAe;EACf,4BAA4B;EAC5B,0BAA0B;EAC1B,gBAAgB;EAChB,mBAAmB;EACnB,uCAAuC;EACvC,0BAA0B;EAC1B,oCAAoC;EACpC,gBAAgB;EAChB,mBAAmB;EACnB,UAAU;EACV,wBAAwB;EACxB,yDAAyD;EACzD;;yCAEuC;AACzC;AAEA;EACE,UAAU;EACV,4BAA4B;AAC9B;AAEA;EACE,eAAe;EACf,gBAAgB;AAClB;AAEA;EACE,gBAAgB;EAChB,YAAY;EACZ,4BAA4B;EAC5B,eAAe;EACf,eAAe;EACf,WAAW;EACX,YAAY;EACZ,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,kBAAkB;EAClB,yBAAyB;EACzB,YAAY;EACZ,cAAc;EACd,iBAAiB;AACnB;AAEA;EACE,+BAA+B;EAC/B,0BAA0B;EAC1B,UAAU;EACV,qBAAqB;AACvB;;AAEA,UAAU;AACV;EACE,+BAA+B;EAC/B,0CAA0C;EAC1C,8CAA8C;EAC9C,eAAe;EACf,YAAY;EACZ,kBAAkB;EAClB;;;uCAGqC;EACrC,yDAAyD;AAC3D;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,YAAY;EACZ,iBAAiB;EACjB,SAAS;EACT,kBAAkB;EAClB,UAAU;EACV,SAAS;AACX;;AAEA,UAAU;AACV;EACE,aAAa;EACb,mBAAmB;EACnB,SAAS;AACX;;AAEA,iBAAiB;AACjB;EACE,aAAa;EACb,mBAAmB;AACrB;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,iBAAiB;EACjB,uCAAuC;EACvC,0BAA0B;EAC1B,2BAA2B;EAC3B,mBAAmB;EACnB,eAAe;EACf,iDAAiD;EACjD,eAAe;EACf,gBAAgB;EAChB,4BAA4B;EAC5B,kBAAkB;EAClB,gBAAgB;EAChB,eAAe;EACf,2CAA2C;AAC7C;AAEA;EACE,eAAe;AACjB;AAEA;EACE,kCAAkC;EAClC,2BAA2B;EAC3B,0BAA0B;EAC1B;;yCAEuC;EACvC,2BAA2B;AAC7B;AAEA;EACE,kBAAkB;EAClB,WAAW;EACX,YAAY;EACZ,kBAAkB;EAClB,+BAA+B;EAC/B,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,yBAAyB;EACzB,uCAAuC;AACzC;AAEA;EACE,mFAAmF;EACnF,mCAAmC;EACnC,wCAAwC;AAC1C;AAEA;EACE,eAAe;EACf,cAAc;EACd,yBAAyB;EACzB,yCAAyC;AAC3C;AAEA;EACE,kBAAkB;EAClB,QAAQ;EACR,UAAU;EACV,UAAU;EACV,WAAW;EACX,kBAAkB;EAClB,mBAAmB;EACnB,yBAAyB;EACzB,YAAY;AACd;AAEA;EACE,mBAAmB;EACnB,2CAA2C;AAC7C;;AAEA,UAAU;AACV;EACE,OAAO;EACP,gBAAgB;EAChB,sBAAsB;EACtB,kBAAkB;EAClB,UAAU;EACV,6BAA6B;AAC/B;AAEA;EACE,YAAY;EACZ,2BAA2B;EAC3B,0CAA0C;EAC1C,mBAAmB;EACnB,uCAAuC;EACvC,gBAAgB;EAChB;;;uCAGqC;EACrC,kBAAkB;EAClB,yDAAyD;AAC3D;;AAEA,iBAAiB;AACjB;EACE,aAAa;EACb,sBAAsB;AACxB;AAEA;EACE,aAAa;EACb,YAAY;AACd;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,0BAA0B;EAC1B,2BAA2B;EAC3B,kBAAkB;EAClB,yDAAyD;AAC3D;AAEA;EACE,OAAO;EACP,gBAAgB;EAChB,cAAc;EACd,6CAA6C;EAC7C,kBAAkB;AACpB;AAEA;EACE,OAAO;EACP,gBAAgB;AAClB;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,kBAAkB;EAClB,8CAA8C;EAC9C,+BAA+B;EAC/B,2BAA2B;EAC3B,kBAAkB;EAClB,yDAAyD;AAC3D;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,0BAA0B;EAC1B,SAAS;EACT,wBAAwB;EACxB,6BAA6B;EAC7B,yDAAyD;AAC3D;AAEA;EACE,aAAa;EACb,QAAQ;AACV;AAEA;EACE,WAAW;EACX,YAAY;EACZ,sCAAsC;EACtC,0BAA0B;EAC1B,kBAAkB;EAClB,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,yDAAyD;EACzD,eAAe;EACf,4BAA4B;EAC5B;;yCAEuC;EACvC,kBAAkB;EAClB,gBAAgB;AAClB;AAEA;EACE,2BAA2B;EAC3B,0BAA0B;EAC1B,kCAAkC;EAClC;;;uCAGqC;EACrC,2BAA2B;EAC3B,oCAAoC;AACtC;AAEA;EACE,oBAAoB;EACpB,YAAY;AACd;AAEA;EACE,yCAAyC;AAC3C;AAEA;EACE,YAAY;EACZ,mBAAmB;EACnB,oBAAoB;AACtB;AAEA;EACE,iCAAiC;EACjC,cAAc;EACd,mCAAmC;EACnC;;;uCAGqC;EACrC,yCAAyC;AAC3C;AAEA;EACE,mCAAmC;EACnC,qCAAqC;AACvC;AAEA;AACE,OAAO,uBAAuB;AAAE;AAChC,KAAK,yBAAyB;AAAE;AAClC;AAEA;EACE,OAAO;EACP,cAAc;EACd,YAAY;EACZ,0BAA0B;EAC1B,yDAAyD;AAC3D;;AAEA,UAAU;AACV;EACE,OAAO;EACP,cAAc;EACd,aAAa;EACb,0BAA0B;EAC1B,yDAAyD;AAC3D;AAEA;EACE,2BAA2B;EAC3B,2BAA2B;EAC3B,mBAAmB;EACnB,aAAa;EACb,mBAAmB;EACnB,uCAAuC;EACvC;;;uCAGqC;EACrC,kBAAkB;EAClB,gBAAgB;EAChB,yDAAyD;AAC3D;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,eAAe;EACf,gBAAgB;EAChB,0BAA0B;EAC1B,kBAAkB;EAClB,wBAAwB;EACxB,6BAA6B;EAC7B,yDAAyD;AAC3D;AAEA;EACE,eAAe;EACf,8BAA8B;EAC9B,0BAA0B;EAC1B,0BAA0B;EAC1B,qBAAqB;EACrB,iBAAiB;EACjB,mBAAmB;EACnB,gBAAgB;EAChB,wBAAwB;EACxB,sCAAsC;EACtC;;sCAEoC;EACpC,oCAAoC;EACpC,yDAAyD;AAC3D;AAEA;EACE,mBAAmB;AACrB;AAEA;EACE,mBAAmB;EACnB,mBAAmB;EACnB,8CAA8C;EAC9C,kBAAkB;AACpB;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,0BAA0B;EAC1B,SAAS;EACT,wBAAwB;EACxB,uCAAuC;EACvC,yDAAyD;AAC3D;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,SAAS;AACX;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,SAAS;EACT,cAAc;AAChB;AAEA;EACE,eAAe;EACf,eAAe;EACf,4BAA4B;EAC5B,gBAAgB;EAChB,wBAAwB;EACxB,oCAAoC;EACpC,yDAAyD;AAC3D;AAEA;EACE,OAAO;EACP,iBAAiB;EACjB,uCAAuC;EACvC,kBAAkB;EAClB,eAAe;EACf,yDAAyD;EACzD,0BAA0B;EAC1B,0BAA0B;EAC1B,0BAA0B;EAC1B,oBAAoB;EACpB;;yCAEuC;AACzC;AAEA;EACE,aAAa;EACb,kCAAkC;EAClC;;;;uCAIqC;EACrC,2BAA2B;EAC3B,2BAA2B;EAC3B,oCAAoC;AACtC;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,SAAS;AACX;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,SAAS;EACT,iBAAiB;EACjB,0BAA0B;EAC1B,0BAA0B;EAC1B,mBAAmB;EACnB,uCAAuC;EACvC;;yCAEuC;EACvC,yBAAyB;AAC3B;AAEA;EACE,eAAe;EACf,eAAe;EACf,4BAA4B;EAC5B,gBAAgB;EAChB,wBAAwB;EACxB,oCAAoC;EACpC,yDAAyD;AAC3D;AAEA;EACE,aAAa;EACb,QAAQ;EACR,OAAO;AACT;AAEA;EACE,OAAO;EACP,iBAAiB;EACjB,uCAAuC;EACvC,kBAAkB;EAClB,eAAe;EACf,kBAAkB;EAClB,0BAA0B;EAC1B,0BAA0B;EAC1B,yDAAyD;EACzD,0BAA0B;EAC1B,kGAAkG;EAClG,kCAAkC;EAClC;;yCAEuC;AACzC;AAEA;EACE,aAAa;EACb,kCAAkC;EAClC;;;;uCAIqC;EACrC,2BAA2B;EAC3B,2BAA2B;EAC3B,oCAAoC;AACtC;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;EACnB,uBAAuB;EACvB,aAAa;EACb,4BAA4B;EAC5B,kBAAkB;EAClB,0BAA0B;EAC1B,2BAA2B;EAC3B,mBAAmB;EACnB,uCAAuC;EACvC;;yCAEuC;EACvC,yDAAyD;AAC3D;AAEA;EACE,eAAe;EACf,mBAAmB;EACnB,YAAY;EACZ,yBAAyB;EACzB,iDAAiD;EACjD,wCAAwC;EACxC,yDAAyD;AAC3D;AAEA;EACE,eAAe;EACf,wBAAwB;EACxB,oCAAoC;EACpC,gBAAgB;EAChB,yDAAyD;AAC3D;;AAEA,UAAU;AACV;EACE,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,2FAA2F;EAC3F,yDAAyD;AAC3D;AAEA;EACE,kBAAkB;EAClB,aAAa;EACb,gBAAgB;EAChB,2BAA2B;EAC3B,2BAA2B;EAC3B,mBAAmB;EACnB,sCAAsC;EACtC;;;uCAGqC;EACrC,kBAAkB;EAClB,gBAAgB;EAChB,yDAAyD;AAC3D;AAEA;EACE,eAAe;EACf,mBAAmB;EACnB,YAAY;EACZ,yBAAyB;EACzB,kDAAkD;EAClD,wCAAwC;EACxC,6BAA6B;EAC7B,yDAAyD;AAC3D;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,0BAA0B;EAC1B,mBAAmB;EACnB,wBAAwB;EACxB,6BAA6B;EAC7B,yDAAyD;AAC3D;AAEA;EACE,4BAA4B;EAC5B,mBAAmB;EACnB,eAAe;EACf,wBAAwB;EACxB,iBAAiB;EACjB,uCAAuC;EACvC,gBAAgB;EAChB,yDAAyD;AAC3D;AAEA;EACE,WAAW;EACX,WAAW;EACX,0BAA0B;EAC1B,kBAAkB;EAClB,gBAAgB;EAChB;;mCAEiC;EACjC,uCAAuC;EACvC,yDAAyD;AAC3D;AAEA;EACE,YAAY;EACZ,2FAA2F;EAC3F,kBAAkB;EAClB,+CAA+C;EAC/C;;sCAEoC;EACpC,yDAAyD;AAC3D;AAEA;AACE;IACE,SAAS;IACT,eAAe;AACjB;AACA;IACE,UAAU;IACV,gBAAgB;AAClB;AACA;IACE,SAAS;IACT,iBAAiB;AACnB;AACF;;AAEA,aAAa;AACb;EACE,kBAAkB;EAClB,QAAQ;EACR,SAAS;EACT,gCAAgC;EAChC,WAAW;EACX,gBAAgB;EAChB,eAAe;AACjB;AAEA;EACE,2BAA2B;EAC3B,2BAA2B;EAC3B,mBAAmB;EACnB,aAAa;EACb,uCAAuC;EACvC;;yCAEuC;EACvC,kBAAkB;AACpB;AAEA;EACE,eAAe;EACf,mBAAmB;EACnB,YAAY;EACZ,yBAAyB;EACzB,kDAAkD;EAClD,wCAAwC;AAC1C;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,0BAA0B;EAC1B,mBAAmB;EACnB,6BAA6B;AAC/B;AAEA;EACE,gBAAgB;AAClB;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,mBAAmB;EACnB,gBAAgB;EAChB,uCAAuC;EACvC,gBAAgB;AAClB;AAEA;EACE,gBAAgB;EAChB,UAAU;EACV,cAAc;EACd,0BAA0B;EAC1B,kBAAkB;EAClB,aAAa;EACb,uCAAuC;EACvC,2CAA2C;AAC7C;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,kBAAkB;EAClB,cAAc;EACd,8CAA8C;EAC9C,uCAAuC;EACvC,gBAAgB;AAClB;AAEA;EACE,mBAAmB;EACnB,gBAAgB;AAClB;AAEA;AACE;IACE,YAAY;IACZ,mBAAmB;AACrB;AACA;IACE,UAAU;IACV,sBAAsB;AACxB;AACF;;AAEA,kBAAkB;AAClB;EACE,kBAAkB;EAClB,gBAAgB;AAClB;AAEA;EACE,eAAe;EACf,MAAM;EACN,OAAO;EACP,YAAY;EACZ,aAAa;EACb,aAAa;EACb,oBAAoB;EACpB,UAAU;EACV,qDAAqD;EACrD,0BAA0B;AAC5B;AAEA;EACE;;;;;;;;GAQC;AACH;AAEA;EACE;;;;;;;;GAQC;AACH;AAEA;EACE,UAAU;AACZ;;AAEA,WAAW;AACX;EACE,eAAe;EACf,MAAM;EACN,OAAO;EACP,WAAW;EACX,YAAY;EACZ,8BAA8B;EAC9B,0BAA0B;EAC1B,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,cAAc;EACd,2BAA2B;AAC7B;AAEA;EACE,2BAA2B;EAC3B,2BAA2B;EAC3B,mBAAmB;EACnB,uCAAuC;EACvC;;yCAEuC;EACvC,gBAAgB;EAChB,UAAU;EACV,gBAAgB;EAChB,gBAAgB;EAChB,4BAA4B;AAC9B;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,uBAAuB;EACvB,8CAA8C;EAC9C,+BAA+B;AACjC;AAEA;EACE,SAAS;EACT,eAAe;EACf,gBAAgB;EAChB,0BAA0B;EAC1B,6BAA6B;AAC/B;AAEA;EACE,gBAAgB;EAChB,YAAY;EACZ,4BAA4B;EAC5B,eAAe;EACf,eAAe;EACf,WAAW;EACX,YAAY;EACZ,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,kBAAkB;EAClB,yBAAyB;AAC3B;AAEA;EACE,0BAA0B;EAC1B,0BAA0B;EAC1B,qBAAqB;AACvB;AAEA;EACE,aAAa;EACb,kBAAkB;AACpB;AAEA;EACE,eAAe;EACf,mBAAmB;EACnB,wCAAwC;AAC1C;AAEA;EACE,eAAe;EACf,0BAA0B;EAC1B,mBAAmB;EACnB,gBAAgB;EAChB,6BAA6B;AAC/B;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,gBAAgB;EAChB,gBAAgB;AAClB;AAEA;EACE,aAAa;EACb,SAAS;EACT,uBAAuB;EACvB,uBAAuB;AACzB;AAEA;EACE,kBAAkB;EAClB,kBAAkB;EAClB,eAAe;EACf,gBAAgB;EAChB,eAAe;EACf,yBAAyB;EACzB,uCAAuC;EACvC,eAAe;AACjB;AAEA;EACE,0BAA0B;EAC1B,4BAA4B;AAC9B;AAEA;EACE,2BAA2B;EAC3B,0BAA0B;EAC1B,kCAAkC;AACpC;AAEA;EACE,qDAAqD;EACrD,cAAc;EACd,qBAAqB;EACrB,+CAA+C;AACjD;AAEA;EACE,qDAAqD;EACrD,qBAAqB;EACrB,+CAA+C;EAC/C,2BAA2B;AAC7B;AAEA;AACE,OAAO,UAAU;AAAE;AACnB,KAAK,UAAU;AAAE;AACnB;AAEA;AACE;IACE,UAAU;IACV,wCAAwC;AAC1C;AACA;IACE,UAAU;IACV,iCAAiC;AACnC;AACF;;AAEA,WAAW;AACX;EACE,gBAAgB;EAChB,UAAU;AACZ;AAEA;EACE,aAAa;EACb,kBAAkB;AACpB;AAEA;EACE,mBAAmB;EACnB,aAAa;EACb,uBAAuB;EACvB,mBAAmB;AACrB;AAEA;EACE,YAAY;EACZ,aAAa;EACb,mBAAmB;EACnB,yCAAyC;EACzC,uCAAuC;EACvC,yBAAyB;AAC3B;AAEA;EACE,sBAAsB;EACtB,0CAA0C;AAC5C;AAEA;EACE,0BAA0B;AAC5B;AAEA;EACE,kBAAkB;EAClB,eAAe;EACf,gBAAgB;EAChB,0BAA0B;AAC5B;AAEA;EACE,aAAa;EACb,eAAe;EACf,gBAAgB;EAChB,4BAA4B;AAC9B;AAEA;EACE,gBAAgB;EAChB,0BAA0B;AAC5B;;AAEA,WAAW;AACX;EACE,0BAA0B;EAC1B,uCAAuC;EACvC,kBAAkB;EAClB,gBAAgB;EAChB,4BAA4B;EAC5B,eAAe;EACf,yBAAyB;EACzB,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,eAAe;EACf,YAAY;AACd;AAEA;EACE,2BAA2B;EAC3B,0BAA0B;EAC1B,kCAAkC;EAClC,2BAA2B;EAC3B,2CAA2C;AAC7C;AAEA;EACE,eAAe;EACf,mBAAmB;AACrB","sourcesContent":["<template>\r\n  <div class=\"layatree-panel\">\r\n    <!-- 引擎信息显示区域 -->\r\n    <div class=\"info-bar\">\r\n      <div class=\"left-info\">\r\n        <div v-if=\"serverInfo && showServerInfo\" class=\"server-info\" :class=\"{ 'fade-out': isServerInfoFading }\">\r\n          <span class=\"server-info-text\">{{ serverInfo }}</span>\r\n          <button class=\"close-btn\" @click=\"hideServerInfo\" title=\"关闭\">×</button>\r\n        </div>\r\n      </div>\r\n      <div class=\"right-info\">\r\n         <!-- 用户反馈 按钮 -->\r\n        <EngineInfo :engine-info=\"engineInfo\" />\r\n        <button class=\"feedback-btn\" @click=\"openFeedback\" title=\"用户反馈\">\r\n          <i class=\"icon-feedback\"></i>\r\n        </button>\r\n      </div>\r\n    </div>\r\n\r\n    <!-- 顶部导航栏 -->\r\n    <header class=\"header\">\r\n      <div class=\"header-content\">\r\n        <NavigationTabs \r\n          :tabs=\"tabs\" \r\n          :active-tab=\"activeTab\" \r\n          @switch-tab=\"switchTab\"\r\n        />\r\n        \r\n        <!-- 控制按钮组 -->\r\n        <div class=\"control-buttons\">\r\n          <!-- 智能体绑定状态按钮 -->\r\n          <div class=\"ai-agent-switcher\">\r\n            <button \r\n              class=\"ai-agent-btn\"\r\n              @click=\"openAgentPopup\"\r\n              :title=\"getAgentTooltip()\"\r\n            >\r\n              <div class=\"ai-icon-container\" :class=\"{ 'connected': isAgentConnected }\">\r\n                <i class=\"icon-ai-agent\" :class=\"{ 'pulse': isAgentConnected }\"></i>\r\n              </div>\r\n              <span class=\"ai-label\">{{ isAgentConnected ? '已连接' : '未连接' }}</span>\r\n              <div class=\"connection-status\" :class=\"{ 'active': isAgentConnected }\"></div>\r\n            </button>\r\n          </div>\r\n          \r\n          <!-- 主题切换按钮 -->\r\n          <div class=\"theme-switcher\">\r\n            <button \r\n              class=\"theme-toggle-btn\"\r\n              @click=\"toggleTheme\"\r\n              :disabled=\"isThemeTransitioning\"\r\n              :title=\"isDarkMode ? '切换到浅色主题' : '切换到深色主题'\"\r\n            >\r\n              <div class=\"theme-icon-container\">\r\n                <i :class=\"isDarkMode ? 'icon-light' : 'icon-dark'\" class=\"theme-icon\"></i>\r\n              </div>\r\n              <span class=\"theme-label\">{{ isDarkMode ? '浅色' : '深色' }}</span>\r\n            </button>\r\n          </div>\r\n        </div>\r\n      </div>\r\n    </header>\r\n\r\n    <!-- 主内容区域 -->\r\n    <main class=\"main-content\">\r\n      <!-- Hierarchy 功能 -->\r\n      <div v-if=\"activeTab === 'hierarchy'\" class=\"content-panel hierarchy-panel\">\r\n        <div class=\"hierarchy-content\">\r\n          <!-- 左侧层级树 -->\r\n          <div class=\"tree-panel\">\r\n            <div class=\"panel-header\">\r\n              <h3>场景层级</h3>\r\n              \r\n              <!-- 游戏控制按钮组 -->\r\n              <GameControls\r\n                :is-paused=\"isPaused\"\r\n                v-model:time-scale=\"timeScale\"\r\n                @toggle-pause=\"togglePause\"\r\n                @next-frame=\"nextFrame\"\r\n                @timescale-change=\"onTimeScaleChange\"\r\n              />\r\n              \r\n              <div class=\"panel-actions\">\r\n                <button \r\n                  class=\"action-btn\" \r\n                  @click=\"refreshTree\" \r\n                  :disabled=\"isRefreshing\" \r\n                  :class=\"{ 'refreshing': isRefreshing }\"\r\n                  :title=\"isRefreshing ? '正在刷新...' : '刷新场景层级'\"\r\n                >\r\n                  <i :class=\"isRefreshing ? 'icon-loading' : 'icon-refresh'\"></i>\r\n                </button>\r\n                <button \r\n                  class=\"action-btn\" \r\n                  @click=\"expandAll\"\r\n                  title=\"展开所有节点\"\r\n                >\r\n                  <i class=\"icon-expand\"></i>\r\n                </button>\r\n                <button \r\n                  class=\"action-btn\" \r\n                  @click=\"collapseAll\"\r\n                  title=\"折叠所有节点\"\r\n                >\r\n                  <i class=\"icon-collapse\"></i>\r\n                </button>\r\n                <button \r\n                  class=\"action-btn\" \r\n                  @click=\"toggleSelBoxMark\"\r\n                  :class=\"{ 'active': isSelBoxMarkEnabled }\"\r\n                  :title=\"isSelBoxMarkEnabled ? '关闭选择框标记' : '开启选择框标记'\"\r\n                >\r\n                  <i class=\"icon-flag\"></i>\r\n                </button>\r\n              </div>\r\n            </div>\r\n            <div class=\"tree-container\">\r\n              <TreeView \r\n                :nodes=\"treeNodes\" \r\n                :selected-node-id=\"selectedNode?.id || ''\"\r\n                :is-dark-mode=\"isDarkMode\" \r\n                @node-select=\"onNodeSelect\"\r\n                @status-toggle=\"onStatusToggle\"\r\n                @node-delete=\"onNodeDelete\"\r\n              />\r\n            </div>\r\n          </div>\r\n\r\n          <!-- 右侧属性面板 -->\r\n          <div class=\"inspector-panel\">\r\n            <div class=\"panel-header\">\r\n              <h3>属性检查器</h3>\r\n            </div>\r\n            <div class=\"inspector-content\">\r\n              <PropertyInspector\r\n                :selected-node=\"selectedNode\"\r\n                :is-dark-mode=\"isDarkMode\"\r\n                :message-listener=\"getMessageListener()\"\r\n                @property-change=\"onPropertyChange\"\r\n              />\r\n              \r\n              <div v-if=\"!selectedNode && !engineInfo\" class=\"engine-help\">\r\n                <div class=\"help-content\">\r\n                  <i class=\"icon-development\"></i>\r\n                  <p class=\"help-title\">未检测到支持的游戏引擎</p>\r\n                  <div class=\"help-details\">\r\n                    <p class=\"help-text\">LayaTree 支持以下游戏引擎：</p>\r\n                    <ul class=\"help-list\">\r\n                      <li>🎮 Laya Engine (Laya1.x / Laya2.x / Laya3.x)</li>\r\n                      <li>🔵 Three.js</li>\r\n                    </ul>\r\n                    <p class=\"help-text\">请确保目标页面包含支持的游戏引擎</p>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n            </div>\r\n          </div>\r\n        </div>\r\n      </div>\r\n\r\n      <!-- Nano 功能 -->\r\n      <div v-else-if=\"activeTab === 'nano'\" class=\"content-panel\">\r\n        <Nano \r\n          ref=\"nanoComponentRef\"\r\n          :is-dark-mode=\"isDarkMode\"\r\n        />\r\n      </div>\r\n\r\n      <!-- Performance 功能 -->\r\n      <div v-else-if=\"activeTab === 'performance'\" class=\"content-panel\">\r\n        <!-- <Performance \r\n          :message-listener=\"getMessageListener()\"\r\n          :is-dark-mode=\"isDarkMode\"\r\n        /> -->\r\n        <div class=\"coming-soon-content\">\r\n          <i class=\"icon-development\"></i>\r\n          <h2>{{ getCurrentTabLabel() }}</h2>\r\n          <p>该功能正在开发中，敬请期待...</p>\r\n          <div class=\"progress-indicator\">\r\n            <div class=\"progress-bar\"></div>\r\n          </div>\r\n        </div>\r\n      </div>\r\n\r\n      <!-- 其他功能模块 -->\r\n      <div v-else class=\"content-panel coming-soon\">\r\n        <div class=\"coming-soon-content\">\r\n          <i class=\"icon-development\"></i>\r\n          <h2>{{ getCurrentTabLabel() }}</h2>\r\n          <p>该功能正在开发中，敬请期待...</p>\r\n          <div class=\"progress-indicator\">\r\n            <div class=\"progress-bar\"></div>\r\n          </div>\r\n        </div>\r\n      </div>\r\n    </main>\r\n    \r\n    <!-- 页签切换确认弹窗 -->\r\n    <div v-if=\"showTabSwitchConfirm\" class=\"modal-overlay\" @click.self=\"cancelTabSwitch\">\r\n      <div class=\"modal-container\">\r\n        <div class=\"modal-header\">\r\n          <h3>确认切换页签</h3>\r\n          <button class=\"modal-close-btn\" @click=\"cancelTabSwitch\">\r\n            <span class=\"close-icon\">×</span>\r\n          </button>\r\n        </div>\r\n        <div class=\"modal-content\">\r\n          <div class=\"warning-icon\">⚠️</div>\r\n          <p class=\"warning-text\">当前Nano页面处于连接状态，切换到其他页签将会断开连接。</p>\r\n          <p class=\"confirm-text\">确定要继续切换吗？</p>\r\n        </div>\r\n        <div class=\"modal-footer\">\r\n          <button class=\"cancel-btn\" @click=\"cancelTabSwitch\">取消</button>\r\n          <button class=\"confirm-btn\" @click=\"confirmTabSwitch\">确认切换</button>\r\n        </div>\r\n      </div>\r\n    </div>\r\n\r\n    <!-- 用户反馈弹窗 -->\r\n    <div v-if=\"showFeedbackModal\" class=\"modal-overlay\" @click.self=\"closeFeedback\">\r\n      <div class=\"modal-container feedback-modal\">\r\n        <div class=\"modal-header\">\r\n          <h3>用户反馈</h3>\r\n          <button class=\"modal-close-btn\" @click=\"closeFeedback\">\r\n            <span class=\"close-icon\">×</span>\r\n          </button>\r\n        </div>\r\n        <div class=\"modal-content feedback-content\">\r\n          <div class=\"qrcode-container\">\r\n             <img :src=\"qrcodeUrl\" alt=\"QQ群二维码\" class=\"qrcode-image\" />\r\n           </div>\r\n          <div class=\"feedback-text\">\r\n            <h4>扫码加QQ群</h4>\r\n            <p>扫描上方二维码加入QQ群，与开发者和其他用户交流反馈</p>\r\n            <p>我们会及时回复您的问题和建议</p>\r\n          </div>\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </div>\r\n</template>\r\n\r\n<script setup lang=\"ts\">\r\nimport { ref, onMounted, onUnmounted } from 'vue';\r\nimport TreeView from './components/TreeView.vue';\r\nimport EngineInfo from './components/EngineInfo.vue';\r\nimport NavigationTabs from './components/NavigationTabs.vue';\r\nimport GameControls from './components/GameControls.vue';\r\nimport PropertyInspector from './components/PropertyInspector.vue';\r\nimport Performance from './components/Performance.vue';\r\nimport Nano from './components/Nano.vue';\r\n\r\n// Core imports\r\nimport { Logger, Constant } from '@/core/Constant';\r\nimport { EventType } from '@/core/message/Event';\r\n\r\n// Composables\r\nimport { useTheme } from './composables/useTheme';\r\nimport { useAgentConnection } from './composables/useAgentConnection';\r\nimport { useEngineData } from './composables/useEngineData';\r\nimport { useGameControls } from './composables/useGameControls';\r\nimport { useMessageHandler } from './composables/useMessageHandler';\r\n\r\n// Types\r\nimport type { Tab, TreeNode } from './types/panel.types';\r\n\r\n// 导航标签\r\nconst tabs: Tab[] = [\r\n  { id: 'hierarchy', label: 'Hierarchy', icon: 'icon-hierarchy' },\r\n  { id: 'nano', label: 'Nano', icon: 'icon-nano' },\r\n  { id: 'performance', label: 'Performance', icon: 'icon-performance' },\r\n  { id: 'codedebugging', label: 'Code Debugging', icon: 'icon-debug' }\r\n];\r\n\r\n// 基础状态\r\nconst activeTab = ref('hierarchy');\r\nconst serverInfo = ref<string>('');\r\nconst showServerInfo = ref(false);\r\nconst isServerInfoFading = ref(false);\r\nconst isSelBoxMarkEnabled = ref(false);\r\n\r\n// 确认弹窗状态\r\nconst showTabSwitchConfirm = ref(false);\r\nconst pendingTabId = ref<string>('');\r\nconst nanoComponentRef = ref<InstanceType<typeof Nano> | null>(null);\r\n\r\n// 反馈弹窗状态\r\nconst showFeedbackModal = ref(false);\r\n\r\n// 二维码图片URL\r\nconst qrcodeUrl = chrome.runtime.getURL('assets/qrcode.jpg');\r\n\r\n// 使用 composables\r\nconst { isDarkMode, isThemeTransitioning, toggleTheme } = useTheme();\r\nconst { isAgentConnected, openAgentPopup, getAgentTooltip } = useAgentConnection();\r\n\r\n// 引擎数据管理\r\nconst {\r\n  engineInfo,\r\n  treeNodes,\r\n  selectedNode,\r\n  isRefreshing,\r\n  refreshTree,\r\n  expandAll,\r\n  collapseAll,\r\n  onNodeSelect,\r\n  onPropertyChange,\r\n  getNodeIcon,\r\n  handleTreeRefresh,\r\n  handleNodePropertyResponse,\r\n  handleSetNodePropertyResponse,\r\n  connectionStatus,\r\n  stopPropertyAutoUpdate,\r\n  resetEngineData\r\n} = useEngineData(() => getMessageListener());\r\n\r\n// 游戏控制\r\nconst {\r\n  isPaused,\r\n  timeScale,\r\n  togglePause,\r\n  nextFrame,\r\n  onTimeScaleChange,\r\n  handleTimeScaleResponse\r\n} = useGameControls(() => getMessageListener());\r\n\r\n// 页面刷新检测回调\r\nconst onPageRefreshDetected = () => {\r\n  Logger.log('📨 收到页面刷新检测消息，执行状态重置');\r\n  resetAllDevtoolsState();\r\n};\r\n\r\n// 消息处理 - 在后面创建，这样可以使用上面定义的处理函数\r\nconst { messageListener: getMessageListener } = useMessageHandler(\r\n  engineInfo,\r\n  connectionStatus,\r\n  handleTreeRefresh,\r\n  handleTimeScaleResponse,\r\n  handleNodePropertyResponse,\r\n  handleSetNodePropertyResponse,\r\n  onPageRefreshDetected\r\n);\r\n\r\n// 方法\r\nconst switchTab = (tabId: string) => {\r\n  // 如果当前在nano页签且要切换到其他页签，检查连接状态\r\n  if (activeTab.value === 'nano' && tabId !== 'nano') {\r\n    // 检查Nano是否处于连接状态\r\n    if (nanoComponentRef.value && isNanoConnected()) {\r\n      // 显示确认弹窗\r\n      pendingTabId.value = tabId;\r\n      showTabSwitchConfirm.value = true;\r\n      return;\r\n    }\r\n  }\r\n  \r\n  // 直接切换页签\r\n  activeTab.value = tabId;\r\n};\r\n\r\n// 检查Nano是否处于连接状态\r\nconst isNanoConnected = (): boolean => {\r\n  if (!nanoComponentRef.value) {\r\n    return false;\r\n  }\r\n  \r\n  try {\r\n    // 检查是否有活跃的连接（已连接或服务器已启动）\r\n    return nanoComponentRef.value.hasActiveConnection();\r\n  } catch (error) {\r\n    console.warn('检查Nano连接状态时出错:', error);\r\n    return false;\r\n  }\r\n};\r\n\r\n// 确认切换页签\r\nconst confirmTabSwitch = () => {\r\n  showTabSwitchConfirm.value = false;\r\n  activeTab.value = pendingTabId.value;\r\n  pendingTabId.value = '';\r\n};\r\n\r\n// 取消切换页签\r\nconst cancelTabSwitch = () => {\r\n  showTabSwitchConfirm.value = false;\r\n  pendingTabId.value = '';\r\n};\r\n\r\n// 打开反馈弹窗\r\nconst openFeedback = () => {\r\n  showFeedbackModal.value = true;\r\n};\r\n\r\n// 关闭反馈弹窗\r\nconst closeFeedback = () => {\r\n  showFeedbackModal.value = false;\r\n};\r\n\r\nconst getCurrentTabLabel = () => {\r\n  const tab = tabs.find(t => t.id === activeTab.value);\r\n  return tab?.label || '';\r\n};\r\n\r\n// 切换选择框标记状态\r\nconst toggleSelBoxMark = () => {\r\n  isSelBoxMarkEnabled.value = !isSelBoxMarkEnabled.value;\r\n  Logger.log(`切换选择框标记状态: ${isSelBoxMarkEnabled.value}`);\r\n  \r\n  // 向引擎发送设置显示选择框请求\r\n  const messageListener = getMessageListener();\r\n  if (messageListener) {\r\n    messageListener.post(EventType.SET_SHOW_SEL_BOX, {\r\n      show: isSelBoxMarkEnabled.value,\r\n      timestamp: Date.now()\r\n    });\r\n    Logger.log(`📤 已发送设置显示选择框请求: show=${isSelBoxMarkEnabled.value}`);\r\n  } else {\r\n    Logger.warn('消息监听器未初始化，无法发送设置显示选择框请求');\r\n  }\r\n};\r\n\r\n// 处理节点删除\r\nconst onNodeDelete = (node: TreeNode) => {\r\n  console.log('面板接收到删除节点请求:', node.name, node.exId);\r\n  \r\n  // 递归删除节点\r\n  const removeNodeFromTree = (nodes: TreeNode[], targetId: string): TreeNode[] => {\r\n    return nodes.filter(n => {\r\n      if (n.id === targetId) {\r\n        console.log('已从树中删除节点:', n.name);\r\n        return false; // 删除这个节点\r\n      }\r\n      // 递归处理子节点\r\n      if (n.children) {\r\n        n.children = removeNodeFromTree(n.children, targetId);\r\n      }\r\n      return true; // 保留这个节点\r\n    });\r\n  };\r\n  \r\n  // 从本地树数据中删除节点\r\n  treeNodes.value = removeNodeFromTree(treeNodes.value, node.id);\r\n  \r\n  // 如果删除的是当前选中的节点，清除选中状态\r\n  if (selectedNode.value && selectedNode.value.id === node.id) {\r\n    selectedNode.value = null;\r\n    console.log('已清除选中状态，因为选中的节点被删除了');\r\n  }\r\n  \r\n  // 如果节点有exId，向引擎发送删除请求\r\n  if (node.exId !== undefined) {\r\n    const messageListener = getMessageListener();\r\n    if (messageListener) {\r\n      messageListener.post(EventType.DELETE_NODE, {\r\n        exId: node.exId,\r\n        timestamp: Date.now()\r\n      });\r\n      console.log('已向引擎发送删除节点请求, exId:', node.exId);\r\n    } else {\r\n      console.warn('消息监听器未初始化，无法向引擎发送删除请求');\r\n    }\r\n  } else {\r\n    console.warn('节点没有exId，仅删除本地显示');\r\n  }\r\n};\r\n\r\n// 处理节点状态切换 - 修复悬浮节点与选中节点混淆的bug\r\nconst onStatusToggle = (node: any, statusType: 'active' | 'visible', newValue: boolean) => {\r\n  Logger.log(`🔄 切换节点 ${node.name} 的 ${statusType} 状态为: ${newValue} (exId: ${node.exId})`);\r\n  \r\n  if (node.exId == undefined) {\r\n    Logger.warn('节点没有exId，无法发送状态更新请求');\r\n    return;\r\n  }\r\n\r\n  // 重要修复：直接使用传入的node的exId发送属性更新请求\r\n  // 避免悬浮节点和选中节点混淆的问题\r\n  const messageListener = getMessageListener();\r\n  if (messageListener) {\r\n    const componentType = statusType === 'visible' ? 'Node2D' : 'NodeInfo';\r\n    const propertyName = statusType === 'visible' ? 'visible' : 'active';\r\n    \r\n    // 直接使用传入节点的exId，而不是selectedNode的exId\r\n    messageListener.post(EventType.SET_NODE_PROPERTY, {\r\n      exId: node.exId, // 关键修复：使用传入节点的exId\r\n      componentType: componentType,\r\n      propertyName: propertyName,\r\n      value: newValue,\r\n      timestamp: Date.now()\r\n    });\r\n    \r\n    Logger.log(`📤 已发送${statusType}状态更新请求: ${componentType}.${propertyName}=${newValue} (exId: ${node.exId})`);\r\n    \r\n    // 更新传入节点的本地显示状态\r\n    if (statusType === 'visible') {\r\n      node.visible = newValue;\r\n    } else {\r\n      node.active = newValue;\r\n    }\r\n    \r\n    Logger.log(`🔄 已更新节点 ${node.name} 的${statusType}属性为: ${newValue}`);\r\n  } else {\r\n    Logger.warn('消息监听器未初始化，无法发送状态更新请求');\r\n  }\r\n};\r\n\r\n// 重置所有devtools状态的函数\r\nconst resetAllDevtoolsState = () => {\r\n  Logger.log('🔄 开始重置所有devtools状态...');\r\n  \r\n  // 重置引擎数据状态\r\n  engineInfo.value = null;\r\n  treeNodes.value = [];\r\n  selectedNode.value = null;\r\n  isRefreshing.value = false;\r\n  resetEngineData();\r\n  \r\n  // 重置游戏控制状态\r\n  isPaused.value = false;\r\n  timeScale.value = 1.0;\r\n  \r\n  // 重置连接状态\r\n  connectionStatus.value = {\r\n    isConnected: false,\r\n    lastHeartbeat: 0,\r\n    backgroundConnected: false,\r\n    contentScriptConnected: false,\r\n    inspectorConnected: false,\r\n    lastPingTime: 0,\r\n    pingCount: 0\r\n  };\r\n  \r\n  // 重置导航状态\r\n  activeTab.value = 'hierarchy';\r\n  \r\n  // 停止所有自动更新和监听\r\n  stopPropertyAutoUpdate();\r\n  \r\n  Logger.log('✅ 所有devtools状态已重置完成');\r\n  \r\n  // 重新初始化连接和状态检查\r\n  setTimeout(() => {\r\n    Logger.log('🔄 重新初始化devtools连接...');\r\n    // 重新请求引擎状态\r\n    const messageListener = getMessageListener();\r\n    if (messageListener) {\r\n      messageListener.post(EventType.ENGINE_STATUS_CHECK, {\r\n        timestamp: Date.now(),\r\n        source: 'reset_recovery'\r\n      });\r\n    }\r\n  }, 500);\r\n};\r\n\r\n// 监听页面导航事件（页面刷新/跳转）\r\nconst handlePageNavigation = (url: string) => {\r\n  Logger.log('🔃 检测到页面导航事件:', url);\r\n  Logger.log('🔄 准备延迟重置devtools状态...');\r\n  \r\n  // 延迟1.5秒后重置状态，确保页面加载完成\r\n  setTimeout(() => {\r\n    resetAllDevtoolsState();\r\n  }, 1500);\r\n};\r\n\r\n// 版本检测函数\r\nconst checkVersionUpdate = async () => {\r\n  try {\r\n    // 获取manifest.json中的版本信息\r\n    const manifestUrl = chrome.runtime.getURL('manifest.json');\r\n    const manifestResponse = await fetch(manifestUrl);\r\n    const manifest = await manifestResponse.json();\r\n    const version = manifest.version;\r\n    \r\n    Logger.log('🔍 开始版本检测, 当前版本:', version);\r\n    \r\n    // 请求服务器检查更新\r\n    try {\r\n      const updateResponse = await fetch(`${Constant.API_CONFIG.VERSION_CHECK_URL}?version=${version}`);\r\n      const updateInfo = await updateResponse.text();\r\n      serverInfo.value = updateInfo;\r\n      showServerInfo.value = true;\r\n\r\n      let hm = document.createElement(\"script\");\r\n      hm.src = chrome.runtime.getURL(Constant.API_CONFIG.ANALYTICS_URL);\r\n      let s = document.getElementsByTagName(\"script\")[0]; \r\n      s.parentNode?.insertBefore(hm, s);\r\n\r\n\r\n      Logger.log('✅ 版本检测完成:', updateInfo);\r\n      \r\n      // 20秒后自动隐藏\r\n      setTimeout(() => {\r\n        startServerInfoFadeOut();\r\n      }, 20000);\r\n      \r\n    } catch (updateError) {\r\n      // 服务器请求失败\r\n      Logger.warn('⚠️ 版本检测服务器请求失败:', updateError);\r\n\r\n      // 版本检测服务器请求失败，显示随机\r\n      const rainbowPraise = [\r\n        \"金鳞岂是池中物，一遇风云便化龙\",\r\n        \"自信人生二百年，会当水击三千里\",\r\n        \"山重水复疑无路，柳暗花明又一村\",\r\n        \"明年此日青云去，却笑人间举子忙\",\r\n        \"誓上青天揽明月，一品蟾宫桂花香\",\r\n        \"须知少年凌云志，曾许人间第一流\",\r\n        \"除去君身三尺雪，天下谁人配白衣\",\r\n        \"读书不觉已春深 一寸光阴一寸金\",\r\n        \"万里飞腾仍有路，莫愁四海正风尘\",\r\n        \"春风得意马蹄疾，一日看尽长安花\",\r\n        \"寄言燕雀莫相啅，自有云霄万里高\",\r\n        \"宣父犹能畏后生，丈夫未可轻年少\",\r\n        \"重拾道心又半载，何惧不日跃龙门\",\r\n        \"十年窗下无人问,一举成名天下知\",\r\n        \"青云高渺唯生翼，莫贳流年在此朝\"\r\n      ]\r\n\r\n      serverInfo.value = rainbowPraise[Math.floor(Math.random() * rainbowPraise.length)];\r\n      showServerInfo.value = true;\r\n      \r\n      // 20秒后自动隐藏\r\n      setTimeout(() => {\r\n        startServerInfoFadeOut();\r\n      }, 20000);\r\n        \r\n    }\r\n  } catch (manifestError) {\r\n    // manifest读取失败\r\n    Logger.warn('⚠️ manifest.json读取失败:', manifestError);\r\n    serverInfo.value = \"codeAI检测结果:你的代码风格过时了~~\";\r\n    showServerInfo.value = true;\r\n    \r\n    // 20秒后自动隐藏\r\n    setTimeout(() => {\r\n      startServerInfoFadeOut();\r\n    }, 20000);\r\n  }\r\n};\r\n\r\n// 开始淡出动画\r\nconst startServerInfoFadeOut = () => {\r\n  if (showServerInfo.value) {\r\n    isServerInfoFading.value = true;\r\n    // 动画完成后隐藏\r\n    setTimeout(() => {\r\n      showServerInfo.value = false;\r\n      isServerInfoFading.value = false;\r\n    }, 500); // 500ms淡出动画\r\n  }\r\n};\r\n\r\n// 立即隐藏服务器信息\r\nconst hideServerInfo = () => {\r\n  startServerInfoFadeOut();\r\n};\r\n\r\n// 组件挂载时注册页面导航监听器\r\nonMounted(() => {\r\n  // 使用Chrome DevTools API监听页面导航作为主要检测方式\r\n  if (chrome.devtools && chrome.devtools.network) {\r\n    chrome.devtools.network.onNavigated.addListener(handlePageNavigation);\r\n    Logger.log('📝 已注册页面导航事件监听器');\r\n  } else {\r\n    Logger.warn('⚠️ Chrome DevTools API不可用，将依赖连接状态检测');\r\n  }\r\n  \r\n  // 初始化版本检测\r\n  checkVersionUpdate();\r\n});\r\n\r\n// 组件销毁时清理事件监听器\r\nonUnmounted(() => {\r\n  stopPropertyAutoUpdate();\r\n  \r\n  // 清理页面导航监听器\r\n  if (chrome.devtools && chrome.devtools.network) {\r\n    chrome.devtools.network.onNavigated.removeListener(handlePageNavigation);\r\n    Logger.log('🧹 已清理页面导航事件监听器');\r\n  }\r\n});\r\n</script>\r\n\r\n<style>\r\n/* 图标字体定义 */\r\n.icon-hierarchy::before { content: '⬢'; }\r\n.icon-performance::before { content: '⚡'; }\r\n.icon-nano::before { content: '◉'; }\r\n.icon-debug::before { content: '⚙'; }\r\n.icon-refresh::before { content: '⟳'; }\r\n.icon-expand::before { content: '⬇'; }\r\n.icon-collapse::before { content: '➤'; }\r\n.icon-flag::before { content: '🚩'; }\r\n.icon-select::before { content: '◯'; }\r\n.icon-development::before { content: '⟲'; }\r\n.icon-scene::before { content: '⬢'; }\r\n.icon-camera::before { content: '◉'; }\r\n.icon-folder::before { content: '▩'; }\r\n.icon-sprite::before { content: '◈'; }\r\n.icon-mesh::before { content: '⬟'; }\r\n.icon-node::before { content: '⬡'; }\r\n.icon-engine::before { content: '⚙'; }\r\n.icon-light::before { content: '☀'; }\r\n.icon-dark::before { content: '🌙'; }\r\n.icon-loading::before { content: '⟲'; }\r\n.icon-play::before { content: '▷'; }\r\n.icon-pause::before { content: '❚❚'; }\r\n.icon-ai-agent::before { content: '🤖'; }\r\n.icon-feedback::before { content: '💬'; }\r\n\r\n/* 从原文件中提取的核心样式 */\r\n\r\n/* CSS 变量定义 */\r\n.layatree-panel {\r\n  /* 深色主题变量 */\r\n  --bg-primary: linear-gradient(135deg, #0a0e17 0%, #0f1419 40%, #1a1f29 100%);\r\n  --bg-secondary: linear-gradient(135deg, rgba(15, 20, 25, 0.95) 0%, rgba(26, 31, 41, 0.95) 100%);\r\n  --bg-panel: linear-gradient(135deg, rgba(15, 20, 25, 0.9) 0%, rgba(26, 31, 41, 0.8) 100%);\r\n  --bg-card: linear-gradient(135deg, rgba(15, 20, 25, 0.7) 0%, rgba(26, 31, 41, 0.5) 100%);\r\n  --text-primary: #f0f2f5;\r\n  --text-secondary: #b8c5d1;\r\n  --text-accent: #4dd4ff;\r\n  --accent-primary: #0aa2ff;\r\n  --accent-secondary: #40e0d0;\r\n  --border-primary: rgba(0, 162, 255, 0.2);\r\n  --border-accent: rgba(0, 162, 255, 0.4);\r\n  --shadow-primary: rgba(0, 0, 0, 0.3);\r\n  --shadow-accent: rgba(0, 162, 255, 0.3);\r\n  --text-glow: 0 0 8px rgba(0, 162, 255, 0.5);\r\n  --text-glow-accent: 0 0 4px rgba(0, 162, 255, 0.3);\r\n  --text-glow-secondary: 0 0 6px rgba(0, 162, 255, 0.3);\r\n}\r\n\r\n/* 浅色主题变量 */\r\n.layatree-panel.light-mode {\r\n  --bg-primary: #f8fafc;\r\n  --bg-secondary: rgba(248, 250, 252, 0.95);\r\n  --bg-panel: rgba(255, 255, 255, 0.9);\r\n  --bg-card: rgba(255, 255, 255, 0.8);\r\n  --text-primary: #1e293b;\r\n  --text-secondary: #475569;\r\n  --text-accent: #0369a1;\r\n  --accent-primary: #0ea5e9;\r\n  --accent-secondary: #14b8a6;\r\n  --border-primary: rgba(0, 0, 0, 0.08);\r\n  --border-accent: rgba(0, 0, 0, 0.12);\r\n  --shadow-primary: rgba(0, 0, 0, 0.05);\r\n  --shadow-accent: rgba(0, 0, 0, 0.1);\r\n  --text-glow: 0 1px 2px rgba(0, 0, 0, 0.05);\r\n  --text-glow-accent: 0 1px 1px rgba(0, 0, 0, 0.08);\r\n  --text-glow-secondary: 0 1px 2px rgba(0, 0, 0, 0.06);\r\n}\r\n\r\n/* 主容器 */\r\n.layatree-panel {\r\n  height: 100vh;\r\n  display: flex;\r\n  flex-direction: column;\r\n  background: var(--bg-primary);\r\n  font-family: 'SF Pro Display', -apple-system, BlinkMacSystemFont, 'Inter', 'Segoe UI', Helvetica, Arial, sans-serif;\r\n  color: var(--text-primary);\r\n  font-weight: 400;\r\n  letter-spacing: -0.003em;\r\n  position: relative;\r\n  overflow: hidden;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n/* 信息栏样式 */\r\n.info-bar {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: space-between;\r\n  padding: 0 12px;\r\n  background: var(--bg-secondary);\r\n  backdrop-filter: blur(16px);\r\n  border-bottom: 1px solid var(--border-primary);\r\n  min-height: 32px;\r\n}\r\n\r\n.left-info {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 12px;\r\n}\r\n\r\n.right-info {\r\n  display: flex;\r\n  align-items: center;\r\n  \r\n}\r\n\r\n.server-info {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 6px;\r\n  font-size: 10px;\r\n  color: var(--text-secondary);\r\n  background: var(--bg-card);\r\n  padding: 3px 8px;\r\n  border-radius: 10px;\r\n  border: 1px solid var(--border-primary);\r\n  backdrop-filter: blur(8px);\r\n  text-shadow: var(--text-glow-accent);\r\n  font-weight: 500;\r\n  white-space: nowrap;\r\n  opacity: 1;\r\n  transform: translateY(0);\r\n  transition: all 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n}\r\n\r\n.server-info.fade-out {\r\n  opacity: 0;\r\n  transform: translateY(-10px);\r\n}\r\n\r\n.server-info-text {\r\n  font-size: 10px;\r\n  line-height: 1.2;\r\n}\r\n\r\n.close-btn {\r\n  background: none;\r\n  border: none;\r\n  color: var(--text-secondary);\r\n  font-size: 12px;\r\n  cursor: pointer;\r\n  width: 16px;\r\n  height: 16px;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  border-radius: 50%;\r\n  transition: all 0.2s ease;\r\n  opacity: 0.7;\r\n  line-height: 1;\r\n  font-weight: bold;\r\n}\r\n\r\n.close-btn:hover {\r\n  background: var(--bg-secondary);\r\n  color: var(--text-primary);\r\n  opacity: 1;\r\n  transform: scale(1.1);\r\n}\r\n\r\n/* 顶部导航栏 */\r\n.header {\r\n  background: var(--bg-secondary);\r\n  backdrop-filter: blur(24px) saturate(180%);\r\n  border-bottom: 1px solid var(--border-primary);\r\n  padding: 0 12px;\r\n  z-index: 100;\r\n  position: relative;\r\n  box-shadow: \r\n    0 1px 0 var(--border-primary) inset,\r\n    0 4px 24px var(--shadow-primary),\r\n    0 0 0 1px rgba(255, 255, 255, 0.05);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.header-content {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: space-between;\r\n  height: 40px;\r\n  max-width: 2440px;\r\n  margin: 0;\r\n  position: relative;\r\n  z-index: 1;\r\n  gap: 16px;\r\n}\r\n\r\n/* 控制按钮组 */\r\n.control-buttons {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 12px;\r\n}\r\n\r\n/* 智能体和主题切换按钮样式 */\r\n.ai-agent-switcher, .theme-switcher {\r\n  display: flex;\r\n  align-items: center;\r\n}\r\n\r\n.ai-agent-btn, .theme-toggle-btn {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 6px;\r\n  padding: 6px 12px;\r\n  border: 1px solid var(--border-primary);\r\n  background: var(--bg-card);\r\n  backdrop-filter: blur(16px);\r\n  border-radius: 20px;\r\n  cursor: pointer;\r\n  transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);\r\n  font-size: 11px;\r\n  font-weight: 500;\r\n  color: var(--text-secondary);\r\n  position: relative;\r\n  overflow: hidden;\r\n  min-width: 60px;\r\n  box-shadow: 0 2px 8px var(--shadow-primary);\r\n}\r\n\r\n.ai-agent-btn {\r\n  min-width: 80px;\r\n}\r\n\r\n.ai-agent-btn:hover, .theme-toggle-btn:hover:not(:disabled) {\r\n  border-color: var(--border-accent);\r\n  background: var(--bg-panel);\r\n  color: var(--text-primary);\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  transform: translateY(-1px);\r\n}\r\n\r\n.ai-icon-container, .theme-icon-container {\r\n  position: relative;\r\n  width: 16px;\r\n  height: 16px;\r\n  border-radius: 50%;\r\n  background: var(--bg-secondary);\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  transition: all 0.3s ease;\r\n  border: 1px solid var(--border-primary);\r\n}\r\n\r\n.ai-icon-container.connected, .theme-icon-container {\r\n  background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));\r\n  border-color: var(--accent-primary);\r\n  box-shadow: 0 0 8px var(--shadow-accent);\r\n}\r\n\r\n.ai-icon-container .icon-ai-agent, .theme-icon {\r\n  font-size: 10px;\r\n  color: #ffffff;\r\n  transition: all 0.3s ease;\r\n  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);\r\n}\r\n\r\n.connection-status {\r\n  position: absolute;\r\n  top: 2px;\r\n  right: 2px;\r\n  width: 6px;\r\n  height: 6px;\r\n  border-radius: 50%;\r\n  background: #9ca3af;\r\n  transition: all 0.3s ease;\r\n  opacity: 0.8;\r\n}\r\n\r\n.connection-status.active {\r\n  background: #40e0d0;\r\n  box-shadow: 0 0 8px rgba(64, 224, 208, 0.5);\r\n}\r\n\r\n/* 主内容区域 */\r\n.main-content {\r\n  flex: 1;\r\n  overflow: hidden;\r\n  padding: 8px 12px 12px;\r\n  position: relative;\r\n  z-index: 1;\r\n  background: var(--bg-primary);\r\n}\r\n\r\n.content-panel {\r\n  height: 100%;\r\n  background: var(--bg-panel);\r\n  backdrop-filter: blur(24px) saturate(180%);\r\n  border-radius: 16px;\r\n  border: 1px solid var(--border-primary);\r\n  overflow: hidden;\r\n  box-shadow: \r\n    0 16px 64px var(--shadow-primary),\r\n    0 0 0 1px rgba(255, 255, 255, 0.05) inset,\r\n    0 2px 0 var(--border-primary) inset;\r\n  position: relative;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n/* Hierarchy 面板 */\r\n.hierarchy-panel {\r\n  display: flex;\r\n  flex-direction: column;\r\n}\r\n\r\n.hierarchy-content {\r\n  display: flex;\r\n  height: 100%;\r\n}\r\n\r\n.tree-panel, .inspector-panel {\r\n  display: flex;\r\n  flex-direction: column;\r\n  background: var(--bg-card);\r\n  backdrop-filter: blur(16px);\r\n  position: relative;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.tree-panel {\r\n  flex: 1;\r\n  min-width: 320px;\r\n  max-width: 50%;\r\n  border-right: 1px solid var(--border-primary);\r\n  position: relative;\r\n}\r\n\r\n.inspector-panel {\r\n  flex: 1;\r\n  min-width: 320px;\r\n}\r\n\r\n.panel-header {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: space-between;\r\n  padding: 12px 16px;\r\n  border-bottom: 1px solid var(--border-primary);\r\n  background: var(--bg-secondary);\r\n  backdrop-filter: blur(16px);\r\n  position: relative;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.panel-header h3 {\r\n  font-size: 15px;\r\n  font-weight: 600;\r\n  color: var(--text-primary);\r\n  margin: 0;\r\n  letter-spacing: -0.022em;\r\n  text-shadow: var(--text-glow);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.panel-actions {\r\n  display: flex;\r\n  gap: 8px;\r\n}\r\n\r\n.action-btn {\r\n  width: 32px;\r\n  height: 32px;\r\n  border: 1px solid var(--border-accent);\r\n  background: var(--bg-card);\r\n  border-radius: 8px;\r\n  cursor: pointer;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n  font-size: 14px;\r\n  color: var(--text-secondary);\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  position: relative;\r\n  overflow: hidden;\r\n}\r\n\r\n.action-btn:hover {\r\n  background: var(--bg-panel);\r\n  color: var(--text-primary);\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 8px 32px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset,\r\n    0 0 16px var(--shadow-accent) inset;\r\n  transform: translateY(-1px);\r\n  text-shadow: var(--text-glow-accent);\r\n}\r\n\r\n.action-btn.refreshing {\r\n  pointer-events: none;\r\n  opacity: 0.7;\r\n}\r\n\r\n.action-btn.refreshing i {\r\n  animation: refreshSpin 1s linear infinite;\r\n}\r\n\r\n.action-btn:disabled {\r\n  opacity: 0.6;\r\n  cursor: not-allowed;\r\n  pointer-events: none;\r\n}\r\n\r\n.action-btn.active {\r\n  background: var(--accent-primary);\r\n  color: #ffffff;\r\n  border-color: var(--accent-primary);\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--accent-primary) inset,\r\n    0 0 12px var(--shadow-accent) inset;\r\n  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);\r\n}\r\n\r\n.action-btn.active:hover {\r\n  background: var(--accent-secondary);\r\n  border-color: var(--accent-secondary);\r\n}\r\n\r\n@keyframes refreshSpin {\r\n  from { transform: rotate(0deg); }\r\n  to { transform: rotate(360deg); }\r\n}\r\n\r\n.tree-container {\r\n  flex: 1;\r\n  overflow: auto;\r\n  padding: 8px;\r\n  background: var(--bg-card);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n/* 属性检查器 */\r\n.inspector-content {\r\n  flex: 1;\r\n  overflow: auto;\r\n  padding: 16px;\r\n  background: var(--bg-card);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.node-info {\r\n  background: var(--bg-panel);\r\n  backdrop-filter: blur(16px);\r\n  border-radius: 12px;\r\n  padding: 12px;\r\n  margin-bottom: 16px;\r\n  border: 1px solid var(--border-primary);\r\n  box-shadow: \r\n    0 8px 32px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset,\r\n    0 2px 0 var(--border-primary) inset;\r\n  position: relative;\r\n  overflow: hidden;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.node-title {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 8px;\r\n  font-size: 16px;\r\n  font-weight: 600;\r\n  color: var(--text-primary);\r\n  margin-bottom: 6px;\r\n  letter-spacing: -0.024em;\r\n  text-shadow: var(--text-glow);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.node-type {\r\n  font-size: 13px;\r\n  color: var(--accent-secondary);\r\n  background: var(--bg-card);\r\n  backdrop-filter: blur(8px);\r\n  display: inline-block;\r\n  padding: 6px 16px;\r\n  border-radius: 20px;\r\n  font-weight: 500;\r\n  letter-spacing: -0.008em;\r\n  border: 1px solid var(--border-accent);\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 8px var(--shadow-accent) inset;\r\n  text-shadow: var(--text-glow-accent);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.properties-section, .transform-section {\r\n  margin-bottom: 20px;\r\n}\r\n\r\n.section-header {\r\n  margin-bottom: 12px;\r\n  padding-bottom: 8px;\r\n  border-bottom: 1px solid var(--border-primary);\r\n  position: relative;\r\n}\r\n\r\n.section-header h4 {\r\n  font-size: 15px;\r\n  font-weight: 600;\r\n  color: var(--text-primary);\r\n  margin: 0;\r\n  letter-spacing: -0.016em;\r\n  text-shadow: var(--text-glow-secondary);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.property-group {\r\n  display: flex;\r\n  flex-direction: column;\r\n  gap: 12px;\r\n}\r\n\r\n.property-item {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 12px;\r\n  padding: 2px 0;\r\n}\r\n\r\n.property-label {\r\n  min-width: 80px;\r\n  font-size: 13px;\r\n  color: var(--text-secondary);\r\n  font-weight: 500;\r\n  letter-spacing: -0.006em;\r\n  text-shadow: var(--text-glow-accent);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.property-input {\r\n  flex: 1;\r\n  padding: 8px 12px;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 8px;\r\n  font-size: 13px;\r\n  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n  background: var(--bg-card);\r\n  backdrop-filter: blur(8px);\r\n  color: var(--text-primary);\r\n  font-family: inherit;\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n}\r\n\r\n.property-input:focus {\r\n  outline: none;\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 0 0 4px var(--shadow-accent),\r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset,\r\n    0 0 16px var(--shadow-accent) inset;\r\n  background: var(--bg-panel);\r\n  transform: translateY(-1px);\r\n  text-shadow: var(--text-glow-accent);\r\n}\r\n\r\n.transform-grid {\r\n  display: flex;\r\n  flex-direction: column;\r\n  gap: 12px;\r\n}\r\n\r\n.transform-row {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 12px;\r\n  padding: 6px 12px;\r\n  background: var(--bg-card);\r\n  backdrop-filter: blur(8px);\r\n  border-radius: 10px;\r\n  border: 1px solid var(--border-primary);\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  transition: all 0.3s ease;\r\n}\r\n\r\n.transform-row label {\r\n  min-width: 60px;\r\n  font-size: 13px;\r\n  color: var(--text-secondary);\r\n  font-weight: 500;\r\n  letter-spacing: -0.006em;\r\n  text-shadow: var(--text-glow-accent);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.vector-input {\r\n  display: flex;\r\n  gap: 8px;\r\n  flex: 1;\r\n}\r\n\r\n.vector-input input {\r\n  flex: 1;\r\n  padding: 8px 12px;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 8px;\r\n  font-size: 13px;\r\n  text-align: center;\r\n  background: var(--bg-card);\r\n  backdrop-filter: blur(8px);\r\n  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n  color: var(--text-primary);\r\n  font-family: 'SF Mono', Monaco, 'Cascadia Code', 'Roboto Mono', Consolas, 'Courier New', monospace;\r\n  font-variant-numeric: tabular-nums;\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n}\r\n\r\n.vector-input input:focus {\r\n  outline: none;\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 0 0 3px var(--shadow-accent),\r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset,\r\n    0 0 12px var(--shadow-accent) inset;\r\n  background: var(--bg-panel);\r\n  transform: translateY(-1px);\r\n  text-shadow: var(--text-glow-accent);\r\n}\r\n\r\n.no-selection {\r\n  display: flex;\r\n  flex-direction: column;\r\n  align-items: center;\r\n  justify-content: center;\r\n  height: 240px;\r\n  color: var(--text-secondary);\r\n  text-align: center;\r\n  background: var(--bg-card);\r\n  backdrop-filter: blur(16px);\r\n  border-radius: 16px;\r\n  border: 1px solid var(--border-primary);\r\n  box-shadow: \r\n    0 8px 32px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.no-selection i {\r\n  font-size: 48px;\r\n  margin-bottom: 16px;\r\n  opacity: 0.8;\r\n  color: var(--text-accent);\r\n  filter: drop-shadow(0 0 8px var(--shadow-accent));\r\n  animation: pulse 3s ease-in-out infinite;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.no-selection p {\r\n  font-size: 15px;\r\n  letter-spacing: -0.016em;\r\n  text-shadow: var(--text-glow-accent);\r\n  font-weight: 500;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n/* 待开发页面 */\r\n.coming-soon {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  background: radial-gradient(circle at center, rgba(14, 165, 233, 0.08) 0%, transparent 70%);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.coming-soon-content {\r\n  text-align: center;\r\n  padding: 48px;\r\n  max-width: 480px;\r\n  background: var(--bg-panel);\r\n  backdrop-filter: blur(24px);\r\n  border-radius: 24px;\r\n  border: 1px solid var(--border-accent);\r\n  box-shadow: \r\n    0 16px 64px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset,\r\n    0 4px 0 var(--border-primary) inset;\r\n  position: relative;\r\n  overflow: hidden;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.coming-soon-content i {\r\n  font-size: 64px;\r\n  margin-bottom: 24px;\r\n  opacity: 0.9;\r\n  color: var(--text-accent);\r\n  filter: drop-shadow(0 0 16px var(--shadow-accent));\r\n  animation: pulse 2s ease-in-out infinite;\r\n  text-shadow: var(--text-glow);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.coming-soon-content h2 {\r\n  font-size: 28px;\r\n  font-weight: 600;\r\n  color: var(--text-primary);\r\n  margin-bottom: 16px;\r\n  letter-spacing: -0.032em;\r\n  text-shadow: var(--text-glow);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.coming-soon-content p {\r\n  color: var(--text-secondary);\r\n  margin-bottom: 32px;\r\n  font-size: 17px;\r\n  letter-spacing: -0.022em;\r\n  line-height: 1.47;\r\n  text-shadow: var(--text-glow-secondary);\r\n  font-weight: 500;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.progress-indicator {\r\n  width: 100%;\r\n  height: 6px;\r\n  background: var(--bg-card);\r\n  border-radius: 3px;\r\n  overflow: hidden;\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary) inset,\r\n    0 0 0 1px var(--border-primary);\r\n  border: 1px solid var(--border-primary);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.progress-bar {\r\n  height: 100%;\r\n  background: linear-gradient(90deg, var(--accent-primary), var(--accent-secondary), #8a2be2);\r\n  border-radius: 3px;\r\n  animation: aiProgress 2.5s ease-in-out infinite;\r\n  box-shadow: \r\n    0 0 16px var(--shadow-accent),\r\n    0 0 8px var(--shadow-accent) inset;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n@keyframes aiProgress {\r\n  0% {\r\n    width: 0%;\r\n    margin-left: 0%;\r\n  }\r\n  50% {\r\n    width: 70%;\r\n    margin-left: 30%;\r\n  }\r\n  100% {\r\n    width: 0%;\r\n    margin-left: 100%;\r\n  }\r\n}\r\n\r\n/* 引擎帮助信息样式 */\r\n.engine-help {\r\n  position: absolute;\r\n  top: 50%;\r\n  left: 50%;\r\n  transform: translate(-50%, -50%);\r\n  width: 100%;\r\n  max-width: 400px;\r\n  padding: 0 20px;\r\n}\r\n\r\n.help-content {\r\n  background: var(--bg-panel);\r\n  backdrop-filter: blur(24px);\r\n  border-radius: 16px;\r\n  padding: 32px;\r\n  border: 1px solid var(--border-primary);\r\n  box-shadow: \r\n    0 16px 64px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  text-align: center;\r\n}\r\n\r\n.help-content i {\r\n  font-size: 64px;\r\n  margin-bottom: 24px;\r\n  opacity: 0.9;\r\n  color: var(--text-accent);\r\n  filter: drop-shadow(0 0 16px var(--shadow-accent));\r\n  animation: pulse 2s ease-in-out infinite;\r\n}\r\n\r\n.help-title {\r\n  font-size: 18px;\r\n  font-weight: 600;\r\n  color: var(--text-primary);\r\n  margin-bottom: 20px;\r\n  text-shadow: var(--text-glow);\r\n}\r\n\r\n.help-details {\r\n  text-align: left;\r\n}\r\n\r\n.help-details .help-text {\r\n  font-size: 13px;\r\n  color: var(--text-secondary);\r\n  margin-bottom: 12px;\r\n  line-height: 1.5;\r\n  text-shadow: var(--text-glow-secondary);\r\n  font-weight: 500;\r\n}\r\n\r\n.help-details .help-list {\r\n  list-style: none;\r\n  padding: 0;\r\n  margin: 16px 0;\r\n  background: var(--bg-card);\r\n  border-radius: 8px;\r\n  padding: 12px;\r\n  border: 1px solid var(--border-primary);\r\n  box-shadow: 0 2px 8px var(--shadow-primary);\r\n}\r\n\r\n.help-details .help-list li {\r\n  font-size: 12px;\r\n  color: var(--text-secondary);\r\n  margin-bottom: 8px;\r\n  padding: 4px 0;\r\n  border-bottom: 1px solid var(--border-primary);\r\n  text-shadow: var(--text-glow-secondary);\r\n  font-weight: 500;\r\n}\r\n\r\n.help-details .help-list li:last-child {\r\n  border-bottom: none;\r\n  margin-bottom: 0;\r\n}\r\n\r\n@keyframes pulse {\r\n  0%, 100% { \r\n    opacity: 0.8; \r\n    transform: scale(1);\r\n  }\r\n  50% { \r\n    opacity: 1; \r\n    transform: scale(1.08);\r\n  }\r\n}\r\n\r\n/* 主题转换特效 - 平滑渐变 */\r\n.theme-transitioning {\r\n  position: relative;\r\n  overflow: hidden;\r\n}\r\n\r\n.theme-transition-overlay {\r\n  position: fixed;\r\n  top: 0;\r\n  left: 0;\r\n  width: 100vw;\r\n  height: 100vh;\r\n  z-index: 9999;\r\n  pointer-events: none;\r\n  opacity: 0;\r\n  transition: opacity 0.3s cubic-bezier(0.4, 0, 0.2, 1);\r\n  backdrop-filter: blur(8px);\r\n}\r\n\r\n.theme-transition-overlay.fade-to-light {\r\n  background: linear-gradient(\r\n    135deg,\r\n    rgba(10, 14, 23, 0.95) 0%,\r\n    rgba(26, 31, 41, 0.9) 20%,\r\n    rgba(64, 74, 88, 0.8) 40%,\r\n    rgba(148, 163, 184, 0.7) 60%,\r\n    rgba(203, 213, 224, 0.6) 80%,\r\n    rgba(248, 250, 252, 0.5) 100%\r\n  );\r\n}\r\n\r\n.theme-transition-overlay.fade-to-dark {\r\n  background: linear-gradient(\r\n    135deg,\r\n    rgba(248, 250, 252, 0.95) 0%,\r\n    rgba(203, 213, 224, 0.9) 20%,\r\n    rgba(148, 163, 184, 0.8) 40%,\r\n    rgba(64, 74, 88, 0.7) 60%,\r\n    rgba(26, 31, 41, 0.6) 80%,\r\n    rgba(10, 14, 23, 0.5) 100%\r\n  );\r\n}\r\n\r\n.theme-transition-overlay.active {\r\n  opacity: 1;\r\n}\r\n\r\n/* 确认弹窗样式 */\r\n.modal-overlay {\r\n  position: fixed;\r\n  top: 0;\r\n  left: 0;\r\n  width: 100%;\r\n  height: 100%;\r\n  background: rgba(0, 0, 0, 0.6);\r\n  backdrop-filter: blur(8px);\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  z-index: 10000;\r\n  animation: fadeIn 0.3s ease;\r\n}\r\n\r\n.modal-container {\r\n  background: var(--bg-panel);\r\n  backdrop-filter: blur(24px);\r\n  border-radius: 16px;\r\n  border: 1px solid var(--border-primary);\r\n  box-shadow: \r\n    0 16px 64px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  max-width: 480px;\r\n  width: 90%;\r\n  max-height: 80vh;\r\n  overflow: hidden;\r\n  animation: slideIn 0.3s ease;\r\n}\r\n\r\n.modal-header {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: space-between;\r\n  padding: 20px 24px 16px;\r\n  border-bottom: 1px solid var(--border-primary);\r\n  background: var(--bg-secondary);\r\n}\r\n\r\n.modal-header h3 {\r\n  margin: 0;\r\n  font-size: 18px;\r\n  font-weight: 600;\r\n  color: var(--text-primary);\r\n  text-shadow: var(--text-glow);\r\n}\r\n\r\n.modal-close-btn {\r\n  background: none;\r\n  border: none;\r\n  color: var(--text-secondary);\r\n  font-size: 20px;\r\n  cursor: pointer;\r\n  width: 32px;\r\n  height: 32px;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  border-radius: 50%;\r\n  transition: all 0.2s ease;\r\n}\r\n\r\n.modal-close-btn:hover {\r\n  background: var(--bg-card);\r\n  color: var(--text-primary);\r\n  transform: scale(1.1);\r\n}\r\n\r\n.modal-content {\r\n  padding: 24px;\r\n  text-align: center;\r\n}\r\n\r\n.warning-icon {\r\n  font-size: 48px;\r\n  margin-bottom: 16px;\r\n  animation: pulse 2s ease-in-out infinite;\r\n}\r\n\r\n.warning-text {\r\n  font-size: 16px;\r\n  color: var(--text-primary);\r\n  margin-bottom: 12px;\r\n  line-height: 1.5;\r\n  text-shadow: var(--text-glow);\r\n}\r\n\r\n.confirm-text {\r\n  font-size: 14px;\r\n  color: var(--text-secondary);\r\n  margin-bottom: 0;\r\n  font-weight: 500;\r\n}\r\n\r\n.modal-footer {\r\n  display: flex;\r\n  gap: 12px;\r\n  padding: 16px 24px 24px;\r\n  justify-content: center;\r\n}\r\n\r\n.cancel-btn, .confirm-btn {\r\n  padding: 10px 20px;\r\n  border-radius: 8px;\r\n  font-size: 14px;\r\n  font-weight: 500;\r\n  cursor: pointer;\r\n  transition: all 0.3s ease;\r\n  border: 1px solid var(--border-primary);\r\n  min-width: 80px;\r\n}\r\n\r\n.cancel-btn {\r\n  background: var(--bg-card);\r\n  color: var(--text-secondary);\r\n}\r\n\r\n.cancel-btn:hover {\r\n  background: var(--bg-panel);\r\n  color: var(--text-primary);\r\n  border-color: var(--border-accent);\r\n}\r\n\r\n.confirm-btn {\r\n  background: linear-gradient(135deg, #ff6b6b, #ee5a52);\r\n  color: #ffffff;\r\n  border-color: #ff6b6b;\r\n  box-shadow: 0 4px 16px rgba(255, 107, 107, 0.3);\r\n}\r\n\r\n.confirm-btn:hover {\r\n  background: linear-gradient(135deg, #ff5252, #e53935);\r\n  border-color: #ff5252;\r\n  box-shadow: 0 6px 20px rgba(255, 107, 107, 0.4);\r\n  transform: translateY(-1px);\r\n}\r\n\r\n@keyframes fadeIn {\r\n  from { opacity: 0; }\r\n  to { opacity: 1; }\r\n}\r\n\r\n@keyframes slideIn {\r\n  from {\r\n    opacity: 0;\r\n    transform: translateY(-20px) scale(0.95);\r\n  }\r\n  to {\r\n    opacity: 1;\r\n    transform: translateY(0) scale(1);\r\n  }\r\n}\r\n\r\n/* 反馈弹窗样式 */\r\n.feedback-modal {\r\n  max-width: 400px;\r\n  width: 90%;\r\n}\r\n\r\n.feedback-content {\r\n  padding: 20px;\r\n  text-align: center;\r\n}\r\n\r\n.qrcode-container {\r\n  margin-bottom: 20px;\r\n  display: flex;\r\n  justify-content: center;\r\n  align-items: center;\r\n}\r\n\r\n.qrcode-image {\r\n  width: 280px;\r\n  height: 280px;\r\n  border-radius: 12px;\r\n  box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);\r\n  border: 2px solid var(--border-primary);\r\n  transition: all 0.3s ease;\r\n}\r\n\r\n.qrcode-image:hover {\r\n  transform: scale(1.05);\r\n  box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);\r\n}\r\n\r\n.feedback-text {\r\n  color: var(--text-primary);\r\n}\r\n\r\n.feedback-text h4 {\r\n  margin: 0 0 12px 0;\r\n  font-size: 18px;\r\n  font-weight: 600;\r\n  color: var(--text-primary);\r\n}\r\n\r\n.feedback-text p {\r\n  margin: 8px 0;\r\n  font-size: 14px;\r\n  line-height: 1.5;\r\n  color: var(--text-secondary);\r\n}\r\n\r\n.feedback-text p:first-of-type {\r\n  font-weight: 500;\r\n  color: var(--text-primary);\r\n}\r\n\r\n/* 反馈按钮样式 */\r\n.feedback-btn {\r\n  background: var(--bg-card);\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 2px;\r\n  padding: 2px 2px;\r\n  color: var(--text-secondary);\r\n  cursor: pointer;\r\n  transition: all 0.2s ease;\r\n  font-size: 14px;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  min-width: 18px;\r\n  height: 18px;\r\n}\r\n\r\n.feedback-btn:hover {\r\n  background: var(--bg-panel);\r\n  color: var(--text-primary);\r\n  border-color: var(--border-accent);\r\n  transform: translateY(-1px);\r\n  box-shadow: 0 2px 2px var(--shadow-primary);\r\n}\r\n\r\n.feedback-btn .icon-feedback {\r\n  font-size: 16px;\r\n  padding-bottom: 5px;\r\n}\r\n</style>"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/CustomDropdown.vue?vue&type=style&index=0&id=4611b98b&scoped=true&lang=css":
/*!************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/CustomDropdown.vue?vue&type=style&index=0&id=4611b98b&scoped=true&lang=css ***!
  \************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
.custom-dropdown[data-v-4611b98b] {
  position: relative;
  flex: 1;
}
.dropdown-trigger[data-v-4611b98b] {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 8px 12px;
  border: 1px solid var(--border-primary);
  border-radius: 8px;
  font-size: 13px;
  background: var(--bg-card);
  backdrop-filter: blur(8px);
  color: var(--text-primary);
  font-family: inherit;
  cursor: pointer;
  box-shadow: 
    0 2px 8px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  min-height: 36px;
}
.dropdown-trigger[data-v-4611b98b]:hover {
  border-color: var(--border-accent);
  box-shadow: 
    0 4px 12px var(--shadow-accent),
    0 0 0 1px var(--border-primary) inset;
}
.dropdown-open .dropdown-trigger[data-v-4611b98b] {
  border-color: var(--border-accent);
  box-shadow: 
    0 0 0 3px var(--shadow-accent),
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset;
  background: var(--bg-panel);
  transform: translateY(-1px);
  text-shadow: var(--text-glow-accent);
}
.dropdown-value[data-v-4611b98b] {
  flex: 1;
  text-align: left;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
}
.dropdown-arrow[data-v-4611b98b] {
  font-size: 10px;
  color: var(--text-secondary);
  transition: all 0.3s ease;
  margin-left: 8px;
  flex-shrink: 0;
}
.dropdown-arrow.rotated[data-v-4611b98b] {
  transform: rotate(180deg);
  color: var(--text-accent);
}
.dropdown-menu[data-v-4611b98b] {
  position: absolute;
  top: 100%;
  left: 0;
  right: 0;
  z-index: 1000;
  background: var(--bg-panel);
  backdrop-filter: blur(16px);
  border: 1px solid var(--border-accent);
  border-radius: 8px;
  margin-top: 4px;
  box-shadow: 
    0 8px 32px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset;
  overflow: hidden;
  animation: dropdownOpen-4611b98b 0.2s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.dropdown-option[data-v-4611b98b] {
  padding: 8px 12px;
  font-size: 13px;
  color: var(--text-primary);
  cursor: pointer;
  transition: all 0.2s ease;
  background: transparent;
  border-bottom: 1px solid var(--border-primary);
  font-family: inherit;
}
.dropdown-option[data-v-4611b98b]:last-child {
  border-bottom: none;
}
.dropdown-option[data-v-4611b98b]:hover {
  background: var(--bg-hover, linear-gradient(135deg, rgba(0, 162, 255, 0.1), rgba(64, 224, 208, 0.05)));
  color: var(--text-accent);
  text-shadow: var(--text-glow-accent);
  transform: translateX(2px);
}
.dropdown-option.selected[data-v-4611b98b] {
  background: var(--bg-selected, linear-gradient(135deg, rgba(0, 162, 255, 0.15), rgba(64, 224, 208, 0.1)));
  color: var(--text-accent);
  font-weight: 600;
  text-shadow: var(--text-glow-accent);
}
.dropdown-option.selected[data-v-4611b98b]:hover {
  background: var(--bg-selected, linear-gradient(135deg, rgba(0, 162, 255, 0.2), rgba(64, 224, 208, 0.15)));
}
@keyframes dropdownOpen-4611b98b {
from {
    opacity: 0;
    transform: translateY(-8px) scale(0.95);
}
to {
    opacity: 1;
    transform: translateY(0) scale(1);
}
}

/* 深色模式变量回退 */
.custom-dropdown[data-v-4611b98b] {
  --bg-hover: linear-gradient(135deg, rgba(0, 162, 255, 0.08), rgba(64, 224, 208, 0.04));
  --bg-selected: linear-gradient(135deg, rgba(0, 162, 255, 0.15), rgba(64, 224, 208, 0.1));
}

/* 浅色模式适配 */
.layatree-panel.light-mode {
  --bg-hover: linear-gradient(135deg, rgba(0, 0, 0, 0.04), rgba(0, 0, 0, 0.02));
  --bg-selected: linear-gradient(135deg, rgba(0, 0, 0, 0.08), rgba(0, 0, 0, 0.05));
}

/* 禁用状态样式 */
.dropdown-trigger.disabled[data-v-4611b98b] {
  opacity: 0.7;
  cursor: not-allowed;
  background: var(--bg-disabled, rgba(128, 128, 128, 0.15));
  color: var(--text-primary);
  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));
  pointer-events: none;
}
.dropdown-trigger.disabled[data-v-4611b98b]:hover {
  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));
  box-shadow: 
    0 2px 8px var(--shadow-primary),
    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;
  transform: none;
}
.custom-dropdown.disabled .dropdown-arrow[data-v-4611b98b] {
  color: var(--text-secondary);
}

/* 深色模式下的禁用状态 */
.layatree-panel:not(.light-mode) {
  background: var(--bg-disabled, rgba(80, 80, 80, 0.3));
  color: var(--text-primary);
  border-color: var(--border-disabled, rgba(150, 150, 150, 0.4));
}
.layatree-panel:not(.light-mode) {
  color: var(--text-secondary);
}
`, "",{"version":3,"sources":["webpack://./src/devtools/components/CustomDropdown.vue"],"names":[],"mappings":";AA2FA;EACE,kBAAkB;EAClB,OAAO;AACT;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,iBAAiB;EACjB,uCAAuC;EACvC,kBAAkB;EAClB,eAAe;EACf,0BAA0B;EAC1B,0BAA0B;EAC1B,0BAA0B;EAC1B,oBAAoB;EACpB,eAAe;EACf;;yCAEuC;EACvC,yDAAyD;EACzD,gBAAgB;AAClB;AAEA;EACE,kCAAkC;EAClC;;yCAEuC;AACzC;AAEA;EACE,kCAAkC;EAClC;;;wCAGsC;EACtC,2BAA2B;EAC3B,2BAA2B;EAC3B,oCAAoC;AACtC;AAEA;EACE,OAAO;EACP,gBAAgB;EAChB,gBAAgB;EAChB,uBAAuB;EACvB,mBAAmB;AACrB;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,yBAAyB;EACzB,gBAAgB;EAChB,cAAc;AAChB;AAEA;EACE,yBAAyB;EACzB,yBAAyB;AAC3B;AAEA;EACE,kBAAkB;EAClB,SAAS;EACT,OAAO;EACP,QAAQ;EACR,aAAa;EACb,2BAA2B;EAC3B,2BAA2B;EAC3B,sCAAsC;EACtC,kBAAkB;EAClB,eAAe;EACf;;wCAEsC;EACtC,gBAAgB;EAChB,0EAAiE;AACnE;AAEA;EACE,iBAAiB;EACjB,eAAe;EACf,0BAA0B;EAC1B,eAAe;EACf,yBAAyB;EACzB,uBAAuB;EACvB,8CAA8C;EAC9C,oBAAoB;AACtB;AAEA;EACE,mBAAmB;AACrB;AAEA;EACE,sGAAsG;EACtG,yBAAyB;EACzB,oCAAoC;EACpC,0BAA0B;AAC5B;AAEA;EACE,yGAAyG;EACzG,yBAAyB;EACzB,gBAAgB;EAChB,oCAAoC;AACtC;AAEA;EACE,yGAAyG;AAC3G;AAEA;AACE;IACE,UAAU;IACV,uCAAuC;AACzC;AACA;IACE,UAAU;IACV,iCAAiC;AACnC;AACF;;AAEA,aAAa;AACb;EACE,sFAAsF;EACtF,wFAAwF;AAC1F;;AAEA,WAAW;AACX;EACE,6EAA6E;EAC7E,gFAAgF;AAClF;;AAEA,WAAW;AACX;EACE,YAAY;EACZ,mBAAmB;EACnB,yDAAyD;EACzD,0BAA0B;EAC1B,8DAA8D;EAC9D,oBAAoB;AACtB;AAEA;EACE,8DAA8D;EAC9D;;oEAEkE;EAClE,eAAe;AACjB;AAEA;EACE,4BAA4B;AAC9B;;AAEA,eAAe;AACf;EACE,qDAAqD;EACrD,0BAA0B;EAC1B,8DAA8D;AAChE;AAEA;EACE,4BAA4B;AAC9B","sourcesContent":["<template>\r\n  <div class=\"custom-dropdown\" :class=\"{ 'dropdown-open': isOpen, 'disabled': disabled }\">\r\n    <div \r\n      class=\"dropdown-trigger\"\r\n      @click=\"toggleDropdown\"\r\n      :title=\"selectedOption || '请选择'\"\r\n      :class=\"{ 'disabled': disabled }\"\r\n    >\r\n      <span class=\"dropdown-value\">{{ selectedOption }}</span>\r\n      <i class=\"dropdown-arrow\" :class=\"{ 'rotated': isOpen }\">▼</i>\r\n    </div>\r\n    \r\n    <div v-if=\"isOpen\" class=\"dropdown-menu\">\r\n      <div \r\n        v-for=\"(option, index) in options\" \r\n        :key=\"option\"\r\n        class=\"dropdown-option\"\r\n        :class=\"{ 'selected': selectedIndex === index }\"\r\n        @click=\"selectOption(index)\"\r\n      >\r\n        {{ option }}\r\n      </div>\r\n    </div>\r\n  </div>\r\n</template>\r\n\r\n<script setup lang=\"ts\">\r\nimport { ref, computed, onMounted, onUnmounted } from 'vue';\r\n\r\n// Props\r\ninterface Props {\r\n  value: number | string;\r\n  options: string[];\r\n  disabled?: boolean;\r\n}\r\n\r\nconst props = withDefaults(defineProps<Props>(), {\r\n  disabled: false\r\n});\r\n\r\n// Emits\r\nconst emit = defineEmits<{\r\n  change: [value: number];\r\n}>();\r\n\r\n// 响应式状态\r\nconst isOpen = ref(false);\r\n\r\n// 计算属性\r\nconst selectedIndex = computed(() => {\r\n  if (typeof props.value === 'number') {\r\n    return props.value;\r\n  }\r\n  return props.options.indexOf(props.value);\r\n});\r\n\r\nconst selectedOption = computed(() => {\r\n  const index = selectedIndex.value;\r\n  return index >= 0 && index < props.options.length ? props.options[index] : '';\r\n});\r\n\r\n// 方法\r\nconst toggleDropdown = () => {\r\n  if (props.disabled) return;\r\n  isOpen.value = !isOpen.value;\r\n};\r\n\r\nconst selectOption = (index: number) => {\r\n  if (props.disabled) return;\r\n  emit('change', index);\r\n  isOpen.value = false;\r\n};\r\n\r\nconst closeDropdown = (event: MouseEvent) => {\r\n  const target = event.target as HTMLElement;\r\n  if (!target.closest('.custom-dropdown')) {\r\n    isOpen.value = false;\r\n  }\r\n};\r\n\r\n// 生命周期\r\nonMounted(() => {\r\n  document.addEventListener('click', closeDropdown);\r\n});\r\n\r\nonUnmounted(() => {\r\n  document.removeEventListener('click', closeDropdown);\r\n});\r\n</script>\r\n\r\n<style scoped>\r\n.custom-dropdown {\r\n  position: relative;\r\n  flex: 1;\r\n}\r\n\r\n.dropdown-trigger {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: space-between;\r\n  padding: 8px 12px;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 8px;\r\n  font-size: 13px;\r\n  background: var(--bg-card);\r\n  backdrop-filter: blur(8px);\r\n  color: var(--text-primary);\r\n  font-family: inherit;\r\n  cursor: pointer;\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n  min-height: 36px;\r\n}\r\n\r\n.dropdown-trigger:hover {\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 4px 12px var(--shadow-accent),\r\n    0 0 0 1px var(--border-primary) inset;\r\n}\r\n\r\n.dropdown-open .dropdown-trigger {\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 0 0 3px var(--shadow-accent),\r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset;\r\n  background: var(--bg-panel);\r\n  transform: translateY(-1px);\r\n  text-shadow: var(--text-glow-accent);\r\n}\r\n\r\n.dropdown-value {\r\n  flex: 1;\r\n  text-align: left;\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n}\r\n\r\n.dropdown-arrow {\r\n  font-size: 10px;\r\n  color: var(--text-secondary);\r\n  transition: all 0.3s ease;\r\n  margin-left: 8px;\r\n  flex-shrink: 0;\r\n}\r\n\r\n.dropdown-arrow.rotated {\r\n  transform: rotate(180deg);\r\n  color: var(--text-accent);\r\n}\r\n\r\n.dropdown-menu {\r\n  position: absolute;\r\n  top: 100%;\r\n  left: 0;\r\n  right: 0;\r\n  z-index: 1000;\r\n  background: var(--bg-panel);\r\n  backdrop-filter: blur(16px);\r\n  border: 1px solid var(--border-accent);\r\n  border-radius: 8px;\r\n  margin-top: 4px;\r\n  box-shadow: \r\n    0 8px 32px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset;\r\n  overflow: hidden;\r\n  animation: dropdownOpen 0.2s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.dropdown-option {\r\n  padding: 8px 12px;\r\n  font-size: 13px;\r\n  color: var(--text-primary);\r\n  cursor: pointer;\r\n  transition: all 0.2s ease;\r\n  background: transparent;\r\n  border-bottom: 1px solid var(--border-primary);\r\n  font-family: inherit;\r\n}\r\n\r\n.dropdown-option:last-child {\r\n  border-bottom: none;\r\n}\r\n\r\n.dropdown-option:hover {\r\n  background: var(--bg-hover, linear-gradient(135deg, rgba(0, 162, 255, 0.1), rgba(64, 224, 208, 0.05)));\r\n  color: var(--text-accent);\r\n  text-shadow: var(--text-glow-accent);\r\n  transform: translateX(2px);\r\n}\r\n\r\n.dropdown-option.selected {\r\n  background: var(--bg-selected, linear-gradient(135deg, rgba(0, 162, 255, 0.15), rgba(64, 224, 208, 0.1)));\r\n  color: var(--text-accent);\r\n  font-weight: 600;\r\n  text-shadow: var(--text-glow-accent);\r\n}\r\n\r\n.dropdown-option.selected:hover {\r\n  background: var(--bg-selected, linear-gradient(135deg, rgba(0, 162, 255, 0.2), rgba(64, 224, 208, 0.15)));\r\n}\r\n\r\n@keyframes dropdownOpen {\r\n  from {\r\n    opacity: 0;\r\n    transform: translateY(-8px) scale(0.95);\r\n  }\r\n  to {\r\n    opacity: 1;\r\n    transform: translateY(0) scale(1);\r\n  }\r\n}\r\n\r\n/* 深色模式变量回退 */\r\n.custom-dropdown {\r\n  --bg-hover: linear-gradient(135deg, rgba(0, 162, 255, 0.08), rgba(64, 224, 208, 0.04));\r\n  --bg-selected: linear-gradient(135deg, rgba(0, 162, 255, 0.15), rgba(64, 224, 208, 0.1));\r\n}\r\n\r\n/* 浅色模式适配 */\r\n:global(.layatree-panel.light-mode) .custom-dropdown {\r\n  --bg-hover: linear-gradient(135deg, rgba(0, 0, 0, 0.04), rgba(0, 0, 0, 0.02));\r\n  --bg-selected: linear-gradient(135deg, rgba(0, 0, 0, 0.08), rgba(0, 0, 0, 0.05));\r\n}\r\n\r\n/* 禁用状态样式 */\r\n.dropdown-trigger.disabled {\r\n  opacity: 0.7;\r\n  cursor: not-allowed;\r\n  background: var(--bg-disabled, rgba(128, 128, 128, 0.15));\r\n  color: var(--text-primary);\r\n  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));\r\n  pointer-events: none;\r\n}\r\n\r\n.dropdown-trigger.disabled:hover {\r\n  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary),\r\n    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;\r\n  transform: none;\r\n}\r\n\r\n.custom-dropdown.disabled .dropdown-arrow {\r\n  color: var(--text-secondary);\r\n}\r\n\r\n/* 深色模式下的禁用状态 */\r\n:global(.layatree-panel:not(.light-mode)) .dropdown-trigger.disabled {\r\n  background: var(--bg-disabled, rgba(80, 80, 80, 0.3));\r\n  color: var(--text-primary);\r\n  border-color: var(--border-disabled, rgba(150, 150, 150, 0.4));\r\n}\r\n\r\n:global(.layatree-panel:not(.light-mode)) .custom-dropdown.disabled .dropdown-arrow {\r\n  color: var(--text-secondary);\r\n}\r\n</style>"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/EngineInfo.vue?vue&type=style&index=0&id=4f7f5279&scoped=true&lang=css":
/*!********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/EngineInfo.vue?vue&type=style&index=0&id=4f7f5279&scoped=true&lang=css ***!
  \********************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
/* 引擎信息显示区域 */
.engine-info[data-v-4f7f5279] {
  background: var(--bg-secondary);
  backdrop-filter: blur(12px);
  border-bottom: 1px solid var(--border-primary);
  padding: 2px 4px;
  position: relative;
  overflow: hidden;
  opacity: 0.95;
  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}

/* 为引擎信息添加效果 */
.engine-info[data-v-4f7f5279]::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  height: 2px;
  background: linear-gradient(90deg, transparent, var(--accent-primary), var(--accent-secondary), transparent);
  z-index: 1;
  animation: scanLine-4f7f5279 3s ease-in-out infinite;
  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}

/* 浅色模式下使用subtle的扫描线 */
.layatree-panel.light-mode .engine-info[data-v-4f7f5279]::before {
  background: linear-gradient(90deg, transparent, rgba(0, 0, 0, 0.06), rgba(0, 0, 0, 0.04), transparent);
  height: 1px;
  animation: none;
}
@keyframes scanLine-4f7f5279 {
0%, 100% { transform: translateX(-100%); opacity: 0;
}
50% { transform: translateX(100%); opacity: 1;
}
}
.engine-info-content[data-v-4f7f5279] {
  display: flex;
  align-items: center;
  gap: 8px;
  max-width: 1440px;
  margin: 0 auto;
  position: relative;
  z-index: 2;
  justify-content: flex-end;
}
.engine-info-content i[data-v-4f7f5279] {
  font-size: 11px;
  color: var(--text-accent);
  opacity: 1;
  text-shadow: var(--text-glow-accent);
  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}
.engine-name[data-v-4f7f5279] {
  font-size: 11px;
  font-weight: 500;
  color: var(--text-primary);
  letter-spacing: -0.004em;
  opacity: 1;
  text-shadow: var(--text-glow);
  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}
.engine-version[data-v-4f7f5279] {
  font-size: 10px;
  color: var(--text-accent);
  background: var(--bg-card);
  padding: 2px 8px;
  border-radius: 10px;
  font-weight: 600;
  letter-spacing: -0.002em;
  border: 1px solid var(--border-accent);
  font-family: 'SF Mono', Monaco, 'Cascadia Code', 'Roboto Mono', Consolas, 'Courier New', monospace;
  opacity: 1;
  box-shadow: 0 0 8px var(--shadow-accent);
  text-shadow: var(--text-glow-accent);
  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}
.game-name[data-v-4f7f5279] {
  font-size: 10px;
  color: var(--accent-secondary);
  background: var(--bg-card);
  padding: 2px 8px;
  border-radius: 10px;
  font-weight: 600;
  letter-spacing: -0.002em;
  border: 1px solid var(--border-accent);
  font-family: 'SF Mono', Monaco, 'Cascadia Code', 'Roboto Mono', Consolas, 'Courier New', monospace;
  opacity: 1;
  box-shadow: 0 0 8px var(--shadow-accent);
  text-shadow: var(--text-glow-accent);
  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}

/* 图标字体 */
.icon-engine[data-v-4f7f5279]::before { content: '⚙';
}
`, "",{"version":3,"sources":["webpack://./src/devtools/components/EngineInfo.vue"],"names":[],"mappings":";AAoBA,aAAa;AACb;EACE,+BAA+B;EAC/B,2BAA2B;EAC3B,8CAA8C;EAC9C,gBAAgB;EAChB,kBAAkB;EAClB,gBAAgB;EAChB,aAAa;EACb,iDAAiD;AACnD;;AAEA,cAAc;AACd;EACE,WAAW;EACX,kBAAkB;EAClB,MAAM;EACN,OAAO;EACP,QAAQ;EACR,WAAW;EACX,4GAA4G;EAC5G,UAAU;EACV,oDAA2C;EAC3C,iDAAiD;AACnD;;AAEA,sBAAsB;AACtB;EACE,sGAAsG;EACtG,WAAW;EACX,eAAe;AACjB;AAEA;AACE,WAAW,4BAA4B,EAAE,UAAU;AAAE;AACrD,MAAM,2BAA2B,EAAE,UAAU;AAAE;AACjD;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,iBAAiB;EACjB,cAAc;EACd,kBAAkB;EAClB,UAAU;EACV,yBAAyB;AAC3B;AAEA;EACE,eAAe;EACf,yBAAyB;EACzB,UAAU;EACV,oCAAoC;EACpC,iDAAiD;AACnD;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,0BAA0B;EAC1B,wBAAwB;EACxB,UAAU;EACV,6BAA6B;EAC7B,iDAAiD;AACnD;AAEA;EACE,eAAe;EACf,yBAAyB;EACzB,0BAA0B;EAC1B,gBAAgB;EAChB,mBAAmB;EACnB,gBAAgB;EAChB,wBAAwB;EACxB,sCAAsC;EACtC,kGAAkG;EAClG,UAAU;EACV,wCAAwC;EACxC,oCAAoC;EACpC,iDAAiD;AACnD;AAEA;EACE,eAAe;EACf,8BAA8B;EAC9B,0BAA0B;EAC1B,gBAAgB;EAChB,mBAAmB;EACnB,gBAAgB;EAChB,wBAAwB;EACxB,sCAAsC;EACtC,kGAAkG;EAClG,UAAU;EACV,wCAAwC;EACxC,oCAAoC;EACpC,iDAAiD;AACnD;;AAEA,SAAS;AACT,wCAAuB,YAAY;AAAE","sourcesContent":["<template>\r\n  <div v-if=\"engineInfo\" class=\"engine-info\">\r\n    <div class=\"engine-info-content\">\r\n      <i class=\"icon-engine\"></i>\r\n      <span class=\"engine-name\">{{ engineInfo.name }}</span>\r\n      <span class=\"engine-version\">v{{ engineInfo.version }}</span>\r\n      <span v-if=\"engineInfo.gamename\" class=\"game-name\">{{ engineInfo.gamename }}</span>\r\n    </div>\r\n  </div>\r\n</template>\r\n\r\n<script setup lang=\"ts\">\r\nimport type { EngineInfo } from '../types/panel.types';\r\n\r\ndefineProps<{\r\n  engineInfo: EngineInfo | null;\r\n}>();\r\n</script>\r\n\r\n<style scoped>\r\n/* 引擎信息显示区域 */\r\n.engine-info {\r\n  background: var(--bg-secondary);\r\n  backdrop-filter: blur(12px);\r\n  border-bottom: 1px solid var(--border-primary);\r\n  padding: 2px 4px;\r\n  position: relative;\r\n  overflow: hidden;\r\n  opacity: 0.95;\r\n  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);\r\n}\r\n\r\n/* 为引擎信息添加效果 */\r\n.engine-info::before {\r\n  content: '';\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  right: 0;\r\n  height: 2px;\r\n  background: linear-gradient(90deg, transparent, var(--accent-primary), var(--accent-secondary), transparent);\r\n  z-index: 1;\r\n  animation: scanLine 3s ease-in-out infinite;\r\n  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);\r\n}\r\n\r\n/* 浅色模式下使用subtle的扫描线 */\r\n.layatree-panel.light-mode .engine-info::before {\r\n  background: linear-gradient(90deg, transparent, rgba(0, 0, 0, 0.06), rgba(0, 0, 0, 0.04), transparent);\r\n  height: 1px;\r\n  animation: none;\r\n}\r\n\r\n@keyframes scanLine {\r\n  0%, 100% { transform: translateX(-100%); opacity: 0; }\r\n  50% { transform: translateX(100%); opacity: 1; }\r\n}\r\n\r\n.engine-info-content {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 8px;\r\n  max-width: 1440px;\r\n  margin: 0 auto;\r\n  position: relative;\r\n  z-index: 2;\r\n  justify-content: flex-end;\r\n}\r\n\r\n.engine-info-content i {\r\n  font-size: 11px;\r\n  color: var(--text-accent);\r\n  opacity: 1;\r\n  text-shadow: var(--text-glow-accent);\r\n  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);\r\n}\r\n\r\n.engine-name {\r\n  font-size: 11px;\r\n  font-weight: 500;\r\n  color: var(--text-primary);\r\n  letter-spacing: -0.004em;\r\n  opacity: 1;\r\n  text-shadow: var(--text-glow);\r\n  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);\r\n}\r\n\r\n.engine-version {\r\n  font-size: 10px;\r\n  color: var(--text-accent);\r\n  background: var(--bg-card);\r\n  padding: 2px 8px;\r\n  border-radius: 10px;\r\n  font-weight: 600;\r\n  letter-spacing: -0.002em;\r\n  border: 1px solid var(--border-accent);\r\n  font-family: 'SF Mono', Monaco, 'Cascadia Code', 'Roboto Mono', Consolas, 'Courier New', monospace;\r\n  opacity: 1;\r\n  box-shadow: 0 0 8px var(--shadow-accent);\r\n  text-shadow: var(--text-glow-accent);\r\n  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);\r\n}\r\n\r\n.game-name {\r\n  font-size: 10px;\r\n  color: var(--accent-secondary);\r\n  background: var(--bg-card);\r\n  padding: 2px 8px;\r\n  border-radius: 10px;\r\n  font-weight: 600;\r\n  letter-spacing: -0.002em;\r\n  border: 1px solid var(--border-accent);\r\n  font-family: 'SF Mono', Monaco, 'Cascadia Code', 'Roboto Mono', Consolas, 'Courier New', monospace;\r\n  opacity: 1;\r\n  box-shadow: 0 0 8px var(--shadow-accent);\r\n  text-shadow: var(--text-glow-accent);\r\n  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);\r\n}\r\n\r\n/* 图标字体 */\r\n.icon-engine::before { content: '⚙'; }\r\n</style> "],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/GameControls.vue?vue&type=style&index=0&id=7109ee1e&scoped=true&lang=css":
/*!**********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/GameControls.vue?vue&type=style&index=0&id=7109ee1e&scoped=true&lang=css ***!
  \**********************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
/* 游戏控制按钮组样式 */
.game-controls[data-v-7109ee1e] {
  display: flex;
  align-items: center;
  gap: 8px;
  padding: 5px 8px;
  background: var(--bg-card);
  backdrop-filter: blur(16px);
  border-radius: 8px;
  border: 1px solid var(--border-primary);
  box-shadow: 
    0 4px 16px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}
.control-btn[data-v-7109ee1e] {
  width: 28px;
  height: 28px;
  border: 1px solid var(--border-primary);
  background: var(--bg-card);
  border-radius: 6px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  font-size: 12px;
  color: var(--text-secondary);
  box-shadow: 
    0 2px 8px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  position: relative;
  overflow: hidden;
}
.control-btn[data-v-7109ee1e]::before {
  content: '';
  position: absolute;
  top: -50%;
  left: -50%;
  width: 200%;
  height: 200%;
  background: linear-gradient(45deg, transparent, var(--accent-primary), transparent);
  opacity: 0;
  transition: all 0.3s ease;
  transform: rotate(45deg);
}
.control-btn[data-v-7109ee1e]:hover:not(:disabled) {
  background: var(--bg-panel);
  color: var(--text-primary);
  border-color: var(--border-accent);
  box-shadow: 
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset,
    0 0 8px var(--shadow-accent) inset;
  transform: translateY(-1px);
  text-shadow: var(--text-glow-accent);
}
.control-btn[data-v-7109ee1e]:hover:not(:disabled)::before {
  opacity: 0.15;
  transform: rotate(45deg) translate(-25%, -25%);
}
.control-btn[data-v-7109ee1e]:disabled {
  opacity: 0.5;
  cursor: not-allowed;
  pointer-events: none;
}

/* 暂停按钮特殊样式 */
.pause-btn.paused[data-v-7109ee1e] {
  background: var(--accent-primary);
  color: #ffffff;
  border-color: var(--accent-primary);
  box-shadow: 
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--accent-primary) inset,
    0 0 12px var(--shadow-accent) inset;
  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
}
.pause-btn.paused[data-v-7109ee1e]::before {
  opacity: 0.2;
}
.pause-btn.paused[data-v-7109ee1e]:hover {
  background: var(--accent-secondary);
  border-color: var(--accent-secondary);
}

/* 下一帧按钮特殊样式 */
.next-frame-btn[data-v-7109ee1e]:not(:disabled) {
  background: var(--bg-panel);
  color: var(--text-accent);
  border-color: var(--border-accent);
  box-shadow: 
    0 2px 8px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset;
}
.next-frame-btn[data-v-7109ee1e]:not(:disabled):hover {
  background: var(--accent-secondary);
  color: #ffffff;
  border-color: var(--accent-secondary);
  box-shadow: 
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--accent-secondary) inset,
    0 0 12px var(--shadow-accent) inset;
  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
}

/* TimeScale控制区域 */
.timescale-display[data-v-7109ee1e] {
  display: flex;
  align-items: center;
  gap: 4px;
  padding: 0 6px;
  background: var(--bg-panel);
  border-radius: 6px;
  border: 1px solid var(--border-primary);
  box-shadow: 
    0 2px 8px var(--shadow-primary) inset,
    0 0 0 1px var(--border-primary) inset;
  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}
.timescale-label[data-v-7109ee1e] {
  font-size: 10px;
  color: var(--text-secondary);
  font-weight: 500;
  letter-spacing: -0.004em;
  text-shadow: var(--text-glow-secondary);
  white-space: nowrap;
  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}
.timescale-input[data-v-7109ee1e] {
  width: 70px;
  padding: 6px 1px;
  border: none;
  background: transparent;
  font-size: 12px;
  color: var(--text-accent);
  text-align: center;
  font-weight: 600;
  font-family: 'SF Mono', Monaco, 'Cascadia Code', 'Roboto Mono', Consolas, 'Courier New', monospace;
  font-variant-numeric: tabular-nums;
  outline: none;
  text-shadow: var(--text-glow-accent);
  transition: all 0.3s ease;
}
.timescale-input[data-v-7109ee1e]:focus {
  color: var(--accent-primary);
  text-shadow: var(--text-glow);
  background: var(--bg-card);
  border-radius: 4px;
}

/* 图标字体 */
.icon-play[data-v-7109ee1e]::before { content: '▷';
}
.icon-pause[data-v-7109ee1e]::before { content: '❚❚';
}
.icon-next-frame[data-v-7109ee1e]::before { content: '⏭';
}
`, "",{"version":3,"sources":["webpack://./src/devtools/components/GameControls.vue"],"names":[],"mappings":";AAqDA,cAAc;AACd;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,gBAAgB;EAChB,0BAA0B;EAC1B,2BAA2B;EAC3B,kBAAkB;EAClB,uCAAuC;EACvC;;yCAEuC;EACvC,iDAAiD;AACnD;AAEA;EACE,WAAW;EACX,YAAY;EACZ,uCAAuC;EACvC,0BAA0B;EAC1B,kBAAkB;EAClB,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,yDAAyD;EACzD,eAAe;EACf,4BAA4B;EAC5B;;yCAEuC;EACvC,kBAAkB;EAClB,gBAAgB;AAClB;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,SAAS;EACT,UAAU;EACV,WAAW;EACX,YAAY;EACZ,mFAAmF;EACnF,UAAU;EACV,yBAAyB;EACzB,wBAAwB;AAC1B;AAEA;EACE,2BAA2B;EAC3B,0BAA0B;EAC1B,kCAAkC;EAClC;;;sCAGoC;EACpC,2BAA2B;EAC3B,oCAAoC;AACtC;AAEA;EACE,aAAa;EACb,8CAA8C;AAChD;AAEA;EACE,YAAY;EACZ,mBAAmB;EACnB,oBAAoB;AACtB;;AAEA,aAAa;AACb;EACE,iCAAiC;EACjC,cAAc;EACd,mCAAmC;EACnC;;;uCAGqC;EACrC,yCAAyC;AAC3C;AAEA;EACE,YAAY;AACd;AAEA;EACE,mCAAmC;EACnC,qCAAqC;AACvC;;AAEA,cAAc;AACd;EACE,2BAA2B;EAC3B,yBAAyB;EACzB,kCAAkC;EAClC;;wCAEsC;AACxC;AAEA;EACE,mCAAmC;EACnC,cAAc;EACd,qCAAqC;EACrC;;;uCAGqC;EACrC,yCAAyC;AAC3C;;AAEA,kBAAkB;AAClB;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,cAAc;EACd,2BAA2B;EAC3B,kBAAkB;EAClB,uCAAuC;EACvC;;yCAEuC;EACvC,iDAAiD;AACnD;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,gBAAgB;EAChB,wBAAwB;EACxB,uCAAuC;EACvC,mBAAmB;EACnB,iDAAiD;AACnD;AAEA;EACE,WAAW;EACX,gBAAgB;EAChB,YAAY;EACZ,uBAAuB;EACvB,eAAe;EACf,yBAAyB;EACzB,kBAAkB;EAClB,gBAAgB;EAChB,kGAAkG;EAClG,kCAAkC;EAClC,aAAa;EACb,oCAAoC;EACpC,yBAAyB;AAC3B;AAEA;EACE,4BAA4B;EAC5B,6BAA6B;EAC7B,0BAA0B;EAC1B,kBAAkB;AACpB;;AAEA,SAAS;AACT,sCAAqB,YAAY;AAAE;AACnC,uCAAsB,aAAa;AAAE;AACrC,4CAA2B,YAAY;AAAE","sourcesContent":["<template>\r\n  <div class=\"game-controls\">\r\n    <button \r\n      class=\"control-btn pause-btn\" \r\n      @click=\"$emit('toggle-pause')\" \r\n      :class=\"{ 'paused': isPaused }\"\r\n      :title=\"isPaused ? '恢复游戏' : '暂停游戏'\"\r\n    >\r\n      <i :class=\"isPaused ? 'icon-play' : 'icon-pause'\"></i>\r\n    </button>\r\n    \r\n    <!-- 下一帧按钮 -->\r\n    <button \r\n      class=\"control-btn next-frame-btn\" \r\n      @click=\"$emit('next-frame')\"\r\n      :disabled=\"!isPaused\"\r\n      :title=\"isPaused ? '执行下一帧' : '只有暂停时才能使用'\"\r\n    >\r\n      <i class=\"icon-next-frame\"></i>\r\n    </button>\r\n    \r\n    <div class=\"timescale-display\">\r\n      <span class=\"timescale-label\">TimeScale:</span>\r\n      <input \r\n        :value=\"timeScale\" \r\n        @input=\"$emit('update:timeScale', parseFloat(($event.target as HTMLInputElement).value))\"\r\n        @change=\"$emit('timescale-change')\"\r\n        @blur=\"$emit('timescale-change')\"\r\n        type=\"number\" \r\n        step=\"0.1\" \r\n        min=\"0\" \r\n        max=\"50\"\r\n        class=\"timescale-input\"\r\n      >\r\n    </div>\r\n  </div>\r\n</template>\r\n\r\n<script setup lang=\"ts\">\r\ndefineProps<{\r\n  isPaused: boolean;\r\n  timeScale: number;\r\n}>();\r\n\r\ndefineEmits<{\r\n  'toggle-pause': [];\r\n  'next-frame': [];\r\n  'update:timeScale': [value: number];\r\n  'timescale-change': [];\r\n}>();\r\n</script>\r\n\r\n<style scoped>\r\n/* 游戏控制按钮组样式 */\r\n.game-controls {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 8px;\r\n  padding: 5px 8px;\r\n  background: var(--bg-card);\r\n  backdrop-filter: blur(16px);\r\n  border-radius: 8px;\r\n  border: 1px solid var(--border-primary);\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);\r\n}\r\n\r\n.control-btn {\r\n  width: 28px;\r\n  height: 28px;\r\n  border: 1px solid var(--border-primary);\r\n  background: var(--bg-card);\r\n  border-radius: 6px;\r\n  cursor: pointer;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n  font-size: 12px;\r\n  color: var(--text-secondary);\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  position: relative;\r\n  overflow: hidden;\r\n}\r\n\r\n.control-btn::before {\r\n  content: '';\r\n  position: absolute;\r\n  top: -50%;\r\n  left: -50%;\r\n  width: 200%;\r\n  height: 200%;\r\n  background: linear-gradient(45deg, transparent, var(--accent-primary), transparent);\r\n  opacity: 0;\r\n  transition: all 0.3s ease;\r\n  transform: rotate(45deg);\r\n}\r\n\r\n.control-btn:hover:not(:disabled) {\r\n  background: var(--bg-panel);\r\n  color: var(--text-primary);\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset,\r\n    0 0 8px var(--shadow-accent) inset;\r\n  transform: translateY(-1px);\r\n  text-shadow: var(--text-glow-accent);\r\n}\r\n\r\n.control-btn:hover:not(:disabled)::before {\r\n  opacity: 0.15;\r\n  transform: rotate(45deg) translate(-25%, -25%);\r\n}\r\n\r\n.control-btn:disabled {\r\n  opacity: 0.5;\r\n  cursor: not-allowed;\r\n  pointer-events: none;\r\n}\r\n\r\n/* 暂停按钮特殊样式 */\r\n.pause-btn.paused {\r\n  background: var(--accent-primary);\r\n  color: #ffffff;\r\n  border-color: var(--accent-primary);\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--accent-primary) inset,\r\n    0 0 12px var(--shadow-accent) inset;\r\n  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);\r\n}\r\n\r\n.pause-btn.paused::before {\r\n  opacity: 0.2;\r\n}\r\n\r\n.pause-btn.paused:hover {\r\n  background: var(--accent-secondary);\r\n  border-color: var(--accent-secondary);\r\n}\r\n\r\n/* 下一帧按钮特殊样式 */\r\n.next-frame-btn:not(:disabled) {\r\n  background: var(--bg-panel);\r\n  color: var(--text-accent);\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset;\r\n}\r\n\r\n.next-frame-btn:not(:disabled):hover {\r\n  background: var(--accent-secondary);\r\n  color: #ffffff;\r\n  border-color: var(--accent-secondary);\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--accent-secondary) inset,\r\n    0 0 12px var(--shadow-accent) inset;\r\n  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);\r\n}\r\n\r\n/* TimeScale控制区域 */\r\n.timescale-display {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 4px;\r\n  padding: 0 6px;\r\n  background: var(--bg-panel);\r\n  border-radius: 6px;\r\n  border: 1px solid var(--border-primary);\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary) inset,\r\n    0 0 0 1px var(--border-primary) inset;\r\n  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);\r\n}\r\n\r\n.timescale-label {\r\n  font-size: 10px;\r\n  color: var(--text-secondary);\r\n  font-weight: 500;\r\n  letter-spacing: -0.004em;\r\n  text-shadow: var(--text-glow-secondary);\r\n  white-space: nowrap;\r\n  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);\r\n}\r\n\r\n.timescale-input {\r\n  width: 70px;\r\n  padding: 6px 1px;\r\n  border: none;\r\n  background: transparent;\r\n  font-size: 12px;\r\n  color: var(--text-accent);\r\n  text-align: center;\r\n  font-weight: 600;\r\n  font-family: 'SF Mono', Monaco, 'Cascadia Code', 'Roboto Mono', Consolas, 'Courier New', monospace;\r\n  font-variant-numeric: tabular-nums;\r\n  outline: none;\r\n  text-shadow: var(--text-glow-accent);\r\n  transition: all 0.3s ease;\r\n}\r\n\r\n.timescale-input:focus {\r\n  color: var(--accent-primary);\r\n  text-shadow: var(--text-glow);\r\n  background: var(--bg-card);\r\n  border-radius: 4px;\r\n}\r\n\r\n/* 图标字体 */\r\n.icon-play::before { content: '▷'; }\r\n.icon-pause::before { content: '❚❚'; }\r\n.icon-next-frame::before { content: '⏭'; }\r\n</style> "],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/Nano.vue?vue&type=style&index=0&id=1d922c46&scoped=true&lang=css":
/*!**************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/Nano.vue?vue&type=style&index=0&id=1d922c46&scoped=true&lang=css ***!
  \**************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/getUrl.js */ "./node_modules/css-loader/dist/runtime/getUrl.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__);
// Imports



var ___CSS_LOADER_URL_IMPORT_0___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="%234CD964" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M5 12h14"></path><path d="M12 5l7 7-7 7"></path></svg> */ "data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%234CD964\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><path d=\"M5 12h14\"></path><path d=\"M12 5l7 7-7 7\"></path></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_1___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="%23FF3B30" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="15" y1="9" x2="9" y2="15"></line><line x1="9" y1="9" x2="15" y2="15"></line></svg> */ "data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23FF3B30\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><circle cx=\"12\" cy=\"12\" r=\"10\"></circle><line x1=\"15\" y1=\"9\" x2=\"9\" y2=\"15\"></line><line x1=\"9\" y1=\"9\" x2=\"15\" y2=\"15\"></line></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_2___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="%2364D2FF" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="2" y="2" width="20" height="8" rx="2" ry="2"></rect><rect x="2" y="14" width="20" height="8" rx="2" ry="2"></rect><line x1="6" y1="6" x2="6.01" y2="6"></line><line x1="6" y1="18" x2="6.01" y2="18"></line></svg> */ "data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%2364D2FF\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><rect x=\"2\" y=\"2\" width=\"20\" height=\"8\" rx=\"2\" ry=\"2\"></rect><rect x=\"2\" y=\"14\" width=\"20\" height=\"8\" rx=\"2\" ry=\"2\"></rect><line x1=\"6\" y1=\"6\" x2=\"6.01\" y2=\"6\"></line><line x1=\"6\" y1=\"18\" x2=\"6.01\" y2=\"18\"></line></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_3___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="%23ffb638" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><path d="M16 12a4 4 0 1 1-8 0"></path></svg> */ "data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23ffb638\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><circle cx=\"12\" cy=\"12\" r=\"10\"></circle><path d=\"M16 12a4 4 0 1 1-8 0\"></path></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_4___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="%23e0e0e0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect><path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path></svg> */ "data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><rect x=\"9\" y=\"9\" width=\"13\" height=\"13\" rx=\"2\" ry=\"2\"></rect><path d=\"M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1\"></path></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_5___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="%23e0e0e0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="3"></circle><path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"></path></svg> */ "data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><circle cx=\"12\" cy=\"12\" r=\"3\"></circle><path d=\"M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z\"></path></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_6___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="%23e0e0e0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg> */ "data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><line x1=\"18\" y1=\"6\" x2=\"6\" y2=\"18\"></line><line x1=\"6\" y1=\"6\" x2=\"18\" y2=\"18\"></line></svg>"), __webpack_require__.b);
var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
var ___CSS_LOADER_URL_REPLACEMENT_0___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_0___);
var ___CSS_LOADER_URL_REPLACEMENT_1___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_1___);
var ___CSS_LOADER_URL_REPLACEMENT_2___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_2___);
var ___CSS_LOADER_URL_REPLACEMENT_3___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_3___);
var ___CSS_LOADER_URL_REPLACEMENT_4___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_4___);
var ___CSS_LOADER_URL_REPLACEMENT_5___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_5___);
var ___CSS_LOADER_URL_REPLACEMENT_6___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_6___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
/* CSS 变量定义 */
.nano-container[data-v-1d922c46] {
  /* 深色主题变量 */
  --bg-primary: linear-gradient(135deg, #0a0e17 0%, #0f1419 40%, #1a1f29 100%);
  --bg-secondary: linear-gradient(135deg, rgba(15, 20, 25, 0.95) 0%, rgba(26, 31, 41, 0.95) 100%);
  --bg-panel: linear-gradient(135deg, rgba(15, 20, 25, 0.9) 0%, rgba(26, 31, 41, 0.8) 100%);
  --bg-card: linear-gradient(135deg, rgba(15, 20, 25, 0.7) 0%, rgba(26, 31, 41, 0.5) 100%);
  --bg-card-secondary: rgba(26, 31, 41, 0.6);
  --bg-input: rgba(15, 20, 25, 0.8);
  --bg-button: rgba(26, 31, 41, 0.7);
  --bg-button-hover: rgba(26, 31, 41, 0.9);
  --text-primary: #f0f2f5;
  --text-secondary: #b8c5d1;
  --text-accent: #4dd4ff;
  --accent-primary: #0aa2ff;
  --accent-secondary: #40e0d0;
  --border-primary: rgba(0, 162, 255, 0.2);
  --border-accent: rgba(0, 162, 255, 0.4);
  --shadow-primary: rgba(0, 0, 0, 0.3);
  --shadow-accent: rgba(0, 162, 255, 0.3);
  --text-glow: 0 0 8px rgba(0, 162, 255, 0.5);
  --text-glow-accent: 0 0 4px rgba(0, 162, 255, 0.3);
  --text-glow-secondary: 0 0 6px rgba(0, 162, 255, 0.3);
  --color-success: #4CD964;
  --color-error: #FF3B30;
  --color-warning: #ffb638;
  --color-info: #64D2FF;
  
  display: flex;
  flex-direction: column;
  height: 100%;
  overflow: hidden;
  background: var(--bg-primary);
  color: var(--text-primary);
  font-family: 'SF Pro Display', -apple-system, BlinkMacSystemFont, 'Inter', 'Segoe UI', Helvetica, Arial, sans-serif;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}

/* 浅色主题变量 */
.nano-container.light-mode[data-v-1d922c46] {
  --bg-primary: #f8fafc;
  --bg-secondary: rgba(248, 250, 252, 0.95);
  --bg-panel: rgba(255, 255, 255, 0.9);
  --bg-card: rgba(255, 255, 255, 0.8);
  --bg-card-secondary: rgba(248, 250, 252, 0.8);
  --bg-input: rgba(255, 255, 255, 0.9);
  --bg-button: rgba(248, 250, 252, 0.7);
  --bg-button-hover: rgba(248, 250, 252, 0.9);
  --text-primary: #1e293b;
  --text-secondary: #475569;
  --text-accent: #0369a1;
  --accent-primary: #0ea5e9;
  --accent-secondary: #14b8a6;
  --border-primary: rgba(0, 0, 0, 0.08);
  --border-accent: rgba(0, 0, 0, 0.12);
  --shadow-primary: rgba(0, 0, 0, 0.05);
  --shadow-accent: rgba(0, 0, 0, 0.1);
  --text-glow: 0 1px 2px rgba(0, 0, 0, 0.05);
  --text-glow-accent: 0 1px 1px rgba(0, 0, 0, 0.08);
  --text-glow-secondary: 0 1px 2px rgba(0, 0, 0, 0.06);
  --color-success: #22c55e;
  --color-error: #ef4444;
  --color-warning: #f59e0b;
  --color-info: #3b82f6;
}
.panel-title[data-v-1d922c46] {
  font-size: 16px;
  font-weight: 600;
  color: var(--text-primary);
  text-shadow: var(--text-glow);
}
.status-btn[data-v-1d922c46] {
  width: auto;
  padding: 0 12px;
  font-size: 13px;
  font-weight: 500;
  text-align: center; /* 确保文本居中 */
  min-width: 130px; /* 设置最小宽度，确保按钮大小一致 */
  justify-content: center; /* 确保内容居中 */
  height: 28px; /* 固定高度 */
  box-sizing: border-box; /* 确保padding不会增加元素的总高度 */
}
.icon-connected[data-v-1d922c46] {
  color: var(--color-success, #4CD964);
  border-color: var(--color-success, #4CD964);
}
.icon-server-active[data-v-1d922c46] {
  color: var(--color-info, #64D2FF);
  border-color: var(--color-info, #64D2FF);
}
.icon-loading[data-v-1d922c46] {
  color: var(--color-warning, #ffb638);
  border-color: var(--color-warning, #ffb638);
}
.icon-disconnected[data-v-1d922c46] {
  color: var(--color-error, #FF3B30);
  border-color: var(--color-error, #FF3B30);
  position: relative;
  padding-left: 24px;
}
.action-btn[data-v-1d922c46]:hover:not(:disabled) {
  background: var(--bg-button-hover);
  color: var(--text-primary);
  border-color: var(--border-accent);
  box-shadow: 0 0 8px var(--shadow-accent);
}
.action-btn[data-v-1d922c46]:disabled {
  opacity: 0.5;
  cursor: not-allowed;
}
.action-btn.connecting i[data-v-1d922c46],
.action-btn.refreshing i[data-v-1d922c46] {
  animation: spin-1d922c46 1s linear infinite;
}
.action-btn.connected[data-v-1d922c46] {
  color: var(--color-success);
  border-color: var(--color-success);
}
.icon-connected[data-v-1d922c46] {
  position: relative;
  padding-left: 24px;
}
.icon-connected[data-v-1d922c46]::before {
  content: '';
  position: absolute;
  left: 8px;
  top: 50%;
  transform: translateY(-50%);
  width: 16px;
  height: 16px;
  background-image: url(${___CSS_LOADER_URL_REPLACEMENT_0___});
  background-repeat: no-repeat;
  background-position: center;
}
.icon-disconnected[data-v-1d922c46]::before {
  content: '';
  position: absolute;
  left: 8px;
  top: 50%;
  transform: translateY(-50%);
  width: 16px;
  height: 16px;
  background-image: url(${___CSS_LOADER_URL_REPLACEMENT_1___});
  background-repeat: no-repeat;
  background-position: center;
}
.icon-server-active[data-v-1d922c46] {
  position: relative;
  padding-left: 24px;
}
.icon-server-active[data-v-1d922c46]::before {
  content: '';
  position: absolute;
  left: 8px;
  top: 50%;
  transform: translateY(-50%);
  width: 16px;
  height: 16px;
  background-image: url(${___CSS_LOADER_URL_REPLACEMENT_2___});
  background-repeat: no-repeat;
  background-position: center;
}
.icon-loading[data-v-1d922c46] {
  position: relative;
  padding-left: 24px;
}
.icon-loading[data-v-1d922c46]::before {
  content: '';
  position: absolute;
  left: 8px;
  top: 50%;
  transform: translateY(-50%);
  width: 16px;
  height: 16px;
  background-image: url(${___CSS_LOADER_URL_REPLACEMENT_3___});
  background-repeat: no-repeat;
  background-position: center;
  animation: spin-1d922c46 1s linear infinite;
}
.nano-content[data-v-1d922c46] {
  flex: 1;
  overflow: hidden;
  display: flex;
  flex-direction: column;
}
.connection-guide[data-v-1d922c46] {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  height: 100%;
  padding: 20px;
}
.guide-content[data-v-1d922c46] {
  max-width: 500px;
  text-align: center;
  background: var(--bg-card);
  border-radius: 12px;
  padding: 24px;
  box-shadow: 0 8px 32px var(--shadow-primary);
  border: 1px solid var(--border-primary);
}
.guide-content i[data-v-1d922c46] {
  font-size: 48px;
  color: var(--accent-primary);
  margin-bottom: 16px;
  display: block;
}
.guide-title[data-v-1d922c46] {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 16px;
  color: var(--text-primary);
}
.guide-details[data-v-1d922c46] {
  text-align: left;
}
.guide-text[data-v-1d922c46] {
  margin-bottom: 12px;
  color: var(--text-secondary);
}
.guide-steps[data-v-1d922c46] {
  margin-bottom: 24px;
  padding: 16px;
  background: var(--bg-panel);
  border-radius: 16px;
  border: 1px solid var(--border-primary);
  box-shadow: 0 4px 16px var(--shadow-primary);
  backdrop-filter: blur(24px);
  position: relative;
  overflow: hidden;
}
.guide-steps[data-v-1d922c46]::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  height: 2px;
  background: linear-gradient(90deg, var(--accent-primary) 0%, var(--accent-secondary, #4A9EFF) 100%);
}
.guide-steps li[data-v-1d922c46] {
  margin-bottom: 8px;
  color: var(--text-secondary);
}
.step[data-v-1d922c46] {
  margin-bottom: 16px;
  padding: 16px 20px;
  background: var(--bg-card);
  border-radius: 8px;
  border: 1px solid var(--border-primary);
  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  position: relative;
  overflow: hidden;
}
.step[data-v-1d922c46]:last-child {
  margin-bottom: 0;
}
.step[data-v-1d922c46]::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  width: 3px;
  height: 100%;
  background: linear-gradient(180deg, var(--accent-primary) 0%, var(--accent-secondary, #4A9EFF) 100%);
  border-radius: 0 2px 2px 0;
}
.step[data-v-1d922c46]:hover {
  transform: translateY(-1px);
  background: var(--bg-panel);
  border-color: var(--border-accent);
  box-shadow: 0 2px 8px var(--shadow-primary);
}
.step-title[data-v-1d922c46] {
  font-size: 15px;
  font-weight: 600;
  color: var(--accent-primary);
  margin-bottom: 10px;
  display: flex;
  align-items: center;
  gap: 6px;
}
.step-title[data-v-1d922c46]::before {
  content: '●';
  font-size: 12px;
  color: var(--accent-primary);
  opacity: 0.8;
}
.step-content[data-v-1d922c46] {
  margin-left: 0;
}
.step-desc[data-v-1d922c46] {
  margin-bottom: 8px;
  color: var(--text-secondary);
  line-height: 1.6;
  padding-left: 16px;
  position: relative;
  transition: color 0.2s;
}
.step-desc[data-v-1d922c46]::before {
  content: '▸';
  position: absolute;
  left: 0;
  color: var(--accent-primary);
  font-weight: bold;
  transition: transform 0.2s;
}
.step:hover .step-desc[data-v-1d922c46] {
  color: var(--text-primary);
}
.step:hover .step-desc[data-v-1d922c46]::before {
  transform: translateX(2px);
}
.connection-status-box[data-v-1d922c46] {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
  margin-top: 16px;
  padding: 8px;
  background: var(--bg-panel);
  border-radius: 8px;
  border: 1px solid var(--border-primary);
}
.status-indicator[data-v-1d922c46] {
  width: 12px;
  height: 12px;
  border-radius: 50%;
  background: var(--color-error);
}
.status-indicator.active[data-v-1d922c46] {
  background: var(--color-success);
}
.status-indicator.connecting[data-v-1d922c46] {
  background-color: #ffb638;
  animation: pulse-1d922c46 1.5s infinite;
}
.status-indicator.server-active[data-v-1d922c46] {
  background-color: var(--color-info, #64D2FF);
  animation: pulse-1d922c46 2s infinite;
}
.server-info[data-v-1d922c46] {
  display: flex;
  flex-direction: column;
  align-items: center;
  width: 100%;
  max-width: 500px;
  margin-bottom: 20px;
  padding: 16px;
  background-color: rgba(100, 210, 255, 0.05);
  border-radius: 6px;
  border: 1px solid rgba(100, 210, 255, 0.2);
}
.server-config[data-v-1d922c46] {
  margin-top: 20px;
  margin-bottom: 20px;
  padding: 15px;
  background: var(--bg-card-secondary);
  border-radius: 8px;
  width: 100%;
}
.ws-input-container[data-v-1d922c46] {
  display: flex;
  flex-direction: column;
  margin-bottom: 10px;
}
.ws-input-label[data-v-1d922c46] {
  font-size: 14px;
  font-weight: 500;
  margin-bottom: 8px;
  color: var(--text-primary);
}
.ws-input-box[data-v-1d922c46] {
  display: flex;
  align-items: center;
}
.ws-address-input[data-v-1d922c46] {
  flex: 1;
  width: 350px;
  padding: 8px 12px;
  border: 1px solid var(--border-primary);
  border-radius: 4px;
  background: var(--bg-input);
  color: var(--text-primary);
  font-family: monospace;
  font-size: 14px;
  outline: none;
  transition: border-color 0.2s;
}
.ws-address-input[data-v-1d922c46]:focus {
  border-color: var(--accent-primary);
}
.ws-address-box[data-v-1d922c46] {
  display: flex;
  align-items: center;
  width: 100%;
  margin-bottom: 12px;
  padding: 8px 12px;
  background-color: rgba(0, 0, 0, 0.2);
  border-radius: 4px;
}
.ws-address-label[data-v-1d922c46] {
  font-size: 13px;
  color: var(--text-secondary);
  margin-right: 8px;
}
.ws-address-value[data-v-1d922c46] {
  flex: 1;
  font-family: monospace;
  color: var(--color-info, #64D2FF);
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
}
.copy-btn[data-v-1d922c46] {
  display: flex;
  align-items: center;
  justify-content: center;
  width: 24px;
  height: 24px;
  background-color: transparent;
  border: none;
  cursor: pointer;
  opacity: 0.7;
  transition: opacity 0.2s;
  margin-left: 8px;
}
.copy-btn[data-v-1d922c46]:hover {
  opacity: 1;
}
.copy-icon[data-v-1d922c46] {
  display: inline-block;
  width: 16px;
  height: 16px;
  background-image: url(${___CSS_LOADER_URL_REPLACEMENT_4___});
  background-position: center;
  background-repeat: no-repeat;
  background-size: contain;
}
.server-status[data-v-1d922c46] {
  font-size: 14px;
  color: var(--text-secondary);
  margin-bottom: 16px;
}
.test-btn[data-v-1d922c46] {
  padding: 6px 12px;
  background-color: rgba(100, 210, 255, 0.1);
  border: 1px solid rgba(100, 210, 255, 0.3);
  border-radius: 4px;
  color: var(--color-info, #64D2FF);
  cursor: pointer;
  font-size: 13px;
  transition: background-color 0.2s;
}
.test-btn[data-v-1d922c46]:hover {
  background-color: rgba(100, 210, 255, 0.2);
}

/* 已连接状态的布局样式 */
.nano-connected-layout[data-v-1d922c46] {
  display: flex;
  height: 100%;
  gap: 1px;
}
.tree-panel[data-v-1d922c46], .inspector-panel[data-v-1d922c46] {
  display: flex;
  flex-direction: column;
  background: var(--bg-card);
  backdrop-filter: blur(16px);
}
.tree-panel[data-v-1d922c46] {
  flex: 1;
  min-width: 320px;
  max-width: 50%;
  border-right: 1px solid var(--border-primary);
}
.inspector-panel[data-v-1d922c46] {
  flex: 1;
  min-width: 320px;
}
.tree-container[data-v-1d922c46] {
  flex: 1;
  overflow: auto;
  padding: 8px;
}

/* 面板头部样式 */
.panel-header[data-v-1d922c46] {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 12px 16px;
  border-bottom: 1px solid var(--border-primary);
  background: var(--bg-secondary);
  backdrop-filter: blur(16px);
  position: relative;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.panel-header h3[data-v-1d922c46] {
  font-size: 15px;
  font-weight: 600;
  color: var(--text-primary);
  margin: 0;
  letter-spacing: -0.022em;
  text-shadow: var(--text-glow);
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.panel-left[data-v-1d922c46] {
  display: flex;
  align-items: center;
  gap: 16px;
}
.panel-controls[data-v-1d922c46] {
  display: flex;
  align-items: center;
  gap: 16px;
}
.auto-update-control[data-v-1d922c46],
.stat-control[data-v-1d922c46],
.render-control[data-v-1d922c46] {
  display: flex;
  align-items: center;
}
.checkbox-label[data-v-1d922c46] {
  display: flex;
  align-items: center;
  gap: 6px;
  cursor: pointer;
  font-size: 13px;
  color: var(--text-secondary);
  transition: color 0.2s ease;
}
.checkbox-label[data-v-1d922c46]:hover {
  color: var(--text-primary);
}
.checkbox-input[data-v-1d922c46] {
  width: 16px;
  height: 16px;
  border: 1px solid var(--border-accent);
  border-radius: 3px;
  background: var(--bg-input);
  cursor: pointer;
  position: relative;
  transition: all 0.2s ease;
  appearance: none;
  -webkit-appearance: none;
  -moz-appearance: none;
}
.checkbox-input[data-v-1d922c46]:checked {
  background: var(--accent-primary);
  border-color: var(--accent-primary);
}
.checkbox-input[data-v-1d922c46]:checked::after {
  content: '✓';
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  color: white;
  font-size: 10px;
  font-weight: bold;
}
.checkbox-text[data-v-1d922c46] {
  user-select: none;
}
.render-btn[data-v-1d922c46] {
  padding: 6px 12px;
  font-size: 13px;
  font-weight: 500;
  color: var(--text-primary);
  background: var(--bg-button);
  border: 1px solid var(--border-accent);
  border-radius: 6px;
  cursor: pointer;
  transition: all 0.2s ease;
  display: flex;
  align-items: center;
  gap: 4px;
  user-select: none;
}
.render-btn[data-v-1d922c46]:hover {
  background: var(--bg-button-hover);
  border-color: var(--accent-primary);
  color: var(--accent-primary);
  transform: translateY(-1px);
  box-shadow: 0 2px 8px var(--shadow-primary);
}
.render-btn[data-v-1d922c46]:active {
  transform: translateY(0);
  box-shadow: 0 1px 4px var(--shadow-primary);
}
.help-btn[data-v-1d922c46] {
  display: flex;
  align-items: center;
  gap: 4px;
  padding: 4px 8px;
  border: 1px solid var(--border-accent);
  background: var(--bg-card);
  border-radius: 6px;
  cursor: pointer;
  font-size: 12px;
  color: var(--text-secondary);
  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  box-shadow: 0 2px 8px var(--shadow-primary);
  text-decoration: none;
}
.help-btn[data-v-1d922c46]:hover {
  background: var(--bg-panel);
  color: var(--accent-primary);
  border-color: var(--accent-primary);
  box-shadow: 0 4px 16px var(--shadow-accent);
  transform: translateY(-1px);
  text-shadow: var(--text-glow-accent);
}
.help-icon[data-v-1d922c46] {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  width: 14px;
  height: 14px;
  border-radius: 50%;
  background: var(--accent-primary);
  color: white;
  font-size: 10px;
  font-weight: bold;
  line-height: 1;
}
.panel-actions[data-v-1d922c46] {
  display: flex;
  gap: 8px;
}
.action-btn[data-v-1d922c46] {
  width: 32px;
  height: 32px;
  border: 1px solid var(--border-accent);
  background: var(--bg-card);
  border-radius: 8px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  font-size: 14px;
  color: var(--text-secondary);
  box-shadow: 
    0 4px 16px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  position: relative;
  overflow: hidden;
}
.action-btn[data-v-1d922c46]:hover {
  background: var(--bg-panel);
  color: var(--text-primary);
  border-color: var(--border-accent);
  box-shadow: 
    0 8px 32px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset,
    0 0 16px var(--shadow-accent) inset;
  transform: translateY(-1px);
  text-shadow: var(--text-glow-accent);
}
.action-btn.refreshing[data-v-1d922c46] {
  pointer-events: none;
  opacity: 0.7;
}
.action-btn.refreshing i[data-v-1d922c46] {
  animation: refreshSpin-1d922c46 1s linear infinite;
}
.action-btn[data-v-1d922c46]:disabled {
  opacity: 0.6;
  cursor: not-allowed;
  pointer-events: none;
}
.action-btn.active[data-v-1d922c46] {
  background: var(--accent-primary);
  color: #ffffff;
  border-color: var(--accent-primary);
  box-shadow: 
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--accent-primary) inset,
    0 0 12px var(--shadow-accent) inset;
  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
}
.action-btn.active[data-v-1d922c46]:hover {
  background: var(--accent-secondary);
  border-color: var(--accent-secondary);
}
@keyframes refreshSpin-1d922c46 {
from { transform: rotate(0deg);
}
to { transform: rotate(360deg);
}
}

/* 图标样式 */
.icon-refresh[data-v-1d922c46]::before { content: '⟳';
}
.icon-expand[data-v-1d922c46]::before { content: '⬇';
}
.icon-collapse[data-v-1d922c46]::before { content: '➤';
}
.icon-flag[data-v-1d922c46]::before { content: '🚩';
}
.icon-loading[data-v-1d922c46]::before { content: '⟲';
}
.inspector-content[data-v-1d922c46] {
  flex: 1;
  overflow: auto;
  padding: 16px;
}
.no-selection-hint[data-v-1d922c46] {
  display: flex;
  height: 100%;
  align-items: center;
  justify-content: center;
  color: var(--text-secondary);
  font-style: italic;
}
@keyframes spin-1d922c46 {
from { transform: translateY(-50%) rotate(0deg);
}
to { transform: translateY(-50%) rotate(360deg);
}
}
@keyframes pulse-1d922c46 {
0% { opacity: 0.6;
}
50% { opacity: 1;
}
100% { opacity: 0.6;
}
}



/* 设置按钮样式 */
.settings-btn[data-v-1d922c46] {
  width: auto;
  padding: 0 12px;
  font-size: 13px;
  font-weight: 500;
  display: flex;
  align-items: center;
  gap: 6px;
}
.settings-icon[data-v-1d922c46] {
  display: inline-block;
  width: 16px;
  height: 16px;
  background-image: url(${___CSS_LOADER_URL_REPLACEMENT_5___});
  background-position: center;
  background-repeat: no-repeat;
  background-size: contain;
}

/* 服务器信息显示样式 */
.ws-info-container[data-v-1d922c46] {
  display: flex;
  flex-direction: column;
  margin-bottom: 10px;
}
.ws-info-label[data-v-1d922c46] {
  font-size: 14px;
  font-weight: 500;
  margin-bottom: 8px;
  color: var(--text-primary);
}
.ws-info-value[data-v-1d922c46] {
  font-family: monospace;
  padding: 8px 12px;
  background-color: rgba(0, 0, 0, 0.2);
  border-radius: 4px;
  color: var(--color-info, #64D2FF);
  margin-bottom: 8px;
  max-width: 500px;
  width: 100%;
}
.ws-info-hint[data-v-1d922c46] {
  font-size: 12px;
  color: var(--text-secondary);
  font-style: italic;
}

/* 弹窗样式 */
.modal-overlay[data-v-1d922c46] {
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: var(--bg-panel, #1e1e1e);
  display: flex;
  align-items: center;
  justify-content: center;
  z-index: 1000;
}
.modal-container[data-v-1d922c46] {
  background: var(--bg-card);
  border-radius: 8px;
  box-shadow: 0 4px 16px rgba(0, 0, 0, 0.2);
  width: 90%;
  max-width: 600px;
  max-height: 90vh;
  display: flex;
  flex-direction: column;
  overflow: hidden;
  border: 1px solid var(--border-primary);
}
.modal-header[data-v-1d922c46] {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 16px;
  border-bottom: 1px solid var(--border-primary);
}
.modal-header h3[data-v-1d922c46] {
  margin: 0;
  font-size: 16px;
  font-weight: 600;
  color: var(--text-primary);
}
.modal-close-btn[data-v-1d922c46] {
  background: transparent;
  border: none;
  cursor: pointer;
  width: 24px;
  height: 24px;
  display: flex;
  align-items: center;
  justify-content: center;
  opacity: 0.7;
  transition: opacity 0.2s;
}
.modal-close-btn[data-v-1d922c46]:hover {
  opacity: 1;
}
.close-icon[data-v-1d922c46] {
  display: inline-block;
  width: 16px;
  height: 16px;
  background-image: url(${___CSS_LOADER_URL_REPLACEMENT_6___});
  background-position: center;
  background-repeat: no-repeat;
  background-size: contain;
}
.modal-content[data-v-1d922c46] {
  padding: 16px;
  overflow-y: auto;
  flex: 1;
}
.form-group[data-v-1d922c46] {
    margin-bottom: 16px;
}
.form-group label[data-v-1d922c46] {
    display: block;
    margin-bottom: 8px;
    font-size: 14px;
    font-weight: 500;
    color: var(--text-primary);
}
.form-group input[data-v-1d922c46] {
    width: 100%;
    padding: 8px 12px;
    border-radius: 4px;
    border: 1px solid var(--border-primary);
    background-color: var(--bg-input);
    color: var(--text-primary);
    font-family: monospace;
    font-size: 14px;
}
.modal-footer[data-v-1d922c46] {
  display: flex;
  justify-content: flex-end;
  padding: 16px;
  border-top: 1px solid var(--border-primary);
  gap: 8px;
}
.cancel-btn[data-v-1d922c46], .save-btn[data-v-1d922c46] {
  padding: 8px 16px;
  border-radius: 4px;
  font-size: 14px;
  font-weight: 500;
  cursor: pointer;
  transition: all 0.2s;
}
.cancel-btn[data-v-1d922c46] {
  background-color: transparent;
  border: 1px solid var(--border-primary);
  color: var(--text-secondary);
}
.cancel-btn[data-v-1d922c46]:hover {
  background-color: var(--bg-button-hover);
  color: var(--text-primary);
}
.save-btn[data-v-1d922c46] {
  background-color: var(--color-info, #64D2FF);
  border: 1px solid var(--color-info, #64D2FF);
  color: var(--bg-card);
}
.save-btn[data-v-1d922c46]:hover {
  background-color: rgba(100, 210, 255, 0.8);
}

/* 二维码相关样式 */
.qrcode-container[data-v-1d922c46] {
  display: flex;
  flex-direction: column;
  align-items: center;
  padding: 20px;
  background-color: var(--bg-card);
  border-radius: 8px;
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
  margin: 20px auto;
  max-width: 300px;
}
.qrcode-title[data-v-1d922c46] {
  font-size: 16px;
  font-weight: 600;
  margin-bottom: 15px;
  color: var(--text-primary);
}
.qrcode-canvas[data-v-1d922c46] {
  background-color: white;
  padding: 10px;
  border-radius: 4px;
  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
  cursor: pointer;
  transition: all 0.2s ease;
}
.qrcode-canvas[data-v-1d922c46]:hover {
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
  transform: scale(1.02);
}
.qrcode-image[data-v-1d922c46] {
  display: block;
  max-width: 200px;
  background-color: white;
  padding: 10px;
  border-radius: 4px;
  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
  margin: 0 auto;
}
.qrcode-info[data-v-1d922c46] {
  margin-top: 15px;
  width: 100%;
  text-align: center;
}
.qrcode-id[data-v-1d922c46], .qrcode-url[data-v-1d922c46] {
  font-size: 14px;
  color: var(--text-secondary);
  margin: 5px 0;
  word-break: break-all;
}
.waiting-connection[data-v-1d922c46] {
  display: flex;
  flex-direction: column;
  align-items: center;
  padding: 30px;
}
.spinner[data-v-1d922c46] {
  width: 40px;
  height: 40px;
  border: 4px solid rgba(0, 0, 0, 0.1);
  border-radius: 50%;
  border-top-color: var(--color-info, #64D2FF);
  animation: spin-1d922c46 1s ease-in-out infinite;
  margin-bottom: 15px;
}
@keyframes spin-1d922c46 {
to { transform: rotate(360deg);
}
}
.waiting-text[data-v-1d922c46] {
  font-size: 16px;
  color: var(--text-secondary);
  margin-bottom: 15px;
  position: relative;
  display: inline-block;
}
.waiting-text-active[data-v-1d922c46] {
  animation: textPulse-1d922c46 1.5s infinite;
}
@keyframes textPulse-1d922c46 {
0% { opacity: 0.6;
}
50% { opacity: 1;
}
100% { opacity: 0.6;
}
}
.waiting-text-active[data-v-1d922c46]::after {
  content: '...';
  position: absolute;
  right: -12px;
  animation: ellipsis-1d922c46 1.5s infinite;
  width: 12px;
  overflow: hidden;
}
@keyframes ellipsis-1d922c46 {
0% { width: 0;
}
50% { width: 12px;
}
100% { width: 0;
}
}
.debug-btn[data-v-1d922c46] {
  padding: 8px 16px;
  background-color: #ff5722;
  color: white;
  border: none;
  border-radius: 4px;
  font-size: 14px;
  cursor: pointer;
  margin-top: 10px;
  transition: background-color 0.2s;
}
.debug-btn[data-v-1d922c46]:hover {
  background-color: #e64a19;
}
`, "",{"version":3,"sources":["webpack://./src/devtools/components/Nano.vue"],"names":[],"mappings":";AAwsCA,aAAa;AACb;EACE,WAAW;EACX,4EAA4E;EAC5E,+FAA+F;EAC/F,yFAAyF;EACzF,wFAAwF;EACxF,0CAA0C;EAC1C,iCAAiC;EACjC,kCAAkC;EAClC,wCAAwC;EACxC,uBAAuB;EACvB,yBAAyB;EACzB,sBAAsB;EACtB,yBAAyB;EACzB,2BAA2B;EAC3B,wCAAwC;EACxC,uCAAuC;EACvC,oCAAoC;EACpC,uCAAuC;EACvC,2CAA2C;EAC3C,kDAAkD;EAClD,qDAAqD;EACrD,wBAAwB;EACxB,sBAAsB;EACtB,wBAAwB;EACxB,qBAAqB;;EAErB,aAAa;EACb,sBAAsB;EACtB,YAAY;EACZ,gBAAgB;EAChB,6BAA6B;EAC7B,0BAA0B;EAC1B,mHAAmH;EACnH,yDAAyD;AAC3D;;AAEA,WAAW;AACX;EACE,qBAAqB;EACrB,yCAAyC;EACzC,oCAAoC;EACpC,mCAAmC;EACnC,6CAA6C;EAC7C,oCAAoC;EACpC,qCAAqC;EACrC,2CAA2C;EAC3C,uBAAuB;EACvB,yBAAyB;EACzB,sBAAsB;EACtB,yBAAyB;EACzB,2BAA2B;EAC3B,qCAAqC;EACrC,oCAAoC;EACpC,qCAAqC;EACrC,mCAAmC;EACnC,0CAA0C;EAC1C,iDAAiD;EACjD,oDAAoD;EACpD,wBAAwB;EACxB,sBAAsB;EACtB,wBAAwB;EACxB,qBAAqB;AACvB;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,0BAA0B;EAC1B,6BAA6B;AAC/B;AAEA;EACE,WAAW;EACX,eAAe;EACf,eAAe;EACf,gBAAgB;EAChB,kBAAkB,EAAE,WAAW;EAC/B,gBAAgB,EAAE,oBAAoB;EACtC,uBAAuB,EAAE,WAAW;EACpC,YAAY,EAAE,SAAS;EACvB,sBAAsB,EAAE,wBAAwB;AAClD;AAEA;EACE,oCAAoC;EACpC,2CAA2C;AAC7C;AAEA;EACE,iCAAiC;EACjC,wCAAwC;AAC1C;AAEA;EACE,oCAAoC;EACpC,2CAA2C;AAC7C;AAEA;EACE,kCAAkC;EAClC,yCAAyC;EACzC,kBAAkB;EAClB,kBAAkB;AACpB;AAEA;EACE,kCAAkC;EAClC,0BAA0B;EAC1B,kCAAkC;EAClC,wCAAwC;AAC1C;AAEA;EACE,YAAY;EACZ,mBAAmB;AACrB;AAEA;;EAEE,2CAAkC;AACpC;AAEA;EACE,2BAA2B;EAC3B,kCAAkC;AACpC;AAEA;EACE,kBAAkB;EAClB,kBAAkB;AACpB;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,SAAS;EACT,QAAQ;EACR,2BAA2B;EAC3B,WAAW;EACX,YAAY;EACZ,yDAAkS;EAClS,4BAA4B;EAC5B,2BAA2B;AAC7B;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,SAAS;EACT,QAAQ;EACR,2BAA2B;EAC3B,WAAW;EACX,YAAY;EACZ,yDAAuW;EACvW,4BAA4B;EAC5B,2BAA2B;AAC7B;AAEA;EACE,kBAAkB;EAClB,kBAAkB;AACpB;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,SAAS;EACT,QAAQ;EACR,2BAA2B;EAC3B,WAAW;EACX,YAAY;EACZ,yDAA8b;EAC9b,4BAA4B;EAC5B,2BAA2B;AAC7B;AAEA;EACE,kBAAkB;EAClB,kBAAkB;AACpB;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,SAAS;EACT,QAAQ;EACR,2BAA2B;EAC3B,WAAW;EACX,YAAY;EACZ,yDAAuT;EACvT,4BAA4B;EAC5B,2BAA2B;EAC3B,2CAAkC;AACpC;AAEA;EACE,OAAO;EACP,gBAAgB;EAChB,aAAa;EACb,sBAAsB;AACxB;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;EACnB,uBAAuB;EACvB,YAAY;EACZ,aAAa;AACf;AAEA;EACE,gBAAgB;EAChB,kBAAkB;EAClB,0BAA0B;EAC1B,mBAAmB;EACnB,aAAa;EACb,4CAA4C;EAC5C,uCAAuC;AACzC;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,mBAAmB;EACnB,cAAc;AAChB;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,mBAAmB;EACnB,0BAA0B;AAC5B;AAEA;EACE,gBAAgB;AAClB;AAEA;EACE,mBAAmB;EACnB,4BAA4B;AAC9B;AAEA;EACE,mBAAmB;EACnB,aAAa;EACb,2BAA2B;EAC3B,mBAAmB;EACnB,uCAAuC;EACvC,4CAA4C;EAC5C,2BAA2B;EAC3B,kBAAkB;EAClB,gBAAgB;AAClB;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,MAAM;EACN,OAAO;EACP,QAAQ;EACR,WAAW;EACX,mGAAmG;AACrG;AAEA;EACE,kBAAkB;EAClB,4BAA4B;AAC9B;AAEA;EACE,mBAAmB;EACnB,kBAAkB;EAClB,0BAA0B;EAC1B,kBAAkB;EAClB,uCAAuC;EACvC,yDAAyD;EACzD,kBAAkB;EAClB,gBAAgB;AAClB;AAEA;EACE,gBAAgB;AAClB;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,MAAM;EACN,OAAO;EACP,UAAU;EACV,YAAY;EACZ,oGAAoG;EACpG,0BAA0B;AAC5B;AAEA;EACE,2BAA2B;EAC3B,2BAA2B;EAC3B,kCAAkC;EAClC,2CAA2C;AAC7C;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,4BAA4B;EAC5B,mBAAmB;EACnB,aAAa;EACb,mBAAmB;EACnB,QAAQ;AACV;AAEA;EACE,YAAY;EACZ,eAAe;EACf,4BAA4B;EAC5B,YAAY;AACd;AAEA;EACE,cAAc;AAChB;AAEA;EACE,kBAAkB;EAClB,4BAA4B;EAC5B,gBAAgB;EAChB,kBAAkB;EAClB,kBAAkB;EAClB,sBAAsB;AACxB;AAEA;EACE,YAAY;EACZ,kBAAkB;EAClB,OAAO;EACP,4BAA4B;EAC5B,iBAAiB;EACjB,0BAA0B;AAC5B;AAEA;EACE,0BAA0B;AAC5B;AAEA;EACE,0BAA0B;AAC5B;AAIA;EACE,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,QAAQ;EACR,gBAAgB;EAChB,YAAY;EACZ,2BAA2B;EAC3B,kBAAkB;EAClB,uCAAuC;AACzC;AAEA;EACE,WAAW;EACX,YAAY;EACZ,kBAAkB;EAClB,8BAA8B;AAChC;AAEA;EACE,gCAAgC;AAClC;AAEA;EACE,yBAAyB;EACzB,uCAA8B;AAChC;AAEA;EACE,4CAA4C;EAC5C,qCAA4B;AAC9B;AAIA;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;EACnB,WAAW;EACX,gBAAgB;EAChB,mBAAmB;EACnB,aAAa;EACb,2CAA2C;EAC3C,kBAAkB;EAClB,0CAA0C;AAC5C;AAEA;EACE,gBAAgB;EAChB,mBAAmB;EACnB,aAAa;EACb,oCAAoC;EACpC,kBAAkB;EAClB,WAAW;AACb;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;AACrB;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,kBAAkB;EAClB,0BAA0B;AAC5B;AAEA;EACE,aAAa;EACb,mBAAmB;AACrB;AAEA;EACE,OAAO;EACP,YAAY;EACZ,iBAAiB;EACjB,uCAAuC;EACvC,kBAAkB;EAClB,2BAA2B;EAC3B,0BAA0B;EAC1B,sBAAsB;EACtB,eAAe;EACf,aAAa;EACb,6BAA6B;AAC/B;AAEA;EACE,mCAAmC;AACrC;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,WAAW;EACX,mBAAmB;EACnB,iBAAiB;EACjB,oCAAoC;EACpC,kBAAkB;AACpB;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,iBAAiB;AACnB;AAEA;EACE,OAAO;EACP,sBAAsB;EACtB,iCAAiC;EACjC,gBAAgB;EAChB,uBAAuB;EACvB,mBAAmB;AACrB;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,WAAW;EACX,YAAY;EACZ,6BAA6B;EAC7B,YAAY;EACZ,eAAe;EACf,YAAY;EACZ,wBAAwB;EACxB,gBAAgB;AAClB;AAEA;EACE,UAAU;AACZ;AAEA;EACE,qBAAqB;EACrB,WAAW;EACX,YAAY;EACZ,yDAAgX;EAChX,2BAA2B;EAC3B,4BAA4B;EAC5B,wBAAwB;AAC1B;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,mBAAmB;AACrB;AAEA;EACE,iBAAiB;EACjB,0CAA0C;EAC1C,0CAA0C;EAC1C,kBAAkB;EAClB,iCAAiC;EACjC,eAAe;EACf,eAAe;EACf,iCAAiC;AACnC;AAEA;EACE,0CAA0C;AAC5C;;AAEA,eAAe;AACf;EACE,aAAa;EACb,YAAY;EACZ,QAAQ;AACV;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,0BAA0B;EAC1B,2BAA2B;AAC7B;AAEA;EACE,OAAO;EACP,gBAAgB;EAChB,cAAc;EACd,6CAA6C;AAC/C;AAEA;EACE,OAAO;EACP,gBAAgB;AAClB;AAEA;EACE,OAAO;EACP,cAAc;EACd,YAAY;AACd;;AAEA,WAAW;AACX;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,kBAAkB;EAClB,8CAA8C;EAC9C,+BAA+B;EAC/B,2BAA2B;EAC3B,kBAAkB;EAClB,yDAAyD;AAC3D;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,0BAA0B;EAC1B,SAAS;EACT,wBAAwB;EACxB,6BAA6B;EAC7B,yDAAyD;AAC3D;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,SAAS;AACX;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,SAAS;AACX;AAEA;;;EAGE,aAAa;EACb,mBAAmB;AACrB;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,eAAe;EACf,eAAe;EACf,4BAA4B;EAC5B,2BAA2B;AAC7B;AAEA;EACE,0BAA0B;AAC5B;AAEA;EACE,WAAW;EACX,YAAY;EACZ,sCAAsC;EACtC,kBAAkB;EAClB,2BAA2B;EAC3B,eAAe;EACf,kBAAkB;EAClB,yBAAyB;EACzB,gBAAgB;EAChB,wBAAwB;EACxB,qBAAqB;AACvB;AAEA;EACE,iCAAiC;EACjC,mCAAmC;AACrC;AAEA;EACE,YAAY;EACZ,kBAAkB;EAClB,QAAQ;EACR,SAAS;EACT,gCAAgC;EAChC,YAAY;EACZ,eAAe;EACf,iBAAiB;AACnB;AAEA;EACE,iBAAiB;AACnB;AAEA;EACE,iBAAiB;EACjB,eAAe;EACf,gBAAgB;EAChB,0BAA0B;EAC1B,4BAA4B;EAC5B,sCAAsC;EACtC,kBAAkB;EAClB,eAAe;EACf,yBAAyB;EACzB,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,iBAAiB;AACnB;AAEA;EACE,kCAAkC;EAClC,mCAAmC;EACnC,4BAA4B;EAC5B,2BAA2B;EAC3B,2CAA2C;AAC7C;AAEA;EACE,wBAAwB;EACxB,2CAA2C;AAC7C;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,gBAAgB;EAChB,sCAAsC;EACtC,0BAA0B;EAC1B,kBAAkB;EAClB,eAAe;EACf,eAAe;EACf,4BAA4B;EAC5B,yDAAyD;EACzD,2CAA2C;EAC3C,qBAAqB;AACvB;AAEA;EACE,2BAA2B;EAC3B,4BAA4B;EAC5B,mCAAmC;EACnC,2CAA2C;EAC3C,2BAA2B;EAC3B,oCAAoC;AACtC;AAEA;EACE,oBAAoB;EACpB,mBAAmB;EACnB,uBAAuB;EACvB,WAAW;EACX,YAAY;EACZ,kBAAkB;EAClB,iCAAiC;EACjC,YAAY;EACZ,eAAe;EACf,iBAAiB;EACjB,cAAc;AAChB;AAEA;EACE,aAAa;EACb,QAAQ;AACV;AAEA;EACE,WAAW;EACX,YAAY;EACZ,sCAAsC;EACtC,0BAA0B;EAC1B,kBAAkB;EAClB,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,yDAAyD;EACzD,eAAe;EACf,4BAA4B;EAC5B;;yCAEuC;EACvC,kBAAkB;EAClB,gBAAgB;AAClB;AAEA;EACE,2BAA2B;EAC3B,0BAA0B;EAC1B,kCAAkC;EAClC;;;uCAGqC;EACrC,2BAA2B;EAC3B,oCAAoC;AACtC;AAEA;EACE,oBAAoB;EACpB,YAAY;AACd;AAEA;EACE,kDAAyC;AAC3C;AAEA;EACE,YAAY;EACZ,mBAAmB;EACnB,oBAAoB;AACtB;AAEA;EACE,iCAAiC;EACjC,cAAc;EACd,mCAAmC;EACnC;;;uCAGqC;EACrC,yCAAyC;AAC3C;AAEA;EACE,mCAAmC;EACnC,qCAAqC;AACvC;AAEA;AACE,OAAO,uBAAuB;AAAE;AAChC,KAAK,yBAAyB;AAAE;AAClC;;AAEA,SAAS;AACT,yCAAwB,YAAY;AAAE;AACtC,wCAAuB,YAAY;AAAE;AACrC,0CAAyB,YAAY;AAAE;AACvC,sCAAqB,aAAa;AAAE;AACpC,yCAAwB,YAAY;AAAE;AAEtC;EACE,OAAO;EACP,cAAc;EACd,aAAa;AACf;AAEA;EACE,aAAa;EACb,YAAY;EACZ,mBAAmB;EACnB,uBAAuB;EACvB,4BAA4B;EAC5B,kBAAkB;AACpB;AAEA;AACE,OAAO,wCAAwC;AAAE;AACjD,KAAK,0CAA0C;AAAE;AACnD;AAEA;AACE,KAAK,YAAY;AAAE;AACnB,MAAM,UAAU;AAAE;AAClB,OAAO,YAAY;AAAE;AACvB;;;;AAIA,WAAW;AACX;EACE,WAAW;EACX,eAAe;EACf,eAAe;EACf,gBAAgB;EAChB,aAAa;EACb,mBAAmB;EACnB,QAAQ;AACV;AAEA;EACE,qBAAqB;EACrB,WAAW;EACX,YAAY;EACZ,yDAAggC;EAChgC,2BAA2B;EAC3B,4BAA4B;EAC5B,wBAAwB;AAC1B;;AAEA,cAAc;AACd;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;AACrB;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,kBAAkB;EAClB,0BAA0B;AAC5B;AAEA;EACE,sBAAsB;EACtB,iBAAiB;EACjB,oCAAoC;EACpC,kBAAkB;EAClB,iCAAiC;EACjC,kBAAkB;EAClB,gBAAgB;EAChB,WAAW;AACb;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,kBAAkB;AACpB;;AAEA,SAAS;AACT;EACE,eAAe;EACf,MAAM;EACN,OAAO;EACP,QAAQ;EACR,SAAS;EACT,0CAA0C;EAC1C,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,aAAa;AACf;AAEA;EACE,0BAA0B;EAC1B,kBAAkB;EAClB,yCAAyC;EACzC,UAAU;EACV,gBAAgB;EAChB,gBAAgB;EAChB,aAAa;EACb,sBAAsB;EACtB,gBAAgB;EAChB,uCAAuC;AACzC;AAEA;EACE,aAAa;EACb,8BAA8B;EAC9B,mBAAmB;EACnB,aAAa;EACb,8CAA8C;AAChD;AAEA;EACE,SAAS;EACT,eAAe;EACf,gBAAgB;EAChB,0BAA0B;AAC5B;AAEA;EACE,uBAAuB;EACvB,YAAY;EACZ,eAAe;EACf,WAAW;EACX,YAAY;EACZ,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,YAAY;EACZ,wBAAwB;AAC1B;AAEA;EACE,UAAU;AACZ;AAEA;EACE,qBAAqB;EACrB,WAAW;EACX,YAAY;EACZ,yDAA+T;EAC/T,2BAA2B;EAC3B,4BAA4B;EAC5B,wBAAwB;AAC1B;AAEA;EACE,aAAa;EACb,gBAAgB;EAChB,OAAO;AACT;AAEA;IACI,mBAAmB;AACrB;AAEA;IACE,cAAc;IACd,kBAAkB;IAClB,eAAe;IACf,gBAAgB;IAChB,0BAA0B;AAC5B;AAEA;IACE,WAAW;IACX,iBAAiB;IACjB,kBAAkB;IAClB,uCAAuC;IACvC,iCAAiC;IACjC,0BAA0B;IAC1B,sBAAsB;IACtB,eAAe;AACjB;AAEF;EACE,aAAa;EACb,yBAAyB;EACzB,aAAa;EACb,2CAA2C;EAC3C,QAAQ;AACV;AAEA;EACE,iBAAiB;EACjB,kBAAkB;EAClB,eAAe;EACf,gBAAgB;EAChB,eAAe;EACf,oBAAoB;AACtB;AAEA;EACE,6BAA6B;EAC7B,uCAAuC;EACvC,4BAA4B;AAC9B;AAEA;EACE,wCAAwC;EACxC,0BAA0B;AAC5B;AAEA;EACE,4CAA4C;EAC5C,4CAA4C;EAC5C,qBAAqB;AACvB;AAEA;EACE,0CAA0C;AAC5C;;AAEA,YAAY;AACZ;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;EACnB,aAAa;EACb,gCAAgC;EAChC,kBAAkB;EAClB,wCAAwC;EACxC,iBAAiB;EACjB,gBAAgB;AAClB;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,mBAAmB;EACnB,0BAA0B;AAC5B;AAEA;EACE,uBAAuB;EACvB,aAAa;EACb,kBAAkB;EAClB,wCAAwC;EACxC,eAAe;EACf,yBAAyB;AAC3B;AAEA;EACE,wCAAwC;EACxC,sBAAsB;AACxB;AAEA;EACE,cAAc;EACd,gBAAgB;EAChB,uBAAuB;EACvB,aAAa;EACb,kBAAkB;EAClB,wCAAwC;EACxC,cAAc;AAChB;AAEA;EACE,gBAAgB;EAChB,WAAW;EACX,kBAAkB;AACpB;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,aAAa;EACb,qBAAqB;AACvB;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;EACnB,aAAa;AACf;AAEA;EACE,WAAW;EACX,YAAY;EACZ,oCAAoC;EACpC,kBAAkB;EAClB,4CAA4C;EAC5C,gDAAuC;EACvC,mBAAmB;AACrB;AAEA;AACE,KAAK,yBAAyB;AAAE;AAClC;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,mBAAmB;EACnB,kBAAkB;EAClB,qBAAqB;AACvB;AAEA;EACE,2CAAkC;AACpC;AAEA;AACE,KAAK,YAAY;AAAE;AACnB,MAAM,UAAU;AAAE;AAClB,OAAO,YAAY;AAAE;AACvB;AAEA;EACE,cAAc;EACd,kBAAkB;EAClB,YAAY;EACZ,0CAAiC;EACjC,WAAW;EACX,gBAAgB;AAClB;AAEA;AACE,KAAK,QAAQ;AAAE;AACf,MAAM,WAAW;AAAE;AACnB,OAAO,QAAQ;AAAE;AACnB;AAEA;EACE,iBAAiB;EACjB,yBAAyB;EACzB,YAAY;EACZ,YAAY;EACZ,kBAAkB;EAClB,eAAe;EACf,eAAe;EACf,gBAAgB;EAChB,iCAAiC;AACnC;AAEA;EACE,yBAAyB;AAC3B","sourcesContent":["<template>\r\n  <div class=\"nano-container\" :class=\"{ 'light-mode': !isDarkMode }\">\r\n    <div class=\"panel-header\">\r\n      <div class=\"panel-left\">\r\n        <div class=\"panel-title\">Nano 调试</div>\r\n        <!-- 使用说明按钮 -->\r\n        <button \r\n          class=\"help-btn\" \r\n          title=\"查看使用说明\"\r\n          @click=\"openHelpDocument\"\r\n        >\r\n          <span class=\"help-icon\">?</span>\r\n          使用说明\r\n        </button>\r\n\r\n        <!-- Render按钮 - 仅在连接状态下显示 -->\r\n        <div v-if=\"isConnected\" class=\"render-control\">\r\n          <button \r\n            class=\"help-btn\" \r\n            title=\"渲染信息统计\"\r\n            @click=\"onRenderClick\"\r\n          >\r\n            🎨 Render\r\n          </button>\r\n        </div>\r\n\r\n        <!-- vConsole按钮 - 仅在连接状态下显示 -->\r\n        <div v-if=\"isConnected\" class=\"render-control\">\r\n          <button \r\n            class=\"help-btn\" \r\n            title=\"vConsole\"\r\n            @click=\"onVConsoleClick\"\r\n          >\r\n             vConsole\r\n          </button>\r\n        </div>\r\n\r\n        <!-- 调试Stat勾选框 - 仅在连接状态下显示 -->\r\n        <div v-if=\"isConnected\" class=\"stat-control\">\r\n          <label class=\"checkbox-label\" title=\"勾选时显示调试统计信息\">\r\n            <input \r\n              type=\"checkbox\" \r\n              v-model=\"isStatEnabled\" \r\n              @change=\"onStatChange\"\r\n              class=\"checkbox-input\"\r\n            >\r\n            <span class=\"checkbox-text\">调试Stat</span>\r\n          </label>\r\n        </div>\r\n        \r\n      </div>\r\n      <div class=\"panel-controls\">\r\n        <!-- 即时更新勾选框 - 仅在连接状态下显示 -->\r\n        <div v-if=\"isConnected\" class=\"auto-update-control\">\r\n          <label class=\"checkbox-label\" title=\"勾选时会实时更新节点树和属性信息\">\r\n            <input \r\n              type=\"checkbox\" \r\n              v-model=\"autoUpdate\" \r\n              @change=\"onAutoUpdateChange\"\r\n              class=\"checkbox-input\"\r\n            >\r\n            <span class=\"checkbox-text\">实时刷新</span>\r\n          </label>\r\n        </div>\r\n        \r\n        <div class=\"panel-actions\">\r\n          <button \r\n            class=\"action-btn status-btn\" \r\n            :class=\"connectionIconClass\" \r\n            :title=\"connectionButtonTitle\"\r\n            @click=\"toggleNanoServer\"\r\n          >\r\n            {{ isConnecting ? '服务器启动中...' : (serverActive ? '关闭服务器' : '连接服务器') }}\r\n          </button>\r\n          <button \r\n            class=\"action-btn settings-btn\" \r\n            title=\"设置服务器地址\"\r\n            @click=\"showServerSettings\"\r\n          >\r\n            <span class=\"settings-icon\"></span>\r\n            设置\r\n          </button>\r\n        </div>\r\n      </div>\r\n    </div>\r\n    \r\n    <div class=\"nano-content\">\r\n      <!-- 未连接状态 -->\r\n      <div v-if=\"!isConnected\" class=\"connection-guide\">\r\n        <div class=\"waiting-text\" :class=\"{ 'waiting-text-active': serverActive }\">{{ serverActive ? '等待设备连接' : '移动端LayaTreeNano调试' }}</div>\r\n\r\n\r\n        \r\n        <!-- 服务器已启动但未连接 或 显示二维码 -->\r\n        <div v-if=\"(serverActive && !isConnected) || (showQrcode && qrcodeData)\" class=\"server-info\">\r\n          <div v-if=\"showQrcode && qrcodeData\" class=\"qrcode-container\">\r\n            <div class=\"qrcode-title\">手机扫描二维码连接</div>\r\n            <!-- 二维码显示方式：Canvas -->\r\n            <canvas ref=\"qrcodeCanvas\" class=\"qrcode-canvas\" @dblclick=\"copyQrcodeInfo\" title=\"双击复制二维码信息\"></canvas>\r\n            <div class=\"qrcode-info\">\r\n              <div class=\"qrcode-id\">{{ qrcodeData.uid }}</div>\r\n              <div class=\"qrcode-url\">Nano服务器: {{ qrcodeData.url }}</div>\r\n            </div>\r\n          </div>\r\n          <div v-else class=\"waiting-connection\">\r\n            <div class=\"spinner\"></div>\r\n            <div class=\"waiting-text waiting-text-active\">正在等待设备连接</div>\r\n          </div>\r\n        </div>\r\n        \r\n        <!-- 服务器未启动 - WebSocket地址信息已移除 -->\r\n        \r\n        <!-- 服务器未启动 - 引导步骤 -->\r\n        <div v-if=\"!serverActive\" class=\"guide-steps\">\r\n          <div class=\"step\">\r\n            <div class=\"step-title\">1.真机直连，实时联调无门槛</div>\r\n    \r\n            <div class=\"step-content\">\r\n              <div class=\"step-desc\">扫码直连：手机调试信息将实时同步，在Nano界面直接观察真机运行状态。</div>\r\n              <div class=\"step-desc\">支持私有化部署：开放Nano部署方案，满足对数据安全、隐私保护的需求。</div>\r\n            </div>\r\n          </div>\r\n          \r\n          <div class=\"step\">\r\n            <div class=\"step-title\">2.轻量化设计，降低使用成本</div>\r\n            <div class=\"step-content\">\r\n              <div class=\"step-desc\">无缝衔接 LayaTree</div>\r\n              <div class=\"step-desc\">共享项目配置与调试逻辑，开发者无需额外学习成本</div>\r\n            </div>\r\n          </div>\r\n          \r\n          <div class=\"step\">\r\n            <div class=\"step-title\">3.核心适用场景</div>\r\n            <div class=\"step-content\">\r\n              <div class=\"step-desc\">发现真机运行时的性能瓶颈、兼容性与适配、触控交互异常等问题。</div>\r\n              <div class=\"step-desc\">在真机环境下快速验证产品功能与用户体验，缩短迭代周期。</div>\r\n            </div>\r\n          </div>\r\n        </div>\r\n      </div>\r\n\r\n      <!-- 已连接状态 - 分为左右两栏 -->\r\n      <div v-else-if=\"isConnected\" class=\"nano-connected-layout\">\r\n        <!-- 左侧层级树 -->\r\n        <div class=\"tree-panel\">\r\n          <div class=\"panel-header\">\r\n            <h3>场景层级</h3>\r\n            \r\n            <!-- 游戏控制按钮组 -->\r\n            <GameControls\r\n              :is-paused=\"isPaused\"\r\n              v-model:time-scale=\"timeScale\"\r\n              @toggle-pause=\"togglePause\"\r\n              @next-frame=\"nextFrame\"\r\n              @timescale-change=\"onTimeScaleChange\"\r\n            />\r\n            \r\n            <div class=\"panel-actions\">\r\n              <button \r\n                class=\"action-btn\" \r\n                @click=\"refreshTree\" \r\n                :disabled=\"isRefreshing\" \r\n                :class=\"{ 'refreshing': isRefreshing }\"\r\n                :title=\"isRefreshing ? '正在刷新...' : '刷新场景层级'\"\r\n              >\r\n                <i :class=\"isRefreshing ? 'icon-loading' : 'icon-refresh'\"></i>\r\n              </button>\r\n              <button \r\n                class=\"action-btn\" \r\n                @click=\"expandAll\"\r\n                title=\"展开所有节点\"\r\n              >\r\n                <i class=\"icon-expand\"></i>\r\n              </button>\r\n              <button \r\n                class=\"action-btn\" \r\n                @click=\"collapseAll\"\r\n                title=\"折叠所有节点\"\r\n              >\r\n                <i class=\"icon-collapse\"></i>\r\n              </button>\r\n              <button \r\n                class=\"action-btn\" \r\n                @click=\"toggleSelBoxMark\"\r\n                :class=\"{ 'active': isSelBoxMarkEnabled }\"\r\n                :title=\"isSelBoxMarkEnabled ? '关闭选择框标记' : '开启选择框标记'\"\r\n              >\r\n                <i class=\"icon-flag\"></i>\r\n              </button>\r\n            </div>\r\n          </div>\r\n          <div class=\"tree-container\">\r\n            <TreeView \r\n              :nodes=\"treeNodes\" \r\n              :selected-node-id=\"selectedNode?.id || ''\"\r\n              :is-dark-mode=\"isDarkMode\" \r\n              @node-select=\"onNodeSelect\"\r\n              @node-delete=\"deleteNode\"\r\n            />\r\n          </div>\r\n        </div>\r\n\r\n        <!-- 右侧属性面板 -->\r\n        <div class=\"inspector-panel\">\r\n          <div class=\"panel-header\">\r\n            <h3>属性检查器</h3>\r\n          </div>\r\n          <div class=\"inspector-content\">\r\n            <PropertyInspector\r\n              v-if=\"selectedNode\"\r\n              :selected-node=\"selectedNode\"\r\n              :is-dark-mode=\"isDarkMode\"\r\n              @property-change=\"onPropertyChange\"\r\n            />\r\n            <div v-else class=\"no-selection-hint\">\r\n              <p>请从左侧选择一个节点查看属性</p>\r\n            </div>\r\n          </div>\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </div>\r\n  \r\n  <!-- 服务器设置弹窗 -->\r\n  <div v-if=\"showSettings\" class=\"modal-overlay\" @click.self=\"closeServerSettings\">\r\n    <div class=\"modal-container\">\r\n      <div class=\"modal-header\">\r\n        <h3>使用的Nano服务器设置</h3>\r\n        <button class=\"modal-close-btn\" @click=\"closeServerSettings\">\r\n          <span class=\"close-icon\"></span>\r\n        </button>\r\n      </div>\r\n      <div class=\"modal-content\">\r\n        <div class=\"form-group\">\r\n          <label for=\"wsAddress\">WebSocket服务器地址:</label>\r\n          <input \r\n            type=\"text\" \r\n            id=\"wsAddress\"\r\n            v-model=\"tempWsAddress\" \r\n            placeholder=\"ws://womenzhai.cn:9981\" \r\n            class=\"ws-address-input\"\r\n          />\r\n        </div>\r\n      </div>\r\n      <div class=\"modal-footer\">\r\n        <button class=\"cancel-btn\" @click=\"closeServerSettings\">取消</button>\r\n        <button class=\"save-btn\" @click=\"saveServerSettings\">保存</button>\r\n      </div>\r\n    </div>\r\n  </div>\r\n  \r\n  <!-- Render悬浮面板 -->\r\n  <Render ref=\"renderPanelRef\" />\r\n  \r\n  <!-- VConsole悬浮面板 -->\r\n  <VConsole ref=\"vconsolePanelRef\" />\r\n</template>\r\n\r\n<script setup lang=\"ts\">\r\nimport { ref, computed, onMounted, onUnmounted, watch, nextTick, defineExpose, provide } from 'vue';\r\nimport TreeView from './TreeView.vue';\r\nimport PropertyInspector from './PropertyInspector.vue';\r\nimport GameControls from './GameControls.vue';\r\nimport Render from './Render.vue';\r\nimport VConsole from './VConsole.vue';\r\nimport { Logger } from '@/core/Constant';\r\nimport QRCode from 'qrcode';\r\nimport { useEngineData } from '../composables/useEngineData';\r\nimport { useNanoWebSocket } from '../composables/useNanoWebSocket';\r\nimport type { PropertyComponent, PropertyItem } from '../types/panel.types';\r\nimport { LayaPropParse } from '@/core/engine/laya/LayaPropParse';\r\n\r\n// 定义props\r\nconst props = defineProps<{\r\n  isDarkMode: boolean;\r\n}>();\r\n\r\n// 状态变量\r\nconst isRefreshing = ref(false);\r\nconst serverPort = ref(9090);\r\nconst showQrcode = ref(false);\r\nconst qrcodeData = ref<{uid: string, url: string} | null>(null);\r\nconst qrcodeCanvas = ref<HTMLCanvasElement | null>(null);\r\nconst qrcodeImageUrl = ref('');\r\nconst showSettings = ref(false);\r\nconst tempWsAddress = ref('ws://womenzhai.cn:9981');\r\n\r\n// 即时更新配置 - 默认开启，支持持久化存储\r\nconst autoUpdate = ref(true);\r\n// 调试Stat配置\r\nconst isStatEnabled = ref(false);\r\n// Render面板引用\r\nconst renderPanelRef = ref<{ showPanel: () => void; handleWebGLHookResponse: (message: any) => void } | null>(null);\r\n// VConsole面板引用\r\nconst vconsolePanelRef = ref<{ showPanel: () => void; handleVConsoleResponse: (message: any) => void; addLog: (level: string, message: string) => void } | null>(null);\r\nconst {\r\n  isConnecting,\r\n  serverActive,\r\n  isConnected,\r\n  uniqueId,\r\n  lowerId,\r\n  wsAddress,\r\n  customWsAddress,\r\n  startNanoServer,\r\n  closeNanoServer,\r\n  startHeartbeat,\r\n  sendMessage,\r\n} = useNanoWebSocket(\r\n  (message) => {\r\n    uniqueId.value = message.uniqueId;\r\n    // 缓存localToken\r\n    if (message.localToken) {\r\n      localStorage.setItem('local-token', message.localToken);\r\n    }\r\n    serverActive.value = true;\r\n    qrcodeData.value = { uid: uniqueId.value, url: wsAddress.value };\r\n    showQrcode.value = true;\r\n    startHeartbeat();\r\n  },\r\n  (message) => {\r\n    isConnected.value = true;\r\n    lowerId.value = message.lowerId;\r\n    console.log('下位机已连接，界面已切换到节点视图');\r\n    setTimeout(() => { refreshTree(); }, 500);\r\n  },\r\n  (message) => {\r\n    isRefreshing.value = false;\r\n    if (message.success && message.nodeTree) {\r\n      // 如果是第一次加载（treeNodes为空），不传递existingNodes以获得更好的默认展开\r\n      const existingNodes = treeNodes.value.length > 0 ? treeNodes.value : undefined;\r\n      const convertedTree = convertEngineTreeToLocal(message.nodeTree, existingNodes);\r\n      \r\n      treeNodes.value = convertedTree;\r\n      smartSelectNode(convertedTree);\r\n      // 请求选中节点的属性\r\n\r\n    }\r\n  },\r\n  (message) => {\r\n    if (message.success && message.property && selectedNode.value && selectedNode.value.exId === message.exId) {\r\n      updateNodeWithRealProperties(selectedNode.value, message.property);\r\n    }\r\n  },\r\n  (message) => {\r\n    // 处理SET_NODE_PROPERTY_RESPONSE\r\n    if (message.success && selectedNode.value && message.exId === selectedNode.value.exId) {\r\n      Logger.log(`📥 收到SET_NODE_PROPERTY_RESPONSE: ${message.componentType}.${message.propertyName} = ${message.value}`);\r\n      \r\n      // 更新节点属性值\r\n      if (selectedNode.value.components) {\r\n        selectedNode.value.components.forEach((component: any) => {\r\n          if (component.type === message.componentType && component.properties) {\r\n            component.properties.forEach((prop: any) => {\r\n              if (prop.name === message.propertyName) {\r\n                prop.value = message.value;\r\n              }\r\n            });\r\n          }\r\n        });\r\n      }\r\n      \r\n      // 如果有properties数组（兼容旧格式），也更新它\r\n      if (selectedNode.value.properties) {\r\n        selectedNode.value.properties = selectedNode.value.properties.map((prop: any) => {\r\n          if (prop.key === message.propertyName) {\r\n            return { ...prop, value: message.value };\r\n          }\r\n          return prop;\r\n        });\r\n      }\r\n    } else if (!message.success) {\r\n      Logger.error(`❌ 设置属性失败: ${message.componentType}.${message.propertyName}`);\r\n    }\r\n  },\r\n  () => { console.log('收到心跳包确认'); },\r\n  (message) => {\r\n    // 处理GET_AUTO_UPDATE_FLAG请求\r\n    Logger.log('📥 收到GET_AUTO_UPDATE_FLAG请求，返回当前autoUpdate状态');\r\n    \r\n    if (isConnected.value) {\r\n      try {\r\n        sendMessage({\r\n          type: 'SET_AUTO_UPDATE_FLAG',\r\n          targetId: lowerId.value,\r\n          autoUpdateFlag: autoUpdate.value,\r\n          timestamp: Date.now()\r\n        });\r\n        Logger.log(`📤 已响应GET_AUTO_UPDATE_FLAG: autoUpdate = ${autoUpdate.value}`);\r\n      } catch (error) {\r\n        Logger.error('响应GET_AUTO_UPDATE_FLAG失败:', error);\r\n      }\r\n    }\r\n  },\r\n  (message) => {\r\n    // 处理SET_TIMESCALE_RESPONSE\r\n    Logger.log('📥 收到SET_TIMESCALE_RESPONSE:', message);\r\n    \r\n    if (message.success && message.timeScale !== undefined) {\r\n      timeScale.value = message.timeScale;\r\n      // 更新暂停状态（如果timeScale为0则认为是暂停状态）\r\n      isPaused.value = message.timeScale === 0;\r\n      Logger.log(`✅ TimeScale已更新为: ${timeScale.value}, 暂停状态: ${isPaused.value}`);\r\n    } else {\r\n      Logger.error('❌ 设置TimeScale失败:', message.error || '未知错误');\r\n    }\r\n  },\r\n  (message) => {\r\n    // 处理STAT_RESPONSE\r\n    Logger.log('📥 收到STAT_RESPONSE:', message);\r\n    \r\n    if (message.success && message.isShow !== undefined) {\r\n      isStatEnabled.value = message.isShow;\r\n      Logger.log(`✅ Stat状态已更新为: ${isStatEnabled.value}`);\r\n    } else {\r\n      Logger.error('❌ 获取Stat状态失败:', message.error || '未知错误');\r\n    }\r\n  },\r\n  (message) => {\r\n    // 处理DELETE_NODE_RESPONSE\r\n    Logger.log('📥 收到DELETE_NODE_RESPONSE:', message);\r\n    \r\n    if (message.success) {\r\n      Logger.log(`✅ 节点删除成功: ${message.exId}`);\r\n      // 删除成功后刷新节点树\r\n      refreshTree();\r\n    } else {\r\n      Logger.error('❌ 删除节点失败:', message.error || '未知错误');\r\n    }\r\n  },\r\n  (message) => {\r\n    // 处理WEBGLHOOK响应消息\r\n    Logger.log('📥 收到WEBGLHOOK响应:', message);\r\n    \r\n    // 转发给Render组件处理\r\n    if (renderPanelRef.value && renderPanelRef.value.handleWebGLHookResponse) {\r\n      renderPanelRef.value.handleWebGLHookResponse(message);\r\n    }\r\n  },\r\n  (message) => {\r\n    // 处理VConsole响应消息\r\n    Logger.log('📥 收到VConsole响应:', message);\r\n    \r\n    // 转发给VConsole组件处理\r\n    if (vconsolePanelRef.value && vconsolePanelRef.value.handleVConsoleResponse) {\r\n      vconsolePanelRef.value.handleVConsoleResponse(message);\r\n    }\r\n  }\r\n);\r\n\r\n// 游戏控制相关状态\r\nconst isPaused = ref(false);\r\nconst timeScale = ref(1.0);\r\nconst isSelBoxMarkEnabled = ref(false);\r\n\r\n// 属性自动更新定时器\r\nlet propertyUpdateInterval: NodeJS.Timeout | null = null;\r\n\r\n// Nano组件自己管理treeNodes\r\nconst treeNodes = ref<any[]>([]);\r\n\r\n// 使用useEngineData获取智能选中节点所需的函数，传入自己的treeNodes\r\nconst {   \r\n  selectedNode,\r\n  selectedExId,\r\n  convertEngineTreeToLocal,\r\n  updateNodeWithRealProperties\r\n} = useEngineData(() => null, treeNodes);\r\n\r\n// 属性自动更新相关函数\r\nconst startPropertyAutoUpdate = () => {\r\n    // 检查是否开启即时更新\r\n    if (!autoUpdate.value) {\r\n        return;\r\n    }\r\n    \r\n    stopPropertyAutoUpdate();\r\n    \r\n    const exId = selectedNode.value?.exId;\r\n    if (exId === undefined) return;\r\n    \r\n    requestNodeProperty(exId); // 立即请求一次\r\n    \r\n    propertyUpdateInterval = setInterval(() => {\r\n      if (selectedNode.value?.exId === exId) {\r\n          requestNodeProperty(exId);\r\n      } else {\r\n        stopPropertyAutoUpdate();\r\n      }\r\n    }, 1000);\r\n};\r\n\r\nconst stopPropertyAutoUpdate = () => {\r\n    if (propertyUpdateInterval) {\r\n      clearInterval(propertyUpdateInterval);\r\n      propertyUpdateInterval = null;\r\n    }\r\n};\r\n\r\n// 查找节点的辅助函数\r\nconst findNodeByExId = (nodes: any[], exId: number): any | null => {\r\n  for (const node of nodes) {\r\n    if (node.exId === exId) return node;\r\n    if (node.children?.length) {\r\n      const found = findNodeByExId(node.children, exId);\r\n      if (found) return found;\r\n    }\r\n  }\r\n  return null;\r\n};\r\n\r\n// 展开路径到指定节点的辅助函数\r\nconst expandPathToNode = (nodes: any[], targetExId: number): boolean => {\r\n  for (const node of nodes) {\r\n    if (node.exId === targetExId) {\r\n      return true; // 找到目标节点\r\n    }\r\n    \r\n    if (node.children?.length) {\r\n      if (expandPathToNode(node.children, targetExId)) {\r\n        node.expanded = true; // 展开父节点\r\n        return true;\r\n      }\r\n    }\r\n  }\r\n  return false;\r\n};\r\n\r\n// 智能选择节点函数\r\nconst smartSelectNode = (convertedTree: any[]) => {\r\n  // 查找目标节点\r\n  let nodeToSelect = selectedExId.value !== null \r\n    ? findNodeByExId(convertedTree, selectedExId.value)\r\n    : null;\r\n  \r\n  // 回退到stage节点\r\n  if (!nodeToSelect) {\r\n    nodeToSelect = findNodeByExId(convertedTree, 0);\r\n    if (nodeToSelect) {\r\n      selectedExId.value = 0;\r\n    }\r\n  }\r\n  \r\n  if (nodeToSelect) {\r\n    // 展开路径到目标节点\r\n    if (nodeToSelect.exId !== undefined) {\r\n      expandPathToNode(convertedTree, nodeToSelect.exId);\r\n    }\r\n     requestNodeProperty(nodeToSelect.exId);\r\n    // 检查是否需要更新选中节点\r\n    const isSameNode = selectedNode.value?.exId === nodeToSelect.exId && \r\n                      nodeToSelect.exId !== undefined;\r\n\r\n    if (!isSameNode) {\r\n      selectedNode.value = nodeToSelect;\r\n      if (nodeToSelect.exId !== undefined) {\r\n        startPropertyAutoUpdate();\r\n      }\r\n\r\n    } else if (selectedNode.value) {\r\n      // 更新节点数据但保持引用\r\n      Object.assign(selectedNode.value, nodeToSelect);\r\n    }\r\n  } else {\r\n    selectedNode.value = null;\r\n    selectedExId.value = null;\r\n  }\r\n};\r\n\r\n\r\n\r\n// 监听qrcodeData和showQrcode变化，生成二维码\r\nwatch([qrcodeData, showQrcode], ([newQrcodeData, newShowQrcode]) => {\r\n  if (newQrcodeData && newShowQrcode) {\r\n    // 使用nextTick确保DOM已更新\r\n    nextTick(() => {\r\n      console.log('DOM已更新，尝试生成二维码，canvas元素存在:', !!qrcodeCanvas.value);\r\n      generateQRCode();\r\n    });\r\n  }\r\n});\r\n\r\n// 在组件挂载后，如果已有qrcodeData和showQrcode为true，则生成二维码\r\nonMounted(() => {\r\n  if (qrcodeData.value && showQrcode.value) {\r\n    // 使用nextTick确保DOM已更新\r\n    nextTick(() => {\r\n      console.log('组件已挂载，尝试生成二维码，canvas元素存在:', !!qrcodeCanvas.value);\r\n      generateQRCode();\r\n    });\r\n  }\r\n});\r\n\r\n// 生成二维码\r\nconst generateQRCode = async () => {\r\n  console.log('[DEBUG] 开始生成二维码，检查条件:', { \r\n    hasQrcodeData: !!qrcodeData.value, \r\n    hasCanvas: !!qrcodeCanvas.value,\r\n    showQrcode: showQrcode.value\r\n  });\r\n  \r\n  if (!qrcodeData.value) {\r\n    console.error('[ERROR] 无法生成二维码：缺少二维码数据');\r\n    return;\r\n  }\r\n  \r\n  if (!qrcodeCanvas.value) {\r\n    console.error('[ERROR] 无法生成二维码：找不到canvas元素');\r\n    return;\r\n  }\r\n  \r\n  try {\r\n    // 创建包含设备ID和服务器地址的JSON字符串\r\n    const qrData = JSON.stringify({\r\n      uid: qrcodeData.value.uid,\r\n      url: qrcodeData.value.url\r\n    });\r\n    \r\n    console.log('[DEBUG] 二维码数据:', qrData);\r\n    \r\n    // 使用toDataURL方法生成二维码\r\n    const dataURL = await QRCode.toDataURL(qrData, {\r\n      width: 200,\r\n      margin: 2,\r\n      color: {\r\n        dark: '#000000',\r\n        light: '#ffffff'\r\n      }\r\n    });\r\n    \r\n    // 创建图像并加载到canvas\r\n    const img = new Image();\r\n    img.onload = () => {\r\n      const canvas = qrcodeCanvas.value;\r\n      if (!canvas) return;\r\n      \r\n      const context = canvas.getContext('2d');\r\n      if (!context) {\r\n        console.error('[ERROR] 无法获取canvas上下文');\r\n        return;\r\n      }\r\n      \r\n      // 设置canvas尺寸\r\n      canvas.width = img.width;\r\n      canvas.height = img.height;\r\n      \r\n      // 清除canvas并绘制图像\r\n      context.clearRect(0, 0, canvas.width, canvas.height);\r\n      context.drawImage(img, 0, 0);\r\n      \r\n      // 在二维码中心位置添加图标\r\n      const logoImg = new Image();\r\n      logoImg.onload = () => {\r\n        // 计算图标位置（居中）\r\n        const logoSize = canvas.width * 0.2; // 图标大小为二维码的20%\r\n        const logoX = (canvas.width - logoSize) / 2;\r\n        const logoY = (canvas.height - logoSize) / 2;\r\n        \r\n        // 先绘制白色背景（稍大一些并添加圆角效果）\r\n        const padding = logoSize * 0.1; // 背景比图标大10%\r\n        context.fillStyle = '#FFFFFF';\r\n        \r\n        // 绘制圆角矩形\r\n        const bgX = logoX - padding;\r\n        const bgY = logoY - padding;\r\n        const bgWidth = logoSize + padding * 2;\r\n        const bgHeight = logoSize + padding * 2;\r\n        const radius = bgWidth * 0.2; // 圆角半径\r\n        \r\n        context.beginPath();\r\n        context.moveTo(bgX + radius, bgY);\r\n        context.lineTo(bgX + bgWidth - radius, bgY);\r\n        context.arcTo(bgX + bgWidth, bgY, bgX + bgWidth, bgY + radius, radius);\r\n        context.lineTo(bgX + bgWidth, bgY + bgHeight - radius);\r\n        context.arcTo(bgX + bgWidth, bgY + bgHeight, bgX + bgWidth - radius, bgY + bgHeight, radius);\r\n        context.lineTo(bgX + radius, bgY + bgHeight);\r\n        context.arcTo(bgX, bgY + bgHeight, bgX, bgY + bgHeight - radius, radius);\r\n        context.lineTo(bgX, bgY + radius);\r\n        context.arcTo(bgX, bgY, bgX + radius, bgY, radius);\r\n        context.closePath();\r\n        context.fill();\r\n        \r\n        // 绘制图标\r\n        context.drawImage(logoImg, logoX, logoY, logoSize, logoSize);\r\n        console.log('[SUCCESS] 图标已添加到二维码中心');\r\n      };\r\n      \r\n      logoImg.onerror = (err) => {\r\n        console.error('[ERROR] 加载图标失败:', err);\r\n      };\r\n      \r\n      // 设置图标源 - 使用chrome扩展资源路径\r\n      if (typeof chrome !== 'undefined' && chrome.runtime) {\r\n        // 在Chrome扩展环境中\r\n        logoImg.src = chrome.runtime.getURL('assets/icon48.png');\r\n      } else {\r\n        // 在开发环境中\r\n        logoImg.src = '../assets/icon48.png';\r\n      }\r\n      \r\n      console.log('[SUCCESS] 二维码已成功绘制到canvas');\r\n      // 确保qrcodeImageUrl为空\r\n      qrcodeImageUrl.value = '';\r\n    };\r\n    \r\n    img.onerror = (err) => {\r\n      console.error('[ERROR] 加载二维码图像失败:', err);\r\n    };\r\n    \r\n    // 设置图像源\r\n    img.src = dataURL;\r\n    console.log('[SUCCESS] 二维码数据URL已生成');\r\n  } catch (error) {\r\n    console.error('[ERROR] 生成二维码出错:', error);\r\n  }\r\n};\r\n\r\n// 通知状态已完全移除\r\n\r\n// 计算属性\r\nconst connectionButtonTitle = computed(() => {\r\n  if (serverActive.value) return '关闭服务器';\r\n  if (isConnecting.value) return '服务器启动中...';\r\n  return '连接服务器';\r\n});\r\n\r\nconst connectionIconClass = computed(() => {\r\n  if (isConnected.value) return 'icon-connected';\r\n  if (serverActive.value) return 'icon-server-active';\r\n  if (isConnecting.value) return 'icon-loading';\r\n  return 'icon-disconnected';\r\n});\r\n\r\n// 请求节点属性\r\nconst requestNodeProperty = (exId: number) => {\r\n    try {\r\n      sendMessage({\r\n        type: 'REQUEST_NODE_PROPERTY',\r\n        targetId: lowerId.value,\r\n        exId: exId,\r\n        timestamp: Date.now()\r\n      });\r\n      Logger.log('📤 已发送REQUEST_NODE_PROPERTY请求');\r\n    } catch (error) {\r\n      Logger.error('发送节点属性请求失败:', error);\r\n    }\r\n};\r\n\r\n// 删除节点函数\r\nconst deleteNode = (node: any) => {\r\n  if (node && node.exId !== undefined) {\r\n    try {\r\n      sendMessage({\r\n        type: 'DELETE_NODE_REQUEST',\r\n        targetId: lowerId.value,\r\n        exId: node.exId,\r\n        timestamp: Date.now()\r\n      });\r\n      Logger.log(`📤 已发送DELETE_NODE_REQUEST请求，exId: ${node.exId}`);\r\n    } catch (error) {\r\n      Logger.error('发送删除节点请求失败:', error);\r\n    }\r\n  }\r\n};\r\n\r\nconst onNodeSelect = (node: any) => {\r\n  selectedNode.value = node;\r\n  \r\n  if (node && node.exId !== undefined) {\r\n    selectedExId.value = node.exId;\r\n    // 即时更新\r\n    if (autoUpdate.value) {\r\n      startPropertyAutoUpdate();\r\n    }\r\n\r\n  } else {\r\n    if (autoUpdate.value) {\r\n      stopPropertyAutoUpdate();\r\n    }\r\n  }\r\n  \r\n  if (node && node.exId !== undefined && isConnected.value) {\r\n    Logger.log(`🎯 选中节点: ${node.name} (exId: ${node.exId})，请求节点属性`);\r\n    \r\n    try {\r\n      sendMessage({\r\n        type: 'REQUEST_NODE_PROPERTY',\r\n        targetId: lowerId.value,\r\n        exId: node.exId,\r\n        timestamp: Date.now()\r\n      });\r\n      Logger.log('📤 已发送REQUEST_NODE_PROPERTY请求');\r\n    } catch (error) {\r\n      Logger.error('发送节点属性请求失败:', error);\r\n    }\r\n  }\r\n};\r\n\r\nconst onPropertyChange = (component: any, property: any, value: any) => {\r\n  if (!selectedNode.value) return;\r\n  \r\n  // 更新本地属性值\r\n  if (selectedNode.value.properties) {\r\n    selectedNode.value.properties = selectedNode.value.properties.map((prop: any) => {\r\n      if (prop.key === property.name) {\r\n        return { ...prop, value: value };\r\n      }\r\n      return prop;\r\n    });\r\n  }\r\n  \r\n  // 只有在开启即时更新且已连接时才发送请求\r\n  if (isConnected.value) {\r\n    try {\r\n      sendMessage({\r\n        type: 'SET_NODE_PROPERTY_REQUEST',\r\n        targetId: lowerId.value,\r\n        exId: selectedNode.value.exId,\r\n        componentType: component.type,\r\n        propertyName: property.name,\r\n        value: value,\r\n        timestamp: Date.now()\r\n      });\r\n      Logger.log(`📤 已发送SET_NODE_PROPERTY_REQUEST请求: ${component.type}.${property.name} = ${value}`);\r\n    } catch (error) {\r\n      Logger.error('发送属性设置请求失败:', error);\r\n    }\r\n  }\r\n};\r\n\r\n// 辅助函数 - 根据ID查找节点\r\nconst findNodeById = (nodes: any[], id: string): any => {\r\n  for (const node of nodes) {\r\n    if (node.id === id) return node;\r\n    if (node.children && node.children.length > 0) {\r\n      const found = findNodeById(node.children, id);\r\n      if (found) return found;\r\n    }\r\n  }\r\n  return null;\r\n};\r\n\r\n\r\n// 生成随机会话ID\r\nconst generateSessionId = (): string => {\r\n  return Math.random().toString(36).substring(2, 10) + Date.now().toString(36);\r\n};\r\n\r\n\r\n\r\n// 监听WebSocket地址变化并保存到localStorage\r\nwatch(customWsAddress, (newAddress) => {\r\n  if (newAddress && newAddress.trim() !== '') {\r\n    localStorage.setItem('nano_ws_address', newAddress.trim());\r\n    console.log('已保存WebSocket地址到localStorage:', newAddress.trim());\r\n  }\r\n});\r\n\r\n// 服务器设置弹窗相关方法\r\nconst showServerSettings = () => {\r\n  // 打开设置弹窗时，将当前的WebSocket地址复制到临时变量\r\n  tempWsAddress.value = customWsAddress.value;\r\n  showSettings.value = true;\r\n};\r\n\r\nconst closeServerSettings = () => {\r\n  showSettings.value = false;\r\n};\r\n\r\nconst saveServerSettings = () => {\r\n  // 保存设置并关闭弹窗\r\n  if (tempWsAddress.value && tempWsAddress.value.trim() !== '') {\r\n    customWsAddress.value = tempWsAddress.value.trim();\r\n    localStorage.setItem('nano_ws_address', customWsAddress.value);\r\n    console.log('已保存WebSocket地址:', customWsAddress.value);\r\n  }\r\n  showSettings.value = false;\r\n};\r\n\r\n// 游戏控制方法\r\nconst togglePause = () => {\r\n  const newPausedState = !isPaused.value;\r\n  isPaused.value = newPausedState;\r\n  Logger.log(`游戏${newPausedState ? '暂停' : '恢复'}`);\r\n  \r\n  if (!isConnected.value) {\r\n    Logger.warn('未连接，无法发送暂停/恢复指令');\r\n    return;\r\n  }\r\n  \r\n  // 通过设置timeScale来实现暂停/恢复\r\n  const targetTimeScale = newPausedState ? 0 : 1;\r\n  timeScale.value = targetTimeScale;\r\n  \r\n  try {\r\n    sendMessage({\r\n      type: 'SET_TIMESCALE_REQUEST',\r\n      targetId: lowerId.value,\r\n      timeScale: targetTimeScale,\r\n      timestamp: Date.now()\r\n    });\r\n    Logger.log(`📤 已发送SET_TIMESCALE_REQUEST: ${targetTimeScale} (${newPausedState ? '暂停' : '恢复'})`);\r\n  } catch (error) {\r\n    Logger.error('发送暂停/恢复指令失败:', error);\r\n  }\r\n};\r\n\r\nconst nextFrame = () => {\r\n  if (!isPaused.value) {\r\n    Logger.warn('只有在暂停状态下才能使用下一帧功能');\r\n    return;\r\n  }\r\n  \r\n  Logger.log('请求执行下一帧');\r\n  \r\n  if (!isConnected.value) {\r\n    Logger.warn('未连接，无法发送下一帧指令');\r\n    return;\r\n  }\r\n  \r\n  try {\r\n    sendMessage({\r\n      type: 'NEXT_FRAME_REQUEST',\r\n      targetId: lowerId.value,\r\n      timestamp: Date.now()\r\n    });\r\n    Logger.log('📤 已发送NEXT_FRAME_REQUEST');\r\n  } catch (error) {\r\n    Logger.error('发送下一帧指令失败:', error);\r\n  }\r\n};\r\n\r\nconst onTimeScaleChange = () => {\r\n  // 确保值在有效范围内\r\n  if (timeScale.value < 0) timeScale.value = 0;\r\n  if (timeScale.value > 50) timeScale.value = 50;\r\n  \r\n  // 格式化为三位小数\r\n  timeScale.value = Math.round(timeScale.value * 1000) / 1000;\r\n  \r\n  Logger.log(`手动设置时间倍速为: ${timeScale.value}`);\r\n  \r\n  // 更新暂停状态（如果timeScale为0则认为是暂停状态）\r\n  isPaused.value = timeScale.value === 0;\r\n  \r\n  if (!isConnected.value) {\r\n    Logger.warn('未连接，无法发送TimeScale设置请求');\r\n    return;\r\n  }\r\n  \r\n  try {\r\n    sendMessage({\r\n      type: 'SET_TIMESCALE_REQUEST',\r\n      targetId: lowerId.value,\r\n      timeScale: timeScale.value,\r\n      timestamp: Date.now()\r\n    });\r\n    Logger.log(`📤 已发送SET_TIMESCALE_REQUEST: ${timeScale.value}`);\r\n  } catch (error) {\r\n    Logger.error('发送TimeScale设置请求失败:', error);\r\n  }\r\n};\r\n\r\n// 面板操作方法\r\nconst refreshTree = () => {\r\n  if (isRefreshing.value) return;\r\n  \r\n  if (!isConnected.value) {\r\n    Logger.warn('未连接，无法刷新场景层级树');\r\n    return;\r\n  }\r\n  \r\n  isRefreshing.value = true;\r\n  Logger.log('发送刷新场景层级树请求');\r\n  \r\n  try {\r\n    sendMessage({\r\n      type: 'REFRESH_NODE_TREE_REQUEST',\r\n      targetId: lowerId.value,\r\n      timestamp: Date.now()\r\n    });\r\n    Logger.log('📤 已发送REFRESH_NODE_TREE_REQUEST');\r\n  } catch (error) {\r\n    Logger.error('发送刷新请求失败:', error);\r\n    isRefreshing.value = false;\r\n  }\r\n  \r\n  // 设置超时，避免一直处于刷新状态\r\n  setTimeout(() => {\r\n    if (isRefreshing.value) {\r\n      isRefreshing.value = false;\r\n      Logger.warn('刷新请求超时');\r\n    }\r\n  }, 5000);\r\n};\r\n\r\n// 递归展开所有节点\r\nconst expandNodes = (nodes: any[]) => {\r\n  nodes.forEach(node => {\r\n    node.expanded = true;\r\n    if (node.children) {\r\n      expandNodes(node.children);\r\n    }\r\n  });\r\n};\r\n\r\n// 递归折叠所有节点\r\nconst collapseNodes = (nodes: any[]) => {\r\n  nodes.forEach(node => {\r\n    node.expanded = false;\r\n    if (node.children) {\r\n      collapseNodes(node.children);\r\n    }\r\n  });\r\n};\r\n\r\nconst expandAll = () => {\r\n  Logger.log('展开所有节点');\r\n  expandNodes(treeNodes.value);\r\n};\r\n\r\nconst collapseAll = () => {\r\n  Logger.log('折叠所有节点');\r\n  collapseNodes(treeNodes.value);\r\n};\r\n\r\nconst toggleSelBoxMark = () => {\r\n  isSelBoxMarkEnabled.value = !isSelBoxMarkEnabled.value;\r\n  Logger.log('切换选择框标记状态:', isSelBoxMarkEnabled.value);\r\n  // TODO: 向Nano设备发送选择框标记指令\r\n};\r\n\r\n// 即时更新配置变更处理\r\nconst onAutoUpdateChange = () => {\r\n  // 保存到localStorage进行持久化存储\r\n  localStorage.setItem('nano_auto_update', autoUpdate.value.toString());\r\n  Logger.log('即时更新配置已更改:', autoUpdate.value);\r\n  \r\n  // 发送即时更新配置变更消息到上位机\r\n  if (isConnected.value) {\r\n    try {\r\n      sendMessage({\r\n        type: 'SET_AUTO_UPDATE_FLAG',\r\n        targetId: lowerId.value,\r\n        autoUpdateFlag: autoUpdate.value,\r\n        timestamp: Date.now()\r\n      });\r\n      Logger.log(`📤 已发送SET_AUTO_UPDATE_FLAG消息: autoUpdate = ${autoUpdate.value}`);\r\n    } catch (error) {\r\n      Logger.error('发送SET_AUTO_UPDATE_FLAG消息失败:', error);\r\n    }\r\n  }\r\n  \r\n  if (autoUpdate.value && selectedNode.value && selectedNode.value.exId !== undefined) {\r\n    // 如果开启即时更新且有选中节点，立即开始属性自动更新\r\n    startPropertyAutoUpdate();\r\n  } else if (!autoUpdate.value) {\r\n    // 如果关闭即时更新，停止属性自动更新\r\n    stopPropertyAutoUpdate();\r\n  }\r\n};\r\n\r\n// 调试Stat配置变更处理\r\nconst onStatChange = () => {\r\n  Logger.log('调试Stat配置已更改:', isStatEnabled.value);\r\n  \r\n  // 发送STAT_REQUEST消息到下位机\r\n  if (isConnected.value) {\r\n    try {\r\n      sendMessage({\r\n        type: 'STAT_REQUEST',\r\n        targetId: lowerId.value,\r\n        isShow: isStatEnabled.value,\r\n        timestamp: Date.now()\r\n      });\r\n      Logger.log(`📤 已发送STAT_REQUEST消息: isShow = ${isStatEnabled.value}`);\r\n    } catch (error) {\r\n      Logger.error('发送STAT_REQUEST消息失败:', error);\r\n    }\r\n  } else {\r\n    Logger.warn('未连接，无法发送STAT_REQUEST消息');\r\n  }\r\n};\r\n\r\n// Render按钮点击处理\r\nconst onRenderClick = () => {\r\n  Logger.log('Render按钮被点击，显示渲染信息面板');\r\n  \r\n  // 显示Render悬浮面板\r\n  if (renderPanelRef.value) {\r\n    renderPanelRef.value.showPanel();\r\n  }\r\n};\r\n\r\n// VConsole按钮点击处理\r\nconst onVConsoleClick = () => {\r\n  Logger.log('VConsole按钮被点击，显示控制台面板');\r\n  \r\n  // 显示VConsole悬浮面板\r\n  if (vconsolePanelRef.value) {\r\n    vconsolePanelRef.value.showPanel();\r\n  }\r\n};\r\n\r\n// 打开使用说明文档\r\nconst openHelpDocument = () => {\r\n  const helpUrl = 'https://womenzhai.cn/articleDetail?article_id=68a22445b1f0e960ad6e2379';\r\n  window.open(helpUrl, '_blank');\r\n  Logger.log('已打开使用说明文档:', helpUrl);\r\n};\r\n\r\nconst toggleNanoServer = () => {\r\n  if (serverActive.value) {\r\n    closeNanoServer();\r\n    // 清除二维码相关状态\r\n    showQrcode.value = false;\r\n    qrcodeData.value = null;\r\n  } else {\r\n    let address = customWsAddress.value.trim();\r\n    if (!address) {\r\n      const host = window.location.hostname || 'localhost';\r\n      address = `ws://${host}:${serverPort.value}`;\r\n      customWsAddress.value = address;\r\n    }\r\n    startNanoServer(address);\r\n  }\r\n};\r\n\r\n// 复制二维码信息\r\nconst copyQrcodeInfo = async () => {\r\n  if (!qrcodeData.value) {\r\n    Logger.warn('没有二维码数据可复制');\r\n    return;\r\n  }\r\n  \r\n  try {\r\n    // 创建包含设备ID和服务器地址的JSON字符串\r\n    const qrInfo = JSON.stringify({\r\n      uid: qrcodeData.value.uid,\r\n      url: qrcodeData.value.url\r\n    });\r\n    \r\n    // 复制到剪贴板\r\n    await navigator.clipboard.writeText(qrInfo);\r\n    Logger.log('二维码信息已复制到剪贴板:', qrInfo);\r\n    \r\n    // 可以添加一个简单的提示\r\n    console.log('二维码信息已复制到剪贴板');\r\n  } catch (error) {\r\n    Logger.error('复制二维码信息失败:', error);\r\n    \r\n    // 降级方案：使用传统的复制方法\r\n    try {\r\n      const qrInfo = JSON.stringify({\r\n        uid: qrcodeData.value.uid,\r\n        url: qrcodeData.value.url\r\n      });\r\n      \r\n      const textArea = document.createElement('textarea');\r\n      textArea.value = qrInfo;\r\n      document.body.appendChild(textArea);\r\n      textArea.select();\r\n      document.execCommand('copy');\r\n      document.body.removeChild(textArea);\r\n      \r\n      Logger.log('二维码信息已复制到剪贴板(降级方案):', qrInfo);\r\n      console.log('二维码信息已复制到剪贴板');\r\n    } catch (fallbackError) {\r\n      Logger.error('复制失败:', fallbackError);\r\n      console.error('复制失败:', fallbackError);\r\n    }\r\n  }\r\n};\r\n\r\n// 生命周期钩子\r\nonMounted(() => {\r\n  // 初始化资源\r\n  console.log('Nano组件已挂载');\r\n  \r\n  // 从localStorage加载保存的WebSocket地址\r\n  const savedWsAddress = localStorage.getItem('nano_ws_address');\r\n  if (savedWsAddress) {\r\n    customWsAddress.value = savedWsAddress;\r\n    tempWsAddress.value = savedWsAddress;\r\n    console.log('已加载保存的WebSocket地址:', savedWsAddress);\r\n  }\r\n  \r\n  // 从localStorage加载即时更新配置\r\n  const savedAutoUpdate = localStorage.getItem('nano_auto_update');\r\n  if (savedAutoUpdate !== null) {\r\n    autoUpdate.value = savedAutoUpdate === 'true';\r\n    console.log('已加载即时更新配置:', autoUpdate.value);\r\n  }\r\n});\r\n\r\n// 为子组件提供sendMessage方法和lowerId\r\nprovide('sendMessage', sendMessage);\r\nprovide('lowerId', lowerId);\r\n\r\n// 暴露组件方法和状态给父组件\r\ndefineExpose({\r\n  isConnected: () => isConnected.value,\r\n  serverActive: () => serverActive.value,\r\n  hasActiveConnection: () => isConnected.value || serverActive.value\r\n});\r\n\r\nonUnmounted(() => {\r\n  // 清理资源\r\n  console.log('Nano组件将卸载，清理资源');\r\n  \r\n  // 清理属性自动更新定时器\r\n  stopPropertyAutoUpdate();\r\n  \r\n  // 清除二维码相关状态\r\n  showQrcode.value = false;\r\n  qrcodeData.value = null;\r\n  \r\n  // 关闭服务器\r\n  if (serverActive.value) {\r\n    closeNanoServer();\r\n  }\r\n});\r\n</script>\r\n\r\n<style scoped>\r\n/* CSS 变量定义 */\r\n.nano-container {\r\n  /* 深色主题变量 */\r\n  --bg-primary: linear-gradient(135deg, #0a0e17 0%, #0f1419 40%, #1a1f29 100%);\r\n  --bg-secondary: linear-gradient(135deg, rgba(15, 20, 25, 0.95) 0%, rgba(26, 31, 41, 0.95) 100%);\r\n  --bg-panel: linear-gradient(135deg, rgba(15, 20, 25, 0.9) 0%, rgba(26, 31, 41, 0.8) 100%);\r\n  --bg-card: linear-gradient(135deg, rgba(15, 20, 25, 0.7) 0%, rgba(26, 31, 41, 0.5) 100%);\r\n  --bg-card-secondary: rgba(26, 31, 41, 0.6);\r\n  --bg-input: rgba(15, 20, 25, 0.8);\r\n  --bg-button: rgba(26, 31, 41, 0.7);\r\n  --bg-button-hover: rgba(26, 31, 41, 0.9);\r\n  --text-primary: #f0f2f5;\r\n  --text-secondary: #b8c5d1;\r\n  --text-accent: #4dd4ff;\r\n  --accent-primary: #0aa2ff;\r\n  --accent-secondary: #40e0d0;\r\n  --border-primary: rgba(0, 162, 255, 0.2);\r\n  --border-accent: rgba(0, 162, 255, 0.4);\r\n  --shadow-primary: rgba(0, 0, 0, 0.3);\r\n  --shadow-accent: rgba(0, 162, 255, 0.3);\r\n  --text-glow: 0 0 8px rgba(0, 162, 255, 0.5);\r\n  --text-glow-accent: 0 0 4px rgba(0, 162, 255, 0.3);\r\n  --text-glow-secondary: 0 0 6px rgba(0, 162, 255, 0.3);\r\n  --color-success: #4CD964;\r\n  --color-error: #FF3B30;\r\n  --color-warning: #ffb638;\r\n  --color-info: #64D2FF;\r\n  \r\n  display: flex;\r\n  flex-direction: column;\r\n  height: 100%;\r\n  overflow: hidden;\r\n  background: var(--bg-primary);\r\n  color: var(--text-primary);\r\n  font-family: 'SF Pro Display', -apple-system, BlinkMacSystemFont, 'Inter', 'Segoe UI', Helvetica, Arial, sans-serif;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n/* 浅色主题变量 */\r\n.nano-container.light-mode {\r\n  --bg-primary: #f8fafc;\r\n  --bg-secondary: rgba(248, 250, 252, 0.95);\r\n  --bg-panel: rgba(255, 255, 255, 0.9);\r\n  --bg-card: rgba(255, 255, 255, 0.8);\r\n  --bg-card-secondary: rgba(248, 250, 252, 0.8);\r\n  --bg-input: rgba(255, 255, 255, 0.9);\r\n  --bg-button: rgba(248, 250, 252, 0.7);\r\n  --bg-button-hover: rgba(248, 250, 252, 0.9);\r\n  --text-primary: #1e293b;\r\n  --text-secondary: #475569;\r\n  --text-accent: #0369a1;\r\n  --accent-primary: #0ea5e9;\r\n  --accent-secondary: #14b8a6;\r\n  --border-primary: rgba(0, 0, 0, 0.08);\r\n  --border-accent: rgba(0, 0, 0, 0.12);\r\n  --shadow-primary: rgba(0, 0, 0, 0.05);\r\n  --shadow-accent: rgba(0, 0, 0, 0.1);\r\n  --text-glow: 0 1px 2px rgba(0, 0, 0, 0.05);\r\n  --text-glow-accent: 0 1px 1px rgba(0, 0, 0, 0.08);\r\n  --text-glow-secondary: 0 1px 2px rgba(0, 0, 0, 0.06);\r\n  --color-success: #22c55e;\r\n  --color-error: #ef4444;\r\n  --color-warning: #f59e0b;\r\n  --color-info: #3b82f6;\r\n}\r\n\r\n.panel-title {\r\n  font-size: 16px;\r\n  font-weight: 600;\r\n  color: var(--text-primary);\r\n  text-shadow: var(--text-glow);\r\n}\r\n\r\n.status-btn {\r\n  width: auto;\r\n  padding: 0 12px;\r\n  font-size: 13px;\r\n  font-weight: 500;\r\n  text-align: center; /* 确保文本居中 */\r\n  min-width: 130px; /* 设置最小宽度，确保按钮大小一致 */\r\n  justify-content: center; /* 确保内容居中 */\r\n  height: 28px; /* 固定高度 */\r\n  box-sizing: border-box; /* 确保padding不会增加元素的总高度 */\r\n}\r\n\r\n.icon-connected {\r\n  color: var(--color-success, #4CD964);\r\n  border-color: var(--color-success, #4CD964);\r\n}\r\n\r\n.icon-server-active {\r\n  color: var(--color-info, #64D2FF);\r\n  border-color: var(--color-info, #64D2FF);\r\n}\r\n\r\n.icon-loading {\r\n  color: var(--color-warning, #ffb638);\r\n  border-color: var(--color-warning, #ffb638);\r\n}\r\n\r\n.icon-disconnected {\r\n  color: var(--color-error, #FF3B30);\r\n  border-color: var(--color-error, #FF3B30);\r\n  position: relative;\r\n  padding-left: 24px;\r\n}\r\n\r\n.action-btn:hover:not(:disabled) {\r\n  background: var(--bg-button-hover);\r\n  color: var(--text-primary);\r\n  border-color: var(--border-accent);\r\n  box-shadow: 0 0 8px var(--shadow-accent);\r\n}\r\n\r\n.action-btn:disabled {\r\n  opacity: 0.5;\r\n  cursor: not-allowed;\r\n}\r\n\r\n.action-btn.connecting i,\r\n.action-btn.refreshing i {\r\n  animation: spin 1s linear infinite;\r\n}\r\n\r\n.action-btn.connected {\r\n  color: var(--color-success);\r\n  border-color: var(--color-success);\r\n}\r\n\r\n.icon-connected {\r\n  position: relative;\r\n  padding-left: 24px;\r\n}\r\n\r\n.icon-connected::before {\r\n  content: '';\r\n  position: absolute;\r\n  left: 8px;\r\n  top: 50%;\r\n  transform: translateY(-50%);\r\n  width: 16px;\r\n  height: 16px;\r\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%234CD964\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><path d=\"M5 12h14\"></path><path d=\"M12 5l7 7-7 7\"></path></svg>');\r\n  background-repeat: no-repeat;\r\n  background-position: center;\r\n}\r\n\r\n.icon-disconnected::before {\r\n  content: '';\r\n  position: absolute;\r\n  left: 8px;\r\n  top: 50%;\r\n  transform: translateY(-50%);\r\n  width: 16px;\r\n  height: 16px;\r\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23FF3B30\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><circle cx=\"12\" cy=\"12\" r=\"10\"></circle><line x1=\"15\" y1=\"9\" x2=\"9\" y2=\"15\"></line><line x1=\"9\" y1=\"9\" x2=\"15\" y2=\"15\"></line></svg>');\r\n  background-repeat: no-repeat;\r\n  background-position: center;\r\n}\r\n\r\n.icon-server-active {\r\n  position: relative;\r\n  padding-left: 24px;\r\n}\r\n\r\n.icon-server-active::before {\r\n  content: '';\r\n  position: absolute;\r\n  left: 8px;\r\n  top: 50%;\r\n  transform: translateY(-50%);\r\n  width: 16px;\r\n  height: 16px;\r\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%2364D2FF\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><rect x=\"2\" y=\"2\" width=\"20\" height=\"8\" rx=\"2\" ry=\"2\"></rect><rect x=\"2\" y=\"14\" width=\"20\" height=\"8\" rx=\"2\" ry=\"2\"></rect><line x1=\"6\" y1=\"6\" x2=\"6.01\" y2=\"6\"></line><line x1=\"6\" y1=\"18\" x2=\"6.01\" y2=\"18\"></line></svg>');\r\n  background-repeat: no-repeat;\r\n  background-position: center;\r\n}\r\n\r\n.icon-loading {\r\n  position: relative;\r\n  padding-left: 24px;\r\n}\r\n\r\n.icon-loading::before {\r\n  content: '';\r\n  position: absolute;\r\n  left: 8px;\r\n  top: 50%;\r\n  transform: translateY(-50%);\r\n  width: 16px;\r\n  height: 16px;\r\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23ffb638\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><circle cx=\"12\" cy=\"12\" r=\"10\"></circle><path d=\"M16 12a4 4 0 1 1-8 0\"></path></svg>');\r\n  background-repeat: no-repeat;\r\n  background-position: center;\r\n  animation: spin 1s linear infinite;\r\n}\r\n\r\n.nano-content {\r\n  flex: 1;\r\n  overflow: hidden;\r\n  display: flex;\r\n  flex-direction: column;\r\n}\r\n\r\n.connection-guide {\r\n  display: flex;\r\n  flex-direction: column;\r\n  align-items: center;\r\n  justify-content: center;\r\n  height: 100%;\r\n  padding: 20px;\r\n}\r\n\r\n.guide-content {\r\n  max-width: 500px;\r\n  text-align: center;\r\n  background: var(--bg-card);\r\n  border-radius: 12px;\r\n  padding: 24px;\r\n  box-shadow: 0 8px 32px var(--shadow-primary);\r\n  border: 1px solid var(--border-primary);\r\n}\r\n\r\n.guide-content i {\r\n  font-size: 48px;\r\n  color: var(--accent-primary);\r\n  margin-bottom: 16px;\r\n  display: block;\r\n}\r\n\r\n.guide-title {\r\n  font-size: 18px;\r\n  font-weight: 600;\r\n  margin-bottom: 16px;\r\n  color: var(--text-primary);\r\n}\r\n\r\n.guide-details {\r\n  text-align: left;\r\n}\r\n\r\n.guide-text {\r\n  margin-bottom: 12px;\r\n  color: var(--text-secondary);\r\n}\r\n\r\n.guide-steps {\r\n  margin-bottom: 24px;\r\n  padding: 16px;\r\n  background: var(--bg-panel);\r\n  border-radius: 16px;\r\n  border: 1px solid var(--border-primary);\r\n  box-shadow: 0 4px 16px var(--shadow-primary);\r\n  backdrop-filter: blur(24px);\r\n  position: relative;\r\n  overflow: hidden;\r\n}\r\n\r\n.guide-steps::before {\r\n  content: '';\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  right: 0;\r\n  height: 2px;\r\n  background: linear-gradient(90deg, var(--accent-primary) 0%, var(--accent-secondary, #4A9EFF) 100%);\r\n}\r\n\r\n.guide-steps li {\r\n  margin-bottom: 8px;\r\n  color: var(--text-secondary);\r\n}\r\n\r\n.step {\r\n  margin-bottom: 16px;\r\n  padding: 16px 20px;\r\n  background: var(--bg-card);\r\n  border-radius: 8px;\r\n  border: 1px solid var(--border-primary);\r\n  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n  position: relative;\r\n  overflow: hidden;\r\n}\r\n\r\n.step:last-child {\r\n  margin-bottom: 0;\r\n}\r\n\r\n.step::before {\r\n  content: '';\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  width: 3px;\r\n  height: 100%;\r\n  background: linear-gradient(180deg, var(--accent-primary) 0%, var(--accent-secondary, #4A9EFF) 100%);\r\n  border-radius: 0 2px 2px 0;\r\n}\r\n\r\n.step:hover {\r\n  transform: translateY(-1px);\r\n  background: var(--bg-panel);\r\n  border-color: var(--border-accent);\r\n  box-shadow: 0 2px 8px var(--shadow-primary);\r\n}\r\n\r\n.step-title {\r\n  font-size: 15px;\r\n  font-weight: 600;\r\n  color: var(--accent-primary);\r\n  margin-bottom: 10px;\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 6px;\r\n}\r\n\r\n.step-title::before {\r\n  content: '●';\r\n  font-size: 12px;\r\n  color: var(--accent-primary);\r\n  opacity: 0.8;\r\n}\r\n\r\n.step-content {\r\n  margin-left: 0;\r\n}\r\n\r\n.step-desc {\r\n  margin-bottom: 8px;\r\n  color: var(--text-secondary);\r\n  line-height: 1.6;\r\n  padding-left: 16px;\r\n  position: relative;\r\n  transition: color 0.2s;\r\n}\r\n\r\n.step-desc::before {\r\n  content: '▸';\r\n  position: absolute;\r\n  left: 0;\r\n  color: var(--accent-primary);\r\n  font-weight: bold;\r\n  transition: transform 0.2s;\r\n}\r\n\r\n.step:hover .step-desc {\r\n  color: var(--text-primary);\r\n}\r\n\r\n.step:hover .step-desc::before {\r\n  transform: translateX(2px);\r\n}\r\n\r\n\r\n\r\n.connection-status-box {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  gap: 8px;\r\n  margin-top: 16px;\r\n  padding: 8px;\r\n  background: var(--bg-panel);\r\n  border-radius: 8px;\r\n  border: 1px solid var(--border-primary);\r\n}\r\n\r\n.status-indicator {\r\n  width: 12px;\r\n  height: 12px;\r\n  border-radius: 50%;\r\n  background: var(--color-error);\r\n}\r\n\r\n.status-indicator.active {\r\n  background: var(--color-success);\r\n}\r\n\r\n.status-indicator.connecting {\r\n  background-color: #ffb638;\r\n  animation: pulse 1.5s infinite;\r\n}\r\n\r\n.status-indicator.server-active {\r\n  background-color: var(--color-info, #64D2FF);\r\n  animation: pulse 2s infinite;\r\n}\r\n\r\n\r\n\r\n.server-info {\r\n  display: flex;\r\n  flex-direction: column;\r\n  align-items: center;\r\n  width: 100%;\r\n  max-width: 500px;\r\n  margin-bottom: 20px;\r\n  padding: 16px;\r\n  background-color: rgba(100, 210, 255, 0.05);\r\n  border-radius: 6px;\r\n  border: 1px solid rgba(100, 210, 255, 0.2);\r\n}\r\n\r\n.server-config {\r\n  margin-top: 20px;\r\n  margin-bottom: 20px;\r\n  padding: 15px;\r\n  background: var(--bg-card-secondary);\r\n  border-radius: 8px;\r\n  width: 100%;\r\n}\r\n\r\n.ws-input-container {\r\n  display: flex;\r\n  flex-direction: column;\r\n  margin-bottom: 10px;\r\n}\r\n\r\n.ws-input-label {\r\n  font-size: 14px;\r\n  font-weight: 500;\r\n  margin-bottom: 8px;\r\n  color: var(--text-primary);\r\n}\r\n\r\n.ws-input-box {\r\n  display: flex;\r\n  align-items: center;\r\n}\r\n\r\n.ws-address-input {\r\n  flex: 1;\r\n  width: 350px;\r\n  padding: 8px 12px;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 4px;\r\n  background: var(--bg-input);\r\n  color: var(--text-primary);\r\n  font-family: monospace;\r\n  font-size: 14px;\r\n  outline: none;\r\n  transition: border-color 0.2s;\r\n}\r\n\r\n.ws-address-input:focus {\r\n  border-color: var(--accent-primary);\r\n}\r\n\r\n.ws-address-box {\r\n  display: flex;\r\n  align-items: center;\r\n  width: 100%;\r\n  margin-bottom: 12px;\r\n  padding: 8px 12px;\r\n  background-color: rgba(0, 0, 0, 0.2);\r\n  border-radius: 4px;\r\n}\r\n\r\n.ws-address-label {\r\n  font-size: 13px;\r\n  color: var(--text-secondary);\r\n  margin-right: 8px;\r\n}\r\n\r\n.ws-address-value {\r\n  flex: 1;\r\n  font-family: monospace;\r\n  color: var(--color-info, #64D2FF);\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n}\r\n\r\n.copy-btn {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  width: 24px;\r\n  height: 24px;\r\n  background-color: transparent;\r\n  border: none;\r\n  cursor: pointer;\r\n  opacity: 0.7;\r\n  transition: opacity 0.2s;\r\n  margin-left: 8px;\r\n}\r\n\r\n.copy-btn:hover {\r\n  opacity: 1;\r\n}\r\n\r\n.copy-icon {\r\n  display: inline-block;\r\n  width: 16px;\r\n  height: 16px;\r\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><rect x=\"9\" y=\"9\" width=\"13\" height=\"13\" rx=\"2\" ry=\"2\"></rect><path d=\"M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1\"></path></svg>');\r\n  background-position: center;\r\n  background-repeat: no-repeat;\r\n  background-size: contain;\r\n}\r\n\r\n.server-status {\r\n  font-size: 14px;\r\n  color: var(--text-secondary);\r\n  margin-bottom: 16px;\r\n}\r\n\r\n.test-btn {\r\n  padding: 6px 12px;\r\n  background-color: rgba(100, 210, 255, 0.1);\r\n  border: 1px solid rgba(100, 210, 255, 0.3);\r\n  border-radius: 4px;\r\n  color: var(--color-info, #64D2FF);\r\n  cursor: pointer;\r\n  font-size: 13px;\r\n  transition: background-color 0.2s;\r\n}\r\n\r\n.test-btn:hover {\r\n  background-color: rgba(100, 210, 255, 0.2);\r\n}\r\n\r\n/* 已连接状态的布局样式 */\r\n.nano-connected-layout {\r\n  display: flex;\r\n  height: 100%;\r\n  gap: 1px;\r\n}\r\n\r\n.tree-panel, .inspector-panel {\r\n  display: flex;\r\n  flex-direction: column;\r\n  background: var(--bg-card);\r\n  backdrop-filter: blur(16px);\r\n}\r\n\r\n.tree-panel {\r\n  flex: 1;\r\n  min-width: 320px;\r\n  max-width: 50%;\r\n  border-right: 1px solid var(--border-primary);\r\n}\r\n\r\n.inspector-panel {\r\n  flex: 1;\r\n  min-width: 320px;\r\n}\r\n\r\n.tree-container {\r\n  flex: 1;\r\n  overflow: auto;\r\n  padding: 8px;\r\n}\r\n\r\n/* 面板头部样式 */\r\n.panel-header {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: space-between;\r\n  padding: 12px 16px;\r\n  border-bottom: 1px solid var(--border-primary);\r\n  background: var(--bg-secondary);\r\n  backdrop-filter: blur(16px);\r\n  position: relative;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.panel-header h3 {\r\n  font-size: 15px;\r\n  font-weight: 600;\r\n  color: var(--text-primary);\r\n  margin: 0;\r\n  letter-spacing: -0.022em;\r\n  text-shadow: var(--text-glow);\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.panel-left {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 16px;\r\n}\r\n\r\n.panel-controls {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 16px;\r\n}\r\n\r\n.auto-update-control,\r\n.stat-control,\r\n.render-control {\r\n  display: flex;\r\n  align-items: center;\r\n}\r\n\r\n.checkbox-label {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 6px;\r\n  cursor: pointer;\r\n  font-size: 13px;\r\n  color: var(--text-secondary);\r\n  transition: color 0.2s ease;\r\n}\r\n\r\n.checkbox-label:hover {\r\n  color: var(--text-primary);\r\n}\r\n\r\n.checkbox-input {\r\n  width: 16px;\r\n  height: 16px;\r\n  border: 1px solid var(--border-accent);\r\n  border-radius: 3px;\r\n  background: var(--bg-input);\r\n  cursor: pointer;\r\n  position: relative;\r\n  transition: all 0.2s ease;\r\n  appearance: none;\r\n  -webkit-appearance: none;\r\n  -moz-appearance: none;\r\n}\r\n\r\n.checkbox-input:checked {\r\n  background: var(--accent-primary);\r\n  border-color: var(--accent-primary);\r\n}\r\n\r\n.checkbox-input:checked::after {\r\n  content: '✓';\r\n  position: absolute;\r\n  top: 50%;\r\n  left: 50%;\r\n  transform: translate(-50%, -50%);\r\n  color: white;\r\n  font-size: 10px;\r\n  font-weight: bold;\r\n}\r\n\r\n.checkbox-text {\r\n  user-select: none;\r\n}\r\n\r\n.render-btn {\r\n  padding: 6px 12px;\r\n  font-size: 13px;\r\n  font-weight: 500;\r\n  color: var(--text-primary);\r\n  background: var(--bg-button);\r\n  border: 1px solid var(--border-accent);\r\n  border-radius: 6px;\r\n  cursor: pointer;\r\n  transition: all 0.2s ease;\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 4px;\r\n  user-select: none;\r\n}\r\n\r\n.render-btn:hover {\r\n  background: var(--bg-button-hover);\r\n  border-color: var(--accent-primary);\r\n  color: var(--accent-primary);\r\n  transform: translateY(-1px);\r\n  box-shadow: 0 2px 8px var(--shadow-primary);\r\n}\r\n\r\n.render-btn:active {\r\n  transform: translateY(0);\r\n  box-shadow: 0 1px 4px var(--shadow-primary);\r\n}\r\n\r\n.help-btn {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 4px;\r\n  padding: 4px 8px;\r\n  border: 1px solid var(--border-accent);\r\n  background: var(--bg-card);\r\n  border-radius: 6px;\r\n  cursor: pointer;\r\n  font-size: 12px;\r\n  color: var(--text-secondary);\r\n  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n  box-shadow: 0 2px 8px var(--shadow-primary);\r\n  text-decoration: none;\r\n}\r\n\r\n.help-btn:hover {\r\n  background: var(--bg-panel);\r\n  color: var(--accent-primary);\r\n  border-color: var(--accent-primary);\r\n  box-shadow: 0 4px 16px var(--shadow-accent);\r\n  transform: translateY(-1px);\r\n  text-shadow: var(--text-glow-accent);\r\n}\r\n\r\n.help-icon {\r\n  display: inline-flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  width: 14px;\r\n  height: 14px;\r\n  border-radius: 50%;\r\n  background: var(--accent-primary);\r\n  color: white;\r\n  font-size: 10px;\r\n  font-weight: bold;\r\n  line-height: 1;\r\n}\r\n\r\n.panel-actions {\r\n  display: flex;\r\n  gap: 8px;\r\n}\r\n\r\n.action-btn {\r\n  width: 32px;\r\n  height: 32px;\r\n  border: 1px solid var(--border-accent);\r\n  background: var(--bg-card);\r\n  border-radius: 8px;\r\n  cursor: pointer;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n  font-size: 14px;\r\n  color: var(--text-secondary);\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  position: relative;\r\n  overflow: hidden;\r\n}\r\n\r\n.action-btn:hover {\r\n  background: var(--bg-panel);\r\n  color: var(--text-primary);\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 8px 32px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset,\r\n    0 0 16px var(--shadow-accent) inset;\r\n  transform: translateY(-1px);\r\n  text-shadow: var(--text-glow-accent);\r\n}\r\n\r\n.action-btn.refreshing {\r\n  pointer-events: none;\r\n  opacity: 0.7;\r\n}\r\n\r\n.action-btn.refreshing i {\r\n  animation: refreshSpin 1s linear infinite;\r\n}\r\n\r\n.action-btn:disabled {\r\n  opacity: 0.6;\r\n  cursor: not-allowed;\r\n  pointer-events: none;\r\n}\r\n\r\n.action-btn.active {\r\n  background: var(--accent-primary);\r\n  color: #ffffff;\r\n  border-color: var(--accent-primary);\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--accent-primary) inset,\r\n    0 0 12px var(--shadow-accent) inset;\r\n  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);\r\n}\r\n\r\n.action-btn.active:hover {\r\n  background: var(--accent-secondary);\r\n  border-color: var(--accent-secondary);\r\n}\r\n\r\n@keyframes refreshSpin {\r\n  from { transform: rotate(0deg); }\r\n  to { transform: rotate(360deg); }\r\n}\r\n\r\n/* 图标样式 */\r\n.icon-refresh::before { content: '⟳'; }\r\n.icon-expand::before { content: '⬇'; }\r\n.icon-collapse::before { content: '➤'; }\r\n.icon-flag::before { content: '🚩'; }\r\n.icon-loading::before { content: '⟲'; }\r\n\r\n.inspector-content {\r\n  flex: 1;\r\n  overflow: auto;\r\n  padding: 16px;\r\n}\r\n\r\n.no-selection-hint {\r\n  display: flex;\r\n  height: 100%;\r\n  align-items: center;\r\n  justify-content: center;\r\n  color: var(--text-secondary);\r\n  font-style: italic;\r\n}\r\n\r\n@keyframes spin {\r\n  from { transform: translateY(-50%) rotate(0deg); }\r\n  to { transform: translateY(-50%) rotate(360deg); }\r\n}\r\n\r\n@keyframes pulse {\r\n  0% { opacity: 0.6; }\r\n  50% { opacity: 1; }\r\n  100% { opacity: 0.6; }\r\n}\r\n\r\n\r\n\r\n/* 设置按钮样式 */\r\n.settings-btn {\r\n  width: auto;\r\n  padding: 0 12px;\r\n  font-size: 13px;\r\n  font-weight: 500;\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 6px;\r\n}\r\n\r\n.settings-icon {\r\n  display: inline-block;\r\n  width: 16px;\r\n  height: 16px;\r\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><circle cx=\"12\" cy=\"12\" r=\"3\"></circle><path d=\"M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z\"></path></svg>');\r\n  background-position: center;\r\n  background-repeat: no-repeat;\r\n  background-size: contain;\r\n}\r\n\r\n/* 服务器信息显示样式 */\r\n.ws-info-container {\r\n  display: flex;\r\n  flex-direction: column;\r\n  margin-bottom: 10px;\r\n}\r\n\r\n.ws-info-label {\r\n  font-size: 14px;\r\n  font-weight: 500;\r\n  margin-bottom: 8px;\r\n  color: var(--text-primary);\r\n}\r\n\r\n.ws-info-value {\r\n  font-family: monospace;\r\n  padding: 8px 12px;\r\n  background-color: rgba(0, 0, 0, 0.2);\r\n  border-radius: 4px;\r\n  color: var(--color-info, #64D2FF);\r\n  margin-bottom: 8px;\r\n  max-width: 500px;\r\n  width: 100%;\r\n}\r\n\r\n.ws-info-hint {\r\n  font-size: 12px;\r\n  color: var(--text-secondary);\r\n  font-style: italic;\r\n}\r\n\r\n/* 弹窗样式 */\r\n.modal-overlay {\r\n  position: fixed;\r\n  top: 0;\r\n  left: 0;\r\n  right: 0;\r\n  bottom: 0;\r\n  background-color: var(--bg-panel, #1e1e1e);\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  z-index: 1000;\r\n}\r\n\r\n.modal-container {\r\n  background: var(--bg-card);\r\n  border-radius: 8px;\r\n  box-shadow: 0 4px 16px rgba(0, 0, 0, 0.2);\r\n  width: 90%;\r\n  max-width: 600px;\r\n  max-height: 90vh;\r\n  display: flex;\r\n  flex-direction: column;\r\n  overflow: hidden;\r\n  border: 1px solid var(--border-primary);\r\n}\r\n\r\n.modal-header {\r\n  display: flex;\r\n  justify-content: space-between;\r\n  align-items: center;\r\n  padding: 16px;\r\n  border-bottom: 1px solid var(--border-primary);\r\n}\r\n\r\n.modal-header h3 {\r\n  margin: 0;\r\n  font-size: 16px;\r\n  font-weight: 600;\r\n  color: var(--text-primary);\r\n}\r\n\r\n.modal-close-btn {\r\n  background: transparent;\r\n  border: none;\r\n  cursor: pointer;\r\n  width: 24px;\r\n  height: 24px;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  opacity: 0.7;\r\n  transition: opacity 0.2s;\r\n}\r\n\r\n.modal-close-btn:hover {\r\n  opacity: 1;\r\n}\r\n\r\n.close-icon {\r\n  display: inline-block;\r\n  width: 16px;\r\n  height: 16px;\r\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><line x1=\"18\" y1=\"6\" x2=\"6\" y2=\"18\"></line><line x1=\"6\" y1=\"6\" x2=\"18\" y2=\"18\"></line></svg>');\r\n  background-position: center;\r\n  background-repeat: no-repeat;\r\n  background-size: contain;\r\n}\r\n\r\n.modal-content {\r\n  padding: 16px;\r\n  overflow-y: auto;\r\n  flex: 1;\r\n}\r\n\r\n.form-group {\r\n    margin-bottom: 16px;\r\n  }\r\n\r\n  .form-group label {\r\n    display: block;\r\n    margin-bottom: 8px;\r\n    font-size: 14px;\r\n    font-weight: 500;\r\n    color: var(--text-primary);\r\n  }\r\n  \r\n  .form-group input {\r\n    width: 100%;\r\n    padding: 8px 12px;\r\n    border-radius: 4px;\r\n    border: 1px solid var(--border-primary);\r\n    background-color: var(--bg-input);\r\n    color: var(--text-primary);\r\n    font-family: monospace;\r\n    font-size: 14px;\r\n  }\r\n\r\n.modal-footer {\r\n  display: flex;\r\n  justify-content: flex-end;\r\n  padding: 16px;\r\n  border-top: 1px solid var(--border-primary);\r\n  gap: 8px;\r\n}\r\n\r\n.cancel-btn, .save-btn {\r\n  padding: 8px 16px;\r\n  border-radius: 4px;\r\n  font-size: 14px;\r\n  font-weight: 500;\r\n  cursor: pointer;\r\n  transition: all 0.2s;\r\n}\r\n\r\n.cancel-btn {\r\n  background-color: transparent;\r\n  border: 1px solid var(--border-primary);\r\n  color: var(--text-secondary);\r\n}\r\n\r\n.cancel-btn:hover {\r\n  background-color: var(--bg-button-hover);\r\n  color: var(--text-primary);\r\n}\r\n\r\n.save-btn {\r\n  background-color: var(--color-info, #64D2FF);\r\n  border: 1px solid var(--color-info, #64D2FF);\r\n  color: var(--bg-card);\r\n}\r\n\r\n.save-btn:hover {\r\n  background-color: rgba(100, 210, 255, 0.8);\r\n}\r\n\r\n/* 二维码相关样式 */\r\n.qrcode-container {\r\n  display: flex;\r\n  flex-direction: column;\r\n  align-items: center;\r\n  padding: 20px;\r\n  background-color: var(--bg-card);\r\n  border-radius: 8px;\r\n  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);\r\n  margin: 20px auto;\r\n  max-width: 300px;\r\n}\r\n\r\n.qrcode-title {\r\n  font-size: 16px;\r\n  font-weight: 600;\r\n  margin-bottom: 15px;\r\n  color: var(--text-primary);\r\n}\r\n\r\n.qrcode-canvas {\r\n  background-color: white;\r\n  padding: 10px;\r\n  border-radius: 4px;\r\n  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);\r\n  cursor: pointer;\r\n  transition: all 0.2s ease;\r\n}\r\n\r\n.qrcode-canvas:hover {\r\n  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);\r\n  transform: scale(1.02);\r\n}\r\n\r\n.qrcode-image {\r\n  display: block;\r\n  max-width: 200px;\r\n  background-color: white;\r\n  padding: 10px;\r\n  border-radius: 4px;\r\n  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);\r\n  margin: 0 auto;\r\n}\r\n\r\n.qrcode-info {\r\n  margin-top: 15px;\r\n  width: 100%;\r\n  text-align: center;\r\n}\r\n\r\n.qrcode-id, .qrcode-url {\r\n  font-size: 14px;\r\n  color: var(--text-secondary);\r\n  margin: 5px 0;\r\n  word-break: break-all;\r\n}\r\n\r\n.waiting-connection {\r\n  display: flex;\r\n  flex-direction: column;\r\n  align-items: center;\r\n  padding: 30px;\r\n}\r\n\r\n.spinner {\r\n  width: 40px;\r\n  height: 40px;\r\n  border: 4px solid rgba(0, 0, 0, 0.1);\r\n  border-radius: 50%;\r\n  border-top-color: var(--color-info, #64D2FF);\r\n  animation: spin 1s ease-in-out infinite;\r\n  margin-bottom: 15px;\r\n}\r\n\r\n@keyframes spin {\r\n  to { transform: rotate(360deg); }\r\n}\r\n\r\n.waiting-text {\r\n  font-size: 16px;\r\n  color: var(--text-secondary);\r\n  margin-bottom: 15px;\r\n  position: relative;\r\n  display: inline-block;\r\n}\r\n\r\n.waiting-text-active {\r\n  animation: textPulse 1.5s infinite;\r\n}\r\n\r\n@keyframes textPulse {\r\n  0% { opacity: 0.6; }\r\n  50% { opacity: 1; }\r\n  100% { opacity: 0.6; }\r\n}\r\n\r\n.waiting-text-active::after {\r\n  content: '...';\r\n  position: absolute;\r\n  right: -12px;\r\n  animation: ellipsis 1.5s infinite;\r\n  width: 12px;\r\n  overflow: hidden;\r\n}\r\n\r\n@keyframes ellipsis {\r\n  0% { width: 0; }\r\n  50% { width: 12px; }\r\n  100% { width: 0; }\r\n}\r\n\r\n.debug-btn {\r\n  padding: 8px 16px;\r\n  background-color: #ff5722;\r\n  color: white;\r\n  border: none;\r\n  border-radius: 4px;\r\n  font-size: 14px;\r\n  cursor: pointer;\r\n  margin-top: 10px;\r\n  transition: background-color 0.2s;\r\n}\r\n\r\n.debug-btn:hover {\r\n  background-color: #e64a19;\r\n}\r\n</style>"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/NavigationTabs.vue?vue&type=style&index=0&id=7cc9069b&scoped=true&lang=css":
/*!************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/NavigationTabs.vue?vue&type=style&index=0&id=7cc9069b&scoped=true&lang=css ***!
  \************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
.nav-tabs[data-v-7cc9069b] {
  display: flex;
  gap: 2px;
  background: var(--bg-card);
  backdrop-filter: blur(16px);
  border-radius: 8px;
  padding: 3px;
  box-shadow: 
    0 8px 32px var(--shadow-primary),
    0 1px 0 var(--border-primary) inset,
    0 0 0 1px rgba(255, 255, 255, 0.05);
  border: 1px solid var(--border-primary);
  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}
.tab-button[data-v-7cc9069b] {
  display: flex;
  align-items: center;
  gap: 4px;
  padding: 6px 12px;
  border: none;
  background: transparent;
  border-radius: 6px;
  cursor: pointer;
  font-size: 11px;
  font-weight: 500;
  color: var(--text-secondary);
  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  letter-spacing: -0.008em;
  position: relative;
  overflow: hidden;
  border: 1px solid transparent;
}

/* 为tab按钮添加科技感光效 */
.tab-button[data-v-7cc9069b]::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));
  opacity: 0;
  transition: all 0.3s ease;
  border-radius: 6px;
}
.tab-button[data-v-7cc9069b]:hover:not(.active) {
  color: var(--text-primary);
  background: var(--bg-card);
  border-color: var(--border-primary);
  box-shadow: 
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--border-primary) inset;
  transform: translateY(-1px);
}
.tab-button[data-v-7cc9069b]:hover:not(.active)::before {
  opacity: 0.1;
}
.tab-button.active[data-v-7cc9069b] {
  background: var(--bg-panel);
  color: var(--text-primary);
  font-weight: 600;
  border-color: var(--border-accent);
  box-shadow: 
    0 8px 32px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset,
    0 0 20px var(--shadow-accent) inset;
  transform: translateY(-1px);
  text-shadow: var(--text-glow);
}
.tab-button.active[data-v-7cc9069b]::before {
  opacity: 0.15;
}

/* 图标字体 - 科技感符号 */
.icon-hierarchy[data-v-7cc9069b]::before { content: '⬢';
}
.icon-energy[data-v-7cc9069b]::before { content: '⚡';
}
.icon-nano[data-v-7cc9069b]::before { content: '◉';
}
.icon-debug[data-v-7cc9069b]::before { content: '⚙';
}
`, "",{"version":3,"sources":["webpack://./src/devtools/components/NavigationTabs.vue"],"names":[],"mappings":";AA4BA;EACE,aAAa;EACb,QAAQ;EACR,0BAA0B;EAC1B,2BAA2B;EAC3B,kBAAkB;EAClB,YAAY;EACZ;;;uCAGqC;EACrC,uCAAuC;EACvC,iDAAiD;AACnD;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,iBAAiB;EACjB,YAAY;EACZ,uBAAuB;EACvB,kBAAkB;EAClB,eAAe;EACf,eAAe;EACf,gBAAgB;EAChB,4BAA4B;EAC5B,yDAAyD;EACzD,wBAAwB;EACxB,kBAAkB;EAClB,gBAAgB;EAChB,6BAA6B;AAC/B;;AAEA,kBAAkB;AAClB;EACE,WAAW;EACX,kBAAkB;EAClB,MAAM;EACN,OAAO;EACP,QAAQ;EACR,SAAS;EACT,mFAAmF;EACnF,UAAU;EACV,yBAAyB;EACzB,kBAAkB;AACpB;AAEA;EACE,0BAA0B;EAC1B,0BAA0B;EAC1B,mCAAmC;EACnC;;yCAEuC;EACvC,2BAA2B;AAC7B;AAEA;EACE,YAAY;AACd;AAEA;EACE,2BAA2B;EAC3B,0BAA0B;EAC1B,gBAAgB;EAChB,kCAAkC;EAClC;;;uCAGqC;EACrC,2BAA2B;EAC3B,6BAA6B;AAC/B;AAEA;EACE,aAAa;AACf;;AAEA,iBAAiB;AACjB,2CAA0B,YAAY;AAAE;AACxC,wCAAuB,YAAY;AAAE;AACrC,sCAAqB,YAAY;AAAE;AACnC,uCAAsB,YAAY;AAAE","sourcesContent":["<template>\n  <nav class=\"nav-tabs\">\n    <button \n      v-for=\"tab in tabs\" \n      :key=\"tab.id\"\n      :class=\"['tab-button', { active: activeTab === tab.id }]\"\n      @click=\"$emit('switch-tab', tab.id)\"\n    >\n      <i :class=\"tab.icon\"></i>\n      <span>{{ tab.label }}</span>\n    </button>\n  </nav>\n</template>\n\n<script setup lang=\"ts\">\nimport type { Tab } from '../types/panel.types';\n\ndefineProps<{\n  tabs: Tab[];\n  activeTab: string;\n}>();\n\ndefineEmits<{\n  'switch-tab': [tabId: string];\n}>();\n</script>\n\n<style scoped>\n.nav-tabs {\n  display: flex;\n  gap: 2px;\n  background: var(--bg-card);\n  backdrop-filter: blur(16px);\n  border-radius: 8px;\n  padding: 3px;\n  box-shadow: \n    0 8px 32px var(--shadow-primary),\n    0 1px 0 var(--border-primary) inset,\n    0 0 0 1px rgba(255, 255, 255, 0.05);\n  border: 1px solid var(--border-primary);\n  transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);\n}\n\n.tab-button {\n  display: flex;\n  align-items: center;\n  gap: 4px;\n  padding: 6px 12px;\n  border: none;\n  background: transparent;\n  border-radius: 6px;\n  cursor: pointer;\n  font-size: 11px;\n  font-weight: 500;\n  color: var(--text-secondary);\n  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\n  letter-spacing: -0.008em;\n  position: relative;\n  overflow: hidden;\n  border: 1px solid transparent;\n}\n\n/* 为tab按钮添加科技感光效 */\n.tab-button::before {\n  content: '';\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));\n  opacity: 0;\n  transition: all 0.3s ease;\n  border-radius: 6px;\n}\n\n.tab-button:hover:not(.active) {\n  color: var(--text-primary);\n  background: var(--bg-card);\n  border-color: var(--border-primary);\n  box-shadow: \n    0 4px 16px var(--shadow-accent),\n    0 0 0 1px var(--border-primary) inset;\n  transform: translateY(-1px);\n}\n\n.tab-button:hover:not(.active)::before {\n  opacity: 0.1;\n}\n\n.tab-button.active {\n  background: var(--bg-panel);\n  color: var(--text-primary);\n  font-weight: 600;\n  border-color: var(--border-accent);\n  box-shadow: \n    0 8px 32px var(--shadow-accent),\n    0 0 0 1px var(--border-accent) inset,\n    0 0 20px var(--shadow-accent) inset;\n  transform: translateY(-1px);\n  text-shadow: var(--text-glow);\n}\n\n.tab-button.active::before {\n  opacity: 0.15;\n}\n\n/* 图标字体 - 科技感符号 */\n.icon-hierarchy::before { content: '⬢'; }\n.icon-energy::before { content: '⚡'; }\n.icon-nano::before { content: '◉'; }\n.icon-debug::before { content: '⚙'; }\n</style> "],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/PropertyInput.vue?vue&type=style&index=0&id=1bf9b39c&scoped=true&lang=css":
/*!***********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/PropertyInput.vue?vue&type=style&index=0&id=1bf9b39c&scoped=true&lang=css ***!
  \***********************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
.number-input[data-v-1bf9b39c] {
  width: 100%;
  padding: 4px 8px;
  border: 1px solid var(--border-primary);
  border-radius: 6px;
  font-size: 12px;
  background: var(--bg-card);
  backdrop-filter: blur(8px);
  color: var(--text-primary);
  font-family: 'SF Mono', Monaco, 'Cascadia Code', 'Roboto Mono', Consolas, 'Courier New', monospace;
  font-variant-numeric: tabular-nums;
  text-align: center;
  height: 28px;
  min-width: 45px;
  box-shadow: 
    0 2px 8px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.number-input[data-v-1bf9b39c]:focus {
  outline: none;
  border-color: var(--border-accent);
  box-shadow: 
    0 0 0 3px var(--shadow-accent),
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset;
  background: var(--bg-panel);
  transform: translateY(-1px);
  text-shadow: var(--text-glow-accent);
}
.number-input[data-v-1bf9b39c]:hover:not(:focus) {
  border-color: var(--border-accent);
  box-shadow: 
    0 4px 12px var(--shadow-accent),
    0 0 0 1px var(--border-primary) inset;
  cursor: ew-resize;
}
.number-input.dragging[data-v-1bf9b39c] {
  border-color: var(--accent-primary);
  box-shadow: 
    0 0 0 2px var(--accent-primary),
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--accent-primary) inset;
  background: var(--bg-panel);
  cursor: ew-resize !important;
  user-select: none;
}
.drag-overlay[data-v-1bf9b39c] {
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  cursor: ew-resize;
  z-index: 9999;
  pointer-events: none;
}

/* 移除浏览器默认的数字输入框样式 */
.number-input[data-v-1bf9b39c]::-webkit-outer-spin-button,
.number-input[data-v-1bf9b39c]::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}
.number-input[type=number][data-v-1bf9b39c] {
  -moz-appearance: textfield;
}

/* 拖拽状态下的特殊样式 */
.number-input.dragging[data-v-1bf9b39c]::selection {
  background: transparent;
}
.number-input.dragging[data-v-1bf9b39c]::-moz-selection {
  background: transparent;
}

/* 禁用状态样式 */
.number-input[data-v-1bf9b39c]:disabled {
  opacity: 0.7;
  cursor: not-allowed;
  background: var(--bg-disabled, rgba(128, 128, 128, 0.15));
  color: var(--text-primary);
  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));
  pointer-events: none;
}
.number-input[data-v-1bf9b39c]:disabled:hover {
  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));
  box-shadow: 
    0 2px 8px var(--shadow-primary),
    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;
  cursor: not-allowed;
  transform: none;
}
`, "",{"version":3,"sources":["webpack://./src/devtools/components/PropertyInput.vue"],"names":[],"mappings":";AAwMA;EACE,WAAW;EACX,gBAAgB;EAChB,uCAAuC;EACvC,kBAAkB;EAClB,eAAe;EACf,0BAA0B;EAC1B,0BAA0B;EAC1B,0BAA0B;EAC1B,kGAAkG;EAClG,kCAAkC;EAClC,kBAAkB;EAClB,YAAY;EACZ,eAAe;EACf;;yCAEuC;EACvC,yDAAyD;AAC3D;AAEA;EACE,aAAa;EACb,kCAAkC;EAClC;;;wCAGsC;EACtC,2BAA2B;EAC3B,2BAA2B;EAC3B,oCAAoC;AACtC;AAEA;EACE,kCAAkC;EAClC;;yCAEuC;EACvC,iBAAiB;AACnB;AAEA;EACE,mCAAmC;EACnC;;;yCAGuC;EACvC,2BAA2B;EAC3B,4BAA4B;EAC5B,iBAAiB;AACnB;AAEA;EACE,eAAe;EACf,MAAM;EACN,OAAO;EACP,QAAQ;EACR,SAAS;EACT,iBAAiB;EACjB,aAAa;EACb,oBAAoB;AACtB;;AAEA,oBAAoB;AACpB;;EAEE,wBAAwB;EACxB,SAAS;AACX;AAEA;EACE,0BAA0B;AAC5B;;AAEA,eAAe;AACf;EACE,uBAAuB;AACzB;AAEA;EACE,uBAAuB;AACzB;;AAEA,WAAW;AACX;EACE,YAAY;EACZ,mBAAmB;EACnB,yDAAyD;EACzD,0BAA0B;EAC1B,8DAA8D;EAC9D,oBAAoB;AACtB;AAEA;EACE,8DAA8D;EAC9D;;oEAEkE;EAClE,mBAAmB;EACnB,eAAe;AACjB","sourcesContent":["<template>\r\n  <input\r\n    ref=\"inputRef\"\r\n    type=\"number\"\r\n    :value=\"displayValue\"\r\n    :min=\"min\"\r\n    :max=\"max\"\r\n    :step=\"step\"\r\n    :disabled=\"disabled\"\r\n    @input=\"onInput\"\r\n    @focus=\"onFocus\"\r\n    @blur=\"onBlur\"\r\n    @mousedown=\"onMouseDown\"\r\n    @keydown=\"onKeyDown\"\r\n    class=\"number-input\"\r\n    :class=\"{ 'dragging': isDragging, 'disabled': disabled }\"\r\n  />\r\n  <div v-if=\"isDragging\" class=\"drag-overlay\"></div>\r\n</template>\r\n\r\n<script setup lang=\"ts\">\r\nimport { ref, computed, nextTick } from 'vue';\r\n\r\n// Props\r\ninterface Props {\r\n  value: number;\r\n  step?: number;\r\n  min?: number;\r\n  max?: number;\r\n  precision?: number;\r\n  disabled?: boolean;\r\n}\r\n\r\nconst props = withDefaults(defineProps<Props>(), {\r\n  step: 0.01,\r\n  min: undefined,\r\n  max: undefined,\r\n  precision: 5,\r\n  disabled: false\r\n});\r\n\r\n// Emits\r\nconst emit = defineEmits<{\r\n  change: [value: number];\r\n}>();\r\n\r\n// 响应式状态\r\nconst inputRef = ref<HTMLInputElement>();\r\nconst isDragging = ref(false);\r\nconst dragStartX = ref(0);\r\nconst dragStartValue = ref(0);\r\nconst isFocused = ref(false);\r\n\r\n// 计算显示值\r\nconst displayValue = computed(() => {\r\n  if (isFocused.value) {\r\n    // 焦点时显示原始值，便于编辑\r\n    return props.value;\r\n  }\r\n  // 非焦点时格式化显示\r\n  return Number(props.value.toFixed(props.precision));\r\n});\r\n\r\n// 约束值在范围内\r\nconst clampValue = (value: number): number => {\r\n  let result = value;\r\n  if (props.min !== undefined && result < props.min) {\r\n    result = props.min;\r\n  }\r\n  if (props.max !== undefined && result > props.max) {\r\n    result = props.max;\r\n  }\r\n  return result;\r\n};\r\n\r\n// 输入处理\r\nconst onInput = (event: Event) => {\r\n  if (props.disabled) return;\r\n  const target = event.target as HTMLInputElement;\r\n  const newValue = parseFloat(target.value);\r\n  if (!isNaN(newValue)) {\r\n    const clampedValue = clampValue(newValue);\r\n    emit('change', clampedValue);\r\n  }\r\n};\r\n\r\n// 焦点处理\r\nconst onFocus = () => {\r\n  if (props.disabled) return;\r\n  isFocused.value = true;\r\n};\r\n\r\nconst onBlur = () => {\r\n  if (props.disabled) return;\r\n  isFocused.value = false;\r\n  // 失去焦点时，确保值是有效的\r\n  if (inputRef.value) {\r\n    const currentValue = parseFloat(inputRef.value.value);\r\n    if (!isNaN(currentValue)) {\r\n      const clampedValue = clampValue(currentValue);\r\n      if (clampedValue !== currentValue) {\r\n        emit('change', clampedValue);\r\n      }\r\n    }\r\n  }\r\n};\r\n\r\n// 键盘处理\r\nconst onKeyDown = (event: KeyboardEvent) => {\r\n  if (props.disabled) return;\r\n  const target = event.target as HTMLInputElement;\r\n  \r\n  if (event.key === 'ArrowUp' || event.key === 'ArrowDown') {\r\n    event.preventDefault();\r\n    const currentValue = parseFloat(target.value) || 0;\r\n    const delta = event.key === 'ArrowUp' ? props.step : -props.step;\r\n    const newValue = clampValue(currentValue + delta);\r\n    emit('change', newValue);\r\n  } else if (event.key === 'Enter') {\r\n    target.blur();\r\n  }\r\n};\r\n\r\n// 鼠标拖拽处理\r\nconst onMouseDown = (event: MouseEvent) => {\r\n  if (props.disabled || event.button !== 0) return; // 只处理左键且非禁用状态\r\n  \r\n  const target = event.target as HTMLInputElement;\r\n  \r\n  // 检测是否是开始拖拽的操作（按住鼠标但不是文本选择）\r\n  let dragStartTime = Date.now();\r\n  let hasMoved = false;\r\n  \r\n  const startDrag = () => {\r\n    if (isDragging.value) return;\r\n    \r\n    isDragging.value = true;\r\n    dragStartX.value = event.clientX;\r\n    dragStartValue.value = props.value;\r\n    \r\n    // 设置拖拽光标\r\n    target.style.cursor = 'ew-resize';\r\n    document.body.style.cursor = 'ew-resize';\r\n    document.body.style.userSelect = 'none';\r\n    \r\n    // 阻止文本选择\r\n    target.blur();\r\n    event.preventDefault();\r\n  };\r\n  \r\n  // 全局鼠标事件\r\n  const handleMouseMove = (e: MouseEvent) => {\r\n    const deltaX = Math.abs(e.clientX - event.clientX);\r\n    \r\n    // 如果鼠标移动距离超过阈值，启动拖拽\r\n    if (!isDragging.value && deltaX > 3) {\r\n      hasMoved = true;\r\n      startDrag();\r\n    }\r\n    \r\n    if (!isDragging.value) return;\r\n    \r\n    const totalDeltaX = e.clientX - dragStartX.value;\r\n    const sensitivity = e.shiftKey ? 0.1 : 1; // Shift键降低灵敏度\r\n    const stepSize = props.step * sensitivity;\r\n    const deltaValue = (totalDeltaX / 3) * stepSize; // 3像素 = 1个步长，提高精度\r\n    \r\n    const newValue = clampValue(dragStartValue.value + deltaValue);\r\n    emit('change', newValue);\r\n  };\r\n  \r\n  const handleMouseUp = () => {\r\n    const dragDuration = Date.now() - dragStartTime;\r\n    \r\n    if (isDragging.value) {\r\n      isDragging.value = false;\r\n      \r\n      // 恢复光标\r\n      target.style.cursor = '';\r\n      document.body.style.cursor = '';\r\n      document.body.style.userSelect = '';\r\n    } else if (!hasMoved && dragDuration < 200) {\r\n      // 短时间点击且没有移动，聚焦输入框进行编辑\r\n      nextTick(() => {\r\n        target.focus();\r\n        target.select();\r\n      });\r\n    }\r\n    \r\n    // 移除事件监听器\r\n    document.removeEventListener('mousemove', handleMouseMove);\r\n    document.removeEventListener('mouseup', handleMouseUp);\r\n  };\r\n  \r\n  document.addEventListener('mousemove', handleMouseMove);\r\n  document.addEventListener('mouseup', handleMouseUp);\r\n};\r\n</script>\r\n\r\n<style scoped>\r\n.number-input {\r\n  width: 100%;\r\n  padding: 4px 8px;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 6px;\r\n  font-size: 12px;\r\n  background: var(--bg-card);\r\n  backdrop-filter: blur(8px);\r\n  color: var(--text-primary);\r\n  font-family: 'SF Mono', Monaco, 'Cascadia Code', 'Roboto Mono', Consolas, 'Courier New', monospace;\r\n  font-variant-numeric: tabular-nums;\r\n  text-align: center;\r\n  height: 28px;\r\n  min-width: 45px;\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.number-input:focus {\r\n  outline: none;\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 0 0 3px var(--shadow-accent),\r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset;\r\n  background: var(--bg-panel);\r\n  transform: translateY(-1px);\r\n  text-shadow: var(--text-glow-accent);\r\n}\r\n\r\n.number-input:hover:not(:focus) {\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 4px 12px var(--shadow-accent),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  cursor: ew-resize;\r\n}\r\n\r\n.number-input.dragging {\r\n  border-color: var(--accent-primary);\r\n  box-shadow: \r\n    0 0 0 2px var(--accent-primary),\r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--accent-primary) inset;\r\n  background: var(--bg-panel);\r\n  cursor: ew-resize !important;\r\n  user-select: none;\r\n}\r\n\r\n.drag-overlay {\r\n  position: fixed;\r\n  top: 0;\r\n  left: 0;\r\n  right: 0;\r\n  bottom: 0;\r\n  cursor: ew-resize;\r\n  z-index: 9999;\r\n  pointer-events: none;\r\n}\r\n\r\n/* 移除浏览器默认的数字输入框样式 */\r\n.number-input::-webkit-outer-spin-button,\r\n.number-input::-webkit-inner-spin-button {\r\n  -webkit-appearance: none;\r\n  margin: 0;\r\n}\r\n\r\n.number-input[type=number] {\r\n  -moz-appearance: textfield;\r\n}\r\n\r\n/* 拖拽状态下的特殊样式 */\r\n.number-input.dragging::selection {\r\n  background: transparent;\r\n}\r\n\r\n.number-input.dragging::-moz-selection {\r\n  background: transparent;\r\n}\r\n\r\n/* 禁用状态样式 */\r\n.number-input:disabled {\r\n  opacity: 0.7;\r\n  cursor: not-allowed;\r\n  background: var(--bg-disabled, rgba(128, 128, 128, 0.15));\r\n  color: var(--text-primary);\r\n  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));\r\n  pointer-events: none;\r\n}\r\n\r\n.number-input:disabled:hover {\r\n  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary),\r\n    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;\r\n  cursor: not-allowed;\r\n  transform: none;\r\n}\r\n</style>"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/PropertyInspector.vue?vue&type=style&index=0&id=9bc4e96e&scoped=true&lang=css":
/*!***************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/PropertyInspector.vue?vue&type=style&index=0&id=9bc4e96e&scoped=true&lang=css ***!
  \***************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
/* 图标定义 */
.icon-info[data-v-9bc4e96e]::before { content: 'ℹ';
}
.icon-transform3d[data-v-9bc4e96e]::before { content: '⚹';
}
.icon-transform2d[data-v-9bc4e96e]::before { content: '⚏';
}
.icon-camera[data-v-9bc4e96e]::before { content: '◉';
}
.icon-light[data-v-9bc4e96e]::before { content: '☀';
}
.icon-mesh[data-v-9bc4e96e]::before { content: '⬟';
}
.icon-material[data-v-9bc4e96e]::before { content: '◈';
}
.icon-component[data-v-9bc4e96e]::before { content: '⬡';
}
.icon-loading[data-v-9bc4e96e]::before { content: '⟲';
}
.icon-select[data-v-9bc4e96e]::before { content: '◯';
}
.icon-console[data-v-9bc4e96e]::before { content: '⌨';
}
.icon-jump[data-v-9bc4e96e]::before { content: '↗';
}
.property-inspector[data-v-9bc4e96e] {
  height: 100%;
  overflow-y: auto;
  padding: 0;
  /* 使用父级的 CSS 变量 */
}
.components-container[data-v-9bc4e96e] {
  display: flex;
  flex-direction: column;
  gap: 8px;
}
.component-group[data-v-9bc4e96e] {
  background: var(--bg-panel);
  backdrop-filter: blur(16px);
  border-radius: 8px;
  border: 1px solid var(--border-primary);
  overflow: hidden;
  box-shadow: 
    0 4px 16px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}
.component-group[data-v-9bc4e96e]:hover {
  border-color: var(--border-accent);
  box-shadow: 
    0 12px 40px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset;
  transform: translateY(-2px);
}
.component-header[data-v-9bc4e96e] {
  display: flex;
  align-items: center;
  gap: 6px;
  padding: 8px 12px;
  background: var(--bg-secondary);
  border-bottom: 1px solid var(--border-primary);
  position: relative;
}
.component-header i[data-v-9bc4e96e] {
  font-size: 14px;
  color: var(--text-accent);
  filter: drop-shadow(var(--text-glow-accent));
}
.component-header h4[data-v-9bc4e96e] {
  font-size: 13px;
  font-weight: 600;
  color: var(--text-primary);
  margin: 0;
  flex: 1;
  letter-spacing: -0.022em;
  text-shadow: var(--text-glow);
}
.component-type[data-v-9bc4e96e] {
  font-size: 10px;
  color: var(--accent-secondary);
  background: var(--bg-card);
  padding: 2px 6px;
  border-radius: 4px;
  border: 1px solid var(--border-accent);
  font-weight: 500;
  text-shadow: var(--text-glow-accent);
}

/* Component操作按钮样式 */
.component-actions[data-v-9bc4e96e] {
  display: flex;
  align-items: center;
  gap: 4px;
  margin-left: 8px;
}
.component-action-btn[data-v-9bc4e96e] {
  width: 24px;
  height: 24px;
  border: 1px solid var(--border-primary);
  border-radius: 4px;
  background: var(--bg-card);
  color: var(--text-secondary);
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.2s ease;
  font-size: 12px;
  padding: 0;
}
.component-action-btn[data-v-9bc4e96e]:hover {
  border-color: var(--border-accent);
  background: var(--accent-primary);
  color: white;
  box-shadow: 0 0 8px var(--shadow-accent);
  transform: scale(1.1);
}
.component-action-btn[data-v-9bc4e96e]:active {
  transform: scale(0.95);
}
.component-action-btn i[data-v-9bc4e96e] {
  font-size: 10px;
  color: inherit;
}
.component-properties[data-v-9bc4e96e] {
  padding: 8px 12px;
  display: flex;
  flex-direction: column;
  gap: 6px;
}
.property-item[data-v-9bc4e96e] {
  display: flex;
  align-items: center;
  gap: 8px;
  min-height: 28px;
}
.property-item.button-item[data-v-9bc4e96e] {
  justify-content: center;
}
.property-label[data-v-9bc4e96e] {
  min-width: 60px;
  font-size: 12px;
  color: var(--text-secondary);
  font-weight: 500;
  letter-spacing: -0.006em;
  text-shadow: var(--text-glow-accent);
  flex-shrink: 0;
}
.property-control[data-v-9bc4e96e] {
  flex: 1;
  display: flex;
  align-items: center;
}
.property-control.button-control[data-v-9bc4e96e] {
  width: 100%;
  justify-content: left;
}

/* 输入框基础样式 */
.text-input[data-v-9bc4e96e], .dropdown-input[data-v-9bc4e96e] {
  flex: 1;
  padding: 8px 12px;
  border: 1px solid var(--border-primary);
  border-radius: 8px;
  font-size: 13px;
  background: var(--bg-card);
  backdrop-filter: blur(8px);
  color: var(--text-primary);
  font-family: inherit;
  box-shadow: 
    0 2px 8px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.text-input[data-v-9bc4e96e]:focus, .dropdown-input[data-v-9bc4e96e]:focus {
  outline: none;
  border-color: var(--border-accent);
  box-shadow: 
    0 0 0 3px var(--shadow-accent),
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset;
  background: var(--bg-panel);
  transform: translateY(-1px);
  text-shadow: var(--text-glow-accent);
}

/* 下拉框选项样式 - 深色模式适配 */
.dropdown-input option[data-v-9bc4e96e] {
  background: var(--bg-card);
  color: var(--text-primary);
  padding: 8px 12px;
  border: none;
  font-family: inherit;
  font-size: 13px;
}

/* 深色模式下强制覆盖浏览器默认样式 */
.layatree-panel:not(.light-mode) .dropdown-input option[data-v-9bc4e96e] {
  background-color: #1a1f29 !important;
  color: #f0f2f5 !important;
}

/* 浅色模式下的选项样式 */
.layatree-panel.light-mode .dropdown-input option[data-v-9bc4e96e] {
  background-color: #ffffff !important;
  color: #1e293b !important;
}

/* hover 状态的选项样式 */
.dropdown-input option[data-v-9bc4e96e]:hover,
.dropdown-input option[data-v-9bc4e96e]:checked {
  background: var(--bg-selected) !important;
  color: var(--text-accent) !important;
}

/* 复选框样式 */
.checkbox-input[data-v-9bc4e96e] {
  width: 18px;
  height: 18px;
  border: 2px solid var(--border-primary);
  border-radius: 4px;
  background: var(--bg-card);
  cursor: pointer;
  position: relative;
  transition: all 0.3s ease;
  appearance: none;
}
.checkbox-input[data-v-9bc4e96e]:checked {
  background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));
  border-color: var(--accent-primary);
  box-shadow: 0 0 8px var(--shadow-accent);
}
.checkbox-input[data-v-9bc4e96e]:checked::after {
  content: '✓';
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  color: white;
  font-size: 12px;
  font-weight: bold;
  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
}
.checkbox-input[data-v-9bc4e96e]:hover {
  border-color: var(--border-accent);
  box-shadow: 0 0 8px var(--shadow-accent);
}

/* NodeInfo双控件样式 */
.nodeinfo-dual-control[data-v-9bc4e96e] {
  display: flex;
  align-items: center;
  gap: 20px;
  min-height: 28px;
  background: var(--bg-card);
  border: 1px solid var(--border-primary);
  border-radius: 8px;
  padding: 8px 12px;
  margin: 4px 0;
  transition: all 0.3s ease;
}
.nodeinfo-dual-control[data-v-9bc4e96e]:hover {
  border-color: var(--border-accent);
  box-shadow: 0 0 8px var(--shadow-accent);
  background: var(--bg-panel);
}
.dual-control-item[data-v-9bc4e96e] {
  display: flex;
  align-items: center;
  gap: 6px;
  flex: 1;
}
.property-label.compact[data-v-9bc4e96e] {
  min-width: 40px;
  font-size: 11px;
  color: var(--text-secondary);
  font-weight: 600;
  letter-spacing: -0.006em;
  text-shadow: var(--text-glow-accent);
  flex-shrink: 0;
}

/* 颜色选择器样式 */
.color-input[data-v-9bc4e96e] {
  width: 40px;
  height: 36px;
  border: 1px solid var(--border-primary);
  border-radius: 8px;
  background: var(--bg-card);
  cursor: pointer;
  transition: all 0.3s ease;
  overflow: hidden;
}
.color-input[data-v-9bc4e96e]:hover {
  border-color: var(--border-accent);
  box-shadow: 0 0 8px var(--shadow-accent);
  transform: scale(1.05);
}
.color-string-input[data-v-9bc4e96e] {
  display: flex;
  align-items: center;
  gap: 8px;
  width: 100%;
}
.color-picker[data-v-9bc4e96e] {
  width: 32px;
  height: 28px;
  border: 1px solid var(--border-primary);
  border-radius: 4px;
  cursor: pointer;
  background: transparent;
  flex-shrink: 0;
}
.color-picker[data-v-9bc4e96e]:hover {
  border-color: var(--border-accent);
}
.color-text-input[data-v-9bc4e96e] {
  flex: 1;
  height: 28px;
  padding: 0 8px;
  border: 1px solid var(--border-primary);
  border-radius: 4px;
  background: var(--bg-input);
  color: var(--text-primary);
  font-family: 'Consolas', 'Monaco', monospace;
  font-size: 12px;
  transition: all 0.2s ease;
}
.color-text-input[data-v-9bc4e96e]:focus {
  outline: none;
  border-color: var(--accent-primary);
  box-shadow: 0 0 0 2px var(--shadow-accent);
}
.color-text-input[data-v-9bc4e96e]:invalid {
  border-color: #ff6b6b;
  box-shadow: 0 0 0 2px rgba(255, 107, 107, 0.2);
}
.color-text-input[data-v-9bc4e96e]::placeholder {
  color: var(--text-tertiary);
  opacity: 0.6;
}

/* 按钮样式 */
.action-button[data-v-9bc4e96e] {
  padding: 8px 16px;
  border: 1px solid var(--border-primary);
  border-radius: 8px;
  background: linear-gradient(135deg, var(--bg-card), var(--bg-secondary));
  color: var(--text-primary);
  font-size: 12px;
  font-weight: 600;
  cursor: pointer;
  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  box-shadow: 
    0 2px 8px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  text-shadow: var(--text-glow);
  letter-spacing: -0.006em;
  min-width: 120px;
  text-align: center;
}
.action-button[data-v-9bc4e96e]:hover {
  border-color: var(--border-accent);
  background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));
  color: white;
  box-shadow: 
    0 0 0 3px var(--shadow-accent),
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset;
  transform: translateY(-2px);
  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
}
.action-button[data-v-9bc4e96e]:active {
  transform: translateY(0);
  box-shadow: 
    0 2px 8px var(--shadow-primary),
    0 0 0 1px var(--border-accent) inset;
}

/* 无选择和加载状态 */
.loading-properties[data-v-9bc4e96e], .no-selection[data-v-9bc4e96e] {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  height: 200px;
  color: var(--text-secondary);
  text-align: center;
}
.loading-properties i[data-v-9bc4e96e], .no-selection i[data-v-9bc4e96e] {
  font-size: 48px;
  margin-bottom: 16px;
  opacity: 0.8;
  color: var(--text-accent);
  filter: drop-shadow(0 0 8px var(--shadow-accent));
}
.loading-properties i[data-v-9bc4e96e] {
  animation: spin-9bc4e96e 1s linear infinite;
}
.loading-properties p[data-v-9bc4e96e], .no-selection p[data-v-9bc4e96e] {
  font-size: 15px;
  letter-spacing: -0.016em;
  text-shadow: var(--text-glow-accent);
  font-weight: 500;
}
@keyframes spin-9bc4e96e {
from { transform: rotate(0deg);
}
to { transform: rotate(360deg);
}
}

/* 禁用状态样式 */
.text-input.disabled[data-v-9bc4e96e],
.color-input.disabled[data-v-9bc4e96e],
.color-picker[data-v-9bc4e96e]:disabled,
.color-text-input[data-v-9bc4e96e]:disabled,
.action-button.disabled[data-v-9bc4e96e] {
  opacity: 0.7;
  cursor: not-allowed;
  background: var(--bg-disabled, rgba(128, 128, 128, 0.15));
  color: var(--text-primary);
  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));
  pointer-events: none;
}
.color-string-input.disabled[data-v-9bc4e96e] {
  opacity: 0.7;
  pointer-events: none;
}
.text-input.disabled[data-v-9bc4e96e]:hover,
.color-input.disabled[data-v-9bc4e96e]:hover,
.action-button.disabled[data-v-9bc4e96e]:hover {
  transform: none;
  box-shadow: none;
  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));
}

/* 深色模式下的禁用状态 */
.layatree-panel:not(.light-mode) .text-input.disabled[data-v-9bc4e96e],
.layatree-panel:not(.light-mode) .color-input.disabled[data-v-9bc4e96e],
.layatree-panel:not(.light-mode) .color-picker[data-v-9bc4e96e]:disabled,
.layatree-panel:not(.light-mode) .color-text-input[data-v-9bc4e96e]:disabled,
.layatree-panel:not(.light-mode) .action-button.disabled[data-v-9bc4e96e] {
  background: var(--bg-disabled, #2a2a2a);
  color: var(--text-primary);
  border-color: var(--border-disabled, #444);
}

/* 复选框禁用状态样式 */
.checkbox-input.disabled[data-v-9bc4e96e] {
  opacity: 0.7;
  cursor: not-allowed;
  pointer-events: none;
  background-color: var(--bg-disabled, rgba(128, 128, 128, 0.15));
  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));
}
.checkbox-input.disabled[data-v-9bc4e96e]:checked {
  background-color: var(--bg-disabled, rgba(128, 128, 128, 0.25));
  border-color: var(--border-disabled, rgba(128, 128, 128, 0.5));
}
.checkbox-input.disabled[data-v-9bc4e96e]:checked::after {
  color: var(--text-primary);
}
.checkbox-input.disabled[data-v-9bc4e96e]:hover {
  transform: none;
  box-shadow: 0 0 0 2px var(--border-primary);
}

/* 深色模式下的复选框禁用状态 */
.layatree-panel:not(.light-mode) .checkbox-input.disabled[data-v-9bc4e96e] {
  opacity: 0.7;
  background-color: var(--bg-disabled, rgba(80, 80, 80, 0.3));
  border-color: var(--border-disabled, rgba(150, 150, 150, 0.4));
}
.layatree-panel:not(.light-mode) .checkbox-input.disabled[data-v-9bc4e96e]:checked {
  background-color: var(--bg-disabled, rgba(80, 80, 80, 0.5));
  border-color: var(--border-disabled, rgba(150, 150, 150, 0.5));
}
.layatree-panel:not(.light-mode) .checkbox-input.disabled[data-v-9bc4e96e]:checked::after {
  color: var(--text-primary);
}

/* 响应式设计 */
@media (max-width: 768px) {
.property-item[data-v-9bc4e96e] {
    flex-direction: column;
    align-items: flex-start;
    gap: 8px;
}
.property-label[data-v-9bc4e96e] {
    min-width: auto;
}
.property-control[data-v-9bc4e96e] {
    width: 100%;
}
}
`, "",{"version":3,"sources":["webpack://./src/devtools/components/PropertyInspector.vue"],"names":[],"mappings":";AAkiBA,SAAS;AACT,sCAAqB,YAAY;AAAE;AACnC,6CAA4B,YAAY;AAAE;AAC1C,6CAA4B,YAAY;AAAE;AAC1C,wCAAuB,YAAY;AAAE;AACrC,uCAAsB,YAAY;AAAE;AACpC,sCAAqB,YAAY;AAAE;AACnC,0CAAyB,YAAY;AAAE;AACvC,2CAA0B,YAAY;AAAE;AACxC,yCAAwB,YAAY;AAAE;AACtC,wCAAuB,YAAY;AAAE;AACrC,yCAAwB,YAAY;AAAE;AACtC,sCAAqB,YAAY;AAAE;AAEnC;EACE,YAAY;EACZ,gBAAgB;EAChB,UAAU;EACV,iBAAiB;AACnB;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,QAAQ;AACV;AAEA;EACE,2BAA2B;EAC3B,2BAA2B;EAC3B,kBAAkB;EAClB,uCAAuC;EACvC,gBAAgB;EAChB;;yCAEuC;EACvC,iDAAiD;AACnD;AAEA;EACE,kCAAkC;EAClC;;wCAEsC;EACtC,2BAA2B;AAC7B;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,iBAAiB;EACjB,+BAA+B;EAC/B,8CAA8C;EAC9C,kBAAkB;AACpB;AAEA;EACE,eAAe;EACf,yBAAyB;EACzB,4CAA4C;AAC9C;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,0BAA0B;EAC1B,SAAS;EACT,OAAO;EACP,wBAAwB;EACxB,6BAA6B;AAC/B;AAEA;EACE,eAAe;EACf,8BAA8B;EAC9B,0BAA0B;EAC1B,gBAAgB;EAChB,kBAAkB;EAClB,sCAAsC;EACtC,gBAAgB;EAChB,oCAAoC;AACtC;;AAEA,oBAAoB;AACpB;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,gBAAgB;AAClB;AAEA;EACE,WAAW;EACX,YAAY;EACZ,uCAAuC;EACvC,kBAAkB;EAClB,0BAA0B;EAC1B,4BAA4B;EAC5B,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,yBAAyB;EACzB,eAAe;EACf,UAAU;AACZ;AAEA;EACE,kCAAkC;EAClC,iCAAiC;EACjC,YAAY;EACZ,wCAAwC;EACxC,qBAAqB;AACvB;AAEA;EACE,sBAAsB;AACxB;AAEA;EACE,eAAe;EACf,cAAc;AAChB;AAEA;EACE,iBAAiB;EACjB,aAAa;EACb,sBAAsB;EACtB,QAAQ;AACV;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,gBAAgB;AAClB;AAEA;EACE,uBAAuB;AACzB;AAEA;EACE,eAAe;EACf,eAAe;EACf,4BAA4B;EAC5B,gBAAgB;EAChB,wBAAwB;EACxB,oCAAoC;EACpC,cAAc;AAChB;AAEA;EACE,OAAO;EACP,aAAa;EACb,mBAAmB;AACrB;AAEA;EACE,WAAW;EACX,qBAAqB;AACvB;;AAEA,YAAY;AACZ;EACE,OAAO;EACP,iBAAiB;EACjB,uCAAuC;EACvC,kBAAkB;EAClB,eAAe;EACf,0BAA0B;EAC1B,0BAA0B;EAC1B,0BAA0B;EAC1B,oBAAoB;EACpB;;yCAEuC;EACvC,yDAAyD;AAC3D;AAEA;EACE,aAAa;EACb,kCAAkC;EAClC;;;wCAGsC;EACtC,2BAA2B;EAC3B,2BAA2B;EAC3B,oCAAoC;AACtC;;AAEA,qBAAqB;AACrB;EACE,0BAA0B;EAC1B,0BAA0B;EAC1B,iBAAiB;EACjB,YAAY;EACZ,oBAAoB;EACpB,eAAe;AACjB;;AAEA,qBAAqB;AACrB;EACE,oCAAoC;EACpC,yBAAyB;AAC3B;;AAEA,eAAe;AACf;EACE,oCAAoC;EACpC,yBAAyB;AAC3B;;AAEA,kBAAkB;AAClB;;EAEE,yCAAyC;EACzC,oCAAoC;AACtC;;AAEA,UAAU;AACV;EACE,WAAW;EACX,YAAY;EACZ,uCAAuC;EACvC,kBAAkB;EAClB,0BAA0B;EAC1B,eAAe;EACf,kBAAkB;EAClB,yBAAyB;EACzB,gBAAgB;AAClB;AAEA;EACE,mFAAmF;EACnF,mCAAmC;EACnC,wCAAwC;AAC1C;AAEA;EACE,YAAY;EACZ,kBAAkB;EAClB,QAAQ;EACR,SAAS;EACT,gCAAgC;EAChC,YAAY;EACZ,eAAe;EACf,iBAAiB;EACjB,yCAAyC;AAC3C;AAEA;EACE,kCAAkC;EAClC,wCAAwC;AAC1C;;AAEA,kBAAkB;AAClB;EACE,aAAa;EACb,mBAAmB;EACnB,SAAS;EACT,gBAAgB;EAChB,0BAA0B;EAC1B,uCAAuC;EACvC,kBAAkB;EAClB,iBAAiB;EACjB,aAAa;EACb,yBAAyB;AAC3B;AAEA;EACE,kCAAkC;EAClC,wCAAwC;EACxC,2BAA2B;AAC7B;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,OAAO;AACT;AAEA;EACE,eAAe;EACf,eAAe;EACf,4BAA4B;EAC5B,gBAAgB;EAChB,wBAAwB;EACxB,oCAAoC;EACpC,cAAc;AAChB;;AAEA,YAAY;AACZ;EACE,WAAW;EACX,YAAY;EACZ,uCAAuC;EACvC,kBAAkB;EAClB,0BAA0B;EAC1B,eAAe;EACf,yBAAyB;EACzB,gBAAgB;AAClB;AAEA;EACE,kCAAkC;EAClC,wCAAwC;EACxC,sBAAsB;AACxB;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,WAAW;AACb;AAEA;EACE,WAAW;EACX,YAAY;EACZ,uCAAuC;EACvC,kBAAkB;EAClB,eAAe;EACf,uBAAuB;EACvB,cAAc;AAChB;AAEA;EACE,kCAAkC;AACpC;AAEA;EACE,OAAO;EACP,YAAY;EACZ,cAAc;EACd,uCAAuC;EACvC,kBAAkB;EAClB,2BAA2B;EAC3B,0BAA0B;EAC1B,4CAA4C;EAC5C,eAAe;EACf,yBAAyB;AAC3B;AAEA;EACE,aAAa;EACb,mCAAmC;EACnC,0CAA0C;AAC5C;AAEA;EACE,qBAAqB;EACrB,8CAA8C;AAChD;AAEA;EACE,2BAA2B;EAC3B,YAAY;AACd;;AAEA,SAAS;AACT;EACE,iBAAiB;EACjB,uCAAuC;EACvC,kBAAkB;EAClB,wEAAwE;EACxE,0BAA0B;EAC1B,eAAe;EACf,gBAAgB;EAChB,eAAe;EACf,yDAAyD;EACzD;;yCAEuC;EACvC,6BAA6B;EAC7B,wBAAwB;EACxB,gBAAgB;EAChB,kBAAkB;AACpB;AAEA;EACE,kCAAkC;EAClC,mFAAmF;EACnF,YAAY;EACZ;;;wCAGsC;EACtC,2BAA2B;EAC3B,yCAAyC;AAC3C;AAEA;EACE,wBAAwB;EACxB;;wCAEsC;AACxC;;AAEA,aAAa;AACb;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;EACnB,uBAAuB;EACvB,aAAa;EACb,4BAA4B;EAC5B,kBAAkB;AACpB;AAEA;EACE,eAAe;EACf,mBAAmB;EACnB,YAAY;EACZ,yBAAyB;EACzB,iDAAiD;AACnD;AAEA;EACE,2CAAkC;AACpC;AAEA;EACE,eAAe;EACf,wBAAwB;EACxB,oCAAoC;EACpC,gBAAgB;AAClB;AAEA;AACE,OAAO,uBAAuB;AAAE;AAChC,KAAK,yBAAyB;AAAE;AAClC;;AAEA,WAAW;AACX;;;;;EAKE,YAAY;EACZ,mBAAmB;EACnB,yDAAyD;EACzD,0BAA0B;EAC1B,8DAA8D;EAC9D,oBAAoB;AACtB;AAEA;EACE,YAAY;EACZ,oBAAoB;AACtB;AAEA;;;EAGE,eAAe;EACf,gBAAgB;EAChB,8DAA8D;AAChE;;AAEA,eAAe;AACf;;;;;EAKE,uCAAuC;EACvC,0BAA0B;EAC1B,0CAA0C;AAC5C;;AAEA,cAAc;AACd;EACE,YAAY;EACZ,mBAAmB;EACnB,oBAAoB;EACpB,+DAA+D;EAC/D,8DAA8D;AAChE;AAEA;EACE,+DAA+D;EAC/D,8DAA8D;AAChE;AAEA;EACE,0BAA0B;AAC5B;AAEA;EACE,eAAe;EACf,2CAA2C;AAC7C;;AAEA,kBAAkB;AAClB;EACE,YAAY;EACZ,2DAA2D;EAC3D,8DAA8D;AAChE;AAEA;EACE,2DAA2D;EAC3D,8DAA8D;AAChE;AAEA;EACE,0BAA0B;AAC5B;;AAEA,UAAU;AACV;AACE;IACE,sBAAsB;IACtB,uBAAuB;IACvB,QAAQ;AACV;AAEA;IACE,eAAe;AACjB;AAEA;IACE,WAAW;AACb;AACF","sourcesContent":["<template>\r\n  <div class=\"property-inspector\">\r\n    <div v-if=\"selectedNode && selectedNode.components\" class=\"components-container\">\r\n      <div \r\n        v-for=\"component in selectedNode.components\" \r\n        :key=\"component.name\"\r\n        class=\"component-group\"\r\n      >\r\n        <div class=\"component-header\">\r\n          <i :class=\"getComponentIcon(component.type)\"></i>\r\n          <h4>{{ component.name }}</h4>\r\n          <div class=\"component-type\">{{ component.type }}</div>\r\n          \r\n          <!-- Component类型的操作按钮 -->\r\n          <div v-if=\"component.type === 'Component'\" class=\"component-actions\">\r\n            <button \r\n              @click=\"onOutputComponentToConsole(component, component.properties, $event)\"\r\n              class=\"component-action-btn\"\r\n              title=\"输出到控制台\"\r\n            >\r\n              <i class=\"icon-console\"></i>\r\n            </button>\r\n            <button \r\n              @click=\"onJumpToComponentDefinition(component, component.properties, $event)\"\r\n              class=\"component-action-btn\"\r\n              title=\"跳转定义\"\r\n            >\r\n              <i class=\"icon-jump\"></i>\r\n            </button>\r\n          </div>\r\n        </div>\r\n        \r\n        <div class=\"component-properties\">\r\n          <!-- 普通属性项 -->\r\n          <template v-for=\"(property, index) in component.properties\" :key=\"property.name\">\r\n            <!-- 显示当前属性（如果不需要跳过） -->\r\n            <div \r\n              v-show=\"!shouldSkipProperty(component, property)\"\r\n              :class=\"['property-item', { 'button-item': getFieldType(property) === 'button' }]\"\r\n            >\r\n              <label v-if=\"getFieldType(property) !== 'button'\" class=\"property-label\">{{ getPropertyDisplayName(property) }}</label>\r\n            \r\n              <!-- 布尔值复选框 -->\r\n              <div v-if=\"getFieldType(property) === 'boolean'\" class=\"property-control\">\r\n                <input \r\n                  type=\"checkbox\" \r\n                  :checked=\"property.value\"\r\n                  @change=\"onPropertyChange(component, property, ($event.target as HTMLInputElement).checked)\"\r\n                  class=\"checkbox-input\"\r\n                >\r\n              </div>\r\n             \r\n              <!-- 文本输入框 -->\r\n              <div v-else-if=\"getFieldType(property) === 'text'\" class=\"property-control\">\r\n                <input \r\n                  type=\"text\" \r\n                  :value=\"property.value\"\r\n                  @input=\"onPropertyChange(component, property, ($event.target as HTMLInputElement).value)\"\r\n                  :disabled=\"property.editable === false\"\r\n                  class=\"text-input\"\r\n                  :class=\"{ 'disabled': property.editable === false }\"\r\n                >\r\n              </div>\r\n            \r\n              <!-- 滑动条组件 -->\r\n              <div v-else-if=\"getFieldType(property) === 'slider'\" class=\"property-control\">\r\n                <SliderInput\r\n                  :value=\"property.value\"\r\n                  :min=\"property.min ?? 0\"\r\n                  :max=\"property.max ?? 1\"\r\n                  :step=\"property.step ?? 0.01\"\r\n                  :precision=\"property.precision ?? 2\"\r\n                  :disabled=\"property.editable === false\"\r\n                  @change=\"onPropertyChange(component, property, $event)\"\r\n                />\r\n              </div>\r\n            \r\n              <!-- 数字输入框 -->\r\n              <div v-else-if=\"getFieldType(property) === 'number'\" class=\"property-control\">\r\n                <PropertyInput\r\n                  :value=\"property.value\"\r\n                  :step=\"property.step ?? 0.01\"\r\n                  :min=\"property.min\"\r\n                  :max=\"property.max\"\r\n                  :precision=\"property.precision ?? 5\"\r\n                  :disabled=\"property.editable === false\"\r\n                  @change=\"onPropertyChange(component, property, $event)\"\r\n                />\r\n              </div>\r\n            \r\n              <!-- 向量输入框 -->\r\n              <div v-else-if=\"getFieldType(property) === 'vector2' || getFieldType(property) === 'vector3' || getFieldType(property) === 'vector4'\" class=\"property-control\">\r\n                <VectorInput\r\n                  :value=\"property.value\"\r\n                  :type=\"getFieldType(property)\"\r\n                  :step=\"property.step ?? 0.01\"\r\n                  :min=\"property.min\"\r\n                  :max=\"property.max\"\r\n                  :precision=\"property.precision ?? 3\"\r\n                  :disabled=\"property.editable === false\"\r\n                  @change=\"onPropertyChange(component, property, $event)\"\r\n                />\r\n              </div>\r\n            \r\n              <!-- 下拉框 -->\r\n              <div v-else-if=\"getFieldType(property) === 'dropdown'\" class=\"property-control\">\r\n                <CustomDropdown\r\n                  :value=\"getDropdownDisplayValue(property)\"\r\n                  :options=\"property.options || []\"\r\n                  :disabled=\"property.editable === false\"\r\n                  @change=\"(value) => onCustomDropdownChange(component, property, value)\"\r\n                />\r\n              </div>\r\n              \r\n              <!-- 字符串下拉框 -->\r\n              <div v-else-if=\"getFieldType(property) === 'dropdownString'\" class=\"property-control\">\r\n                <CustomDropdown\r\n                  :value=\"getDropdownStringIndex(property)\"\r\n                  :options=\"property.options || []\"\r\n                  :disabled=\"property.editable === false\"\r\n                  @change=\"onDropdownStringChange(component, property, $event)\"\r\n                />\r\n              </div>\r\n             \r\n              <!-- 颜色选择器 -->\r\n              <div v-else-if=\"getFieldType(property) === 'color'\" class=\"property-control\">\r\n                <input \r\n                  type=\"color\" \r\n                  :value=\"property.value\"\r\n                  @input=\"onPropertyChange(component, property, ($event.target as HTMLInputElement).value)\"\r\n                  :disabled=\"property.editable === false\"\r\n                  class=\"color-input\"\r\n                  :class=\"{ 'disabled': property.editable === false }\"\r\n                >\r\n              </div>\r\n              \r\n              <!-- 颜色字符串选择器 -->\r\n              <div v-else-if=\"getFieldType(property) === 'colorString'\" class=\"property-control\">\r\n                <div class=\"color-string-input\" :class=\"{ 'disabled': property.editable === false }\">\r\n                  <input \r\n                    type=\"color\" \r\n                    :value=\"property.value\"\r\n                    @input=\"onPropertyChange(component, property, ($event.target as HTMLInputElement).value)\"\r\n                    :disabled=\"property.editable === false\"\r\n                    class=\"color-picker\"\r\n                  >\r\n                  <input \r\n                    type=\"text\" \r\n                    :value=\"property.value\"\r\n                    @input=\"onColorStringTextChange(component, property, ($event.target as HTMLInputElement).value)\"\r\n                    :disabled=\"property.editable === false\"\r\n                    class=\"color-text-input\"\r\n                    placeholder=\"#FFFFFF\"\r\n                    pattern=\"^#[0-9A-Fa-f]{6}$\"\r\n                  >\r\n                </div>\r\n              </div>\r\n             \r\n              <!-- 按钮 -->\r\n              <div v-else-if=\"getFieldType(property) === 'button'\" class=\"property-control button-control\">\r\n                <button \r\n                  @click=\"onButtonClick(component, property, $event)\"\r\n                  :disabled=\"property.editable === false\"\r\n                  class=\"action-button\"\r\n                  :class=\"{ 'disabled': property.editable === false }\"\r\n                >\r\n                  {{ getPropertyDisplayName(property) }}\r\n                </button>\r\n              </div>\r\n            </div>\r\n\r\n            <!-- 在名称属性后显示NodeInfo的激活状态和可见性并排控件 -->\r\n            <div \r\n              v-if=\"component.type === 'NodeInfo' && property.name === 'name' && hasNode2DComponent() && getActiveProperty(component) && getVisibleProperty(component)\"\r\n              class=\"property-item nodeinfo-dual-control\"\r\n            >\r\n              <!-- 激活状态 -->\r\n              <div class=\"dual-control-item\">\r\n                <label class=\"property-label compact\">激活</label>\r\n                <div class=\"property-control\">\r\n                  <input \r\n                    type=\"checkbox\" \r\n                    :checked=\"getActiveProperty(component)?.value\"\r\n                    @change=\"getActiveProperty(component) && onPropertyChange(component, getActiveProperty(component)!, ($event.target as HTMLInputElement).checked)\"\r\n                    :disabled=\"getActiveProperty(component)?.editable === false\"\r\n                    class=\"checkbox-input\"\r\n                    :class=\"{ 'disabled': getActiveProperty(component)?.editable === false }\"\r\n                  >\r\n                </div>\r\n              </div>\r\n            \r\n              <!-- 可见性 -->\r\n              <div class=\"dual-control-item\">\r\n                <label class=\"property-label compact\">可见</label>\r\n                <div class=\"property-control\">\r\n                  <input \r\n                    type=\"checkbox\" \r\n                    :checked=\"getVisibleProperty(component)?.value\"\r\n                    @change=\"getVisibleProperty(component) && onVisiblePropertyChange(getVisibleProperty(component)!, ($event.target as HTMLInputElement).checked)\"\r\n                    :disabled=\"getVisibleProperty(component)?.editable === false\"\r\n                    class=\"checkbox-input\"\r\n                    :class=\"{ 'disabled': getVisibleProperty(component)?.editable === false }\"\r\n                  >\r\n                </div>\r\n              </div>\r\n            </div>\r\n          </template>\r\n        </div>\r\n      </div>\r\n    </div>\r\n    \r\n    <div v-else-if=\"selectedNode\" class=\"loading-properties\">\r\n      <i class=\"icon-loading\"></i>\r\n      <p>正在加载节点属性...</p>\r\n    </div>\r\n    \r\n    <div v-else class=\"no-selection\">\r\n      <i class=\"icon-select\"></i>\r\n      <p>请在左侧选择一个节点</p>\r\n    </div>\r\n    \r\n\r\n  </div>\r\n</template>\r\n\r\n<script setup lang=\"ts\">\r\nimport { computed } from 'vue';\r\nimport PropertyInput from './PropertyInput.vue';\r\nimport VectorInput from './VectorInput.vue';\r\nimport SliderInput from './SliderInput.vue';\r\nimport { EventType } from '@/core/message/Event';\r\nimport type { TreeNode, PropertyComponent, PropertyItem } from '../types/panel.types';\r\nimport CustomDropdown from './CustomDropdown.vue';\r\nimport { useToast } from '../composables/useToast';\r\n\r\n// Props\r\ninterface Props {\r\n  selectedNode?: TreeNode | null;\r\n  isDarkMode?: boolean;\r\n  messageListener?: any; // 消息监听器\r\n}\r\n\r\nconst props = withDefaults(defineProps<Props>(), {\r\n  selectedNode: null,\r\n  isDarkMode: true,\r\n  messageListener: null\r\n});\r\n\r\n// Emits\r\nconst emit = defineEmits<{\r\n  propertyChange: [component: PropertyComponent, property: PropertyItem, value: any];\r\n}>();\r\n\r\n// Toast 管理\r\nconst { showToast } = useToast();\r\n\r\n// 方法\r\nconst onPropertyChange = (component: PropertyComponent, property: PropertyItem, value: any) => {\r\n  // 更新本地值\r\n  property.value = value;\r\n  \r\n  // 发送属性变更事件\r\n  emit('propertyChange', component, property, value);\r\n};\r\n\r\n// 获取属性显示名称\r\nconst getPropertyDisplayName = (property: PropertyItem): string => {\r\n  return property.displayName || property.name;\r\n};\r\n\r\n// 获取字段类型\r\nconst getFieldType = (property: PropertyItem): string => {\r\n  return property.fieldType || property.type;\r\n};\r\n\r\n// 获取下拉框的显示值（将数值转换为对应的索引）\r\nconst getDropdownDisplayValue = (property: PropertyItem) => {\r\n  if (property.name === 'Clear Flag' && typeof property.value === 'number') {\r\n    return property.value; // clearFlag的值就是索引\r\n  }\r\n  return property.value;\r\n};\r\n\r\n// 处理下拉框变更\r\nconst onCustomDropdownChange = (component: PropertyComponent, property: PropertyItem, value: any) => {\r\n  onPropertyChange(component, property, value);\r\n};\r\n\r\n// 获取字符串下拉框的索引值\r\nconst getDropdownStringIndex = (property: PropertyItem) => {\r\n  if (!property.options || !Array.isArray(property.options)) {\r\n    return 0;\r\n  }\r\n  const index = property.options.indexOf(property.value);\r\n  return index >= 0 ? index : 0;\r\n};\r\n\r\n// 处理字符串下拉框变更（接收索引，转换为字符串值）\r\nconst onDropdownStringChange = (component: PropertyComponent, property: PropertyItem, selectedIndex: number) => {\r\n  if (!property.options || !Array.isArray(property.options)) {\r\n    return;\r\n  }\r\n  const stringValue = property.options[selectedIndex] || property.options[0] || '';\r\n  onPropertyChange(component, property, stringValue);\r\n};\r\n\r\n// 处理颜色字符串文本输入变更\r\nconst onColorStringTextChange = (component: PropertyComponent, property: PropertyItem, value: string) => {\r\n  // 验证颜色格式\r\n  const colorRegex = /^#[0-9A-Fa-f]{6}$/;\r\n  if (colorRegex.test(value)) {\r\n    onPropertyChange(component, property, value);\r\n  } else if (value === '') {\r\n    // 允许清空，使用默认颜色\r\n    onPropertyChange(component, property, '#000000');\r\n  }\r\n  // 如果格式不正确，不更新值，让用户继续编辑\r\n};\r\n\r\n// 处理Component组件输出到控制台\r\nconst onOutputComponentToConsole = (component: PropertyComponent,property: PropertyItem[], event: MouseEvent) => {\r\n  if (!property || !property.length) {\r\n    return;\r\n  }\r\n\r\n  let i = property.findIndex((p: PropertyItem) => p.name === 'index');\r\n  if (i < 0) {\r\n    return;\r\n  }\r\n\r\n  let index = property[i].value;\r\n  if (index < 0) {\r\n    return;\r\n  }\r\n\r\n  if (props.messageListener && props.selectedNode) {\r\n    const messageData = {\r\n      exId: props.selectedNode.exId,\r\n      index: index\r\n    };\r\n    \r\n    try {\r\n      // 通过消息系统发送请求到页面控制台输出节点信息\r\n      props.messageListener.post(EventType.OUTPUT_NODE_TO_CONSOLE_COMPONENT, messageData);\r\n      \r\n      // 复制到剪贴板\r\n      const input = document.createElement('input');\r\n      document.body.appendChild(input);\r\n      input.setAttribute('value', `window.getNodeMemoryStroge(${props.selectedNode.exId})._components[${index}]`);\r\n      input.select();\r\n      if (document.execCommand('copy')) {\r\n        document.execCommand('copy');\r\n      }\r\n      document.body.removeChild(input);\r\n\r\n      // 获取按钮位置\r\n      const buttonRect = (event.target as HTMLElement).getBoundingClientRect();\r\n      const position = {\r\n        x: buttonRect.left + buttonRect.width / 2 - 140, // 居中对齐，减去Toast宽度的一半\r\n        y: buttonRect.top\r\n      };\r\n\r\n      // 显示Toast提示\r\n      showToast('组件已输出，也可通过 Ctrl+V 粘贴到控制台获取', {\r\n        duration: 4000,\r\n        isDarkMode: props.isDarkMode,\r\n        position: position\r\n      });\r\n    } catch (error) {\r\n      console.error('发送消息失败:', error);\r\n    }\r\n  } else {\r\n    console.warn('消息监听器未初始化或没有选中节点');\r\n  }\r\n};\r\n\r\n// 处理Component组件跳转定义\r\nconst onJumpToComponentDefinition = (component: PropertyComponent,property: PropertyItem[], event: MouseEvent) => {\r\n  if (!property || !property.length) {\r\n    return;\r\n  }\r\n  let i = property.findIndex((p: PropertyItem) => p.name === 'index');\r\n  if (i < 0) {\r\n    return;\r\n  }\r\n\r\n  let index = property[i].value;\r\n  if (index < 0) {\r\n    return;\r\n  }\r\n\r\n  let node = props.selectedNode;\r\n  if (!node) {\r\n    return;\r\n  }\r\n  try {\r\n    // 在被检查页面的上下文中执行代码来跳转到构造函数\r\n    const inspectCode = `\r\n      (function() {\r\n        // 通过 getNodeMemoryStroge 查找节点\r\n        if (typeof window.getNodeMemoryStroge === 'function') {\r\n          try {\r\n            const targetNode = window.getNodeMemoryStroge(${node.exId})._components[${index}];\r\n            if (targetNode) {\r\n              console.log('找到节点对象:', targetNode);\r\n              inspect(targetNode.constructor);\r\n              return true;\r\n            } else {\r\n              console.warn('getNodeMemoryStroge 未找到节点组件，exId:', ${node.exId}, 'index:', ${index});\r\n              return false;\r\n            }\r\n          } catch (error) {\r\n            console.error('getNodeMemoryStroge 调用失败:', error);\r\n            return false;\r\n          }\r\n        } else {\r\n          console.error('getNodeMemoryStroge 函数不存在');\r\n          return false;\r\n        }\r\n      })();\r\n    `;\r\n    \r\n    (chrome as any).devtools.inspectedWindow.eval(\r\n      inspectCode,\r\n      (result: any, isException: boolean) => {\r\n        if (isException) {\r\n          console.error('跳转定义失败:', result);\r\n        } else if (result) {\r\n          console.log('成功跳转到节点定义:', node.type);\r\n        } else {\r\n          console.warn('未能跳转到节点定义，可能节点不存在于当前上下文中');\r\n        }\r\n      }\r\n    );\r\n  } catch (error) {\r\n    console.error('跳转定义失败:', error);\r\n  }\r\n};\r\n\r\n// 处理按钮点击\r\nconst onButtonClick = (component: PropertyComponent, property: PropertyItem, event: MouseEvent) => {\r\n  // 根据按钮的action执行相应操作\r\n  if (property.action === 'outputToConsole') {\r\n    if (props.messageListener && props.selectedNode) {\r\n      const messageData = {\r\n        exId: props.selectedNode.exId,\r\n      };\r\n      \r\n      try {\r\n        // 通过消息系统发送请求到页面控制台输出节点信息\r\n        props.messageListener.post(EventType.OUTPUT_NODE_TO_CONSOLE, messageData);\r\n        \r\n        // 复制到剪贴板\r\n        const input = document.createElement('input');\r\n        document.body.appendChild(input);\r\n        input.setAttribute('value', `window.getNodeMemoryStroge(${props.selectedNode.exId})`);\r\n        input.select();\r\n        if (document.execCommand('copy')) {\r\n          document.execCommand('copy');\r\n        }\r\n        document.body.removeChild(input);\r\n\r\n        // 获取按钮位置\r\n        const buttonRect = (event.target as HTMLElement).getBoundingClientRect();\r\n        const position = {\r\n          x: buttonRect.left + buttonRect.width / 2 - 140, // 居中对齐，减去Toast宽度的一半\r\n          y: buttonRect.top\r\n        };\r\n\r\n        // 显示Toast提示\r\n        showToast('对象已输出，也可通过 Ctrl+V 粘贴到控制台获取', {\r\n          duration: 4000,\r\n          isDarkMode: props.isDarkMode,\r\n          position: position\r\n        });\r\n      } catch (error) {\r\n        console.error('发送消息失败:', error);\r\n      }\r\n    } else {\r\n      console.warn('消息监听器未初始化或没有选中节点');\r\n    }\r\n  }\r\n};\r\n\r\nconst getComponentIcon = (type: string) => {\r\n  const iconMap: Record<string, string> = {\r\n    'NodeInfo': 'icon-info',\r\n    'Transform3D': 'icon-transform3d',\r\n    'Node2D': 'icon-transform2d',\r\n    'Camera': 'icon-camera',\r\n    'Light': 'icon-light',\r\n    'Mesh': 'icon-mesh',\r\n    'Material': 'icon-material',\r\n    'Text': 'icon-text',\r\n    'Image': 'icon-image'\r\n  };\r\n  return iconMap[type] || 'icon-component';\r\n};\r\n\r\n// 检查是否有Node2D组件\r\nconst hasNode2DComponent = (): boolean => {\r\n  if (!props.selectedNode?.components) return false;\r\n  return props.selectedNode.components.some((c: PropertyComponent) => c.type === 'Node2D');\r\n};\r\n\r\n// 获取激活状态属性\r\nconst getActiveProperty = (component: PropertyComponent): PropertyItem | null => {\r\n  if (!props.selectedNode?.components) return null;\r\n  \r\n  const nodeInfo = props.selectedNode.components.find((c: PropertyComponent) => c.type === 'NodeInfo');\r\n  return nodeInfo?.properties.find((p: PropertyItem) => p.name === 'active') || null;\r\n};\r\n\r\n// 获取可见性属性\r\nconst getVisibleProperty = (component: PropertyComponent): PropertyItem | null => {\r\n  if (!props.selectedNode?.components) return null;\r\n  \r\n  const node2D = props.selectedNode.components.find((c: PropertyComponent) => c.type === 'Node2D');\r\n  return node2D?.properties.find((p: PropertyItem) => p.name === 'visible') || null;\r\n};\r\n\r\n// 处理可见性属性变更\r\nconst onVisiblePropertyChange = (property: PropertyItem, value: boolean) => {\r\n  // 更新本地值\r\n  property.value = value;\r\n  \r\n  // 找到Node2D组件\r\n  const node2DComponent = props.selectedNode?.components?.find((c: PropertyComponent) => c.type === 'Node2D');\r\n  if (node2DComponent) {\r\n    // 发送属性变更事件\r\n    emit('propertyChange', node2DComponent, property, value);\r\n  }\r\n};\r\n\r\n// 判断是否应该跳过属性（避免重复显示）\r\nconst shouldSkipProperty = (component: PropertyComponent, property: PropertyItem): boolean => {\r\n  // 在NodeInfo组件中，如果有Node2D组件，跳过激活状态属性（因为在并排控件中显示）\r\n  if (component.type === 'NodeInfo' && hasNode2DComponent() && property.name === 'active') {\r\n    return true;\r\n  }\r\n  \r\n  return false;\r\n};\r\n</script>\r\n\r\n<style scoped>\r\n/* 图标定义 */\r\n.icon-info::before { content: 'ℹ'; }\r\n.icon-transform3d::before { content: '⚹'; }\r\n.icon-transform2d::before { content: '⚏'; }\r\n.icon-camera::before { content: '◉'; }\r\n.icon-light::before { content: '☀'; }\r\n.icon-mesh::before { content: '⬟'; }\r\n.icon-material::before { content: '◈'; }\r\n.icon-component::before { content: '⬡'; }\r\n.icon-loading::before { content: '⟲'; }\r\n.icon-select::before { content: '◯'; }\r\n.icon-console::before { content: '⌨'; }\r\n.icon-jump::before { content: '↗'; }\r\n\r\n.property-inspector {\r\n  height: 100%;\r\n  overflow-y: auto;\r\n  padding: 0;\r\n  /* 使用父级的 CSS 变量 */\r\n}\r\n\r\n.components-container {\r\n  display: flex;\r\n  flex-direction: column;\r\n  gap: 8px;\r\n}\r\n\r\n.component-group {\r\n  background: var(--bg-panel);\r\n  backdrop-filter: blur(16px);\r\n  border-radius: 8px;\r\n  border: 1px solid var(--border-primary);\r\n  overflow: hidden;\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);\r\n}\r\n\r\n.component-group:hover {\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 12px 40px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset;\r\n  transform: translateY(-2px);\r\n}\r\n\r\n.component-header {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 6px;\r\n  padding: 8px 12px;\r\n  background: var(--bg-secondary);\r\n  border-bottom: 1px solid var(--border-primary);\r\n  position: relative;\r\n}\r\n\r\n.component-header i {\r\n  font-size: 14px;\r\n  color: var(--text-accent);\r\n  filter: drop-shadow(var(--text-glow-accent));\r\n}\r\n\r\n.component-header h4 {\r\n  font-size: 13px;\r\n  font-weight: 600;\r\n  color: var(--text-primary);\r\n  margin: 0;\r\n  flex: 1;\r\n  letter-spacing: -0.022em;\r\n  text-shadow: var(--text-glow);\r\n}\r\n\r\n.component-type {\r\n  font-size: 10px;\r\n  color: var(--accent-secondary);\r\n  background: var(--bg-card);\r\n  padding: 2px 6px;\r\n  border-radius: 4px;\r\n  border: 1px solid var(--border-accent);\r\n  font-weight: 500;\r\n  text-shadow: var(--text-glow-accent);\r\n}\r\n\r\n/* Component操作按钮样式 */\r\n.component-actions {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 4px;\r\n  margin-left: 8px;\r\n}\r\n\r\n.component-action-btn {\r\n  width: 24px;\r\n  height: 24px;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 4px;\r\n  background: var(--bg-card);\r\n  color: var(--text-secondary);\r\n  cursor: pointer;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  transition: all 0.2s ease;\r\n  font-size: 12px;\r\n  padding: 0;\r\n}\r\n\r\n.component-action-btn:hover {\r\n  border-color: var(--border-accent);\r\n  background: var(--accent-primary);\r\n  color: white;\r\n  box-shadow: 0 0 8px var(--shadow-accent);\r\n  transform: scale(1.1);\r\n}\r\n\r\n.component-action-btn:active {\r\n  transform: scale(0.95);\r\n}\r\n\r\n.component-action-btn i {\r\n  font-size: 10px;\r\n  color: inherit;\r\n}\r\n\r\n.component-properties {\r\n  padding: 8px 12px;\r\n  display: flex;\r\n  flex-direction: column;\r\n  gap: 6px;\r\n}\r\n\r\n.property-item {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 8px;\r\n  min-height: 28px;\r\n}\r\n\r\n.property-item.button-item {\r\n  justify-content: center;\r\n}\r\n\r\n.property-label {\r\n  min-width: 60px;\r\n  font-size: 12px;\r\n  color: var(--text-secondary);\r\n  font-weight: 500;\r\n  letter-spacing: -0.006em;\r\n  text-shadow: var(--text-glow-accent);\r\n  flex-shrink: 0;\r\n}\r\n\r\n.property-control {\r\n  flex: 1;\r\n  display: flex;\r\n  align-items: center;\r\n}\r\n\r\n.property-control.button-control {\r\n  width: 100%;\r\n  justify-content: left;\r\n}\r\n\r\n/* 输入框基础样式 */\r\n.text-input, .dropdown-input {\r\n  flex: 1;\r\n  padding: 8px 12px;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 8px;\r\n  font-size: 13px;\r\n  background: var(--bg-card);\r\n  backdrop-filter: blur(8px);\r\n  color: var(--text-primary);\r\n  font-family: inherit;\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.text-input:focus, .dropdown-input:focus {\r\n  outline: none;\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 0 0 3px var(--shadow-accent),\r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset;\r\n  background: var(--bg-panel);\r\n  transform: translateY(-1px);\r\n  text-shadow: var(--text-glow-accent);\r\n}\r\n\r\n/* 下拉框选项样式 - 深色模式适配 */\r\n.dropdown-input option {\r\n  background: var(--bg-card);\r\n  color: var(--text-primary);\r\n  padding: 8px 12px;\r\n  border: none;\r\n  font-family: inherit;\r\n  font-size: 13px;\r\n}\r\n\r\n/* 深色模式下强制覆盖浏览器默认样式 */\r\n.layatree-panel:not(.light-mode) .dropdown-input option {\r\n  background-color: #1a1f29 !important;\r\n  color: #f0f2f5 !important;\r\n}\r\n\r\n/* 浅色模式下的选项样式 */\r\n.layatree-panel.light-mode .dropdown-input option {\r\n  background-color: #ffffff !important;\r\n  color: #1e293b !important;\r\n}\r\n\r\n/* hover 状态的选项样式 */\r\n.dropdown-input option:hover,\r\n.dropdown-input option:checked {\r\n  background: var(--bg-selected) !important;\r\n  color: var(--text-accent) !important;\r\n}\r\n\r\n/* 复选框样式 */\r\n.checkbox-input {\r\n  width: 18px;\r\n  height: 18px;\r\n  border: 2px solid var(--border-primary);\r\n  border-radius: 4px;\r\n  background: var(--bg-card);\r\n  cursor: pointer;\r\n  position: relative;\r\n  transition: all 0.3s ease;\r\n  appearance: none;\r\n}\r\n\r\n.checkbox-input:checked {\r\n  background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));\r\n  border-color: var(--accent-primary);\r\n  box-shadow: 0 0 8px var(--shadow-accent);\r\n}\r\n\r\n.checkbox-input:checked::after {\r\n  content: '✓';\r\n  position: absolute;\r\n  top: 50%;\r\n  left: 50%;\r\n  transform: translate(-50%, -50%);\r\n  color: white;\r\n  font-size: 12px;\r\n  font-weight: bold;\r\n  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);\r\n}\r\n\r\n.checkbox-input:hover {\r\n  border-color: var(--border-accent);\r\n  box-shadow: 0 0 8px var(--shadow-accent);\r\n}\r\n\r\n/* NodeInfo双控件样式 */\r\n.nodeinfo-dual-control {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 20px;\r\n  min-height: 28px;\r\n  background: var(--bg-card);\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 8px;\r\n  padding: 8px 12px;\r\n  margin: 4px 0;\r\n  transition: all 0.3s ease;\r\n}\r\n\r\n.nodeinfo-dual-control:hover {\r\n  border-color: var(--border-accent);\r\n  box-shadow: 0 0 8px var(--shadow-accent);\r\n  background: var(--bg-panel);\r\n}\r\n\r\n.dual-control-item {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 6px;\r\n  flex: 1;\r\n}\r\n\r\n.property-label.compact {\r\n  min-width: 40px;\r\n  font-size: 11px;\r\n  color: var(--text-secondary);\r\n  font-weight: 600;\r\n  letter-spacing: -0.006em;\r\n  text-shadow: var(--text-glow-accent);\r\n  flex-shrink: 0;\r\n}\r\n\r\n/* 颜色选择器样式 */\r\n.color-input {\r\n  width: 40px;\r\n  height: 36px;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 8px;\r\n  background: var(--bg-card);\r\n  cursor: pointer;\r\n  transition: all 0.3s ease;\r\n  overflow: hidden;\r\n}\r\n\r\n.color-input:hover {\r\n  border-color: var(--border-accent);\r\n  box-shadow: 0 0 8px var(--shadow-accent);\r\n  transform: scale(1.05);\r\n}\r\n\r\n.color-string-input {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 8px;\r\n  width: 100%;\r\n}\r\n\r\n.color-picker {\r\n  width: 32px;\r\n  height: 28px;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 4px;\r\n  cursor: pointer;\r\n  background: transparent;\r\n  flex-shrink: 0;\r\n}\r\n\r\n.color-picker:hover {\r\n  border-color: var(--border-accent);\r\n}\r\n\r\n.color-text-input {\r\n  flex: 1;\r\n  height: 28px;\r\n  padding: 0 8px;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 4px;\r\n  background: var(--bg-input);\r\n  color: var(--text-primary);\r\n  font-family: 'Consolas', 'Monaco', monospace;\r\n  font-size: 12px;\r\n  transition: all 0.2s ease;\r\n}\r\n\r\n.color-text-input:focus {\r\n  outline: none;\r\n  border-color: var(--accent-primary);\r\n  box-shadow: 0 0 0 2px var(--shadow-accent);\r\n}\r\n\r\n.color-text-input:invalid {\r\n  border-color: #ff6b6b;\r\n  box-shadow: 0 0 0 2px rgba(255, 107, 107, 0.2);\r\n}\r\n\r\n.color-text-input::placeholder {\r\n  color: var(--text-tertiary);\r\n  opacity: 0.6;\r\n}\r\n\r\n/* 按钮样式 */\r\n.action-button {\r\n  padding: 8px 16px;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 8px;\r\n  background: linear-gradient(135deg, var(--bg-card), var(--bg-secondary));\r\n  color: var(--text-primary);\r\n  font-size: 12px;\r\n  font-weight: 600;\r\n  cursor: pointer;\r\n  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  text-shadow: var(--text-glow);\r\n  letter-spacing: -0.006em;\r\n  min-width: 120px;\r\n  text-align: center;\r\n}\r\n\r\n.action-button:hover {\r\n  border-color: var(--border-accent);\r\n  background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));\r\n  color: white;\r\n  box-shadow: \r\n    0 0 0 3px var(--shadow-accent),\r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset;\r\n  transform: translateY(-2px);\r\n  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);\r\n}\r\n\r\n.action-button:active {\r\n  transform: translateY(0);\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary),\r\n    0 0 0 1px var(--border-accent) inset;\r\n}\r\n\r\n/* 无选择和加载状态 */\r\n.loading-properties, .no-selection {\r\n  display: flex;\r\n  flex-direction: column;\r\n  align-items: center;\r\n  justify-content: center;\r\n  height: 200px;\r\n  color: var(--text-secondary);\r\n  text-align: center;\r\n}\r\n\r\n.loading-properties i, .no-selection i {\r\n  font-size: 48px;\r\n  margin-bottom: 16px;\r\n  opacity: 0.8;\r\n  color: var(--text-accent);\r\n  filter: drop-shadow(0 0 8px var(--shadow-accent));\r\n}\r\n\r\n.loading-properties i {\r\n  animation: spin 1s linear infinite;\r\n}\r\n\r\n.loading-properties p, .no-selection p {\r\n  font-size: 15px;\r\n  letter-spacing: -0.016em;\r\n  text-shadow: var(--text-glow-accent);\r\n  font-weight: 500;\r\n}\r\n\r\n@keyframes spin {\r\n  from { transform: rotate(0deg); }\r\n  to { transform: rotate(360deg); }\r\n}\r\n\r\n/* 禁用状态样式 */\r\n.text-input.disabled,\r\n.color-input.disabled,\r\n.color-picker:disabled,\r\n.color-text-input:disabled,\r\n.action-button.disabled {\r\n  opacity: 0.7;\r\n  cursor: not-allowed;\r\n  background: var(--bg-disabled, rgba(128, 128, 128, 0.15));\r\n  color: var(--text-primary);\r\n  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));\r\n  pointer-events: none;\r\n}\r\n\r\n.color-string-input.disabled {\r\n  opacity: 0.7;\r\n  pointer-events: none;\r\n}\r\n\r\n.text-input.disabled:hover,\r\n.color-input.disabled:hover,\r\n.action-button.disabled:hover {\r\n  transform: none;\r\n  box-shadow: none;\r\n  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));\r\n}\r\n\r\n/* 深色模式下的禁用状态 */\r\n.layatree-panel:not(.light-mode) .text-input.disabled,\r\n.layatree-panel:not(.light-mode) .color-input.disabled,\r\n.layatree-panel:not(.light-mode) .color-picker:disabled,\r\n.layatree-panel:not(.light-mode) .color-text-input:disabled,\r\n.layatree-panel:not(.light-mode) .action-button.disabled {\r\n  background: var(--bg-disabled, #2a2a2a);\r\n  color: var(--text-primary);\r\n  border-color: var(--border-disabled, #444);\r\n}\r\n\r\n/* 复选框禁用状态样式 */\r\n.checkbox-input.disabled {\r\n  opacity: 0.7;\r\n  cursor: not-allowed;\r\n  pointer-events: none;\r\n  background-color: var(--bg-disabled, rgba(128, 128, 128, 0.15));\r\n  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));\r\n}\r\n\r\n.checkbox-input.disabled:checked {\r\n  background-color: var(--bg-disabled, rgba(128, 128, 128, 0.25));\r\n  border-color: var(--border-disabled, rgba(128, 128, 128, 0.5));\r\n}\r\n\r\n.checkbox-input.disabled:checked::after {\r\n  color: var(--text-primary);\r\n}\r\n\r\n.checkbox-input.disabled:hover {\r\n  transform: none;\r\n  box-shadow: 0 0 0 2px var(--border-primary);\r\n}\r\n\r\n/* 深色模式下的复选框禁用状态 */\r\n.layatree-panel:not(.light-mode) .checkbox-input.disabled {\r\n  opacity: 0.7;\r\n  background-color: var(--bg-disabled, rgba(80, 80, 80, 0.3));\r\n  border-color: var(--border-disabled, rgba(150, 150, 150, 0.4));\r\n}\r\n\r\n.layatree-panel:not(.light-mode) .checkbox-input.disabled:checked {\r\n  background-color: var(--bg-disabled, rgba(80, 80, 80, 0.5));\r\n  border-color: var(--border-disabled, rgba(150, 150, 150, 0.5));\r\n}\r\n\r\n.layatree-panel:not(.light-mode) .checkbox-input.disabled:checked::after {\r\n  color: var(--text-primary);\r\n}\r\n\r\n/* 响应式设计 */\r\n@media (max-width: 768px) {\r\n  .property-item {\r\n    flex-direction: column;\r\n    align-items: flex-start;\r\n    gap: 8px;\r\n  }\r\n  \r\n  .property-label {\r\n    min-width: auto;\r\n  }\r\n  \r\n  .property-control {\r\n    width: 100%;\r\n  }\r\n}\r\n</style>"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/Render.vue?vue&type=style&index=0&id=8e0de102&scoped=true&lang=css":
/*!****************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/Render.vue?vue&type=style&index=0&id=8e0de102&scoped=true&lang=css ***!
  \****************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/getUrl.js */ "./node_modules/css-loader/dist/runtime/getUrl.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__);
// Imports



var ___CSS_LOADER_URL_IMPORT_0___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="%23e0e0e0" stroke-width="2"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg> */ "data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\"><line x1=\"18\" y1=\"6\" x2=\"6\" y2=\"18\"></line><line x1=\"6\" y1=\"6\" x2=\"18\" y2=\"18\"></line></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_1___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="%23666" stroke-width="1.5"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><circle cx="8.5" cy="8.5" r="1.5"></circle><polyline points="21,15 16,10 5,21"></polyline></svg> */ "data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23666\" stroke-width=\"1.5\"><rect x=\"3\" y=\"3\" width=\"18\" height=\"18\" rx=\"2\" ry=\"2\"></rect><circle cx=\"8.5\" cy=\"8.5\" r=\"1.5\"></circle><polyline points=\"21,15 16,10 5,21\"></polyline></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_2___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><polygon points="5,3 19,12 5,21"></polygon></svg> */ "data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"currentColor\"><polygon points=\"5,3 19,12 5,21\"></polygon></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_3___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><rect x="6" y="6" width="12" height="12"></rect></svg> */ "data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"currentColor\"><rect x=\"6\" y=\"6\" width=\"12\" height=\"12\"></rect></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_4___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><rect x="7" y="7" width="10" height="3"></rect><rect x="7" y="14" width="10" height="3"></rect></svg> */ "data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\"><rect x=\"3\" y=\"3\" width=\"18\" height=\"18\" rx=\"2\" ry=\"2\"></rect><rect x=\"7\" y=\"7\" width=\"10\" height=\"3\"></rect><rect x=\"7\" y=\"14\" width=\"10\" height=\"3\"></rect></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_5___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="%23e0e0e0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path><polyline points="7,10 12,15 17,10"></polyline><line x1="12" y1="15" x2="12" y2="3"></line></svg> */ "data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><path d=\"M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4\"></path><polyline points=\"7,10 12,15 17,10\"></polyline><line x1=\"12\" y1=\"15\" x2=\"12\" y2=\"3\"></line></svg>"), __webpack_require__.b);
var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
var ___CSS_LOADER_URL_REPLACEMENT_0___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_0___);
var ___CSS_LOADER_URL_REPLACEMENT_1___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_1___);
var ___CSS_LOADER_URL_REPLACEMENT_2___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_2___);
var ___CSS_LOADER_URL_REPLACEMENT_3___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_3___);
var ___CSS_LOADER_URL_REPLACEMENT_4___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_4___);
var ___CSS_LOADER_URL_REPLACEMENT_5___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_5___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
.render-panel-overlay[data-v-8e0de102] {
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  z-index: 9999;
  pointer-events: none;
}
.render-panel[data-v-8e0de102] {
  position: absolute;
  width: 600px;
  height: 500px;
  background: var(--bg-card);
  border: 1px solid var(--border-primary);
  border-radius: 12px;
  box-shadow: 0 8px 32px var(--shadow-primary);
  display: flex;
  flex-direction: column;
  animation: slideIn-8e0de102 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  pointer-events: auto;
  user-select: none;
  backdrop-filter: blur(16px);
}
.panel-header[data-v-8e0de102] {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 16px 20px;
  border-bottom: 1px solid var(--border-primary);
  background: var(--bg-secondary);
  border-radius: 12px 12px 0 0;
  cursor: move;
  user-select: none;
  backdrop-filter: blur(16px);
}
.panel-header[data-v-8e0de102]:active {
  cursor: grabbing;
}
.panel-header h3[data-v-8e0de102] {
  margin: 0;
  font-size: 16px;
  font-weight: 600;
  color: var(--text-primary);
}
.close-btn[data-v-8e0de102] {
  width: 28px;
  height: 28px;
  border: none;
  background: transparent;
  border-radius: 6px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.2s ease;
}
.close-btn[data-v-8e0de102]:hover {
  background: var(--bg-button-hover);
}
.close-icon[data-v-8e0de102] {
  width: 14px;
  height: 14px;
  background: url(${___CSS_LOADER_URL_REPLACEMENT_0___}) no-repeat center;
  background-size: contain;
}
.panel-content[data-v-8e0de102] {
  flex: 1;
  padding: 20px;
  display: flex;
  flex-direction: column;
  gap: 20px;
  overflow: hidden;
}
.render-list[data-v-8e0de102] {
  flex: 1;
  display: flex;
  flex-direction: column;
  border: 1px solid var(--border-primary);
  border-radius: 8px;
  overflow: hidden;
  background: var(--bg-card);
}
.list-header[data-v-8e0de102] {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 12px 16px;
  background: var(--bg-secondary);
  border-bottom: 1px solid var(--border-primary);
  font-size: 14px;
  font-weight: 500;
  color: var(--text-primary);
}
.item-count[data-v-8e0de102] {
  font-size: 12px;
  color: var(--text-secondary);
  background: var(--bg-card-secondary);
  padding: 2px 8px;
  border-radius: 12px;
}
.list-container[data-v-8e0de102] {
  flex: 1;
  overflow-y: auto;
}
.empty-state[data-v-8e0de102] {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  height: 200px;
  color: var(--text-secondary);
  text-align: center;
}
.empty-icon[data-v-8e0de102] {
  width: 48px;
  height: 48px;
  margin-bottom: 12px;
  background: url(${___CSS_LOADER_URL_REPLACEMENT_1___}) no-repeat center;
  background-size: contain;
  opacity: 0.5;
}
.list-items[data-v-8e0de102] {
  padding: 8px;
}
.list-item[data-v-8e0de102] {
  padding: 12px;
  border-radius: 6px;
  cursor: pointer;
  transition: all 0.2s ease;
  border: 1px solid transparent;
  margin-bottom: 4px;
}
.list-item[data-v-8e0de102]:hover {
  background: var(--bg-card-secondary);
  border-color: var(--border-accent);
}
.list-item.active[data-v-8e0de102] {
  background: var(--bg-panel);
  border-color: var(--accent-primary);
}
.item-info[data-v-8e0de102] {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 4px;
}
.item-type[data-v-8e0de102] {
  font-size: 12px;
  font-weight: 500;
  color: var(--accent-primary);
  background: var(--bg-card-secondary);
  padding: 2px 6px;
  border-radius: 4px;
}
.item-time[data-v-8e0de102] {
  font-size: 11px;
  color: var(--text-secondary);
}
.item-details[data-v-8e0de102] {
  display: flex;
  align-items: center;
  justify-content: space-between;
}
.item-name[data-v-8e0de102] {
  font-size: 13px;
  color: var(--text-primary);
  font-weight: 500;
}
.item-value[data-v-8e0de102] {
  font-size: 12px;
  color: var(--text-secondary);
  font-family: monospace;
}
.control-buttons[data-v-8e0de102] {
  display: flex;
  gap: 12px;
  padding-top: 16px;
  border-top: 1px solid var(--border-primary);
}
.control-btn[data-v-8e0de102] {
  flex: 1;
  padding: 10px 16px;
  border: 1px solid var(--border-primary);
  border-radius: 8px;
  background: var(--bg-button);
  color: var(--text-primary);
  font-size: 13px;
  font-weight: 500;
  cursor: pointer;
  transition: all 0.2s ease;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 6px;
}
.control-btn[data-v-8e0de102]:hover {
  background: var(--bg-button-hover);
  border-color: var(--border-accent);
  color: var(--accent-primary);
  transform: translateY(-1px);
  box-shadow: 0 4px 16px var(--shadow-accent);
}
.start-icon[data-v-8e0de102] {
  width: 12px;
  height: 12px;
  background: url(${___CSS_LOADER_URL_REPLACEMENT_2___}) no-repeat center;
  background-size: contain;
}
.stop-icon[data-v-8e0de102] {
  width: 12px;
  height: 12px;
  background: url(${___CSS_LOADER_URL_REPLACEMENT_3___}) no-repeat center;
  background-size: contain;
}
.stack-icon[data-v-8e0de102] {
  width: 12px;
  height: 12px;
  background: url(${___CSS_LOADER_URL_REPLACEMENT_4___}) no-repeat center;
  background-size: contain;
}
@keyframes fadeIn-8e0de102 {
from {
    opacity: 0;
}
to {
    opacity: 1;
}
}
@keyframes slideIn-8e0de102 {
from {
    opacity: 0;
    transform: scale(0.9) translateY(-20px);
}
to {
    opacity: 1;
    transform: scale(1) translateY(0);
}
}
.copy-btn[data-v-8e0de102] {
  display: flex;
  align-items: center;
  justify-content: center;
  width: 24px;
  height: 24px;
  background-color: transparent;
  border: none;
  cursor: pointer;
  opacity: 0.7;
  transition: opacity 0.2s;
  margin-left: 8px;
}
.copy-btn[data-v-8e0de102]:hover {
  opacity: 1;
}
.download-icon[data-v-8e0de102] {
  display: inline-block;
  width: 16px;
  height: 16px;
  background-image: url(${___CSS_LOADER_URL_REPLACEMENT_5___});
  background-position: center;
  background-repeat: no-repeat;
  background-size: contain;
}
`, "",{"version":3,"sources":["webpack://./src/devtools/components/Render.vue"],"names":[],"mappings":";AAqUA;EACE,eAAe;EACf,MAAM;EACN,OAAO;EACP,QAAQ;EACR,SAAS;EACT,aAAa;EACb,oBAAoB;AACtB;AAEA;EACE,kBAAkB;EAClB,YAAY;EACZ,aAAa;EACb,0BAA0B;EAC1B,uCAAuC;EACvC,mBAAmB;EACnB,4CAA4C;EAC5C,aAAa;EACb,sBAAsB;EACtB,qEAA4D;EAC5D,oBAAoB;EACpB,iBAAiB;EACjB,2BAA2B;AAC7B;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,kBAAkB;EAClB,8CAA8C;EAC9C,+BAA+B;EAC/B,4BAA4B;EAC5B,YAAY;EACZ,iBAAiB;EACjB,2BAA2B;AAC7B;AAEA;EACE,gBAAgB;AAClB;AAEA;EACE,SAAS;EACT,eAAe;EACf,gBAAgB;EAChB,0BAA0B;AAC5B;AAEA;EACE,WAAW;EACX,YAAY;EACZ,YAAY;EACZ,uBAAuB;EACvB,kBAAkB;EAClB,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,yBAAyB;AAC3B;AAEA;EACE,kCAAkC;AACpC;AAEA;EACE,WAAW;EACX,YAAY;EACZ,oEAA+P;EAC/P,wBAAwB;AAC1B;AAEA;EACE,OAAO;EACP,aAAa;EACb,aAAa;EACb,sBAAsB;EACtB,SAAS;EACT,gBAAgB;AAClB;AAEA;EACE,OAAO;EACP,aAAa;EACb,sBAAsB;EACtB,uCAAuC;EACvC,kBAAkB;EAClB,gBAAgB;EAChB,0BAA0B;AAC5B;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,kBAAkB;EAClB,+BAA+B;EAC/B,8CAA8C;EAC9C,eAAe;EACf,gBAAgB;EAChB,0BAA0B;AAC5B;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,oCAAoC;EACpC,gBAAgB;EAChB,mBAAmB;AACrB;AAEA;EACE,OAAO;EACP,gBAAgB;AAClB;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;EACnB,uBAAuB;EACvB,aAAa;EACb,4BAA4B;EAC5B,kBAAkB;AACpB;AAEA;EACE,WAAW;EACX,YAAY;EACZ,mBAAmB;EACnB,oEAAgU;EAChU,wBAAwB;EACxB,YAAY;AACd;AAEA;EACE,YAAY;AACd;AAEA;EACE,aAAa;EACb,kBAAkB;EAClB,eAAe;EACf,yBAAyB;EACzB,6BAA6B;EAC7B,kBAAkB;AACpB;AAEA;EACE,oCAAoC;EACpC,kCAAkC;AACpC;AAEA;EACE,2BAA2B;EAC3B,mCAAmC;AACrC;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,kBAAkB;AACpB;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,4BAA4B;EAC5B,oCAAoC;EACpC,gBAAgB;EAChB,kBAAkB;AACpB;AAEA;EACE,eAAe;EACf,4BAA4B;AAC9B;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;AAChC;AAEA;EACE,eAAe;EACf,0BAA0B;EAC1B,gBAAgB;AAClB;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,sBAAsB;AACxB;AAEA;EACE,aAAa;EACb,SAAS;EACT,iBAAiB;EACjB,2CAA2C;AAC7C;AAEA;EACE,OAAO;EACP,kBAAkB;EAClB,uCAAuC;EACvC,kBAAkB;EAClB,4BAA4B;EAC5B,0BAA0B;EAC1B,eAAe;EACf,gBAAgB;EAChB,eAAe;EACf,yBAAyB;EACzB,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,QAAQ;AACV;AAEA;EACE,kCAAkC;EAClC,kCAAkC;EAClC,4BAA4B;EAC5B,2BAA2B;EAC3B,2CAA2C;AAC7C;AAEA;EACE,WAAW;EACX,YAAY;EACZ,oEAAwL;EACxL,wBAAwB;AAC1B;AAEA;EACE,WAAW;EACX,YAAY;EACZ,oEAA6L;EAC7L,wBAAwB;AAC1B;AAEA;EACE,WAAW;EACX,YAAY;EACZ,oEAAyU;EACzU,wBAAwB;AAC1B;AAEA;AACE;IACE,UAAU;AACZ;AACA;IACE,UAAU;AACZ;AACF;AAEA;AACE;IACE,UAAU;IACV,uCAAuC;AACzC;AACA;IACE,UAAU;IACV,iCAAiC;AACnC;AACF;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,WAAW;EACX,YAAY;EACZ,6BAA6B;EAC7B,YAAY;EACZ,eAAe;EACf,YAAY;EACZ,wBAAwB;EACxB,gBAAgB;AAClB;AAEA;EACE,UAAU;AACZ;AAEA;EACE,qBAAqB;EACrB,WAAW;EACX,YAAY;EACZ,yDAA+X;EAC/X,2BAA2B;EAC3B,4BAA4B;EAC5B,wBAAwB;AAC1B","sourcesContent":["<template>\r\n  <div v-if=\"isVisible\" class=\"render-panel-overlay\">\r\n    <div \r\n        class=\"render-panel\" \r\n        :style=\"{ left: panelPosition.x + 'px', top: panelPosition.y + 'px' }\"\r\n        @mousedown=\"startDrag\"\r\n      >\r\n      <div class=\"panel-header\" @mousedown=\"startDrag\">\r\n        <h3>渲染信息面板</h3>\r\n        <button class=\"close-btn\" @click=\"closePanel\" title=\"关闭面板\" @mousedown.stop>\r\n          <i class=\"close-icon\"></i>\r\n        </button>\r\n      </div>\r\n      \r\n      <div class=\"panel-content\">\r\n        <!-- 列表组件 -->\r\n        <div class=\"render-list\">\r\n          <div class=\"list-header\">\r\n            <span>渲染数据列表</span>\r\n            <span class=\"item-count\">{{ renderData.length }} 项</span>\r\n            <button class=\"copy-btn\" @click=\"copyList\" title=\"下载数据\">\r\n              <i class=\"download-icon\"></i>\r\n            </button>\r\n          </div>\r\n          <div class=\"list-container\">\r\n            <div v-if=\"renderData.length === 0\" class=\"empty-state\">\r\n              <i class=\"empty-icon\"></i>\r\n              <p>暂无渲染数据</p>\r\n              <small>点击下方按钮开始监听</small>\r\n            </div>\r\n            <div v-else class=\"list-items\">\r\n              <div \r\n                v-for=\"(item, index) in renderData\" \r\n                :key=\"index\" \r\n                class=\"list-item\"\r\n                :class=\"{ 'active': selectedIndex === index }\"\r\n                @click=\"selectItem(index)\"\r\n              >\r\n                <div class=\"item-info\">\r\n                  <span class=\"item-type\">{{ item.type }}</span>\r\n                </div>\r\n                <div class=\"item-details\">\r\n                  <span class=\"item-name\">{{ item.name }}</span>\r\n                </div>\r\n              </div>\r\n            </div>\r\n          </div>\r\n        </div>\r\n        \r\n        <!-- 控制按钮 -->\r\n        <div class=\"control-buttons\">\r\n          <button \r\n            class=\"control-btn start-btn\" \r\n            @click=\"startListening\"\r\n            title=\"开启渲染监听\"\r\n          >\r\n            <i class=\"start-icon\"></i>\r\n            开启监听\r\n          </button>\r\n          \r\n          <button \r\n            class=\"control-btn stop-btn\" \r\n            @click=\"stopListening\"\r\n            title=\"关闭渲染监听\"\r\n          >\r\n            <i class=\"stop-icon\"></i>\r\n            关闭监听\r\n          </button>\r\n          \r\n          <button \r\n            class=\"control-btn stack-btn\" \r\n            @click=\"getWebGLStack\"\r\n            title=\"获取WebGL调用堆栈\"\r\n          >\r\n            <i class=\"stack-icon\"></i>\r\n            获取WebGL堆栈\r\n          </button>\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </div>\r\n</template>\r\n\r\n<script setup lang=\"ts\">\r\nimport { ref, reactive, onMounted, onUnmounted, inject, type Ref } from 'vue'\r\nimport { EventType } from '@/core/message/Event'\r\nimport { Logger } from '@/core/Constant'\r\n\r\n// 注入父组件提供的sendMessage方法和lowerId\r\nconst sendMessage = inject('sendMessage') as Function\r\nconst lowerId = inject('lowerId') as Ref<string>\r\n\r\n// 面板显示状态\r\nconst isVisible = ref(false)\r\n\r\n// 监听状态\r\nconst isListening = ref(false)\r\n\r\n// 渲染数据列表\r\ninterface RenderDataItem {\r\n  type: string;\r\n  name: string;\r\n}\r\n\r\nconst renderData = reactive<RenderDataItem[]>([])\r\n\r\n// 选中项索引\r\nconst selectedIndex = ref(-1)\r\n\r\n// 面板位置和拖拽状态\r\nconst panelPosition = reactive({ x: 100, y: 100 })\r\nconst isDragging = ref(false)\r\nconst dragOffset = reactive({ x: 0, y: 0 })\r\n\r\n// 显示面板\r\nconst showPanel = () => {\r\n  isVisible.value = true\r\n  // 居中显示面板\r\n  panelPosition.x = (window.innerWidth - 600) / 2\r\n  panelPosition.y = (window.innerHeight - 500) / 2\r\n}\r\n\r\n// 关闭面板\r\nconst closePanel = () => {\r\n  isVisible.value = false\r\n}\r\n\r\n\r\n\r\n// 选择列表项\r\nconst selectItem = (index: number) => {\r\n  selectedIndex.value = index\r\n}\r\n\r\n// 下载列表文件\r\nconst copyList = () => {\r\n  try {\r\n    if (renderData.length === 0) {\r\n      Logger.warn('[Render Panel] 暂无数据可下载')\r\n      return\r\n    }\r\n    \r\n    // 将renderData中的name字段提取出来组成数组\r\n    const apiCalls = renderData.map(item => item.name)\r\n    \r\n    // 转换为JSON字符串\r\n    const jsonContent = JSON.stringify(apiCalls, null, 2)\r\n    \r\n    // 创建Blob对象\r\n    const blob = new Blob([jsonContent], { type: 'application/json' })\r\n    \r\n    // 创建下载链接\r\n    const url = URL.createObjectURL(blob)\r\n    const link = document.createElement('a')\r\n    link.href = url\r\n    \r\n    // 生成文件名（包含时间戳）\r\n    const timestamp = new Date().toISOString().replace(/[:.]/g, '-').slice(0, -5)\r\n    link.download = `webgl-api-calls-${timestamp}.json`\r\n    \r\n    // 触发下载\r\n    document.body.appendChild(link)\r\n    link.click()\r\n    document.body.removeChild(link)\r\n    \r\n    // 释放URL对象\r\n    URL.revokeObjectURL(url)\r\n    \r\n    Logger.log('[Render Panel] 已下载API调用列表文件')\r\n  } catch (error) {\r\n    Logger.error('[Render Panel] 下载失败:', error)\r\n  }\r\n}\r\n\r\n// 开始拖拽\r\nconst startDrag = (event: MouseEvent) => {\r\n  if (event.target === event.currentTarget || (event.target as HTMLElement).closest('.panel-header')) {\r\n    isDragging.value = true\r\n    dragOffset.x = event.clientX - panelPosition.x\r\n    dragOffset.y = event.clientY - panelPosition.y\r\n    \r\n    document.addEventListener('mousemove', onDrag)\r\n    document.addEventListener('mouseup', stopDrag)\r\n    event.preventDefault()\r\n  }\r\n}\r\n\r\n// 拖拽中\r\nconst onDrag = (event: MouseEvent) => {\r\n  if (isDragging.value) {\r\n    panelPosition.x = event.clientX - dragOffset.x\r\n    panelPosition.y = event.clientY - dragOffset.y\r\n    \r\n    // 限制面板不超出视窗边界\r\n    panelPosition.x = Math.max(0, Math.min(panelPosition.x, window.innerWidth - 600))\r\n    panelPosition.y = Math.max(0, Math.min(panelPosition.y, window.innerHeight - 500))\r\n  }\r\n}\r\n\r\n// 停止拖拽\r\nconst stopDrag = () => {\r\n  isDragging.value = false\r\n  document.removeEventListener('mousemove', onDrag)\r\n  document.removeEventListener('mouseup', stopDrag)\r\n}\r\n\r\n// 开启监听\r\nconst startListening = () => {\r\n  try {\r\n    Logger.log('[Render Panel] 开启WEBGL监听')\r\n    isListening.value = true\r\n    \r\n    // 通过父组件的sendMessage发送WEBGLHOOK开始请求\r\n    if (sendMessage) {\r\n      sendMessage({\r\n        type: EventType.WEBGLHOOK_START_REQUEST,\r\n        targetId: lowerId.value,\r\n        timestamp: Date.now()\r\n      })\r\n      Logger.log('📤 已发送WEBGLHOOK_START_REQUEST')\r\n    } else {\r\n      Logger.warn('sendMessage方法未注入，无法发送WEBGLHOOK开始请求')\r\n    }\r\n  } catch (error) {\r\n    Logger.error('[Render Panel] 开启监听失败:', error)\r\n  }\r\n}\r\n\r\n// 关闭监听\r\nconst stopListening = () => {\r\n  try {\r\n    Logger.log('[Render Panel] 关闭WEBGL监听')\r\n    isListening.value = false\r\n    \r\n    // 通过父组件的sendMessage发送WEBGLHOOK停止请求\r\n    if (sendMessage) {\r\n      sendMessage({\r\n        type: EventType.WEBGLHOOK_STOP_REQUEST,\r\n        targetId: lowerId.value,\r\n        timestamp: Date.now()\r\n      })\r\n      Logger.log('📤 已发送WEBGLHOOK_STOP_REQUEST')\r\n    } else {\r\n      Logger.warn('sendMessage方法未注入，无法发送WEBGLHOOK停止请求')\r\n    }\r\n  } catch (error) {\r\n    Logger.error('[Render Panel] 关闭监听失败:', error)\r\n  }\r\n}\r\n\r\n// 获取WebGL API调用数据\r\nconst getWebGLStack = () => {\r\n  try {\r\n    Logger.log('[Render Panel] 获取WebGL API调用数据')\r\n    \r\n    // 通过父组件的sendMessage发送WEBGLHOOK获取API调用请求\r\n    if (sendMessage) {\r\n      sendMessage({\r\n        type: EventType.WEBGLHOOK_GET_APICALL_REQUEST,\r\n        targetId: lowerId.value,\r\n        timestamp: Date.now()\r\n      })\r\n      Logger.log('📤 已发送WEBGLHOOK_GET_APICALL_REQUEST')\r\n    } else {\r\n      Logger.warn('sendMessage方法未注入，无法发送WEBGLHOOK获取API调用请求')\r\n    }\r\n  } catch (error) {\r\n    Logger.error('[Render Panel] 获取WebGL API调用数据失败:', error)\r\n  }\r\n}\r\n\r\n// 处理WEBGLHOOK响应消息\r\nconst handleWebGLHookResponse = (message: any) => {\r\n  switch (message.type) {\r\n    case EventType.WEBGLHOOK_START_RESPONSE:\r\n      Logger.log('📥 收到WEBGLHOOK_START_RESPONSE:', message)\r\n      if (message.success) {\r\n        isListening.value = true\r\n        Logger.log('✅ WEBGL监听已开启')\r\n      } else {\r\n        Logger.error('❌ 开启WEBGL监听失败:', message.error)\r\n        isListening.value = false\r\n      }\r\n      break\r\n      \r\n    case EventType.WEBGLHOOK_STOP_RESPONSE:\r\n      Logger.log('📥 收到WEBGLHOOK_STOP_RESPONSE:', message)\r\n      if (message.success) {\r\n        isListening.value = false\r\n        Logger.log('✅ WEBGL监听已关闭')\r\n      } else {\r\n        Logger.error('❌ 关闭WEBGL监听失败:', message.error)\r\n      }\r\n      break\r\n      \r\n    case EventType.WEBGLHOOK_GET_APICALL_RESPONSE:\r\n      Logger.log('📥 收到WEBGLHOOK_GET_APICALL_RESPONSE:', message)\r\n      if (message.success) {\r\n        renderData.length = 0;\r\n        // 处理API调用数据\r\n        if (Array.isArray(message.apiCalls)) {\r\n          message.apiCalls.forEach((apiCall: any) => {\r\n            renderData.push({\r\n              type: 'WebGL',\r\n              name: apiCall,\r\n            })\r\n          })\r\n        }\r\n        Logger.log('✅ WebGL API调用数据已更新')\r\n      } else {\r\n        Logger.error('❌ 获取WebGL API调用数据失败:', message.error)\r\n      }\r\n      break\r\n  }\r\n}\r\n\r\n// 暴露方法给父组件\r\ndefineExpose({\r\n  showPanel,\r\n  closePanel,\r\n  handleWebGLHookResponse\r\n})\r\n</script>\r\n\r\n<style scoped>\r\n.render-panel-overlay {\r\n  position: fixed;\r\n  top: 0;\r\n  left: 0;\r\n  right: 0;\r\n  bottom: 0;\r\n  z-index: 9999;\r\n  pointer-events: none;\r\n}\r\n\r\n.render-panel {\r\n  position: absolute;\r\n  width: 600px;\r\n  height: 500px;\r\n  background: var(--bg-card);\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 12px;\r\n  box-shadow: 0 8px 32px var(--shadow-primary);\r\n  display: flex;\r\n  flex-direction: column;\r\n  animation: slideIn 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n  pointer-events: auto;\r\n  user-select: none;\r\n  backdrop-filter: blur(16px);\r\n}\r\n\r\n.panel-header {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: space-between;\r\n  padding: 16px 20px;\r\n  border-bottom: 1px solid var(--border-primary);\r\n  background: var(--bg-secondary);\r\n  border-radius: 12px 12px 0 0;\r\n  cursor: move;\r\n  user-select: none;\r\n  backdrop-filter: blur(16px);\r\n}\r\n\r\n.panel-header:active {\r\n  cursor: grabbing;\r\n}\r\n\r\n.panel-header h3 {\r\n  margin: 0;\r\n  font-size: 16px;\r\n  font-weight: 600;\r\n  color: var(--text-primary);\r\n}\r\n\r\n.close-btn {\r\n  width: 28px;\r\n  height: 28px;\r\n  border: none;\r\n  background: transparent;\r\n  border-radius: 6px;\r\n  cursor: pointer;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  transition: all 0.2s ease;\r\n}\r\n\r\n.close-btn:hover {\r\n  background: var(--bg-button-hover);\r\n}\r\n\r\n.close-icon {\r\n  width: 14px;\r\n  height: 14px;\r\n  background: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\"><line x1=\"18\" y1=\"6\" x2=\"6\" y2=\"18\"></line><line x1=\"6\" y1=\"6\" x2=\"18\" y2=\"18\"></line></svg>') no-repeat center;\r\n  background-size: contain;\r\n}\r\n\r\n.panel-content {\r\n  flex: 1;\r\n  padding: 20px;\r\n  display: flex;\r\n  flex-direction: column;\r\n  gap: 20px;\r\n  overflow: hidden;\r\n}\r\n\r\n.render-list {\r\n  flex: 1;\r\n  display: flex;\r\n  flex-direction: column;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 8px;\r\n  overflow: hidden;\r\n  background: var(--bg-card);\r\n}\r\n\r\n.list-header {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: space-between;\r\n  padding: 12px 16px;\r\n  background: var(--bg-secondary);\r\n  border-bottom: 1px solid var(--border-primary);\r\n  font-size: 14px;\r\n  font-weight: 500;\r\n  color: var(--text-primary);\r\n}\r\n\r\n.item-count {\r\n  font-size: 12px;\r\n  color: var(--text-secondary);\r\n  background: var(--bg-card-secondary);\r\n  padding: 2px 8px;\r\n  border-radius: 12px;\r\n}\r\n\r\n.list-container {\r\n  flex: 1;\r\n  overflow-y: auto;\r\n}\r\n\r\n.empty-state {\r\n  display: flex;\r\n  flex-direction: column;\r\n  align-items: center;\r\n  justify-content: center;\r\n  height: 200px;\r\n  color: var(--text-secondary);\r\n  text-align: center;\r\n}\r\n\r\n.empty-icon {\r\n  width: 48px;\r\n  height: 48px;\r\n  margin-bottom: 12px;\r\n  background: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23666\" stroke-width=\"1.5\"><rect x=\"3\" y=\"3\" width=\"18\" height=\"18\" rx=\"2\" ry=\"2\"></rect><circle cx=\"8.5\" cy=\"8.5\" r=\"1.5\"></circle><polyline points=\"21,15 16,10 5,21\"></polyline></svg>') no-repeat center;\r\n  background-size: contain;\r\n  opacity: 0.5;\r\n}\r\n\r\n.list-items {\r\n  padding: 8px;\r\n}\r\n\r\n.list-item {\r\n  padding: 12px;\r\n  border-radius: 6px;\r\n  cursor: pointer;\r\n  transition: all 0.2s ease;\r\n  border: 1px solid transparent;\r\n  margin-bottom: 4px;\r\n}\r\n\r\n.list-item:hover {\r\n  background: var(--bg-card-secondary);\r\n  border-color: var(--border-accent);\r\n}\r\n\r\n.list-item.active {\r\n  background: var(--bg-panel);\r\n  border-color: var(--accent-primary);\r\n}\r\n\r\n.item-info {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: space-between;\r\n  margin-bottom: 4px;\r\n}\r\n\r\n.item-type {\r\n  font-size: 12px;\r\n  font-weight: 500;\r\n  color: var(--accent-primary);\r\n  background: var(--bg-card-secondary);\r\n  padding: 2px 6px;\r\n  border-radius: 4px;\r\n}\r\n\r\n.item-time {\r\n  font-size: 11px;\r\n  color: var(--text-secondary);\r\n}\r\n\r\n.item-details {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: space-between;\r\n}\r\n\r\n.item-name {\r\n  font-size: 13px;\r\n  color: var(--text-primary);\r\n  font-weight: 500;\r\n}\r\n\r\n.item-value {\r\n  font-size: 12px;\r\n  color: var(--text-secondary);\r\n  font-family: monospace;\r\n}\r\n\r\n.control-buttons {\r\n  display: flex;\r\n  gap: 12px;\r\n  padding-top: 16px;\r\n  border-top: 1px solid var(--border-primary);\r\n}\r\n\r\n.control-btn {\r\n  flex: 1;\r\n  padding: 10px 16px;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 8px;\r\n  background: var(--bg-button);\r\n  color: var(--text-primary);\r\n  font-size: 13px;\r\n  font-weight: 500;\r\n  cursor: pointer;\r\n  transition: all 0.2s ease;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  gap: 6px;\r\n}\r\n\r\n.control-btn:hover {\r\n  background: var(--bg-button-hover);\r\n  border-color: var(--border-accent);\r\n  color: var(--accent-primary);\r\n  transform: translateY(-1px);\r\n  box-shadow: 0 4px 16px var(--shadow-accent);\r\n}\r\n\r\n.start-icon {\r\n  width: 12px;\r\n  height: 12px;\r\n  background: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"currentColor\"><polygon points=\"5,3 19,12 5,21\"></polygon></svg>') no-repeat center;\r\n  background-size: contain;\r\n}\r\n\r\n.stop-icon {\r\n  width: 12px;\r\n  height: 12px;\r\n  background: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"currentColor\"><rect x=\"6\" y=\"6\" width=\"12\" height=\"12\"></rect></svg>') no-repeat center;\r\n  background-size: contain;\r\n}\r\n\r\n.stack-icon {\r\n  width: 12px;\r\n  height: 12px;\r\n  background: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\"><rect x=\"3\" y=\"3\" width=\"18\" height=\"18\" rx=\"2\" ry=\"2\"></rect><rect x=\"7\" y=\"7\" width=\"10\" height=\"3\"></rect><rect x=\"7\" y=\"14\" width=\"10\" height=\"3\"></rect></svg>') no-repeat center;\r\n  background-size: contain;\r\n}\r\n\r\n@keyframes fadeIn {\r\n  from {\r\n    opacity: 0;\r\n  }\r\n  to {\r\n    opacity: 1;\r\n  }\r\n}\r\n\r\n@keyframes slideIn {\r\n  from {\r\n    opacity: 0;\r\n    transform: scale(0.9) translateY(-20px);\r\n  }\r\n  to {\r\n    opacity: 1;\r\n    transform: scale(1) translateY(0);\r\n  }\r\n}\r\n\r\n.copy-btn {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  width: 24px;\r\n  height: 24px;\r\n  background-color: transparent;\r\n  border: none;\r\n  cursor: pointer;\r\n  opacity: 0.7;\r\n  transition: opacity 0.2s;\r\n  margin-left: 8px;\r\n}\r\n\r\n.copy-btn:hover {\r\n  opacity: 1;\r\n}\r\n\r\n.download-icon {\r\n  display: inline-block;\r\n  width: 16px;\r\n  height: 16px;\r\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><path d=\"M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4\"></path><polyline points=\"7,10 12,15 17,10\"></polyline><line x1=\"12\" y1=\"15\" x2=\"12\" y2=\"3\"></line></svg>');\r\n  background-position: center;\r\n  background-repeat: no-repeat;\r\n  background-size: contain;\r\n}\r\n</style>"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/SliderInput.vue?vue&type=style&index=0&id=703ac460&scoped=true&lang=css":
/*!*********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/SliderInput.vue?vue&type=style&index=0&id=703ac460&scoped=true&lang=css ***!
  \*********************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
.slider-input[data-v-703ac460] {
  display: flex;
  align-items: center;
  gap: 12px;
  width: 100%;
}
.slider-container[data-v-703ac460] {
  position: relative;
  flex: 1;
  height: 20px;
  display: flex;
  align-items: center;
}
.slider[data-v-703ac460] {
  width: 100%;
  height: 20px;
  background: transparent;
  outline: none;
  cursor: pointer;
  position: relative;
  z-index: 2;
  -webkit-appearance: none;
  appearance: none;
}

/* WebKit浏览器滑动条样式 */
.slider[data-v-703ac460]::-webkit-slider-track {
  background: transparent;
  height: 6px;
  border-radius: 3px;
}
.slider[data-v-703ac460]::-webkit-slider-thumb {
  -webkit-appearance: none;
  appearance: none;
  width: 16px;
  height: 16px;
  border-radius: 50%;
  background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));
  border: 2px solid var(--bg-panel);
  cursor: pointer;
  box-shadow: 
    0 2px 8px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset;
  transition: all 0.2s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.slider[data-v-703ac460]::-webkit-slider-thumb:hover {
  transform: scale(1.1);
  box-shadow: 
    0 4px 16px var(--shadow-accent),
    0 0 0 2px var(--accent-primary) inset;
}
.slider[data-v-703ac460]::-webkit-slider-thumb:active {
  transform: scale(1.2);
  box-shadow: 
    0 6px 20px var(--shadow-accent),
    0 0 0 3px var(--accent-primary) inset;
}

/* Firefox滑动条样式 */
.slider[data-v-703ac460]::-moz-range-track {
  background: transparent;
  height: 6px;
  border-radius: 3px;
  border: none;
}
.slider[data-v-703ac460]::-moz-range-thumb {
  width: 16px;
  height: 16px;
  border-radius: 50%;
  background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));
  border: 2px solid var(--bg-panel);
  cursor: pointer;
  box-shadow: 
    0 2px 8px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset;
  transition: all 0.2s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.slider[data-v-703ac460]::-moz-range-thumb:hover {
  transform: scale(1.1);
  box-shadow: 
    0 4px 16px var(--shadow-accent),
    0 0 0 2px var(--accent-primary) inset;
}
.slider[data-v-703ac460]::-moz-range-thumb:active {
  transform: scale(1.2);
  box-shadow: 
    0 6px 20px var(--shadow-accent),
    0 0 0 3px var(--accent-primary) inset;
}

/* 自定义滑动条轨道 */
.slider-track[data-v-703ac460] {
  position: absolute;
  top: 50%;
  left: 0;
  right: 0;
  height: 6px;
  background: var(--bg-secondary);
  border-radius: 3px;
  border: 1px solid var(--border-primary);
  transform: translateY(-50%);
  z-index: 1;
  box-shadow: 
    0 2px 4px var(--shadow-primary) inset,
    0 0 0 1px var(--border-primary) inset;
}
.slider-fill[data-v-703ac460] {
  height: 100%;
  background: linear-gradient(90deg, var(--accent-primary), var(--accent-secondary));
  border-radius: 3px;
  transition: width 0.2s ease;
  box-shadow: 
    0 0 8px var(--shadow-accent),
    0 0 0 1px var(--accent-primary) inset;
}
.value-input[data-v-703ac460] {
  flex-shrink: 0;
  width: 60px;
  padding: 4px 8px;
  border: 1px solid var(--border-primary);
  border-radius: 6px;
  font-size: 12px;
  background: var(--bg-card);
  backdrop-filter: blur(8px);
  color: var(--text-primary);
  font-family: 'SF Mono', Monaco, 'Cascadia Code', 'Roboto Mono', Consolas, 'Courier New', monospace;
  font-variant-numeric: tabular-nums;
  text-align: center;
  height: 28px;
  box-shadow: 
    0 2px 8px var(--shadow-primary),
    0 0 0 1px var(--border-primary) inset;
  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.value-input[data-v-703ac460]:focus {
  outline: none;
  border-color: var(--border-accent);
  box-shadow: 
    0 0 0 3px var(--shadow-accent),
    0 4px 16px var(--shadow-accent),
    0 0 0 1px var(--border-accent) inset;
  background: var(--bg-panel);
  transform: translateY(-1px);
  text-shadow: var(--text-glow-accent);
}
.value-input[data-v-703ac460]:hover:not(:focus) {
  border-color: var(--border-accent);
  box-shadow: 
    0 4px 12px var(--shadow-accent),
    0 0 0 1px var(--border-primary) inset;
}

/* 移除浏览器默认的数字输入框样式 */
.value-input[data-v-703ac460]::-webkit-outer-spin-button,
.value-input[data-v-703ac460]::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}
.value-input[type=number][data-v-703ac460] {
  -moz-appearance: textfield;
}

/* 禁用状态样式 */
.slider.disabled[data-v-703ac460] {
  opacity: 0.7;
  cursor: not-allowed;
  pointer-events: none;
}
.slider.disabled[data-v-703ac460]::-webkit-slider-thumb {
  background: var(--bg-disabled, rgba(128, 128, 128, 0.4));
  border-color: var(--border-disabled, rgba(128, 128, 128, 0.5));
  cursor: not-allowed;
  box-shadow: 
    0 2px 4px var(--shadow-primary),
    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;
}
.slider.disabled[data-v-703ac460]::-webkit-slider-thumb:hover {
  transform: none;
  box-shadow: 
    0 2px 4px var(--shadow-primary),
    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;
}
.slider.disabled[data-v-703ac460]::-moz-range-thumb {
  background: var(--bg-disabled, rgba(128, 128, 128, 0.4));
  border-color: var(--border-disabled, rgba(128, 128, 128, 0.5));
  cursor: not-allowed;
  box-shadow: 
    0 2px 4px var(--shadow-primary),
    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;
}
.slider.disabled[data-v-703ac460]::-moz-range-thumb:hover {
  transform: none;
  box-shadow: 
    0 2px 4px var(--shadow-primary),
    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;
}
.slider-track.disabled[data-v-703ac460] {
  background: var(--bg-disabled, rgba(128, 128, 128, 0.1));
  border-color: var(--border-disabled, rgba(128, 128, 128, 0.3));
}
.slider-fill.disabled[data-v-703ac460] {
  background: var(--bg-disabled, rgba(128, 128, 128, 0.3));
  box-shadow: 
    0 0 4px var(--shadow-primary),
    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;
}
.value-input[data-v-703ac460]:disabled {
  opacity: 0.7;
  cursor: not-allowed;
  background: var(--bg-disabled, rgba(128, 128, 128, 0.15));
  color: var(--text-primary);
  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));
  pointer-events: none;
}
.value-input[data-v-703ac460]:disabled:hover {
  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));
  box-shadow: 
    0 2px 8px var(--shadow-primary),
    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;
  transform: none;
}

/* 响应式设计 */
@media (max-width: 768px) {
.slider-input[data-v-703ac460] {
    flex-direction: column;
    gap: 8px;
}
.value-input[data-v-703ac460] {
    width: 100%;
}
}
`, "",{"version":3,"sources":["webpack://./src/devtools/components/SliderInput.vue"],"names":[],"mappings":";AA6IA;EACE,aAAa;EACb,mBAAmB;EACnB,SAAS;EACT,WAAW;AACb;AAEA;EACE,kBAAkB;EAClB,OAAO;EACP,YAAY;EACZ,aAAa;EACb,mBAAmB;AACrB;AAEA;EACE,WAAW;EACX,YAAY;EACZ,uBAAuB;EACvB,aAAa;EACb,eAAe;EACf,kBAAkB;EAClB,UAAU;EACV,wBAAwB;EACxB,gBAAgB;AAClB;;AAEA,mBAAmB;AACnB;EACE,uBAAuB;EACvB,WAAW;EACX,kBAAkB;AACpB;AAEA;EACE,wBAAwB;EACxB,gBAAgB;EAChB,WAAW;EACX,YAAY;EACZ,kBAAkB;EAClB,mFAAmF;EACnF,iCAAiC;EACjC,eAAe;EACf;;wCAEsC;EACtC,yDAAyD;AAC3D;AAEA;EACE,qBAAqB;EACrB;;yCAEuC;AACzC;AAEA;EACE,qBAAqB;EACrB;;yCAEuC;AACzC;;AAEA,iBAAiB;AACjB;EACE,uBAAuB;EACvB,WAAW;EACX,kBAAkB;EAClB,YAAY;AACd;AAEA;EACE,WAAW;EACX,YAAY;EACZ,kBAAkB;EAClB,mFAAmF;EACnF,iCAAiC;EACjC,eAAe;EACf;;wCAEsC;EACtC,yDAAyD;AAC3D;AAEA;EACE,qBAAqB;EACrB;;yCAEuC;AACzC;AAEA;EACE,qBAAqB;EACrB;;yCAEuC;AACzC;;AAEA,aAAa;AACb;EACE,kBAAkB;EAClB,QAAQ;EACR,OAAO;EACP,QAAQ;EACR,WAAW;EACX,+BAA+B;EAC/B,kBAAkB;EAClB,uCAAuC;EACvC,2BAA2B;EAC3B,UAAU;EACV;;yCAEuC;AACzC;AAEA;EACE,YAAY;EACZ,kFAAkF;EAClF,kBAAkB;EAClB,2BAA2B;EAC3B;;yCAEuC;AACzC;AAEA;EACE,cAAc;EACd,WAAW;EACX,gBAAgB;EAChB,uCAAuC;EACvC,kBAAkB;EAClB,eAAe;EACf,0BAA0B;EAC1B,0BAA0B;EAC1B,0BAA0B;EAC1B,kGAAkG;EAClG,kCAAkC;EAClC,kBAAkB;EAClB,YAAY;EACZ;;yCAEuC;EACvC,yDAAyD;AAC3D;AAEA;EACE,aAAa;EACb,kCAAkC;EAClC;;;wCAGsC;EACtC,2BAA2B;EAC3B,2BAA2B;EAC3B,oCAAoC;AACtC;AAEA;EACE,kCAAkC;EAClC;;yCAEuC;AACzC;;AAEA,oBAAoB;AACpB;;EAEE,wBAAwB;EACxB,SAAS;AACX;AAEA;EACE,0BAA0B;AAC5B;;AAEA,WAAW;AACX;EACE,YAAY;EACZ,mBAAmB;EACnB,oBAAoB;AACtB;AAEA;EACE,wDAAwD;EACxD,8DAA8D;EAC9D,mBAAmB;EACnB;;oEAEkE;AACpE;AAEA;EACE,eAAe;EACf;;oEAEkE;AACpE;AAEA;EACE,wDAAwD;EACxD,8DAA8D;EAC9D,mBAAmB;EACnB;;oEAEkE;AACpE;AAEA;EACE,eAAe;EACf;;oEAEkE;AACpE;AAEA;EACE,wDAAwD;EACxD,8DAA8D;AAChE;AAEA;EACE,wDAAwD;EACxD;;oEAEkE;AACpE;AAEA;EACE,YAAY;EACZ,mBAAmB;EACnB,yDAAyD;EACzD,0BAA0B;EAC1B,8DAA8D;EAC9D,oBAAoB;AACtB;AAEA;EACE,8DAA8D;EAC9D;;oEAEkE;EAClE,eAAe;AACjB;;AAEA,UAAU;AACV;AACE;IACE,sBAAsB;IACtB,QAAQ;AACV;AAEA;IACE,WAAW;AACb;AACF","sourcesContent":["<template>\r\n  <div class=\"slider-input\">\r\n    <div class=\"slider-container\">\r\n      <input\r\n        ref=\"sliderRef\"\r\n        type=\"range\"\r\n        :value=\"value\"\r\n        :min=\"min\"\r\n        :max=\"max\"\r\n        :step=\"step\"\r\n        :disabled=\"disabled\"\r\n        @input=\"onInput\"\r\n        @change=\"onChange\"\r\n        class=\"slider\"\r\n        :class=\"{ 'disabled': disabled }\"\r\n        :style=\"{ '--slider-percentage': percentage + '%' }\"\r\n      />\r\n      <div class=\"slider-track\" :class=\"{ 'disabled': disabled }\">\r\n        <div class=\"slider-fill\" :style=\"{ width: percentage + '%' }\"></div>\r\n      </div>\r\n      <div class=\"slider-thumb\" :class=\"{ 'disabled': disabled }\" :style=\"{ left: percentage + '%' }\"></div>\r\n    </div>\r\n    \r\n    <input\r\n      ref=\"valueInputRef\"\r\n      type=\"number\"\r\n      :value=\"displayValue\"\r\n      :min=\"min\"\r\n      :max=\"max\"\r\n      :step=\"step\"\r\n      :disabled=\"disabled\"\r\n      @input=\"onValueInput\"\r\n      @focus=\"onValueFocus\"\r\n      @blur=\"onValueBlur\"\r\n      class=\"value-input\"\r\n      :class=\"{ 'disabled': disabled }\"\r\n    />\r\n  </div>\r\n</template>\r\n\r\n<script setup lang=\"ts\">\r\nimport { ref, computed } from 'vue';\r\n\r\n// Props\r\ninterface Props {\r\n  value: number;\r\n  min?: number;\r\n  max?: number;\r\n  step?: number;\r\n  precision?: number;\r\n  disabled?: boolean;\r\n}\r\n\r\nconst props = withDefaults(defineProps<Props>(), {\r\n  min: 0,\r\n  max: 1,\r\n  step: 0.01,\r\n  precision: 5,\r\n  disabled: false\r\n});\r\n\r\n// Emits\r\nconst emit = defineEmits<{\r\n  change: [value: number];\r\n}>();\r\n\r\n// 响应式状态\r\nconst sliderRef = ref<HTMLInputElement>();\r\nconst valueInputRef = ref<HTMLInputElement>();\r\nconst isValueFocused = ref(false);\r\n\r\n// 计算属性\r\nconst percentage = computed(() => {\r\n  const range = props.max - props.min;\r\n  return ((props.value - props.min) / range) * 100;\r\n});\r\n\r\nconst displayValue = computed(() => {\r\n  if (isValueFocused.value) {\r\n    return props.value;\r\n  }\r\n  return Number(props.value.toFixed(props.precision));\r\n});\r\n\r\n// 约束值在范围内\r\nconst clampValue = (value: number): number => {\r\n  return Math.max(props.min, Math.min(props.max, value));\r\n};\r\n\r\n// 滑动条输入处理\r\nconst onInput = (event: Event) => {\r\n  if (props.disabled) return;\r\n  const target = event.target as HTMLInputElement;\r\n  const newValue = parseFloat(target.value);\r\n  if (!isNaN(newValue)) {\r\n    emit('change', clampValue(newValue));\r\n  }\r\n};\r\n\r\nconst onChange = (event: Event) => {\r\n  if (props.disabled) return;\r\n  const target = event.target as HTMLInputElement;\r\n  const newValue = parseFloat(target.value);\r\n  if (!isNaN(newValue)) {\r\n    emit('change', clampValue(newValue));\r\n  }\r\n};\r\n\r\n// 数值输入框处理\r\nconst onValueInput = (event: Event) => {\r\n  if (props.disabled) return;\r\n  const target = event.target as HTMLInputElement;\r\n  const newValue = parseFloat(target.value);\r\n  if (!isNaN(newValue)) {\r\n    emit('change', clampValue(newValue));\r\n  }\r\n};\r\n\r\nconst onValueFocus = () => {\r\n  if (props.disabled) return;\r\n  isValueFocused.value = true;\r\n};\r\n\r\nconst onValueBlur = () => {\r\n  if (props.disabled) return;\r\n  isValueFocused.value = false;\r\n  \r\n  // 确保值是有效的\r\n  if (valueInputRef.value) {\r\n    const currentValue = parseFloat(valueInputRef.value.value);\r\n    if (!isNaN(currentValue)) {\r\n      const clampedValue = clampValue(currentValue);\r\n      if (clampedValue !== currentValue) {\r\n        emit('change', clampedValue);\r\n      }\r\n    }\r\n  }\r\n};\r\n</script>\r\n\r\n<style scoped>\r\n.slider-input {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 12px;\r\n  width: 100%;\r\n}\r\n\r\n.slider-container {\r\n  position: relative;\r\n  flex: 1;\r\n  height: 20px;\r\n  display: flex;\r\n  align-items: center;\r\n}\r\n\r\n.slider {\r\n  width: 100%;\r\n  height: 20px;\r\n  background: transparent;\r\n  outline: none;\r\n  cursor: pointer;\r\n  position: relative;\r\n  z-index: 2;\r\n  -webkit-appearance: none;\r\n  appearance: none;\r\n}\r\n\r\n/* WebKit浏览器滑动条样式 */\r\n.slider::-webkit-slider-track {\r\n  background: transparent;\r\n  height: 6px;\r\n  border-radius: 3px;\r\n}\r\n\r\n.slider::-webkit-slider-thumb {\r\n  -webkit-appearance: none;\r\n  appearance: none;\r\n  width: 16px;\r\n  height: 16px;\r\n  border-radius: 50%;\r\n  background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));\r\n  border: 2px solid var(--bg-panel);\r\n  cursor: pointer;\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset;\r\n  transition: all 0.2s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.slider::-webkit-slider-thumb:hover {\r\n  transform: scale(1.1);\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 2px var(--accent-primary) inset;\r\n}\r\n\r\n.slider::-webkit-slider-thumb:active {\r\n  transform: scale(1.2);\r\n  box-shadow: \r\n    0 6px 20px var(--shadow-accent),\r\n    0 0 0 3px var(--accent-primary) inset;\r\n}\r\n\r\n/* Firefox滑动条样式 */\r\n.slider::-moz-range-track {\r\n  background: transparent;\r\n  height: 6px;\r\n  border-radius: 3px;\r\n  border: none;\r\n}\r\n\r\n.slider::-moz-range-thumb {\r\n  width: 16px;\r\n  height: 16px;\r\n  border-radius: 50%;\r\n  background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));\r\n  border: 2px solid var(--bg-panel);\r\n  cursor: pointer;\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset;\r\n  transition: all 0.2s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.slider::-moz-range-thumb:hover {\r\n  transform: scale(1.1);\r\n  box-shadow: \r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 2px var(--accent-primary) inset;\r\n}\r\n\r\n.slider::-moz-range-thumb:active {\r\n  transform: scale(1.2);\r\n  box-shadow: \r\n    0 6px 20px var(--shadow-accent),\r\n    0 0 0 3px var(--accent-primary) inset;\r\n}\r\n\r\n/* 自定义滑动条轨道 */\r\n.slider-track {\r\n  position: absolute;\r\n  top: 50%;\r\n  left: 0;\r\n  right: 0;\r\n  height: 6px;\r\n  background: var(--bg-secondary);\r\n  border-radius: 3px;\r\n  border: 1px solid var(--border-primary);\r\n  transform: translateY(-50%);\r\n  z-index: 1;\r\n  box-shadow: \r\n    0 2px 4px var(--shadow-primary) inset,\r\n    0 0 0 1px var(--border-primary) inset;\r\n}\r\n\r\n.slider-fill {\r\n  height: 100%;\r\n  background: linear-gradient(90deg, var(--accent-primary), var(--accent-secondary));\r\n  border-radius: 3px;\r\n  transition: width 0.2s ease;\r\n  box-shadow: \r\n    0 0 8px var(--shadow-accent),\r\n    0 0 0 1px var(--accent-primary) inset;\r\n}\r\n\r\n.value-input {\r\n  flex-shrink: 0;\r\n  width: 60px;\r\n  padding: 4px 8px;\r\n  border: 1px solid var(--border-primary);\r\n  border-radius: 6px;\r\n  font-size: 12px;\r\n  background: var(--bg-card);\r\n  backdrop-filter: blur(8px);\r\n  color: var(--text-primary);\r\n  font-family: 'SF Mono', Monaco, 'Cascadia Code', 'Roboto Mono', Consolas, 'Courier New', monospace;\r\n  font-variant-numeric: tabular-nums;\r\n  text-align: center;\r\n  height: 28px;\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary),\r\n    0 0 0 1px var(--border-primary) inset;\r\n  transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.value-input:focus {\r\n  outline: none;\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 0 0 3px var(--shadow-accent),\r\n    0 4px 16px var(--shadow-accent),\r\n    0 0 0 1px var(--border-accent) inset;\r\n  background: var(--bg-panel);\r\n  transform: translateY(-1px);\r\n  text-shadow: var(--text-glow-accent);\r\n}\r\n\r\n.value-input:hover:not(:focus) {\r\n  border-color: var(--border-accent);\r\n  box-shadow: \r\n    0 4px 12px var(--shadow-accent),\r\n    0 0 0 1px var(--border-primary) inset;\r\n}\r\n\r\n/* 移除浏览器默认的数字输入框样式 */\r\n.value-input::-webkit-outer-spin-button,\r\n.value-input::-webkit-inner-spin-button {\r\n  -webkit-appearance: none;\r\n  margin: 0;\r\n}\r\n\r\n.value-input[type=number] {\r\n  -moz-appearance: textfield;\r\n}\r\n\r\n/* 禁用状态样式 */\r\n.slider.disabled {\r\n  opacity: 0.7;\r\n  cursor: not-allowed;\r\n  pointer-events: none;\r\n}\r\n\r\n.slider.disabled::-webkit-slider-thumb {\r\n  background: var(--bg-disabled, rgba(128, 128, 128, 0.4));\r\n  border-color: var(--border-disabled, rgba(128, 128, 128, 0.5));\r\n  cursor: not-allowed;\r\n  box-shadow: \r\n    0 2px 4px var(--shadow-primary),\r\n    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;\r\n}\r\n\r\n.slider.disabled::-webkit-slider-thumb:hover {\r\n  transform: none;\r\n  box-shadow: \r\n    0 2px 4px var(--shadow-primary),\r\n    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;\r\n}\r\n\r\n.slider.disabled::-moz-range-thumb {\r\n  background: var(--bg-disabled, rgba(128, 128, 128, 0.4));\r\n  border-color: var(--border-disabled, rgba(128, 128, 128, 0.5));\r\n  cursor: not-allowed;\r\n  box-shadow: \r\n    0 2px 4px var(--shadow-primary),\r\n    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;\r\n}\r\n\r\n.slider.disabled::-moz-range-thumb:hover {\r\n  transform: none;\r\n  box-shadow: \r\n    0 2px 4px var(--shadow-primary),\r\n    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;\r\n}\r\n\r\n.slider-track.disabled {\r\n  background: var(--bg-disabled, rgba(128, 128, 128, 0.1));\r\n  border-color: var(--border-disabled, rgba(128, 128, 128, 0.3));\r\n}\r\n\r\n.slider-fill.disabled {\r\n  background: var(--bg-disabled, rgba(128, 128, 128, 0.3));\r\n  box-shadow: \r\n    0 0 4px var(--shadow-primary),\r\n    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;\r\n}\r\n\r\n.value-input:disabled {\r\n  opacity: 0.7;\r\n  cursor: not-allowed;\r\n  background: var(--bg-disabled, rgba(128, 128, 128, 0.15));\r\n  color: var(--text-primary);\r\n  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));\r\n  pointer-events: none;\r\n}\r\n\r\n.value-input:disabled:hover {\r\n  border-color: var(--border-disabled, rgba(128, 128, 128, 0.4));\r\n  box-shadow: \r\n    0 2px 8px var(--shadow-primary),\r\n    0 0 0 1px var(--border-disabled, rgba(128, 128, 128, 0.4)) inset;\r\n  transform: none;\r\n}\r\n\r\n/* 响应式设计 */\r\n@media (max-width: 768px) {\r\n  .slider-input {\r\n    flex-direction: column;\r\n    gap: 8px;\r\n  }\r\n  \r\n  .value-input {\r\n    width: 100%;\r\n  }\r\n}\r\n</style>"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/Toast.vue?vue&type=style&index=0&id=8f250e64&scoped=true&lang=css":
/*!***************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/Toast.vue?vue&type=style&index=0&id=8f250e64&scoped=true&lang=css ***!
  \***************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
.toast-container[data-v-8f250e64] {
  z-index: 10000;
  pointer-events: none;
  /* 深色主题变量 */
  --toast-bg: linear-gradient(135deg, rgba(15, 20, 25, 0.95) 0%, rgba(26, 31, 41, 0.95) 100%);
  --toast-text: #f0f2f5;
  --toast-icon: #40e0d0;
  --toast-border: rgba(0, 162, 255, 0.4);
  --toast-shadow: rgba(0, 162, 255, 0.3);
  --toast-glow: 0 0 8px rgba(0, 162, 255, 0.5);
}

/* 浅色主题变量 */
.toast-container.light-mode[data-v-8f250e64] {
  --toast-bg: rgba(255, 255, 255, 0.95);
  --toast-text: #1e293b;
  --toast-icon: #14b8a6;
  --toast-border: rgba(0, 0, 0, 0.12);
  --toast-shadow: rgba(0, 0, 0, 0.1);
  --toast-glow: 0 1px 2px rgba(0, 0, 0, 0.08);
}
.toast[data-v-8f250e64] {
  background: var(--toast-bg);
  backdrop-filter: blur(16px);
  border-radius: 12px;
  border: 1px solid var(--toast-border);
  padding: 16px 20px;
  min-width: 280px;
  max-width: 400px;
  box-shadow: 
    0 8px 32px var(--toast-shadow),
    0 0 0 1px var(--toast-border) inset;
  transform: translateY(20px) scale(0.9);
  opacity: 0;
  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}
.toast.show[data-v-8f250e64] {
  animation: toastSlideInUp-8f250e64 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94) forwards;
}
.toast.hide[data-v-8f250e64] {
  animation: toastFloatUp-8f250e64 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94) forwards;
}
.toast-content[data-v-8f250e64] {
  display: flex;
  align-items: center;
  gap: 12px;
}
.toast-icon[data-v-8f250e64] {
  display: flex;
  align-items: center;
  justify-content: center;
  width: 24px;
  height: 24px;
  background: linear-gradient(135deg, var(--toast-icon), var(--toast-icon));
  border-radius: 50%;
  font-size: 14px;
  font-weight: bold;
  color: #ffffff;
  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
  box-shadow: 
    0 2px 8px var(--toast-shadow),
    0 0 0 1px var(--toast-border) inset;
  flex-shrink: 0;
}
.toast-message[data-v-8f250e64] {
  color: var(--toast-text);
  font-size: 14px;
  font-weight: 500;
  line-height: 1.4;
  text-shadow: var(--toast-glow);
  flex: 1;
}

/* 动画特效 */
@keyframes toastSlideInUp-8f250e64 {
from {
    transform: translateY(20px) scale(0.9);
    opacity: 0;
}
to {
    transform: translateY(0) scale(1);
    opacity: 1;
}
}
@keyframes toastFloatUp-8f250e64 {
0% {
    transform: translateY(0) scale(1);
    opacity: 1;
}
100% {
    transform: translateY(-40px) scale(0.95);
    opacity: 0;
}
}
`, "",{"version":3,"sources":["webpack://./src/devtools/components/Toast.vue"],"names":[],"mappings":";AAwFA;EACE,cAAc;EACd,oBAAoB;EACpB,WAAW;EACX,2FAA2F;EAC3F,qBAAqB;EACrB,qBAAqB;EACrB,sCAAsC;EACtC,sCAAsC;EACtC,4CAA4C;AAC9C;;AAEA,WAAW;AACX;EACE,qCAAqC;EACrC,qBAAqB;EACrB,qBAAqB;EACrB,mCAAmC;EACnC,kCAAkC;EAClC,2CAA2C;AAC7C;AAEA;EACE,2BAA2B;EAC3B,2BAA2B;EAC3B,mBAAmB;EACnB,qCAAqC;EACrC,kBAAkB;EAClB,gBAAgB;EAChB,gBAAgB;EAChB;;uCAEqC;EACrC,sCAAsC;EACtC,UAAU;EACV,yDAAyD;AAC3D;AAEA;EACE,qFAA4E;AAC9E;AAEA;EACE,mFAA0E;AAC5E;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,SAAS;AACX;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,WAAW;EACX,YAAY;EACZ,yEAAyE;EACzE,kBAAkB;EAClB,eAAe;EACf,iBAAiB;EACjB,cAAc;EACd,yCAAyC;EACzC;;uCAEqC;EACrC,cAAc;AAChB;AAEA;EACE,wBAAwB;EACxB,eAAe;EACf,gBAAgB;EAChB,gBAAgB;EAChB,8BAA8B;EAC9B,OAAO;AACT;;AAEA,SAAS;AACT;AACE;IACE,sCAAsC;IACtC,UAAU;AACZ;AACA;IACE,iCAAiC;IACjC,UAAU;AACZ;AACF;AAEA;AACE;IACE,iCAAiC;IACjC,UAAU;AACZ;AACA;IACE,wCAAwC;IACxC,UAAU;AACZ;AACF","sourcesContent":["<template>\r\n  <Teleport to=\"body\">\r\n    <div \r\n      v-if=\"visible\" \r\n      :class=\"['toast-container', { 'light-mode': !isDarkMode }]\"\r\n      :style=\"positionStyle\"\r\n    >\r\n      <div class=\"toast\" :class=\"{ 'show': visible, 'hide': !visible }\">\r\n        <div class=\"toast-content\">\r\n          <i class=\"toast-icon\">✓</i>\r\n          <span class=\"toast-message\">{{ message }}</span>\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </Teleport>\r\n</template>\r\n\r\n<script setup lang=\"ts\">\r\nimport { ref, computed, onMounted } from 'vue';\r\n\r\ninterface ToastPosition {\r\n  x: number;\r\n  y: number;\r\n}\r\n\r\ninterface Props {\r\n  message: string;\r\n  duration?: number;\r\n  isDarkMode?: boolean;\r\n  position?: ToastPosition;\r\n}\r\n\r\nconst props = withDefaults(defineProps<Props>(), {\r\n  duration: 1000,\r\n  isDarkMode: true,\r\n  position: () => ({ x: 0, y: 0 })\r\n});\r\n\r\nconst emit = defineEmits<{\r\n  hide: [];\r\n}>();\r\n\r\nconst visible = ref(false);\r\n\r\n// 计算位置样式\r\nconst positionStyle = computed(() => {\r\n  if (props.position && props.position.x !== 0 && props.position.y !== 0) {\r\n    return {\r\n      position: 'fixed' as const,\r\n      left: `${props.position.x}px`,\r\n      top: `${props.position.y - 60}px`, // 在按钮上方60px\r\n      right: 'auto'\r\n    };\r\n  }\r\n  return {\r\n    position: 'fixed' as const,\r\n    top: '20px',\r\n    right: '20px'\r\n  };\r\n});\r\n\r\nconst show = () => {\r\n  visible.value = true;\r\n  setTimeout(() => {\r\n    hide();\r\n  }, props.duration);\r\n};\r\n\r\nconst hide = () => {\r\n  visible.value = false;\r\n  setTimeout(() => {\r\n    emit('hide');\r\n  }, 300); // 等待退出动画完成\r\n};\r\n\r\n// 组件挂载时显示\r\nonMounted(() => {\r\n  show();\r\n});\r\n\r\n// 暴露方法给父组件\r\ndefineExpose({\r\n  show,\r\n  hide\r\n});\r\n</script>\r\n\r\n<style scoped>\r\n.toast-container {\r\n  z-index: 10000;\r\n  pointer-events: none;\r\n  /* 深色主题变量 */\r\n  --toast-bg: linear-gradient(135deg, rgba(15, 20, 25, 0.95) 0%, rgba(26, 31, 41, 0.95) 100%);\r\n  --toast-text: #f0f2f5;\r\n  --toast-icon: #40e0d0;\r\n  --toast-border: rgba(0, 162, 255, 0.4);\r\n  --toast-shadow: rgba(0, 162, 255, 0.3);\r\n  --toast-glow: 0 0 8px rgba(0, 162, 255, 0.5);\r\n}\r\n\r\n/* 浅色主题变量 */\r\n.toast-container.light-mode {\r\n  --toast-bg: rgba(255, 255, 255, 0.95);\r\n  --toast-text: #1e293b;\r\n  --toast-icon: #14b8a6;\r\n  --toast-border: rgba(0, 0, 0, 0.12);\r\n  --toast-shadow: rgba(0, 0, 0, 0.1);\r\n  --toast-glow: 0 1px 2px rgba(0, 0, 0, 0.08);\r\n}\r\n\r\n.toast {\r\n  background: var(--toast-bg);\r\n  backdrop-filter: blur(16px);\r\n  border-radius: 12px;\r\n  border: 1px solid var(--toast-border);\r\n  padding: 16px 20px;\r\n  min-width: 280px;\r\n  max-width: 400px;\r\n  box-shadow: \r\n    0 8px 32px var(--toast-shadow),\r\n    0 0 0 1px var(--toast-border) inset;\r\n  transform: translateY(20px) scale(0.9);\r\n  opacity: 0;\r\n  transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);\r\n}\r\n\r\n.toast.show {\r\n  animation: toastSlideInUp 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94) forwards;\r\n}\r\n\r\n.toast.hide {\r\n  animation: toastFloatUp 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94) forwards;\r\n}\r\n\r\n.toast-content {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 12px;\r\n}\r\n\r\n.toast-icon {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  width: 24px;\r\n  height: 24px;\r\n  background: linear-gradient(135deg, var(--toast-icon), var(--toast-icon));\r\n  border-radius: 50%;\r\n  font-size: 14px;\r\n  font-weight: bold;\r\n  color: #ffffff;\r\n  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);\r\n  box-shadow: \r\n    0 2px 8px var(--toast-shadow),\r\n    0 0 0 1px var(--toast-border) inset;\r\n  flex-shrink: 0;\r\n}\r\n\r\n.toast-message {\r\n  color: var(--toast-text);\r\n  font-size: 14px;\r\n  font-weight: 500;\r\n  line-height: 1.4;\r\n  text-shadow: var(--toast-glow);\r\n  flex: 1;\r\n}\r\n\r\n/* 动画特效 */\r\n@keyframes toastSlideInUp {\r\n  from {\r\n    transform: translateY(20px) scale(0.9);\r\n    opacity: 0;\r\n  }\r\n  to {\r\n    transform: translateY(0) scale(1);\r\n    opacity: 1;\r\n  }\r\n}\r\n\r\n@keyframes toastFloatUp {\r\n  0% {\r\n    transform: translateY(0) scale(1);\r\n    opacity: 1;\r\n  }\r\n  100% {\r\n    transform: translateY(-40px) scale(0.95);\r\n    opacity: 0;\r\n  }\r\n}\r\n</style> "],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/TreeView.vue?vue&type=style&index=0&id=6721f28c&scoped=true&lang=css":
/*!******************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/TreeView.vue?vue&type=style&index=0&id=6721f28c&scoped=true&lang=css ***!
  \******************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
/* 图标定义 - 科技感符号 */
.icon-arrow[data-v-6721f28c]::before { content: '▶';
}
.icon-scene[data-v-6721f28c]::before { content: '⬢';
}
.icon-camera[data-v-6721f28c]::before { content: '◉';
}
.icon-folder[data-v-6721f28c]::before { content: '▩';
}
.icon-sprite[data-v-6721f28c]::before { content: '◈';
}
.icon-mesh[data-v-6721f28c]::before { content: '⬟';
}
.icon-node[data-v-6721f28c]::before { content: '⬡';
}
.icon-inspect[data-v-6721f28c]::before { content: '⚹';
}
.icon-delete[data-v-6721f28c]::before { content: '⨯';
}
.icon-expand-all[data-v-6721f28c]::before { content: '⬇';
}
.icon-collapse-all[data-v-6721f28c]::before { content: '➤';
}
.icon-search[data-v-6721f28c]::before { content: '🔍';
}
.icon-clear[data-v-6721f28c]::before { content: '⨯';
}
.icon-eye-open[data-v-6721f28c]::before { content: '👁';
}
.icon-eye-closed[data-v-6721f28c]::before { content: '🚫';
}
.tree-view[data-v-6721f28c] {
  position: relative;
  user-select: none;
  /* 深色主题变量 */
  --tree-text-primary: #f0f2f5;
  --tree-text-secondary: #b8c5d1;
  --tree-text-accent: #4dd4ff;
  --tree-accent-primary: #0aa2ff;
  --tree-accent-secondary: #40e0d0;
  --tree-bg-hover: linear-gradient(135deg, rgba(0, 162, 255, 0.08), rgba(64, 224, 208, 0.04));
  --tree-bg-selected: linear-gradient(135deg, rgba(0, 162, 255, 0.15), rgba(64, 224, 208, 0.1));
  --tree-bg-card: linear-gradient(135deg, rgba(15, 20, 25, 0.5), rgba(26, 31, 41, 0.3));
  --tree-bg-menu: linear-gradient(135deg, rgba(15, 20, 25, 0.95), rgba(26, 31, 41, 0.95));
  --tree-border-primary: rgba(0, 162, 255, 0.2);
  --tree-border-accent: rgba(0, 162, 255, 0.4);
  --tree-shadow-primary: rgba(0, 0, 0, 0.2);
  --tree-shadow-accent: rgba(0, 162, 255, 0.3);
  /* 深色模式光效 */
  --tree-text-glow: 0 0 8px rgba(0, 162, 255, 0.5);
  --tree-text-glow-accent: 0 0 4px rgba(0, 162, 255, 0.3);
  --tree-text-glow-secondary: 0 0 2px rgba(0, 162, 255, 0.3);
}

/* 浅色主题变量 */
.tree-view.light-mode[data-v-6721f28c] {
  --tree-text-primary: #1e293b;
  --tree-text-secondary: #475569;
  --tree-text-accent: #0369a1;
  --tree-accent-primary: #0ea5e9;
  --tree-accent-secondary: #14b8a6;
  /* 苹果风格背景 - 使用subtle灰色hover和选中效果 */
  --tree-bg-hover: linear-gradient(135deg, rgba(0, 0, 0, 0.04), rgba(0, 0, 0, 0.02));
  --tree-bg-selected: linear-gradient(135deg, rgba(0, 0, 0, 0.08), rgba(0, 0, 0, 0.05));
  --tree-bg-card: linear-gradient(135deg, rgba(255, 255, 255, 0.7), rgba(248, 250, 252, 0.5));
  --tree-bg-menu: linear-gradient(135deg, rgba(255, 255, 255, 0.95), rgba(248, 250, 252, 0.95));
  /* 苹果风格边框 - 使用subtle灰色 */
  --tree-border-primary: rgba(0, 0, 0, 0.08);
  --tree-border-accent: rgba(0, 0, 0, 0.12);
  /* 苹果风格阴影 */
  --tree-shadow-primary: rgba(0, 0, 0, 0.05);
  --tree-shadow-accent: rgba(0, 0, 0, 0.1);
  /* 浅色模式光效 - 苹果风格的subtle阴影 */
  --tree-text-glow: 0 1px 2px rgba(0, 0, 0, 0.05);
  --tree-text-glow-accent: 0 1px 1px rgba(0, 0, 0, 0.08);
  --tree-text-glow-secondary: 0 0.5px 1px rgba(0, 0, 0, 0.06);
}
.tree-node[data-v-6721f28c] {
  position: relative;
}
.node-item[data-v-6721f28c] {
  display: flex;
  align-items: center;
  padding: 4px 8px;
  margin: 1px 0;
  border-radius: 8px;
  cursor: pointer;
  transition: all 0.25s ease-out;
  position: relative;
  overflow: hidden;
  border: 1px solid transparent;
  backdrop-filter: blur(4px);
}
.node-item[data-v-6721f28c]::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: linear-gradient(135deg, var(--tree-accent-primary), var(--tree-accent-secondary));
  opacity: 0;
  transition: opacity 0.2s ease;
  z-index: -1;
}

/* 浅色模式下完全隐藏伪元素背景 */
.tree-view.light-mode .node-item[data-v-6721f28c]::before {
  display: none !important;
  content: none !important;
  background: transparent !important;
}
.node-item[data-v-6721f28c]:hover {
  background: var(--tree-bg-hover);
  transform: translateX(2px);
  box-shadow: 
    0 2px 8px var(--tree-shadow-accent),
    0 0 0 1px var(--tree-border-primary) inset;
  border: 1px solid var(--tree-border-primary);
}
.node-item[data-v-6721f28c]:hover::before {
  opacity: 0.05;
}

/* 浅色模式下hover不显示伪元素 */
.tree-view.light-mode .node-item[data-v-6721f28c]:hover::before {
  opacity: 0 !important;
  display: none !important;
}
.node-item.selected[data-v-6721f28c] {
  background: var(--tree-bg-selected);
  color: var(--tree-text-primary);
  font-weight: 600;
  box-shadow: 
    0 4px 16px var(--tree-shadow-accent),
    0 0 0 1px var(--tree-border-accent) inset;
  border: 1px solid var(--tree-border-accent);
  text-shadow: var(--tree-text-glow);
}
.node-item.selected[data-v-6721f28c]::before {
  opacity: 0.1;
}

/* 浅色模式下selected也不显示伪元素 */
.tree-view.light-mode .node-item.selected[data-v-6721f28c]::before {
  opacity: 0 !important;
  display: none !important;
}
.node-content[data-v-6721f28c] {
  display: flex;
  align-items: center;
  gap: 8px;
  flex: 1;
  min-width: 0;
}
.expand-btn[data-v-6721f28c] {
  width: 16px;
  height: 16px;
  border: none;
  background: var(--tree-bg-card);
  border-radius: 6px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 10px;
  color: var(--tree-text-accent);
  transition: all 0.2s ease-out;
  flex-shrink: 0;
  border: 1px solid var(--tree-border-primary);
  backdrop-filter: blur(4px);
  text-shadow: var(--tree-text-glow-accent);
}
.expand-btn[data-v-6721f28c]:hover {
  background: var(--tree-bg-selected);
  border-color: var(--tree-border-accent);
  box-shadow: 0 0 8px var(--tree-shadow-accent);
  transform: scale(1.1);
  color: var(--tree-text-primary);
}
.expand-btn.expanded[data-v-6721f28c] {
  transform: rotate(90deg);
}
.expand-btn.expanded[data-v-6721f28c]:hover {
  transform: rotate(90deg) scale(1.1);
}

/* 搜索自动展开的按钮样式 */
.expand-btn.search-auto-expanded[data-v-6721f28c] {
  background: linear-gradient(135deg, rgba(255, 193, 7, 0.3), rgba(255, 152, 0, 0.2));
  border-color: rgba(255, 193, 7, 0.4);
  color: #ffc107;
  transform: rotate(90deg);
  animation: searchPulse-6721f28c 2s ease-in-out infinite;
}
.expand-btn.search-auto-expanded[data-v-6721f28c]:hover {
  background: linear-gradient(135deg, rgba(255, 193, 7, 0.4), rgba(255, 152, 0, 0.3));
  border-color: rgba(255, 193, 7, 0.6);
  transform: rotate(90deg) scale(1.1);
}
@keyframes searchPulse-6721f28c {
0%, 100% {
    box-shadow: 0 0 4px rgba(255, 193, 7, 0.3);
}
50% {
    box-shadow: 0 0 8px rgba(255, 193, 7, 0.5);
}
}
.expand-spacer[data-v-6721f28c] {
  width: 16px;
  flex-shrink: 0;
}
.node-icon[data-v-6721f28c] {
  font-size: 14px;
  flex-shrink: 0;
  opacity: 0.9;
  color: var(--tree-text-secondary);
  filter: drop-shadow(var(--tree-text-glow-secondary));
  transition: all 0.2s ease-out;
}
.node-name[data-v-6721f28c] {
  font-size: 13px;
  color: var(--tree-text-primary);
  flex: 1;
  min-width: 0;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  font-weight: 500;
  text-shadow: var(--tree-text-glow-accent);
  transition: all 0.2s ease-out;
}
.node-type-tag[data-v-6721f28c] {
  font-size: 10px;
  color: var(--tree-text-secondary);
  background: var(--tree-bg-card);
  padding: 2px 6px;
  border-radius: 6px;
  flex-shrink: 0;
  opacity: 0;
  transition: all 0.2s ease-out;
  border: 1px solid var(--tree-border-primary);
  backdrop-filter: blur(4px);
  font-weight: 500;
  text-shadow: var(--tree-text-glow-secondary);
}
.node-item:hover .node-type-tag[data-v-6721f28c],
.node-item.selected .node-type-tag[data-v-6721f28c] {
  opacity: 1;
  color: var(--tree-accent-secondary);
  background: var(--tree-bg-selected);
  border-color: var(--tree-border-accent);
  text-shadow: var(--tree-text-glow-accent);
}
.node-item.selected .node-name[data-v-6721f28c] {
  color: var(--tree-text-primary);
  font-weight: 600;
  text-shadow: var(--tree-text-glow);
}
.node-item.selected .node-icon[data-v-6721f28c] {
  color: var(--tree-text-accent);
  filter: drop-shadow(var(--tree-text-glow-accent));
}

/* 状态按钮样式 */
.status-btn[data-v-6721f28c] {
  width: 20px;
  height: 20px;
  border: none;
  background: var(--tree-bg-card);
  border-radius: 6px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 12px;
  transition: all 0.2s ease-out;
  flex-shrink: 0;
  border: 1px solid var(--tree-border-primary);
  backdrop-filter: blur(4px);
  opacity: 0;
  transform: scale(0.8);
  pointer-events: none;
}

/* 在hover或选中时显示状态按钮 */
.node-item:hover .status-btn[data-v-6721f28c],
.node-item.selected .status-btn[data-v-6721f28c] {
  opacity: 1;
  transform: scale(1);
  pointer-events: auto;
}
.status-btn.status-active[data-v-6721f28c] {
  color: var(--tree-accent-secondary);
  background: var(--tree-bg-selected);
  border-color: var(--tree-border-accent);
  text-shadow: var(--tree-text-glow-accent);
}
.status-btn.status-inactive[data-v-6721f28c] {
  color: var(--tree-text-secondary);
  background: var(--tree-bg-hover);
  border-color: var(--tree-border-primary);
}
.node-item:hover .status-btn.status-inactive[data-v-6721f28c],
.node-item.selected .status-btn.status-inactive[data-v-6721f28c] {
  opacity: 0.7;
}
.status-btn[data-v-6721f28c]:hover {
  background: var(--tree-bg-selected);
  border-color: var(--tree-border-accent);
  box-shadow: 0 0 8px var(--tree-shadow-accent);
  transform: scale(1.1);
  color: var(--tree-text-primary);
}
.status-btn.status-inactive[data-v-6721f28c]:hover {
  color: var(--tree-accent-secondary);
}
.children-container[data-v-6721f28c] {
  margin-left: 20px;
  position: relative;
  /* 移除默认动画，避免刷新时的不必要动效 */
}
.children-container[data-v-6721f28c]::before {
  content: '';
  position: absolute;
  left: -12px;
  top: 0;
  bottom: 0;
  width: 2px;
  background: linear-gradient(to bottom, rgba(0, 162, 255, 0.15), rgba(64, 224, 208, 0.1), transparent);
  border-radius: 1px;
  box-shadow: 0 0 2px rgba(0, 162, 255, 0.15);
  transition: all 0.2s ease-out;
}

/* 搜索展开的容器特殊样式 */
.children-container.search-expanded[data-v-6721f28c]::before {
  background: linear-gradient(to bottom, rgba(255, 193, 7, 0.4), rgba(255, 152, 0, 0.3), transparent);
  box-shadow: 0 0 4px rgba(255, 193, 7, 0.3);
  width: 3px;
}
.children-container.search-expanded[data-v-6721f28c] {
  position: relative;
}
.children-container.search-expanded[data-v-6721f28c]::after {
  content: '🔍';
  position: absolute;
  left: -20px;
  top: 2px;
  font-size: 10px;
  opacity: 0.6;
  color: var(--tree-accent-secondary);
  filter: drop-shadow(var(--tree-text-glow-accent));
}

/* 浅色模式下使用subtle的连接线 */
.tree-view.light-mode .children-container[data-v-6721f28c]::before {
  background: linear-gradient(to bottom, rgba(0, 0, 0, 0.12), rgba(0, 0, 0, 0.08), transparent);
  box-shadow: none;
  width: 1px;
}

/* 用户手动展开时的动画 */
.children-container.manual-expand[data-v-6721f28c] {
  animation: expandDown-6721f28c 0.25s ease-out;
}
@keyframes expandDown-6721f28c {
from {
    opacity: 0;
    transform: translateY(-2px);
    max-height: 0;
}
to {
    opacity: 1;
    transform: translateY(0);
    max-height: 500px;
}
}

/* 右键菜单 */
.context-menu[data-v-6721f28c] {
  position: fixed;
  background: var(--tree-bg-menu);
  backdrop-filter: blur(24px);
  border: 1px solid var(--tree-border-accent);
  border-radius: 12px;
  box-shadow: 
    0 16px 64px var(--tree-shadow-primary),
    0 0 0 1px var(--tree-border-primary) inset;
  padding: 6px;
  z-index: 1000;
  min-width: 180px;
  animation: contextMenuShow-6721f28c 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}
@keyframes contextMenuShow-6721f28c {
from {
    opacity: 0;
    transform: scale(0.95) translateY(-5px);
}
to {
    opacity: 1;
    transform: scale(1) translateY(0);
}
}
.menu-item[data-v-6721f28c] {
  display: flex;
  align-items: center;
  gap: 8px;
  padding: 8px 12px;
  border-radius: 8px;
  cursor: pointer;
  font-size: 12px;
  color: var(--tree-text-secondary);
  transition: all 0.2s ease-out;
  font-weight: 500;
  border: 1px solid transparent;
}
.menu-item[data-v-6721f28c]:hover {
  background: var(--tree-bg-hover);
  color: var(--tree-text-primary);
  border: 1px solid var(--tree-border-primary);
  box-shadow: 0 0 8px var(--tree-shadow-accent);
  text-shadow: var(--tree-text-glow-accent);
}
.menu-item i[data-v-6721f28c] {
  font-size: 12px;
  opacity: 0.8;
  color: var(--tree-text-secondary);
  filter: drop-shadow(var(--tree-text-glow-secondary));
  transition: all 0.2s ease-out;
}
.menu-separator[data-v-6721f28c] {
  height: 1px;
  background: linear-gradient(90deg, transparent, var(--tree-border-accent), transparent);
  margin: 4px 8px;
  box-shadow: 0 0 2px var(--tree-shadow-accent);
}

/* 浅色模式下使用subtle的菜单分隔线 */
.tree-view.light-mode .menu-separator[data-v-6721f28c] {
  background: linear-gradient(90deg, transparent, rgba(0, 0, 0, 0.1), transparent);
  box-shadow: none;
}

/* 响应式设计 */
@media (max-width: 768px) {
.children-container[data-v-6721f28c] {
    margin-left: 16px;
}
.node-name[data-v-6721f28c] {
    font-size: 12px;
}
.node-type-tag[data-v-6721f28c] {
    display: none;
}
}

/* 搜索容器样式 */
.search-container[data-v-6721f28c] {
  padding: 8px 8px 8px 8px;
  margin: -8px -8px 0 -8px;
  border-bottom: 1px solid var(--tree-border-primary);
  background: var(--tree-bg-card);
  backdrop-filter: blur(8px);
  position: sticky;
  top: -8px;
  z-index: 10;
}
.search-container[data-v-6721f28c]::before {
  content: '';
  position: absolute;
  top: -8px;
  left: 0;
  right: 0;
  height: 8px;
  background: var(--tree-bg-card);
  backdrop-filter: blur(8px);
  z-index: -1;
}
.search-input-wrapper[data-v-6721f28c] {
  position: relative;
  display: flex;
  align-items: center;
}
.search-input[data-v-6721f28c] {
  width: 100%;
  height: 32px;
  padding: 6px 12px 6px 32px;
  border: 1px solid var(--tree-border-primary);
  border-radius: 16px;
  background: var(--tree-bg-card);
  backdrop-filter: blur(4px);
  color: var(--tree-text-primary);
  font-size: 12px;
  font-weight: 400;
  transition: all 0.25s ease-out;
  outline: none;
  box-shadow: 0 2px 8px var(--tree-shadow-primary);
}
.search-input[data-v-6721f28c]::placeholder {
  color: var(--tree-text-secondary);
  opacity: 0.8;
}
.search-input[data-v-6721f28c]:focus {
  border-color: var(--tree-border-accent);
  background: var(--tree-bg-selected);
  box-shadow: 
    0 4px 16px var(--tree-shadow-accent),
    0 0 0 1px var(--tree-border-accent) inset;
  color: var(--tree-text-primary);
  text-shadow: var(--tree-text-glow-accent);
}
.search-icon[data-v-6721f28c] {
  position: absolute;
  left: 10px;
  font-size: 12px;
  color: var(--tree-text-secondary);
  pointer-events: none;
  z-index: 1;
  filter: drop-shadow(var(--tree-text-glow-secondary));
}
.clear-search-btn[data-v-6721f28c] {
  position: absolute;
  right: 8px;
  width: 20px;
  height: 20px;
  border: none;
  background: var(--tree-bg-hover);
  border-radius: 50%;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 10px;
  color: var(--tree-text-secondary);
  transition: all 0.2s ease-out;
  opacity: 0.7;
}
.clear-search-btn[data-v-6721f28c]:hover {
  background: var(--tree-bg-selected);
  color: var(--tree-text-primary);
  opacity: 1;
  transform: scale(1.1);
  box-shadow: 0 0 8px var(--tree-shadow-accent);
}

/* 搜索匹配高亮 */
.node-item.search-match[data-v-6721f28c] {
  background: var(--tree-bg-hover);
  box-shadow: 
    0 2px 8px var(--tree-shadow-accent),
    0 0 0 1px var(--tree-border-primary) inset;
}
.search-highlight[data-v-6721f28c] {
  background: linear-gradient(135deg, var(--tree-accent-primary), var(--tree-accent-secondary));
  color: #ffffff;
  padding: 1px 3px;
  border-radius: 3px;
  font-weight: 600;
  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
  box-shadow: 0 0 4px var(--tree-shadow-accent);
}

/* 浅色模式下的搜索高亮 */
.tree-view.light-mode .search-highlight[data-v-6721f28c] {
  background: linear-gradient(135deg, var(--tree-accent-primary), var(--tree-accent-secondary));
  color: #ffffff;
  box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
}
`, "",{"version":3,"sources":["webpack://./src/devtools/components/TreeView.vue"],"names":[],"mappings":";AAgmBA,iBAAiB;AACjB,uCAAsB,YAAY;AAAE;AACpC,uCAAsB,YAAY;AAAE;AACpC,wCAAuB,YAAY;AAAE;AACrC,wCAAuB,YAAY;AAAE;AACrC,wCAAuB,YAAY;AAAE;AACrC,sCAAqB,YAAY;AAAE;AACnC,sCAAqB,YAAY;AAAE;AACnC,yCAAwB,YAAY;AAAE;AACtC,wCAAuB,YAAY;AAAE;AACrC,4CAA2B,YAAY;AAAE;AACzC,8CAA6B,YAAY;AAAE;AAC3C,wCAAuB,aAAa;AAAE;AACtC,uCAAsB,YAAY;AAAE;AACpC,0CAAyB,aAAa;AAAE;AACxC,4CAA2B,aAAa;AAAE;AAE1C;EACE,kBAAkB;EAClB,iBAAiB;EACjB,WAAW;EACX,4BAA4B;EAC5B,8BAA8B;EAC9B,2BAA2B;EAC3B,8BAA8B;EAC9B,gCAAgC;EAChC,2FAA2F;EAC3F,6FAA6F;EAC7F,qFAAqF;EACrF,uFAAuF;EACvF,6CAA6C;EAC7C,4CAA4C;EAC5C,yCAAyC;EACzC,4CAA4C;EAC5C,WAAW;EACX,gDAAgD;EAChD,uDAAuD;EACvD,0DAA0D;AAC5D;;AAEA,WAAW;AACX;EACE,4BAA4B;EAC5B,8BAA8B;EAC9B,2BAA2B;EAC3B,8BAA8B;EAC9B,gCAAgC;EAChC,kCAAkC;EAClC,kFAAkF;EAClF,qFAAqF;EACrF,2FAA2F;EAC3F,6FAA6F;EAC7F,wBAAwB;EACxB,0CAA0C;EAC1C,yCAAyC;EACzC,WAAW;EACX,0CAA0C;EAC1C,wCAAwC;EACxC,2BAA2B;EAC3B,+CAA+C;EAC/C,sDAAsD;EACtD,2DAA2D;AAC7D;AAEA;EACE,kBAAkB;AACpB;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,gBAAgB;EAChB,aAAa;EACb,kBAAkB;EAClB,eAAe;EACf,8BAA8B;EAC9B,kBAAkB;EAClB,gBAAgB;EAChB,6BAA6B;EAC7B,0BAA0B;AAC5B;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,MAAM;EACN,OAAO;EACP,QAAQ;EACR,SAAS;EACT,6FAA6F;EAC7F,UAAU;EACV,6BAA6B;EAC7B,WAAW;AACb;;AAEA,mBAAmB;AACnB;EACE,wBAAwB;EACxB,wBAAwB;EACxB,kCAAkC;AACpC;AAEA;EACE,gCAAgC;EAChC,0BAA0B;EAC1B;;8CAE4C;EAC5C,4CAA4C;AAC9C;AAEA;EACE,aAAa;AACf;;AAEA,qBAAqB;AACrB;EACE,qBAAqB;EACrB,wBAAwB;AAC1B;AAEA;EACE,mCAAmC;EACnC,+BAA+B;EAC/B,gBAAgB;EAChB;;6CAE2C;EAC3C,2CAA2C;EAC3C,kCAAkC;AACpC;AAEA;EACE,YAAY;AACd;;AAEA,yBAAyB;AACzB;EACE,qBAAqB;EACrB,wBAAwB;AAC1B;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,OAAO;EACP,YAAY;AACd;AAEA;EACE,WAAW;EACX,YAAY;EACZ,YAAY;EACZ,+BAA+B;EAC/B,kBAAkB;EAClB,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,eAAe;EACf,8BAA8B;EAC9B,6BAA6B;EAC7B,cAAc;EACd,4CAA4C;EAC5C,0BAA0B;EAC1B,yCAAyC;AAC3C;AAEA;EACE,mCAAmC;EACnC,uCAAuC;EACvC,6CAA6C;EAC7C,qBAAqB;EACrB,+BAA+B;AACjC;AAEA;EACE,wBAAwB;AAC1B;AAEA;EACE,mCAAmC;AACrC;;AAEA,gBAAgB;AAChB;EACE,mFAAmF;EACnF,oCAAoC;EACpC,cAAc;EACd,wBAAwB;EACxB,uDAA8C;AAChD;AAEA;EACE,mFAAmF;EACnF,oCAAoC;EACpC,mCAAmC;AACrC;AAEA;AACE;IACE,0CAA0C;AAC5C;AACA;IACE,0CAA0C;AAC5C;AACF;AAEA;EACE,WAAW;EACX,cAAc;AAChB;AAEA;EACE,eAAe;EACf,cAAc;EACd,YAAY;EACZ,iCAAiC;EACjC,oDAAoD;EACpD,6BAA6B;AAC/B;AAEA;EACE,eAAe;EACf,+BAA+B;EAC/B,OAAO;EACP,YAAY;EACZ,gBAAgB;EAChB,uBAAuB;EACvB,mBAAmB;EACnB,gBAAgB;EAChB,yCAAyC;EACzC,6BAA6B;AAC/B;AAEA;EACE,eAAe;EACf,iCAAiC;EACjC,+BAA+B;EAC/B,gBAAgB;EAChB,kBAAkB;EAClB,cAAc;EACd,UAAU;EACV,6BAA6B;EAC7B,4CAA4C;EAC5C,0BAA0B;EAC1B,gBAAgB;EAChB,4CAA4C;AAC9C;AAEA;;EAEE,UAAU;EACV,mCAAmC;EACnC,mCAAmC;EACnC,uCAAuC;EACvC,yCAAyC;AAC3C;AAEA;EACE,+BAA+B;EAC/B,gBAAgB;EAChB,kCAAkC;AACpC;AAEA;EACE,8BAA8B;EAC9B,iDAAiD;AACnD;;AAEA,WAAW;AACX;EACE,WAAW;EACX,YAAY;EACZ,YAAY;EACZ,+BAA+B;EAC/B,kBAAkB;EAClB,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,eAAe;EACf,6BAA6B;EAC7B,cAAc;EACd,4CAA4C;EAC5C,0BAA0B;EAC1B,UAAU;EACV,qBAAqB;EACrB,oBAAoB;AACtB;;AAEA,qBAAqB;AACrB;;EAEE,UAAU;EACV,mBAAmB;EACnB,oBAAoB;AACtB;AAEA;EACE,mCAAmC;EACnC,mCAAmC;EACnC,uCAAuC;EACvC,yCAAyC;AAC3C;AAEA;EACE,iCAAiC;EACjC,gCAAgC;EAChC,wCAAwC;AAC1C;AAEA;;EAEE,YAAY;AACd;AAEA;EACE,mCAAmC;EACnC,uCAAuC;EACvC,6CAA6C;EAC7C,qBAAqB;EACrB,+BAA+B;AACjC;AAEA;EACE,mCAAmC;AACrC;AAEA;EACE,iBAAiB;EACjB,kBAAkB;EAClB,uBAAuB;AACzB;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,WAAW;EACX,MAAM;EACN,SAAS;EACT,UAAU;EACV,qGAAqG;EACrG,kBAAkB;EAClB,2CAA2C;EAC3C,6BAA6B;AAC/B;;AAEA,gBAAgB;AAChB;EACE,mGAAmG;EACnG,0CAA0C;EAC1C,UAAU;AACZ;AAEA;EACE,kBAAkB;AACpB;AAEA;EACE,aAAa;EACb,kBAAkB;EAClB,WAAW;EACX,QAAQ;EACR,eAAe;EACf,YAAY;EACZ,mCAAmC;EACnC,iDAAiD;AACnD;;AAEA,sBAAsB;AACtB;EACE,6FAA6F;EAC7F,gBAAgB;EAChB,UAAU;AACZ;;AAEA,eAAe;AACf;EACE,6CAAoC;AACtC;AAEA;AACE;IACE,UAAU;IACV,2BAA2B;IAC3B,aAAa;AACf;AACA;IACE,UAAU;IACV,wBAAwB;IACxB,iBAAiB;AACnB;AACF;;AAEA,SAAS;AACT;EACE,eAAe;EACf,+BAA+B;EAC/B,2BAA2B;EAC3B,2CAA2C;EAC3C,mBAAmB;EACnB;;8CAE4C;EAC5C,YAAY;EACZ,aAAa;EACb,gBAAgB;EAChB,qEAA4D;AAC9D;AAEA;AACE;IACE,UAAU;IACV,uCAAuC;AACzC;AACA;IACE,UAAU;IACV,iCAAiC;AACnC;AACF;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,iBAAiB;EACjB,kBAAkB;EAClB,eAAe;EACf,eAAe;EACf,iCAAiC;EACjC,6BAA6B;EAC7B,gBAAgB;EAChB,6BAA6B;AAC/B;AAEA;EACE,gCAAgC;EAChC,+BAA+B;EAC/B,4CAA4C;EAC5C,6CAA6C;EAC7C,yCAAyC;AAC3C;AAEA;EACE,eAAe;EACf,YAAY;EACZ,iCAAiC;EACjC,oDAAoD;EACpD,6BAA6B;AAC/B;AAEA;EACE,WAAW;EACX,uFAAuF;EACvF,eAAe;EACf,6CAA6C;AAC/C;;AAEA,wBAAwB;AACxB;EACE,gFAAgF;EAChF,gBAAgB;AAClB;;AAEA,UAAU;AACV;AACE;IACE,iBAAiB;AACnB;AAEA;IACE,eAAe;AACjB;AAEA;IACE,aAAa;AACf;AACF;;AAEA,WAAW;AACX;EACE,wBAAwB;EACxB,wBAAwB;EACxB,mDAAmD;EACnD,+BAA+B;EAC/B,0BAA0B;EAC1B,gBAAgB;EAChB,SAAS;EACT,WAAW;AACb;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,SAAS;EACT,OAAO;EACP,QAAQ;EACR,WAAW;EACX,+BAA+B;EAC/B,0BAA0B;EAC1B,WAAW;AACb;AAEA;EACE,kBAAkB;EAClB,aAAa;EACb,mBAAmB;AACrB;AAEA;EACE,WAAW;EACX,YAAY;EACZ,0BAA0B;EAC1B,4CAA4C;EAC5C,mBAAmB;EACnB,+BAA+B;EAC/B,0BAA0B;EAC1B,+BAA+B;EAC/B,eAAe;EACf,gBAAgB;EAChB,8BAA8B;EAC9B,aAAa;EACb,gDAAgD;AAClD;AAEA;EACE,iCAAiC;EACjC,YAAY;AACd;AAEA;EACE,uCAAuC;EACvC,mCAAmC;EACnC;;6CAE2C;EAC3C,+BAA+B;EAC/B,yCAAyC;AAC3C;AAEA;EACE,kBAAkB;EAClB,UAAU;EACV,eAAe;EACf,iCAAiC;EACjC,oBAAoB;EACpB,UAAU;EACV,oDAAoD;AACtD;AAEA;EACE,kBAAkB;EAClB,UAAU;EACV,WAAW;EACX,YAAY;EACZ,YAAY;EACZ,gCAAgC;EAChC,kBAAkB;EAClB,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,eAAe;EACf,iCAAiC;EACjC,6BAA6B;EAC7B,YAAY;AACd;AAEA;EACE,mCAAmC;EACnC,+BAA+B;EAC/B,UAAU;EACV,qBAAqB;EACrB,6CAA6C;AAC/C;;AAEA,WAAW;AACX;EACE,gCAAgC;EAChC;;8CAE4C;AAC9C;AAEA;EACE,6FAA6F;EAC7F,cAAc;EACd,gBAAgB;EAChB,kBAAkB;EAClB,gBAAgB;EAChB,yCAAyC;EACzC,6CAA6C;AAC/C;;AAEA,eAAe;AACf;EACE,6FAA6F;EAC7F,cAAc;EACd,wCAAwC;AAC1C","sourcesContent":["<template>\r\n  <div :class=\"['tree-view', { 'light-mode': !isDarkMode }]\">\r\n    <!-- 搜索过滤输入框 - 只在顶层显示 -->\r\n    <div v-if=\"showSearch\" class=\"search-container\">\r\n      <div class=\"search-input-wrapper\">\r\n        <i class=\"icon-search search-icon\"></i>\r\n        <input\r\n          v-model=\"searchKeyword\"\r\n          type=\"text\"\r\n          class=\"search-input\"\r\n          placeholder=\"输入关键字进行过滤\"\r\n          @input=\"onSearchInput\"\r\n        />\r\n        <button\r\n          v-if=\"searchKeyword\"\r\n          class=\"clear-search-btn\"\r\n          @click=\"clearSearch\"\r\n          title=\"清除搜索\"\r\n        >\r\n          <i class=\"icon-clear\"></i>\r\n        </button>\r\n      </div>\r\n    </div>\r\n\r\n    <!-- 节点树 -->\r\n    <div v-for=\"node in filteredNodes\" :key=\"getNodeKey(node)\" class=\"tree-node\" :data-node-id=\"node.id\">\r\n      <div \r\n        :class=\"['node-item', { \r\n          'selected': props.selectedNodeId === node.id,\r\n          'has-children': node.children && node.children.length > 0,\r\n          'search-match': node.isSearchMatch\r\n        }]\"\r\n        @click=\"handleNodeClick(node)\"\r\n        @dblclick=\"handleNodeDoubleClick(node)\"\r\n        @contextmenu.prevent=\"showContextMenu(node, $event)\"\r\n      >\r\n        <div class=\"node-content\">\r\n          <!-- 展开/折叠按钮 -->\r\n          <button \r\n            v-if=\"node.children && node.children.length > 0\"\r\n            :class=\"['expand-btn', { \r\n              'expanded': node.expanded,\r\n              'search-auto-expanded': shouldShowChildrenForSearch(node) && !node.expanded\r\n            }]\"\r\n            @click.stop=\"toggleExpand(node)\"\r\n            :title=\"shouldShowChildrenForSearch(node) && !node.expanded ? '因搜索自动展开' : ''\"\r\n          >\r\n            <i class=\"icon-arrow\"></i>\r\n          </button>\r\n          <div v-else class=\"expand-spacer\"></div>\r\n          \r\n          <!-- 节点图标 -->\r\n          <i :class=\"getNodeIcon(node.type)\" class=\"node-icon\"></i>\r\n          \r\n          <!-- 节点名称 -->\r\n          <span class=\"node-name\" v-html=\"highlightSearchText(node.name)\"></span>\r\n          \r\n          <!-- 状态按钮 (小眼睛) - 在hover或选中时显示 -->\r\n          <button \r\n            v-if=\"shouldShowStatusButton(node)\"\r\n            :class=\"['status-btn', { \r\n              'status-active': getNodeStatus(node),\r\n              'status-inactive': !getNodeStatus(node)\r\n            }]\"\r\n            @click.stop=\"toggleNodeStatus(node)\"\r\n            :title=\"getStatusButtonTitle(node)\"\r\n          >\r\n            <i :class=\"getStatusIcon(node)\"></i>\r\n          </button>\r\n          \r\n          <!-- 节点类型标签 -->\r\n          <span class=\"node-type-tag\">{{ node.type }}</span>\r\n        </div>\r\n      </div>\r\n      \r\n      <!-- 子节点 -->\r\n      <div v-if=\"node.children && (node.expanded || shouldShowChildrenForSearch(node))\" \r\n           :class=\"['children-container', { 'search-expanded': shouldShowChildrenForSearch(node) && !node.expanded }]\">\r\n        <TreeView \r\n          :nodes=\"node.children\" \r\n          :selected-node-id=\"props.selectedNodeId\"\r\n          :is-dark-mode=\"isDarkMode\"\r\n          :search-keyword=\"searchKeyword\"\r\n          :show-search=\"false\"\r\n          @node-select=\"onChildNodeSelect\"\r\n          @status-toggle=\"onChildStatusToggle\"\r\n          @node-delete=\"onChildNodeDelete\"\r\n        />\r\n      </div>\r\n    </div>\r\n    \r\n    <!-- 右键菜单 -->\r\n    <div \r\n      v-if=\"contextMenu.visible\" \r\n      :style=\"{ left: contextMenu.x + 'px', top: contextMenu.y + 'px' }\"\r\n      class=\"context-menu\"\r\n      @click.stop\r\n    >\r\n      <div class=\"menu-item\" @click=\"inspectNode\">\r\n        <i class=\"icon-inspect\"></i>\r\n        <span>跳转定义</span>\r\n      </div>\r\n      <div class=\"menu-item\" @click=\"deleteNode\">\r\n        <i class=\"icon-delete\"></i>\r\n        <span>删除节点</span>\r\n      </div>\r\n      <div class=\"menu-separator\"></div>\r\n      <div class=\"menu-item\" @click=\"expandChildren\">\r\n        <i class=\"icon-expand-all\"></i>\r\n        <span>展开所有子节点</span>\r\n      </div>\r\n      <div class=\"menu-item\" @click=\"collapseChildren\">\r\n        <i class=\"icon-collapse-all\"></i>\r\n        <span>折叠所有子节点</span>\r\n      </div>\r\n    </div>\r\n  </div>\r\n</template>\r\n\r\n<script setup lang=\"ts\">\r\nimport { ref, reactive, computed, watch, onMounted, onUnmounted } from 'vue';\r\nimport type { TreeNode, PropertyComponent, PropertyItem } from '../types/panel.types';\r\n\r\n// Props\r\ninterface Props {\r\n  nodes: TreeNode[];\r\n  selectedNodeId?: string;\r\n  isDarkMode?: boolean;\r\n  searchKeyword?: string; // 从父组件传递的搜索关键字\r\n  showSearch?: boolean; // 是否显示搜索输入框\r\n}\r\n\r\nconst props = withDefaults(defineProps<Props>(), {\r\n  selectedNodeId: '',\r\n  isDarkMode: true,\r\n  searchKeyword: '',\r\n  showSearch: true\r\n});\r\n\r\n// Emits\r\nconst emit = defineEmits<{\r\n  nodeSelect: [node: TreeNode];\r\n  statusToggle: [node: TreeNode, statusType: 'active' | 'visible', newValue: boolean];\r\n  nodeDelete: [node: TreeNode];\r\n}>();\r\n\r\n// 响应式数据\r\nconst searchKeyword = ref(props.searchKeyword || '');\r\nconst contextMenu = reactive({\r\n  visible: false,\r\n  x: 0,\r\n  y: 0,\r\n  node: null as TreeNode | null\r\n});\r\n\r\n// 监听外部传入的搜索关键字\r\nwatch(() => props.searchKeyword, (newKeyword) => {\r\n  searchKeyword.value = newKeyword || '';\r\n});\r\n\r\n// 监听隐藏所有右键菜单的自定义事件\r\nconst handleHideAllMenus = () => {\r\n  hideContextMenu();\r\n};\r\n\r\nonMounted(() => {\r\n  document.addEventListener('hide-all-context-menus', handleHideAllMenus);\r\n});\r\n\r\nonUnmounted(() => {\r\n  document.removeEventListener('hide-all-context-menus', handleHideAllMenus);\r\n});\r\n\r\n// 递归过滤节点\r\nconst filterNodes = (nodes: TreeNode[], keyword: string): TreeNode[] => {\r\n  if (!keyword.trim()) {\r\n    // 无搜索时，确保搜索相关属性为false，但不创建拷贝\r\n    const ensureSearchProps = (nodeList: TreeNode[]) => {\r\n      nodeList.forEach(node => {\r\n        node.isSearchMatch = false;\r\n        node.hasMatchingChildren = false;\r\n        if (node.children) {\r\n          ensureSearchProps(node.children);\r\n        }\r\n      });\r\n    };\r\n    ensureSearchProps(nodes);\r\n    return nodes;\r\n  }\r\n\r\n  const filtered: TreeNode[] = [];\r\n  \r\n  for (const node of nodes) {\r\n    const nodeClone = { ...node };\r\n    const nameMatch = node.name.toLowerCase().includes(keyword.toLowerCase());\r\n    const typeMatch = node.type.toLowerCase().includes(keyword.toLowerCase());\r\n    const isMatch = nameMatch || typeMatch;\r\n    \r\n    // 递归处理子节点\r\n    let filteredChildren: TreeNode[] = [];\r\n    if (node.children) {\r\n      filteredChildren = filterNodes(node.children, keyword);\r\n    }\r\n    \r\n    const hasMatchingChildren = filteredChildren.length > 0;\r\n    \r\n    // 如果当前节点匹配或有匹配的子节点，则包含此节点\r\n    if (isMatch || hasMatchingChildren) {\r\n      nodeClone.isSearchMatch = isMatch;\r\n      nodeClone.hasMatchingChildren = hasMatchingChildren;\r\n      nodeClone.children = filteredChildren;\r\n      \r\n      // 保持原始节点的展开状态，不强制展开\r\n      // nodeClone.expanded 已经从原始节点拷贝而来\r\n      \r\n      filtered.push(nodeClone);\r\n    }\r\n  }\r\n  \r\n  return filtered;\r\n};\r\n\r\n// 为节点生成稳定的key\r\nconst getNodeKey = (node: TreeNode): string => {\r\n  // 优先使用exId，如果没有则使用id，确保key的稳定性\r\n  return node.exId !== undefined ? `ex-${node.exId}` : `id-${node.id}`;\r\n};\r\n\r\n// 计算过滤后的节点\r\nconst filteredNodes = computed(() => {\r\n  // 确保使用最新的原始节点数据\r\n  return filterNodes(props.nodes, searchKeyword.value);\r\n});\r\n\r\n// 高亮搜索文本\r\nconst highlightSearchText = (text: string): string => {\r\n  if (!searchKeyword.value.trim()) {\r\n    return text;\r\n  }\r\n  \r\n  const keyword = searchKeyword.value.trim();\r\n  const regex = new RegExp(`(${keyword})`, 'gi');\r\n  return text.replace(regex, '<mark class=\"search-highlight\">$1</mark>');\r\n};\r\n\r\n// 搜索输入处理\r\nconst onSearchInput = () => {\r\n  // 搜索时延迟执行，避免频繁过滤\r\n  // 实际过滤逻辑由 computed 自动处理\r\n};\r\n\r\n// 找到节点在原始树中的路径并展开\r\nconst expandPathToNode = (nodes: TreeNode[], targetNodeId: string, path: TreeNode[] = []): boolean => {\r\n  for (const node of nodes) {\r\n    const currentPath = [...path, node];\r\n    \r\n    if (node.id === targetNodeId) {\r\n      // 找到目标节点，展开路径上的所有父节点\r\n      currentPath.forEach((pathNode, index) => {\r\n        if (index < currentPath.length - 1) { // 不包括目标节点本身\r\n          pathNode.expanded = true;\r\n        }\r\n      });\r\n      return true;\r\n    }\r\n    \r\n    if (node.children && node.children.length > 0) {\r\n      if (expandPathToNode(node.children, targetNodeId, currentPath)) {\r\n        return true;\r\n      }\r\n    }\r\n  }\r\n  return false;\r\n};\r\n\r\n// 清除搜索\r\nconst clearSearch = () => {\r\n  // 如果有选中的节点，在清除搜索前先确保其路径展开\r\n  if (props.selectedNodeId) {\r\n    expandPathToNode(props.nodes, props.selectedNodeId);\r\n  }\r\n  \r\n  searchKeyword.value = '';\r\n};\r\n\r\n// 方法\r\nconst selectNode = (node: TreeNode) => {\r\n  emit('nodeSelect', node);\r\n  hideContextMenu();\r\n};\r\n\r\nconst handleNodeClick = (node: TreeNode) => {\r\n  // 选择节点\r\n  selectNode(node);\r\n  \r\n  // 如果节点有子节点，则切换展开/收起状态\r\n  if (node.children && node.children.length > 0) {\r\n    toggleNodeExpanded(node);\r\n  }\r\n};\r\n\r\nconst handleNodeDoubleClick = (node: TreeNode) => {\r\n  // 双击时不做任何特殊处理，防止与单击冲突\r\n  // 只确保节点被选中\r\n  selectNode(node);\r\n};\r\n\r\nconst onChildNodeSelect = (node: TreeNode) => {\r\n  // 直接向上传递事件，让父组件统一管理选中状态\r\n  emit('nodeSelect', node);\r\n};\r\n\r\nconst onChildStatusToggle = (node: TreeNode, statusType: 'active' | 'visible', newValue: boolean) => {\r\n  // 向上传递状态切换事件\r\n  emit('statusToggle', node, statusType, newValue);\r\n};\r\n\r\nconst onChildNodeDelete = (node: TreeNode) => {\r\n  // 向上传递删除事件\r\n  emit('nodeDelete', node);\r\n};\r\n\r\n// 直接切换节点的展开状态（和右键菜单使用相同的简单方式）\r\nconst toggleNodeExpanded = (node: TreeNode) => {\r\n  node.expanded = !node.expanded;\r\n  \r\n  // 如果是展开操作，为子容器添加展开动画类\r\n  if (node.expanded) {\r\n    setTimeout(() => {\r\n      const childrenContainer = document.querySelector(`[data-node-id=\"${node.id}\"] .children-container`);\r\n      if (childrenContainer) {\r\n        childrenContainer.classList.add('manual-expand');\r\n        setTimeout(() => {\r\n          childrenContainer.classList.remove('manual-expand');\r\n        }, 250);\r\n      }\r\n    }, 10);\r\n  }\r\n};\r\n\r\nconst toggleExpand = (node: TreeNode) => {\r\n  // 展开按钮点击时，使用同样的逻辑\r\n  toggleNodeExpanded(node);\r\n};\r\n\r\nconst getNodeIcon = (type: string) => {\r\n  const iconMap: Record<string, string> = {\r\n    'Scene3D': 'icon-scene',\r\n    'Camera': 'icon-camera',\r\n    'Container': 'icon-folder',\r\n    'Sprite3D': 'icon-sprite',\r\n    'MeshSprite3D': 'icon-mesh'\r\n  };\r\n  return iconMap[type] || 'icon-node';\r\n};\r\n\r\nconst showContextMenu = (node: TreeNode, event: MouseEvent) => {\r\n  // 阻止事件冒泡，防止触发父组件的右键菜单\r\n  event.stopPropagation();\r\n  \r\n  // 先隐藏所有可能存在的其他菜单\r\n  hideAllContextMenus();\r\n  \r\n  contextMenu.visible = true;\r\n  contextMenu.node = node;\r\n  \r\n  // 获取菜单的预计宽高（根据实际情况调整）\r\n  const menuWidth = 200; // 预估菜单宽度\r\n  const menuHeight = 280; // 预估菜单高度\r\n  \r\n  // 获取视窗宽高\r\n  const viewportWidth = window.innerWidth;\r\n  const viewportHeight = window.innerHeight;\r\n  \r\n  // 计算菜单位置，确保不超出屏幕\r\n  let x = event.clientX;\r\n  let y = event.clientY;\r\n  \r\n  // 检查右边界\r\n  if (x + menuWidth > viewportWidth) {\r\n    x = viewportWidth - menuWidth - 5; // 留出5px边距\r\n  }\r\n  \r\n  // 检查下边界\r\n  if (y + menuHeight > viewportHeight) {\r\n    y = viewportHeight - menuHeight - 5; // 留出5px边距\r\n  }\r\n  \r\n  // 确保不会出现在屏幕外（左上角）\r\n  x = Math.max(5, x);\r\n  y = Math.max(5, y);\r\n  \r\n  // 设置最终位置\r\n  contextMenu.x = x;\r\n  contextMenu.y = y;\r\n  \r\n  // 点击其他地方隐藏菜单\r\n  document.addEventListener('click', hideContextMenu, { once: true });\r\n};\r\n\r\n// 隐藏页面上所有的右键菜单\r\nconst hideAllContextMenus = () => {\r\n  // 使用自定义事件通知所有TreeView组件隐藏它们的右键菜单\r\n  const event = new CustomEvent('hide-all-context-menus');\r\n  document.dispatchEvent(event);\r\n  \r\n  // 隐藏当前组件的右键菜单\r\n  hideContextMenu();\r\n};\r\n\r\nconst hideContextMenu = () => {\r\n  contextMenu.visible = false;\r\n  contextMenu.node = null;\r\n};\r\n\r\nconst inspectNode = () => {\r\n  if (contextMenu.node) {\r\n    const node = contextMenu.node;\r\n    try {\r\n      // 在被检查页面的上下文中执行代码来跳转到构造函数\r\n      const inspectCode = `\r\n        (function() {\r\n          // 通过 getNodeMemoryStroge 查找节点\r\n          if (typeof window.getNodeMemoryStroge === 'function') {\r\n            try {\r\n              const targetNode = window.getNodeMemoryStroge(${node.exId});\r\n              if (targetNode) {\r\n                console.log('找到节点对象:', targetNode);\r\n                inspect(targetNode.constructor);\r\n                return true;\r\n              } else {\r\n                console.warn('getNodeMemoryStroge 未找到节点，exId:', ${node.exId});\r\n                return false;\r\n              }\r\n            } catch (error) {\r\n              console.error('getNodeMemoryStroge 调用失败:', error);\r\n              return false;\r\n            }\r\n          } else {\r\n            console.error('getNodeMemoryStroge 函数不存在');\r\n            return false;\r\n          }\r\n        })();\r\n      `;\r\n      \r\n      (chrome as any).devtools.inspectedWindow.eval(\r\n        inspectCode,\r\n        (result: any, isException: boolean) => {\r\n          if (isException) {\r\n            console.error('跳转定义失败:', result);\r\n          } else if (result) {\r\n            console.log('成功跳转到节点定义:', node.type);\r\n          } else {\r\n            console.warn('未能跳转到节点定义，可能节点不存在于当前上下文中');\r\n          }\r\n        }\r\n      );\r\n    } catch (error) {\r\n      console.error('跳转定义失败:', error);\r\n    }\r\n  }\r\n  hideContextMenu();\r\n};\r\n\r\nconst deleteNode = () => {\r\n  if (contextMenu.node) {\r\n    const nodeToDelete = contextMenu.node;\r\n    console.log('删除节点:', nodeToDelete.name);\r\n    \r\n    // 发送删除事件给父组件\r\n    emit('nodeDelete', nodeToDelete);\r\n  }\r\n  hideContextMenu();\r\n};\r\n\r\nconst expandChildren = () => {\r\n  if (contextMenu.node) {\r\n    const expandAllChildren = (node: TreeNode) => {\r\n      node.expanded = true;\r\n      if (node.children) {\r\n        node.children.forEach(expandAllChildren);\r\n      }\r\n    };\r\n    expandAllChildren(contextMenu.node);\r\n  }\r\n  hideContextMenu();\r\n};\r\n\r\nconst collapseChildren = () => {\r\n  if (contextMenu.node) {\r\n    const collapseAllChildren = (node: TreeNode) => {\r\n      node.expanded = false;\r\n      if (node.children) {\r\n        node.children.forEach(collapseAllChildren);\r\n      }\r\n    };\r\n    collapseAllChildren(contextMenu.node);\r\n  }\r\n  hideContextMenu();\r\n};\r\n\r\n// 搜索模式下判断是否应该显示子节点\r\nconst shouldShowChildrenForSearch = (node: TreeNode): boolean => {\r\n  // 如果没有搜索关键字，返回false（使用正常的展开逻辑）\r\n  if (!searchKeyword.value.trim()) {\r\n    return false;\r\n  }\r\n  \r\n  // 如果节点有匹配的子节点，则显示子节点\r\n  return node.hasMatchingChildren === true;\r\n};\r\n\r\n// 状态按钮相关方法\r\nconst shouldShowStatusButton = (node: TreeNode): boolean => {\r\n  // 在搜索模式下完全隐藏状态按钮\r\n  if (searchKeyword.value.trim()) {\r\n    return false;\r\n  }\r\n  \r\n  // 正常模式下始终渲染状态按钮，但通过CSS控制在hover或选中时才显示\r\n  // 这样可以确保过渡动画的流畅性\r\n  return true;\r\n};\r\n\r\nconst getNodeStatus = (node: TreeNode): boolean => {\r\n  // 修复bug：优先使用节点自己的简单属性，避免因共享components引用而相互影响\r\n  // 这样可以确保每个节点的状态显示都是独立的\r\n  \r\n  if (!node.is3D) {\r\n    // 2D节点优先显示visible状态\r\n    if (node.visible !== undefined) {\r\n      return node.visible;\r\n    }\r\n    \r\n    // 如果简单属性不存在，才从components中获取\r\n    if (node.components) {\r\n      const node2D = node.components.find(c => c.type === 'Node2D');\r\n      if (node2D) {\r\n        const visibleProp = node2D.properties.find(p => p.name === 'visible');\r\n        if (visibleProp !== undefined) {\r\n          return visibleProp.value;\r\n        }\r\n      }\r\n    }\r\n    \r\n    // 默认为true\r\n    return true;\r\n  } else {\r\n    // 3D节点优先显示active状态\r\n    if (node.active !== undefined) {\r\n      return node.active;\r\n    }\r\n    \r\n    // 如果简单属性不存在，才从components中获取\r\n    if (node.components) {\r\n      const nodeInfo = node.components.find(c => c.type === 'NodeInfo');\r\n      if (nodeInfo) {\r\n        const activeProp = nodeInfo.properties.find(p => p.name === 'active');\r\n        if (activeProp !== undefined) {\r\n          return activeProp.value;\r\n        }\r\n      }\r\n    }\r\n    \r\n    // 默认为true\r\n    return true;\r\n  }\r\n};\r\n\r\nconst getStatusIcon = (node: TreeNode): string => {\r\n  const isActive = getNodeStatus(node);\r\n  return isActive ? 'icon-eye-open' : 'icon-eye-closed';\r\n};\r\n\r\nconst getStatusButtonTitle = (node: TreeNode): string => {\r\n  const isActive = getNodeStatus(node);\r\n  \r\n  // 确定状态类型，优先从components判断\r\n  let statusType = 'active';\r\n  if (!node.is3D) {\r\n    statusType = 'visible';\r\n  }\r\n  return `${statusType}: ${isActive ? '连接' : '断开'} (点击切换)`;\r\n};\r\n\r\nconst toggleNodeStatus = (node: TreeNode) => {\r\n  const currentValue = getNodeStatus(node);\r\n  const newValue = !currentValue;\r\n  \r\n  // 确定状态类型，优先从components判断\r\n  let statusType: 'active' | 'visible' = 'active';\r\n\r\n  if (!node.is3D) {\r\n    statusType = 'visible';\r\n  }\r\n  \r\n  // 重要修复：不直接修改传入的node对象，避免影响其他引用\r\n  // 直接向父组件发送状态变更事件，由父组件处理状态更新\r\n  // 这样可以确保只有当前操作的节点受到影响，不会误影响选中的节点\r\n  \r\n  console.log(`切换节点 ${node.name} 的 ${statusType} 状态为: ${newValue}`);\r\n  \r\n  // 向父组件发送状态变更事件\r\n  emit('statusToggle', node, statusType, newValue);\r\n};\r\n</script>\r\n\r\n<style scoped>\r\n/* 图标定义 - 科技感符号 */\r\n.icon-arrow::before { content: '▶'; }\r\n.icon-scene::before { content: '⬢'; }\r\n.icon-camera::before { content: '◉'; }\r\n.icon-folder::before { content: '▩'; }\r\n.icon-sprite::before { content: '◈'; }\r\n.icon-mesh::before { content: '⬟'; }\r\n.icon-node::before { content: '⬡'; }\r\n.icon-inspect::before { content: '⚹'; }\r\n.icon-delete::before { content: '⨯'; }\r\n.icon-expand-all::before { content: '⬇'; }\r\n.icon-collapse-all::before { content: '➤'; }\r\n.icon-search::before { content: '🔍'; }\r\n.icon-clear::before { content: '⨯'; }\r\n.icon-eye-open::before { content: '👁'; }\r\n.icon-eye-closed::before { content: '🚫'; }\r\n\r\n.tree-view {\r\n  position: relative;\r\n  user-select: none;\r\n  /* 深色主题变量 */\r\n  --tree-text-primary: #f0f2f5;\r\n  --tree-text-secondary: #b8c5d1;\r\n  --tree-text-accent: #4dd4ff;\r\n  --tree-accent-primary: #0aa2ff;\r\n  --tree-accent-secondary: #40e0d0;\r\n  --tree-bg-hover: linear-gradient(135deg, rgba(0, 162, 255, 0.08), rgba(64, 224, 208, 0.04));\r\n  --tree-bg-selected: linear-gradient(135deg, rgba(0, 162, 255, 0.15), rgba(64, 224, 208, 0.1));\r\n  --tree-bg-card: linear-gradient(135deg, rgba(15, 20, 25, 0.5), rgba(26, 31, 41, 0.3));\r\n  --tree-bg-menu: linear-gradient(135deg, rgba(15, 20, 25, 0.95), rgba(26, 31, 41, 0.95));\r\n  --tree-border-primary: rgba(0, 162, 255, 0.2);\r\n  --tree-border-accent: rgba(0, 162, 255, 0.4);\r\n  --tree-shadow-primary: rgba(0, 0, 0, 0.2);\r\n  --tree-shadow-accent: rgba(0, 162, 255, 0.3);\r\n  /* 深色模式光效 */\r\n  --tree-text-glow: 0 0 8px rgba(0, 162, 255, 0.5);\r\n  --tree-text-glow-accent: 0 0 4px rgba(0, 162, 255, 0.3);\r\n  --tree-text-glow-secondary: 0 0 2px rgba(0, 162, 255, 0.3);\r\n}\r\n\r\n/* 浅色主题变量 */\r\n.tree-view.light-mode {\r\n  --tree-text-primary: #1e293b;\r\n  --tree-text-secondary: #475569;\r\n  --tree-text-accent: #0369a1;\r\n  --tree-accent-primary: #0ea5e9;\r\n  --tree-accent-secondary: #14b8a6;\r\n  /* 苹果风格背景 - 使用subtle灰色hover和选中效果 */\r\n  --tree-bg-hover: linear-gradient(135deg, rgba(0, 0, 0, 0.04), rgba(0, 0, 0, 0.02));\r\n  --tree-bg-selected: linear-gradient(135deg, rgba(0, 0, 0, 0.08), rgba(0, 0, 0, 0.05));\r\n  --tree-bg-card: linear-gradient(135deg, rgba(255, 255, 255, 0.7), rgba(248, 250, 252, 0.5));\r\n  --tree-bg-menu: linear-gradient(135deg, rgba(255, 255, 255, 0.95), rgba(248, 250, 252, 0.95));\r\n  /* 苹果风格边框 - 使用subtle灰色 */\r\n  --tree-border-primary: rgba(0, 0, 0, 0.08);\r\n  --tree-border-accent: rgba(0, 0, 0, 0.12);\r\n  /* 苹果风格阴影 */\r\n  --tree-shadow-primary: rgba(0, 0, 0, 0.05);\r\n  --tree-shadow-accent: rgba(0, 0, 0, 0.1);\r\n  /* 浅色模式光效 - 苹果风格的subtle阴影 */\r\n  --tree-text-glow: 0 1px 2px rgba(0, 0, 0, 0.05);\r\n  --tree-text-glow-accent: 0 1px 1px rgba(0, 0, 0, 0.08);\r\n  --tree-text-glow-secondary: 0 0.5px 1px rgba(0, 0, 0, 0.06);\r\n}\r\n\r\n.tree-node {\r\n  position: relative;\r\n}\r\n\r\n.node-item {\r\n  display: flex;\r\n  align-items: center;\r\n  padding: 4px 8px;\r\n  margin: 1px 0;\r\n  border-radius: 8px;\r\n  cursor: pointer;\r\n  transition: all 0.25s ease-out;\r\n  position: relative;\r\n  overflow: hidden;\r\n  border: 1px solid transparent;\r\n  backdrop-filter: blur(4px);\r\n}\r\n\r\n.node-item::before {\r\n  content: '';\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  right: 0;\r\n  bottom: 0;\r\n  background: linear-gradient(135deg, var(--tree-accent-primary), var(--tree-accent-secondary));\r\n  opacity: 0;\r\n  transition: opacity 0.2s ease;\r\n  z-index: -1;\r\n}\r\n\r\n/* 浅色模式下完全隐藏伪元素背景 */\r\n.tree-view.light-mode .node-item::before {\r\n  display: none !important;\r\n  content: none !important;\r\n  background: transparent !important;\r\n}\r\n\r\n.node-item:hover {\r\n  background: var(--tree-bg-hover);\r\n  transform: translateX(2px);\r\n  box-shadow: \r\n    0 2px 8px var(--tree-shadow-accent),\r\n    0 0 0 1px var(--tree-border-primary) inset;\r\n  border: 1px solid var(--tree-border-primary);\r\n}\r\n\r\n.node-item:hover::before {\r\n  opacity: 0.05;\r\n}\r\n\r\n/* 浅色模式下hover不显示伪元素 */\r\n.tree-view.light-mode .node-item:hover::before {\r\n  opacity: 0 !important;\r\n  display: none !important;\r\n}\r\n\r\n.node-item.selected {\r\n  background: var(--tree-bg-selected);\r\n  color: var(--tree-text-primary);\r\n  font-weight: 600;\r\n  box-shadow: \r\n    0 4px 16px var(--tree-shadow-accent),\r\n    0 0 0 1px var(--tree-border-accent) inset;\r\n  border: 1px solid var(--tree-border-accent);\r\n  text-shadow: var(--tree-text-glow);\r\n}\r\n\r\n.node-item.selected::before {\r\n  opacity: 0.1;\r\n}\r\n\r\n/* 浅色模式下selected也不显示伪元素 */\r\n.tree-view.light-mode .node-item.selected::before {\r\n  opacity: 0 !important;\r\n  display: none !important;\r\n}\r\n\r\n.node-content {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 8px;\r\n  flex: 1;\r\n  min-width: 0;\r\n}\r\n\r\n.expand-btn {\r\n  width: 16px;\r\n  height: 16px;\r\n  border: none;\r\n  background: var(--tree-bg-card);\r\n  border-radius: 6px;\r\n  cursor: pointer;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  font-size: 10px;\r\n  color: var(--tree-text-accent);\r\n  transition: all 0.2s ease-out;\r\n  flex-shrink: 0;\r\n  border: 1px solid var(--tree-border-primary);\r\n  backdrop-filter: blur(4px);\r\n  text-shadow: var(--tree-text-glow-accent);\r\n}\r\n\r\n.expand-btn:hover {\r\n  background: var(--tree-bg-selected);\r\n  border-color: var(--tree-border-accent);\r\n  box-shadow: 0 0 8px var(--tree-shadow-accent);\r\n  transform: scale(1.1);\r\n  color: var(--tree-text-primary);\r\n}\r\n\r\n.expand-btn.expanded {\r\n  transform: rotate(90deg);\r\n}\r\n\r\n.expand-btn.expanded:hover {\r\n  transform: rotate(90deg) scale(1.1);\r\n}\r\n\r\n/* 搜索自动展开的按钮样式 */\r\n.expand-btn.search-auto-expanded {\r\n  background: linear-gradient(135deg, rgba(255, 193, 7, 0.3), rgba(255, 152, 0, 0.2));\r\n  border-color: rgba(255, 193, 7, 0.4);\r\n  color: #ffc107;\r\n  transform: rotate(90deg);\r\n  animation: searchPulse 2s ease-in-out infinite;\r\n}\r\n\r\n.expand-btn.search-auto-expanded:hover {\r\n  background: linear-gradient(135deg, rgba(255, 193, 7, 0.4), rgba(255, 152, 0, 0.3));\r\n  border-color: rgba(255, 193, 7, 0.6);\r\n  transform: rotate(90deg) scale(1.1);\r\n}\r\n\r\n@keyframes searchPulse {\r\n  0%, 100% {\r\n    box-shadow: 0 0 4px rgba(255, 193, 7, 0.3);\r\n  }\r\n  50% {\r\n    box-shadow: 0 0 8px rgba(255, 193, 7, 0.5);\r\n  }\r\n}\r\n\r\n.expand-spacer {\r\n  width: 16px;\r\n  flex-shrink: 0;\r\n}\r\n\r\n.node-icon {\r\n  font-size: 14px;\r\n  flex-shrink: 0;\r\n  opacity: 0.9;\r\n  color: var(--tree-text-secondary);\r\n  filter: drop-shadow(var(--tree-text-glow-secondary));\r\n  transition: all 0.2s ease-out;\r\n}\r\n\r\n.node-name {\r\n  font-size: 13px;\r\n  color: var(--tree-text-primary);\r\n  flex: 1;\r\n  min-width: 0;\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n  font-weight: 500;\r\n  text-shadow: var(--tree-text-glow-accent);\r\n  transition: all 0.2s ease-out;\r\n}\r\n\r\n.node-type-tag {\r\n  font-size: 10px;\r\n  color: var(--tree-text-secondary);\r\n  background: var(--tree-bg-card);\r\n  padding: 2px 6px;\r\n  border-radius: 6px;\r\n  flex-shrink: 0;\r\n  opacity: 0;\r\n  transition: all 0.2s ease-out;\r\n  border: 1px solid var(--tree-border-primary);\r\n  backdrop-filter: blur(4px);\r\n  font-weight: 500;\r\n  text-shadow: var(--tree-text-glow-secondary);\r\n}\r\n\r\n.node-item:hover .node-type-tag,\r\n.node-item.selected .node-type-tag {\r\n  opacity: 1;\r\n  color: var(--tree-accent-secondary);\r\n  background: var(--tree-bg-selected);\r\n  border-color: var(--tree-border-accent);\r\n  text-shadow: var(--tree-text-glow-accent);\r\n}\r\n\r\n.node-item.selected .node-name {\r\n  color: var(--tree-text-primary);\r\n  font-weight: 600;\r\n  text-shadow: var(--tree-text-glow);\r\n}\r\n\r\n.node-item.selected .node-icon {\r\n  color: var(--tree-text-accent);\r\n  filter: drop-shadow(var(--tree-text-glow-accent));\r\n}\r\n\r\n/* 状态按钮样式 */\r\n.status-btn {\r\n  width: 20px;\r\n  height: 20px;\r\n  border: none;\r\n  background: var(--tree-bg-card);\r\n  border-radius: 6px;\r\n  cursor: pointer;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  font-size: 12px;\r\n  transition: all 0.2s ease-out;\r\n  flex-shrink: 0;\r\n  border: 1px solid var(--tree-border-primary);\r\n  backdrop-filter: blur(4px);\r\n  opacity: 0;\r\n  transform: scale(0.8);\r\n  pointer-events: none;\r\n}\r\n\r\n/* 在hover或选中时显示状态按钮 */\r\n.node-item:hover .status-btn,\r\n.node-item.selected .status-btn {\r\n  opacity: 1;\r\n  transform: scale(1);\r\n  pointer-events: auto;\r\n}\r\n\r\n.status-btn.status-active {\r\n  color: var(--tree-accent-secondary);\r\n  background: var(--tree-bg-selected);\r\n  border-color: var(--tree-border-accent);\r\n  text-shadow: var(--tree-text-glow-accent);\r\n}\r\n\r\n.status-btn.status-inactive {\r\n  color: var(--tree-text-secondary);\r\n  background: var(--tree-bg-hover);\r\n  border-color: var(--tree-border-primary);\r\n}\r\n\r\n.node-item:hover .status-btn.status-inactive,\r\n.node-item.selected .status-btn.status-inactive {\r\n  opacity: 0.7;\r\n}\r\n\r\n.status-btn:hover {\r\n  background: var(--tree-bg-selected);\r\n  border-color: var(--tree-border-accent);\r\n  box-shadow: 0 0 8px var(--tree-shadow-accent);\r\n  transform: scale(1.1);\r\n  color: var(--tree-text-primary);\r\n}\r\n\r\n.status-btn.status-inactive:hover {\r\n  color: var(--tree-accent-secondary);\r\n}\r\n\r\n.children-container {\r\n  margin-left: 20px;\r\n  position: relative;\r\n  /* 移除默认动画，避免刷新时的不必要动效 */\r\n}\r\n\r\n.children-container::before {\r\n  content: '';\r\n  position: absolute;\r\n  left: -12px;\r\n  top: 0;\r\n  bottom: 0;\r\n  width: 2px;\r\n  background: linear-gradient(to bottom, rgba(0, 162, 255, 0.15), rgba(64, 224, 208, 0.1), transparent);\r\n  border-radius: 1px;\r\n  box-shadow: 0 0 2px rgba(0, 162, 255, 0.15);\r\n  transition: all 0.2s ease-out;\r\n}\r\n\r\n/* 搜索展开的容器特殊样式 */\r\n.children-container.search-expanded::before {\r\n  background: linear-gradient(to bottom, rgba(255, 193, 7, 0.4), rgba(255, 152, 0, 0.3), transparent);\r\n  box-shadow: 0 0 4px rgba(255, 193, 7, 0.3);\r\n  width: 3px;\r\n}\r\n\r\n.children-container.search-expanded {\r\n  position: relative;\r\n}\r\n\r\n.children-container.search-expanded::after {\r\n  content: '🔍';\r\n  position: absolute;\r\n  left: -20px;\r\n  top: 2px;\r\n  font-size: 10px;\r\n  opacity: 0.6;\r\n  color: var(--tree-accent-secondary);\r\n  filter: drop-shadow(var(--tree-text-glow-accent));\r\n}\r\n\r\n/* 浅色模式下使用subtle的连接线 */\r\n.tree-view.light-mode .children-container::before {\r\n  background: linear-gradient(to bottom, rgba(0, 0, 0, 0.12), rgba(0, 0, 0, 0.08), transparent);\r\n  box-shadow: none;\r\n  width: 1px;\r\n}\r\n\r\n/* 用户手动展开时的动画 */\r\n.children-container.manual-expand {\r\n  animation: expandDown 0.25s ease-out;\r\n}\r\n\r\n@keyframes expandDown {\r\n  from {\r\n    opacity: 0;\r\n    transform: translateY(-2px);\r\n    max-height: 0;\r\n  }\r\n  to {\r\n    opacity: 1;\r\n    transform: translateY(0);\r\n    max-height: 500px;\r\n  }\r\n}\r\n\r\n/* 右键菜单 */\r\n.context-menu {\r\n  position: fixed;\r\n  background: var(--tree-bg-menu);\r\n  backdrop-filter: blur(24px);\r\n  border: 1px solid var(--tree-border-accent);\r\n  border-radius: 12px;\r\n  box-shadow: \r\n    0 16px 64px var(--tree-shadow-primary),\r\n    0 0 0 1px var(--tree-border-primary) inset;\r\n  padding: 6px;\r\n  z-index: 1000;\r\n  min-width: 180px;\r\n  animation: contextMenuShow 0.3s cubic-bezier(0.4, 0, 0.2, 1);\r\n}\r\n\r\n@keyframes contextMenuShow {\r\n  from {\r\n    opacity: 0;\r\n    transform: scale(0.95) translateY(-5px);\r\n  }\r\n  to {\r\n    opacity: 1;\r\n    transform: scale(1) translateY(0);\r\n  }\r\n}\r\n\r\n.menu-item {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 8px;\r\n  padding: 8px 12px;\r\n  border-radius: 8px;\r\n  cursor: pointer;\r\n  font-size: 12px;\r\n  color: var(--tree-text-secondary);\r\n  transition: all 0.2s ease-out;\r\n  font-weight: 500;\r\n  border: 1px solid transparent;\r\n}\r\n\r\n.menu-item:hover {\r\n  background: var(--tree-bg-hover);\r\n  color: var(--tree-text-primary);\r\n  border: 1px solid var(--tree-border-primary);\r\n  box-shadow: 0 0 8px var(--tree-shadow-accent);\r\n  text-shadow: var(--tree-text-glow-accent);\r\n}\r\n\r\n.menu-item i {\r\n  font-size: 12px;\r\n  opacity: 0.8;\r\n  color: var(--tree-text-secondary);\r\n  filter: drop-shadow(var(--tree-text-glow-secondary));\r\n  transition: all 0.2s ease-out;\r\n}\r\n\r\n.menu-separator {\r\n  height: 1px;\r\n  background: linear-gradient(90deg, transparent, var(--tree-border-accent), transparent);\r\n  margin: 4px 8px;\r\n  box-shadow: 0 0 2px var(--tree-shadow-accent);\r\n}\r\n\r\n/* 浅色模式下使用subtle的菜单分隔线 */\r\n.tree-view.light-mode .menu-separator {\r\n  background: linear-gradient(90deg, transparent, rgba(0, 0, 0, 0.1), transparent);\r\n  box-shadow: none;\r\n}\r\n\r\n/* 响应式设计 */\r\n@media (max-width: 768px) {\r\n  .children-container {\r\n    margin-left: 16px;\r\n  }\r\n  \r\n  .node-name {\r\n    font-size: 12px;\r\n  }\r\n  \r\n  .node-type-tag {\r\n    display: none;\r\n  }\r\n}\r\n\r\n/* 搜索容器样式 */\r\n.search-container {\r\n  padding: 8px 8px 8px 8px;\r\n  margin: -8px -8px 0 -8px;\r\n  border-bottom: 1px solid var(--tree-border-primary);\r\n  background: var(--tree-bg-card);\r\n  backdrop-filter: blur(8px);\r\n  position: sticky;\r\n  top: -8px;\r\n  z-index: 10;\r\n}\r\n\r\n.search-container::before {\r\n  content: '';\r\n  position: absolute;\r\n  top: -8px;\r\n  left: 0;\r\n  right: 0;\r\n  height: 8px;\r\n  background: var(--tree-bg-card);\r\n  backdrop-filter: blur(8px);\r\n  z-index: -1;\r\n}\r\n\r\n.search-input-wrapper {\r\n  position: relative;\r\n  display: flex;\r\n  align-items: center;\r\n}\r\n\r\n.search-input {\r\n  width: 100%;\r\n  height: 32px;\r\n  padding: 6px 12px 6px 32px;\r\n  border: 1px solid var(--tree-border-primary);\r\n  border-radius: 16px;\r\n  background: var(--tree-bg-card);\r\n  backdrop-filter: blur(4px);\r\n  color: var(--tree-text-primary);\r\n  font-size: 12px;\r\n  font-weight: 400;\r\n  transition: all 0.25s ease-out;\r\n  outline: none;\r\n  box-shadow: 0 2px 8px var(--tree-shadow-primary);\r\n}\r\n\r\n.search-input::placeholder {\r\n  color: var(--tree-text-secondary);\r\n  opacity: 0.8;\r\n}\r\n\r\n.search-input:focus {\r\n  border-color: var(--tree-border-accent);\r\n  background: var(--tree-bg-selected);\r\n  box-shadow: \r\n    0 4px 16px var(--tree-shadow-accent),\r\n    0 0 0 1px var(--tree-border-accent) inset;\r\n  color: var(--tree-text-primary);\r\n  text-shadow: var(--tree-text-glow-accent);\r\n}\r\n\r\n.search-icon {\r\n  position: absolute;\r\n  left: 10px;\r\n  font-size: 12px;\r\n  color: var(--tree-text-secondary);\r\n  pointer-events: none;\r\n  z-index: 1;\r\n  filter: drop-shadow(var(--tree-text-glow-secondary));\r\n}\r\n\r\n.clear-search-btn {\r\n  position: absolute;\r\n  right: 8px;\r\n  width: 20px;\r\n  height: 20px;\r\n  border: none;\r\n  background: var(--tree-bg-hover);\r\n  border-radius: 50%;\r\n  cursor: pointer;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  font-size: 10px;\r\n  color: var(--tree-text-secondary);\r\n  transition: all 0.2s ease-out;\r\n  opacity: 0.7;\r\n}\r\n\r\n.clear-search-btn:hover {\r\n  background: var(--tree-bg-selected);\r\n  color: var(--tree-text-primary);\r\n  opacity: 1;\r\n  transform: scale(1.1);\r\n  box-shadow: 0 0 8px var(--tree-shadow-accent);\r\n}\r\n\r\n/* 搜索匹配高亮 */\r\n.node-item.search-match {\r\n  background: var(--tree-bg-hover);\r\n  box-shadow: \r\n    0 2px 8px var(--tree-shadow-accent),\r\n    0 0 0 1px var(--tree-border-primary) inset;\r\n}\r\n\r\n.search-highlight {\r\n  background: linear-gradient(135deg, var(--tree-accent-primary), var(--tree-accent-secondary));\r\n  color: #ffffff;\r\n  padding: 1px 3px;\r\n  border-radius: 3px;\r\n  font-weight: 600;\r\n  text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);\r\n  box-shadow: 0 0 4px var(--tree-shadow-accent);\r\n}\r\n\r\n/* 浅色模式下的搜索高亮 */\r\n.tree-view.light-mode .search-highlight {\r\n  background: linear-gradient(135deg, var(--tree-accent-primary), var(--tree-accent-secondary));\r\n  color: #ffffff;\r\n  box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);\r\n}\r\n</style>"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/VConsole.vue?vue&type=style&index=0&id=22ab07ac&scoped=true&lang=css":
/*!******************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/VConsole.vue?vue&type=style&index=0&id=22ab07ac&scoped=true&lang=css ***!
  \******************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/getUrl.js */ "./node_modules/css-loader/dist/runtime/getUrl.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__);
// Imports



var ___CSS_LOADER_URL_IMPORT_0___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="%23e0e0e0" stroke-width="2"><path d="M3 6h18"/><path d="M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6"/><path d="M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2"/></svg> */ "data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\"><path d=\"M3 6h18\"/><path d=\"M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6\"/><path d=\"M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2\"/></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_1___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="%23e0e0e0" stroke-width="2"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg> */ "data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\"><line x1=\"18\" y1=\"6\" x2=\"6\" y2=\"18\"></line><line x1=\"6\" y1=\"6\" x2=\"18\" y2=\"18\"></line></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_2___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="%23e0e0e0" stroke-width="2"><path d="M3 12a9 9 0 1 0 9-9 9.75 9.75 0 0 0-6.74 2.74L3 8"/><path d="M3 3v5h5"/><path d="M12 7v5l4 2"/></svg> */ "data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\"><path d=\"M3 12a9 9 0 1 0 9-9 9.75 9.75 0 0 0-6.74 2.74L3 8\"/><path d=\"M3 3v5h5\"/><path d=\"M12 7v5l4 2\"/></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_3___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="%23ffffff" stroke-width="2"><line x1="22" y1="2" x2="11" y2="13"></line><polygon points="22,2 15,22 11,13 2,9 22,2"></polygon></svg> */ "data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23ffffff\" stroke-width=\"2\"><line x1=\"22\" y1=\"2\" x2=\"11\" y2=\"13\"></line><polygon points=\"22,2 15,22 11,13 2,9 22,2\"></polygon></svg>"), __webpack_require__.b);
var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
var ___CSS_LOADER_URL_REPLACEMENT_0___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_0___);
var ___CSS_LOADER_URL_REPLACEMENT_1___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_1___);
var ___CSS_LOADER_URL_REPLACEMENT_2___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_2___);
var ___CSS_LOADER_URL_REPLACEMENT_3___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_3___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
.vconsole-panel-overlay[data-v-22ab07ac] {
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  z-index: 9999;
  pointer-events: none;
}
.vconsole-panel[data-v-22ab07ac] {
  position: absolute;
  width: 700px;
  height: 600px;
  background: var(--bg-card);
  border: 1px solid var(--border-primary);
  border-radius: 12px;
  box-shadow: 0 8px 32px var(--shadow-primary);
  display: flex;
  flex-direction: column;
  animation: slideIn-22ab07ac 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  pointer-events: auto;
  user-select: none;
  backdrop-filter: blur(16px);
}
.panel-header[data-v-22ab07ac] {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 16px 20px;
  border-bottom: 1px solid var(--border-primary);
  background: var(--bg-secondary);
  border-radius: 12px 12px 0 0;
  cursor: move;
  user-select: none;
  backdrop-filter: blur(16px);
}
.panel-header[data-v-22ab07ac]:active {
  cursor: grabbing;
}
.panel-header h3[data-v-22ab07ac] {
  margin: 0;
  font-size: 16px;
  font-weight: 600;
  color: var(--text-primary);
}
.header-controls[data-v-22ab07ac] {
  display: flex;
  align-items: center;
  gap: 8px;
}
.clear-btn[data-v-22ab07ac], .close-btn[data-v-22ab07ac] {
  width: 28px;
  height: 28px;
  border: none;
  background: transparent;
  border-radius: 6px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.2s ease;
}
.clear-btn[data-v-22ab07ac]:hover, .close-btn[data-v-22ab07ac]:hover {
  background: var(--bg-button-hover);
}
.clear-icon[data-v-22ab07ac] {
  width: 14px;
  height: 14px;
  background: url(${___CSS_LOADER_URL_REPLACEMENT_0___}) no-repeat center;
  background-size: contain;
}
.close-icon[data-v-22ab07ac] {
  width: 14px;
  height: 14px;
  background: url(${___CSS_LOADER_URL_REPLACEMENT_1___}) no-repeat center;
  background-size: contain;
}
.panel-content[data-v-22ab07ac] {
  flex: 1;
  display: flex;
  flex-direction: column;
  overflow: hidden;
}
.log-container[data-v-22ab07ac] {
  flex: 1;
  display: flex;
  flex-direction: column;
  border-bottom: 1px solid var(--border-primary);
  overflow: hidden;
}
.log-header[data-v-22ab07ac] {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 12px 20px;
  border-bottom: 1px solid var(--border-primary);
  background: var(--bg-secondary);
  font-size: 14px;
  font-weight: 600;
  color: var(--text-primary);
}
.log-controls[data-v-22ab07ac] {
  display: flex;
  align-items: center;
  gap: 12px;
}
.log-level-filter[data-v-22ab07ac] {
  padding: 4px 8px;
  border: 1px solid var(--border-primary);
  border-radius: 4px;
  background: var(--bg-card);
  color: var(--text-primary);
  font-size: 12px;
  cursor: pointer;
}
.log-count[data-v-22ab07ac] {
  font-size: 12px;
  color: var(--text-secondary);
  background: var(--bg-card);
  padding: 2px 8px;
  border-radius: 10px;
  border: 1px solid var(--border-primary);
}
.log-list[data-v-22ab07ac] {
  flex: 1;
  overflow-y: auto;
  background: var(--bg-card);
}
.empty-state[data-v-22ab07ac] {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  height: 100%;
  color: var(--text-secondary);
  text-align: center;
  padding: 40px;
}
.empty-icon[data-v-22ab07ac] {
  font-size: 48px;
  margin-bottom: 16px;
  opacity: 0.5;
}
.empty-icon[data-v-22ab07ac]::before {
  content: '📝';
}
.log-items[data-v-22ab07ac] {
  padding: 8px 0;
}
.log-item[data-v-22ab07ac] {
  display: flex;
  align-items: flex-start;
  padding: 6px 20px;
  border-bottom: 1px solid var(--border-primary);
  font-family: 'Consolas', 'Monaco', 'Courier New', monospace;
  font-size: 12px;
  line-height: 1.4;
  transition: background-color 0.2s ease;
}
.log-item[data-v-22ab07ac]:hover {
  background: var(--bg-secondary);
}
.log-time[data-v-22ab07ac] {
  min-width: 80px;
  color: var(--text-secondary);
  font-size: 11px;
  margin-right: 12px;
  opacity: 0.7;
}
.log-level[data-v-22ab07ac] {
  min-width: 50px;
  font-weight: 600;
  margin-right: 12px;
  font-size: 11px;
}
.log-content[data-v-22ab07ac] {
  flex: 1;
  word-break: break-all;
  white-space: pre-wrap;
}

/* 不同日志级别的颜色 */
.log-log .log-level[data-v-22ab07ac] {
  color: var(--text-primary);
}
.log-info .log-level[data-v-22ab07ac] {
  color: #3b82f6;
}
.log-warn .log-level[data-v-22ab07ac] {
  color: #f59e0b;
}
.log-error .log-level[data-v-22ab07ac] {
  color: #ef4444;
}
.log-error[data-v-22ab07ac] {
  background: rgba(239, 68, 68, 0.05);
}
.log-warn[data-v-22ab07ac] {
  background: rgba(245, 158, 11, 0.05);
}
.command-container[data-v-22ab07ac] {
  height: 200px;
  display: flex;
  flex-direction: column;
  background: var(--bg-card);
}
.command-header[data-v-22ab07ac] {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 12px 20px;
  border-bottom: 1px solid var(--border-primary);
  background: var(--bg-secondary);
  font-size: 14px;
  font-weight: 600;
  color: var(--text-primary);
}
.history-btn[data-v-22ab07ac] {
  width: 24px;
  height: 24px;
  border: none;
  background: transparent;
  border-radius: 4px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.2s ease;
}
.history-btn[data-v-22ab07ac]:hover {
  background: var(--bg-button-hover);
}
.history-icon[data-v-22ab07ac] {
  width: 12px;
  height: 12px;
  background: url(${___CSS_LOADER_URL_REPLACEMENT_2___}) no-repeat center;
  background-size: contain;
}
.command-input-area[data-v-22ab07ac] {
  flex: 1;
  position: relative;
  padding: 16px 20px;
}
.input-wrapper[data-v-22ab07ac] {
  display: flex;
  align-items: center;
  gap: 8px;
  background: var(--bg-secondary);
  border: 1px solid var(--border-primary);
  border-radius: 8px;
  padding: 8px 12px;
  transition: border-color 0.2s ease;
}
.input-wrapper[data-v-22ab07ac]:focus-within {
  border-color: var(--border-accent);
  box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.1);
}
.prompt[data-v-22ab07ac] {
  color: var(--text-accent);
  font-weight: 600;
  font-family: 'Consolas', 'Monaco', 'Courier New', monospace;
}
.command-input[data-v-22ab07ac] {
  flex: 1;
  border: none;
  background: transparent;
  color: var(--text-primary);
  font-family: 'Consolas', 'Monaco', 'Courier New', monospace;
  font-size: 13px;
  outline: none;
}
.command-input[data-v-22ab07ac]::placeholder {
  color: var(--text-secondary);
  opacity: 0.6;
}
.send-btn[data-v-22ab07ac] {
  width: 32px;
  height: 32px;
  border: none;
  background: var(--bg-accent);
  border-radius: 6px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.2s ease;
}
.send-btn[data-v-22ab07ac]:hover:not(:disabled) {
  background: var(--bg-accent-hover);
  transform: translateY(-1px);
}
.send-btn[data-v-22ab07ac]:disabled {
  opacity: 0.5;
  cursor: not-allowed;
}
.send-icon[data-v-22ab07ac] {
  width: 14px;
  height: 14px;
  background: url(${___CSS_LOADER_URL_REPLACEMENT_3___}) no-repeat center;
  background-size: contain;
}
.command-history[data-v-22ab07ac] {
  position: absolute;
  top: -8px;
  left: 20px;
  right: 20px;
  background: var(--bg-card);
  border: 1px solid var(--border-primary);
  border-radius: 8px;
  box-shadow: 0 4px 16px var(--shadow-primary);
  max-height: 200px;
  overflow-y: auto;
  z-index: 10;
  transform: translateY(-100%);
}
.history-item[data-v-22ab07ac] {
  padding: 8px 12px;
  cursor: pointer;
  font-family: 'Consolas', 'Monaco', 'Courier New', monospace;
  font-size: 12px;
  color: var(--text-primary);
  border-bottom: 1px solid var(--border-primary);
  transition: background-color 0.2s ease;
}
.history-item[data-v-22ab07ac]:last-child {
  border-bottom: none;
}
.history-item[data-v-22ab07ac]:hover {
  background: var(--bg-secondary);
}
@keyframes slideIn-22ab07ac {
from {
    opacity: 0;
    transform: translateY(-20px) scale(0.95);
}
to {
    opacity: 1;
    transform: translateY(0) scale(1);
}
}
`, "",{"version":3,"sources":["webpack://./src/devtools/components/VConsole.vue"],"names":[],"mappings":";AAuZA;EACE,eAAe;EACf,MAAM;EACN,OAAO;EACP,QAAQ;EACR,SAAS;EACT,aAAa;EACb,oBAAoB;AACtB;AAEA;EACE,kBAAkB;EAClB,YAAY;EACZ,aAAa;EACb,0BAA0B;EAC1B,uCAAuC;EACvC,mBAAmB;EACnB,4CAA4C;EAC5C,aAAa;EACb,sBAAsB;EACtB,qEAA4D;EAC5D,oBAAoB;EACpB,iBAAiB;EACjB,2BAA2B;AAC7B;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,kBAAkB;EAClB,8CAA8C;EAC9C,+BAA+B;EAC/B,4BAA4B;EAC5B,YAAY;EACZ,iBAAiB;EACjB,2BAA2B;AAC7B;AAEA;EACE,gBAAgB;AAClB;AAEA;EACE,SAAS;EACT,eAAe;EACf,gBAAgB;EAChB,0BAA0B;AAC5B;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;AACV;AAEA;EACE,WAAW;EACX,YAAY;EACZ,YAAY;EACZ,uBAAuB;EACvB,kBAAkB;EAClB,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,yBAAyB;AAC3B;AAEA;EACE,kCAAkC;AACpC;AAEA;EACE,WAAW;EACX,YAAY;EACZ,oEAA2R;EAC3R,wBAAwB;AAC1B;AAEA;EACE,WAAW;EACX,YAAY;EACZ,oEAA+P;EAC/P,wBAAwB;AAC1B;AAEA;EACE,OAAO;EACP,aAAa;EACb,sBAAsB;EACtB,gBAAgB;AAClB;AAEA;EACE,OAAO;EACP,aAAa;EACb,sBAAsB;EACtB,8CAA8C;EAC9C,gBAAgB;AAClB;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,kBAAkB;EAClB,8CAA8C;EAC9C,+BAA+B;EAC/B,eAAe;EACf,gBAAgB;EAChB,0BAA0B;AAC5B;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,SAAS;AACX;AAEA;EACE,gBAAgB;EAChB,uCAAuC;EACvC,kBAAkB;EAClB,0BAA0B;EAC1B,0BAA0B;EAC1B,eAAe;EACf,eAAe;AACjB;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,0BAA0B;EAC1B,gBAAgB;EAChB,mBAAmB;EACnB,uCAAuC;AACzC;AAEA;EACE,OAAO;EACP,gBAAgB;EAChB,0BAA0B;AAC5B;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;EACnB,uBAAuB;EACvB,YAAY;EACZ,4BAA4B;EAC5B,kBAAkB;EAClB,aAAa;AACf;AAEA;EACE,eAAe;EACf,mBAAmB;EACnB,YAAY;AACd;AAEA;EACE,aAAa;AACf;AAEA;EACE,cAAc;AAChB;AAEA;EACE,aAAa;EACb,uBAAuB;EACvB,iBAAiB;EACjB,8CAA8C;EAC9C,2DAA2D;EAC3D,eAAe;EACf,gBAAgB;EAChB,sCAAsC;AACxC;AAEA;EACE,+BAA+B;AACjC;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,eAAe;EACf,kBAAkB;EAClB,YAAY;AACd;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,kBAAkB;EAClB,eAAe;AACjB;AAEA;EACE,OAAO;EACP,qBAAqB;EACrB,qBAAqB;AACvB;;AAEA,cAAc;AACd;EACE,0BAA0B;AAC5B;AAEA;EACE,cAAc;AAChB;AAEA;EACE,cAAc;AAChB;AAEA;EACE,cAAc;AAChB;AAEA;EACE,mCAAmC;AACrC;AAEA;EACE,oCAAoC;AACtC;AAEA;EACE,aAAa;EACb,aAAa;EACb,sBAAsB;EACtB,0BAA0B;AAC5B;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,kBAAkB;EAClB,8CAA8C;EAC9C,+BAA+B;EAC/B,eAAe;EACf,gBAAgB;EAChB,0BAA0B;AAC5B;AAEA;EACE,WAAW;EACX,YAAY;EACZ,YAAY;EACZ,uBAAuB;EACvB,kBAAkB;EAClB,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,yBAAyB;AAC3B;AAEA;EACE,kCAAkC;AACpC;AAEA;EACE,WAAW;EACX,YAAY;EACZ,oEAAiR;EACjR,wBAAwB;AAC1B;AAEA;EACE,OAAO;EACP,kBAAkB;EAClB,kBAAkB;AACpB;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,+BAA+B;EAC/B,uCAAuC;EACvC,kBAAkB;EAClB,iBAAiB;EACjB,kCAAkC;AACpC;AAEA;EACE,kCAAkC;EAClC,6CAA6C;AAC/C;AAEA;EACE,yBAAyB;EACzB,gBAAgB;EAChB,2DAA2D;AAC7D;AAEA;EACE,OAAO;EACP,YAAY;EACZ,uBAAuB;EACvB,0BAA0B;EAC1B,2DAA2D;EAC3D,eAAe;EACf,aAAa;AACf;AAEA;EACE,4BAA4B;EAC5B,YAAY;AACd;AAEA;EACE,WAAW;EACX,YAAY;EACZ,YAAY;EACZ,4BAA4B;EAC5B,kBAAkB;EAClB,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,yBAAyB;AAC3B;AAEA;EACE,kCAAkC;EAClC,2BAA2B;AAC7B;AAEA;EACE,YAAY;EACZ,mBAAmB;AACrB;AAEA;EACE,WAAW;EACX,YAAY;EACZ,oEAA2Q;EAC3Q,wBAAwB;AAC1B;AAEA;EACE,kBAAkB;EAClB,SAAS;EACT,UAAU;EACV,WAAW;EACX,0BAA0B;EAC1B,uCAAuC;EACvC,kBAAkB;EAClB,4CAA4C;EAC5C,iBAAiB;EACjB,gBAAgB;EAChB,WAAW;EACX,4BAA4B;AAC9B;AAEA;EACE,iBAAiB;EACjB,eAAe;EACf,2DAA2D;EAC3D,eAAe;EACf,0BAA0B;EAC1B,8CAA8C;EAC9C,sCAAsC;AACxC;AAEA;EACE,mBAAmB;AACrB;AAEA;EACE,+BAA+B;AACjC;AAEA;AACE;IACE,UAAU;IACV,wCAAwC;AAC1C;AACA;IACE,UAAU;IACV,iCAAiC;AACnC;AACF","sourcesContent":["<template>\n  <div v-if=\"isVisible\" class=\"vconsole-panel-overlay\">\n    <div \n        class=\"vconsole-panel\" \n        :style=\"{ left: panelPosition.x + 'px', top: panelPosition.y + 'px' }\"\n        @mousedown=\"startDrag\"\n      >\n      <div class=\"panel-header\" @mousedown=\"startDrag\">\n        <h3>VConsole 控制台</h3>\n        <div class=\"header-controls\">\n          <button class=\"clear-btn\" @click=\"clearLogs\" title=\"清空日志\" @mousedown.stop>\n            <i class=\"clear-icon\"></i>\n          </button>\n          <button class=\"close-btn\" @click=\"closePanel\" title=\"关闭面板\" @mousedown.stop>\n            <i class=\"close-icon\"></i>\n          </button>\n        </div>\n      </div>\n      \n      <div class=\"panel-content\">\n        <!-- 日志输出区域 -->\n        <div class=\"log-container\">\n          <div class=\"log-header\">\n            <span>控制台日志</span>\n            <div class=\"log-controls\">\n              <select v-model=\"selectedLogLevel\" class=\"log-level-filter\">\n                <option value=\"all\">全部</option>\n                <option value=\"log\">Log</option>\n                <option value=\"info\">Info</option>\n                <option value=\"warn\">Warn</option>\n                <option value=\"error\">Error</option>\n              </select>\n              <span class=\"log-count\">{{ filteredLogs.length }} 条</span>\n            </div>\n          </div>\n          <div class=\"log-list\" ref=\"logListRef\">\n            <div v-if=\"filteredLogs.length === 0\" class=\"empty-state\">\n              <i class=\"empty-icon\"></i>\n              <p>暂无日志输出</p>\n              <small>等待应用程序输出日志信息</small>\n            </div>\n            <div v-else class=\"log-items\">\n              <div \n                v-for=\"(log, index) in filteredLogs\" \n                :key=\"index\" \n                class=\"log-item\"\n                :class=\"`log-${log.level}`\"\n              >\n                <div class=\"log-time\">{{ formatTime(log.timestamp) }}</div>\n                <div class=\"log-level\">{{ log.level.toUpperCase() }}</div>\n                <div class=\"log-content\">{{ log.message }}</div>\n              </div>\n            </div>\n          </div>\n        </div>\n        \n        <!-- 命令行输入区域 -->\n        <div class=\"command-container\">\n          <div class=\"command-header\">\n            <span>命令行</span>\n            <button class=\"history-btn\" @click=\"toggleHistory\" title=\"命令历史\">\n              <i class=\"history-icon\"></i>\n            </button>\n          </div>\n          <div class=\"command-input-area\">\n            <div class=\"input-wrapper\">\n              <span class=\"prompt\">></span>\n              <input \n                ref=\"commandInputRef\"\n                v-model=\"currentCommand\" \n                type=\"text\" \n                class=\"command-input\" \n                placeholder=\"输入JavaScript命令...\"\n                @keydown=\"handleKeyDown\"\n                @focus=\"hideHistory\"\n              />\n              <button \n                class=\"send-btn\" \n                @click=\"executeCommand\" \n                :disabled=\"!currentCommand.trim()\"\n                title=\"执行命令\"\n              >\n                <i class=\"send-icon\"></i>\n              </button>\n            </div>\n            \n            <!-- 命令历史下拉 -->\n            <div v-if=\"showHistory && commandHistory.length > 0\" class=\"command-history\">\n              <div \n                v-for=\"(cmd, index) in commandHistory.slice().reverse()\" \n                :key=\"index\"\n                class=\"history-item\"\n                @click=\"selectHistoryCommand(cmd)\"\n              >\n                {{ cmd }}\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n</template>\n\n<script setup lang=\"ts\">\nimport { ref, reactive, computed, nextTick, inject, onMounted, onUnmounted } from 'vue'\nimport { Logger } from '@/core/Constant'\nimport { EventType } from '@/core/message/Event'\nimport type { Ref } from 'vue'\n\n// 日志级别类型\ntype LogLevel = 'log' | 'info' | 'warn' | 'error'\n\n// 日志项接口\ninterface LogItem {\n  level: LogLevel\n  message: string\n  timestamp: number\n}\n\n// 注入父组件提供的sendMessage方法和lowerId\nconst sendMessage = inject('sendMessage') as Function\nconst lowerId = inject('lowerId') as Ref<string>\n\n// 面板显示状态\nconst isVisible = ref(false)\n\n// 日志相关状态\nconst logs = reactive<LogItem[]>([])\nconst selectedLogLevel = ref<string>('all')\nconst logListRef = ref<HTMLElement | null>(null)\n\n// 命令行相关状态\nconst currentCommand = ref('')\nconst commandHistory = reactive<string[]>([])\nconst showHistory = ref(false)\nconst commandInputRef = ref<HTMLInputElement | null>(null)\n\n// 面板位置和拖拽状态\nconst panelPosition = reactive({ x: 150, y: 150 })\nconst isDragging = ref(false)\nconst dragOffset = reactive({ x: 0, y: 0 })\n\n// 计算过滤后的日志\nconst filteredLogs = computed(() => {\n  if (selectedLogLevel.value === 'all') {\n    return logs\n  }\n  return logs.filter(log => log.level === selectedLogLevel.value)\n})\n\n// 显示面板\nconst showPanel = () => {\n  isVisible.value = true\n  // 居中显示面板\n  panelPosition.x = (window.innerWidth - 700) / 2\n  panelPosition.y = (window.innerHeight - 600) / 2\n  \n  // 发送VConsole日志开始消息到上位机\n  if (sendMessage && lowerId.value) {\n    sendMessage({\n      type: EventType.VCONSOLE_LOG_START,\n      targetId: lowerId.value,\n      timestamp: Date.now()\n    })\n    Logger.log('📤 已发送VCONSOLE_LOG_START消息')\n  }\n  \n  // 聚焦到命令输入框\n  nextTick(() => {\n    commandInputRef.value?.focus()\n  })\n}\n\n// 关闭面板\nconst closePanel = () => {\n  isVisible.value = false\n  hideHistory()\n  \n  // 发送VConsole日志结束消息到上位机\n  if (sendMessage && lowerId.value) {\n    sendMessage({\n      type: EventType.VCONSOLE_LOG_END,\n      targetId: lowerId.value,\n      timestamp: Date.now()\n    })\n    Logger.log('📤 已发送VCONSOLE_LOG_END消息')\n  }\n}\n\n// 清空日志\nconst clearLogs = () => {\n  logs.length = 0\n  Logger.log('[VConsole] 日志已清空')\n}\n\n// 添加日志\nconst addLog = (level: LogLevel, message: string) => {\n  logs.push({\n    level,\n    message,\n    timestamp: Date.now()\n  })\n  \n  // 限制日志数量，避免内存溢出\n  if (logs.length > 1000) {\n    logs.splice(0, logs.length - 1000)\n  }\n  \n  // 自动滚动到底部\n  nextTick(() => {\n    if (logListRef.value) {\n      logListRef.value.scrollTop = logListRef.value.scrollHeight\n    }\n  })\n}\n\n// 格式化时间\nconst formatTime = (timestamp: number): string => {\n  const date = new Date(timestamp)\n  return date.toLocaleTimeString('zh-CN', { \n    hour12: false,\n    hour: '2-digit',\n    minute: '2-digit',\n    second: '2-digit'\n  })\n}\n\n// 执行命令\nconst executeCommand = () => {\n  const command = currentCommand.value.trim()\n  if (!command) return\n  \n  // 添加到命令历史\n  if (!commandHistory.includes(command)) {\n    commandHistory.push(command)\n    // 限制历史记录数量\n    if (commandHistory.length > 50) {\n      commandHistory.shift()\n    }\n  }\n  \n  // 显示执行的命令\n  addLog('info', `> ${command}`)\n  \n  try {\n    // 发送命令到下位机执行\n    if (sendMessage && lowerId.value) {\n      sendMessage({\n        type: EventType.EVAL_REQUEST,\n        targetId: lowerId.value,\n        command: command,\n        timestamp: Date.now()\n      })\n      Logger.log(`📤 已发送VConsole命令: ${command}`)\n    } else {\n      addLog('error', '未连接到设备，无法执行命令')\n    }\n  } catch (error) {\n    addLog('error', `命令执行失败: ${error}`)\n    Logger.error('[VConsole] 命令执行失败:', error)\n  }\n  \n  // 清空输入框\n  currentCommand.value = ''\n  hideHistory()\n}\n\n// 处理键盘事件\nconst handleKeyDown = (event: KeyboardEvent) => {\n  switch (event.key) {\n    case 'Enter':\n      event.preventDefault()\n      executeCommand()\n      break\n    case 'ArrowUp':\n      event.preventDefault()\n      navigateHistory(-1)\n      break\n    case 'ArrowDown':\n      event.preventDefault()\n      navigateHistory(1)\n      break\n    case 'Escape':\n      hideHistory()\n      break\n  }\n}\n\n// 历史记录导航\nlet historyIndex = -1\nconst navigateHistory = (direction: number) => {\n  if (commandHistory.length === 0) return\n  \n  historyIndex += direction\n  \n  if (historyIndex < 0) {\n    historyIndex = -1\n    currentCommand.value = ''\n  } else if (historyIndex >= commandHistory.length) {\n    historyIndex = commandHistory.length - 1\n  }\n  \n  if (historyIndex >= 0) {\n    currentCommand.value = commandHistory[commandHistory.length - 1 - historyIndex]\n  }\n}\n\n// 切换历史记录显示\nconst toggleHistory = () => {\n  showHistory.value = !showHistory.value\n}\n\n// 隐藏历史记录\nconst hideHistory = () => {\n  showHistory.value = false\n  historyIndex = -1\n}\n\n// 选择历史命令\nconst selectHistoryCommand = (command: string) => {\n  currentCommand.value = command\n  hideHistory()\n  commandInputRef.value?.focus()\n}\n\n// 拖拽相关函数\nconst startDrag = (event: MouseEvent) => {\n  if (event.target === event.currentTarget || (event.target as HTMLElement).closest('.panel-header')) {\n    isDragging.value = true\n    dragOffset.x = event.clientX - panelPosition.x\n    dragOffset.y = event.clientY - panelPosition.y\n    \n    document.addEventListener('mousemove', onDrag)\n    document.addEventListener('mouseup', stopDrag)\n    event.preventDefault()\n  }\n}\n\nconst onDrag = (event: MouseEvent) => {\n  if (isDragging.value) {\n    panelPosition.x = event.clientX - dragOffset.x\n    panelPosition.y = event.clientY - dragOffset.y\n    \n    // 限制面板在窗口内\n    panelPosition.x = Math.max(0, Math.min(panelPosition.x, window.innerWidth - 700))\n    panelPosition.y = Math.max(0, Math.min(panelPosition.y, window.innerHeight - 600))\n  }\n}\n\nconst stopDrag = () => {\n  isDragging.value = false\n  document.removeEventListener('mousemove', onDrag)\n  document.removeEventListener('mouseup', stopDrag)\n}\n\n// 处理VConsole响应消息\nconst handleVConsoleResponse = (message: any) => {\n  Logger.log('📥 收到VConsole响应:', message)\n  \n  switch (message.type) {\n    case EventType.EVAL_RESPONSE:\n      if (message.success) {\n        // 显示命令执行结果\n        if (message.result !== undefined) {\n          addLog('log', `< ${message.result}`)\n        }\n        Logger.log('✅ VConsole命令执行成功')\n      } else {\n        addLog('error', `命令执行失败: ${message.error || '未知错误'}`)\n        Logger.error('❌ VConsole命令执行失败:', message.error)\n      }\n      break\n      \n    case EventType.VCONSOLE_LOG_MESSAGE:\n      // 接收来自应用的日志消息\n      if (message.level && message.message) {\n        addLog(message.level as LogLevel, message.message)\n      }\n      break\n  }\n}\n\n// 组件挂载时的初始化\nonMounted(() => {\n  // 添加一些示例日志（开发阶段）\n  addLog('info', 'VConsole 控制台已启动')\n  addLog('log', '可以在下方输入JavaScript命令进行调试')\n})\n\n// 组件卸载时清理\nonUnmounted(() => {\n  if (isDragging.value) {\n    stopDrag()\n  }\n})\n\n// 暴露方法给父组件\ndefineExpose({\n  showPanel,\n  closePanel,\n  handleVConsoleResponse,\n  addLog\n})\n</script>\n\n<style scoped>\n.vconsole-panel-overlay {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 9999;\n  pointer-events: none;\n}\n\n.vconsole-panel {\n  position: absolute;\n  width: 700px;\n  height: 600px;\n  background: var(--bg-card);\n  border: 1px solid var(--border-primary);\n  border-radius: 12px;\n  box-shadow: 0 8px 32px var(--shadow-primary);\n  display: flex;\n  flex-direction: column;\n  animation: slideIn 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);\n  pointer-events: auto;\n  user-select: none;\n  backdrop-filter: blur(16px);\n}\n\n.panel-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 16px 20px;\n  border-bottom: 1px solid var(--border-primary);\n  background: var(--bg-secondary);\n  border-radius: 12px 12px 0 0;\n  cursor: move;\n  user-select: none;\n  backdrop-filter: blur(16px);\n}\n\n.panel-header:active {\n  cursor: grabbing;\n}\n\n.panel-header h3 {\n  margin: 0;\n  font-size: 16px;\n  font-weight: 600;\n  color: var(--text-primary);\n}\n\n.header-controls {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n}\n\n.clear-btn, .close-btn {\n  width: 28px;\n  height: 28px;\n  border: none;\n  background: transparent;\n  border-radius: 6px;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  transition: all 0.2s ease;\n}\n\n.clear-btn:hover, .close-btn:hover {\n  background: var(--bg-button-hover);\n}\n\n.clear-icon {\n  width: 14px;\n  height: 14px;\n  background: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\"><path d=\"M3 6h18\"/><path d=\"M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6\"/><path d=\"M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2\"/></svg>') no-repeat center;\n  background-size: contain;\n}\n\n.close-icon {\n  width: 14px;\n  height: 14px;\n  background: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\"><line x1=\"18\" y1=\"6\" x2=\"6\" y2=\"18\"></line><line x1=\"6\" y1=\"6\" x2=\"18\" y2=\"18\"></line></svg>') no-repeat center;\n  background-size: contain;\n}\n\n.panel-content {\n  flex: 1;\n  display: flex;\n  flex-direction: column;\n  overflow: hidden;\n}\n\n.log-container {\n  flex: 1;\n  display: flex;\n  flex-direction: column;\n  border-bottom: 1px solid var(--border-primary);\n  overflow: hidden;\n}\n\n.log-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 12px 20px;\n  border-bottom: 1px solid var(--border-primary);\n  background: var(--bg-secondary);\n  font-size: 14px;\n  font-weight: 600;\n  color: var(--text-primary);\n}\n\n.log-controls {\n  display: flex;\n  align-items: center;\n  gap: 12px;\n}\n\n.log-level-filter {\n  padding: 4px 8px;\n  border: 1px solid var(--border-primary);\n  border-radius: 4px;\n  background: var(--bg-card);\n  color: var(--text-primary);\n  font-size: 12px;\n  cursor: pointer;\n}\n\n.log-count {\n  font-size: 12px;\n  color: var(--text-secondary);\n  background: var(--bg-card);\n  padding: 2px 8px;\n  border-radius: 10px;\n  border: 1px solid var(--border-primary);\n}\n\n.log-list {\n  flex: 1;\n  overflow-y: auto;\n  background: var(--bg-card);\n}\n\n.empty-state {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  height: 100%;\n  color: var(--text-secondary);\n  text-align: center;\n  padding: 40px;\n}\n\n.empty-icon {\n  font-size: 48px;\n  margin-bottom: 16px;\n  opacity: 0.5;\n}\n\n.empty-icon::before {\n  content: '📝';\n}\n\n.log-items {\n  padding: 8px 0;\n}\n\n.log-item {\n  display: flex;\n  align-items: flex-start;\n  padding: 6px 20px;\n  border-bottom: 1px solid var(--border-primary);\n  font-family: 'Consolas', 'Monaco', 'Courier New', monospace;\n  font-size: 12px;\n  line-height: 1.4;\n  transition: background-color 0.2s ease;\n}\n\n.log-item:hover {\n  background: var(--bg-secondary);\n}\n\n.log-time {\n  min-width: 80px;\n  color: var(--text-secondary);\n  font-size: 11px;\n  margin-right: 12px;\n  opacity: 0.7;\n}\n\n.log-level {\n  min-width: 50px;\n  font-weight: 600;\n  margin-right: 12px;\n  font-size: 11px;\n}\n\n.log-content {\n  flex: 1;\n  word-break: break-all;\n  white-space: pre-wrap;\n}\n\n/* 不同日志级别的颜色 */\n.log-log .log-level {\n  color: var(--text-primary);\n}\n\n.log-info .log-level {\n  color: #3b82f6;\n}\n\n.log-warn .log-level {\n  color: #f59e0b;\n}\n\n.log-error .log-level {\n  color: #ef4444;\n}\n\n.log-error {\n  background: rgba(239, 68, 68, 0.05);\n}\n\n.log-warn {\n  background: rgba(245, 158, 11, 0.05);\n}\n\n.command-container {\n  height: 200px;\n  display: flex;\n  flex-direction: column;\n  background: var(--bg-card);\n}\n\n.command-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 12px 20px;\n  border-bottom: 1px solid var(--border-primary);\n  background: var(--bg-secondary);\n  font-size: 14px;\n  font-weight: 600;\n  color: var(--text-primary);\n}\n\n.history-btn {\n  width: 24px;\n  height: 24px;\n  border: none;\n  background: transparent;\n  border-radius: 4px;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  transition: all 0.2s ease;\n}\n\n.history-btn:hover {\n  background: var(--bg-button-hover);\n}\n\n.history-icon {\n  width: 12px;\n  height: 12px;\n  background: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23e0e0e0\" stroke-width=\"2\"><path d=\"M3 12a9 9 0 1 0 9-9 9.75 9.75 0 0 0-6.74 2.74L3 8\"/><path d=\"M3 3v5h5\"/><path d=\"M12 7v5l4 2\"/></svg>') no-repeat center;\n  background-size: contain;\n}\n\n.command-input-area {\n  flex: 1;\n  position: relative;\n  padding: 16px 20px;\n}\n\n.input-wrapper {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  background: var(--bg-secondary);\n  border: 1px solid var(--border-primary);\n  border-radius: 8px;\n  padding: 8px 12px;\n  transition: border-color 0.2s ease;\n}\n\n.input-wrapper:focus-within {\n  border-color: var(--border-accent);\n  box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.1);\n}\n\n.prompt {\n  color: var(--text-accent);\n  font-weight: 600;\n  font-family: 'Consolas', 'Monaco', 'Courier New', monospace;\n}\n\n.command-input {\n  flex: 1;\n  border: none;\n  background: transparent;\n  color: var(--text-primary);\n  font-family: 'Consolas', 'Monaco', 'Courier New', monospace;\n  font-size: 13px;\n  outline: none;\n}\n\n.command-input::placeholder {\n  color: var(--text-secondary);\n  opacity: 0.6;\n}\n\n.send-btn {\n  width: 32px;\n  height: 32px;\n  border: none;\n  background: var(--bg-accent);\n  border-radius: 6px;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  transition: all 0.2s ease;\n}\n\n.send-btn:hover:not(:disabled) {\n  background: var(--bg-accent-hover);\n  transform: translateY(-1px);\n}\n\n.send-btn:disabled {\n  opacity: 0.5;\n  cursor: not-allowed;\n}\n\n.send-icon {\n  width: 14px;\n  height: 14px;\n  background: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"%23ffffff\" stroke-width=\"2\"><line x1=\"22\" y1=\"2\" x2=\"11\" y2=\"13\"></line><polygon points=\"22,2 15,22 11,13 2,9 22,2\"></polygon></svg>') no-repeat center;\n  background-size: contain;\n}\n\n.command-history {\n  position: absolute;\n  top: -8px;\n  left: 20px;\n  right: 20px;\n  background: var(--bg-card);\n  border: 1px solid var(--border-primary);\n  border-radius: 8px;\n  box-shadow: 0 4px 16px var(--shadow-primary);\n  max-height: 200px;\n  overflow-y: auto;\n  z-index: 10;\n  transform: translateY(-100%);\n}\n\n.history-item {\n  padding: 8px 12px;\n  cursor: pointer;\n  font-family: 'Consolas', 'Monaco', 'Courier New', monospace;\n  font-size: 12px;\n  color: var(--text-primary);\n  border-bottom: 1px solid var(--border-primary);\n  transition: background-color 0.2s ease;\n}\n\n.history-item:last-child {\n  border-bottom: none;\n}\n\n.history-item:hover {\n  background: var(--bg-secondary);\n}\n\n@keyframes slideIn {\n  from {\n    opacity: 0;\n    transform: translateY(-20px) scale(0.95);\n  }\n  to {\n    opacity: 1;\n    transform: translateY(0) scale(1);\n  }\n}\n</style>"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/VectorInput.vue?vue&type=style&index=0&id=5d5b83ae&scoped=true&lang=css":
/*!*********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/devtools/components/VectorInput.vue?vue&type=style&index=0&id=5d5b83ae&scoped=true&lang=css ***!
  \*********************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
.vector-input[data-v-5d5b83ae] {
  display: flex;
  gap: 4px;
  width: 100%;
  align-items: center;
}
.vector-component[data-v-5d5b83ae] {
  display: flex;
  align-items: center;
  gap: 2px;
  min-width: 0;
  flex: 1;
}
.component-label[data-v-5d5b83ae] {
  font-size: 10px;
  color: var(--text-secondary);
  font-weight: 600;
  letter-spacing: 0.5px;
  text-transform: uppercase;
  opacity: 0.9;
  min-width: 8px;
  text-align: center;
  text-shadow: var(--text-glow-accent);
  transition: all 0.3s ease;
}
.vector-component:hover .component-label[data-v-5d5b83ae] {
  color: var(--text-accent);
  opacity: 1;
  text-shadow: var(--text-glow);
}

/* Vector2 特殊样式 */
.vector-vector2 .vector-component:nth-child(1) .component-label[data-v-5d5b83ae] {
  color: #ff6b6b; /* X轴 - 红色 */
}
.vector-vector2 .vector-component:nth-child(2) .component-label[data-v-5d5b83ae] {
  color: #51cf66; /* Y轴 - 绿色 */
}

/* Vector3 特殊样式 */
.vector-vector3 .vector-component:nth-child(1) .component-label[data-v-5d5b83ae] {
  color: #ff6b6b; /* X轴 - 红色 */
}
.vector-vector3 .vector-component:nth-child(2) .component-label[data-v-5d5b83ae] {
  color: #51cf66; /* Y轴 - 绿色 */
}
.vector-vector3 .vector-component:nth-child(3) .component-label[data-v-5d5b83ae] {
  color: #4dabf7; /* Z轴 - 蓝色 */
}

/* Vector4 特殊样式 */
.vector-vector4 .vector-component:nth-child(1) .component-label[data-v-5d5b83ae] {
  color: #ff6b6b; /* X轴 - 红色 */
}
.vector-vector4 .vector-component:nth-child(2) .component-label[data-v-5d5b83ae] {
  color: #51cf66; /* Y轴 - 绿色 */
}
.vector-vector4 .vector-component:nth-child(3) .component-label[data-v-5d5b83ae] {
  color: #4dabf7; /* Z轴 - 蓝色 */
}
.vector-vector4 .vector-component:nth-child(4) .component-label[data-v-5d5b83ae] {
  color: #ffd43b; /* W轴 - 黄色 */
}

/* 响应式设计 */
@media (max-width: 768px) {
.vector-input[data-v-5d5b83ae] {
    gap: 4px;
}
.component-label[data-v-5d5b83ae] {
    font-size: 9px;
}
}
`, "",{"version":3,"sources":["webpack://./src/devtools/components/VectorInput.vue"],"names":[],"mappings":";AA6FA;EACE,aAAa;EACb,QAAQ;EACR,WAAW;EACX,mBAAmB;AACrB;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,YAAY;EACZ,OAAO;AACT;AAEA;EACE,eAAe;EACf,4BAA4B;EAC5B,gBAAgB;EAChB,qBAAqB;EACrB,yBAAyB;EACzB,YAAY;EACZ,cAAc;EACd,kBAAkB;EAClB,oCAAoC;EACpC,yBAAyB;AAC3B;AAEA;EACE,yBAAyB;EACzB,UAAU;EACV,6BAA6B;AAC/B;;AAEA,iBAAiB;AACjB;EACE,cAAc,EAAE,YAAY;AAC9B;AAEA;EACE,cAAc,EAAE,YAAY;AAC9B;;AAEA,iBAAiB;AACjB;EACE,cAAc,EAAE,YAAY;AAC9B;AAEA;EACE,cAAc,EAAE,YAAY;AAC9B;AAEA;EACE,cAAc,EAAE,YAAY;AAC9B;;AAEA,iBAAiB;AACjB;EACE,cAAc,EAAE,YAAY;AAC9B;AAEA;EACE,cAAc,EAAE,YAAY;AAC9B;AAEA;EACE,cAAc,EAAE,YAAY;AAC9B;AAEA;EACE,cAAc,EAAE,YAAY;AAC9B;;AAEA,UAAU;AACV;AACE;IACE,QAAQ;AACV;AAEA;IACE,cAAc;AAChB;AACF","sourcesContent":["<template>\r\n  <div class=\"vector-input\" :class=\"{ [`vector-${type}`]: true }\">\r\n    <div class=\"vector-component\">\r\n      <label class=\"component-label\">X</label>\r\n      <PropertyInput\r\n        :value=\"value.x || 0\"\r\n        :step=\"step\"\r\n        :min=\"min\"\r\n        :max=\"max\"\r\n        :disabled=\"disabled\"\r\n        @change=\"onComponentChange('x', $event)\"\r\n      />\r\n    </div>\r\n    \r\n    <div class=\"vector-component\">\r\n      <label class=\"component-label\">Y</label>\r\n      <PropertyInput\r\n        :value=\"value.y || 0\"\r\n        :step=\"step\"\r\n        :min=\"min\"\r\n        :max=\"max\"\r\n        :disabled=\"disabled\"\r\n        @change=\"onComponentChange('y', $event)\"\r\n      />\r\n    </div>\r\n    \r\n    <div v-if=\"type === 'vector3' || type === 'vector4'\" class=\"vector-component\">\r\n      <label class=\"component-label\">Z</label>\r\n      <PropertyInput\r\n        :value=\"value.z || 0\"\r\n        :step=\"step\"\r\n        :min=\"min\"\r\n        :max=\"max\"\r\n        :disabled=\"disabled\"\r\n        @change=\"onComponentChange('z', $event)\"\r\n      />\r\n    </div>\r\n    \r\n    <div v-if=\"type === 'vector4'\" class=\"vector-component\">\r\n      <label class=\"component-label\">W</label>\r\n      <PropertyInput\r\n        :value=\"value.w || 0\"\r\n        :step=\"step\"\r\n        :min=\"min\"\r\n        :max=\"max\"\r\n        :disabled=\"disabled\"\r\n        @change=\"onComponentChange('w', $event)\"\r\n      />\r\n    </div>\r\n  </div>\r\n</template>\r\n\r\n<script setup lang=\"ts\">\r\nimport PropertyInput from './PropertyInput.vue';\r\n\r\n// Props\r\ninterface Props {\r\n  value: { x?: number; y?: number; z?: number; w?: number };\r\n  type: 'vector2' | 'vector3' | 'vector4' | any;\r\n  step?: number;\r\n  min?: number;\r\n  max?: number;\r\n  disabled?: boolean;\r\n}\r\n\r\nconst props = withDefaults(defineProps<Props>(), {\r\n  step: 0.01,\r\n  min: undefined,\r\n  max: undefined,\r\n  disabled: false\r\n});\r\n\r\n// Emits\r\nconst emit = defineEmits<{\r\n  change: [value: { x: number; y: number; z?: number; w?: number }];\r\n}>();\r\n\r\n// 方法\r\nconst onComponentChange = (component: 'x' | 'y' | 'z' | 'w', newValue: number) => {\r\n  const updatedValue = { ...props.value };\r\n  updatedValue[component] = newValue;\r\n  \r\n  // 确保所有必需的组件都存在\r\n  if (!updatedValue.x) updatedValue.x = 0;\r\n  if (!updatedValue.y) updatedValue.y = 0;\r\n  if ((props.type === 'vector3' || props.type === 'vector4') && !updatedValue.z) updatedValue.z = 0;\r\n  if (props.type === 'vector4' && !updatedValue.w) updatedValue.w = 0;\r\n  \r\n  emit('change', updatedValue as { x: number; y: number; z?: number; w?: number });\r\n};\r\n</script>\r\n\r\n<style scoped>\r\n.vector-input {\r\n  display: flex;\r\n  gap: 4px;\r\n  width: 100%;\r\n  align-items: center;\r\n}\r\n\r\n.vector-component {\r\n  display: flex;\r\n  align-items: center;\r\n  gap: 2px;\r\n  min-width: 0;\r\n  flex: 1;\r\n}\r\n\r\n.component-label {\r\n  font-size: 10px;\r\n  color: var(--text-secondary);\r\n  font-weight: 600;\r\n  letter-spacing: 0.5px;\r\n  text-transform: uppercase;\r\n  opacity: 0.9;\r\n  min-width: 8px;\r\n  text-align: center;\r\n  text-shadow: var(--text-glow-accent);\r\n  transition: all 0.3s ease;\r\n}\r\n\r\n.vector-component:hover .component-label {\r\n  color: var(--text-accent);\r\n  opacity: 1;\r\n  text-shadow: var(--text-glow);\r\n}\r\n\r\n/* Vector2 特殊样式 */\r\n.vector-vector2 .vector-component:nth-child(1) .component-label {\r\n  color: #ff6b6b; /* X轴 - 红色 */\r\n}\r\n\r\n.vector-vector2 .vector-component:nth-child(2) .component-label {\r\n  color: #51cf66; /* Y轴 - 绿色 */\r\n}\r\n\r\n/* Vector3 特殊样式 */\r\n.vector-vector3 .vector-component:nth-child(1) .component-label {\r\n  color: #ff6b6b; /* X轴 - 红色 */\r\n}\r\n\r\n.vector-vector3 .vector-component:nth-child(2) .component-label {\r\n  color: #51cf66; /* Y轴 - 绿色 */\r\n}\r\n\r\n.vector-vector3 .vector-component:nth-child(3) .component-label {\r\n  color: #4dabf7; /* Z轴 - 蓝色 */\r\n}\r\n\r\n/* Vector4 特殊样式 */\r\n.vector-vector4 .vector-component:nth-child(1) .component-label {\r\n  color: #ff6b6b; /* X轴 - 红色 */\r\n}\r\n\r\n.vector-vector4 .vector-component:nth-child(2) .component-label {\r\n  color: #51cf66; /* Y轴 - 绿色 */\r\n}\r\n\r\n.vector-vector4 .vector-component:nth-child(3) .component-label {\r\n  color: #4dabf7; /* Z轴 - 蓝色 */\r\n}\r\n\r\n.vector-vector4 .vector-component:nth-child(4) .component-label {\r\n  color: #ffd43b; /* W轴 - 黄色 */\r\n}\r\n\r\n/* 响应式设计 */\r\n@media (max-width: 768px) {\r\n  .vector-input {\r\n    gap: 4px;\r\n  }\r\n  \r\n  .component-label {\r\n    font-size: 9px;\r\n  }\r\n}\r\n</style>"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/runtime/api.js":
/*!*****************************************************!*\
  !*** ./node_modules/css-loader/dist/runtime/api.js ***!
  \*****************************************************/
/***/ ((module) => {

"use strict";


/*
  MIT License http://www.opensource.org/licenses/mit-license.php
  Author Tobias Koppers @sokra
*/
module.exports = function (cssWithMappingToString) {
  var list = [];

  // return the list of modules as css string
  list.toString = function toString() {
    return this.map(function (item) {
      var content = "";
      var needLayer = typeof item[5] !== "undefined";
      if (item[4]) {
        content += "@supports (".concat(item[4], ") {");
      }
      if (item[2]) {
        content += "@media ".concat(item[2], " {");
      }
      if (needLayer) {
        content += "@layer".concat(item[5].length > 0 ? " ".concat(item[5]) : "", " {");
      }
      content += cssWithMappingToString(item);
      if (needLayer) {
        content += "}";
      }
      if (item[2]) {
        content += "}";
      }
      if (item[4]) {
        content += "}";
      }
      return content;
    }).join("");
  };

  // import a list of modules into the list
  list.i = function i(modules, media, dedupe, supports, layer) {
    if (typeof modules === "string") {
      modules = [[null, modules, undefined]];
    }
    var alreadyImportedModules = {};
    if (dedupe) {
      for (var k = 0; k < this.length; k++) {
        var id = this[k][0];
        if (id != null) {
          alreadyImportedModules[id] = true;
        }
      }
    }
    for (var _k = 0; _k < modules.length; _k++) {
      var item = [].concat(modules[_k]);
      if (dedupe && alreadyImportedModules[item[0]]) {
        continue;
      }
      if (typeof layer !== "undefined") {
        if (typeof item[5] === "undefined") {
          item[5] = layer;
        } else {
          item[1] = "@layer".concat(item[5].length > 0 ? " ".concat(item[5]) : "", " {").concat(item[1], "}");
          item[5] = layer;
        }
      }
      if (media) {
        if (!item[2]) {
          item[2] = media;
        } else {
          item[1] = "@media ".concat(item[2], " {").concat(item[1], "}");
          item[2] = media;
        }
      }
      if (supports) {
        if (!item[4]) {
          item[4] = "".concat(supports);
        } else {
          item[1] = "@supports (".concat(item[4], ") {").concat(item[1], "}");
          item[4] = supports;
        }
      }
      list.push(item);
    }
  };
  return list;
};

/***/ }),

/***/ "./node_modules/css-loader/dist/runtime/getUrl.js":
/*!********************************************************!*\
  !*** ./node_modules/css-loader/dist/runtime/getUrl.js ***!
  \********************************************************/
/***/ ((module) => {

"use strict";


module.exports = function (url, options) {
  if (!options) {
    options = {};
  }
  if (!url) {
    return url;
  }
  url = String(url.__esModule ? url.default : url);

  // If url is already wrapped in quotes, remove them
  if (/^['"].*['"]$/.test(url)) {
    url = url.slice(1, -1);
  }
  if (options.hash) {
    url += options.hash;
  }

  // Should url be wrapped?
  // See https://drafts.csswg.org/css-values-3/#urls
  if (/["'() \t\n]|(%20)/.test(url) || options.needQuotes) {
    return "\"".concat(url.replace(/"/g, '\\"').replace(/\n/g, "\\n"), "\"");
  }
  return url;
};

/***/ }),

/***/ "./node_modules/css-loader/dist/runtime/sourceMaps.js":
/*!************************************************************!*\
  !*** ./node_modules/css-loader/dist/runtime/sourceMaps.js ***!
  \************************************************************/
/***/ ((module) => {

"use strict";


module.exports = function (item) {
  var content = item[1];
  var cssMapping = item[3];
  if (!cssMapping) {
    return content;
  }
  if (typeof btoa === "function") {
    var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(cssMapping))));
    var data = "sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(base64);
    var sourceMapping = "/*# ".concat(data, " */");
    return [content].concat([sourceMapping]).join("\n");
  }
  return [content].join("\n");
};

/***/ }),

/***/ "./node_modules/dijkstrajs/dijkstra.js":
/*!*********************************************!*\
  !*** ./node_modules/dijkstrajs/dijkstra.js ***!
  \*********************************************/
/***/ ((module) => {

"use strict";


/******************************************************************************
 * Created 2008-08-19.
 *
 * Dijkstra path-finding functions. Adapted from the Dijkstar Python project.
 *
 * Copyright (C) 2008
 *   Wyatt Baldwin <self@wyattbaldwin.com>
 *   All rights reserved
 *
 * Licensed under the MIT license.
 *
 *   http://www.opensource.org/licenses/mit-license.php
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *****************************************************************************/
var dijkstra = {
  single_source_shortest_paths: function(graph, s, d) {
    // Predecessor map for each node that has been encountered.
    // node ID => predecessor node ID
    var predecessors = {};

    // Costs of shortest paths from s to all nodes encountered.
    // node ID => cost
    var costs = {};
    costs[s] = 0;

    // Costs of shortest paths from s to all nodes encountered; differs from
    // `costs` in that it provides easy access to the node that currently has
    // the known shortest path from s.
    // XXX: Do we actually need both `costs` and `open`?
    var open = dijkstra.PriorityQueue.make();
    open.push(s, 0);

    var closest,
        u, v,
        cost_of_s_to_u,
        adjacent_nodes,
        cost_of_e,
        cost_of_s_to_u_plus_cost_of_e,
        cost_of_s_to_v,
        first_visit;
    while (!open.empty()) {
      // In the nodes remaining in graph that have a known cost from s,
      // find the node, u, that currently has the shortest path from s.
      closest = open.pop();
      u = closest.value;
      cost_of_s_to_u = closest.cost;

      // Get nodes adjacent to u...
      adjacent_nodes = graph[u] || {};

      // ...and explore the edges that connect u to those nodes, updating
      // the cost of the shortest paths to any or all of those nodes as
      // necessary. v is the node across the current edge from u.
      for (v in adjacent_nodes) {
        if (adjacent_nodes.hasOwnProperty(v)) {
          // Get the cost of the edge running from u to v.
          cost_of_e = adjacent_nodes[v];

          // Cost of s to u plus the cost of u to v across e--this is *a*
          // cost from s to v that may or may not be less than the current
          // known cost to v.
          cost_of_s_to_u_plus_cost_of_e = cost_of_s_to_u + cost_of_e;

          // If we haven't visited v yet OR if the current known cost from s to
          // v is greater than the new cost we just found (cost of s to u plus
          // cost of u to v across e), update v's cost in the cost list and
          // update v's predecessor in the predecessor list (it's now u).
          cost_of_s_to_v = costs[v];
          first_visit = (typeof costs[v] === 'undefined');
          if (first_visit || cost_of_s_to_v > cost_of_s_to_u_plus_cost_of_e) {
            costs[v] = cost_of_s_to_u_plus_cost_of_e;
            open.push(v, cost_of_s_to_u_plus_cost_of_e);
            predecessors[v] = u;
          }
        }
      }
    }

    if (typeof d !== 'undefined' && typeof costs[d] === 'undefined') {
      var msg = ['Could not find a path from ', s, ' to ', d, '.'].join('');
      throw new Error(msg);
    }

    return predecessors;
  },

  extract_shortest_path_from_predecessor_list: function(predecessors, d) {
    var nodes = [];
    var u = d;
    var predecessor;
    while (u) {
      nodes.push(u);
      predecessor = predecessors[u];
      u = predecessors[u];
    }
    nodes.reverse();
    return nodes;
  },

  find_path: function(graph, s, d) {
    var predecessors = dijkstra.single_source_shortest_paths(graph, s, d);
    return dijkstra.extract_shortest_path_from_predecessor_list(
      predecessors, d);
  },

  /**
   * A very naive priority queue implementation.
   */
  PriorityQueue: {
    make: function (opts) {
      var T = dijkstra.PriorityQueue,
          t = {},
          key;
      opts = opts || {};
      for (key in T) {
        if (T.hasOwnProperty(key)) {
          t[key] = T[key];
        }
      }
      t.queue = [];
      t.sorter = opts.sorter || T.default_sorter;
      return t;
    },

    default_sorter: function (a, b) {
      return a.cost - b.cost;
    },

    /**
     * Add a new item to the queue and ensure the highest priority element
     * is at the front of the queue.
     */
    push: function (value, cost) {
      var item = {value: value, cost: cost};
      this.queue.push(item);
      this.queue.sort(this.sorter);
    },

    /**
     * Return the highest priority element in the queue.
     */
    pop: function () {
      return this.queue.shift();
    },

    empty: function () {
      return this.queue.length === 0;
    }
  }
};


// node.js module exports
if (true) {
  module.exports = dijkstra;
}


/***/ }),

/***/ "./node_modules/qrcode/lib/browser.js":
/*!********************************************!*\
  !*** ./node_modules/qrcode/lib/browser.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


const canPromise = __webpack_require__(/*! ./can-promise */ "./node_modules/qrcode/lib/can-promise.js")

const QRCode = __webpack_require__(/*! ./core/qrcode */ "./node_modules/qrcode/lib/core/qrcode.js")
const CanvasRenderer = __webpack_require__(/*! ./renderer/canvas */ "./node_modules/qrcode/lib/renderer/canvas.js")
const SvgRenderer = __webpack_require__(/*! ./renderer/svg-tag.js */ "./node_modules/qrcode/lib/renderer/svg-tag.js")

function renderCanvas (renderFunc, canvas, text, opts, cb) {
  const args = [].slice.call(arguments, 1)
  const argsNum = args.length
  const isLastArgCb = typeof args[argsNum - 1] === 'function'

  if (!isLastArgCb && !canPromise()) {
    throw new Error('Callback required as last argument')
  }

  if (isLastArgCb) {
    if (argsNum < 2) {
      throw new Error('Too few arguments provided')
    }

    if (argsNum === 2) {
      cb = text
      text = canvas
      canvas = opts = undefined
    } else if (argsNum === 3) {
      if (canvas.getContext && typeof cb === 'undefined') {
        cb = opts
        opts = undefined
      } else {
        cb = opts
        opts = text
        text = canvas
        canvas = undefined
      }
    }
  } else {
    if (argsNum < 1) {
      throw new Error('Too few arguments provided')
    }

    if (argsNum === 1) {
      text = canvas
      canvas = opts = undefined
    } else if (argsNum === 2 && !canvas.getContext) {
      opts = text
      text = canvas
      canvas = undefined
    }

    return new Promise(function (resolve, reject) {
      try {
        const data = QRCode.create(text, opts)
        resolve(renderFunc(data, canvas, opts))
      } catch (e) {
        reject(e)
      }
    })
  }

  try {
    const data = QRCode.create(text, opts)
    cb(null, renderFunc(data, canvas, opts))
  } catch (e) {
    cb(e)
  }
}

exports.create = QRCode.create
exports.toCanvas = renderCanvas.bind(null, CanvasRenderer.render)
exports.toDataURL = renderCanvas.bind(null, CanvasRenderer.renderToDataURL)

// only svg for now.
exports.toString = renderCanvas.bind(null, function (data, _, opts) {
  return SvgRenderer.render(data, opts)
})


/***/ }),

/***/ "./node_modules/qrcode/lib/can-promise.js":
/*!************************************************!*\
  !*** ./node_modules/qrcode/lib/can-promise.js ***!
  \************************************************/
/***/ ((module) => {

// can-promise has a crash in some versions of react native that dont have
// standard global objects
// https://github.com/soldair/node-qrcode/issues/157

module.exports = function () {
  return typeof Promise === 'function' && Promise.prototype && Promise.prototype.then
}


/***/ }),

/***/ "./node_modules/qrcode/lib/core/alignment-pattern.js":
/*!***********************************************************!*\
  !*** ./node_modules/qrcode/lib/core/alignment-pattern.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/**
 * Alignment pattern are fixed reference pattern in defined positions
 * in a matrix symbology, which enables the decode software to re-synchronise
 * the coordinate mapping of the image modules in the event of moderate amounts
 * of distortion of the image.
 *
 * Alignment patterns are present only in QR Code symbols of version 2 or larger
 * and their number depends on the symbol version.
 */

const getSymbolSize = (__webpack_require__(/*! ./utils */ "./node_modules/qrcode/lib/core/utils.js").getSymbolSize)

/**
 * Calculate the row/column coordinates of the center module of each alignment pattern
 * for the specified QR Code version.
 *
 * The alignment patterns are positioned symmetrically on either side of the diagonal
 * running from the top left corner of the symbol to the bottom right corner.
 *
 * Since positions are simmetrical only half of the coordinates are returned.
 * Each item of the array will represent in turn the x and y coordinate.
 * @see {@link getPositions}
 *
 * @param  {Number} version QR Code version
 * @return {Array}          Array of coordinate
 */
exports.getRowColCoords = function getRowColCoords (version) {
  if (version === 1) return []

  const posCount = Math.floor(version / 7) + 2
  const size = getSymbolSize(version)
  const intervals = size === 145 ? 26 : Math.ceil((size - 13) / (2 * posCount - 2)) * 2
  const positions = [size - 7] // Last coord is always (size - 7)

  for (let i = 1; i < posCount - 1; i++) {
    positions[i] = positions[i - 1] - intervals
  }

  positions.push(6) // First coord is always 6

  return positions.reverse()
}

/**
 * Returns an array containing the positions of each alignment pattern.
 * Each array's element represent the center point of the pattern as (x, y) coordinates
 *
 * Coordinates are calculated expanding the row/column coordinates returned by {@link getRowColCoords}
 * and filtering out the items that overlaps with finder pattern
 *
 * @example
 * For a Version 7 symbol {@link getRowColCoords} returns values 6, 22 and 38.
 * The alignment patterns, therefore, are to be centered on (row, column)
 * positions (6,22), (22,6), (22,22), (22,38), (38,22), (38,38).
 * Note that the coordinates (6,6), (6,38), (38,6) are occupied by finder patterns
 * and are not therefore used for alignment patterns.
 *
 * let pos = getPositions(7)
 * // [[6,22], [22,6], [22,22], [22,38], [38,22], [38,38]]
 *
 * @param  {Number} version QR Code version
 * @return {Array}          Array of coordinates
 */
exports.getPositions = function getPositions (version) {
  const coords = []
  const pos = exports.getRowColCoords(version)
  const posLength = pos.length

  for (let i = 0; i < posLength; i++) {
    for (let j = 0; j < posLength; j++) {
      // Skip if position is occupied by finder patterns
      if ((i === 0 && j === 0) || // top-left
          (i === 0 && j === posLength - 1) || // bottom-left
          (i === posLength - 1 && j === 0)) { // top-right
        continue
      }

      coords.push([pos[i], pos[j]])
    }
  }

  return coords
}


/***/ }),

/***/ "./node_modules/qrcode/lib/core/alphanumeric-data.js":
/*!***********************************************************!*\
  !*** ./node_modules/qrcode/lib/core/alphanumeric-data.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Mode = __webpack_require__(/*! ./mode */ "./node_modules/qrcode/lib/core/mode.js")

/**
 * Array of characters available in alphanumeric mode
 *
 * As per QR Code specification, to each character
 * is assigned a value from 0 to 44 which in this case coincides
 * with the array index
 *
 * @type {Array}
 */
const ALPHA_NUM_CHARS = [
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
  'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
  ' ', '$', '%', '*', '+', '-', '.', '/', ':'
]

function AlphanumericData (data) {
  this.mode = Mode.ALPHANUMERIC
  this.data = data
}

AlphanumericData.getBitsLength = function getBitsLength (length) {
  return 11 * Math.floor(length / 2) + 6 * (length % 2)
}

AlphanumericData.prototype.getLength = function getLength () {
  return this.data.length
}

AlphanumericData.prototype.getBitsLength = function getBitsLength () {
  return AlphanumericData.getBitsLength(this.data.length)
}

AlphanumericData.prototype.write = function write (bitBuffer) {
  let i

  // Input data characters are divided into groups of two characters
  // and encoded as 11-bit binary codes.
  for (i = 0; i + 2 <= this.data.length; i += 2) {
    // The character value of the first character is multiplied by 45
    let value = ALPHA_NUM_CHARS.indexOf(this.data[i]) * 45

    // The character value of the second digit is added to the product
    value += ALPHA_NUM_CHARS.indexOf(this.data[i + 1])

    // The sum is then stored as 11-bit binary number
    bitBuffer.put(value, 11)
  }

  // If the number of input data characters is not a multiple of two,
  // the character value of the final character is encoded as a 6-bit binary number.
  if (this.data.length % 2) {
    bitBuffer.put(ALPHA_NUM_CHARS.indexOf(this.data[i]), 6)
  }
}

module.exports = AlphanumericData


/***/ }),

/***/ "./node_modules/qrcode/lib/core/bit-buffer.js":
/*!****************************************************!*\
  !*** ./node_modules/qrcode/lib/core/bit-buffer.js ***!
  \****************************************************/
/***/ ((module) => {

function BitBuffer () {
  this.buffer = []
  this.length = 0
}

BitBuffer.prototype = {

  get: function (index) {
    const bufIndex = Math.floor(index / 8)
    return ((this.buffer[bufIndex] >>> (7 - index % 8)) & 1) === 1
  },

  put: function (num, length) {
    for (let i = 0; i < length; i++) {
      this.putBit(((num >>> (length - i - 1)) & 1) === 1)
    }
  },

  getLengthInBits: function () {
    return this.length
  },

  putBit: function (bit) {
    const bufIndex = Math.floor(this.length / 8)
    if (this.buffer.length <= bufIndex) {
      this.buffer.push(0)
    }

    if (bit) {
      this.buffer[bufIndex] |= (0x80 >>> (this.length % 8))
    }

    this.length++
  }
}

module.exports = BitBuffer


/***/ }),

/***/ "./node_modules/qrcode/lib/core/bit-matrix.js":
/*!****************************************************!*\
  !*** ./node_modules/qrcode/lib/core/bit-matrix.js ***!
  \****************************************************/
/***/ ((module) => {

/**
 * Helper class to handle QR Code symbol modules
 *
 * @param {Number} size Symbol size
 */
function BitMatrix (size) {
  if (!size || size < 1) {
    throw new Error('BitMatrix size must be defined and greater than 0')
  }

  this.size = size
  this.data = new Uint8Array(size * size)
  this.reservedBit = new Uint8Array(size * size)
}

/**
 * Set bit value at specified location
 * If reserved flag is set, this bit will be ignored during masking process
 *
 * @param {Number}  row
 * @param {Number}  col
 * @param {Boolean} value
 * @param {Boolean} reserved
 */
BitMatrix.prototype.set = function (row, col, value, reserved) {
  const index = row * this.size + col
  this.data[index] = value
  if (reserved) this.reservedBit[index] = true
}

/**
 * Returns bit value at specified location
 *
 * @param  {Number}  row
 * @param  {Number}  col
 * @return {Boolean}
 */
BitMatrix.prototype.get = function (row, col) {
  return this.data[row * this.size + col]
}

/**
 * Applies xor operator at specified location
 * (used during masking process)
 *
 * @param {Number}  row
 * @param {Number}  col
 * @param {Boolean} value
 */
BitMatrix.prototype.xor = function (row, col, value) {
  this.data[row * this.size + col] ^= value
}

/**
 * Check if bit at specified location is reserved
 *
 * @param {Number}   row
 * @param {Number}   col
 * @return {Boolean}
 */
BitMatrix.prototype.isReserved = function (row, col) {
  return this.reservedBit[row * this.size + col]
}

module.exports = BitMatrix


/***/ }),

/***/ "./node_modules/qrcode/lib/core/byte-data.js":
/*!***************************************************!*\
  !*** ./node_modules/qrcode/lib/core/byte-data.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Mode = __webpack_require__(/*! ./mode */ "./node_modules/qrcode/lib/core/mode.js")

function ByteData (data) {
  this.mode = Mode.BYTE
  if (typeof (data) === 'string') {
    this.data = new TextEncoder().encode(data)
  } else {
    this.data = new Uint8Array(data)
  }
}

ByteData.getBitsLength = function getBitsLength (length) {
  return length * 8
}

ByteData.prototype.getLength = function getLength () {
  return this.data.length
}

ByteData.prototype.getBitsLength = function getBitsLength () {
  return ByteData.getBitsLength(this.data.length)
}

ByteData.prototype.write = function (bitBuffer) {
  for (let i = 0, l = this.data.length; i < l; i++) {
    bitBuffer.put(this.data[i], 8)
  }
}

module.exports = ByteData


/***/ }),

/***/ "./node_modules/qrcode/lib/core/error-correction-code.js":
/*!***************************************************************!*\
  !*** ./node_modules/qrcode/lib/core/error-correction-code.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

const ECLevel = __webpack_require__(/*! ./error-correction-level */ "./node_modules/qrcode/lib/core/error-correction-level.js")

const EC_BLOCKS_TABLE = [
// L  M  Q  H
  1, 1, 1, 1,
  1, 1, 1, 1,
  1, 1, 2, 2,
  1, 2, 2, 4,
  1, 2, 4, 4,
  2, 4, 4, 4,
  2, 4, 6, 5,
  2, 4, 6, 6,
  2, 5, 8, 8,
  4, 5, 8, 8,
  4, 5, 8, 11,
  4, 8, 10, 11,
  4, 9, 12, 16,
  4, 9, 16, 16,
  6, 10, 12, 18,
  6, 10, 17, 16,
  6, 11, 16, 19,
  6, 13, 18, 21,
  7, 14, 21, 25,
  8, 16, 20, 25,
  8, 17, 23, 25,
  9, 17, 23, 34,
  9, 18, 25, 30,
  10, 20, 27, 32,
  12, 21, 29, 35,
  12, 23, 34, 37,
  12, 25, 34, 40,
  13, 26, 35, 42,
  14, 28, 38, 45,
  15, 29, 40, 48,
  16, 31, 43, 51,
  17, 33, 45, 54,
  18, 35, 48, 57,
  19, 37, 51, 60,
  19, 38, 53, 63,
  20, 40, 56, 66,
  21, 43, 59, 70,
  22, 45, 62, 74,
  24, 47, 65, 77,
  25, 49, 68, 81
]

const EC_CODEWORDS_TABLE = [
// L  M  Q  H
  7, 10, 13, 17,
  10, 16, 22, 28,
  15, 26, 36, 44,
  20, 36, 52, 64,
  26, 48, 72, 88,
  36, 64, 96, 112,
  40, 72, 108, 130,
  48, 88, 132, 156,
  60, 110, 160, 192,
  72, 130, 192, 224,
  80, 150, 224, 264,
  96, 176, 260, 308,
  104, 198, 288, 352,
  120, 216, 320, 384,
  132, 240, 360, 432,
  144, 280, 408, 480,
  168, 308, 448, 532,
  180, 338, 504, 588,
  196, 364, 546, 650,
  224, 416, 600, 700,
  224, 442, 644, 750,
  252, 476, 690, 816,
  270, 504, 750, 900,
  300, 560, 810, 960,
  312, 588, 870, 1050,
  336, 644, 952, 1110,
  360, 700, 1020, 1200,
  390, 728, 1050, 1260,
  420, 784, 1140, 1350,
  450, 812, 1200, 1440,
  480, 868, 1290, 1530,
  510, 924, 1350, 1620,
  540, 980, 1440, 1710,
  570, 1036, 1530, 1800,
  570, 1064, 1590, 1890,
  600, 1120, 1680, 1980,
  630, 1204, 1770, 2100,
  660, 1260, 1860, 2220,
  720, 1316, 1950, 2310,
  750, 1372, 2040, 2430
]

/**
 * Returns the number of error correction block that the QR Code should contain
 * for the specified version and error correction level.
 *
 * @param  {Number} version              QR Code version
 * @param  {Number} errorCorrectionLevel Error correction level
 * @return {Number}                      Number of error correction blocks
 */
exports.getBlocksCount = function getBlocksCount (version, errorCorrectionLevel) {
  switch (errorCorrectionLevel) {
    case ECLevel.L:
      return EC_BLOCKS_TABLE[(version - 1) * 4 + 0]
    case ECLevel.M:
      return EC_BLOCKS_TABLE[(version - 1) * 4 + 1]
    case ECLevel.Q:
      return EC_BLOCKS_TABLE[(version - 1) * 4 + 2]
    case ECLevel.H:
      return EC_BLOCKS_TABLE[(version - 1) * 4 + 3]
    default:
      return undefined
  }
}

/**
 * Returns the number of error correction codewords to use for the specified
 * version and error correction level.
 *
 * @param  {Number} version              QR Code version
 * @param  {Number} errorCorrectionLevel Error correction level
 * @return {Number}                      Number of error correction codewords
 */
exports.getTotalCodewordsCount = function getTotalCodewordsCount (version, errorCorrectionLevel) {
  switch (errorCorrectionLevel) {
    case ECLevel.L:
      return EC_CODEWORDS_TABLE[(version - 1) * 4 + 0]
    case ECLevel.M:
      return EC_CODEWORDS_TABLE[(version - 1) * 4 + 1]
    case ECLevel.Q:
      return EC_CODEWORDS_TABLE[(version - 1) * 4 + 2]
    case ECLevel.H:
      return EC_CODEWORDS_TABLE[(version - 1) * 4 + 3]
    default:
      return undefined
  }
}


/***/ }),

/***/ "./node_modules/qrcode/lib/core/error-correction-level.js":
/*!****************************************************************!*\
  !*** ./node_modules/qrcode/lib/core/error-correction-level.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports) => {

exports.L = { bit: 1 }
exports.M = { bit: 0 }
exports.Q = { bit: 3 }
exports.H = { bit: 2 }

function fromString (string) {
  if (typeof string !== 'string') {
    throw new Error('Param is not a string')
  }

  const lcStr = string.toLowerCase()

  switch (lcStr) {
    case 'l':
    case 'low':
      return exports.L

    case 'm':
    case 'medium':
      return exports.M

    case 'q':
    case 'quartile':
      return exports.Q

    case 'h':
    case 'high':
      return exports.H

    default:
      throw new Error('Unknown EC Level: ' + string)
  }
}

exports.isValid = function isValid (level) {
  return level && typeof level.bit !== 'undefined' &&
    level.bit >= 0 && level.bit < 4
}

exports.from = function from (value, defaultValue) {
  if (exports.isValid(value)) {
    return value
  }

  try {
    return fromString(value)
  } catch (e) {
    return defaultValue
  }
}


/***/ }),

/***/ "./node_modules/qrcode/lib/core/finder-pattern.js":
/*!********************************************************!*\
  !*** ./node_modules/qrcode/lib/core/finder-pattern.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

const getSymbolSize = (__webpack_require__(/*! ./utils */ "./node_modules/qrcode/lib/core/utils.js").getSymbolSize)
const FINDER_PATTERN_SIZE = 7

/**
 * Returns an array containing the positions of each finder pattern.
 * Each array's element represent the top-left point of the pattern as (x, y) coordinates
 *
 * @param  {Number} version QR Code version
 * @return {Array}          Array of coordinates
 */
exports.getPositions = function getPositions (version) {
  const size = getSymbolSize(version)

  return [
    // top-left
    [0, 0],
    // top-right
    [size - FINDER_PATTERN_SIZE, 0],
    // bottom-left
    [0, size - FINDER_PATTERN_SIZE]
  ]
}


/***/ }),

/***/ "./node_modules/qrcode/lib/core/format-info.js":
/*!*****************************************************!*\
  !*** ./node_modules/qrcode/lib/core/format-info.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

const Utils = __webpack_require__(/*! ./utils */ "./node_modules/qrcode/lib/core/utils.js")

const G15 = (1 << 10) | (1 << 8) | (1 << 5) | (1 << 4) | (1 << 2) | (1 << 1) | (1 << 0)
const G15_MASK = (1 << 14) | (1 << 12) | (1 << 10) | (1 << 4) | (1 << 1)
const G15_BCH = Utils.getBCHDigit(G15)

/**
 * Returns format information with relative error correction bits
 *
 * The format information is a 15-bit sequence containing 5 data bits,
 * with 10 error correction bits calculated using the (15, 5) BCH code.
 *
 * @param  {Number} errorCorrectionLevel Error correction level
 * @param  {Number} mask                 Mask pattern
 * @return {Number}                      Encoded format information bits
 */
exports.getEncodedBits = function getEncodedBits (errorCorrectionLevel, mask) {
  const data = ((errorCorrectionLevel.bit << 3) | mask)
  let d = data << 10

  while (Utils.getBCHDigit(d) - G15_BCH >= 0) {
    d ^= (G15 << (Utils.getBCHDigit(d) - G15_BCH))
  }

  // xor final data with mask pattern in order to ensure that
  // no combination of Error Correction Level and data mask pattern
  // will result in an all-zero data string
  return ((data << 10) | d) ^ G15_MASK
}


/***/ }),

/***/ "./node_modules/qrcode/lib/core/galois-field.js":
/*!******************************************************!*\
  !*** ./node_modules/qrcode/lib/core/galois-field.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports) => {

const EXP_TABLE = new Uint8Array(512)
const LOG_TABLE = new Uint8Array(256)
/**
 * Precompute the log and anti-log tables for faster computation later
 *
 * For each possible value in the galois field 2^8, we will pre-compute
 * the logarithm and anti-logarithm (exponential) of this value
 *
 * ref {@link https://en.wikiversity.org/wiki/Reed%E2%80%93Solomon_codes_for_coders#Introduction_to_mathematical_fields}
 */
;(function initTables () {
  let x = 1
  for (let i = 0; i < 255; i++) {
    EXP_TABLE[i] = x
    LOG_TABLE[x] = i

    x <<= 1 // multiply by 2

    // The QR code specification says to use byte-wise modulo 100011101 arithmetic.
    // This means that when a number is 256 or larger, it should be XORed with 0x11D.
    if (x & 0x100) { // similar to x >= 256, but a lot faster (because 0x100 == 256)
      x ^= 0x11D
    }
  }

  // Optimization: double the size of the anti-log table so that we don't need to mod 255 to
  // stay inside the bounds (because we will mainly use this table for the multiplication of
  // two GF numbers, no more).
  // @see {@link mul}
  for (let i = 255; i < 512; i++) {
    EXP_TABLE[i] = EXP_TABLE[i - 255]
  }
}())

/**
 * Returns log value of n inside Galois Field
 *
 * @param  {Number} n
 * @return {Number}
 */
exports.log = function log (n) {
  if (n < 1) throw new Error('log(' + n + ')')
  return LOG_TABLE[n]
}

/**
 * Returns anti-log value of n inside Galois Field
 *
 * @param  {Number} n
 * @return {Number}
 */
exports.exp = function exp (n) {
  return EXP_TABLE[n]
}

/**
 * Multiplies two number inside Galois Field
 *
 * @param  {Number} x
 * @param  {Number} y
 * @return {Number}
 */
exports.mul = function mul (x, y) {
  if (x === 0 || y === 0) return 0

  // should be EXP_TABLE[(LOG_TABLE[x] + LOG_TABLE[y]) % 255] if EXP_TABLE wasn't oversized
  // @see {@link initTables}
  return EXP_TABLE[LOG_TABLE[x] + LOG_TABLE[y]]
}


/***/ }),

/***/ "./node_modules/qrcode/lib/core/kanji-data.js":
/*!****************************************************!*\
  !*** ./node_modules/qrcode/lib/core/kanji-data.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Mode = __webpack_require__(/*! ./mode */ "./node_modules/qrcode/lib/core/mode.js")
const Utils = __webpack_require__(/*! ./utils */ "./node_modules/qrcode/lib/core/utils.js")

function KanjiData (data) {
  this.mode = Mode.KANJI
  this.data = data
}

KanjiData.getBitsLength = function getBitsLength (length) {
  return length * 13
}

KanjiData.prototype.getLength = function getLength () {
  return this.data.length
}

KanjiData.prototype.getBitsLength = function getBitsLength () {
  return KanjiData.getBitsLength(this.data.length)
}

KanjiData.prototype.write = function (bitBuffer) {
  let i

  // In the Shift JIS system, Kanji characters are represented by a two byte combination.
  // These byte values are shifted from the JIS X 0208 values.
  // JIS X 0208 gives details of the shift coded representation.
  for (i = 0; i < this.data.length; i++) {
    let value = Utils.toSJIS(this.data[i])

    // For characters with Shift JIS values from 0x8140 to 0x9FFC:
    if (value >= 0x8140 && value <= 0x9FFC) {
      // Subtract 0x8140 from Shift JIS value
      value -= 0x8140

    // For characters with Shift JIS values from 0xE040 to 0xEBBF
    } else if (value >= 0xE040 && value <= 0xEBBF) {
      // Subtract 0xC140 from Shift JIS value
      value -= 0xC140
    } else {
      throw new Error(
        'Invalid SJIS character: ' + this.data[i] + '\n' +
        'Make sure your charset is UTF-8')
    }

    // Multiply most significant byte of result by 0xC0
    // and add least significant byte to product
    value = (((value >>> 8) & 0xff) * 0xC0) + (value & 0xff)

    // Convert result to a 13-bit binary string
    bitBuffer.put(value, 13)
  }
}

module.exports = KanjiData


/***/ }),

/***/ "./node_modules/qrcode/lib/core/mask-pattern.js":
/*!******************************************************!*\
  !*** ./node_modules/qrcode/lib/core/mask-pattern.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports) => {

/**
 * Data mask pattern reference
 * @type {Object}
 */
exports.Patterns = {
  PATTERN000: 0,
  PATTERN001: 1,
  PATTERN010: 2,
  PATTERN011: 3,
  PATTERN100: 4,
  PATTERN101: 5,
  PATTERN110: 6,
  PATTERN111: 7
}

/**
 * Weighted penalty scores for the undesirable features
 * @type {Object}
 */
const PenaltyScores = {
  N1: 3,
  N2: 3,
  N3: 40,
  N4: 10
}

/**
 * Check if mask pattern value is valid
 *
 * @param  {Number}  mask    Mask pattern
 * @return {Boolean}         true if valid, false otherwise
 */
exports.isValid = function isValid (mask) {
  return mask != null && mask !== '' && !isNaN(mask) && mask >= 0 && mask <= 7
}

/**
 * Returns mask pattern from a value.
 * If value is not valid, returns undefined
 *
 * @param  {Number|String} value        Mask pattern value
 * @return {Number}                     Valid mask pattern or undefined
 */
exports.from = function from (value) {
  return exports.isValid(value) ? parseInt(value, 10) : undefined
}

/**
* Find adjacent modules in row/column with the same color
* and assign a penalty value.
*
* Points: N1 + i
* i is the amount by which the number of adjacent modules of the same color exceeds 5
*/
exports.getPenaltyN1 = function getPenaltyN1 (data) {
  const size = data.size
  let points = 0
  let sameCountCol = 0
  let sameCountRow = 0
  let lastCol = null
  let lastRow = null

  for (let row = 0; row < size; row++) {
    sameCountCol = sameCountRow = 0
    lastCol = lastRow = null

    for (let col = 0; col < size; col++) {
      let module = data.get(row, col)
      if (module === lastCol) {
        sameCountCol++
      } else {
        if (sameCountCol >= 5) points += PenaltyScores.N1 + (sameCountCol - 5)
        lastCol = module
        sameCountCol = 1
      }

      module = data.get(col, row)
      if (module === lastRow) {
        sameCountRow++
      } else {
        if (sameCountRow >= 5) points += PenaltyScores.N1 + (sameCountRow - 5)
        lastRow = module
        sameCountRow = 1
      }
    }

    if (sameCountCol >= 5) points += PenaltyScores.N1 + (sameCountCol - 5)
    if (sameCountRow >= 5) points += PenaltyScores.N1 + (sameCountRow - 5)
  }

  return points
}

/**
 * Find 2x2 blocks with the same color and assign a penalty value
 *
 * Points: N2 * (m - 1) * (n - 1)
 */
exports.getPenaltyN2 = function getPenaltyN2 (data) {
  const size = data.size
  let points = 0

  for (let row = 0; row < size - 1; row++) {
    for (let col = 0; col < size - 1; col++) {
      const last = data.get(row, col) +
        data.get(row, col + 1) +
        data.get(row + 1, col) +
        data.get(row + 1, col + 1)

      if (last === 4 || last === 0) points++
    }
  }

  return points * PenaltyScores.N2
}

/**
 * Find 1:1:3:1:1 ratio (dark:light:dark:light:dark) pattern in row/column,
 * preceded or followed by light area 4 modules wide
 *
 * Points: N3 * number of pattern found
 */
exports.getPenaltyN3 = function getPenaltyN3 (data) {
  const size = data.size
  let points = 0
  let bitsCol = 0
  let bitsRow = 0

  for (let row = 0; row < size; row++) {
    bitsCol = bitsRow = 0
    for (let col = 0; col < size; col++) {
      bitsCol = ((bitsCol << 1) & 0x7FF) | data.get(row, col)
      if (col >= 10 && (bitsCol === 0x5D0 || bitsCol === 0x05D)) points++

      bitsRow = ((bitsRow << 1) & 0x7FF) | data.get(col, row)
      if (col >= 10 && (bitsRow === 0x5D0 || bitsRow === 0x05D)) points++
    }
  }

  return points * PenaltyScores.N3
}

/**
 * Calculate proportion of dark modules in entire symbol
 *
 * Points: N4 * k
 *
 * k is the rating of the deviation of the proportion of dark modules
 * in the symbol from 50% in steps of 5%
 */
exports.getPenaltyN4 = function getPenaltyN4 (data) {
  let darkCount = 0
  const modulesCount = data.data.length

  for (let i = 0; i < modulesCount; i++) darkCount += data.data[i]

  const k = Math.abs(Math.ceil((darkCount * 100 / modulesCount) / 5) - 10)

  return k * PenaltyScores.N4
}

/**
 * Return mask value at given position
 *
 * @param  {Number} maskPattern Pattern reference value
 * @param  {Number} i           Row
 * @param  {Number} j           Column
 * @return {Boolean}            Mask value
 */
function getMaskAt (maskPattern, i, j) {
  switch (maskPattern) {
    case exports.Patterns.PATTERN000: return (i + j) % 2 === 0
    case exports.Patterns.PATTERN001: return i % 2 === 0
    case exports.Patterns.PATTERN010: return j % 3 === 0
    case exports.Patterns.PATTERN011: return (i + j) % 3 === 0
    case exports.Patterns.PATTERN100: return (Math.floor(i / 2) + Math.floor(j / 3)) % 2 === 0
    case exports.Patterns.PATTERN101: return (i * j) % 2 + (i * j) % 3 === 0
    case exports.Patterns.PATTERN110: return ((i * j) % 2 + (i * j) % 3) % 2 === 0
    case exports.Patterns.PATTERN111: return ((i * j) % 3 + (i + j) % 2) % 2 === 0

    default: throw new Error('bad maskPattern:' + maskPattern)
  }
}

/**
 * Apply a mask pattern to a BitMatrix
 *
 * @param  {Number}    pattern Pattern reference number
 * @param  {BitMatrix} data    BitMatrix data
 */
exports.applyMask = function applyMask (pattern, data) {
  const size = data.size

  for (let col = 0; col < size; col++) {
    for (let row = 0; row < size; row++) {
      if (data.isReserved(row, col)) continue
      data.xor(row, col, getMaskAt(pattern, row, col))
    }
  }
}

/**
 * Returns the best mask pattern for data
 *
 * @param  {BitMatrix} data
 * @return {Number} Mask pattern reference number
 */
exports.getBestMask = function getBestMask (data, setupFormatFunc) {
  const numPatterns = Object.keys(exports.Patterns).length
  let bestPattern = 0
  let lowerPenalty = Infinity

  for (let p = 0; p < numPatterns; p++) {
    setupFormatFunc(p)
    exports.applyMask(p, data)

    // Calculate penalty
    const penalty =
      exports.getPenaltyN1(data) +
      exports.getPenaltyN2(data) +
      exports.getPenaltyN3(data) +
      exports.getPenaltyN4(data)

    // Undo previously applied mask
    exports.applyMask(p, data)

    if (penalty < lowerPenalty) {
      lowerPenalty = penalty
      bestPattern = p
    }
  }

  return bestPattern
}


/***/ }),

/***/ "./node_modules/qrcode/lib/core/mode.js":
/*!**********************************************!*\
  !*** ./node_modules/qrcode/lib/core/mode.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

const VersionCheck = __webpack_require__(/*! ./version-check */ "./node_modules/qrcode/lib/core/version-check.js")
const Regex = __webpack_require__(/*! ./regex */ "./node_modules/qrcode/lib/core/regex.js")

/**
 * Numeric mode encodes data from the decimal digit set (0 - 9)
 * (byte values 30HEX to 39HEX).
 * Normally, 3 data characters are represented by 10 bits.
 *
 * @type {Object}
 */
exports.NUMERIC = {
  id: 'Numeric',
  bit: 1 << 0,
  ccBits: [10, 12, 14]
}

/**
 * Alphanumeric mode encodes data from a set of 45 characters,
 * i.e. 10 numeric digits (0 - 9),
 *      26 alphabetic characters (A - Z),
 *   and 9 symbols (SP, $, %, *, +, -, ., /, :).
 * Normally, two input characters are represented by 11 bits.
 *
 * @type {Object}
 */
exports.ALPHANUMERIC = {
  id: 'Alphanumeric',
  bit: 1 << 1,
  ccBits: [9, 11, 13]
}

/**
 * In byte mode, data is encoded at 8 bits per character.
 *
 * @type {Object}
 */
exports.BYTE = {
  id: 'Byte',
  bit: 1 << 2,
  ccBits: [8, 16, 16]
}

/**
 * The Kanji mode efficiently encodes Kanji characters in accordance with
 * the Shift JIS system based on JIS X 0208.
 * The Shift JIS values are shifted from the JIS X 0208 values.
 * JIS X 0208 gives details of the shift coded representation.
 * Each two-byte character value is compacted to a 13-bit binary codeword.
 *
 * @type {Object}
 */
exports.KANJI = {
  id: 'Kanji',
  bit: 1 << 3,
  ccBits: [8, 10, 12]
}

/**
 * Mixed mode will contain a sequences of data in a combination of any of
 * the modes described above
 *
 * @type {Object}
 */
exports.MIXED = {
  bit: -1
}

/**
 * Returns the number of bits needed to store the data length
 * according to QR Code specifications.
 *
 * @param  {Mode}   mode    Data mode
 * @param  {Number} version QR Code version
 * @return {Number}         Number of bits
 */
exports.getCharCountIndicator = function getCharCountIndicator (mode, version) {
  if (!mode.ccBits) throw new Error('Invalid mode: ' + mode)

  if (!VersionCheck.isValid(version)) {
    throw new Error('Invalid version: ' + version)
  }

  if (version >= 1 && version < 10) return mode.ccBits[0]
  else if (version < 27) return mode.ccBits[1]
  return mode.ccBits[2]
}

/**
 * Returns the most efficient mode to store the specified data
 *
 * @param  {String} dataStr Input data string
 * @return {Mode}           Best mode
 */
exports.getBestModeForData = function getBestModeForData (dataStr) {
  if (Regex.testNumeric(dataStr)) return exports.NUMERIC
  else if (Regex.testAlphanumeric(dataStr)) return exports.ALPHANUMERIC
  else if (Regex.testKanji(dataStr)) return exports.KANJI
  else return exports.BYTE
}

/**
 * Return mode name as string
 *
 * @param {Mode} mode Mode object
 * @returns {String}  Mode name
 */
exports.toString = function toString (mode) {
  if (mode && mode.id) return mode.id
  throw new Error('Invalid mode')
}

/**
 * Check if input param is a valid mode object
 *
 * @param   {Mode}    mode Mode object
 * @returns {Boolean} True if valid mode, false otherwise
 */
exports.isValid = function isValid (mode) {
  return mode && mode.bit && mode.ccBits
}

/**
 * Get mode object from its name
 *
 * @param   {String} string Mode name
 * @returns {Mode}          Mode object
 */
function fromString (string) {
  if (typeof string !== 'string') {
    throw new Error('Param is not a string')
  }

  const lcStr = string.toLowerCase()

  switch (lcStr) {
    case 'numeric':
      return exports.NUMERIC
    case 'alphanumeric':
      return exports.ALPHANUMERIC
    case 'kanji':
      return exports.KANJI
    case 'byte':
      return exports.BYTE
    default:
      throw new Error('Unknown mode: ' + string)
  }
}

/**
 * Returns mode from a value.
 * If value is not a valid mode, returns defaultValue
 *
 * @param  {Mode|String} value        Encoding mode
 * @param  {Mode}        defaultValue Fallback value
 * @return {Mode}                     Encoding mode
 */
exports.from = function from (value, defaultValue) {
  if (exports.isValid(value)) {
    return value
  }

  try {
    return fromString(value)
  } catch (e) {
    return defaultValue
  }
}


/***/ }),

/***/ "./node_modules/qrcode/lib/core/numeric-data.js":
/*!******************************************************!*\
  !*** ./node_modules/qrcode/lib/core/numeric-data.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Mode = __webpack_require__(/*! ./mode */ "./node_modules/qrcode/lib/core/mode.js")

function NumericData (data) {
  this.mode = Mode.NUMERIC
  this.data = data.toString()
}

NumericData.getBitsLength = function getBitsLength (length) {
  return 10 * Math.floor(length / 3) + ((length % 3) ? ((length % 3) * 3 + 1) : 0)
}

NumericData.prototype.getLength = function getLength () {
  return this.data.length
}

NumericData.prototype.getBitsLength = function getBitsLength () {
  return NumericData.getBitsLength(this.data.length)
}

NumericData.prototype.write = function write (bitBuffer) {
  let i, group, value

  // The input data string is divided into groups of three digits,
  // and each group is converted to its 10-bit binary equivalent.
  for (i = 0; i + 3 <= this.data.length; i += 3) {
    group = this.data.substr(i, 3)
    value = parseInt(group, 10)

    bitBuffer.put(value, 10)
  }

  // If the number of input digits is not an exact multiple of three,
  // the final one or two digits are converted to 4 or 7 bits respectively.
  const remainingNum = this.data.length - i
  if (remainingNum > 0) {
    group = this.data.substr(i)
    value = parseInt(group, 10)

    bitBuffer.put(value, remainingNum * 3 + 1)
  }
}

module.exports = NumericData


/***/ }),

/***/ "./node_modules/qrcode/lib/core/polynomial.js":
/*!****************************************************!*\
  !*** ./node_modules/qrcode/lib/core/polynomial.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

const GF = __webpack_require__(/*! ./galois-field */ "./node_modules/qrcode/lib/core/galois-field.js")

/**
 * Multiplies two polynomials inside Galois Field
 *
 * @param  {Uint8Array} p1 Polynomial
 * @param  {Uint8Array} p2 Polynomial
 * @return {Uint8Array}    Product of p1 and p2
 */
exports.mul = function mul (p1, p2) {
  const coeff = new Uint8Array(p1.length + p2.length - 1)

  for (let i = 0; i < p1.length; i++) {
    for (let j = 0; j < p2.length; j++) {
      coeff[i + j] ^= GF.mul(p1[i], p2[j])
    }
  }

  return coeff
}

/**
 * Calculate the remainder of polynomials division
 *
 * @param  {Uint8Array} divident Polynomial
 * @param  {Uint8Array} divisor  Polynomial
 * @return {Uint8Array}          Remainder
 */
exports.mod = function mod (divident, divisor) {
  let result = new Uint8Array(divident)

  while ((result.length - divisor.length) >= 0) {
    const coeff = result[0]

    for (let i = 0; i < divisor.length; i++) {
      result[i] ^= GF.mul(divisor[i], coeff)
    }

    // remove all zeros from buffer head
    let offset = 0
    while (offset < result.length && result[offset] === 0) offset++
    result = result.slice(offset)
  }

  return result
}

/**
 * Generate an irreducible generator polynomial of specified degree
 * (used by Reed-Solomon encoder)
 *
 * @param  {Number} degree Degree of the generator polynomial
 * @return {Uint8Array}    Buffer containing polynomial coefficients
 */
exports.generateECPolynomial = function generateECPolynomial (degree) {
  let poly = new Uint8Array([1])
  for (let i = 0; i < degree; i++) {
    poly = exports.mul(poly, new Uint8Array([1, GF.exp(i)]))
  }

  return poly
}


/***/ }),

/***/ "./node_modules/qrcode/lib/core/qrcode.js":
/*!************************************************!*\
  !*** ./node_modules/qrcode/lib/core/qrcode.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

const Utils = __webpack_require__(/*! ./utils */ "./node_modules/qrcode/lib/core/utils.js")
const ECLevel = __webpack_require__(/*! ./error-correction-level */ "./node_modules/qrcode/lib/core/error-correction-level.js")
const BitBuffer = __webpack_require__(/*! ./bit-buffer */ "./node_modules/qrcode/lib/core/bit-buffer.js")
const BitMatrix = __webpack_require__(/*! ./bit-matrix */ "./node_modules/qrcode/lib/core/bit-matrix.js")
const AlignmentPattern = __webpack_require__(/*! ./alignment-pattern */ "./node_modules/qrcode/lib/core/alignment-pattern.js")
const FinderPattern = __webpack_require__(/*! ./finder-pattern */ "./node_modules/qrcode/lib/core/finder-pattern.js")
const MaskPattern = __webpack_require__(/*! ./mask-pattern */ "./node_modules/qrcode/lib/core/mask-pattern.js")
const ECCode = __webpack_require__(/*! ./error-correction-code */ "./node_modules/qrcode/lib/core/error-correction-code.js")
const ReedSolomonEncoder = __webpack_require__(/*! ./reed-solomon-encoder */ "./node_modules/qrcode/lib/core/reed-solomon-encoder.js")
const Version = __webpack_require__(/*! ./version */ "./node_modules/qrcode/lib/core/version.js")
const FormatInfo = __webpack_require__(/*! ./format-info */ "./node_modules/qrcode/lib/core/format-info.js")
const Mode = __webpack_require__(/*! ./mode */ "./node_modules/qrcode/lib/core/mode.js")
const Segments = __webpack_require__(/*! ./segments */ "./node_modules/qrcode/lib/core/segments.js")

/**
 * QRCode for JavaScript
 *
 * modified by Ryan Day for nodejs support
 * Copyright (c) 2011 Ryan Day
 *
 * Licensed under the MIT license:
 *   http://www.opensource.org/licenses/mit-license.php
 *
//---------------------------------------------------------------------
// QRCode for JavaScript
//
// Copyright (c) 2009 Kazuhiko Arase
//
// URL: http://www.d-project.com/
//
// Licensed under the MIT license:
//   http://www.opensource.org/licenses/mit-license.php
//
// The word "QR Code" is registered trademark of
// DENSO WAVE INCORPORATED
//   http://www.denso-wave.com/qrcode/faqpatent-e.html
//
//---------------------------------------------------------------------
*/

/**
 * Add finder patterns bits to matrix
 *
 * @param  {BitMatrix} matrix  Modules matrix
 * @param  {Number}    version QR Code version
 */
function setupFinderPattern (matrix, version) {
  const size = matrix.size
  const pos = FinderPattern.getPositions(version)

  for (let i = 0; i < pos.length; i++) {
    const row = pos[i][0]
    const col = pos[i][1]

    for (let r = -1; r <= 7; r++) {
      if (row + r <= -1 || size <= row + r) continue

      for (let c = -1; c <= 7; c++) {
        if (col + c <= -1 || size <= col + c) continue

        if ((r >= 0 && r <= 6 && (c === 0 || c === 6)) ||
          (c >= 0 && c <= 6 && (r === 0 || r === 6)) ||
          (r >= 2 && r <= 4 && c >= 2 && c <= 4)) {
          matrix.set(row + r, col + c, true, true)
        } else {
          matrix.set(row + r, col + c, false, true)
        }
      }
    }
  }
}

/**
 * Add timing pattern bits to matrix
 *
 * Note: this function must be called before {@link setupAlignmentPattern}
 *
 * @param  {BitMatrix} matrix Modules matrix
 */
function setupTimingPattern (matrix) {
  const size = matrix.size

  for (let r = 8; r < size - 8; r++) {
    const value = r % 2 === 0
    matrix.set(r, 6, value, true)
    matrix.set(6, r, value, true)
  }
}

/**
 * Add alignment patterns bits to matrix
 *
 * Note: this function must be called after {@link setupTimingPattern}
 *
 * @param  {BitMatrix} matrix  Modules matrix
 * @param  {Number}    version QR Code version
 */
function setupAlignmentPattern (matrix, version) {
  const pos = AlignmentPattern.getPositions(version)

  for (let i = 0; i < pos.length; i++) {
    const row = pos[i][0]
    const col = pos[i][1]

    for (let r = -2; r <= 2; r++) {
      for (let c = -2; c <= 2; c++) {
        if (r === -2 || r === 2 || c === -2 || c === 2 ||
          (r === 0 && c === 0)) {
          matrix.set(row + r, col + c, true, true)
        } else {
          matrix.set(row + r, col + c, false, true)
        }
      }
    }
  }
}

/**
 * Add version info bits to matrix
 *
 * @param  {BitMatrix} matrix  Modules matrix
 * @param  {Number}    version QR Code version
 */
function setupVersionInfo (matrix, version) {
  const size = matrix.size
  const bits = Version.getEncodedBits(version)
  let row, col, mod

  for (let i = 0; i < 18; i++) {
    row = Math.floor(i / 3)
    col = i % 3 + size - 8 - 3
    mod = ((bits >> i) & 1) === 1

    matrix.set(row, col, mod, true)
    matrix.set(col, row, mod, true)
  }
}

/**
 * Add format info bits to matrix
 *
 * @param  {BitMatrix} matrix               Modules matrix
 * @param  {ErrorCorrectionLevel}    errorCorrectionLevel Error correction level
 * @param  {Number}    maskPattern          Mask pattern reference value
 */
function setupFormatInfo (matrix, errorCorrectionLevel, maskPattern) {
  const size = matrix.size
  const bits = FormatInfo.getEncodedBits(errorCorrectionLevel, maskPattern)
  let i, mod

  for (i = 0; i < 15; i++) {
    mod = ((bits >> i) & 1) === 1

    // vertical
    if (i < 6) {
      matrix.set(i, 8, mod, true)
    } else if (i < 8) {
      matrix.set(i + 1, 8, mod, true)
    } else {
      matrix.set(size - 15 + i, 8, mod, true)
    }

    // horizontal
    if (i < 8) {
      matrix.set(8, size - i - 1, mod, true)
    } else if (i < 9) {
      matrix.set(8, 15 - i - 1 + 1, mod, true)
    } else {
      matrix.set(8, 15 - i - 1, mod, true)
    }
  }

  // fixed module
  matrix.set(size - 8, 8, 1, true)
}

/**
 * Add encoded data bits to matrix
 *
 * @param  {BitMatrix}  matrix Modules matrix
 * @param  {Uint8Array} data   Data codewords
 */
function setupData (matrix, data) {
  const size = matrix.size
  let inc = -1
  let row = size - 1
  let bitIndex = 7
  let byteIndex = 0

  for (let col = size - 1; col > 0; col -= 2) {
    if (col === 6) col--

    while (true) {
      for (let c = 0; c < 2; c++) {
        if (!matrix.isReserved(row, col - c)) {
          let dark = false

          if (byteIndex < data.length) {
            dark = (((data[byteIndex] >>> bitIndex) & 1) === 1)
          }

          matrix.set(row, col - c, dark)
          bitIndex--

          if (bitIndex === -1) {
            byteIndex++
            bitIndex = 7
          }
        }
      }

      row += inc

      if (row < 0 || size <= row) {
        row -= inc
        inc = -inc
        break
      }
    }
  }
}

/**
 * Create encoded codewords from data input
 *
 * @param  {Number}   version              QR Code version
 * @param  {ErrorCorrectionLevel}   errorCorrectionLevel Error correction level
 * @param  {ByteData} data                 Data input
 * @return {Uint8Array}                    Buffer containing encoded codewords
 */
function createData (version, errorCorrectionLevel, segments) {
  // Prepare data buffer
  const buffer = new BitBuffer()

  segments.forEach(function (data) {
    // prefix data with mode indicator (4 bits)
    buffer.put(data.mode.bit, 4)

    // Prefix data with character count indicator.
    // The character count indicator is a string of bits that represents the
    // number of characters that are being encoded.
    // The character count indicator must be placed after the mode indicator
    // and must be a certain number of bits long, depending on the QR version
    // and data mode
    // @see {@link Mode.getCharCountIndicator}.
    buffer.put(data.getLength(), Mode.getCharCountIndicator(data.mode, version))

    // add binary data sequence to buffer
    data.write(buffer)
  })

  // Calculate required number of bits
  const totalCodewords = Utils.getSymbolTotalCodewords(version)
  const ecTotalCodewords = ECCode.getTotalCodewordsCount(version, errorCorrectionLevel)
  const dataTotalCodewordsBits = (totalCodewords - ecTotalCodewords) * 8

  // Add a terminator.
  // If the bit string is shorter than the total number of required bits,
  // a terminator of up to four 0s must be added to the right side of the string.
  // If the bit string is more than four bits shorter than the required number of bits,
  // add four 0s to the end.
  if (buffer.getLengthInBits() + 4 <= dataTotalCodewordsBits) {
    buffer.put(0, 4)
  }

  // If the bit string is fewer than four bits shorter, add only the number of 0s that
  // are needed to reach the required number of bits.

  // After adding the terminator, if the number of bits in the string is not a multiple of 8,
  // pad the string on the right with 0s to make the string's length a multiple of 8.
  while (buffer.getLengthInBits() % 8 !== 0) {
    buffer.putBit(0)
  }

  // Add pad bytes if the string is still shorter than the total number of required bits.
  // Extend the buffer to fill the data capacity of the symbol corresponding to
  // the Version and Error Correction Level by adding the Pad Codewords 11101100 (0xEC)
  // and 00010001 (0x11) alternately.
  const remainingByte = (dataTotalCodewordsBits - buffer.getLengthInBits()) / 8
  for (let i = 0; i < remainingByte; i++) {
    buffer.put(i % 2 ? 0x11 : 0xEC, 8)
  }

  return createCodewords(buffer, version, errorCorrectionLevel)
}

/**
 * Encode input data with Reed-Solomon and return codewords with
 * relative error correction bits
 *
 * @param  {BitBuffer} bitBuffer            Data to encode
 * @param  {Number}    version              QR Code version
 * @param  {ErrorCorrectionLevel} errorCorrectionLevel Error correction level
 * @return {Uint8Array}                     Buffer containing encoded codewords
 */
function createCodewords (bitBuffer, version, errorCorrectionLevel) {
  // Total codewords for this QR code version (Data + Error correction)
  const totalCodewords = Utils.getSymbolTotalCodewords(version)

  // Total number of error correction codewords
  const ecTotalCodewords = ECCode.getTotalCodewordsCount(version, errorCorrectionLevel)

  // Total number of data codewords
  const dataTotalCodewords = totalCodewords - ecTotalCodewords

  // Total number of blocks
  const ecTotalBlocks = ECCode.getBlocksCount(version, errorCorrectionLevel)

  // Calculate how many blocks each group should contain
  const blocksInGroup2 = totalCodewords % ecTotalBlocks
  const blocksInGroup1 = ecTotalBlocks - blocksInGroup2

  const totalCodewordsInGroup1 = Math.floor(totalCodewords / ecTotalBlocks)

  const dataCodewordsInGroup1 = Math.floor(dataTotalCodewords / ecTotalBlocks)
  const dataCodewordsInGroup2 = dataCodewordsInGroup1 + 1

  // Number of EC codewords is the same for both groups
  const ecCount = totalCodewordsInGroup1 - dataCodewordsInGroup1

  // Initialize a Reed-Solomon encoder with a generator polynomial of degree ecCount
  const rs = new ReedSolomonEncoder(ecCount)

  let offset = 0
  const dcData = new Array(ecTotalBlocks)
  const ecData = new Array(ecTotalBlocks)
  let maxDataSize = 0
  const buffer = new Uint8Array(bitBuffer.buffer)

  // Divide the buffer into the required number of blocks
  for (let b = 0; b < ecTotalBlocks; b++) {
    const dataSize = b < blocksInGroup1 ? dataCodewordsInGroup1 : dataCodewordsInGroup2

    // extract a block of data from buffer
    dcData[b] = buffer.slice(offset, offset + dataSize)

    // Calculate EC codewords for this data block
    ecData[b] = rs.encode(dcData[b])

    offset += dataSize
    maxDataSize