/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/core/Constant.ts":
/*!******************************!*\
  !*** ./src/core/Constant.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Constant: () => (/* binding */ Constant),
/* harmony export */   Logger: () => (/* binding */ Logger)
/* harmony export */ });
const Constant = {
    DEBUG: false,
    VERSION: '2.0.0',
    NAME: 'LayaTree',
    SCRITP_NAMES: "scriptInject",
    DEBUG_LAYER_NAME: "LayaTreeDebugLayer",
    // API配置
    API_CONFIG: {
        VERSION_CHECK_URL: 'http://womenzhai.cn:8066/updateInfo',
        ANALYTICS_URL: 'devtools/utils/baidu_tongji.js'
    }
};
/**
 * 日志工具类，根据 DEBUG 常量决定是否输出日志
 */
class Logger {
    /**
     * 普通日志输出
     * @param args 要输出的参数
     */
    static log(...args) {
        if (Constant.DEBUG) {
            console.log('[LayaTree]', ...args);
        }
    }
    /**
     * 警告日志输出
     * @param args 要输出的参数
     */
    static warn(...args) {
        if (Constant.DEBUG) {
            console.warn('[LayaTree]', ...args);
        }
    }
    /**
     * 错误日志输出
     * @param args 要输出的参数
     */
    static error(...args) {
        if (Constant.DEBUG) {
            console.error('[LayaTree]', ...args);
        }
    }
    /**
     * 信息日志输出
     * @param args 要输出的参数
     */
    static info(...args) {
        if (Constant.DEBUG) {
            console.info('[LayaTree]', ...args);
        }
    }
}


/***/ }),

/***/ "./src/core/Inspector.ts":
/*!*******************************!*\
  !*** ./src/core/Inspector.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Inspector: () => (/* binding */ Inspector)
/* harmony export */ });
/* harmony import */ var _engine_EngineProvider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./engine/EngineProvider */ "./src/core/engine/EngineProvider.ts");
/* harmony import */ var _Constant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Constant */ "./src/core/Constant.ts");
/* harmony import */ var _message_Message__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./message/Message */ "./src/core/message/Message.ts");
/* harmony import */ var _message_Event__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./message/Event */ "./src/core/message/Event.ts");




class Inspector {
    constructor() {
        this.currentEngine = null;
        this.windowMessenger = null;
        this.treeRefreshTimer = null;
        this.energyReportTimer = null;
        this.performanceDataTimer = null;
        this.webglSupported = null; // 缓存WebGL支持状态
        this.lastRefreshTime = 0;
        this.init();
    }
    init() {
        _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('Inspector 初始化中...');
        // 初始化引擎提供者
        _engine_EngineProvider__WEBPACK_IMPORTED_MODULE_0__.EngineProvider.init();
        // 获取当前引擎
        this.currentEngine = _engine_EngineProvider__WEBPACK_IMPORTED_MODULE_0__.EngineProvider.getCurrentEngine();
        // 正确绑定this上下文，避免this指向window对象
        const currentEngine = _engine_EngineProvider__WEBPACK_IMPORTED_MODULE_0__.EngineProvider.getCurrentEngine();
        if (currentEngine) {
            window.getNodeMemoryStroge = currentEngine.getNodeMemoryStroge.bind(currentEngine);
            window.getAllProps = currentEngine.getAllProps.bind(currentEngine);
            window.getOrCreatePropStructure = currentEngine.getOrCreatePropStructure.bind(currentEngine);
        }
        this.windowMessenger = _message_Message__WEBPACK_IMPORTED_MODULE_2__.Message.getMessage('Stage', this.handleWindowMessage.bind(this), this);
        _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('Inspector 初始化完成');
        const engineCheck = setInterval(() => {
            var _a;
            this.currentEngine = _engine_EngineProvider__WEBPACK_IMPORTED_MODULE_0__.EngineProvider.getCurrentEngine();
            if (this.currentEngine) {
                clearInterval(engineCheck);
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log(`检测到引擎: ${this.currentEngine.name}, 版本: ${this.currentEngine.getEngineVersion()}`);
                // 初始化代理，监听节点变化
                if (this.currentEngine.initProxy) {
                    this.currentEngine.initProxy();
                    _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('已初始化引擎代理，开始监听节点变化');
                }
                // 重新绑定window方法（确保正确的this上下文）
                window.getNodeMemoryStroge = this.currentEngine.getNodeMemoryStroge.bind(this.currentEngine);
                if (this.windowMessenger) {
                    _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('发送引擎初始化消息' + this.currentEngine.name);
                }
                (_a = this.windowMessenger) === null || _a === void 0 ? void 0 : _a.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.ENGINE_INIT, {
                    engineName: this.currentEngine.name,
                    engineVersion: this.currentEngine.getEngineVersion(),
                    gameName: document.title
                });
                // 启动基于isTreeDirty的定时刷新
                this.startTreeRefreshTimer();
                // 启动GPU能耗监控
                // sthis.startEnergyMonitoring();
                // 启动性能数据收集
                // this.startPerformanceDataCollection();
            }
        }, 1000);
    }
    // 启动性能数据收集
    startPerformanceDataCollection() {
        // 清除之前的定时器（如果存在）
        if (this.performanceDataTimer) {
            clearInterval(this.performanceDataTimer);
        }
        // 每秒收集一次性能数据
        this.performanceDataTimer = setInterval(() => {
            var _a;
            if (this.currentEngine && this.currentEngine.collectPerformanceData) {
                const performanceData = this.currentEngine.collectPerformanceData();
                if (performanceData) {
                    // 发送性能数据到devtools
                    (_a = this.windowMessenger) === null || _a === void 0 ? void 0 : _a.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.PERFORMANCE_DATA, performanceData);
                }
            }
        }, 1000); // 1秒间隔
        _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('已启动性能数据收集');
    }
    refreshTree() {
        var _a, _b;
        let tree = (_a = this.currentEngine) === null || _a === void 0 ? void 0 : _a.refreshTree();
        // Logger.log('获取到的树形数据:', tree);
        (_b = this.windowMessenger) === null || _b === void 0 ? void 0 : _b.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.ENGINE_TREE_REFRESH, {
            tree: tree
        });
    }
    startTreeRefreshTimer() {
        // 清除之前的定时器（如果存在）
        if (this.treeRefreshTimer) {
            clearInterval(this.treeRefreshTimer);
        }
        // 防抖变量
        const REFRESH_DEBOUNCE_TIME = 1000; // 1秒防抖时间
        // 启动新的定时器，每秒检查isTreeDirty状态
        this.treeRefreshTimer = setInterval(() => {
            if (this.currentEngine && this.currentEngine.isTreeDirty) {
                const currentTime = Date.now();
                // 防抖检查：如果距离上次刷新不足1秒，则跳过
                if (currentTime - this.lastRefreshTime < REFRESH_DEBOUNCE_TIME) {
                    return;
                }
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('检测到树结构变化，自动刷新树形结构');
                this.refreshTree();
                this.lastRefreshTime = currentTime;
                // 刷新后将isTreeDirty设置为false
                if (this.currentEngine.setTreeDirty) {
                    this.currentEngine.setTreeDirty(false);
                }
                else {
                    this.currentEngine.isTreeDirty = false;
                }
            }
        }, 500);
        _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('已启动基于isTreeDirty的定时刷新机制（带防抖）');
    }
    handleWindowMessage(message) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
        switch (message.type) {
            case _message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.REQUEST_REFRESH_TREE:
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('收到刷新树形结构请求');
                if (this.currentEngine) {
                    this.refreshTree();
                }
                else {
                    _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.warn('无法刷新：当前页面没有检测到支持的游戏引擎');
                    (_a = this.windowMessenger) === null || _a === void 0 ? void 0 : _a.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.ENGINE_STATUS_RESPONSE, {
                        hasEngine: false,
                        reason: 'NO_ENGINE_DETECTED',
                        supportedEngines: ['Laya', 'ThreeJS'],
                        pageUrl: window.location.href,
                        timestamp: Date.now()
                    });
                }
                break;
            case _message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.REQUEST_NODE_PROPERTY:
                // 移除频繁的请求节点属性日志
                this.getNodeProperty((_b = message.data) === null || _b === void 0 ? void 0 : _b.exId);
                break;
            case _message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.SET_NODE_PROPERTY:
                // Logger.log('收到设置节点属性请求');
                this.setNodeProperty(message.data);
                break;
            case _message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.REQUEST_SET_TIME_SCALE:
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('收到请求设置TimeScale');
                this.setTimeScale((_c = message.data) === null || _c === void 0 ? void 0 : _c.timeScale);
                break;
            case _message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.REQUEST_NEXT_FRAME:
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('收到请求下一帧');
                this.nextFrame();
                break;
            case _message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.DELETE_NODE:
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('收到删除节点请求');
                this.deleteNode(message.data);
                break;
            case _message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.REQUEST_GPU_ENERGY_REPORT:
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('收到GPU能耗报告请求');
                break;
            case _message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.HEARTBEAT_PING:
                // 响应心跳包
                // Logger.log('💓 收到心跳包，发送响应');
                (_d = this.windowMessenger) === null || _d === void 0 ? void 0 : _d.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.HEARTBEAT_PONG, {
                    timestamp: Date.now(),
                    pingId: (_e = message.data) === null || _e === void 0 ? void 0 : _e.pingId,
                    source: 'inspector',
                    connectionChain: {
                        background: true, // Inspector能收到消息说明background连接正常
                        contentScript: true, // Inspector能收到消息说明contentScript连接正常
                        inspector: true // Inspector本身正常运行
                    },
                    engineStatus: {
                        hasEngine: !!this.currentEngine,
                        engineName: (_f = this.currentEngine) === null || _f === void 0 ? void 0 : _f.name,
                        engineVersion: (_g = this.currentEngine) === null || _g === void 0 ? void 0 : _g.getEngineVersion()
                    }
                });
                break;
            case _message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.CONNECTION_CHECK:
                // 响应连接状态检查
                // Logger.log('🔍 收到连接状态检查请求');
                (_h = this.windowMessenger) === null || _h === void 0 ? void 0 : _h.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.CONNECTION_STATUS, {
                    timestamp: Date.now(),
                    requestId: (_j = message.data) === null || _j === void 0 ? void 0 : _j.requestId,
                    backgroundConnected: true,
                    contentScriptConnected: true,
                    inspectorConnected: true,
                    engineInfo: this.currentEngine ? {
                        name: this.currentEngine.name,
                        version: this.currentEngine.getEngineVersion(),
                        detected: true
                    } : {
                        detected: false,
                        reason: 'NO_ENGINE_DETECTED'
                    },
                    pageInfo: {
                        url: window.location.href,
                        title: document.title,
                        loadTime: Date.now(),
                        hasWebGL: this.checkWebGLSupport(),
                        canvasCount: document.querySelectorAll('canvas').length
                    }
                });
                break;
            case _message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.ENGINE_STATUS_CHECK:
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('收到引擎状态检查请求');
                // 重新检测引擎
                const previousEngine = this.currentEngine;
                this.currentEngine = _engine_EngineProvider__WEBPACK_IMPORTED_MODULE_0__.EngineProvider.getCurrentEngine();
                // 重新绑定window方法（如果引擎发生变化）
                if (this.currentEngine) {
                    window.getNodeMemoryStroge = this.currentEngine.getNodeMemoryStroge.bind(this.currentEngine);
                }
                if (this.currentEngine) {
                    // 如果引擎发生变化或之前没有引擎，初始化代理
                    if (!previousEngine || previousEngine.name !== this.currentEngine.name) {
                        if (this.currentEngine.initProxy) {
                            this.currentEngine.initProxy();
                            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('重新初始化引擎代理，开始监听节点变化');
                        }
                    }
                    (_k = this.windowMessenger) === null || _k === void 0 ? void 0 : _k.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.ENGINE_STATUS_RESPONSE, {
                        hasEngine: true,
                        engineName: this.currentEngine.name,
                        engineVersion: this.currentEngine.getEngineVersion(),
                        pageUrl: window.location.href,
                        timestamp: Date.now()
                    });
                    // 如果检测到引擎，发送初始化消息
                    (_l = this.windowMessenger) === null || _l === void 0 ? void 0 : _l.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.ENGINE_INIT, {
                        engineName: this.currentEngine.name,
                        engineVersion: this.currentEngine.getEngineVersion(),
                        gameName: document.title
                    });
                    // 如果引擎发生变化或之前没有引擎，重新启动定时器
                    if (!previousEngine || previousEngine.name !== this.currentEngine.name) {
                        this.startTreeRefreshTimer();
                    }
                }
                else {
                    // 如果没有引擎，停止定时器
                    if (this.treeRefreshTimer) {
                        clearInterval(this.treeRefreshTimer);
                        this.treeRefreshTimer = null;
                    }
                    (_m = this.windowMessenger) === null || _m === void 0 ? void 0 : _m.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.ENGINE_STATUS_RESPONSE, {
                        hasEngine: false,
                        reason: 'NO_ENGINE_DETECTED',
                        supportedEngines: ['Laya', 'ThreeJS'],
                        pageUrl: window.location.href,
                        timestamp: Date.now(),
                        windowObjects: this.getWindowObjectsInfo()
                    });
                }
                break;
            case _message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.OUTPUT_NODE_TO_CONSOLE:
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('收到输出节点信息到控制台请求');
                this.outputNodeToConsole(message.data);
                break;
            case _message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.OUTPUT_NODE_TO_CONSOLE_COMPONENT:
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('收到输出节点信息到控制台组件请求');
                this.outputNodeToConsoleComponent(message.data);
                break;
            case _message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.SET_SHOW_SEL_BOX:
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('收到设置显示选择框请求');
                this.setShowSelBox(message.data);
                break;
            default:
                // 处理其他消息类型
                break;
        }
    }
    getWindowObjectsInfo() {
        // 收集页面上的相关对象信息，帮助诊断
        const info = {
            hasLaya: typeof window.Laya !== 'undefined',
            hasLaya3D: typeof window.Laya3D !== 'undefined',
            hasThreeJS: typeof window.THREE !== 'undefined',
            hasWebGL: this.checkWebGLSupport(),
            userAgent: navigator.userAgent,
            pageTitle: document.title
        };
        // 检查是否有canvas元素
        const canvases = document.querySelectorAll('canvas');
        info.canvasCount = canvases.length;
        info.canvasInfo = Array.from(canvases).map(canvas => ({
            width: canvas.width,
            height: canvas.height,
            id: canvas.id,
            className: canvas.className
        }));
        return info;
    }
    getNodeProperty(exId) {
        var _a;
        if (this.currentEngine) {
            let property = this.currentEngine.getNodeProperty(exId);
            // 移除频繁的获取节点属性日志
            (_a = this.windowMessenger) === null || _a === void 0 ? void 0 : _a.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.RESPONSE_NODE_PROPERTY, {
                property: property
            });
        }
    }
    setNodeProperty(data) {
        var _a, _b, _c;
        if (this.currentEngine && data) {
            const { exId, componentType, propertyName, value } = data;
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log(`设置节点属性: exId=${exId}, component=${componentType}, property=${propertyName}, value=`, value);
            try {
                // 调用引擎的设置属性方法
                const success = this.currentEngine.setNodeProperty ?
                    this.currentEngine.setNodeProperty(exId, componentType, propertyName, value) : false;
                (_a = this.windowMessenger) === null || _a === void 0 ? void 0 : _a.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.RESPONSE_SET_NODE_PROPERTY, {
                    success: success,
                    exId: exId,
                    componentType: componentType,
                    propertyName: propertyName,
                    value: value
                });
                if (success) {
                    // 移除频繁的节点属性设置成功日志
                }
                else {
                    _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.warn(`❌ 节点属性设置失败`);
                }
            }
            catch (error) {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('设置节点属性时发生错误:', error);
                (_b = this.windowMessenger) === null || _b === void 0 ? void 0 : _b.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.RESPONSE_SET_NODE_PROPERTY, {
                    success: false,
                    error: (error === null || error === void 0 ? void 0 : error.message) || 'Unknown error',
                    exId: exId,
                    componentType: componentType,
                    propertyName: propertyName,
                    value: value
                });
            }
        }
        else {
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.warn('无法设置节点属性：当前页面没有检测到支持的游戏引擎或参数无效');
            (_c = this.windowMessenger) === null || _c === void 0 ? void 0 : _c.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.RESPONSE_SET_NODE_PROPERTY, {
                success: false,
                error: 'NO_ENGINE_OR_INVALID_DATA'
            });
        }
    }
    outputNodeToConsole(data) {
        var _a;
        if (data) {
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('输出节点信息:', data);
            if (data.exId != undefined) {
                console.log(`📊 输出的节点数据  window.getNodeMemoryStroge(${data.exId}) : \n`, (_a = this.currentEngine) === null || _a === void 0 ? void 0 : _a.getNodeMemoryStroge(data.exId));
            }
            else {
                console.warn('❌ LayaTree: 无法输出节点信息 - 数据为空');
            }
        }
        else {
            console.warn('❌ LayaTree: 无法输出节点信息 - 数据为空');
        }
    }
    outputNodeToConsoleComponent(data) {
        var _a;
        if (data) {
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('输出节点信息:', data);
            if (data.exId != undefined && data.index != undefined) {
                console.log(`📊 输出的节点数据  window.getNodeMemoryStroge(${data.exId})._components[${data.index}] : \n`, (_a = this.currentEngine) === null || _a === void 0 ? void 0 : _a.getNodeMemoryStroge(data.exId)._components[data.index]);
            }
            else {
                console.warn('❌ LayaTree: 无法输出节点信息 - 数据为空');
            }
        }
        else {
            console.warn('❌ LayaTree: 无法输出节点信息 - 数据为空');
        }
    }
    setTimeScale(timeScale) {
        var _a;
        let resultTimeScale = timeScale;
        if (this.currentEngine) {
            resultTimeScale = this.currentEngine.setTimeScale(timeScale);
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('设置TimeScale成功，当前TimeScale为:', resultTimeScale);
        }
        else {
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.warn('无法设置TimeScale：当前页面没有检测到支持的游戏引擎');
            // 如果是获取当前值的请求（-1），返回默认值1
            resultTimeScale = timeScale === -1 ? 1 : timeScale;
        }
        (_a = this.windowMessenger) === null || _a === void 0 ? void 0 : _a.post(_message_Event__WEBPACK_IMPORTED_MODULE_3__.EventType.RESPONSE_SET_TIME_SCALE, {
            timeScale: resultTimeScale,
            success: !!this.currentEngine,
            error: this.currentEngine ? undefined : 'NO_ENGINE_DETECTED'
        });
    }
    nextFrame() {
        if (this.currentEngine && this.currentEngine.nextFrame) {
            this.currentEngine.nextFrame();
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('执行下一帧成功');
        }
        else {
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.warn('无法执行下一帧：当前页面没有检测到支持的游戏引擎或引擎不支持下一帧功能');
        }
    }
    deleteNode(data) {
        if (this.currentEngine && data) {
            const { exId } = data;
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log(`删除节点: exId=${exId}`);
            try {
                // 调用引擎的删除节点方法
                const success = this.currentEngine.deleteNode ?
                    this.currentEngine.deleteNode(exId) : false;
                if (success) {
                    _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log(`✅ 节点删除成功: exId=${exId}`);
                }
                else {
                    _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.warn(`❌ 节点删除失败: exId=${exId}`);
                }
            }
            catch (error) {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('删除节点时发生错误:', error);
            }
        }
        else {
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.warn('无法删除节点：当前页面没有检测到支持的游戏引擎或参数无效');
        }
    }
    setShowSelBox(data) {
        if (this.currentEngine && data) {
            const { show } = data;
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log(`设置显示选择框: show=${show}`);
            try {
                // 调用引擎的设置显示选择框方法
                if (this.currentEngine.setShowSelBox) {
                    this.currentEngine.setShowSelBox(show);
                    _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log(`✅ 显示选择框设置成功: show=${show}`);
                }
                else {
                    _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.warn('当前引擎不支持setShowSelBox方法');
                }
            }
            catch (error) {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('设置显示选择框时发生错误:', error);
            }
        }
        else {
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.warn('无法设置显示选择框：当前页面没有检测到支持的游戏引擎或参数无效');
        }
    }
    jumpToComponentDefinition(data) {
        if (data) {
            const { componentType, exId } = data;
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log(`跳转到组件定义: componentType=${componentType}, exId=${exId}`);
            try {
                // 这里可以实现跳转到组件定义的逻辑
                // 例如：打开IDE、跳转到文件位置等
                // 目前先输出组件信息到控制台
                console.log(`🔍 组件定义信息:`);
                console.log(`组件类型: ${componentType}`);
                console.log(`节点ID: ${exId}`);
                if (this.currentEngine && this.currentEngine.getNodeMemoryStroge) {
                    const nodeInfo = this.currentEngine.getNodeMemoryStroge(exId);
                    console.log(`节点详细信息:`, nodeInfo);
                }
                // 可以在这里添加更多跳转逻辑，比如：
                // - 调用IDE API跳转到组件定义
                // - 打开文档页面
                // - 显示组件源码等
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log(`✅ 组件定义信息已输出到控制台`);
            }
            catch (error) {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('跳转到组件定义时发生错误:', error);
            }
        }
        else {
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.warn('无法跳转到组件定义：参数无效');
        }
    }
    /**
     * 安全地检查WebGL支持，避免创建过多WebGL上下文导致泄漏
     * @returns boolean WebGL是否支持
     */
    checkWebGLSupport() {
        // 如果已经检查过，直接返回缓存结果
        if (this.webglSupported !== null) {
            return this.webglSupported;
        }
        this.webglSupported = false;
        return false;
    }
}


/***/ }),

/***/ "./src/core/engine/EngineProvider.ts":
/*!*******************************************!*\
  !*** ./src/core/engine/EngineProvider.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EngineProvider: () => (/* binding */ EngineProvider)
/* harmony export */ });
/* harmony import */ var _laya_LayaEngineHolder__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./laya/LayaEngineHolder */ "./src/core/engine/laya/LayaEngineHolder.ts");
/* harmony import */ var _threejs_ThreeJSEngineHolder__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./threejs/ThreeJSEngineHolder */ "./src/core/engine/threejs/ThreeJSEngineHolder.ts");


class EngineProvider {
    constructor() {
    }
    static init() {
        this.engineHolders = [
            new _laya_LayaEngineHolder__WEBPACK_IMPORTED_MODULE_0__.LayaEngineHolder(),
            new _threejs_ThreeJSEngineHolder__WEBPACK_IMPORTED_MODULE_1__.ThreeJSEngineHolder(),
        ];
        // 自动检测当前引擎
        this.detectCurrentEngine();
    }
    /**
     * 检测当前环境使用的引擎
     */
    static detectCurrentEngine() {
        for (const holder of this.engineHolders) {
            if (holder.isCurrentEngine()) {
                this.currentEngineHolder = holder;
                this.currentEngineHolder.init();
                return holder;
            }
        }
        this.currentEngineHolder = null;
        return null;
    }
    /**
     * 获取当前引擎
     */
    static getCurrentEngine() {
        if (!this.currentEngineHolder) {
            this.detectCurrentEngine();
        }
        return this.currentEngineHolder;
    }
    /**
     * 获取所有支持的引擎
     */
    static getAllEngines() {
        return this.engineHolders;
    }
    /**
     * 根据名称获取引擎
     */
    static getEngineByName(name) {
        return this.engineHolders.find(holder => holder.name === name) || null;
    }
    /**
     * 获取当前引擎信息
     */
    static getCurrentEngineInfo() {
        const currentEngine = this.getCurrentEngine();
        if (!currentEngine) {
            return null;
        }
        return {
            name: currentEngine.name,
            version: currentEngine.getEngineVersion(),
            isDetected: true
        };
    }
    /**
     * 获取节点信息
     * @param exId 节点ID
     * @returns 节点信息
     */
    static getNodeProperty(exId) {
        const currentEngine = this.getCurrentEngine();
        if (!currentEngine) {
            return null;
        }
        return currentEngine.getNodeProperty(exId);
    }
}
EngineProvider.engineHolders = [];
EngineProvider.currentEngineHolder = null;


/***/ }),

/***/ "./src/core/engine/laya/LayaEngineHolder.ts":
/*!**************************************************!*\
  !*** ./src/core/engine/laya/LayaEngineHolder.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LayaEngineHolder: () => (/* binding */ LayaEngineHolder)
/* harmony export */ });
/* harmony import */ var _Constant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Constant */ "./src/core/Constant.ts");
/* harmony import */ var _LayaPropParse__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LayaPropParse */ "./src/core/engine/laya/LayaPropParse.ts");
/* harmony import */ var _RoamCamera__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./RoamCamera */ "./src/core/engine/laya/RoamCamera.ts");

const Laya = window.Laya;



class LayaEngineHolder {
    constructor() {
        this.name = 'Laya';
        this.childrenName = 'children';
        // 缓存获取过的节点链索引
        this.nodeChainCache = {};
        this.DebugLayerName = "LayaTreeDebugLayer";
        this.uuid = 0;
        this.isShowSelBox = false;
        this.isTreeDirty = true;
    }
    init() {
        _LayaPropParse__WEBPACK_IMPORTED_MODULE_1__.LayaPropParse.initObfuscationName();
    }
    /**
     * 获取Laya实例，支持从iframe中查找
     */
    getLayaInstance() {
        // 如果已经缓存了有效的Laya实例，直接返回
        // 1. 首先检查主窗口
        if (window.Laya && window.Laya.stage) {
            return window.Laya;
        }
        // 2. 检查所有iframe中的Laya实例
        const iframes = document.getElementsByTagName('iframe');
        for (let i = 0; i < iframes.length; i++) {
            try {
                const iframe = iframes[i];
                const iframeWindow = iframe.contentWindow;
                if (iframeWindow && iframeWindow.Laya) {
                    // 验证找到的Laya实例是否有效
                    const layaInstance = iframeWindow.Laya;
                    if (layaInstance.stage) {
                        _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.log(`在iframe中找到Laya引擎实例: ${iframe.src || 'inline iframe'}`);
                        window.Laya = layaInstance;
                        return window.Laya;
                    }
                }
            }
            catch (error) {
                // 忽略跨域或其他访问错误
                _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn(`无法访问iframe中的Laya对象: ${error.message}`);
                continue;
            }
        }
        return null;
    }
    /**
     * 检测当前环境是否存在Laya引擎
     */
    isCurrentEngine() {
        const layaInstance = this.getLayaInstance();
        return layaInstance !== null;
    }
    /**
     * 获取Laya引擎版本
     */
    getEngineVersion() {
        var _a;
        const layaInstance = this.getLayaInstance();
        if (!layaInstance)
            return undefined;
        let stage = layaInstance.stage;
        if (!stage)
            return undefined;
        return layaInstance.version || ((_a = layaInstance.LayaEnv) === null || _a === void 0 ? void 0 : _a.version) || undefined;
    }
    getStage() {
        if (Laya) {
            return Laya.stage;
        }
        else {
            const layaInstance = this.getLayaInstance();
            if (!layaInstance)
                return undefined;
            return layaInstance.stage;
        }
    }
    refreshTree() {
        let stage = this.getStage();
        if (!stage)
            return;
        let stageName = stage.constructor.name;
        stageName = _LayaPropParse__WEBPACK_IMPORTED_MODULE_1__.LayaPropParse.getObfuscatedName(stageName);
        stage.exId = 0;
        let stageTreeCache = {
            exId: 0,
            is3D: false,
            name: stageName,
            children: [],
            type: stageName,
        };
        // 兼容Laya1.x
        if (stage._children) {
            this.childrenName = "_children";
        }
        else if (stage._childs) {
            this.childrenName = "_childs";
        }
        let len = stage[this.childrenName] ? stage[this.childrenName].length : 0;
        for (let i = 0; i < len; i++) {
            let child = stage[this.childrenName][i];
            if (child.name === this.DebugLayerName) {
                continue;
            }
            this.buildNodeTree(child, stageTreeCache.children);
        }
        // 清空缓存（TODO 可以使用树摇对比，只对比新增和删除的节点）
        this.nodeChainCache = {};
        // 清空调试层
        if (this.isShowSelBox) {
            let layaTreeDebugLayer = this.getLayaTreeDebugLayer();
            layaTreeDebugLayer.graphics.clear(true);
        }
        else {
            if (stage) {
                let layaTreeDebugLayer = stage.getChildByName(_Constant__WEBPACK_IMPORTED_MODULE_0__.Constant.DEBUG_LAYER_NAME);
                if (layaTreeDebugLayer != null) {
                    layaTreeDebugLayer.removeSelf();
                }
            }
        }
        // 刷新完成后，重置脏标记
        this.isTreeDirty = false;
        return stageTreeCache;
    }
    /**
     * 递归获取节点树
     */
    buildNodeTree(node, cache) {
        let exId = node.exId;
        if (exId == null || exId == undefined) {
            this.uuid += 1;
            exId = this.uuid;
            node.exId = exId;
        }
        let name = this.getNodeName(node);
        let type = node.constructor.name;
        type = _LayaPropParse__WEBPACK_IMPORTED_MODULE_1__.LayaPropParse.getObfuscatedName(type);
        let is3D = _LayaPropParse__WEBPACK_IMPORTED_MODULE_1__.LayaPropParse.is3dObject(node, type);
        if (type == 'Scene3D') {
            is3D = true;
        }
        let nodeData = {
            exId,
            name,
            is3D,
            children: [],
            type,
        };
        let len = node[this.childrenName] ? node[this.childrenName].length : 0;
        for (let i = 0; i < len; i++) {
            let childItem = node[this.childrenName][i];
            this.buildNodeTree(childItem, nodeData.children);
        }
        cache.push(nodeData);
    }
    getNodeName(node) {
        let nodeName = node.constructor.name;
        nodeName = _LayaPropParse__WEBPACK_IMPORTED_MODULE_1__.LayaPropParse.getObfuscatedName(nodeName);
        if (node.$owner) {
            nodeName = node.$owner._name + "    " + node.$owner.constructor.name + "    " + nodeName;
        }
        if (node.name) {
            nodeName = nodeName + "   " + node.name;
        }
        return nodeName;
    }
    getNodeProperty(exId) {
        let node = this.getNodeMemoryStroge(exId);
        if (node) {
            let type = node.constructor.name;
            type = _LayaPropParse__WEBPACK_IMPORTED_MODULE_1__.LayaPropParse.getObfuscatedName(type);
            return _LayaPropParse__WEBPACK_IMPORTED_MODULE_1__.LayaPropParse.parse(node, type);
        }
        return undefined;
    }
    setNodeProperty(exId, componentType, propertyName, value) {
        try {
            let node = this.getNodeMemoryStroge(exId);
            if (!node) {
                _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn(`未找到节点 exId: ${exId}`);
                return false;
            }
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.log(`设置节点属性: ${componentType}.${propertyName} = ${JSON.stringify(value)}`);
            if (componentType === 'Transform3D' || componentType === 'Node2D') {
                return this.setTransformProperty(node, propertyName, value, componentType === 'Transform3D');
            }
            else if (componentType === 'NodeInfo') {
                return this.setNodeInfoProperty(node, propertyName, value);
            }
            else {
                return this.setNodeInfoProperty(node, propertyName, value);
            }
        }
        catch (error) {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.error('设置节点属性失败:', error);
            return false;
        }
    }
    setTransformProperty(node, propertyName, value, is3D) {
        if (is3D && node.transform) {
            // 3D Transform
            const transform = node.transform;
            switch (propertyName) {
                case 'Position':
                    if (value.x !== undefined)
                        transform.localPositionX = value.x;
                    if (value.y !== undefined)
                        transform.localPositionY = value.y;
                    if (value.z !== undefined)
                        transform.localPositionZ = value.z;
                    return true;
                case 'Rotation':
                    if (value.x !== undefined)
                        transform.localRotationEulerX = value.x;
                    if (value.y !== undefined)
                        transform.localRotationEulerY = value.y;
                    if (value.z !== undefined)
                        transform.localRotationEulerZ = value.z;
                    return true;
                case 'Scale':
                    if (value.x !== undefined)
                        transform.localScaleX = value.x;
                    if (value.y !== undefined)
                        transform.localScaleY = value.y;
                    if (value.z !== undefined)
                        transform.localScaleZ = value.z;
                    return true;
            }
        }
        else {
            // 2D Transform
            switch (propertyName) {
                case 'Position':
                    if (value.x !== undefined)
                        node.x = value.x;
                    if (value.y !== undefined)
                        node.y = value.y;
                    return true;
                case 'Size':
                    if (value.x !== undefined)
                        node.width = value.x;
                    if (value.y !== undefined)
                        node.height = value.y;
                    return true;
                case 'Anchor':
                    if (value.x !== undefined)
                        node.anchorX = value.x;
                    if (value.y !== undefined)
                        node.anchorY = value.y;
                    return true;
                case 'Scale':
                    if (value.x !== undefined)
                        node.scaleX = value.x;
                    if (value.y !== undefined)
                        node.scaleY = value.y;
                    return true;
                case 'Skew':
                    if (value.x !== undefined)
                        node.skewX = value.x;
                    if (value.y !== undefined)
                        node.skewY = value.y;
                    return true;
                case 'Rotation':
                    if (typeof value === 'number')
                        node.rotation = value;
                    return true;
                case 'alpha':
                    if (typeof value === 'number')
                        node.alpha = value;
                    return true;
                case 'visible':
                    if (typeof value === 'boolean') {
                        node.visible = value;
                        _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.log(`✅ 成功设置2D节点visible属性: ${value}`);
                        return true;
                    }
                    else {
                        _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn(`visible属性值类型错误: ${typeof value}, 期望boolean`);
                        return false;
                    }
                case 'mouseEnabled':
                    if (typeof value === 'boolean') {
                        node.mouseEnabled = value;
                        _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.log(`✅ 成功设置2D节点mouseEnabled属性: ${value}`);
                        return true;
                    }
                    else {
                        _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn(`mouseEnabled属性值类型错误: ${typeof value}, 期望boolean`);
                        return false;
                    }
                case 'mouseThrough':
                    if (typeof value === 'boolean') {
                        node.mouseThrough = value;
                        _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.log(`✅ 成功设置2D节点mouseThrough属性: ${value}`);
                        return true;
                    }
                    else {
                        _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn(`mouseThrough属性值类型错误: ${typeof value}, 期望boolean`);
                        return false;
                    }
                case 'zOrder':
                    if (typeof value === 'number') {
                        node.zOrder = value;
                        _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.log(`✅ 成功设置2D节点zOrder属性: ${value}`);
                        return true;
                    }
                    else {
                        _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn(`zOrder属性值类型错误: ${typeof value}, 期望number`);
                    }
            }
            return false;
        }
        return false;
    }
    setNodeInfoProperty(node, propertyName, value) {
        if (node && node[propertyName] != undefined) {
            let propertyNameType = node[propertyName].constructor.name;
            propertyNameType = _LayaPropParse__WEBPACK_IMPORTED_MODULE_1__.LayaPropParse.getObfuscatedName(propertyNameType);
            switch (propertyNameType) {
                case 'Color':
                    // 特殊处理clearColor：先设置RGBA分量，再触发自赋值
                    if (Array.isArray(value) && value.length >= 4) {
                        // 设置各个分量
                        node[propertyName].r = value[0];
                        node[propertyName].g = value[1];
                        node[propertyName].b = value[2];
                        node[propertyName].a = value[3];
                        // 关键：触发clearColor的自赋值来更新引擎
                        node[propertyName] = node[propertyName];
                        return true;
                    }
                    else {
                        _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn('Color值格式错误，期望[r,g,b,a]数组');
                        return false;
                    }
                default:
                    node[propertyName] = value;
                    break;
            }
            return true;
        }
        else {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn(`未找到节点属性: ${propertyName}`);
            return false;
        }
    }
    deleteNode(exId) {
        try {
            let node = this.getNodeMemoryStroge(exId);
            if (!node) {
                _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn(`未找到要删除的节点 exId: ${exId}`);
                return false;
            }
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.log(`准备删除节点: ${node.name || node.constructor.name} (exId: ${exId})`);
            // 检查节点是否有destroy方法
            if (typeof node.destroy === 'function') {
                // 使用Laya的destroy方法删除节点
                node.destroy();
                _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.log(`✅ 使用destroy方法成功删除节点: ${node.name || node.constructor.name}`);
                return true;
            }
            // 检查节点是否有removeSelf方法 (Laya 2D节点)
            else if (typeof node.removeSelf === 'function') {
                // 从父节点移除
                node.removeSelf();
                _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.log(`✅ 使用removeSelf方法成功删除节点: ${node.name || node.constructor.name}`);
                return true;
            }
            // 检查是否有父节点，尝试从父节点移除
            else if (node.parent && typeof node.parent.removeChild === 'function') {
                node.parent.removeChild(node);
                _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.log(`✅ 从父节点移除成功删除节点: ${node.name || node.constructor.name}`);
                return true;
            }
            else {
                _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn(`❌ 节点没有可用的删除方法: ${node.name || node.constructor.name}`);
                return false;
            }
        }
        catch (error) {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.error('删除节点失败:', error);
            return false;
        }
    }
    getNodeMemoryStroge(exId) {
        let preNode = this.getNodeByChainCache(exId);
        if (preNode && (exId == preNode.exId)) {
            return preNode;
        }
        let stage = this.getStage();
        if (!stage)
            return null;
        let node = this.getNodeByExId(exId, stage, []);
        if (this.isShowSelBox) {
            this.showDisBoundToSprite(node, "#ff0000", 2);
        }
        return node;
    }
    getNodeByExId(exId, node, chain) {
        if (node.exId == exId) {
            this.nodeChainCache[exId] = chain;
            return node;
        }
        let len = node[this.childrenName] ? node[this.childrenName].length : 0;
        for (let i = 0; i < len; i++) {
            let curchain = chain.concat([i]);
            let childItem = node[this.childrenName][i];
            if (childItem.exId == exId) {
                this.nodeChainCache[exId] = curchain;
                return childItem;
            }
            let findResult = this.getNodeByExId(exId, childItem, curchain);
            if (findResult) {
                this.nodeChainCache[exId] = curchain;
                return findResult;
            }
        }
        return undefined;
    }
    getNodeByChainCache(exId) {
        if (!this.nodeChainCache) {
            return undefined;
        }
        let curChain = this.nodeChainCache[exId];
        if (curChain == undefined) {
            return undefined;
        }
        let node = this.getStage();
        if (!node)
            return undefined;
        if (curChain.length > 0) {
            for (let i = 0; i < curChain.length; i++) {
                let chainIndex = curChain[i];
                if (node[this.childrenName][chainIndex]) {
                    node = node[this.childrenName][chainIndex];
                }
                else {
                    return undefined;
                }
            }
        }
        else {
            return undefined;
        }
        return node;
    }
    setTimeScale(timeScale) {
        // 限制在0-50之间
        if (timeScale < 0) {
            timeScale = 0;
        }
        else if (timeScale > 50) {
            timeScale = 50;
        }
        if (Laya && Laya.timer) {
            Laya.timer.scale = timeScale;
        }
        return timeScale;
    }
    nextFrame() {
        _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.log('执行下一帧');
        if (!Laya || !Laya.timer) {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn('未找到Laya引擎实例或timer对象');
            return;
        }
        // 如果当前游戏是暂停状态（timeScale为0），执行一帧
        if (Laya.timer.scale === 0) {
            // 临时恢复时间流逝，让游戏执行一帧
            const originalScale = Laya.timer.scale;
            Laya.timer.scale = 1;
            // 使用 requestAnimationFrame 来精确控制一帧的执行
            requestAnimationFrame(() => {
                // 立即暂停游戏，防止执行多帧
                Laya.timer.scale = originalScale;
                _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.log('下一帧执行完成，恢复暂停状态');
            });
        }
        else {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn('只有在暂停状态下（timeScale=0）才能执行下一帧');
        }
    }
    pluginSetNodeByKey(exId, key, value) {
        let node = this.getNodeMemoryStroge(exId);
        if (node && node[key] !== undefined) {
            node[key] = value;
        }
    }
    ;
    outputToConsole(exId) {
        let node = this.getNodeMemoryStroge(exId);
        if (node) {
            console.log(node);
        }
    }
    getAllProps(obj, showPrivate, showFunction) {
        return _LayaPropParse__WEBPACK_IMPORTED_MODULE_1__.LayaPropParse.getAllProps(obj, showPrivate, showFunction);
    }
    getOrCreatePropStructure(obj, showPrivate, showFunction) {
        return _LayaPropParse__WEBPACK_IMPORTED_MODULE_1__.LayaPropParse.getOrCreatePropStructure(obj, showPrivate, showFunction);
    }
    setShowSelBox(val) {
        this.isShowSelBox = val;
        if (this.isShowSelBox) {
            let layaTreeDebugLayer = this.getLayaTreeDebugLayer();
            layaTreeDebugLayer.visible = this.isShowSelBox;
        }
        else {
            let stage = this.getStage();
            if (stage) {
                let layaTreeDebugLayer = stage.getChildByName(_Constant__WEBPACK_IMPORTED_MODULE_0__.Constant.DEBUG_LAYER_NAME);
                if (layaTreeDebugLayer != null) {
                    layaTreeDebugLayer.visible = this.isShowSelBox;
                }
            }
        }
    }
    getLayaTreeDebugLayer() {
        if (!Laya || !Laya.stage) {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn('未找到Laya引擎实例或stage对象');
            return null;
        }
        let layaTreeDebugLayer = Laya.stage.getChildByName(_Constant__WEBPACK_IMPORTED_MODULE_0__.Constant.DEBUG_LAYER_NAME);
        if (layaTreeDebugLayer == null) {
            layaTreeDebugLayer = new Laya.Sprite();
            layaTreeDebugLayer.name = _Constant__WEBPACK_IMPORTED_MODULE_0__.Constant.DEBUG_LAYER_NAME;
            layaTreeDebugLayer.zOrder = 1000;
            Laya.stage.addChild(layaTreeDebugLayer);
        }
        return layaTreeDebugLayer;
    }
    walkArr(arr, fun, _this = null) {
        if (!arr)
            return;
        var i;
        var len;
        len = arr.length;
        for (i = 0; i < len; i++) {
            fun.apply(_this, [arr[i], i]);
        }
    }
    showDisBoundToSprite(node, color, lineWidth) {
        let layaTreeDebugLayer = this.getLayaTreeDebugLayer();
        layaTreeDebugLayer.graphics.clear(true);
        let type = node.constructor.name;
        type = _LayaPropParse__WEBPACK_IMPORTED_MODULE_1__.LayaPropParse.getObfuscatedName(type);
        // 检查是否是3D节点
        if (_LayaPropParse__WEBPACK_IMPORTED_MODULE_1__.LayaPropParse.is3dObject(node, type)) {
            this.show3DBounds(node, layaTreeDebugLayer, color, lineWidth);
        }
        else {
            // 原有的2D节点处理逻辑
            var pointList;
            if (node._getBoundPointsM != null) {
                pointList = node._getBoundPointsM(true);
                if (!pointList || pointList.length < 1)
                    return;
                pointList = Laya.GrahamScan.pListToPointList(pointList, true);
                this.walkArr(pointList, node.localToGlobal, node);
                pointList = Laya.GrahamScan.pointListToPlist(pointList);
                let disBoundRec = Laya.Rectangle._getWrapRec(pointList);
                layaTreeDebugLayer.graphics.drawRect(disBoundRec.x, disBoundRec.y, disBoundRec.width, disBoundRec.height, null, color, lineWidth);
            }
        }
    }
    /**
     * 绘制3D节点的包围盒
     */
    show3DBounds(node, debugLayer, color, lineWidth) {
        try {
            // 获取当前活跃的相机
            let camera = this.getActiveCamera();
            if (!camera) {
                _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn('未找到活跃的相机，无法绘制3D包围盒');
                return;
            }
            // 获取节点的包围盒
            let bounds = this.get3DNodeBounds(node);
            if (!bounds) {
                _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn('无法获取3D节点的包围盒');
                return;
            }
            // 计算包围盒的8个顶点
            let vertices = this.getBoundingBoxVertices(bounds);
            // 将3D顶点转换为屏幕坐标
            let screenPoints = vertices.map(vertex => {
                return this.worldToScreen(vertex, camera);
            }).filter(point => point !== null);
            if (screenPoints.length === 8) {
                // 绘制立方体的12条边
                this.drawCubeWireframe(debugLayer, screenPoints, color, lineWidth);
            }
        }
        catch (error) {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.error('绘制3D包围盒失败:', error);
        }
    }
    /**
     * 获取活跃的相机
     */
    getActiveCamera() {
        try {
            if (!Laya || !Laya.stage) {
                _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.warn('未找到Laya引擎实例或stage对象');
                return null;
            }
            // 首先尝试获取场景中的相机
            let scene3D = Laya.stage.getChildByType ? Laya.stage.getChildByType(Laya.Scene3D) : null;
            if (scene3D) {
                let camera = scene3D.getChildByType ? scene3D.getChildByType(Laya.Camera) : null;
                if (camera)
                    return camera;
            }
            // 尝试从Scene3D的activeScene获取
            if (Laya.Scene3D && Laya.Scene3D.load) {
                let activeScene = Laya.Scene3D.load;
                if (activeScene && activeScene.getChildByType) {
                    let camera = activeScene.getChildByType(Laya.Camera);
                    if (camera)
                        return camera;
                }
            }
            // 递归查找相机
            return this.findCameraInChildren(Laya.stage);
        }
        catch (error) {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.error('获取相机失败:', error);
            return null;
        }
    }
    findCameraInChildren(node) {
        if (!node)
            return null;
        // 检查当前节点是否是相机
        if (node.constructor && node.constructor.name === 'Camera') {
            return node;
        }
        // 递归检查子节点
        let children = node[this.childrenName];
        if (children) {
            for (let i = 0; i < children.length; i++) {
                let camera = this.findCameraInChildren(children[i]);
                if (camera)
                    return camera;
            }
        }
        return null;
    }
    /**
     * 获取3D节点的包围盒
     */
    get3DNodeBounds(node) {
        try {
            // 尝试不同的包围盒获取方式
            if (node.bounds) {
                return node.bounds;
            }
            if (node.boundingBox) {
                return node.boundingBox;
            }
            if (node.getBounds && typeof node.getBounds === 'function') {
                return node.getBounds();
            }
            if (node.meshRenderer && node.meshRenderer.bounds) {
                return node.meshRenderer.bounds;
            }
            if (node.meshFilter && node.meshFilter.sharedMesh && node.meshFilter.sharedMesh.bounds) {
                return node.meshFilter.sharedMesh.bounds;
            }
            // 如果没有现成的包围盒，尝试创建一个简单的包围盒
            return this.createSimpleBounds(node);
        }
        catch (error) {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.error('获取3D包围盒失败:', error);
            return null;
        }
    }
    /**
     * 创建简单的包围盒
     */
    createSimpleBounds(node) {
        try {
            // 创建一个默认的包围盒 (1x1x1)
            let center = new Laya.Vector3(0, 0, 0);
            let size = new Laya.Vector3(1, 1, 1);
            // 如果节点有transform，使用其位置
            if (node.transform) {
                center.x = node.transform.localPositionX || 0;
                center.y = node.transform.localPositionY || 0;
                center.z = node.transform.localPositionZ || 0;
            }
            return {
                center: center,
                size: size,
                min: new Laya.Vector3(center.x - size.x / 2, center.y - size.y / 2, center.z - size.z / 2),
                max: new Laya.Vector3(center.x + size.x / 2, center.y + size.y / 2, center.z + size.z / 2)
            };
        }
        catch (error) {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.error('创建简单包围盒失败:', error);
            return null;
        }
    }
    /**
     * 获取包围盒的8个顶点
     */
    getBoundingBoxVertices(bounds) {
        try {
            let min, max;
            if (bounds.min && bounds.max) {
                min = bounds.min;
                max = bounds.max;
            }
            else if (bounds.center && bounds.size) {
                let halfSize = {
                    x: bounds.size.x / 2,
                    y: bounds.size.y / 2,
                    z: bounds.size.z / 2
                };
                min = new Laya.Vector3(bounds.center.x - halfSize.x, bounds.center.y - halfSize.y, bounds.center.z - halfSize.z);
                max = new Laya.Vector3(bounds.center.x + halfSize.x, bounds.center.y + halfSize.y, bounds.center.z + halfSize.z);
            }
            else {
                throw new Error('无效的包围盒格式');
            }
            // 立方体的8个顶点
            return [
                new Laya.Vector3(min.x, min.y, min.z), // 0: 左下后
                new Laya.Vector3(max.x, min.y, min.z), // 1: 右下后
                new Laya.Vector3(max.x, max.y, min.z), // 2: 右上后
                new Laya.Vector3(min.x, max.y, min.z), // 3: 左上后
                new Laya.Vector3(min.x, min.y, max.z), // 4: 左下前
                new Laya.Vector3(max.x, min.y, max.z), // 5: 右下前
                new Laya.Vector3(max.x, max.y, max.z), // 6: 右上前
                new Laya.Vector3(min.x, max.y, max.z) // 7: 左上前
            ];
        }
        catch (error) {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.error('获取包围盒顶点失败:', error);
            return [];
        }
    }
    /**
     * 将世界坐标转换为屏幕坐标
     */
    worldToScreen(worldPos, camera) {
        try {
            if (!camera || !worldPos)
                return null;
            if (!Laya || !Laya.stage)
                return null;
            // 创建临时向量
            let screenPos = new Laya.Vector3();
            // 使用相机的worldToScreen方法
            if (camera.worldToScreen && typeof camera.worldToScreen === 'function') {
                camera.worldToScreen(worldPos, screenPos);
                return { x: screenPos.x, y: screenPos.y };
            }
            // 如果没有worldToScreen方法，尝试手动计算
            if (camera.projectionViewMatrix) {
                let viewportMatrix = camera.viewport;
                let projectionViewMatrix = camera.projectionViewMatrix;
                // 将世界坐标转换为裁剪坐标
                let clipPos = new Laya.Vector4(worldPos.x, worldPos.y, worldPos.z, 1.0);
                Laya.Vector4.transformByM4x4(clipPos, projectionViewMatrix, clipPos);
                // 透视除法
                if (clipPos.w !== 0) {
                    clipPos.x /= clipPos.w;
                    clipPos.y /= clipPos.w;
                    clipPos.z /= clipPos.w;
                }
                // 转换到屏幕坐标
                let screenX = (clipPos.x + 1) * 0.5 * Laya.stage.width;
                let screenY = (1 - clipPos.y) * 0.5 * Laya.stage.height;
                return { x: screenX, y: screenY };
            }
            return null;
        }
        catch (error) {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.error('世界坐标转屏幕坐标失败:', error);
            return null;
        }
    }
    /**
     * 绘制立方体线框
     */
    drawCubeWireframe(debugLayer, points, color, lineWidth) {
        try {
            let graphics = debugLayer.graphics;
            // 立方体的12条边的连接关系
            let edges = [
                // 后面的4条边
                [0, 1], [1, 2], [2, 3], [3, 0],
                // 前面的4条边  
                [4, 5], [5, 6], [6, 7], [7, 4],
                // 连接前后的4条边
                [0, 4], [1, 5], [2, 6], [3, 7]
            ];
            // 绘制每条边
            edges.forEach(edge => {
                let startPoint = points[edge[0]];
                let endPoint = points[edge[1]];
                if (startPoint && endPoint) {
                    graphics.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y, color, lineWidth);
                }
            });
        }
        catch (error) {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.error('绘制立方体线框失败:', error);
        }
    }
    isShowStat() {
        return Laya.Stat._show;
    }
    setShowStat(show) {
        if (show) {
            Laya.Stat.show();
        }
        else {
            Laya.Stat.hide();
        }
    }
    initProxy() {
        if (!Laya)
            return;
        Laya.initProxy = true;
        // 保存当前引擎实例的引用
        const engineInstance = this;
        // 替换Node
        let rawChildChanged = Laya.Node.prototype._childChanged;
        Laya.Node.prototype._childChanged = function (child = null) {
            rawChildChanged.apply(this, [child]);
            // 刷新节点树的脏标记
            engineInstance.isTreeDirty = true;
        };
    }
    setTreeDirty(isDirty) {
        this.isTreeDirty = isDirty;
    }
    /**
     * 收集性能数据
     */
    collectPerformanceData() {
        try {
            const layaInstance = this.getLayaInstance();
            if (!layaInstance)
                return null;
            const performanceData = {
                timestamp: Date.now(),
                fps: 0,
                gpuUsage: 0,
                memory: {
                    used: 0,
                    total: 0
                },
                renderStats: {
                    drawCalls: 0,
                    triangles: 0,
                    textureMemory: 0
                },
                energyScore: 0
            };
            // 获取FPS数据
            if (layaInstance.Stat) {
                performanceData.fps = layaInstance.Stat.FPS || 60;
            }
            // 获取渲染统计
            if (layaInstance.Stat) {
                performanceData.renderStats.drawCalls = layaInstance.Stat.renderBatches || 0;
                performanceData.renderStats.triangles = layaInstance.Stat.trianglesFaces || 0;
                // 获取纹理内存（如果有）
                if (layaInstance.Stat.textureMemory) {
                    performanceData.renderStats.textureMemory = layaInstance.Stat.textureMemory;
                }
            }
            // 获取内存使用情况
            if (performance && performance.memory) {
                const memInfo = performance.memory;
                performanceData.memory.used = memInfo.usedJSHeapSize || 0;
                performanceData.memory.total = memInfo.totalJSHeapSize || memInfo.jsHeapSizeLimit || 0;
            }
            // 计算GPU使用率（模拟）
            // 基于draw calls和三角形数量估算
            const drawCallsScore = Math.min(performanceData.renderStats.drawCalls / 300, 1) * 50;
            const trianglesScore = Math.min(performanceData.renderStats.triangles / 100000, 1) * 50;
            performanceData.gpuUsage = Math.round(drawCallsScore + trianglesScore);
            // 计算能耗分数（基于FPS和GPU使用率）
            const fpsScore = (performanceData.fps / 60) * 50;
            const gpuScore = (100 - performanceData.gpuUsage) / 2;
            performanceData.energyScore = Math.round(fpsScore + gpuScore);
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.log('性能数据收集完成:', performanceData);
            return performanceData;
        }
        catch (error) {
            _Constant__WEBPACK_IMPORTED_MODULE_0__.Logger.error('收集性能数据失败:', error);
            return null;
        }
    }
    // 创建漫游相机
    createRoamCamera() {
        _RoamCamera__WEBPACK_IMPORTED_MODULE_2__.RoamCamera.Ins.createRoamCamera();
    }
}


/***/ }),

/***/ "./src/core/engine/laya/LayaPropConfig.ts":
/*!************************************************!*\
  !*** ./src/core/engine/laya/LayaPropConfig.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LayaPropConfig: () => (/* binding */ LayaPropConfig)
/* harmony export */ });
const LayaPropConfig = {
    "Transform3D": {
        "name": "变换",
        "icon": "icon-transform3d",
        "item": [
            {
                "name": "Position",
                "displayName": "位置",
                "type": "vector3",
                "fieldType": "vector3",
                "value": "localPosition",
                "options": {
                    "members": ["x", "y", "z"],
                    "titles": ["X", "Y", "Z"]
                },
                "step": 0.01,
                "precision": 3
            },
            {
                "name": "Rotation",
                "displayName": "旋转",
                "type": "vector3",
                "fieldType": "vector3",
                "value": "localRotationEuler",
                "options": {
                    "members": ["x", "y", "z"],
                    "titles": ["X", "Y", "Z"]
                },
                "step": 1,
                "precision": 1,
                "min": -360,
                "max": 360
            },
            {
                "name": "Scale",
                "displayName": "缩放",
                "type": "vector3",
                "fieldType": "vector3",
                "value": "localScale",
                "options": {
                    "members": ["x", "y", "z"],
                    "titles": ["X", "Y", "Z"]
                },
                "step": 0.01,
                "precision": 3,
                "min": 0
            }
        ]
    },
    "Node2D": {
        "name": "基础",
        "icon": "icon-transform2d",
        "item": [
            {
                "name": "Position",
                "displayName": "位置",
                "type": "vector2",
                "fieldType": "vector2",
                "options": {
                    "members": ["x", "y"],
                    "titles": ["X", "Y"]
                },
                "step": 1,
                "precision": 1
            },
            {
                "name": "Size",
                "displayName": "尺寸",
                "type": "vector2",
                "fieldType": "vector2",
                "options": {
                    "members": ["width", "height"],
                    "titles": ["W", "H"]
                },
                "step": 1,
                "precision": 0,
                "min": 0
            },
            {
                "name": "Anchor",
                "displayName": "锚点",
                "type": "vector2",
                "fieldType": "vector2",
                "options": {
                    "members": ["anchorX", "anchorY"],
                    "titles": ["X", "Y"]
                },
                "step": 0.01,
                "precision": 2,
                "min": 0,
                "max": 1
            },
            {
                "name": "Scale",
                "displayName": "缩放",
                "type": "vector2",
                "fieldType": "vector2",
                "options": {
                    "members": ["scaleX", "scaleY"],
                    "titles": ["X", "Y"]
                },
                "step": 0.01,
                "precision": 3,
                "min": 0
            },
            {
                "name": "Skew",
                "displayName": "倾斜",
                "type": "vector2",
                "fieldType": "vector2",
                "options": {
                    "members": ["skewX", "skewY"],
                    "titles": ["X", "Y"]
                },
                "step": 1,
                "precision": 1
            },
            {
                "name": "Rotation",
                "displayName": "旋转",
                "type": "number",
                "fieldType": "number",
                "value": "rotation",
                "step": 1,
                "precision": 1,
                "min": -360,
                "max": 360
            },
            {
                "name": "visible",
                "displayName": "可见",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "visible"
            },
            {
                "name": "alpha",
                "displayName": "透明度",
                "type": "number",
                "fieldType": "slider",
                "value": "alpha",
                "step": 0.01,
                "precision": 2,
                "min": 0,
                "max": 1
            },
            {
                "name": "mouseEnabled",
                "displayName": "鼠标触摸启用",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "mouseEnabled"
            },
            {
                "name": "mouseThrough",
                "displayName": "鼠标触摸穿透",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "mouseThrough"
            },
            {
                "name": "zOrder",
                "displayName": "zOrder",
                "type": "number",
                "fieldType": "number",
                "value": "zOrder",
                "step": 1,
                "precision": 0
            }
        ]
    },
    "Camera": {
        "name": "相机",
        "icon": "icon-camera",
        "item": [
            {
                "name": "orthographic",
                "displayName": "正交投影",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "orthographic"
            },
            {
                "name": "orthographicVerticalSize",
                "displayName": "正交尺寸",
                "type": "number",
                "fieldType": "number",
                "value": "orthographicVerticalSize",
                "step": 1,
                "precision": 1,
                "min": 0.1
            },
            {
                "name": "fieldOfView",
                "displayName": "视野角度",
                "type": "number",
                "fieldType": "slider",
                "value": "fieldOfView",
                "step": 1,
                "precision": 0,
                "min": 4,
                "max": 120
            },
            {
                "name": "aspectRatio",
                "displayName": "aspectRatio",
                "type": "number",
                "fieldType": "number",
                "value": "aspectRatio",
                "step": 0.01,
                "precision": 2
            },
            {
                "name": "nearPlane",
                "displayName": "近裁剪面",
                "type": "number",
                "fieldType": "number",
                "value": "nearPlane",
                "step": 0.01,
                "precision": 3,
                "min": 0.01
            },
            {
                "name": "farPlane",
                "displayName": "远裁剪面",
                "type": "number",
                "fieldType": "number",
                "value": "farPlane",
                "step": 1,
                "precision": 1,
                "min": 1
            },
            {
                "name": "clearFlag",
                "displayName": "清除标志",
                "type": "dropdown",
                "fieldType": "dropdown",
                "value": "clearFlag",
                "options": ["SolidColor", "Sky", "DepthOnly", "Nothing"]
            },
            {
                "name": "clearColor",
                "displayName": "清除颜色",
                "type": "color",
                "fieldType": "color",
                "value": "clearColor",
                "options": {
                    "supportAlpha": true,
                    "format": "rgba"
                }
            },
            {
                "name": "enableHDR",
                "displayName": "启用HDR",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "enableHDR"
            },
            {
                "name": "msaa",
                "displayName": "msaa",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "msaa"
            },
            {
                "name": "fxaa",
                "displayName": "fxaa",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "fxaa"
            },
            {
                "name": "cullingMask",
                "displayName": "剔除遮罩",
                "type": "number",
                "fieldType": "number",
                "value": "cullingMask",
                "step": 1,
                "precision": 0,
                "min": 0
            }
        ]
    },
    "NodeInfo": {
        "name": "节点信息",
        "icon": "icon-info",
        "item": [
            {
                "name": "name",
                "displayName": "名称",
                "type": "text",
                "fieldType": "text",
                "value": "name"
            },
            {
                "name": "active",
                "displayName": "激活状态",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "active"
            },
            {
                "name": "consoleOutput",
                "displayName": "输出到控制台",
                "type": "button",
                "fieldType": "button",
                "action": "outputToConsole"
            }
        ]
    },
    "Scene3D": {
        "name": "场景3D",
        "icon": "icon-scene3d",
        "item": [
            {
                "name": "ambientMode",
                "displayName": "环境光模式",
                "type": "dropdown",
                "fieldType": "dropdown",
                "value": "ambientMode",
                "options": ["SolidColor", "SphericalHarmonics"]
            },
            {
                "name": "ambientColor",
                "displayName": "环境光颜色",
                "type": "color",
                "fieldType": "color",
                "value": "ambientColor",
                "options": {
                    "supportAlpha": true,
                    "format": "rgba"
                }
            },
            {
                "name": "ambientIntensity",
                "displayName": "环境光强度",
                "type": "number",
                "fieldType": "slider",
                "value": "ambientIntensity",
                "step": 0.01,
                "precision": 2,
                "min": 0,
                "max": 2
            },
            {
                "name": "shadowMapFrequency",
                "displayName": "阴影贴图频率",
                "type": "number",
                "fieldType": "number",
                "value": "shadowMapFrequency",
                "step": 1,
                "precision": 0,
                "min": 1
            },
            {
                "name": "_reflectionsSource",
                "displayName": "反射源",
                "type": "dropdown",
                "fieldType": "dropdown",
                "value": "_reflectionsSource",
                "options": ["Skybox", "Custom"]
            },
            {
                "name": "_reflectionsResolution",
                "displayName": "反射分辨率",
                "type": "dropdown",
                "fieldType": "dropdown",
                "value": "_reflectionsResolution",
                "options": ["16", "32", "64", "128", "256", "512", "1024", "2048"]
            },
            {
                "name": "reflectionIntensity",
                "displayName": "反射强度",
                "type": "number",
                "fieldType": "slider",
                "value": "reflectionIntensity",
                "step": 0.01,
                "precision": 2,
                "min": 0,
                "max": 2
            },
            {
                "name": "enableFog",
                "displayName": "启用雾效",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "enableFog"
            },
            {
                "name": "fogMode",
                "displayName": "雾效模式",
                "type": "dropdown",
                "fieldType": "dropdown",
                "value": "fogMode",
                "options": ["Linear", "EXP", "EXP2"]
            },
            {
                "name": "fogStart",
                "displayName": "雾效开始距离",
                "type": "number",
                "fieldType": "number",
                "value": "fogStart",
                "step": 1,
                "precision": 1,
                "min": 0
            },
            {
                "name": "fogEnd",
                "displayName": "雾效结束距离",
                "type": "number",
                "fieldType": "number",
                "value": "fogEnd",
                "step": 1,
                "precision": 1,
                "min": 0
            },
            {
                "name": "fogDensity",
                "displayName": "雾效密度",
                "type": "number",
                "fieldType": "number",
                "value": "fogDensity",
                "step": 0.001,
                "precision": 4,
                "min": 0
            },
            {
                "name": "fogColor",
                "displayName": "雾效颜色",
                "type": "color",
                "fieldType": "color",
                "value": "fogColor",
                "options": {
                    "supportAlpha": true,
                    "format": "rgba"
                }
            }
        ]
    },
    "Text": {
        "name": "文本",
        "icon": "icon-text",
        "item": [
            {
                "name": "text",
                "displayName": "文本内容",
                "type": "text",
                "fieldType": "text",
                "value": "text"
            },
            {
                "name": "fontSize",
                "displayName": "字体大小",
                "type": "number",
                "fieldType": "number",
                "value": "fontSize",
                "step": 1,
                "precision": 0,
                "min": 1,
                "max": 200
            },
            {
                "name": "font",
                "displayName": "字体",
                "type": "text",
                "fieldType": "text",
                "value": "font"
            },
            {
                "name": "color",
                "displayName": "文本颜色",
                "type": "colorString",
                "fieldType": "colorString",
                "value": "color",
                "options": {
                    "supportAlpha": false,
                    "format": "hex"
                }
            },
            {
                "name": "align",
                "displayName": "对齐方式",
                "type": "dropdownString",
                "fieldType": "dropdownString",
                "value": "align",
                "options": ["left", "center", "right"]
            },
            {
                "name": "valign",
                "displayName": "垂直对齐",
                "type": "dropdownString",
                "fieldType": "dropdownString",
                "value": "valign",
                "options": ["top", "middle", "bottom"]
            },
            {
                "name": "bold",
                "displayName": "粗体",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "bold"
            },
            {
                "name": "italic",
                "displayName": "斜体",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "italic"
            },
            {
                "name": "wordWrap",
                "displayName": "自动换行",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "wordWrap"
            },
            {
                "name": "leading",
                "displayName": "行间距",
                "type": "number",
                "fieldType": "number",
                "value": "leading",
                "step": 1,
                "precision": 0,
                "min": 0
            },
            {
                "name": "padding",
                "displayName": "内边距",
                "type": "vector2",
                "fieldType": "vector2",
                "options": {
                    "members": ["x", "y"],
                    "titles": ["X", "Y"]
                },
                "step": 1,
                "precision": 0,
                "min": 0
            },
            {
                "name": "stroke",
                "displayName": "描边宽度",
                "type": "number",
                "fieldType": "number",
                "value": "stroke",
                "step": 1,
                "precision": 0,
            },
            {
                "name": "strokeColor",
                "displayName": "描边颜色",
                "type": "colorString",
                "fieldType": "colorString",
                "value": "strokeColor",
                "options": {
                    "supportAlpha": false,
                    "format": "hex"
                }
            },
        ]
    },
    "Image": {
        "name": "图片",
        "icon": "icon-image",
        "item": [
            {
                "name": "skin",
                "displayName": "皮肤资源",
                "type": "text",
                "fieldType": "text",
                "value": "skin",
                "editable": false
            },
            {
                "name": "useSourceSize",
                "displayName": "使用源尺寸",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "useSourceSize"
            },
            {
                "name": "sizeGrid",
                "displayName": "九宫格切片",
                "type": "text",
                "fieldType": "text",
                "value": "sizeGrid",
                "editable": false
            },
            {
                "name": "color",
                "displayName": "颜色",
                "type": "colorString",
                "fieldType": "colorString",
                "value": "color",
                "options": {
                    "supportAlpha": false,
                    "format": "hex"
                }
            },
            {
                "name": "group",
                "displayName": "分组",
                "type": "text",
                "fieldType": "text",
                "value": "group",
                "editable": false
            },
            {
                "name": "testClick",
                "displayName": "测试点击",
                "type": "button",
                "fieldType": "button",
                "value": "点击测试",
                "action": "testButtonClick"
            }
        ]
    },
    "Button": {
        "name": "按钮",
        "icon": "icon-button",
        "item": [
            {
                "name": "skin",
                "displayName": "皮肤",
                "type": "text",
                "fieldType": "text",
                "value": "skin",
                "editable": false
            },
            {
                "name": "label",
                "displayName": "标签文本",
                "type": "text",
                "fieldType": "text",
                "value": "label"
            },
            {
                "name": "labelFont",
                "displayName": "标签字体",
                "type": "text",
                "fieldType": "text",
                "value": "labelFont",
                "editable": false
            },
            {
                "name": "labelSize",
                "displayName": "标签大小",
                "type": "number",
                "fieldType": "number",
                "value": "labelSize",
                "min": 1,
                "max": 100,
                "step": 1
            },
            {
                "name": "labelColor",
                "displayName": "标签颜色",
                "type": "colorString",
                "fieldType": "colorString",
                "value": "labelColor",
                "options": {
                    "supportAlpha": false,
                    "format": "hex"
                }
            },
            {
                "name": "labelAlign",
                "displayName": "标签水平对齐",
                "type": "dropdownString",
                "fieldType": "dropdownString",
                "value": "labelAlign",
                "options": ["left", "center", "right"]
            },
            {
                "name": "labelVAlign",
                "displayName": "标签垂直对齐",
                "type": "dropdownString",
                "fieldType": "dropdownString",
                "value": "labelVAlign",
                "options": ["top", "middle", "bottom"]
            },
            {
                "name": "labelBold",
                "displayName": "标签粗体",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "labelBold"
            },
            {
                "name": "labelItalic",
                "displayName": "标签斜体",
                "type": "boolean",
                "fieldType": "boolean",
                "value": "labelItalic"
            },
            {
                "name": "labelPadding",
                "displayName": "标签内边距",
                "type": "vector4",
                "fieldType": "vector4",
                "value": "labelPadding",
                "options": {
                    "members": ["left", "top", "right", "bottom"],
                    "titles": ["左", "上", "右", "下"]
                }
            },
            {
                "name": "stateNum",
                "displayName": "状态数量",
                "type": "number",
                "fieldType": "number",
                "value": "stateNum",
                "min": 1,
                "max": 3,
                "step": 1,
                "precision": 0
            },
            {
                "name": "group",
                "displayName": "分组",
                "type": "text",
                "fieldType": "text",
                "value": "group",
                "editable": false
            }
        ]
    },
    "Component": {
        "name": "组件",
        "icon": "icon-component",
        "item": [
            {
                "name": "name",
                "displayName": "名字",
                "type": "text",
                "fieldType": "text",
                "value": "name",
                "editable": false
            },
            {
                "name": "index",
                "displayName": "索引",
                "type": "number",
                "fieldType": "number",
                "value": "index",
                "editable": false
            }
        ]
    }
};


/***/ }),

/***/ "./src/core/engine/laya/LayaPropParse.ts":
/*!***********************************************!*\
  !*** ./src/core/engine/laya/LayaPropParse.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LayaPropParse: () => (/* binding */ LayaPropParse)
/* harmony export */ });
/* harmony import */ var _LayaPropConfig__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./LayaPropConfig */ "./src/core/engine/laya/LayaPropConfig.ts");

class LayaPropParse {
    // 根据字段类型和配置创建属性项
    static createPropertyItem(fieldConfig, value) {
        const fieldTypeConfig = this.fieldTypeConfig[fieldConfig.fieldType];
        if (!fieldTypeConfig) {
            console.warn(`未知的字段类型: ${fieldConfig.fieldType}`);
            return null;
        }
        return {
            name: fieldConfig.name,
            displayName: fieldConfig.displayName || fieldConfig.name,
            value: value,
            type: fieldConfig.type,
            fieldType: fieldConfig.fieldType,
            component: fieldTypeConfig.component,
            props: Object.assign(Object.assign({}, fieldTypeConfig.props), { step: fieldConfig.step || fieldTypeConfig.props.step, precision: fieldConfig.precision || fieldTypeConfig.props.precision, min: fieldConfig.min, max: fieldConfig.max }),
            options: fieldConfig.options
        };
    }
    static is3dObject(node, type) {
        // Scene3D 是特殊的3D对象，但没有Transform3D
        if (type === 'Scene3D') {
            return false; // Scene3D 不需要Transform3D处理
        }
        if (node.transform) {
            let typeName = node.transform.constructor.name;
            typeName = LayaPropParse.getObfuscatedName(typeName);
            if (typeName == 'Transform3D') {
                return true;
            }
        }
        return false;
    }
    static parse(node, type) {
        if (node.destroyed == true) {
            return null;
        }
        let prop = [];
        // 节点信息
        let name = node.name;
        if (!name) {
            let typeName = node.constructor.name;
            typeName = LayaPropParse.getObfuscatedName(typeName);
            if (node.$owner) {
                name = node.$owner._name || node.$owner.constructor.name;
            }
            else {
                name = typeName;
            }
        }
        let nodeInfoItem = {
            t: 'NodeInfo',
            v: [name, node.active]
        };
        prop.push(nodeInfoItem);
        let nodeType = type;
        if (this.is3dObject(node, type)) {
            let pos = node.transform.localPosition;
            let rotRuler = node.transform.localRotationEuler;
            let scale = node.transform.localScale;
            let propItem = {
                t: 'Transform3D',
                v: [[pos.x, pos.y, pos.z], [rotRuler.x, rotRuler.y, rotRuler.z], [scale.x, scale.y, scale.z]]
            };
            prop.push(propItem);
        }
        else {
            if (nodeType != 'Scene3D') {
                let propItem = {
                    t: 'Node2D',
                    v: [[node.x, node.y], [node.width, node.height], [node.anchorX, node.anchorY], [node.scaleX, node.scaleY], [node.skewX, node.skewY], node.rotation, node.visible, node.alpha, node.mouseEnabled, node.mouseThrough, node.zOrder]
                };
                prop.push(propItem);
            }
        }
        // 判断节点类型
        switch (nodeType) {
            case 'Camera':
                let cameraItem = {
                    t: 'Camera',
                    v: [node.orthographic, node.orthographicVerticalSize, node.fieldOfView, node.aspectRatio, node.nearPlane, node.farPlane, node.clearFlag, [node.clearColor.r, node.clearColor.g, node.clearColor.b, node.clearColor.a], node.enableHDR, node.msaa, node.fxaa, node.cullingMask]
                };
                prop.push(cameraItem);
                break;
            case 'Scene3D':
                let scene3DItem = {
                    t: 'Scene3D',
                    v: [
                        node.ambientMode,
                        node.ambientColor ? [node.ambientColor.r, node.ambientColor.g, node.ambientColor.b, node.ambientColor.a] : [0.7, 0.7, 0.7, 1],
                        node.ambientIntensity || 1,
                        node.shadowMapFrequency || 1,
                        node._reflectionsSource || 0,
                        node._reflectionsResolution || "256",
                        node.reflectionIntensity || 1,
                        node.enableFog || false,
                        node.fogMode || 0,
                        node.fogStart || 300,
                        node.fogEnd || 1000,
                        node.fogDensity || 0.01,
                        node.fogColor ? [node.fogColor.r, node.fogColor.g, node.fogColor.b, node.fogColor.a] : [0.7, 0.7, 0.7, 1]
                    ]
                };
                prop.push(scene3DItem);
                break;
            case 'Text':
                let textItem = {
                    t: 'Text',
                    v: [
                        node.text || '',
                        node.fontSize || 12,
                        node.font || 'Arial',
                        node.color || '#000000',
                        node.align || 'left',
                        node.valign || 'top',
                        node.bold || false,
                        node.italic || false,
                        node.wordWrap || false,
                        node.leading || 0,
                        [node.padding ? node.padding.x || 0 : 0, node.padding ? node.padding.y || 0 : 0],
                        node.stroke || 0,
                        node.strokeColor || '#000000'
                    ]
                };
                prop.push(textItem);
                break;
            case 'Image':
                let imageItem = {
                    t: 'Image',
                    v: [
                        node.skin || '',
                        node.useSourceSize || false,
                        node.sizeGrid || '',
                        node.color || '#FFFFFF',
                        node.group || ''
                    ]
                };
                prop.push(imageItem);
                break;
            case 'Button':
                let buttonItem = {
                    t: 'Button',
                    v: [
                        node.skin || '',
                        node.label || '',
                        node.labelFont || '',
                        node.labelSize || 12,
                        node.labelColor || '#000000',
                        node.labelAlign || 'center',
                        node.labelVAlign || 'middle',
                        node.labelBold || false,
                        node.labelItalic || false,
                        node.labelPadding ? [node.labelPadding.left || 0, node.labelPadding.top || 0, node.labelPadding.right || 0, node.labelPadding.bottom || 0] : [0, 0, 0, 0],
                        node.stateNum || 1,
                        node.group || ''
                    ]
                };
                prop.push(buttonItem);
                break;
            default:
                break;
        }
        // 组件类型
        let components = node._components;
        if (components && components.length > 0) {
            for (let i = 0; i < components.length; i++) {
                let componentName = components[i].constructor.name;
                componentName = LayaPropParse.getObfuscatedName(componentName);
                if (componentName) {
                    let propItem = {
                        t: 'Component',
                        v: [componentName, i]
                    };
                    prop.push(propItem);
                }
            }
            ;
        }
        return {
            prop: prop,
            name: node.name,
            active: node.active,
            exId: node.exId
        };
    }
    /**
     * 初始化混淆名称映射
     */
    static initObfuscationName() {
        const layaInstance = LayaPropParse.getLayaInstance();
        if (layaInstance) {
            // 混淆检测与映射
            if (layaInstance.stage && layaInstance.stage.constructor.name === 'Stage') {
                return;
            }
            Object.keys(layaInstance).forEach(key => {
                if (layaInstance[key] && (layaInstance[key].prototype instanceof layaInstance.Node || layaInstance[key].prototype instanceof layaInstance.EventDispatcher || layaInstance[key].prototype instanceof layaInstance.Component)) {
                    let name = layaInstance[key].name;
                    if (name) {
                        LayaPropParse.layaObfuscationMap.set(name, key);
                    }
                }
            });
        }
    }
    /**
     * 获取混淆映射的真实名称
     */
    static getObfuscatedName(name) {
        return LayaPropParse.layaObfuscationMap.get(name) || name;
    }
    /**
     * 获取混淆映射Map
     */
    static getObfuscationMap() {
        return LayaPropParse.layaObfuscationMap;
    }
    static getLayaInstance() {
        // 如果已经缓存了有效的Laya实例，直接返回
        // 1. 首先检查主窗口
        if (window.Laya) {
            return window.Laya;
        }
        return null;
    }
    static getNodeType(node) {
        let typeName = LayaPropParse.getObfuscatedName(node.constructor.name);
        return typeName;
    }
    /**
     * 生成对象类型的缓存key
     * @param obj 对象实例
     * @param showPrivate 是否显示私有属性
     * @param showFunction 是否显示函数属性
     * @returns 缓存key
     */
    static generateCacheKey(obj, showPrivate, showFunction) {
        var _a, _b;
        // 获取构造函数名作为基础key
        const className = ((_a = obj.constructor) === null || _a === void 0 ? void 0 : _a.name) || 'Unknown';
        // 生成原型链的简单哈希
        let prototypeHash = '';
        let temp = obj;
        let depth = 0;
        const maxDepth = 10; // 限制原型链深度，避免无限循环
        while (temp && depth < maxDepth) {
            const proto = Object.getPrototypeOf(temp);
            if (!proto || proto === Object.prototype)
                break;
            prototypeHash += (((_b = proto.constructor) === null || _b === void 0 ? void 0 : _b.name) || '') + '_';
            temp = proto;
            depth++;
        }
        return `${className}_${prototypeHash}_${showPrivate}_${showFunction}`;
    }
    /**
     * 从缓存中获取属性结构或创建新的缓存
     * @param obj 对象实例
     * @param showPrivate 是否显示私有属性
     * @param showFunction 是否显示函数属性
     * @returns 属性元数据数组
     */
    static getOrCreatePropStructure(obj, showPrivate, showFunction) {
        const cacheKey = this.generateCacheKey(obj, showPrivate, showFunction);
        // 尝试从缓存中获取
        const cached = this.propStructureCache.get(cacheKey);
        if (cached) {
            return cached;
        }
        // 缓存未命中，创建新的属性结构
        const propMetadata = [];
        let temp = obj;
        while (temp) {
            const keys = Reflect.ownKeys(temp);
            const length = keys.length;
            for (let i = 0; i < length; i++) {
                const propName = keys[i];
                if (typeof propName !== "string")
                    continue;
                // 检查是否已经在数组中（避免重复）
                if (propMetadata.some(meta => meta.name === propName))
                    continue;
                const firstChar = propName.charAt(0);
                const isPrivate = firstChar === "_" || firstChar === "$";
                // 根据过滤条件决定是否包含
                if (!showPrivate && isPrivate)
                    continue;
                const propInfo = Object.getOwnPropertyDescriptor(temp, propName);
                const hasGetter = (propInfo === null || propInfo === void 0 ? void 0 : propInfo.get) !== undefined;
                const hasSetter = hasGetter && propInfo.set !== undefined;
                propMetadata.push({
                    name: propName,
                    isPrivate,
                    isGetter: hasGetter,
                    isSetter: hasSetter,
                });
            }
            temp = Object.getPrototypeOf(temp);
        }
        // 缓存结果
        this.propStructureCache.set(cacheKey, propMetadata);
        return propMetadata;
    }
    /**
     * 清空属性结构缓存
     */
    static clearCache() {
        this.propStructureCache.clear();
    }
    static getAllProps(obj, showPrivate, showFunction) {
        const props = {};
        // 使用缓存获取属性结构
        const propStructure = this.getOrCreatePropStructure(obj, showPrivate, showFunction);
        // 为每个属性获取当前值
        for (const metadata of propStructure) {
            let value;
            try {
                value = obj[metadata.name];
            }
            catch (_a) {
                value = null;
            }
            const type = typeof value;
            // 应用showFunction过滤
            if (!showFunction && type === "function") {
                continue;
            }
            const expandable = type === "object" && value !== null;
            props[metadata.name] = {
                name: metadata.name,
                isPrivate: metadata.isPrivate,
                isGetter: metadata.isGetter,
                isSetter: metadata.isSetter,
                type: type,
                expandable,
                value: this.stringifyValue(value, type)
            };
        }
        return props;
    }
    static stringifyValue(value, preComputedType) {
        if (value === null)
            return "null";
        if (value === undefined)
            return "undefined";
        const type = preComputedType || typeof value;
        switch (type) {
            case "string":
                return value;
            case "number":
                return Number.isNaN(value) ? "NaN" : String(value);
            case "bigint":
                return String(value);
            case "object":
                return Array.isArray(value) ? "array" : this.getClassName(value);
            case "function":
                return String(value);
            default:
                return String(value);
        }
    }
    static getClassName(obj) {
        const objType = typeof obj;
        if (objType === "number" || objType === "string")
            return String(obj);
        // 优化FGUI对象检测
        const owner = obj.$owner || obj.$gobj;
        if (owner) {
            const constructor = owner.constructor;
            if ((constructor === null || constructor === void 0 ? void 0 : constructor.name) && constructor.name.length > 2) {
                return constructor.name;
            }
            return typeof owner;
        }
        // 优化__className检测
        const className = obj.__className;
        if (className && !className.toLowerCase().startsWith("laya")) {
            return className;
        }
        // 通用构造函数名检测
        const constructor = obj.constructor;
        if ((constructor === null || constructor === void 0 ? void 0 : constructor.name) && constructor.name.length > 2) {
            return constructor.name;
        }
        return typeof obj;
    }
}
// 属性结构缓存 - 根据对象类型缓存属性元数据
LayaPropParse.propStructureCache = new Map();
// Laya混淆映射map
LayaPropParse.layaObfuscationMap = new Map();
// 字段类型映射配置
LayaPropParse.fieldTypeConfig = {
    // 数字类型字段配置
    number: {
        component: 'PropertyInput',
        props: {
            step: 0.01,
            precision: 5
        }
    },
    // 滑动条类型字段配置
    slider: {
        component: 'SliderInput',
        props: {
            step: 0.01,
            precision: 2
        }
    },
    // 向量类型字段配置
    vector2: {
        component: 'VectorInput',
        props: {
            type: 'vector2',
            step: 0.01
        }
    },
    vector3: {
        component: 'VectorInput',
        props: {
            type: 'vector3',
            step: 0.01
        }
    },
    vector4: {
        component: 'VectorInput',
        props: {
            type: 'vector4',
            step: 0.01
        }
    },
    // 布尔类型字段配置
    boolean: {
        component: 'checkbox',
        props: {}
    },
    // 文本类型字段配置
    text: {
        component: 'text-input',
        props: {}
    },
    // 字符串类型字段配置
    string: {
        component: 'text-input',
        props: {}
    },
    // 下拉框类型字段配置
    dropdown: {
        component: 'dropdown',
        props: {}
    },
    // 颜色选择器类型字段配置
    color: {
        component: 'color-input',
        props: {
            supportAlpha: true
        }
    },
    // 颜色字符串类型字段配置（#FFFFFF格式）
    colorString: {
        component: 'color-string-input',
        props: {
            supportAlpha: false,
            format: 'hex'
        }
    },
    // 按钮类型字段配置
    button: {
        component: 'button',
        props: {}
    }
};
LayaPropParse.propTypeMap = _LayaPropConfig__WEBPACK_IMPORTED_MODULE_0__.LayaPropConfig;


/***/ }),

/***/ "./src/core/engine/laya/RoamCamera.ts":
/*!********************************************!*\
  !*** ./src/core/engine/laya/RoamCamera.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RoamCamera: () => (/* binding */ RoamCamera)
/* harmony export */ });
class RoamCamera {
    static get Ins() {
        if (!RoamCamera.instance) {
            RoamCamera.instance = new RoamCamera();
        }
        return RoamCamera.instance;
    }
    constructor() {
    }
    createRoamCamera() {
        let camera = this.getActiveCamera();
        if (!camera) {
            return;
        }
        this.camera = camera.clone();
        this.camera.name = 'RoamCamera';
        // this.camera.addComponent(CameraMoveScript);
        camera.parent.addChild(this.camera);
    }
    removeRoamCamera() {
        if (this.camera) {
            this.camera.removeSelf();
        }
    }
    getActiveCamera() {
        if (!Laya.stage._scene3Ds) {
            return undefined;
        }
        for (let scene of Laya.stage._scene3Ds) {
            // 获取场景中的相机池
            let cameras = scene._cameraPool;
            // 找到正在渲染的相机
            for (let camera of cameras) {
                if (camera.enableRender && camera.activeInHierarchy) {
                    // 这就是当前正在输出的相机
                    return camera;
                }
            }
        }
        return undefined;
    }
}
// export class CameraMoveScript extends Laya.Script3D {
//     /** @private */
//     protected _tempVector3:Laya.Vector3 = new Laya.Vector3();
//     protected lastMouseX:number;
//     protected lastMouseY:number;
//     protected yawPitchRoll:Laya.Vector3 = new Laya.Vector3();
//     protected resultRotation:Laya.Quaternion = new Laya.Quaternion();
//     protected tempRotationZ:Laya.Quaternion = new Laya.Quaternion();
//     protected tempRotationX:Laya.Quaternion = new Laya.Quaternion();
//     protected tempRotationY:Laya.Quaternion = new Laya.Quaternion();
//     protected isMouseDown:Boolean;
//     protected rotaionSpeed:number = 0.00006;
//     protected camera:Laya.BaseCamera;
//     protected scene:Laya.Scene3D;
//     constructor() {
//         super();
//     }
//     /**
//      * @private
//      */
//     protected _updateRotation():void {
//         if (Math.abs(this.yawPitchRoll.y) < 1.50) {
//             Laya.Quaternion.createFromYawPitchRoll(this.yawPitchRoll.x, this.yawPitchRoll.y, this.yawPitchRoll.z, this.tempRotationZ);
//             this.tempRotationZ.cloneTo(this.camera.transform.localRotation);
//             this.camera.transform.localRotation = this.camera.transform.localRotation;
//         }
//     }
//     /**
//      * @inheritDoc
//      */
//     public onAwake():void {
//         Laya.stage.on(Laya.Event.RIGHT_MOUSE_DOWN, this, this.mouseDown);
//         Laya.stage.on(Laya.Event.RIGHT_MOUSE_UP, this, this.mouseUp);
//         //Laya.stage.on(Event.RIGHT_MOUSE_OUT, this, mouseOut);
//         this.camera = this.owner as Laya.Camera;
//     }
//     /**
//      * @inheritDoc
//      */
//     public onUpdate():void {
//         let elapsedTime:number = Laya.timer.delta;
//         if (!isNaN(this.lastMouseX) && !isNaN(this.lastMouseY) && this.isMouseDown) {
//             Laya.InputManager.hasKeyDown(87) && this.moveForward(-0.01 * elapsedTime);//W
//             Laya.InputManager.hasKeyDown(83) && this.moveForward(0.01 * elapsedTime);//S
//             Laya.InputManager.hasKeyDown(65) && this.moveRight(-0.01 * elapsedTime);//A
//             Laya.InputManager.hasKeyDown(68) && this.moveRight(0.01 * elapsedTime);//D
//             Laya.InputManager.hasKeyDown(81) && this.moveVertical(0.01 * elapsedTime);//Q
//             Laya.InputManager.hasKeyDown(69) && this.moveVertical(-0.01 * elapsedTime);//E
//             let offsetX:number = Laya.stage.mouseX - this.lastMouseX;
//             let offsetY:number = Laya.stage.mouseY - this.lastMouseY;
//             let yprElem:Laya.Vector3 = this.yawPitchRoll;
//             yprElem.x -= offsetX * this.rotaionSpeed * elapsedTime;
//             yprElem.y -= offsetY * this.rotaionSpeed * elapsedTime;
//             this._updateRotation();
//         }
//         this.lastMouseX = Laya.stage.mouseX;
//         this.lastMouseY = Laya.stage.mouseY;
//     }
//     /**
//      * @inheritDoc
//      */
//     public onDestroy():void {
//         Laya.stage.off(Laya.Event.RIGHT_MOUSE_DOWN, this, this.mouseDown);
//         Laya.stage.off(Laya.Event.RIGHT_MOUSE_UP, this, this.mouseUp);
//     }
//     protected mouseDown(e:Event):void {
//         this.camera.transform.localRotation.getYawPitchRoll(this.yawPitchRoll);
//         this.lastMouseX = Laya.stage.mouseX;
//         this.lastMouseY = Laya.stage.mouseY;
//         this.isMouseDown = true;
//     }
//     protected mouseUp(e:Event):void {
//         this.isMouseDown = false;
//     }
//     protected mouseOut(e:Event):void {
//         this.isMouseDown = false;
//     }
//     /**
//      * 向前移动。
//      * @param distance 移动距离。
//      */
//     public moveForward(distance:number):void {
//         this._tempVector3.x = this._tempVector3.y = 0;
//         this._tempVector3.z = distance;
//         this.camera.transform.translate(this._tempVector3);
//     }
//     /**
//      * 向右移动。
//      * @param distance 移动距离。
//      */
//     public moveRight(distance:number):void {
//         this._tempVector3.y = this._tempVector3.z = 0;
//         this._tempVector3.x = distance;
//         this.camera.transform.translate(this._tempVector3);
//     }
//     /**
//      * 向上移动。
//      * @param distance 移动距离。
//      */
//     public moveVertical(distance:number):void {
//         this._tempVector3.x = this._tempVector3.z = 0;
//         this._tempVector3.y = distance;
//         this.camera.transform.translate(this._tempVector3, false);
//     }
//     static init() {
//         Laya.ClassUtils.regClass("CameraMoveScript", CameraMoveScript);
//     }
// }


/***/ }),

/***/ "./src/core/engine/threejs/ThreeJSEngineHolder.ts":
/*!********************************************************!*\
  !*** ./src/core/engine/threejs/ThreeJSEngineHolder.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThreeJSEngineHolder: () => (/* binding */ ThreeJSEngineHolder)
/* harmony export */ });
class ThreeJSEngineHolder {
    constructor() {
        this.name = 'ThreeJS';
        this.isTreeDirty = true;
    }
    init() {
    }
    /**
     * 检测当前环境是否存在ThreeJS引擎
     */
    isCurrentEngine() {
        return typeof window.THREE !== 'undefined';
    }
    /**
     * 获取ThreeJS引擎版本
     */
    getEngineVersion() {
        if (!this.isCurrentEngine())
            return undefined;
        const THREE = window.THREE;
        return THREE.REVISION || undefined;
    }
    getTreeNode(node) {
        return node;
    }
    getStage() {
        return null;
    }
    refreshTree() {
        // 刷新完成后，重置脏标记
        this.isTreeDirty = false;
        return null;
    }
    getNodeProperty(exId) {
        return null;
    }
    getOrCreatePropStructure(obj, showPrivate, showFunction) {
        return null;
    }
    setTimeScale(timeScale) {
        // 如果传递 -1，表示获取当前值而不是设置
        if (timeScale === -1) {
            // ThreeJS 没有内置的 timeScale 概念，返回默认值 1
            return 1;
        }
        // 限制在0-50之间（与UI控件的限制一致）
        if (timeScale < 0) {
            timeScale = 0;
        }
        else if (timeScale > 50) {
            timeScale = 50;
        }
        // TODO: 实现 ThreeJS 的时间缩放功能
        // 当前仅返回设置的值，实际的时间缩放功能需要在具体的游戏逻辑中实现
        return timeScale;
    }
    nextFrame() {
        // TODO: 实现 ThreeJS 的下一帧功能
        // 当前ThreeJS支持还不完整，暂时只是记录日志
        console.log('ThreeJS nextFrame() called - not implemented yet');
    }
    getNodeMemoryStroge(exId) {
        return null;
    }
    getAllProps(obj, showPrivate, showFunction) {
        return null;
    }
    setNodeProperty(exId, componentType, propertyName, value) {
        return false;
    }
    deleteNode(exId) {
        // TODO: 实现ThreeJS的节点删除功能
        // 当前ThreeJS支持还不完整，返回false
        return false;
    }
    initProxy() {
    }
    setTreeDirty(isDirty) {
        this.isTreeDirty = isDirty;
    }
}


/***/ }),

/***/ "./src/core/message/BaseMessage.ts":
/*!*****************************************!*\
  !*** ./src/core/message/BaseMessage.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseMessage: () => (/* binding */ BaseMessage)
/* harmony export */ });
class BaseMessage {
    constructor(from, onMessage, thisObj, name) {
        this._from = from;
        this._name = name || this._from;
        this._thisObj = thisObj;
        this._onMessage = onMessage;
    }
    init() { }
}


/***/ }),

/***/ "./src/core/message/ChromeConnectMessage.ts":
/*!**************************************************!*\
  !*** ./src/core/message/ChromeConnectMessage.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChromeConnectMessage: () => (/* binding */ ChromeConnectMessage)
/* harmony export */ });
/* harmony import */ var _BaseMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMessage */ "./src/core/message/BaseMessage.ts");
/* harmony import */ var _Constant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Constant */ "./src/core/Constant.ts");
/// <reference types="chrome"/>


class ChromeConnectMessage extends _BaseMessage__WEBPACK_IMPORTED_MODULE_0__.BaseMessage {
    constructor(from, onMessage, thisObj, name) {
        super(from, onMessage, thisObj, name);
        this._port = null;
        this._isConnected = false;
        this._reconnectAttempts = 0;
        this.MAX_RECONNECT_ATTEMPTS = 3;
        this.init();
        this.initListener();
    }
    init() { }
    initListener() {
        if (typeof chrome !== 'undefined' && chrome.runtime) {
            try {
                this._port = chrome.runtime.connect({ name: this._name });
                this._isConnected = true;
                this._reconnectAttempts = 0;
                // 监听连接断开
                this._port.onDisconnect.addListener(() => {
                    _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('Chrome port 连接断开');
                    this._isConnected = false;
                    this._port = null;
                    // 尝试重新连接
                    if (this._reconnectAttempts < this.MAX_RECONNECT_ATTEMPTS) {
                        setTimeout(() => {
                            this._reconnectAttempts++;
                            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log(`尝试重新连接 (${this._reconnectAttempts}/${this.MAX_RECONNECT_ATTEMPTS})`);
                            this.initListener();
                        }, 1000 * this._reconnectAttempts); // 递增延迟
                    }
                    else {
                        _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('Chrome port 重连失败，已达到最大重试次数');
                    }
                });
                this._port.onMessage.addListener((message, port) => {
                    // 移除频繁的消息接收日志
                    if (!(message.data && message.data.from === this._from)) {
                        this._onMessage.call(this._thisObj, message);
                    }
                });
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('Chrome port 连接成功');
            }
            catch (error) {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('Game Inspect 链接失败', error);
                this._isConnected = false;
                this._port = null;
            }
        }
    }
    post(type, data) {
        if (!this._port || !this._isConnected) {
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.warn('Chrome port 未连接，尝试重新连接');
            this.initListener();
            return;
        }
        let message;
        let hasError = false;
        if (typeof type === 'string') {
            message = {
                from: this._from,
                name: this._name,
                type: type,
                data: data
            };
        }
        else {
            message = type;
        }
        try {
            // 检查 chrome.runtime.lastError
            if (chrome.runtime.lastError) {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('Chrome runtime 错误:', chrome.runtime.lastError);
                hasError = true;
            }
            else {
                this._port.postMessage(message);
                // 移除频繁的消息发送日志
            }
        }
        catch (error) {
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('发送消息失败:', error);
            hasError = true;
        }
        if (hasError) {
            this._isConnected = false;
            this._port = null;
            // 尝试重新建立连接
            if (this._reconnectAttempts < this.MAX_RECONNECT_ATTEMPTS) {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('消息发送失败，尝试重新连接...');
                this.initListener();
                // 延迟重试发送消息
                setTimeout(() => {
                    if (this._port && this._isConnected) {
                        try {
                            this._port.postMessage(message);
                        }
                        catch (retryError) {
                            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('重试发送消息失败:', retryError);
                        }
                    }
                }, 500);
            }
            else {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('无法发送消息：连接失败且已达到最大重试次数');
            }
        }
    }
    isConnected() {
        return this._isConnected && this._port !== null;
    }
    disconnect() {
        if (this._port) {
            try {
                this._port.disconnect();
            }
            catch (error) {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('断开连接时出错:', error);
            }
        }
        this._isConnected = false;
        this._port = null;
        this._reconnectAttempts = 0;
    }
}


/***/ }),

/***/ "./src/core/message/Event.ts":
/*!***********************************!*\
  !*** ./src/core/message/Event.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EventType: () => (/* binding */ EventType),
/* harmony export */   isHeartbeat: () => (/* binding */ isHeartbeat)
/* harmony export */ });
// 事件类枚举
var EventType;
(function (EventType) {
    EventType["ENGINE_INIT"] = "engineInit";
    EventType["ENGINE_TREE_REFRESH"] = "engineTreeRefresh";
    // 请求刷新节点树
    EventType["REQUEST_REFRESH_TREE"] = "requestRefreshTree";
    // 心跳包相关
    EventType["HEARTBEAT_PING"] = "heartbeatPing";
    EventType["HEARTBEAT_PONG"] = "heartbeatPong";
    // 连接状态检查
    EventType["CONNECTION_CHECK"] = "connectionCheck";
    EventType["CONNECTION_STATUS"] = "connectionStatus";
    // 请求设置TimeScale
    EventType["REQUEST_SET_TIME_SCALE"] = "requestSetTimeScale";
    // 响应设置TimeScale
    EventType["RESPONSE_SET_TIME_SCALE"] = "responseSetTimeScale";
    // 请求下一帧
    EventType["REQUEST_NEXT_FRAME"] = "requestNextFrame";
    // 请求节点属性
    EventType["REQUEST_NODE_PROPERTY"] = "requestNodeProperty";
    // 响应节点属性
    EventType["RESPONSE_NODE_PROPERTY"] = "responseNodeProperty";
    // 设置节点属性
    EventType["SET_NODE_PROPERTY"] = "setNodeProperty";
    // 响应设置节点属性
    EventType["RESPONSE_SET_NODE_PROPERTY"] = "responseSetNodeProperty";
    // 引擎状态响应
    EventType["ENGINE_STATUS_RESPONSE"] = "engineStatusResponse";
    // 引擎状态检查
    EventType["ENGINE_STATUS_CHECK"] = "engineStatusCheck";
    // 输出节点信息到控制台
    EventType["OUTPUT_NODE_TO_CONSOLE"] = "outputNodeToConsole";
    // 输出节点信息到控制台组件
    EventType["OUTPUT_NODE_TO_CONSOLE_COMPONENT"] = "OUTPUT_NODE_TO_CONSOLE_COMPONENT";
    // 删除节点
    EventType["DELETE_NODE"] = "deleteNode";
    // 设置显示选择框
    EventType["SET_SHOW_SEL_BOX"] = "setShowSelBox";
    // WebSocket服务器连接/断开
    EventType["TOGGLE_WEBSOCKET_SERVER"] = "toggleWebsocketServer";
    // GPU能耗相关
    EventType["REQUEST_GPU_ENERGY_REPORT"] = "requestGpuEnergyReport";
    EventType["GPU_ENERGY_REPORT"] = "gpuEnergyReport";
    // 性能数据
    EventType["PERFORMANCE_DATA"] = "performanceData";
    // WEBGLHOOK相关消息
    EventType["WEBGLHOOK_START_REQUEST"] = "WEBGLHOOK_START_REQUEST";
    EventType["WEBGLHOOK_START_RESPONSE"] = "WEBGLHOOK_START_RESPONSE";
    EventType["WEBGLHOOK_STOP_REQUEST"] = "WEBGLHOOK_STOP_REQUEST";
    EventType["WEBGLHOOK_STOP_RESPONSE"] = "WEBGLHOOK_STOP_RESPONSE";
    EventType["WEBGLHOOK_GET_APICALL_REQUEST"] = "WEBGLHOOK_GET_APICALL_REQUEST";
    EventType["WEBGLHOOK_GET_APICALL_RESPONSE"] = "WEBGLHOOK_GET_APICALL_RESPONSE";
    // VConsole相关消息
    EventType["EVAL_REQUEST"] = "EVAL_REQUEST";
    EventType["EVAL_RESPONSE"] = "EVAL_RESPONSE";
    EventType["VCONSOLE_LOG_START"] = "VCONSOLE_LOG_START";
    EventType["VCONSOLE_LOG_END"] = "VCONSOLE_LOG_END";
    EventType["VCONSOLE_LOG_MESSAGE"] = "VCONSOLE_LOG_MESSAGE";
})(EventType || (EventType = {}));
function isHeartbeat(type) {
    return type == EventType.HEARTBEAT_PING || type == EventType.HEARTBEAT_PONG || type == EventType.CONNECTION_CHECK || type == EventType.CONNECTION_STATUS;
}


/***/ }),

/***/ "./src/core/message/Message.ts":
/*!*************************************!*\
  !*** ./src/core/message/Message.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Message: () => (/* binding */ Message)
/* harmony export */ });
/* harmony import */ var _ChromeConnectMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ChromeConnectMessage */ "./src/core/message/ChromeConnectMessage.ts");
/* harmony import */ var _WindowMessage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./WindowMessage */ "./src/core/message/WindowMessage.ts");


class Message {
    static getMessage(from, onMessage, thisObj, name) {
        const MessageClass = this.getMessageClsByType(from);
        return new MessageClass(from, onMessage, thisObj, name);
    }
    static getMessageClsByType(type) {
        switch (type) {
            case 'DevPanel':
            case 'contentChrome':
            case 'background':
                return _ChromeConnectMessage__WEBPACK_IMPORTED_MODULE_0__.ChromeConnectMessage;
            case 'Stage':
            case 'contentWindow':
                return _WindowMessage__WEBPACK_IMPORTED_MODULE_1__.WindowMessage;
            default:
                throw new Error(`Unknown message type: ${type}`);
        }
    }
}


/***/ }),

/***/ "./src/core/message/WindowMessage.ts":
/*!*******************************************!*\
  !*** ./src/core/message/WindowMessage.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   WindowMessage: () => (/* binding */ WindowMessage)
/* harmony export */ });
/* harmony import */ var _BaseMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMessage */ "./src/core/message/BaseMessage.ts");
/* harmony import */ var _Constant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Constant */ "./src/core/Constant.ts");


class WindowMessage extends _BaseMessage__WEBPACK_IMPORTED_MODULE_0__.BaseMessage {
    constructor(from, onMessage, thisObj, name) {
        super(from, onMessage, thisObj, name);
        this.init();
        this.initListener();
    }
    init() { }
    initListener() {
        window.addEventListener('message', (event) => {
            // 忽略自己发送的消息
            if (event.data && event.data.from === this._from) {
                return;
            }
            // 只处理有效的消息格式
            if (!event.data || typeof event.data !== 'object') {
                return;
            }
            if (_Constant__WEBPACK_IMPORTED_MODULE_1__.Constant.DEBUG) {
                // Logger.log(this._from + '收到消息', event);
            }
            if (this._onMessage) {
                this._onMessage.call(this._thisObj, event.data);
            }
        });
    }
    post(type, data) {
        let message;
        if (typeof type === 'string') {
            message = {
                from: this._from,
                name: this._name,
                type: type,
                data: data
            };
        }
        else {
            message = type;
        }
        window.postMessage(message, '*');
    }
}


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!***************************!*\
  !*** ./src/core/index.ts ***!
  \***************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Inspector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Inspector */ "./src/core/Inspector.ts");
/* harmony import */ var _Constant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Constant */ "./src/core/Constant.ts");
/* harmony import */ var _engine_EngineProvider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./engine/EngineProvider */ "./src/core/engine/EngineProvider.ts");



// 初始化核心模块
_Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('LayaTree Core 模块已加载');
// 暴露到全局作用域
window.LayaTreeCore = {
    Inspector: _Inspector__WEBPACK_IMPORTED_MODULE_0__.Inspector,
    Constant: _Constant__WEBPACK_IMPORTED_MODULE_1__.Constant,
    Logger: _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger,
    EngineProvider: _engine_EngineProvider__WEBPACK_IMPORTED_MODULE_2__.EngineProvider,
};
// 初始化Inspector
const inspector = new _Inspector__WEBPACK_IMPORTED_MODULE_0__.Inspector();
_Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('LayaTree Core 初始化完成');

})();

/******/ })()
;
//# sourceMappingURL=index.js.map