/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/core/Constant.ts":
/*!******************************!*\
  !*** ./src/core/Constant.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Constant: () => (/* binding */ Constant),
/* harmony export */   Logger: () => (/* binding */ Logger)
/* harmony export */ });
const Constant = {
    DEBUG: false,
    VERSION: '2.0.0',
    NAME: 'LayaTree',
    SCRITP_NAMES: "scriptInject",
    DEBUG_LAYER_NAME: "LayaTreeDebugLayer",
    // API配置
    API_CONFIG: {
        VERSION_CHECK_URL: 'http://womenzhai.cn:8066/updateInfo',
        ANALYTICS_URL: 'devtools/utils/baidu_tongji.js'
    }
};
/**
 * 日志工具类，根据 DEBUG 常量决定是否输出日志
 */
class Logger {
    /**
     * 普通日志输出
     * @param args 要输出的参数
     */
    static log(...args) {
        if (Constant.DEBUG) {
            console.log('[LayaTree]', ...args);
        }
    }
    /**
     * 警告日志输出
     * @param args 要输出的参数
     */
    static warn(...args) {
        if (Constant.DEBUG) {
            console.warn('[LayaTree]', ...args);
        }
    }
    /**
     * 错误日志输出
     * @param args 要输出的参数
     */
    static error(...args) {
        if (Constant.DEBUG) {
            console.error('[LayaTree]', ...args);
        }
    }
    /**
     * 信息日志输出
     * @param args 要输出的参数
     */
    static info(...args) {
        if (Constant.DEBUG) {
            console.info('[LayaTree]', ...args);
        }
    }
}


/***/ }),

/***/ "./src/core/message/BaseMessage.ts":
/*!*****************************************!*\
  !*** ./src/core/message/BaseMessage.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseMessage: () => (/* binding */ BaseMessage)
/* harmony export */ });
class BaseMessage {
    constructor(from, onMessage, thisObj, name) {
        this._from = from;
        this._name = name || this._from;
        this._thisObj = thisObj;
        this._onMessage = onMessage;
    }
    init() { }
}


/***/ }),

/***/ "./src/core/message/ChromeConnectMessage.ts":
/*!**************************************************!*\
  !*** ./src/core/message/ChromeConnectMessage.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChromeConnectMessage: () => (/* binding */ ChromeConnectMessage)
/* harmony export */ });
/* harmony import */ var _BaseMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMessage */ "./src/core/message/BaseMessage.ts");
/* harmony import */ var _Constant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Constant */ "./src/core/Constant.ts");
/// <reference types="chrome"/>


class ChromeConnectMessage extends _BaseMessage__WEBPACK_IMPORTED_MODULE_0__.BaseMessage {
    constructor(from, onMessage, thisObj, name) {
        super(from, onMessage, thisObj, name);
        this._port = null;
        this._isConnected = false;
        this._reconnectAttempts = 0;
        this.MAX_RECONNECT_ATTEMPTS = 3;
        this.init();
        this.initListener();
    }
    init() { }
    initListener() {
        if (typeof chrome !== 'undefined' && chrome.runtime) {
            try {
                this._port = chrome.runtime.connect({ name: this._name });
                this._isConnected = true;
                this._reconnectAttempts = 0;
                // 监听连接断开
                this._port.onDisconnect.addListener(() => {
                    _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('Chrome port 连接断开');
                    this._isConnected = false;
                    this._port = null;
                    // 尝试重新连接
                    if (this._reconnectAttempts < this.MAX_RECONNECT_ATTEMPTS) {
                        setTimeout(() => {
                            this._reconnectAttempts++;
                            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log(`尝试重新连接 (${this._reconnectAttempts}/${this.MAX_RECONNECT_ATTEMPTS})`);
                            this.initListener();
                        }, 1000 * this._reconnectAttempts); // 递增延迟
                    }
                    else {
                        _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('Chrome port 重连失败，已达到最大重试次数');
                    }
                });
                this._port.onMessage.addListener((message, port) => {
                    // 移除频繁的消息接收日志
                    if (!(message.data && message.data.from === this._from)) {
                        this._onMessage.call(this._thisObj, message);
                    }
                });
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('Chrome port 连接成功');
            }
            catch (error) {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('Game Inspect 链接失败', error);
                this._isConnected = false;
                this._port = null;
            }
        }
    }
    post(type, data) {
        if (!this._port || !this._isConnected) {
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.warn('Chrome port 未连接，尝试重新连接');
            this.initListener();
            return;
        }
        let message;
        let hasError = false;
        if (typeof type === 'string') {
            message = {
                from: this._from,
                name: this._name,
                type: type,
                data: data
            };
        }
        else {
            message = type;
        }
        try {
            // 检查 chrome.runtime.lastError
            if (chrome.runtime.lastError) {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('Chrome runtime 错误:', chrome.runtime.lastError);
                hasError = true;
            }
            else {
                this._port.postMessage(message);
                // 移除频繁的消息发送日志
            }
        }
        catch (error) {
            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('发送消息失败:', error);
            hasError = true;
        }
        if (hasError) {
            this._isConnected = false;
            this._port = null;
            // 尝试重新建立连接
            if (this._reconnectAttempts < this.MAX_RECONNECT_ATTEMPTS) {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.log('消息发送失败，尝试重新连接...');
                this.initListener();
                // 延迟重试发送消息
                setTimeout(() => {
                    if (this._port && this._isConnected) {
                        try {
                            this._port.postMessage(message);
                        }
                        catch (retryError) {
                            _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('重试发送消息失败:', retryError);
                        }
                    }
                }, 500);
            }
            else {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('无法发送消息：连接失败且已达到最大重试次数');
            }
        }
    }
    isConnected() {
        return this._isConnected && this._port !== null;
    }
    disconnect() {
        if (this._port) {
            try {
                this._port.disconnect();
            }
            catch (error) {
                _Constant__WEBPACK_IMPORTED_MODULE_1__.Logger.error('断开连接时出错:', error);
            }
        }
        this._isConnected = false;
        this._port = null;
        this._reconnectAttempts = 0;
    }
}


/***/ }),

/***/ "./src/core/message/Message.ts":
/*!*************************************!*\
  !*** ./src/core/message/Message.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Message: () => (/* binding */ Message)
/* harmony export */ });
/* harmony import */ var _ChromeConnectMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ChromeConnectMessage */ "./src/core/message/ChromeConnectMessage.ts");
/* harmony import */ var _WindowMessage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./WindowMessage */ "./src/core/message/WindowMessage.ts");


class Message {
    static getMessage(from, onMessage, thisObj, name) {
        const MessageClass = this.getMessageClsByType(from);
        return new MessageClass(from, onMessage, thisObj, name);
    }
    static getMessageClsByType(type) {
        switch (type) {
            case 'DevPanel':
            case 'contentChrome':
            case 'background':
                return _ChromeConnectMessage__WEBPACK_IMPORTED_MODULE_0__.ChromeConnectMessage;
            case 'Stage':
            case 'contentWindow':
                return _WindowMessage__WEBPACK_IMPORTED_MODULE_1__.WindowMessage;
            default:
                throw new Error(`Unknown message type: ${type}`);
        }
    }
}


/***/ }),

/***/ "./src/core/message/WindowMessage.ts":
/*!*******************************************!*\
  !*** ./src/core/message/WindowMessage.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   WindowMessage: () => (/* binding */ WindowMessage)
/* harmony export */ });
/* harmony import */ var _BaseMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMessage */ "./src/core/message/BaseMessage.ts");
/* harmony import */ var _Constant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Constant */ "./src/core/Constant.ts");


class WindowMessage extends _BaseMessage__WEBPACK_IMPORTED_MODULE_0__.BaseMessage {
    constructor(from, onMessage, thisObj, name) {
        super(from, onMessage, thisObj, name);
        this.init();
        this.initListener();
    }
    init() { }
    initListener() {
        window.addEventListener('message', (event) => {
            // 忽略自己发送的消息
            if (event.data && event.data.from === this._from) {
                return;
            }
            // 只处理有效的消息格式
            if (!event.data || typeof event.data !== 'object') {
                return;
            }
            if (_Constant__WEBPACK_IMPORTED_MODULE_1__.Constant.DEBUG) {
                // Logger.log(this._from + '收到消息', event);
            }
            if (this._onMessage) {
                this._onMessage.call(this._thisObj, event.data);
            }
        });
    }
    post(type, data) {
        let message;
        if (typeof type === 'string') {
            message = {
                from: this._from,
                name: this._name,
                type: type,
                data: data
            };
        }
        else {
            message = type;
        }
        window.postMessage(message, '*');
    }
}


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!******************************!*\
  !*** ./src/content/index.ts ***!
  \******************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_message_Message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/message/Message */ "./src/core/message/Message.ts");
/* harmony import */ var _core_Constant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/Constant */ "./src/core/Constant.ts");


class ContentScript {
    start() {
        ContentScript.UUID++;
        this.winMsg = _core_message_Message__WEBPACK_IMPORTED_MODULE_0__.Message.getMessage('contentWindow', this.handleRecvWindowMessage, this);
        this.chromeMsg = _core_message_Message__WEBPACK_IMPORTED_MODULE_0__.Message.getMessage('contentChrome', this.handleRecvChromeMessage, this, 'contentChrome' + ContentScript.UUID + Date.now() + Math.floor(Math.random() * 1000000));
        window.setTimeout(() => {
            this.injectJSCode();
        }, 200);
    }
    handleRecvWindowMessage(message) {
        // 移除频繁的消息接收日志
        if (message.type) {
            this.chromeMsg.post(message);
        }
    }
    handleRecvChromeMessage(message) {
        // 移除频繁的消息接收日志
        if (message.type) {
            this.winMsg.post(message);
        }
    }
    addScript(code, id) {
        const existingScript = document.getElementById(id);
        if (existingScript) {
            document.head.removeChild(existingScript);
        }
        const script = document.createElement('script');
        script.innerHTML = code;
        script.id = id;
        document.head.appendChild(script);
    }
    addScriptByUrl(url, callback, context) {
        if (typeof chrome !== 'undefined' && chrome.runtime) {
            url = chrome.runtime.getURL(url);
        }
        const script = document.createElement('script');
        script.src = url;
        script.onload = () => {
            if (callback) {
                callback.call(context);
            }
        };
        document.head.appendChild(script);
    }
    injectJSCode() {
        this.addScriptByUrl('core/index.js', () => {
            this.checkCode();
        }, this);
    }
    checkCode() {
        if (typeof chrome !== 'undefined' && chrome.storage) {
            chrome.storage.local.get(_core_Constant__WEBPACK_IMPORTED_MODULE_1__.Constant.SCRITP_NAMES)
                .then((result) => {
                if (result && result[_core_Constant__WEBPACK_IMPORTED_MODULE_1__.Constant.SCRITP_NAMES]) {
                    const scriptNames = result[_core_Constant__WEBPACK_IMPORTED_MODULE_1__.Constant.SCRITP_NAMES];
                    if (scriptNames) {
                        this.winMsg.post('initUserCode', scriptNames);
                    }
                }
            });
        }
    }
}
ContentScript.UUID = 0;
// 启动content script
new ContentScript().start();

})();

/******/ })()
;
//# sourceMappingURL=index.js.map