/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/*!*********************************!*\
  !*** ./src/background/index.ts ***!
  \*********************************/

// 在开发模式下导入热重载脚本
if (false) {}
// 使用明确的类型声明
const devPanelPorts = {};
const contentScriptPorts = {};
// 添加错误处理函数
const handlePortError = (port, error) => {
    console.error(`Port 错误 (${port.name}):`, error);
    // 检查是否是 Extension context invalidated 错误
    if (error && error.message && error.message.includes('Extension context invalidated')) {
        console.warn('检测到 Extension context invalidated 错误，清理无效连接');
        // 清理所有相关连接
        Object.keys(devPanelPorts).forEach(key => {
            if (devPanelPorts[key] === port) {
                delete devPanelPorts[key];
                console.log(`已清理 DevPanel port: ${key}`);
            }
        });
        Object.keys(contentScriptPorts).forEach(key => {
            if (contentScriptPorts[key] === port) {
                delete contentScriptPorts[key];
                console.log(`已清理 ContentScript port: ${key}`);
            }
        });
    }
};
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
    var _a, _b;
    try {
        if (message.type === "devPanelStateChange") {
            const tabId = message.data.tabId;
            // 向所有相关的 DevPanel 发送消息
            for (const portName in devPanelPorts) {
                const port = devPanelPorts[portName];
                if (port.name === "DevPanel" + tabId) {
                    try {
                        port.postMessage(message);
                    }
                    catch (error) {
                        handlePortError(port, error);
                    }
                }
            }
            // 向所有相关的 ContentScript 发送消息
            for (const portName in contentScriptPorts) {
                const port = contentScriptPorts[portName];
                const senderTabId = (_b = (_a = port.sender) === null || _a === void 0 ? void 0 : _a.tab) === null || _b === void 0 ? void 0 : _b.id;
                if (senderTabId === tabId) {
                    try {
                        port.postMessage(message);
                    }
                    catch (error) {
                        handlePortError(port, error);
                    }
                }
            }
            return true;
        }
    }
    catch (error) {
        console.error('处理消息时出错:', error);
    }
});
chrome.runtime.onConnect.addListener((port) => {
    var _a, _b;
    const devPanelPrefix = "DevPanel";
    const contentChromePrefix = "contentChrome";
    let targetTabId = 0;
    let currentPorts;
    let targetPorts;
    if (port.name.indexOf(devPanelPrefix) === 0) {
        // DevPanel 连接
        currentPorts = devPanelPorts;
        targetPorts = contentScriptPorts;
        targetTabId = parseInt(port.name.replace(devPanelPrefix, ""), 10);
    }
    else if (port.name.indexOf(contentChromePrefix) === 0) {
        // ContentScript 连接
        currentPorts = contentScriptPorts;
        targetPorts = devPanelPorts;
        targetTabId = ((_b = (_a = port.sender) === null || _a === void 0 ? void 0 : _a.tab) === null || _b === void 0 ? void 0 : _b.id) || 0;
    }
    else {
        console.log("不是合法的port.name: " + port.name);
        return;
    }
    // 保存连接
    currentPorts[port.name] = port;
    console.log(`新的连接建立: ${port.name} (Tab ID: ${targetTabId})`);
    // 监听消息
    port.onMessage.addListener((message, messagePort) => {
        var _a, _b, _c, _d;
        try {
            for (const portName in targetPorts) {
                const targetPort = targetPorts[portName];
                let targetPortTabId = 0;
                if (targetPort.name.indexOf(devPanelPrefix) === 0) {
                    // 目标是 DevPanel
                    targetPortTabId = parseInt(targetPort.name.replace(devPanelPrefix, ""), 10);
                    message.frameId = (_a = messagePort.sender) === null || _a === void 0 ? void 0 : _a.frameId;
                }
                else if (targetPort.name.indexOf(contentChromePrefix) === 0) {
                    // 目标是 ContentScript
                    targetPortTabId = ((_c = (_b = targetPort.sender) === null || _b === void 0 ? void 0 : _b.tab) === null || _c === void 0 ? void 0 : _c.id) || 0;
                    message.frameId = (_d = targetPort.sender) === null || _d === void 0 ? void 0 : _d.frameId;
                }
                if (targetPortTabId === targetTabId) {
                    try {
                        targetPort.postMessage(message);
                    }
                    catch (error) {
                        handlePortError(targetPort, error);
                    }
                }
            }
        }
        catch (error) {
            console.error('转发消息时出错:', error);
        }
    });
    // 监听断开连接
    port.onDisconnect.addListener(() => {
        var _a, _b;
        const url = ((_b = (_a = port.sender) === null || _a === void 0 ? void 0 : _a.tab) === null || _b === void 0 ? void 0 : _b.url) || "";
        console.log("断开连接： " + port.name + " in " + url);
        // 检查 chrome.runtime.lastError
        if (chrome.runtime.lastError) {
            console.error('连接断开时出现错误:', chrome.runtime.lastError);
        }
        delete currentPorts[port.name];
    });
});
// 添加 Service Worker 生命周期监听
chrome.runtime.onStartup.addListener(() => {
    console.log('Service Worker 启动');
});
chrome.runtime.onInstalled.addListener(() => {
    console.log('扩展已安装/更新');
});
// 定期清理无效连接
setInterval(() => {
    const now = Date.now();
    // 清理 DevPanel 连接
    Object.keys(devPanelPorts).forEach(key => {
        const port = devPanelPorts[key];
        if (!port || !port.sender) {
            delete devPanelPorts[key];
            console.log(`清理无效的 DevPanel 连接: ${key}`);
        }
    });
    // 清理 ContentScript 连接
    Object.keys(contentScriptPorts).forEach(key => {
        const port = contentScriptPorts[key];
        if (!port || !port.sender) {
            delete contentScriptPorts[key];
            console.log(`清理无效的 ContentScript 连接: ${key}`);
        }
    });
}, 30000); // 每30秒清理一次

/******/ })()
;
//# sourceMappingURL=index.js.map